import BaseDashboardNotifier from "./BaseDashboardNotifier"

export default class DashboardMetabaseNotifier extends BaseDashboardNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshError").toSelf().execute((parameters) => this.element.refreshError(parameters.v));
		this.pushLinked = true;
	};
}