import ActionableNotifier from "./ActionableNotifier"

export default class SetDarkModeNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("updateMode").toSelf().execute(() => this.element.updateMode());
		this.pushLinked = true;
	};
}