import BaseDashboardRequester from "./BaseDashboardRequester"

export default class DashboardShinyRequester extends BaseDashboardRequester {
	constructor(element) {
		super(element);
	};
	showSettings = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "showSettings", s: "dashboardshiny", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	hideSettings = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "hideSettings", s: "dashboardshiny", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	saveServerScript = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "saveServerScript", s: "dashboardshiny", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	saveUiScript = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "saveUiScript", s: "dashboardshiny", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "dashboardshiny", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}