import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiDocumentEditorCollabora from "alexandria-ui-elements/src/displays/components/DocumentEditorCollabora";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DocumentEditorExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DocumentEditorExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DocumentEditorExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DocumentEditorExamplesMoldNotifier(this);
		this.requester = new DocumentEditorExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2043904322" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2043904322.a2121266209" format="autoHeight verticalExtraHeight" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2043904322.a2121266209.a_1420955825" format="h6" mode="normal" value="Collabora facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2043904322.a2121266209.a978336689" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2043904322.a2121266209.a978336689.a1047286576" format="airBottom airTop" layout="horizontal">
								<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2043904322.a2121266209.a978336689.a1047286576.a_133975125" title="Edit document" target="self" mode="Button" size="Medium">
								</UiOpenDialog>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2043904322.a2121266209.a978336689.a_148316104" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2043904322.a2121266209.a978336689.a_148316104.a1468055355" mode="normal" language="Html" value="DocumentEditor as Collabora(editorUrl=&quot;&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1132056414" format="noAir" title="Edit document" fullscreen={true}>
					<UiDocumentEditorCollabora context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1132056414.a_721653460" editorUrl="https://wopi.ces.siani.es/browser/a719c0f/cool.html">
					</UiDocumentEditorCollabora>
				</UiDialog>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DocumentEditorExamplesMold));
DisplayFactory.register("DocumentEditorExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DocumentEditorExamplesMold)));