import BaseTextNotifier from "./BaseTextNotifier"

export default class TextEditableCodeNotifier extends BaseTextNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.when("refreshFocused").toSelf().execute((parameters) => this.element.refreshFocused(parameters.v));
		this.pushLinked = true;
	};
}