/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.office;

import java.io.File;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public class PdfOverlay {
    private Position position = Position.FOREGROUND;
    private final EnumMap<Target, File> documents = new EnumMap(Target.class);

    public PdfOverlay() {
    }

    public PdfOverlay(Position position) {
        this.position = position;
    }

    public PdfOverlay(File defaultOverlayDocument) {
        this(Position.FOREGROUND, defaultOverlayDocument);
    }

    public PdfOverlay(Position position, File defaultOverlayDocument) {
        this.position = position;
        this.set(Target.DEFAULT, defaultOverlayDocument);
    }

    public PdfOverlay setPosition(Position position) {
        this.position = Objects.requireNonNull(position);
        return this;
    }

    public PdfOverlay set(Target target, File document) {
        this.documents.put(target, Objects.requireNonNull(document));
        return this;
    }

    public Position position() {
        return this.position;
    }

    public Map<Target, File> documents() {
        return Collections.unmodifiableMap(this.documents);
    }

    public File get(Target target) {
        return this.documents.get((Object)target);
    }

    public static enum Position {
        FOREGROUND,
        BACKGROUND;

    }

    public static enum Target {
        DEFAULT,
        ALL_PAGES,
        FIRST_PAGE,
        LAST_PAGE,
        EVEN_PAGES,
        ODD_PAGES;

    }
}

