/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.office;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

public class PdfMetadata {
    private final PDDocumentInformation info;

    public PdfMetadata() {
        this.info = new PDDocumentInformation();
    }

    public PdfMetadata(File pdf) throws IOException {
        PDDocumentInformation info;
        try (PDDocument doc = PDDocument.load((File)pdf);){
            info = doc.getDocumentInformation();
        }
        this.info = info;
    }

    public String getCustomValue(String fieldName) {
        return this.info.getCustomMetadataValue(fieldName);
    }

    public PdfMetadata setCustomValue(String fieldName, String fieldValue) {
        this.info.setCustomMetadataValue(fieldName, fieldValue);
        return this;
    }

    public Object getPropertyStringValue(String propertyKey) {
        return this.info.getPropertyStringValue(propertyKey);
    }

    public String getTitle() {
        return this.info.getTitle();
    }

    public PdfMetadata setTitle(String title) {
        this.info.setTitle(title);
        return this;
    }

    public String getAuthor() {
        return this.info.getAuthor();
    }

    public PdfMetadata setAuthor(String author) {
        this.info.setAuthor(author);
        return this;
    }

    public String getSubject() {
        return this.info.getSubject();
    }

    public PdfMetadata setSubject(String subject) {
        this.info.setSubject(subject);
        return this;
    }

    public String getKeywords() {
        return this.info.getKeywords();
    }

    public PdfMetadata setKeywords(String keywords) {
        this.info.setKeywords(keywords);
        return this;
    }

    public String getCreator() {
        return this.info.getCreator();
    }

    public PdfMetadata setCreator(String creator) {
        this.info.setCreator(creator);
        return this;
    }

    public String getProducer() {
        return this.info.getProducer();
    }

    public PdfMetadata setProducer(String producer) {
        this.info.setProducer(producer);
        return this;
    }

    public Calendar getCreationDate() {
        return this.info.getCreationDate();
    }

    public PdfMetadata setCreationDate(Calendar date) {
        this.info.setCreationDate(date);
        return this;
    }

    public Calendar getModificationDate() {
        return this.info.getModificationDate();
    }

    public PdfMetadata setModificationDate(Calendar date) {
        this.info.setModificationDate(date);
        return this;
    }

    public String getTrapped() {
        return this.info.getTrapped();
    }

    public Set<String> getMetadataKeys() {
        return this.info.getMetadataKeys();
    }

    public PdfMetadata setTrapped(String value) {
        this.info.setTrapped(value);
        return this;
    }

    PDDocumentInformation info() {
        return this.info;
    }
}

