/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.tools;

import io.intino.alexandria.ollama.tools.OllamaFunction;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public class OllamaFunctionParamTypeMapper {
    public static OllamaFunction.ParamType mapToParamType(Field field) {
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            return OllamaFunctionParamTypeMapper.mapType(fieldType.getComponentType()).asCollection();
        }
        if (Collection.class.isAssignableFrom(fieldType)) {
            return OllamaFunctionParamTypeMapper.mapType(OllamaFunctionParamTypeMapper.getCollectionElementType(field)).asCollection();
        }
        return OllamaFunctionParamTypeMapper.mapType(fieldType);
    }

    private static OllamaFunction.ParamType mapType(Class<?> type) {
        if (type == String.class) {
            return OllamaFunction.ParamType.STRING;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return OllamaFunction.ParamType.INT;
        }
        if (type == Long.TYPE || type == Long.class) {
            return OllamaFunction.ParamType.LONG;
        }
        if (type == Float.TYPE || type == Float.class) {
            return OllamaFunction.ParamType.FLOAT;
        }
        if (type == Double.TYPE || type == Double.class) {
            return OllamaFunction.ParamType.DOUBLE;
        }
        if (type == Character.TYPE || type == Character.class) {
            return OllamaFunction.ParamType.CHAR;
        }
        if (type == Short.TYPE || type == Short.class) {
            return OllamaFunction.ParamType.SHORT;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return OllamaFunction.ParamType.BYTE;
        }
        throw new IllegalArgumentException("Unsupported field type: " + type.getName());
    }

    public static Class<?> getCollectionElementType(Field field) {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return (Class)typeArguments[0];
        }
        throw new IllegalArgumentException("Field is not parameterized or is not a Collection");
    }
}

