/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.tools;

import com.google.gson.annotations.SerializedName;
import io.intino.alexandria.Json;
import io.intino.alexandria.ollama.tools.OllamaFunctionParamTypeMapper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class OllamaFunction {
    private String name;
    private String description;
    private Parameters parameters = new Parameters();
    private transient Class<?> binding;

    public static OllamaFunction from(Class<?> binding) {
        OllamaFunction function = new OllamaFunction();
        function.binding(binding);
        Binding definition = binding.getAnnotation(Binding.class);
        function.name(definition.name().isBlank() ? binding.getSimpleName() : definition.name());
        function.description(definition.description());
        for (Field field : binding.getDeclaredFields()) {
            field.setAccessible(true);
            Param param = field.getAnnotation(Param.class);
            if (param == null) continue;
            String name = param.name().isBlank() ? field.getName() : param.name();
            String type = param.type().isBlank() ? OllamaFunctionParamTypeMapper.mapToParamType(field).label() : param.type();
            function.parameter(name, type, param.description(), param.required(), param.enumValues());
        }
        return function;
    }

    public OllamaFunction() {
    }

    public OllamaFunction(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public OllamaFunction(String name, String description, Parameters parameters) {
        this.name = name;
        this.description = description;
        this.parameters = parameters;
    }

    public OllamaFunction(String name, String description, Parameters parameters, Class<?> binding) {
        this.name = name;
        this.description = description;
        this.parameters = parameters;
        this.binding(binding);
    }

    public String name() {
        return this.name;
    }

    public OllamaFunction name(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public OllamaFunction description(String description) {
        this.description = description;
        return this;
    }

    public OllamaFunction parameter(String name, String type, String description) {
        return this.parameter(name, type, description, false);
    }

    public OllamaFunction parameter(String name, String type, String description, boolean required) {
        this.parameters.properties.put(name, new Parameters.Property(type, description));
        if (required) {
            this.parameters.required.add(name);
        }
        return this;
    }

    public OllamaFunction parameter(String name, String type, String description, String ... enumValues) {
        return this.parameter(name, type, description, false, enumValues);
    }

    public OllamaFunction parameter(String name, String type, String description, boolean required, String ... enumValues) {
        this.parameters.properties.put(name, new Parameters.Property(type, description, Arrays.stream(enumValues).collect(Collectors.toSet())));
        if (required) {
            this.parameters.required.add(name);
        }
        return this;
    }

    public Parameters parameters() {
        return this.parameters;
    }

    public OllamaFunction parameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public <T> Class<T> binding() {
        return this.binding;
    }

    public OllamaFunction binding(Class<?> binding) {
        if (binding != null && binding.getAnnotation(Binding.class) == null) {
            throw new IllegalArgumentException("Binding object must be annotated with OllamaFunction.Binding annotation");
        }
        this.binding = binding;
        return this;
    }

    public String toString() {
        return Json.toJson((Object)this);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Binding {
        public String name() default "";

        public String description() default "";
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Param {
        public String name() default "";

        public String type() default "";

        public String description() default "";

        public boolean required() default true;

        public String[] enumValues() default {};
    }

    public static enum ParamType {
        STRING("string"),
        INT("int"),
        LONG("long"),
        FLOAT("float"),
        DOUBLE("double"),
        CHAR("char"),
        SHORT("short"),
        BYTE("byte"),
        STRING_COLLECTION("[string]"),
        INT_COLLECTION("[int]"),
        LONG_COLLECTION("[long]"),
        FLOAT_COLLECTION("[float]"),
        DOUBLE_COLLECTION("[double]"),
        CHAR_COLLECTION("[char]"),
        SHORT_COLLECTION("[short]"),
        BYTE_COLLECTION("[byte]");

        private final String label;
        private final boolean isCollection;

        private ParamType(String label) {
            this.label = label;
            this.isCollection = label.startsWith("[");
        }

        public String label() {
            return this.label;
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public ParamType asCollection() {
            if (this.isCollection) {
                return this;
            }
            return ParamType.from("[" + this.label + "]");
        }

        public ParamType asNonArray() {
            if (!this.isCollection) {
                return this;
            }
            return ParamType.from(this.label.substring(1, this.label.length() - 1));
        }

        public static ParamType from(String nameOrLabel) {
            return Arrays.stream(ParamType.values()).filter(p -> p.name().equalsIgnoreCase(nameOrLabel) || p.label().equalsIgnoreCase(nameOrLabel)).findFirst().orElse(null);
        }
    }

    public static class Parameters {
        private String type = "object";
        private Properties properties = new Properties();
        private Set<String> required = new LinkedHashSet<String>();

        public String type() {
            return this.type;
        }

        public Parameters type(String type) {
            this.type = type;
            return this;
        }

        public Properties properties() {
            return this.properties;
        }

        public Parameters properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Set<String> required() {
            return this.required;
        }

        public Parameters required(Set<String> required) {
            this.required = required;
            return this;
        }

        public String toString() {
            return Json.toJson((Object)this);
        }

        public static class Properties
        extends LinkedHashMap<String, Property> {
        }

        public static class Property {
            private String type;
            private String description;
            @SerializedName(value="enum")
            private LinkedHashSet<String> enumValues;

            public Property() {
            }

            public Property(String type, String description) {
                this.type = type;
                this.description = description;
            }

            public Property(String type, String description, Collection<String> enumValues) {
                this.type = type;
                this.description = description;
                this.enumValues = new LinkedHashSet<String>(enumValues);
            }

            public String typeAsString() {
                return this.type;
            }

            public ParamType type() {
                return this.type == null ? null : ParamType.from(this.type);
            }

            public Property type(String type) {
                this.type = type;
                return this;
            }

            public Property type(ParamType type) {
                return this.type(type == null ? null : type.label());
            }

            public String description() {
                return this.description;
            }

            public Property description(String description) {
                this.description = description;
                return this;
            }

            public Set<String> enumValues() {
                return this.enumValues;
            }

            public Property enumValues(Collection<String> enumValues) {
                this.enumValues = new LinkedHashSet<String>(enumValues);
                return this;
            }

            public String toString() {
                return Json.toJson((Object)this);
            }
        }
    }
}

