/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.responses;

import com.google.gson.annotations.SerializedName;
import io.intino.alexandria.Json;
import io.intino.alexandria.ollama.responses.OllamaResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class OllamaPsResponse
extends OllamaResponse {
    private List<Model> models = new ArrayList<Model>();

    public OllamaPsResponse() {
    }

    public OllamaPsResponse(List<Model> models) {
        this.models = models;
    }

    public List<Model> models() {
        return this.models;
    }

    public OllamaPsResponse models(List<Model> models) {
        this.models = models;
        return this;
    }

    public static class Model {
        private String name;
        private String model;
        private long size;
        private String digest;
        private Details details;
        @SerializedName(value="expires_at")
        private String expiresAt;
        @SerializedName(value="size_vram")
        private long sizeVRAM;

        public String name() {
            return this.name;
        }

        public Model name(String name) {
            this.name = name;
            return this;
        }

        public String model() {
            return this.model;
        }

        public Model model(String model) {
            this.model = model;
            return this;
        }

        public long size() {
            return this.size;
        }

        public Model size(long size) {
            this.size = size;
            return this;
        }

        public String digest() {
            return this.digest;
        }

        public Model digest(String digest) {
            this.digest = digest;
            return this;
        }

        public Details details() {
            return this.details;
        }

        public Model details(Details details) {
            this.details = details;
            return this;
        }

        public String expiresAtStr() {
            return this.expiresAt;
        }

        public OffsetDateTime expiresAt() {
            return OffsetDateTime.parse(this.expiresAt);
        }

        public Model expiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public long sizeVRAM() {
            return this.sizeVRAM;
        }

        public Model sizeVRAM(long sizeVRAM) {
            this.sizeVRAM = sizeVRAM;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Model model1 = (Model)o;
            return this.size == model1.size && this.sizeVRAM == model1.sizeVRAM && Objects.equals(this.name, model1.name) && Objects.equals(this.model, model1.model) && Objects.equals(this.digest, model1.digest) && Objects.equals(this.details, model1.details) && Objects.equals(this.expiresAt, model1.expiresAt);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.model, this.size, this.digest, this.details, this.expiresAt, this.sizeVRAM);
        }

        public String toString() {
            return Json.toJson((Object)this);
        }

        public static class Details {
            @SerializedName(value="parent_model")
            private String parentModel;
            private String format;
            private String family;
            private String[] families;
            @SerializedName(value="parameter_size")
            private String parameterSize;
            @SerializedName(value="quantization_level")
            private String quantizationLevel;

            public String parentModel() {
                return this.parentModel;
            }

            public Details parentModel(String parentModel) {
                this.parentModel = parentModel;
                return this;
            }

            public String format() {
                return this.format;
            }

            public Details format(String format) {
                this.format = format;
                return this;
            }

            public String family() {
                return this.family;
            }

            public Details family(String family) {
                this.family = family;
                return this;
            }

            public String[] families() {
                return this.families;
            }

            public Details families(String[] families) {
                this.families = families;
                return this;
            }

            public String parameterSize() {
                return this.parameterSize;
            }

            public Details parameterSize(String parameterSize) {
                this.parameterSize = parameterSize;
                return this;
            }

            public String quantizationLevel() {
                return this.quantizationLevel;
            }

            public Details quantizationLevel(String quantizationLevel) {
                this.quantizationLevel = quantizationLevel;
                return this;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Details details = (Details)o;
                return Objects.equals(this.parentModel, details.parentModel) && Objects.equals(this.format, details.format) && Objects.equals(this.family, details.family) && Objects.deepEquals(this.families, details.families) && Objects.equals(this.parameterSize, details.parameterSize) && Objects.equals(this.quantizationLevel, details.quantizationLevel);
            }

            public int hashCode() {
                return Objects.hash(this.parentModel, this.format, this.family, Arrays.hashCode(this.families), this.parameterSize, this.quantizationLevel);
            }

            public String toString() {
                return Json.toJson((Object)this);
            }
        }
    }
}

