/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ollama.responses;

import com.google.gson.annotations.SerializedName;
import io.intino.alexandria.ollama.OllamaMessage;
import io.intino.alexandria.ollama.responses.OllamaResponse;
import java.time.OffsetDateTime;

public class OllamaChatResponse
extends OllamaResponse {
    private String model;
    @SerializedName(value="created_at")
    private String createdAt;
    private OllamaMessage message;
    private boolean done;
    @SerializedName(value="done_reason")
    private String doneReason;
    @SerializedName(value="total_duration")
    private long totalDuration;
    @SerializedName(value="load_duration")
    private long loadDuration;
    @SerializedName(value="prompt_eval_count")
    private long promptEvalCount;
    @SerializedName(value="prompt_eval_duration")
    private long promptEvalDuration;
    @SerializedName(value="eval_count")
    private long evalCount;
    @SerializedName(value="eval_duration")
    private long evalDuration;

    public String model() {
        return this.model;
    }

    public OllamaChatResponse model(String model) {
        this.model = model;
        return this;
    }

    public String createdAtStr() {
        return this.createdAt;
    }

    public OffsetDateTime createdAt() {
        return OffsetDateTime.parse(this.createdAt);
    }

    public OllamaChatResponse createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String text() {
        return this.message == null || this.message.content() == null ? null : this.message.content();
    }

    public OllamaMessage message() {
        return this.message;
    }

    public OllamaChatResponse message(OllamaMessage message) {
        this.message = message;
        return this;
    }

    public boolean done() {
        return this.done;
    }

    public OllamaChatResponse done(boolean done) {
        this.done = done;
        return this;
    }

    public String doneReason() {
        return this.doneReason;
    }

    public OllamaChatResponse doneReason(String doneReason) {
        this.doneReason = doneReason;
        return this;
    }

    public long totalDuration() {
        return this.totalDuration;
    }

    public OllamaChatResponse totalDuration(long totalDuration) {
        this.totalDuration = totalDuration;
        return this;
    }

    public long loadDuration() {
        return this.loadDuration;
    }

    public OllamaChatResponse loadDuration(long loadDuration) {
        this.loadDuration = loadDuration;
        return this;
    }

    public long promptEvalCount() {
        return this.promptEvalCount;
    }

    public OllamaChatResponse promptEvalCount(long promptEvalCount) {
        this.promptEvalCount = promptEvalCount;
        return this;
    }

    public long promptEvalDuration() {
        return this.promptEvalDuration;
    }

    public OllamaChatResponse promptEvalDuration(long promptEvalDuration) {
        this.promptEvalDuration = promptEvalDuration;
        return this;
    }

    public long evalCount() {
        return this.evalCount;
    }

    public OllamaChatResponse evalCount(long evalCount) {
        this.evalCount = evalCount;
        return this;
    }

    public long evalDuration() {
        return this.evalDuration;
    }

    public OllamaChatResponse evalDuration(long evalDuration) {
        this.evalDuration = evalDuration;
        return this;
    }

    public float tokensPerSecond() {
        return (float)this.evalCount / (float)this.evalDuration * 1.0E9f;
    }
}

