/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.dsl.rules;

import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.rules.MogramRule;
import java.util.List;

public class CheckFileParameter
implements MogramRule {
    private Cause cause;

    public boolean accept(Mogram mogram2) {
        List<Mogram> list = mogram2.components().stream().filter(mogram -> this.isParameter((Mogram)mogram) && mogram.appliedFacets().stream().anyMatch(facet -> facet.type().equals("File"))).toList();
        if (!(list.isEmpty() || this.parameterInForm(list.get(0)) || this.parameterInBody(list.get(0)))) {
            this.cause = Cause.FileParameterNotInForm;
            return false;
        }
        return true;
    }

    public String errorMessage() {
        return this.cause.message;
    }

    private boolean isParameter(Mogram mogram) {
        return mogram.type().equals("Service.REST.Resource.Parameter");
    }

    private boolean parameterInForm(Mogram mogram) {
        return "form".equals(this.parameter(mogram, "in").values().get(0).toString());
    }

    private boolean parameterInBody(Mogram mogram) {
        return "body".equals(this.parameter(mogram, "in").values().get(0).toString());
    }

    private Parameter parameter(Mogram mogram, String string) {
        return mogram.parameters().stream().filter(parameter -> parameter.name().equals(string)).findFirst().orElse(null);
    }

    private static enum Cause {
        FileParameterNotInForm("File parameters only can be added in form");

        private final String message;

        private Cause(String string2) {
            this.message = string2;
        }
    }
}

