/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.dsl.rules;

import io.intino.tara.language.model.EmptyMogram;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.rules.MogramRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CheckPath
implements MogramRule {
    private Cause cause;

    public boolean accept(Mogram mogram) {
        return !this.pathIsWrong(mogram);
    }

    private boolean pathIsWrong(Mogram mogram) {
        if (this.parameter(mogram, "path") == null) {
            return false;
        }
        if (this.parameter(mogram, "path").values().get(0) instanceof EmptyMogram) {
            this.cause = Cause.NullPath;
            return true;
        }
        return this.pathIsWrong((String)this.parameter(mogram, "path").values().get(0), mogram);
    }

    private boolean pathIsWrong(String string2, Mogram mogram) {
        if (mogram == null) {
            return false;
        }
        List list = Arrays.stream(string2.split("/")).filter(string -> string.startsWith(":")).map(string -> string.substring(1)).collect(Collectors.toList());
        List<String> list2 = this.pathParametersFromMogram(mogram);
        list2.addAll(this.pathParametersInMethods(mogram.components()));
        for (String string3 : list) {
            if (list2.contains(string3)) continue;
            this.cause = Cause.ParameterNotDeclared;
            return true;
        }
        for (String string3 : list2) {
            if (list.contains(string3)) continue;
            this.cause = Cause.ParameterNotInPath;
            return true;
        }
        return false;
    }

    private List<String> pathParametersFromMogram(Mogram mogram2) {
        return mogram2.components().stream().filter(mogram -> this.isParameter((Mogram)mogram) && this.parameterIsInPath((Mogram)mogram)).map(Mogram::name).collect(Collectors.toList());
    }

    private List<String> pathParametersInMethods(List<Mogram> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Mogram mogram : list) {
            arrayList.addAll(this.pathParametersFromMogram(mogram));
        }
        return arrayList;
    }

    private boolean parameterIsInPath(Mogram mogram) {
        return "path".equals(this.parameter(mogram, "in").values().get(0).toString());
    }

    private Parameter parameter(Mogram mogram, String string) {
        return mogram.parameters().stream().filter(parameter -> parameter.name().equals(string)).findFirst().orElse(null);
    }

    private boolean isParameter(Mogram mogram) {
        return mogram.type().equals("Service.REST.Resource.Parameter");
    }

    public String errorMessage() {
        if (this.cause == Cause.NullPath) {
            return "Path cannot be empty";
        }
        if (this.cause == Cause.ParameterNotDeclared) {
            return "Parameters in path must be declared as \"Parameter\"";
        }
        return "Declared parameter is not visible in resource's path";
    }

    static enum Cause {
        NullPath,
        ParameterNotDeclared,
        ParameterNotInPath;

    }
}

