/******/ var __webpack_modules__ = ({

/***/ "./node_modules/vscode/_virtual/semver.js":
/*!************************************************!*\
  !*** ./node_modules/vscode/_virtual/semver.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __module: () => (/* binding */ semver)
/* harmony export */ });
var semver = {exports: {}};



/***/ }),

/***/ "./node_modules/vscode/external/tslib/tslib.es6.js":
/*!*********************************************************!*\
  !*** ./node_modules/vscode/external/tslib/tslib.es6.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __decorate: () => (/* binding */ __decorate),
/* harmony export */   __param: () => (/* binding */ __param)
/* harmony export */ });
function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}
function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}



/***/ }),

/***/ "./node_modules/vscode/external/vscode-marked/lib/marked.esm.js":
/*!**********************************************************************!*\
  !*** ./node_modules/vscode/external/vscode-marked/lib/marked.esm.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ marked_1)
/* harmony export */ });
var defaults$5 = {exports: {}};
function getDefaults$1() {
  return {
    baseUrl: null,
    breaks: false,
    extensions: null,
    gfm: true,
    headerIds: true,
    headerPrefix: '',
    highlight: null,
    langPrefix: 'language-',
    mangle: true,
    pedantic: false,
    renderer: null,
    sanitize: false,
    sanitizer: null,
    silent: false,
    smartLists: false,
    smartypants: false,
    tokenizer: null,
    walkTokens: null,
    xhtml: false
  };
}
function changeDefaults$1(newDefaults) {
  defaults$5.exports.defaults = newDefaults;
}
defaults$5.exports = {
  defaults: getDefaults$1(),
  getDefaults: getDefaults$1,
  changeDefaults: changeDefaults$1
};
const escapeTest = /[&<>"']/;
const escapeReplace = /[&<>"']/g;
const escapeTestNoEncode = /[<>"']|&(?!#?\w+;)/;
const escapeReplaceNoEncode = /[<>"']|&(?!#?\w+;)/g;
const escapeReplacements = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  '"': '&quot;',
  "'": '&#39;'
};
const getEscapeReplacement = (ch) => escapeReplacements[ch];
function escape$3(html, encode) {
  if (encode) {
    if (escapeTest.test(html)) {
      return html.replace(escapeReplace, getEscapeReplacement);
    }
  } else {
    if (escapeTestNoEncode.test(html)) {
      return html.replace(escapeReplaceNoEncode, getEscapeReplacement);
    }
  }
  return html;
}
const unescapeTest = /&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/ig;
function unescape$1(html) {
  return html.replace(unescapeTest, (_, n) => {
    n = n.toLowerCase();
    if (n === 'colon') return ':';
    if (n.charAt(0) === '#') {
      return n.charAt(1) === 'x'
        ? String.fromCharCode(parseInt(n.substring(2), 16))
        : String.fromCharCode(+n.substring(1));
    }
    return '';
  });
}
const caret = /(^|[^\[])\^/g;
function edit$1(regex, opt) {
  regex = regex.source || regex;
  opt = opt || '';
  const obj = {
    replace: (name, val) => {
      val = val.source || val;
      val = val.replace(caret, '$1');
      regex = regex.replace(name, val);
      return obj;
    },
    getRegex: () => {
      return new RegExp(regex, opt);
    }
  };
  return obj;
}
const nonWordAndColonTest = /[^\w:]/g;
const originIndependentUrl = /^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;
function cleanUrl$1(sanitize, base, href) {
  if (sanitize) {
    let prot;
    try {
      prot = decodeURIComponent(unescape$1(href))
        .replace(nonWordAndColonTest, '')
        .toLowerCase();
    } catch (e) {
      return null;
    }
    if (prot.indexOf('javascript:') === 0 || prot.indexOf('vbscript:') === 0 || prot.indexOf('data:') === 0) {
      return null;
    }
  }
  if (base && !originIndependentUrl.test(href)) {
    href = resolveUrl(base, href);
  }
  try {
    href = encodeURI(href).replace(/%25/g, '%');
  } catch (e) {
    return null;
  }
  return href;
}
const baseUrls = {};
const justDomain = /^[^:]+:\/*[^/]*$/;
const protocol = /^([^:]+:)[\s\S]*$/;
const domain = /^([^:]+:\/*[^/]*)[\s\S]*$/;
function resolveUrl(base, href) {
  if (!baseUrls[' ' + base]) {
    if (justDomain.test(base)) {
      baseUrls[' ' + base] = base + '/';
    } else {
      baseUrls[' ' + base] = rtrim$1(base, '/', true);
    }
  }
  base = baseUrls[' ' + base];
  const relativeBase = base.indexOf(':') === -1;
  if (href.substring(0, 2) === '//') {
    if (relativeBase) {
      return href;
    }
    return base.replace(protocol, '$1') + href;
  } else if (href.charAt(0) === '/') {
    if (relativeBase) {
      return href;
    }
    return base.replace(domain, '$1') + href;
  } else {
    return base + href;
  }
}
const noopTest$1 = { exec: function noopTest() {} };
function merge$2(obj) {
  let i = 1,
    target,
    key;
  for (; i < arguments.length; i++) {
    target = arguments[i];
    for (key in target) {
      if (Object.prototype.hasOwnProperty.call(target, key)) {
        obj[key] = target[key];
      }
    }
  }
  return obj;
}
function splitCells$1(tableRow, count) {
  const row = tableRow.replace(/\|/g, (match, offset, str) => {
      let escaped = false,
        curr = offset;
      while (--curr >= 0 && str[curr] === '\\') escaped = !escaped;
      if (escaped) {
        return '|';
      } else {
        return ' |';
      }
    }),
    cells = row.split(/ \|/);
  let i = 0;
  if (!cells[0].trim()) { cells.shift(); }
  if (!cells[cells.length - 1].trim()) { cells.pop(); }
  if (cells.length > count) {
    cells.splice(count);
  } else {
    while (cells.length < count) cells.push('');
  }
  for (; i < cells.length; i++) {
    cells[i] = cells[i].trim().replace(/\\\|/g, '|');
  }
  return cells;
}
function rtrim$1(str, c, invert) {
  const l = str.length;
  if (l === 0) {
    return '';
  }
  let suffLen = 0;
  while (suffLen < l) {
    const currChar = str.charAt(l - suffLen - 1);
    if (currChar === c && !invert) {
      suffLen++;
    } else if (currChar !== c && invert) {
      suffLen++;
    } else {
      break;
    }
  }
  return str.substr(0, l - suffLen);
}
function findClosingBracket$1(str, b) {
  if (str.indexOf(b[1]) === -1) {
    return -1;
  }
  const l = str.length;
  let level = 0,
    i = 0;
  for (; i < l; i++) {
    if (str[i] === '\\') {
      i++;
    } else if (str[i] === b[0]) {
      level++;
    } else if (str[i] === b[1]) {
      level--;
      if (level < 0) {
        return i;
      }
    }
  }
  return -1;
}
function checkSanitizeDeprecation$1(opt) {
  if (opt && opt.sanitize && !opt.silent) {
    console.warn('marked(): sanitize and sanitizer parameters are deprecated since version 0.7.0, should not be used and will be removed in the future. Read more here: https://marked.js.org/#/USING_ADVANCED.md#options');
  }
}
function repeatString$1(pattern, count) {
  if (count < 1) {
    return '';
  }
  let result = '';
  while (count > 1) {
    if (count & 1) {
      result += pattern;
    }
    count >>= 1;
    pattern += pattern;
  }
  return result + pattern;
}
var helpers = {
  escape: escape$3,
  unescape: unescape$1,
  edit: edit$1,
  cleanUrl: cleanUrl$1,
  resolveUrl,
  noopTest: noopTest$1,
  merge: merge$2,
  splitCells: splitCells$1,
  rtrim: rtrim$1,
  findClosingBracket: findClosingBracket$1,
  checkSanitizeDeprecation: checkSanitizeDeprecation$1,
  repeatString: repeatString$1
};
const { defaults: defaults$4 } = defaults$5.exports;
const {
  rtrim,
  splitCells,
  escape: escape$2,
  findClosingBracket
} = helpers;
function outputLink(cap, link, raw, lexer) {
  const href = link.href;
  const title = link.title ? escape$2(link.title) : null;
  const text = cap[1].replace(/\\([\[\]])/g, '$1');
  if (cap[0].charAt(0) !== '!') {
    lexer.state.inLink = true;
    const token = {
      type: 'link',
      raw,
      href,
      title,
      text,
      tokens: lexer.inlineTokens(text, [])
    };
    lexer.state.inLink = false;
    return token;
  } else {
    return {
      type: 'image',
      raw,
      href,
      title,
      text: escape$2(text)
    };
  }
}
function indentCodeCompensation(raw, text) {
  const matchIndentToCode = raw.match(/^(\s+)(?:```)/);
  if (matchIndentToCode === null) {
    return text;
  }
  const indentToCode = matchIndentToCode[1];
  return ( text
    .split('\n')
    .map(node => {
      const matchIndentInNode = node.match(/^\s+/);
      if (matchIndentInNode === null) {
        return node;
      }
      const [indentInNode] = matchIndentInNode;
      if (indentInNode.length >= indentToCode.length) {
        return node.slice(indentToCode.length);
      }
      return node;
    }))
    .join('\n');
}
var Tokenizer_1 = class Tokenizer {
  constructor(options) {
    this.options = options || defaults$4;
  }
  space(src) {
    const cap = this.rules.block.newline.exec(src);
    if (cap) {
      if (cap[0].length > 1) {
        return {
          type: 'space',
          raw: cap[0]
        };
      }
      return { raw: '\n' };
    }
  }
  code(src) {
    const cap = this.rules.block.code.exec(src);
    if (cap) {
      const text = cap[0].replace(/^ {1,4}/gm, '');
      return {
        type: 'code',
        raw: cap[0],
        codeBlockStyle: 'indented',
        text: !this.options.pedantic
          ? rtrim(text, '\n')
          : text
      };
    }
  }
  fences(src) {
    const cap = this.rules.block.fences.exec(src);
    if (cap) {
      const raw = cap[0];
      const text = indentCodeCompensation(raw, cap[3] || '');
      return {
        type: 'code',
        raw,
        lang: cap[2] ? cap[2].trim() : cap[2],
        text
      };
    }
  }
  heading(src) {
    const cap = this.rules.block.heading.exec(src);
    if (cap) {
      let text = cap[2].trim();
      if (/#$/.test(text)) {
        const trimmed = rtrim(text, '#');
        if (this.options.pedantic) {
          text = trimmed.trim();
        } else if (!trimmed || / $/.test(trimmed)) {
          text = trimmed.trim();
        }
      }
      const token = {
        type: 'heading',
        raw: cap[0],
        depth: cap[1].length,
        text: text,
        tokens: []
      };
      this.lexer.inline(token.text, token.tokens);
      return token;
    }
  }
  hr(src) {
    const cap = this.rules.block.hr.exec(src);
    if (cap) {
      return {
        type: 'hr',
        raw: cap[0]
      };
    }
  }
  blockquote(src) {
    const cap = this.rules.block.blockquote.exec(src);
    if (cap) {
      const text = cap[0].replace(/^ *> ?/gm, '');
      return {
        type: 'blockquote',
        raw: cap[0],
        tokens: this.lexer.blockTokens(text, []),
        text
      };
    }
  }
  list(src) {
    let cap = this.rules.block.list.exec(src);
    if (cap) {
      let raw, istask, ischecked, indent, i, blankLine, endsWithBlankLine,
        line, lines, itemContents;
      let bull = cap[1].trim();
      const isordered = bull.length > 1;
      const list = {
        type: 'list',
        raw: '',
        ordered: isordered,
        start: isordered ? +bull.slice(0, -1) : '',
        loose: false,
        items: []
      };
      bull = isordered ? `\\d{1,9}\\${bull.slice(-1)}` : `\\${bull}`;
      if (this.options.pedantic) {
        bull = isordered ? bull : '[*+-]';
      }
      const itemRegex = new RegExp(`^( {0,3}${bull})((?: [^\\n]*| *)(?:\\n[^\\n]*)*(?:\\n|$))`);
      while (src) {
        if (this.rules.block.hr.test(src)) {
          break;
        }
        if (!(cap = itemRegex.exec(src))) {
          break;
        }
        lines = cap[2].split('\n');
        if (this.options.pedantic) {
          indent = 2;
          itemContents = lines[0].trimLeft();
        } else {
          indent = cap[2].search(/[^ ]/);
          indent = cap[1].length + (indent > 4 ? 1 : indent);
          itemContents = lines[0].slice(indent - cap[1].length);
        }
        blankLine = false;
        raw = cap[0];
        if (!lines[0] && /^ *$/.test(lines[1])) {
          raw = cap[1] + lines.slice(0, 2).join('\n') + '\n';
          list.loose = true;
          lines = [];
        }
        const nextBulletRegex = new RegExp(`^ {0,${Math.min(3, indent - 1)}}(?:[*+-]|\\d{1,9}[.)])`);
        for (i = 1; i < lines.length; i++) {
          line = lines[i];
          if (this.options.pedantic) {
            line = line.replace(/^ {1,4}(?=( {4})*[^ ])/g, '  ');
          }
          if (nextBulletRegex.test(line)) {
            raw = cap[1] + lines.slice(0, i).join('\n') + '\n';
            break;
          }
          if (!blankLine) {
            if (!line.trim()) {
              blankLine = true;
            }
            if (line.search(/[^ ]/) >= indent) {
              itemContents += '\n' + line.slice(indent);
            } else {
              itemContents += '\n' + line;
            }
            continue;
          }
          if (line.search(/[^ ]/) >= indent || !line.trim()) {
            itemContents += '\n' + line.slice(indent);
            continue;
          } else {
            raw = cap[1] + lines.slice(0, i).join('\n') + '\n';
            break;
          }
        }
        if (!list.loose) {
          if (endsWithBlankLine) {
            list.loose = true;
          } else if (/\n *\n *$/.test(raw)) {
            endsWithBlankLine = true;
          }
        }
        if (this.options.gfm) {
          istask = /^\[[ xX]\] /.exec(itemContents);
          if (istask) {
            ischecked = istask[0] !== '[ ] ';
            itemContents = itemContents.replace(/^\[[ xX]\] +/, '');
          }
        }
        list.items.push({
          type: 'list_item',
          raw: raw,
          task: !!istask,
          checked: ischecked,
          loose: false,
          text: itemContents
        });
        list.raw += raw;
        src = src.slice(raw.length);
      }
      list.items[list.items.length - 1].raw = raw.trimRight();
      list.items[list.items.length - 1].text = itemContents.trimRight();
      list.raw = list.raw.trimRight();
      const l = list.items.length;
      for (i = 0; i < l; i++) {
        this.lexer.state.top = false;
        list.items[i].tokens = this.lexer.blockTokens(list.items[i].text, []);
        if (( list.items[i].tokens.some(t => t.type === 'space'))) {
          list.loose = true;
          list.items[i].loose = true;
        }
      }
      return list;
    }
  }
  html(src) {
    const cap = this.rules.block.html.exec(src);
    if (cap) {
      const token = {
        type: 'html',
        raw: cap[0],
        pre: !this.options.sanitizer
          && (cap[1] === 'pre' || cap[1] === 'script' || cap[1] === 'style'),
        text: cap[0]
      };
      if (this.options.sanitize) {
        token.type = 'paragraph';
        token.text = this.options.sanitizer ? this.options.sanitizer(cap[0]) : escape$2(cap[0]);
        token.tokens = [];
        this.lexer.inline(token.text, token.tokens);
      }
      return token;
    }
  }
  def(src) {
    const cap = this.rules.block.def.exec(src);
    if (cap) {
      if (cap[3]) cap[3] = cap[3].substring(1, cap[3].length - 1);
      const tag = cap[1].toLowerCase().replace(/\s+/g, ' ');
      return {
        type: 'def',
        tag,
        raw: cap[0],
        href: cap[2],
        title: cap[3]
      };
    }
  }
  table(src) {
    const cap = this.rules.block.table.exec(src);
    if (cap) {
      const item = {
        type: 'table',
        header: ( splitCells(cap[1]).map(c => { return { text: c }; })),
        align: cap[2].replace(/^ *|\| *$/g, '').split(/ *\| */),
        rows: cap[3] ? cap[3].replace(/\n$/, '').split('\n') : []
      };
      if (item.header.length === item.align.length) {
        item.raw = cap[0];
        let l = item.align.length;
        let i, j, k, row;
        for (i = 0; i < l; i++) {
          if (/^ *-+: *$/.test(item.align[i])) {
            item.align[i] = 'right';
          } else if (/^ *:-+: *$/.test(item.align[i])) {
            item.align[i] = 'center';
          } else if (/^ *:-+ *$/.test(item.align[i])) {
            item.align[i] = 'left';
          } else {
            item.align[i] = null;
          }
        }
        l = item.rows.length;
        for (i = 0; i < l; i++) {
          item.rows[i] = ( splitCells(item.rows[i], item.header.length).map(c => { return { text: c }; }));
        }
        l = item.header.length;
        for (j = 0; j < l; j++) {
          item.header[j].tokens = [];
          this.lexer.inlineTokens(item.header[j].text, item.header[j].tokens);
        }
        l = item.rows.length;
        for (j = 0; j < l; j++) {
          row = item.rows[j];
          for (k = 0; k < row.length; k++) {
            row[k].tokens = [];
            this.lexer.inlineTokens(row[k].text, row[k].tokens);
          }
        }
        return item;
      }
    }
  }
  lheading(src) {
    const cap = this.rules.block.lheading.exec(src);
    if (cap) {
      const token = {
        type: 'heading',
        raw: cap[0],
        depth: cap[2].charAt(0) === '=' ? 1 : 2,
        text: cap[1],
        tokens: []
      };
      this.lexer.inline(token.text, token.tokens);
      return token;
    }
  }
  paragraph(src) {
    const cap = this.rules.block.paragraph.exec(src);
    if (cap) {
      const token = {
        type: 'paragraph',
        raw: cap[0],
        text: cap[1].charAt(cap[1].length - 1) === '\n'
          ? cap[1].slice(0, -1)
          : cap[1],
        tokens: []
      };
      this.lexer.inline(token.text, token.tokens);
      return token;
    }
  }
  text(src) {
    const cap = this.rules.block.text.exec(src);
    if (cap) {
      const token = {
        type: 'text',
        raw: cap[0],
        text: cap[0],
        tokens: []
      };
      this.lexer.inline(token.text, token.tokens);
      return token;
    }
  }
  escape(src) {
    const cap = this.rules.inline.escape.exec(src);
    if (cap) {
      return {
        type: 'escape',
        raw: cap[0],
        text: escape$2(cap[1])
      };
    }
  }
  tag(src) {
    const cap = this.rules.inline.tag.exec(src);
    if (cap) {
      if (!this.lexer.state.inLink && /^<a /i.test(cap[0])) {
        this.lexer.state.inLink = true;
      } else if (this.lexer.state.inLink && /^<\/a>/i.test(cap[0])) {
        this.lexer.state.inLink = false;
      }
      if (!this.lexer.state.inRawBlock && /^<(pre|code|kbd|script)(\s|>)/i.test(cap[0])) {
        this.lexer.state.inRawBlock = true;
      } else if (this.lexer.state.inRawBlock && /^<\/(pre|code|kbd|script)(\s|>)/i.test(cap[0])) {
        this.lexer.state.inRawBlock = false;
      }
      return {
        type: this.options.sanitize
          ? 'text'
          : 'html',
        raw: cap[0],
        inLink: this.lexer.state.inLink,
        inRawBlock: this.lexer.state.inRawBlock,
        text: this.options.sanitize
          ? (this.options.sanitizer
            ? this.options.sanitizer(cap[0])
            : escape$2(cap[0]))
          : cap[0]
      };
    }
  }
  link(src) {
    const cap = this.rules.inline.link.exec(src);
    if (cap) {
      const trimmedUrl = cap[2].trim();
      if (!this.options.pedantic && /^</.test(trimmedUrl)) {
        if (!(/>$/.test(trimmedUrl))) {
          return;
        }
        const rtrimSlash = rtrim(trimmedUrl.slice(0, -1), '\\');
        if ((trimmedUrl.length - rtrimSlash.length) % 2 === 0) {
          return;
        }
      } else {
        const lastParenIndex = findClosingBracket(cap[2], '()');
        if (lastParenIndex > -1) {
          const start = cap[0].indexOf('!') === 0 ? 5 : 4;
          const linkLen = start + cap[1].length + lastParenIndex;
          cap[2] = cap[2].substring(0, lastParenIndex);
          cap[0] = cap[0].substring(0, linkLen).trim();
          cap[3] = '';
        }
      }
      let href = cap[2];
      let title = '';
      if (this.options.pedantic) {
        const link = /^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(href);
        if (link) {
          href = link[1];
          title = link[3];
        }
      } else {
        title = cap[3] ? cap[3].slice(1, -1) : '';
      }
      href = href.trim();
      if (/^</.test(href)) {
        if (this.options.pedantic && !(/>$/.test(trimmedUrl))) {
          href = href.slice(1);
        } else {
          href = href.slice(1, -1);
        }
      }
      return outputLink(cap, {
        href: href ? href.replace(this.rules.inline._escapes, '$1') : href,
        title: title ? title.replace(this.rules.inline._escapes, '$1') : title
      }, cap[0], this.lexer);
    }
  }
  reflink(src, links) {
    let cap;
    if ((cap = this.rules.inline.reflink.exec(src))
        || (cap = this.rules.inline.nolink.exec(src))) {
      let link = (cap[2] || cap[1]).replace(/\s+/g, ' ');
      link = links[link.toLowerCase()];
      if (!link || !link.href) {
        const text = cap[0].charAt(0);
        return {
          type: 'text',
          raw: text,
          text
        };
      }
      return outputLink(cap, link, cap[0], this.lexer);
    }
  }
  emStrong(src, maskedSrc, prevChar = '') {
    let match = this.rules.inline.emStrong.lDelim.exec(src);
    if (!match) return;
    if (match[3] && prevChar.match(/[\p{L}\p{N}]/u)) return;
    const nextChar = match[1] || match[2] || '';
    if (!nextChar || (nextChar && (prevChar === '' || this.rules.inline.punctuation.exec(prevChar)))) {
      const lLength = match[0].length - 1;
      let rDelim, rLength, delimTotal = lLength, midDelimTotal = 0;
      const endReg = match[0][0] === '*' ? this.rules.inline.emStrong.rDelimAst : this.rules.inline.emStrong.rDelimUnd;
      endReg.lastIndex = 0;
      maskedSrc = maskedSrc.slice(-1 * src.length + lLength);
      while ((match = endReg.exec(maskedSrc)) != null) {
        rDelim = match[1] || match[2] || match[3] || match[4] || match[5] || match[6];
        if (!rDelim) continue;
        rLength = rDelim.length;
        if (match[3] || match[4]) {
          delimTotal += rLength;
          continue;
        } else if (match[5] || match[6]) {
          if (lLength % 3 && !((lLength + rLength) % 3)) {
            midDelimTotal += rLength;
            continue;
          }
        }
        delimTotal -= rLength;
        if (delimTotal > 0) continue;
        rLength = Math.min(rLength, rLength + delimTotal + midDelimTotal);
        if (Math.min(lLength, rLength) % 2) {
          const text = src.slice(1, lLength + match.index + rLength);
          return {
            type: 'em',
            raw: src.slice(0, lLength + match.index + rLength + 1),
            text,
            tokens: this.lexer.inlineTokens(text, [])
          };
        }
        const text = src.slice(2, lLength + match.index + rLength - 1);
        return {
          type: 'strong',
          raw: src.slice(0, lLength + match.index + rLength + 1),
          text,
          tokens: this.lexer.inlineTokens(text, [])
        };
      }
    }
  }
  codespan(src) {
    const cap = this.rules.inline.code.exec(src);
    if (cap) {
      let text = cap[2].replace(/\n/g, ' ');
      const hasNonSpaceChars = /[^ ]/.test(text);
      const hasSpaceCharsOnBothEnds = /^ /.test(text) && / $/.test(text);
      if (hasNonSpaceChars && hasSpaceCharsOnBothEnds) {
        text = text.substring(1, text.length - 1);
      }
      text = escape$2(text, true);
      return {
        type: 'codespan',
        raw: cap[0],
        text
      };
    }
  }
  br(src) {
    const cap = this.rules.inline.br.exec(src);
    if (cap) {
      return {
        type: 'br',
        raw: cap[0]
      };
    }
  }
  del(src) {
    const cap = this.rules.inline.del.exec(src);
    if (cap) {
      return {
        type: 'del',
        raw: cap[0],
        text: cap[2],
        tokens: this.lexer.inlineTokens(cap[2], [])
      };
    }
  }
  autolink(src, mangle) {
    const cap = this.rules.inline.autolink.exec(src);
    if (cap) {
      let text, href;
      if (cap[2] === '@') {
        text = escape$2(this.options.mangle ? mangle(cap[1]) : cap[1]);
        href = 'mailto:' + text;
      } else {
        text = escape$2(cap[1]);
        href = text;
      }
      return {
        type: 'link',
        raw: cap[0],
        text,
        href,
        tokens: [
          {
            type: 'text',
            raw: text,
            text
          }
        ]
      };
    }
  }
  url(src, mangle) {
    let cap;
    if (cap = this.rules.inline.url.exec(src)) {
      let text, href;
      if (cap[2] === '@') {
        text = escape$2(this.options.mangle ? mangle(cap[0]) : cap[0]);
        href = 'mailto:' + text;
      } else {
        let prevCapZero;
        do {
          prevCapZero = cap[0];
          cap[0] = this.rules.inline._backpedal.exec(cap[0])[0];
        } while (prevCapZero !== cap[0]);
        text = escape$2(cap[0]);
        if (cap[1] === 'www.') {
          href = 'http://' + text;
        } else {
          href = text;
        }
      }
      return {
        type: 'link',
        raw: cap[0],
        text,
        href,
        tokens: [
          {
            type: 'text',
            raw: text,
            text
          }
        ]
      };
    }
  }
  inlineText(src, smartypants) {
    const cap = this.rules.inline.text.exec(src);
    if (cap) {
      let text;
      if (this.lexer.state.inRawBlock) {
        text = this.options.sanitize ? (this.options.sanitizer ? this.options.sanitizer(cap[0]) : escape$2(cap[0])) : cap[0];
      } else {
        text = escape$2(this.options.smartypants ? smartypants(cap[0]) : cap[0]);
      }
      return {
        type: 'text',
        raw: cap[0],
        text
      };
    }
  }
};
const {
  noopTest,
  edit,
  merge: merge$1
} = helpers;
const block$1 = {
  newline: /^(?: *(?:\n|$))+/,
  code: /^( {4}[^\n]+(?:\n(?: *(?:\n|$))*)?)+/,
  fences: /^ {0,3}(`{3,}(?=[^`\n]*\n)|~{3,})([^\n]*)\n(?:|([\s\S]*?)\n)(?: {0,3}\1[~`]* *(?=\n|$)|$)/,
  hr: /^ {0,3}((?:- *){3,}|(?:_ *){3,}|(?:\* *){3,})(?:\n+|$)/,
  heading: /^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,
  blockquote: /^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,
  list: /^( {0,3}bull)( [^\n]+?)?(?:\n|$)/,
  html: '^ {0,3}(?:'
    + '<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)'
    + '|comment[^\\n]*(\\n+|$)'
    + '|<\\?[\\s\\S]*?(?:\\?>\\n*|$)'
    + '|<![A-Z][\\s\\S]*?(?:>\\n*|$)'
    + '|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)'
    + '|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n *)+\\n|$)'
    + '|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$)'
    + '|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$)'
    + ')',
  def: /^ {0,3}\[(label)\]: *\n? *<?([^\s>]+)>?(?:(?: +\n? *| *\n *)(title))? *(?:\n+|$)/,
  table: noopTest,
  lheading: /^([^\n]+)\n {0,3}(=+|-+) *(?:\n+|$)/,
  _paragraph: /^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html| +\n)[^\n]+)*)/,
  text: /^[^\n]+/
};
block$1._label = /(?!\s*\])(?:\\[\[\]]|[^\[\]])+/;
block$1._title = /(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/;
block$1.def = edit(block$1.def)
  .replace('label', block$1._label)
  .replace('title', block$1._title)
  .getRegex();
block$1.bullet = /(?:[*+-]|\d{1,9}[.)])/;
block$1.listItemStart = edit(/^( *)(bull) */)
  .replace('bull', block$1.bullet)
  .getRegex();
block$1.list = edit(block$1.list)
  .replace(/bull/g, block$1.bullet)
  .replace('hr', '\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))')
  .replace('def', '\\n+(?=' + block$1.def.source + ')')
  .getRegex();
block$1._tag = 'address|article|aside|base|basefont|blockquote|body|caption'
  + '|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption'
  + '|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe'
  + '|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option'
  + '|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr'
  + '|track|ul';
block$1._comment = /<!--(?!-?>)[\s\S]*?(?:-->|$)/;
block$1.html = edit(block$1.html, 'i')
  .replace('comment', block$1._comment)
  .replace('tag', block$1._tag)
  .replace('attribute', / +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/)
  .getRegex();
block$1.paragraph = edit(block$1._paragraph)
  .replace('hr', block$1.hr)
  .replace('heading', ' {0,3}#{1,6} ')
  .replace('|lheading', '')
  .replace('blockquote', ' {0,3}>')
  .replace('fences', ' {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n')
  .replace('list', ' {0,3}(?:[*+-]|1[.)]) ')
  .replace('html', '</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)')
  .replace('tag', block$1._tag)
  .getRegex();
block$1.blockquote = edit(block$1.blockquote)
  .replace('paragraph', block$1.paragraph)
  .getRegex();
block$1.normal = merge$1({}, block$1);
block$1.gfm = merge$1({}, block$1.normal, {
  table: '^ *([^\\n ].*\\|.*)\\n'
    + ' {0,3}(?:\\| *)?(:?-+:? *(?:\\| *:?-+:? *)*)\\|?'
    + '(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)'
});
block$1.gfm.table = edit(block$1.gfm.table)
  .replace('hr', block$1.hr)
  .replace('heading', ' {0,3}#{1,6} ')
  .replace('blockquote', ' {0,3}>')
  .replace('code', ' {4}[^\\n]')
  .replace('fences', ' {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n')
  .replace('list', ' {0,3}(?:[*+-]|1[.)]) ')
  .replace('html', '</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)')
  .replace('tag', block$1._tag)
  .getRegex();
block$1.pedantic = merge$1({}, block$1.normal, {
  html: edit(
    '^ *(?:comment *(?:\\n|\\s*$)'
    + '|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)'
    + '|<tag(?:"[^"]*"|\'[^\']*\'|\\s[^\'"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))')
    .replace('comment', block$1._comment)
    .replace(/tag/g, '(?!(?:'
      + 'a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub'
      + '|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)'
      + '\\b)\\w+(?!:|[^\\w\\s@]*@)\\b')
    .getRegex(),
  def: /^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,
  heading: /^(#{1,6})(.*)(?:\n+|$)/,
  fences: noopTest,
  paragraph: edit(block$1.normal._paragraph)
    .replace('hr', block$1.hr)
    .replace('heading', ' *#{1,6} *[^\n]')
    .replace('lheading', block$1.lheading)
    .replace('blockquote', ' {0,3}>')
    .replace('|fences', '')
    .replace('|list', '')
    .replace('|html', '')
    .getRegex()
});
const inline$1 = {
  escape: /^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,
  autolink: /^<(scheme:[^\s\x00-\x1f<>]*|email)>/,
  url: noopTest,
  tag: '^comment'
    + '|^</[a-zA-Z][\\w:-]*\\s*>'
    + '|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>'
    + '|^<\\?[\\s\\S]*?\\?>'
    + '|^<![a-zA-Z]+\\s[\\s\\S]*?>'
    + '|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>',
  link: /^!?\[(label)\]\(\s*(href)(?:\s+(title))?\s*\)/,
  reflink: /^!?\[(label)\]\[(?!\s*\])((?:\\[\[\]]?|[^\[\]\\])+)\]/,
  nolink: /^!?\[(?!\s*\])((?:\[[^\[\]]*\]|\\[\[\]]|[^\[\]])*)\](?:\[\])?/,
  reflinkSearch: 'reflink|nolink(?!\\()',
  emStrong: {
    lDelim: /^(?:\*+(?:([punct_])|[^\s*]))|^_+(?:([punct*])|([^\s_]))/,
    rDelimAst: /\_\_[^_*]*?\*[^_*]*?\_\_|[punct_](\*+)(?=[\s]|$)|[^punct*_\s](\*+)(?=[punct_\s]|$)|[punct_\s](\*+)(?=[^punct*_\s])|[\s](\*+)(?=[punct_])|[punct_](\*+)(?=[punct_])|[^punct*_\s](\*+)(?=[^punct*_\s])/,
    rDelimUnd: /\*\*[^_*]*?\_[^_*]*?\*\*|[punct*](\_+)(?=[\s]|$)|[^punct*_\s](\_+)(?=[punct*\s]|$)|[punct*\s](\_+)(?=[^punct*_\s])|[\s](\_+)(?=[punct*])|[punct*](\_+)(?=[punct*])/
  },
  code: /^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,
  br: /^( {2,}|\\)\n(?!\s*$)/,
  del: noopTest,
  text: /^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,
  punctuation: /^([\spunctuation])/
};
inline$1._punctuation = '!"#$%&\'()+\\-.,/:;<=>?@\\[\\]`^{|}~';
inline$1.punctuation = edit(inline$1.punctuation).replace(/punctuation/g, inline$1._punctuation).getRegex();
inline$1.blockSkip = /\[[^\]]*?\]\([^\)]*?\)|`[^`]*?`|<[^>]*?>/g;
inline$1.escapedEmSt = /\\\*|\\_/g;
inline$1._comment = edit(block$1._comment).replace('(?:-->|$)', '-->').getRegex();
inline$1.emStrong.lDelim = edit(inline$1.emStrong.lDelim)
  .replace(/punct/g, inline$1._punctuation)
  .getRegex();
inline$1.emStrong.rDelimAst = edit(inline$1.emStrong.rDelimAst, 'g')
  .replace(/punct/g, inline$1._punctuation)
  .getRegex();
inline$1.emStrong.rDelimUnd = edit(inline$1.emStrong.rDelimUnd, 'g')
  .replace(/punct/g, inline$1._punctuation)
  .getRegex();
inline$1._escapes = /\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/g;
inline$1._scheme = /[a-zA-Z][a-zA-Z0-9+.-]{1,31}/;
inline$1._email = /[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/;
inline$1.autolink = edit(inline$1.autolink)
  .replace('scheme', inline$1._scheme)
  .replace('email', inline$1._email)
  .getRegex();
inline$1._attribute = /\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/;
inline$1.tag = edit(inline$1.tag)
  .replace('comment', inline$1._comment)
  .replace('attribute', inline$1._attribute)
  .getRegex();
inline$1._label = /(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/;
inline$1._href = /<(?:\\.|[^\n<>\\])+>|[^\s\x00-\x1f]*/;
inline$1._title = /"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/;
inline$1.link = edit(inline$1.link)
  .replace('label', inline$1._label)
  .replace('href', inline$1._href)
  .replace('title', inline$1._title)
  .getRegex();
inline$1.reflink = edit(inline$1.reflink)
  .replace('label', inline$1._label)
  .getRegex();
inline$1.reflinkSearch = edit(inline$1.reflinkSearch, 'g')
  .replace('reflink', inline$1.reflink)
  .replace('nolink', inline$1.nolink)
  .getRegex();
inline$1.normal = merge$1({}, inline$1);
inline$1.pedantic = merge$1({}, inline$1.normal, {
  strong: {
    start: /^__|\*\*/,
    middle: /^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,
    endAst: /\*\*(?!\*)/g,
    endUnd: /__(?!_)/g
  },
  em: {
    start: /^_|\*/,
    middle: /^()\*(?=\S)([\s\S]*?\S)\*(?!\*)|^_(?=\S)([\s\S]*?\S)_(?!_)/,
    endAst: /\*(?!\*)/g,
    endUnd: /_(?!_)/g
  },
  link: edit(/^!?\[(label)\]\((.*?)\)/)
    .replace('label', inline$1._label)
    .getRegex(),
  reflink: edit(/^!?\[(label)\]\s*\[([^\]]*)\]/)
    .replace('label', inline$1._label)
    .getRegex()
});
inline$1.gfm = merge$1({}, inline$1.normal, {
  escape: edit(inline$1.escape).replace('])', '~|])').getRegex(),
  _extended_email: /[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/,
  url: /^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,
  _backpedal: /(?:[^?!.,:;*_~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,
  del: /^(~~?)(?=[^\s~])([\s\S]*?[^\s~])\1(?=[^~]|$)/,
  text: /^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/
});
inline$1.gfm.url = edit(inline$1.gfm.url, 'i')
  .replace('email', inline$1.gfm._extended_email)
  .getRegex();
inline$1.breaks = merge$1({}, inline$1.gfm, {
  br: edit(inline$1.br).replace('{2,}', '*').getRegex(),
  text: edit(inline$1.gfm.text)
    .replace('\\b_', '\\b_| {2,}\\n')
    .replace(/\{2,\}/g, '*')
    .getRegex()
});
var rules = {
  block: block$1,
  inline: inline$1
};
const Tokenizer$1 = Tokenizer_1;
const { defaults: defaults$3 } = defaults$5.exports;
const { block, inline } = rules;
const { repeatString } = helpers;
function smartypants(text) {
  return text
    .replace(/---/g, '\u2014')
    .replace(/--/g, '\u2013')
    .replace(/(^|[-\u2014/(\[{"\s])'/g, '$1\u2018')
    .replace(/'/g, '\u2019')
    .replace(/(^|[-\u2014/(\[{\u2018\s])"/g, '$1\u201c')
    .replace(/"/g, '\u201d')
    .replace(/\.{3}/g, '\u2026');
}
function mangle(text) {
  let out = '',
    i,
    ch;
  const l = text.length;
  for (i = 0; i < l; i++) {
    ch = text.charCodeAt(i);
    if (Math.random() > 0.5) {
      ch = 'x' + ( ch.toString(16));
    }
    out += '&#' + ch + ';';
  }
  return out;
}
var Lexer_1 = class Lexer {
  constructor(options) {
    this.tokens = [];
    this.tokens.links = Object.create(null);
    this.options = options || defaults$3;
    this.options.tokenizer = this.options.tokenizer || new Tokenizer$1();
    this.tokenizer = this.options.tokenizer;
    this.tokenizer.options = this.options;
    this.tokenizer.lexer = this;
    this.inlineQueue = [];
    this.state = {
      inLink: false,
      inRawBlock: false,
      top: true
    };
    const rules = {
      block: block.normal,
      inline: inline.normal
    };
    if (this.options.pedantic) {
      rules.block = block.pedantic;
      rules.inline = inline.pedantic;
    } else if (this.options.gfm) {
      rules.block = block.gfm;
      if (this.options.breaks) {
        rules.inline = inline.breaks;
      } else {
        rules.inline = inline.gfm;
      }
    }
    this.tokenizer.rules = rules;
  }
  static get rules() {
    return {
      block,
      inline
    };
  }
  static lex(src, options) {
    const lexer = new Lexer(options);
    return lexer.lex(src);
  }
  static lexInline(src, options) {
    const lexer = new Lexer(options);
    return lexer.inlineTokens(src);
  }
  lex(src) {
    src = src
      .replace(/\r\n|\r/g, '\n')
      .replace(/\t/g, '    ');
    this.blockTokens(src, this.tokens);
    let next;
    while (next = this.inlineQueue.shift()) {
      this.inlineTokens(next.src, next.tokens);
    }
    return this.tokens;
  }
  blockTokens(src, tokens = []) {
    if (this.options.pedantic) {
      src = src.replace(/^ +$/gm, '');
    }
    let token, lastToken, cutSrc, lastParagraphClipped;
    while (src) {
      if (this.options.extensions
        && this.options.extensions.block
        && ( this.options.extensions.block.some((extTokenizer) => {
          if (token = extTokenizer.call({ lexer: this }, src, tokens)) {
            src = src.substring(token.raw.length);
            tokens.push(token);
            return true;
          }
          return false;
        }))) {
        continue;
      }
      if (token = this.tokenizer.space(src)) {
        src = src.substring(token.raw.length);
        if (token.type) {
          tokens.push(token);
        }
        continue;
      }
      if (token = this.tokenizer.code(src)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && (lastToken.type === 'paragraph' || lastToken.type === 'text')) {
          lastToken.raw += '\n' + token.raw;
          lastToken.text += '\n' + token.text;
          this.inlineQueue[this.inlineQueue.length - 1].src = lastToken.text;
        } else {
          tokens.push(token);
        }
        continue;
      }
      if (token = this.tokenizer.fences(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.heading(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.hr(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.blockquote(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.list(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.html(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.def(src)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && (lastToken.type === 'paragraph' || lastToken.type === 'text')) {
          lastToken.raw += '\n' + token.raw;
          lastToken.text += '\n' + token.raw;
          this.inlineQueue[this.inlineQueue.length - 1].src = lastToken.text;
        } else if (!this.tokens.links[token.tag]) {
          this.tokens.links[token.tag] = {
            href: token.href,
            title: token.title
          };
        }
        continue;
      }
      if (token = this.tokenizer.table(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.lheading(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      cutSrc = src;
      if (this.options.extensions && this.options.extensions.startBlock) {
        let startIndex = Infinity;
        const tempSrc = src.slice(1);
        let tempStart;
        this.options.extensions.startBlock.forEach(function(getStartIndex) {
          tempStart = getStartIndex.call({ lexer: this }, tempSrc);
          if (typeof tempStart === 'number' && tempStart >= 0) { startIndex = Math.min(startIndex, tempStart); }
        });
        if (startIndex < Infinity && startIndex >= 0) {
          cutSrc = src.substring(0, startIndex + 1);
        }
      }
      if (this.state.top && (token = this.tokenizer.paragraph(cutSrc))) {
        lastToken = tokens[tokens.length - 1];
        if (lastParagraphClipped && lastToken.type === 'paragraph') {
          lastToken.raw += '\n' + token.raw;
          lastToken.text += '\n' + token.text;
          this.inlineQueue.pop();
          this.inlineQueue[this.inlineQueue.length - 1].src = lastToken.text;
        } else {
          tokens.push(token);
        }
        lastParagraphClipped = (cutSrc.length !== src.length);
        src = src.substring(token.raw.length);
        continue;
      }
      if (token = this.tokenizer.text(src)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && lastToken.type === 'text') {
          lastToken.raw += '\n' + token.raw;
          lastToken.text += '\n' + token.text;
          this.inlineQueue.pop();
          this.inlineQueue[this.inlineQueue.length - 1].src = lastToken.text;
        } else {
          tokens.push(token);
        }
        continue;
      }
      if (src) {
        const errMsg = 'Infinite loop on byte: ' + src.charCodeAt(0);
        if (this.options.silent) {
          console.error(errMsg);
          break;
        } else {
          throw new Error(errMsg);
        }
      }
    }
    this.state.top = true;
    return tokens;
  }
  inline(src, tokens) {
    this.inlineQueue.push({ src, tokens });
  }
  inlineTokens(src, tokens = []) {
    let token, lastToken, cutSrc;
    let maskedSrc = src;
    let match;
    let keepPrevChar, prevChar;
    if (this.tokens.links) {
      const links = ( Object.keys(this.tokens.links));
      if (links.length > 0) {
        while ((match = this.tokenizer.rules.inline.reflinkSearch.exec(maskedSrc)) != null) {
          if (links.includes(match[0].slice(match[0].lastIndexOf('[') + 1, -1))) {
            maskedSrc = maskedSrc.slice(0, match.index) + '[' + repeatString('a', match[0].length - 2) + ']' + maskedSrc.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex);
          }
        }
      }
    }
    while ((match = this.tokenizer.rules.inline.blockSkip.exec(maskedSrc)) != null) {
      maskedSrc = maskedSrc.slice(0, match.index) + '[' + repeatString('a', match[0].length - 2) + ']' + maskedSrc.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);
    }
    while ((match = this.tokenizer.rules.inline.escapedEmSt.exec(maskedSrc)) != null) {
      maskedSrc = maskedSrc.slice(0, match.index) + '++' + maskedSrc.slice(this.tokenizer.rules.inline.escapedEmSt.lastIndex);
    }
    while (src) {
      if (!keepPrevChar) {
        prevChar = '';
      }
      keepPrevChar = false;
      if (this.options.extensions
        && this.options.extensions.inline
        && ( this.options.extensions.inline.some((extTokenizer) => {
          if (token = extTokenizer.call({ lexer: this }, src, tokens)) {
            src = src.substring(token.raw.length);
            tokens.push(token);
            return true;
          }
          return false;
        }))) {
        continue;
      }
      if (token = this.tokenizer.escape(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.tag(src)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && token.type === 'text' && lastToken.type === 'text') {
          lastToken.raw += token.raw;
          lastToken.text += token.text;
        } else {
          tokens.push(token);
        }
        continue;
      }
      if (token = this.tokenizer.link(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.reflink(src, this.tokens.links)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && token.type === 'text' && lastToken.type === 'text') {
          lastToken.raw += token.raw;
          lastToken.text += token.text;
        } else {
          tokens.push(token);
        }
        continue;
      }
      if (token = this.tokenizer.emStrong(src, maskedSrc, prevChar)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.codespan(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.br(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.del(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (token = this.tokenizer.autolink(src, mangle)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      if (!this.state.inLink && (token = this.tokenizer.url(src, mangle))) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }
      cutSrc = src;
      if (this.options.extensions && this.options.extensions.startInline) {
        let startIndex = Infinity;
        const tempSrc = src.slice(1);
        let tempStart;
        this.options.extensions.startInline.forEach(function(getStartIndex) {
          tempStart = getStartIndex.call({ lexer: this }, tempSrc);
          if (typeof tempStart === 'number' && tempStart >= 0) { startIndex = Math.min(startIndex, tempStart); }
        });
        if (startIndex < Infinity && startIndex >= 0) {
          cutSrc = src.substring(0, startIndex + 1);
        }
      }
      if (token = this.tokenizer.inlineText(cutSrc, smartypants)) {
        src = src.substring(token.raw.length);
        if (token.raw.slice(-1) !== '_') {
          prevChar = token.raw.slice(-1);
        }
        keepPrevChar = true;
        lastToken = tokens[tokens.length - 1];
        if (lastToken && lastToken.type === 'text') {
          lastToken.raw += token.raw;
          lastToken.text += token.text;
        } else {
          tokens.push(token);
        }
        continue;
      }
      if (src) {
        const errMsg = 'Infinite loop on byte: ' + src.charCodeAt(0);
        if (this.options.silent) {
          console.error(errMsg);
          break;
        } else {
          throw new Error(errMsg);
        }
      }
    }
    return tokens;
  }
};
const { defaults: defaults$2 } = defaults$5.exports;
const {
  cleanUrl,
  escape: escape$1
} = helpers;
var Renderer_1 = class Renderer {
  constructor(options) {
    this.options = options || defaults$2;
  }
  code(code, infostring, escaped) {
    const lang = (infostring || '').match(/\S*/)[0];
    if (this.options.highlight) {
      const out = this.options.highlight(code, lang);
      if (out != null && out !== code) {
        escaped = true;
        code = out;
      }
    }
    code = code.replace(/\n$/, '') + '\n';
    if (!lang) {
      return '<pre><code>'
        + (escaped ? code : escape$1(code, true))
        + '</code></pre>\n';
    }
    return '<pre><code class="'
      + this.options.langPrefix
      + escape$1(lang, true)
      + '">'
      + (escaped ? code : escape$1(code, true))
      + '</code></pre>\n';
  }
  blockquote(quote) {
    return '<blockquote>\n' + quote + '</blockquote>\n';
  }
  html(html) {
    return html;
  }
  heading(text, level, raw, slugger) {
    if (this.options.headerIds) {
      return '<h'
        + level
        + ' id="'
        + this.options.headerPrefix
        + slugger.slug(raw)
        + '">'
        + text
        + '</h'
        + level
        + '>\n';
    }
    return '<h' + level + '>' + text + '</h' + level + '>\n';
  }
  hr() {
    return this.options.xhtml ? '<hr/>\n' : '<hr>\n';
  }
  list(body, ordered, start) {
    const type = ordered ? 'ol' : 'ul',
      startatt = (ordered && start !== 1) ? (' start="' + start + '"') : '';
    return '<' + type + startatt + '>\n' + body + '</' + type + '>\n';
  }
  listitem(text) {
    return '<li>' + text + '</li>\n';
  }
  checkbox(checked) {
    return '<input '
      + (checked ? 'checked="" ' : '')
      + 'disabled="" type="checkbox"'
      + (this.options.xhtml ? ' /' : '')
      + '> ';
  }
  paragraph(text) {
    return '<p>' + text + '</p>\n';
  }
  table(header, body) {
    if (body) body = '<tbody>' + body + '</tbody>';
    return '<table>\n'
      + '<thead>\n'
      + header
      + '</thead>\n'
      + body
      + '</table>\n';
  }
  tablerow(content) {
    return '<tr>\n' + content + '</tr>\n';
  }
  tablecell(content, flags) {
    const type = flags.header ? 'th' : 'td';
    const tag = flags.align
      ? '<' + type + ' align="' + flags.align + '">'
      : '<' + type + '>';
    return tag + content + '</' + type + '>\n';
  }
  strong(text) {
    return '<strong>' + text + '</strong>';
  }
  em(text) {
    return '<em>' + text + '</em>';
  }
  codespan(text) {
    return '<code>' + text + '</code>';
  }
  br() {
    return this.options.xhtml ? '<br/>' : '<br>';
  }
  del(text) {
    return '<del>' + text + '</del>';
  }
  link(href, title, text) {
    href = cleanUrl(this.options.sanitize, this.options.baseUrl, href);
    if (href === null) {
      return text;
    }
    let out = '<a href="' + escape$1(href) + '"';
    if (title) {
      out += ' title="' + title + '"';
    }
    out += '>' + text + '</a>';
    return out;
  }
  image(href, title, text) {
    href = cleanUrl(this.options.sanitize, this.options.baseUrl, href);
    if (href === null) {
      return text;
    }
    let out = '<img src="' + href + '" alt="' + text + '"';
    if (title) {
      out += ' title="' + title + '"';
    }
    out += this.options.xhtml ? '/>' : '>';
    return out;
  }
  text(text) {
    return text;
  }
};
var TextRenderer_1 = class TextRenderer {
  strong(text) {
    return text;
  }
  em(text) {
    return text;
  }
  codespan(text) {
    return text;
  }
  del(text) {
    return text;
  }
  html(text) {
    return text;
  }
  text(text) {
    return text;
  }
  link(href, title, text) {
    return '' + text;
  }
  image(href, title, text) {
    return '' + text;
  }
  br() {
    return '';
  }
};
var Slugger_1 = class Slugger {
  constructor() {
    this.seen = {};
  }
  serialize(value) {
    return value
      .toLowerCase()
      .trim()
      .replace(/<[!\/a-z].*?>/ig, '')
      .replace(/[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,./:;<=>?@[\]^`{|}~]/g, '')
      .replace(/\s/g, '-');
  }
  getNextSafeSlug(originalSlug, isDryRun) {
    let slug = originalSlug;
    let occurenceAccumulator = 0;
    if (this.seen.hasOwnProperty(slug)) {
      occurenceAccumulator = this.seen[originalSlug];
      do {
        occurenceAccumulator++;
        slug = originalSlug + '-' + occurenceAccumulator;
      } while (this.seen.hasOwnProperty(slug));
    }
    if (!isDryRun) {
      this.seen[originalSlug] = occurenceAccumulator;
      this.seen[slug] = 0;
    }
    return slug;
  }
  slug(value, options = {}) {
    const slug = this.serialize(value);
    return this.getNextSafeSlug(slug, options.dryrun);
  }
};
const Renderer$1 = Renderer_1;
const TextRenderer$1 = TextRenderer_1;
const Slugger$1 = Slugger_1;
const { defaults: defaults$1 } = defaults$5.exports;
const {
  unescape
} = helpers;
var Parser_1 = class Parser {
  constructor(options) {
    this.options = options || defaults$1;
    this.options.renderer = this.options.renderer || new Renderer$1();
    this.renderer = this.options.renderer;
    this.renderer.options = this.options;
    this.textRenderer = new TextRenderer$1();
    this.slugger = new Slugger$1();
  }
  static parse(tokens, options) {
    const parser = new Parser(options);
    return parser.parse(tokens);
  }
  static parseInline(tokens, options) {
    const parser = new Parser(options);
    return parser.parseInline(tokens);
  }
  parse(tokens, top = true) {
    let out = '',
      i,
      j,
      k,
      l2,
      l3,
      row,
      cell,
      header,
      body,
      token,
      ordered,
      start,
      loose,
      itemBody,
      item,
      checked,
      task,
      checkbox,
      ret;
    const l = tokens.length;
    for (i = 0; i < l; i++) {
      token = tokens[i];
      if (this.options.extensions && this.options.extensions.renderers && this.options.extensions.renderers[token.type]) {
        ret = this.options.extensions.renderers[token.type].call({ parser: this }, token);
        if (ret !== false || !['space', 'hr', 'heading', 'code', 'table', 'blockquote', 'list', 'html', 'paragraph', 'text'].includes(token.type)) {
          out += ret || '';
          continue;
        }
      }
      switch (token.type) {
        case 'space': {
          continue;
        }
        case 'hr': {
          out += this.renderer.hr();
          continue;
        }
        case 'heading': {
          out += this.renderer.heading(
            this.parseInline(token.tokens),
            token.depth,
            unescape(this.parseInline(token.tokens, this.textRenderer)),
            this.slugger);
          continue;
        }
        case 'code': {
          out += this.renderer.code(token.text,
            token.lang,
            token.escaped);
          continue;
        }
        case 'table': {
          header = '';
          cell = '';
          l2 = token.header.length;
          for (j = 0; j < l2; j++) {
            cell += this.renderer.tablecell(
              this.parseInline(token.header[j].tokens),
              { header: true, align: token.align[j] }
            );
          }
          header += this.renderer.tablerow(cell);
          body = '';
          l2 = token.rows.length;
          for (j = 0; j < l2; j++) {
            row = token.rows[j];
            cell = '';
            l3 = row.length;
            for (k = 0; k < l3; k++) {
              cell += this.renderer.tablecell(
                this.parseInline(row[k].tokens),
                { header: false, align: token.align[k] }
              );
            }
            body += this.renderer.tablerow(cell);
          }
          out += this.renderer.table(header, body);
          continue;
        }
        case 'blockquote': {
          body = this.parse(token.tokens);
          out += this.renderer.blockquote(body);
          continue;
        }
        case 'list': {
          ordered = token.ordered;
          start = token.start;
          loose = token.loose;
          l2 = token.items.length;
          body = '';
          for (j = 0; j < l2; j++) {
            item = token.items[j];
            checked = item.checked;
            task = item.task;
            itemBody = '';
            if (item.task) {
              checkbox = this.renderer.checkbox(checked);
              if (loose) {
                if (item.tokens.length > 0 && item.tokens[0].type === 'paragraph') {
                  item.tokens[0].text = checkbox + ' ' + item.tokens[0].text;
                  if (item.tokens[0].tokens && item.tokens[0].tokens.length > 0 && item.tokens[0].tokens[0].type === 'text') {
                    item.tokens[0].tokens[0].text = checkbox + ' ' + item.tokens[0].tokens[0].text;
                  }
                } else {
                  item.tokens.unshift({
                    type: 'text',
                    text: checkbox
                  });
                }
              } else {
                itemBody += checkbox;
              }
            }
            itemBody += this.parse(item.tokens, loose);
            body += this.renderer.listitem(itemBody, task, checked);
          }
          out += this.renderer.list(body, ordered, start);
          continue;
        }
        case 'html': {
          out += this.renderer.html(token.text);
          continue;
        }
        case 'paragraph': {
          out += this.renderer.paragraph(this.parseInline(token.tokens));
          continue;
        }
        case 'text': {
          body = token.tokens ? this.parseInline(token.tokens) : token.text;
          while (i + 1 < l && tokens[i + 1].type === 'text') {
            token = tokens[++i];
            body += '\n' + (token.tokens ? this.parseInline(token.tokens) : token.text);
          }
          out += top ? this.renderer.paragraph(body) : body;
          continue;
        }
        default: {
          const errMsg = 'Token with "' + token.type + '" type was not found.';
          if (this.options.silent) {
            console.error(errMsg);
            return;
          } else {
            throw new Error(errMsg);
          }
        }
      }
    }
    return out;
  }
  parseInline(tokens, renderer) {
    renderer = renderer || this.renderer;
    let out = '',
      i,
      token,
      ret;
    const l = tokens.length;
    for (i = 0; i < l; i++) {
      token = tokens[i];
      if (this.options.extensions && this.options.extensions.renderers && this.options.extensions.renderers[token.type]) {
        ret = this.options.extensions.renderers[token.type].call({ parser: this }, token);
        if (ret !== false || !['escape', 'html', 'link', 'image', 'strong', 'em', 'codespan', 'br', 'del', 'text'].includes(token.type)) {
          out += ret || '';
          continue;
        }
      }
      switch (token.type) {
        case 'escape': {
          out += renderer.text(token.text);
          break;
        }
        case 'html': {
          out += renderer.html(token.text);
          break;
        }
        case 'link': {
          out += renderer.link(token.href, token.title, this.parseInline(token.tokens, renderer));
          break;
        }
        case 'image': {
          out += renderer.image(token.href, token.title, token.text);
          break;
        }
        case 'strong': {
          out += renderer.strong(this.parseInline(token.tokens, renderer));
          break;
        }
        case 'em': {
          out += renderer.em(this.parseInline(token.tokens, renderer));
          break;
        }
        case 'codespan': {
          out += renderer.codespan(token.text);
          break;
        }
        case 'br': {
          out += renderer.br();
          break;
        }
        case 'del': {
          out += renderer.del(this.parseInline(token.tokens, renderer));
          break;
        }
        case 'text': {
          out += renderer.text(token.text);
          break;
        }
        default: {
          const errMsg = 'Token with "' + token.type + '" type was not found.';
          if (this.options.silent) {
            console.error(errMsg);
            return;
          } else {
            throw new Error(errMsg);
          }
        }
      }
    }
    return out;
  }
};
const Lexer = Lexer_1;
const Parser = Parser_1;
const Tokenizer = Tokenizer_1;
const Renderer = Renderer_1;
const TextRenderer = TextRenderer_1;
const Slugger = Slugger_1;
const {
  merge,
  checkSanitizeDeprecation,
  escape
} = helpers;
const {
  getDefaults,
  changeDefaults,
  defaults
} = defaults$5.exports;
function marked(src, opt, callback) {
  if (typeof src === 'undefined' || src === null) {
    throw new Error('marked(): input parameter is undefined or null');
  }
  if (typeof src !== 'string') {
    throw new Error('marked(): input parameter is of type '
      + Object.prototype.toString.call(src) + ', string expected');
  }
  if (typeof opt === 'function') {
    callback = opt;
    opt = null;
  }
  opt = merge({}, marked.defaults, opt || {});
  checkSanitizeDeprecation(opt);
  if (callback) {
    const highlight = opt.highlight;
    let tokens;
    try {
      tokens = Lexer.lex(src, opt);
    } catch (e) {
      return callback(e);
    }
    const done = function(err) {
      let out;
      if (!err) {
        try {
          if (opt.walkTokens) {
            marked.walkTokens(tokens, opt.walkTokens);
          }
          out = Parser.parse(tokens, opt);
        } catch (e) {
          err = e;
        }
      }
      opt.highlight = highlight;
      return err
        ? callback(err)
        : callback(null, out);
    };
    if (!highlight || highlight.length < 3) {
      return done();
    }
    delete opt.highlight;
    if (!tokens.length) return done();
    let pending = 0;
    marked.walkTokens(tokens, function(token) {
      if (token.type === 'code') {
        pending++;
        setTimeout(() => {
          highlight(token.text, token.lang, function(err, code) {
            if (err) {
              return done(err);
            }
            if (code != null && code !== token.text) {
              token.text = code;
              token.escaped = true;
            }
            pending--;
            if (pending === 0) {
              done();
            }
          });
        }, 0);
      }
    });
    if (pending === 0) {
      done();
    }
    return;
  }
  try {
    const tokens = Lexer.lex(src, opt);
    if (opt.walkTokens) {
      marked.walkTokens(tokens, opt.walkTokens);
    }
    return Parser.parse(tokens, opt);
  } catch (e) {
    e.message += '\nPlease report this to https://github.com/markedjs/marked.';
    if (opt.silent) {
      return '<p>An error occurred:</p><pre>'
        + escape(e.message + '', true)
        + '</pre>';
    }
    throw e;
  }
}
marked.options =
marked.setOptions = function(opt) {
  merge(marked.defaults, opt);
  changeDefaults(marked.defaults);
  return marked;
};
marked.getDefaults = getDefaults;
marked.defaults = defaults;
marked.use = function(...args) {
  const opts = merge({}, ...args);
  const extensions = marked.defaults.extensions || { renderers: {}, childTokens: {} };
  let hasExtensions;
  args.forEach((pack) => {
    if (pack.extensions) {
      hasExtensions = true;
      pack.extensions.forEach((ext) => {
        if (!ext.name) {
          throw new Error('extension name required');
        }
        if (ext.renderer) {
          const prevRenderer = extensions.renderers ? extensions.renderers[ext.name] : null;
          if (prevRenderer) {
            extensions.renderers[ext.name] = function(...args) {
              let ret = ext.renderer.apply(this, args);
              if (ret === false) {
                ret = prevRenderer.apply(this, args);
              }
              return ret;
            };
          } else {
            extensions.renderers[ext.name] = ext.renderer;
          }
        }
        if (ext.tokenizer) {
          if (!ext.level || (ext.level !== 'block' && ext.level !== 'inline')) {
            throw new Error("extension level must be 'block' or 'inline'");
          }
          if (extensions[ext.level]) {
            extensions[ext.level].unshift(ext.tokenizer);
          } else {
            extensions[ext.level] = [ext.tokenizer];
          }
          if (ext.start) {
            if (ext.level === 'block') {
              if (extensions.startBlock) {
                extensions.startBlock.push(ext.start);
              } else {
                extensions.startBlock = [ext.start];
              }
            } else if (ext.level === 'inline') {
              if (extensions.startInline) {
                extensions.startInline.push(ext.start);
              } else {
                extensions.startInline = [ext.start];
              }
            }
          }
        }
        if (ext.childTokens) {
          extensions.childTokens[ext.name] = ext.childTokens;
        }
      });
    }
    if (pack.renderer) {
      const renderer = marked.defaults.renderer || new Renderer();
      for (const prop in pack.renderer) {
        const prevRenderer = renderer[prop];
        renderer[prop] = (...args) => {
          let ret = pack.renderer[prop].apply(renderer, args);
          if (ret === false) {
            ret = prevRenderer.apply(renderer, args);
          }
          return ret;
        };
      }
      opts.renderer = renderer;
    }
    if (pack.tokenizer) {
      const tokenizer = marked.defaults.tokenizer || new Tokenizer();
      for (const prop in pack.tokenizer) {
        const prevTokenizer = tokenizer[prop];
        tokenizer[prop] = (...args) => {
          let ret = pack.tokenizer[prop].apply(tokenizer, args);
          if (ret === false) {
            ret = prevTokenizer.apply(tokenizer, args);
          }
          return ret;
        };
      }
      opts.tokenizer = tokenizer;
    }
    if (pack.walkTokens) {
      const walkTokens = marked.defaults.walkTokens;
      opts.walkTokens = (token) => {
        pack.walkTokens.call(this, token);
        if (walkTokens) {
          walkTokens(token);
        }
      };
    }
    if (hasExtensions) {
      opts.extensions = extensions;
    }
    marked.setOptions(opts);
  });
};
marked.walkTokens = function(tokens, callback) {
  for (const token of tokens) {
    callback(token);
    switch (token.type) {
      case 'table': {
        for (const cell of token.header) {
          marked.walkTokens(cell.tokens, callback);
        }
        for (const row of token.rows) {
          for (const cell of row) {
            marked.walkTokens(cell.tokens, callback);
          }
        }
        break;
      }
      case 'list': {
        marked.walkTokens(token.items, callback);
        break;
      }
      default: {
        if (marked.defaults.extensions && marked.defaults.extensions.childTokens && marked.defaults.extensions.childTokens[token.type]) {
          marked.defaults.extensions.childTokens[token.type].forEach(function(childTokens) {
            marked.walkTokens(token[childTokens], callback);
          });
        } else if (token.tokens) {
          marked.walkTokens(token.tokens, callback);
        }
      }
    }
  }
};
marked.parseInline = function(src, opt) {
  if (typeof src === 'undefined' || src === null) {
    throw new Error('marked.parseInline(): input parameter is undefined or null');
  }
  if (typeof src !== 'string') {
    throw new Error('marked.parseInline(): input parameter is of type '
      + Object.prototype.toString.call(src) + ', string expected');
  }
  opt = merge({}, marked.defaults, opt || {});
  checkSanitizeDeprecation(opt);
  try {
    const tokens = Lexer.lexInline(src, opt);
    if (opt.walkTokens) {
      marked.walkTokens(tokens, opt.walkTokens);
    }
    return Parser.parseInline(tokens, opt);
  } catch (e) {
    e.message += '\nPlease report this to https://github.com/markedjs/marked.';
    if (opt.silent) {
      return '<p>An error occurred:</p><pre>'
        + escape(e.message + '', true)
        + '</pre>';
    }
    throw e;
  }
};
marked.Parser = Parser;
marked.parser = Parser.parse;
marked.Renderer = Renderer;
marked.TextRenderer = TextRenderer;
marked.Lexer = Lexer;
marked.lexer = Lexer.lex;
marked.Tokenizer = Tokenizer;
marked.Slugger = Slugger;
marked.parse = marked;
var marked_1 = marked;



/***/ }),

/***/ "./node_modules/vscode/external/vscode-semver/semver.js":
/*!**************************************************************!*\
  !*** ./node_modules/vscode/external/vscode-semver/semver.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   semverExports: () => (/* binding */ semverExports)
/* harmony export */ });
/* harmony import */ var _virtual_semver_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_virtual/semver.js */ "./node_modules/vscode/_virtual/semver.js");

(function (module, exports) {
	exports = module.exports = SemVer;
	 var debug;
	 if (typeof process === 'object' &&
	     process.env &&
	     process.env.NODE_DEBUG &&
	     /\bsemver\b/i.test(process.env.NODE_DEBUG))
	   debug = function() {
	     var args = Array.prototype.slice.call(arguments, 0);
	     args.unshift('SEMVER');
	     console.log.apply(console, args);
	     };
	 else
	   debug = function() {};
	exports.SEMVER_SPEC_VERSION = '2.0.0';
	var MAX_LENGTH = 256;
	var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
	var MAX_SAFE_COMPONENT_LENGTH = 16;
	var re = exports.re = [];
	var src = exports.src = [];
	var R = 0;
	var NUMERICIDENTIFIER = R++;
	src[NUMERICIDENTIFIER] = '0|[1-9]\\d*';
	var NUMERICIDENTIFIERLOOSE = R++;
	src[NUMERICIDENTIFIERLOOSE] = '[0-9]+';
	var NONNUMERICIDENTIFIER = R++;
	src[NONNUMERICIDENTIFIER] = '\\d*[a-zA-Z-][a-zA-Z0-9-]*';
	var MAINVERSION = R++;
	src[MAINVERSION] = '(' + src[NUMERICIDENTIFIER] + ')\\.' +
	                   '(' + src[NUMERICIDENTIFIER] + ')\\.' +
	                   '(' + src[NUMERICIDENTIFIER] + ')';
	var MAINVERSIONLOOSE = R++;
	src[MAINVERSIONLOOSE] = '(' + src[NUMERICIDENTIFIERLOOSE] + ')\\.' +
	                        '(' + src[NUMERICIDENTIFIERLOOSE] + ')\\.' +
	                        '(' + src[NUMERICIDENTIFIERLOOSE] + ')';
	var PRERELEASEIDENTIFIER = R++;
	src[PRERELEASEIDENTIFIER] = '(?:' + src[NUMERICIDENTIFIER] +
	                            '|' + src[NONNUMERICIDENTIFIER] + ')';
	var PRERELEASEIDENTIFIERLOOSE = R++;
	src[PRERELEASEIDENTIFIERLOOSE] = '(?:' + src[NUMERICIDENTIFIERLOOSE] +
	                                 '|' + src[NONNUMERICIDENTIFIER] + ')';
	var PRERELEASE = R++;
	src[PRERELEASE] = '(?:-(' + src[PRERELEASEIDENTIFIER] +
	                  '(?:\\.' + src[PRERELEASEIDENTIFIER] + ')*))';
	var PRERELEASELOOSE = R++;
	src[PRERELEASELOOSE] = '(?:-?(' + src[PRERELEASEIDENTIFIERLOOSE] +
	                       '(?:\\.' + src[PRERELEASEIDENTIFIERLOOSE] + ')*))';
	var BUILDIDENTIFIER = R++;
	src[BUILDIDENTIFIER] = '[0-9A-Za-z-]+';
	var BUILD = R++;
	src[BUILD] = '(?:\\+(' + src[BUILDIDENTIFIER] +
	             '(?:\\.' + src[BUILDIDENTIFIER] + ')*))';
	var FULL = R++;
	var FULLPLAIN = 'v?' + src[MAINVERSION] +
	                src[PRERELEASE] + '?' +
	                src[BUILD] + '?';
	src[FULL] = '^' + FULLPLAIN + '$';
	var LOOSEPLAIN = '[v=\\s]*' + src[MAINVERSIONLOOSE] +
	                 src[PRERELEASELOOSE] + '?' +
	                 src[BUILD] + '?';
	var LOOSE = R++;
	src[LOOSE] = '^' + LOOSEPLAIN + '$';
	var GTLT = R++;
	src[GTLT] = '((?:<|>)?=?)';
	var XRANGEIDENTIFIERLOOSE = R++;
	src[XRANGEIDENTIFIERLOOSE] = src[NUMERICIDENTIFIERLOOSE] + '|x|X|\\*';
	var XRANGEIDENTIFIER = R++;
	src[XRANGEIDENTIFIER] = src[NUMERICIDENTIFIER] + '|x|X|\\*';
	var XRANGEPLAIN = R++;
	src[XRANGEPLAIN] = '[v=\\s]*(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:\\.(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:\\.(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:' + src[PRERELEASE] + ')?' +
	                   src[BUILD] + '?' +
	                   ')?)?';
	var XRANGEPLAINLOOSE = R++;
	src[XRANGEPLAINLOOSE] = '[v=\\s]*(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:\\.(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:\\.(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:' + src[PRERELEASELOOSE] + ')?' +
	                        src[BUILD] + '?' +
	                        ')?)?';
	var XRANGE = R++;
	src[XRANGE] = '^' + src[GTLT] + '\\s*' + src[XRANGEPLAIN] + '$';
	var XRANGELOOSE = R++;
	src[XRANGELOOSE] = '^' + src[GTLT] + '\\s*' + src[XRANGEPLAINLOOSE] + '$';
	var COERCE = R++;
	src[COERCE] = '(?:^|[^\\d])' +
	              '(\\d{1,' + MAX_SAFE_COMPONENT_LENGTH + '})' +
	              '(?:\\.(\\d{1,' + MAX_SAFE_COMPONENT_LENGTH + '}))?' +
	              '(?:\\.(\\d{1,' + MAX_SAFE_COMPONENT_LENGTH + '}))?' +
	              '(?:$|[^\\d])';
	var LONETILDE = R++;
	src[LONETILDE] = '(?:~>?)';
	var TILDETRIM = R++;
	src[TILDETRIM] = '(\\s*)' + src[LONETILDE] + '\\s+';
	re[TILDETRIM] = new RegExp(src[TILDETRIM], 'g');
	var tildeTrimReplace = '$1~';
	var TILDE = R++;
	src[TILDE] = '^' + src[LONETILDE] + src[XRANGEPLAIN] + '$';
	var TILDELOOSE = R++;
	src[TILDELOOSE] = '^' + src[LONETILDE] + src[XRANGEPLAINLOOSE] + '$';
	var LONECARET = R++;
	src[LONECARET] = '(?:\\^)';
	var CARETTRIM = R++;
	src[CARETTRIM] = '(\\s*)' + src[LONECARET] + '\\s+';
	re[CARETTRIM] = new RegExp(src[CARETTRIM], 'g');
	var caretTrimReplace = '$1^';
	var CARET = R++;
	src[CARET] = '^' + src[LONECARET] + src[XRANGEPLAIN] + '$';
	var CARETLOOSE = R++;
	src[CARETLOOSE] = '^' + src[LONECARET] + src[XRANGEPLAINLOOSE] + '$';
	var COMPARATORLOOSE = R++;
	src[COMPARATORLOOSE] = '^' + src[GTLT] + '\\s*(' + LOOSEPLAIN + ')$|^$';
	var COMPARATOR = R++;
	src[COMPARATOR] = '^' + src[GTLT] + '\\s*(' + FULLPLAIN + ')$|^$';
	var COMPARATORTRIM = R++;
	src[COMPARATORTRIM] = '(\\s*)' + src[GTLT] +
	                      '\\s*(' + LOOSEPLAIN + '|' + src[XRANGEPLAIN] + ')';
	re[COMPARATORTRIM] = new RegExp(src[COMPARATORTRIM], 'g');
	var comparatorTrimReplace = '$1$2$3';
	var HYPHENRANGE = R++;
	src[HYPHENRANGE] = '^\\s*(' + src[XRANGEPLAIN] + ')' +
	                   '\\s+-\\s+' +
	                   '(' + src[XRANGEPLAIN] + ')' +
	                   '\\s*$';
	var HYPHENRANGELOOSE = R++;
	src[HYPHENRANGELOOSE] = '^\\s*(' + src[XRANGEPLAINLOOSE] + ')' +
	                        '\\s+-\\s+' +
	                        '(' + src[XRANGEPLAINLOOSE] + ')' +
	                        '\\s*$';
	var STAR = R++;
	src[STAR] = '(<|>)?=?\\s*\\*';
	for (var i = 0; i < R; i++) {
	  debug(i, src[i]);
	  if (!re[i])
	    re[i] = new RegExp(src[i]);
	}
	exports.parse = parse;
	function parse(version, loose) {
	  if (version instanceof SemVer)
	    return version;
	  if (typeof version !== 'string')
	    return null;
	  if (version.length > MAX_LENGTH)
	    return null;
	  var r = loose ? re[LOOSE] : re[FULL];
	  if (!r.test(version))
	    return null;
	  try {
	    return new SemVer(version, loose);
	  } catch (er) {
	    return null;
	  }
	}
	exports.valid = valid;
	function valid(version, loose) {
	  var v = parse(version, loose);
	  return v ? v.version : null;
	}
	exports.clean = clean;
	function clean(version, loose) {
	  var s = parse(version.trim().replace(/^[=v]+/, ''), loose);
	  return s ? s.version : null;
	}
	exports.SemVer = SemVer;
	function SemVer(version, loose) {
	  if (version instanceof SemVer) {
	    if (version.loose === loose)
	      return version;
	    else
	      version = version.version;
	  } else if (typeof version !== 'string') {
	    throw new TypeError('Invalid Version: ' + version);
	  }
	  if (version.length > MAX_LENGTH)
	    throw new TypeError('version is longer than ' + MAX_LENGTH + ' characters')
	  if (!(this instanceof SemVer))
	    return new SemVer(version, loose);
	  debug('SemVer', version, loose);
	  this.loose = loose;
	  var m = version.trim().match(loose ? re[LOOSE] : re[FULL]);
	  if (!m)
	    throw new TypeError('Invalid Version: ' + version);
	  this.raw = version;
	  this.major = +m[1];
	  this.minor = +m[2];
	  this.patch = +m[3];
	  if (this.major > MAX_SAFE_INTEGER || this.major < 0)
	    throw new TypeError('Invalid major version')
	  if (this.minor > MAX_SAFE_INTEGER || this.minor < 0)
	    throw new TypeError('Invalid minor version')
	  if (this.patch > MAX_SAFE_INTEGER || this.patch < 0)
	    throw new TypeError('Invalid patch version')
	  if (!m[4])
	    this.prerelease = [];
	  else
	    this.prerelease = m[4].split('.').map(function(id) {
	      if (/^[0-9]+$/.test(id)) {
	        var num = +id;
	        if (num >= 0 && num < MAX_SAFE_INTEGER)
	          return num;
	      }
	      return id;
	    });
	  this.build = m[5] ? m[5].split('.') : [];
	  this.format();
	}
	SemVer.prototype.format = function() {
	  this.version = this.major + '.' + this.minor + '.' + this.patch;
	  if (this.prerelease.length)
	    this.version += '-' + this.prerelease.join('.');
	  return this.version;
	};
	SemVer.prototype.toString = function() {
	  return this.version;
	};
	SemVer.prototype.compare = function(other) {
	  debug('SemVer.compare', this.version, this.loose, other);
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);
	  return this.compareMain(other) || this.comparePre(other);
	};
	SemVer.prototype.compareMain = function(other) {
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);
	  return compareIdentifiers(this.major, other.major) ||
	         compareIdentifiers(this.minor, other.minor) ||
	         compareIdentifiers(this.patch, other.patch);
	};
	SemVer.prototype.comparePre = function(other) {
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);
	  if (this.prerelease.length && !other.prerelease.length)
	    return -1;
	  else if (!this.prerelease.length && other.prerelease.length)
	    return 1;
	  else if (!this.prerelease.length && !other.prerelease.length)
	    return 0;
	  var i = 0;
	  do {
	    var a = this.prerelease[i];
	    var b = other.prerelease[i];
	    debug('prerelease compare', i, a, b);
	    if (a === undefined && b === undefined)
	      return 0;
	    else if (b === undefined)
	      return 1;
	    else if (a === undefined)
	      return -1;
	    else if (a === b)
	      continue;
	    else
	      return compareIdentifiers(a, b);
	  } while (++i);
	};
	SemVer.prototype.inc = function(release, identifier) {
	  switch (release) {
	    case 'premajor':
	      this.prerelease.length = 0;
	      this.patch = 0;
	      this.minor = 0;
	      this.major++;
	      this.inc('pre', identifier);
	      break;
	    case 'preminor':
	      this.prerelease.length = 0;
	      this.patch = 0;
	      this.minor++;
	      this.inc('pre', identifier);
	      break;
	    case 'prepatch':
	      this.prerelease.length = 0;
	      this.inc('patch', identifier);
	      this.inc('pre', identifier);
	      break;
	    case 'prerelease':
	      if (this.prerelease.length === 0)
	        this.inc('patch', identifier);
	      this.inc('pre', identifier);
	      break;
	    case 'major':
	      if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0)
	        this.major++;
	      this.minor = 0;
	      this.patch = 0;
	      this.prerelease = [];
	      break;
	    case 'minor':
	      if (this.patch !== 0 || this.prerelease.length === 0)
	        this.minor++;
	      this.patch = 0;
	      this.prerelease = [];
	      break;
	    case 'patch':
	      if (this.prerelease.length === 0)
	        this.patch++;
	      this.prerelease = [];
	      break;
	    case 'pre':
	      if (this.prerelease.length === 0)
	        this.prerelease = [0];
	      else {
	        var i = this.prerelease.length;
	        while (--i >= 0) {
	          if (typeof this.prerelease[i] === 'number') {
	            this.prerelease[i]++;
	            i = -2;
	          }
	        }
	        if (i === -1)
	          this.prerelease.push(0);
	      }
	      if (identifier) {
	        if (this.prerelease[0] === identifier) {
	          if (isNaN(this.prerelease[1]))
	            this.prerelease = [identifier, 0];
	        } else
	          this.prerelease = [identifier, 0];
	      }
	      break;
	    default:
	      throw new Error('invalid increment argument: ' + release);
	  }
	  this.format();
	  this.raw = this.version;
	  return this;
	};
	exports.inc = inc;
	function inc(version, release, loose, identifier) {
	  if (typeof(loose) === 'string') {
	    identifier = loose;
	    loose = undefined;
	  }
	  try {
	    return new SemVer(version, loose).inc(release, identifier).version;
	  } catch (er) {
	    return null;
	  }
	}
	exports.diff = diff;
	function diff(version1, version2) {
	  if (eq(version1, version2)) {
	    return null;
	  } else {
	    var v1 = parse(version1);
	    var v2 = parse(version2);
	    if (v1.prerelease.length || v2.prerelease.length) {
	      for (var key in v1) {
	        if (key === 'major' || key === 'minor' || key === 'patch') {
	          if (v1[key] !== v2[key]) {
	            return 'pre'+key;
	          }
	        }
	      }
	      return 'prerelease';
	    }
	    for (var key in v1) {
	      if (key === 'major' || key === 'minor' || key === 'patch') {
	        if (v1[key] !== v2[key]) {
	          return key;
	        }
	      }
	    }
	  }
	}
	exports.compareIdentifiers = compareIdentifiers;
	var numeric = /^[0-9]+$/;
	function compareIdentifiers(a, b) {
	  var anum = numeric.test(a);
	  var bnum = numeric.test(b);
	  if (anum && bnum) {
	    a = +a;
	    b = +b;
	  }
	  return (anum && !bnum) ? -1 :
	         (bnum && !anum) ? 1 :
	         a < b ? -1 :
	         a > b ? 1 :
	         0;
	}
	exports.rcompareIdentifiers = rcompareIdentifiers;
	function rcompareIdentifiers(a, b) {
	  return compareIdentifiers(b, a);
	}
	exports.major = major;
	function major(a, loose) {
	  return new SemVer(a, loose).major;
	}
	exports.minor = minor;
	function minor(a, loose) {
	  return new SemVer(a, loose).minor;
	}
	exports.patch = patch;
	function patch(a, loose) {
	  return new SemVer(a, loose).patch;
	}
	exports.compare = compare;
	function compare(a, b, loose) {
	  return new SemVer(a, loose).compare(new SemVer(b, loose));
	}
	exports.compareLoose = compareLoose;
	function compareLoose(a, b) {
	  return compare(a, b, true);
	}
	exports.rcompare = rcompare;
	function rcompare(a, b, loose) {
	  return compare(b, a, loose);
	}
	exports.sort = sort;
	function sort(list, loose) {
	  return list.sort(function(a, b) {
	    return exports.compare(a, b, loose);
	  });
	}
	exports.rsort = rsort;
	function rsort(list, loose) {
	  return list.sort(function(a, b) {
	    return exports.rcompare(a, b, loose);
	  });
	}
	exports.gt = gt;
	function gt(a, b, loose) {
	  return compare(a, b, loose) > 0;
	}
	exports.lt = lt;
	function lt(a, b, loose) {
	  return compare(a, b, loose) < 0;
	}
	exports.eq = eq;
	function eq(a, b, loose) {
	  return compare(a, b, loose) === 0;
	}
	exports.neq = neq;
	function neq(a, b, loose) {
	  return compare(a, b, loose) !== 0;
	}
	exports.gte = gte;
	function gte(a, b, loose) {
	  return compare(a, b, loose) >= 0;
	}
	exports.lte = lte;
	function lte(a, b, loose) {
	  return compare(a, b, loose) <= 0;
	}
	exports.cmp = cmp;
	function cmp(a, op, b, loose) {
	  var ret;
	  switch (op) {
	    case '===':
	      if (typeof a === 'object') a = a.version;
	      if (typeof b === 'object') b = b.version;
	      ret = a === b;
	      break;
	    case '!==':
	      if (typeof a === 'object') a = a.version;
	      if (typeof b === 'object') b = b.version;
	      ret = a !== b;
	      break;
	    case '': case '=': case '==': ret = eq(a, b, loose); break;
	    case '!=': ret = neq(a, b, loose); break;
	    case '>': ret = gt(a, b, loose); break;
	    case '>=': ret = gte(a, b, loose); break;
	    case '<': ret = lt(a, b, loose); break;
	    case '<=': ret = lte(a, b, loose); break;
	    default: throw new TypeError('Invalid operator: ' + op);
	  }
	  return ret;
	}
	exports.Comparator = Comparator;
	function Comparator(comp, loose) {
	  if (comp instanceof Comparator) {
	    if (comp.loose === loose)
	      return comp;
	    else
	      comp = comp.value;
	  }
	  if (!(this instanceof Comparator))
	    return new Comparator(comp, loose);
	  debug('comparator', comp, loose);
	  this.loose = loose;
	  this.parse(comp);
	  if (this.semver === ANY)
	    this.value = '';
	  else
	    this.value = this.operator + this.semver.version;
	  debug('comp', this);
	}
	var ANY = {};
	Comparator.prototype.parse = function(comp) {
	  var r = this.loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
	  var m = comp.match(r);
	  if (!m)
	    throw new TypeError('Invalid comparator: ' + comp);
	  this.operator = m[1];
	  if (this.operator === '=')
	    this.operator = '';
	  if (!m[2])
	    this.semver = ANY;
	  else
	    this.semver = new SemVer(m[2], this.loose);
	};
	Comparator.prototype.toString = function() {
	  return this.value;
	};
	Comparator.prototype.test = function(version) {
	  debug('Comparator.test', version, this.loose);
	  if (this.semver === ANY)
	    return true;
	  if (typeof version === 'string')
	    version = new SemVer(version, this.loose);
	  return cmp(version, this.operator, this.semver, this.loose);
	};
	Comparator.prototype.intersects = function(comp, loose) {
	  if (!(comp instanceof Comparator)) {
	    throw new TypeError('a Comparator is required');
	  }
	  var rangeTmp;
	  if (this.operator === '') {
	    rangeTmp = new Range(comp.value, loose);
	    return satisfies(this.value, rangeTmp, loose);
	  } else if (comp.operator === '') {
	    rangeTmp = new Range(this.value, loose);
	    return satisfies(comp.semver, rangeTmp, loose);
	  }
	  var sameDirectionIncreasing =
	    (this.operator === '>=' || this.operator === '>') &&
	    (comp.operator === '>=' || comp.operator === '>');
	  var sameDirectionDecreasing =
	    (this.operator === '<=' || this.operator === '<') &&
	    (comp.operator === '<=' || comp.operator === '<');
	  var sameSemVer = this.semver.version === comp.semver.version;
	  var differentDirectionsInclusive =
	    (this.operator === '>=' || this.operator === '<=') &&
	    (comp.operator === '>=' || comp.operator === '<=');
	  var oppositeDirectionsLessThan =
	    cmp(this.semver, '<', comp.semver, loose) &&
	    ((this.operator === '>=' || this.operator === '>') &&
	    (comp.operator === '<=' || comp.operator === '<'));
	  var oppositeDirectionsGreaterThan =
	    cmp(this.semver, '>', comp.semver, loose) &&
	    ((this.operator === '<=' || this.operator === '<') &&
	    (comp.operator === '>=' || comp.operator === '>'));
	  return sameDirectionIncreasing || sameDirectionDecreasing ||
	    (sameSemVer && differentDirectionsInclusive) ||
	    oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
	};
	exports.Range = Range;
	function Range(range, loose) {
	  if (range instanceof Range) {
	    if (range.loose === loose) {
	      return range;
	    } else {
	      return new Range(range.raw, loose);
	    }
	  }
	  if (range instanceof Comparator) {
	    return new Range(range.value, loose);
	  }
	  if (!(this instanceof Range))
	    return new Range(range, loose);
	  this.loose = loose;
	  this.raw = range;
	  this.set = range.split(/\s*\|\|\s*/).map(function(range) {
	    return this.parseRange(range.trim());
	  }, this).filter(function(c) {
	    return c.length;
	  });
	  if (!this.set.length) {
	    throw new TypeError('Invalid SemVer Range: ' + range);
	  }
	  this.format();
	}
	Range.prototype.format = function() {
	  this.range = this.set.map(function(comps) {
	    return comps.join(' ').trim();
	  }).join('||').trim();
	  return this.range;
	};
	Range.prototype.toString = function() {
	  return this.range;
	};
	Range.prototype.parseRange = function(range) {
	  var loose = this.loose;
	  range = range.trim();
	  debug('range', range, loose);
	  var hr = loose ? re[HYPHENRANGELOOSE] : re[HYPHENRANGE];
	  range = range.replace(hr, hyphenReplace);
	  debug('hyphen replace', range);
	  range = range.replace(re[COMPARATORTRIM], comparatorTrimReplace);
	  debug('comparator trim', range, re[COMPARATORTRIM]);
	  range = range.replace(re[TILDETRIM], tildeTrimReplace);
	  range = range.replace(re[CARETTRIM], caretTrimReplace);
	  range = range.split(/\s+/).join(' ');
	  var compRe = loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
	  var set = range.split(' ').map(function(comp) {
	    return parseComparator(comp, loose);
	  }).join(' ').split(/\s+/);
	  if (this.loose) {
	    set = set.filter(function(comp) {
	      return !!comp.match(compRe);
	    });
	  }
	  set = set.map(function(comp) {
	    return new Comparator(comp, loose);
	  });
	  return set;
	};
	Range.prototype.intersects = function(range, loose) {
	  if (!(range instanceof Range)) {
	    throw new TypeError('a Range is required');
	  }
	  return this.set.some(function(thisComparators) {
	    return thisComparators.every(function(thisComparator) {
	      return range.set.some(function(rangeComparators) {
	        return rangeComparators.every(function(rangeComparator) {
	          return thisComparator.intersects(rangeComparator, loose);
	        });
	      });
	    });
	  });
	};
	exports.toComparators = toComparators;
	function toComparators(range, loose) {
	  return new Range(range, loose).set.map(function(comp) {
	    return comp.map(function(c) {
	      return c.value;
	    }).join(' ').trim().split(' ');
	  });
	}
	function parseComparator(comp, loose) {
	  debug('comp', comp);
	  comp = replaceCarets(comp, loose);
	  debug('caret', comp);
	  comp = replaceTildes(comp, loose);
	  debug('tildes', comp);
	  comp = replaceXRanges(comp, loose);
	  debug('xrange', comp);
	  comp = replaceStars(comp, loose);
	  debug('stars', comp);
	  return comp;
	}
	function isX(id) {
	  return !id || id.toLowerCase() === 'x' || id === '*';
	}
	function replaceTildes(comp, loose) {
	  return comp.trim().split(/\s+/).map(function(comp) {
	    return replaceTilde(comp, loose);
	  }).join(' ');
	}
	function replaceTilde(comp, loose) {
	  var r = loose ? re[TILDELOOSE] : re[TILDE];
	  return comp.replace(r, function(_, M, m, p, pr) {
	    debug('tilde', comp, _, M, m, p, pr);
	    var ret;
	    if (isX(M))
	      ret = '';
	    else if (isX(m))
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    else if (isX(p))
	      ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	    else if (pr) {
	      debug('replaceTilde pr', pr);
	      if (pr.charAt(0) !== '-')
	        pr = '-' + pr;
	      ret = '>=' + M + '.' + m + '.' + p + pr +
	            ' <' + M + '.' + (+m + 1) + '.0';
	    } else
	      ret = '>=' + M + '.' + m + '.' + p +
	            ' <' + M + '.' + (+m + 1) + '.0';
	    debug('tilde return', ret);
	    return ret;
	  });
	}
	function replaceCarets(comp, loose) {
	  return comp.trim().split(/\s+/).map(function(comp) {
	    return replaceCaret(comp, loose);
	  }).join(' ');
	}
	function replaceCaret(comp, loose) {
	  debug('caret', comp, loose);
	  var r = loose ? re[CARETLOOSE] : re[CARET];
	  return comp.replace(r, function(_, M, m, p, pr) {
	    debug('caret', comp, _, M, m, p, pr);
	    var ret;
	    if (isX(M))
	      ret = '';
	    else if (isX(m))
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    else if (isX(p)) {
	      if (M === '0')
	        ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	      else
	        ret = '>=' + M + '.' + m + '.0 <' + (+M + 1) + '.0.0';
	    } else if (pr) {
	      debug('replaceCaret pr', pr);
	      if (pr.charAt(0) !== '-')
	        pr = '-' + pr;
	      if (M === '0') {
	        if (m === '0')
	          ret = '>=' + M + '.' + m + '.' + p + pr +
	                ' <' + M + '.' + m + '.' + (+p + 1);
	        else
	          ret = '>=' + M + '.' + m + '.' + p + pr +
	                ' <' + M + '.' + (+m + 1) + '.0';
	      } else
	        ret = '>=' + M + '.' + m + '.' + p + pr +
	              ' <' + (+M + 1) + '.0.0';
	    } else {
	      debug('no pr');
	      if (M === '0') {
	        if (m === '0')
	          ret = '>=' + M + '.' + m + '.' + p +
	                ' <' + M + '.' + m + '.' + (+p + 1);
	        else
	          ret = '>=' + M + '.' + m + '.' + p +
	                ' <' + M + '.' + (+m + 1) + '.0';
	      } else
	        ret = '>=' + M + '.' + m + '.' + p +
	              ' <' + (+M + 1) + '.0.0';
	    }
	    debug('caret return', ret);
	    return ret;
	  });
	}
	function replaceXRanges(comp, loose) {
	  debug('replaceXRanges', comp, loose);
	  return comp.split(/\s+/).map(function(comp) {
	    return replaceXRange(comp, loose);
	  }).join(' ');
	}
	function replaceXRange(comp, loose) {
	  comp = comp.trim();
	  var r = loose ? re[XRANGELOOSE] : re[XRANGE];
	  return comp.replace(r, function(ret, gtlt, M, m, p, pr) {
	    debug('xRange', comp, ret, gtlt, M, m, p, pr);
	    var xM = isX(M);
	    var xm = xM || isX(m);
	    var xp = xm || isX(p);
	    var anyX = xp;
	    if (gtlt === '=' && anyX)
	      gtlt = '';
	    if (xM) {
	      if (gtlt === '>' || gtlt === '<') {
	        ret = '<0.0.0';
	      } else {
	        ret = '*';
	      }
	    } else if (gtlt && anyX) {
	      if (xm)
	        m = 0;
	      if (xp)
	        p = 0;
	      if (gtlt === '>') {
	        gtlt = '>=';
	        if (xm) {
	          M = +M + 1;
	          m = 0;
	          p = 0;
	        } else if (xp) {
	          m = +m + 1;
	          p = 0;
	        }
	      } else if (gtlt === '<=') {
	        gtlt = '<';
	        if (xm)
	          M = +M + 1;
	        else
	          m = +m + 1;
	      }
	      ret = gtlt + M + '.' + m + '.' + p;
	    } else if (xm) {
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    } else if (xp) {
	      ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	    }
	    debug('xRange return', ret);
	    return ret;
	  });
	}
	function replaceStars(comp, loose) {
	  debug('replaceStars', comp, loose);
	  return comp.trim().replace(re[STAR], '');
	}
	function hyphenReplace($0,
	                       from, fM, fm, fp, fpr, fb,
	                       to, tM, tm, tp, tpr, tb) {
	  if (isX(fM))
	    from = '';
	  else if (isX(fm))
	    from = '>=' + fM + '.0.0';
	  else if (isX(fp))
	    from = '>=' + fM + '.' + fm + '.0';
	  else
	    from = '>=' + from;
	  if (isX(tM))
	    to = '';
	  else if (isX(tm))
	    to = '<' + (+tM + 1) + '.0.0';
	  else if (isX(tp))
	    to = '<' + tM + '.' + (+tm + 1) + '.0';
	  else if (tpr)
	    to = '<=' + tM + '.' + tm + '.' + tp + '-' + tpr;
	  else
	    to = '<=' + to;
	  return (from + ' ' + to).trim();
	}
	Range.prototype.test = function(version) {
	  if (!version)
	    return false;
	  if (typeof version === 'string')
	    version = new SemVer(version, this.loose);
	  for (var i = 0; i < this.set.length; i++) {
	    if (testSet(this.set[i], version))
	      return true;
	  }
	  return false;
	};
	function testSet(set, version) {
	  for (var i = 0; i < set.length; i++) {
	    if (!set[i].test(version))
	      return false;
	  }
	  if (version.prerelease.length) {
	    for (var i = 0; i < set.length; i++) {
	      debug(set[i].semver);
	      if (set[i].semver === ANY)
	        continue;
	      if (set[i].semver.prerelease.length > 0) {
	        var allowed = set[i].semver;
	        if (allowed.major === version.major &&
	            allowed.minor === version.minor &&
	            allowed.patch === version.patch)
	          return true;
	      }
	    }
	    return false;
	  }
	  return true;
	}
	exports.satisfies = satisfies;
	function satisfies(version, range, loose) {
	  try {
	    range = new Range(range, loose);
	  } catch (er) {
	    return false;
	  }
	  return range.test(version);
	}
	exports.maxSatisfying = maxSatisfying;
	function maxSatisfying(versions, range, loose) {
	  var max = null;
	  var maxSV = null;
	  try {
	    var rangeObj = new Range(range, loose);
	  } catch (er) {
	    return null;
	  }
	  versions.forEach(function (v) {
	    if (rangeObj.test(v)) {
	      if (!max || maxSV.compare(v) === -1) {
	        max = v;
	        maxSV = new SemVer(max, loose);
	      }
	    }
	  });
	  return max;
	}
	exports.minSatisfying = minSatisfying;
	function minSatisfying(versions, range, loose) {
	  var min = null;
	  var minSV = null;
	  try {
	    var rangeObj = new Range(range, loose);
	  } catch (er) {
	    return null;
	  }
	  versions.forEach(function (v) {
	    if (rangeObj.test(v)) {
	      if (!min || minSV.compare(v) === 1) {
	        min = v;
	        minSV = new SemVer(min, loose);
	      }
	    }
	  });
	  return min;
	}
	exports.validRange = validRange;
	function validRange(range, loose) {
	  try {
	    return new Range(range, loose).range || '*';
	  } catch (er) {
	    return null;
	  }
	}
	exports.ltr = ltr;
	function ltr(version, range, loose) {
	  return outside(version, range, '<', loose);
	}
	exports.gtr = gtr;
	function gtr(version, range, loose) {
	  return outside(version, range, '>', loose);
	}
	exports.outside = outside;
	function outside(version, range, hilo, loose) {
	  version = new SemVer(version, loose);
	  range = new Range(range, loose);
	  var gtfn, ltefn, ltfn, comp, ecomp;
	  switch (hilo) {
	    case '>':
	      gtfn = gt;
	      ltefn = lte;
	      ltfn = lt;
	      comp = '>';
	      ecomp = '>=';
	      break;
	    case '<':
	      gtfn = lt;
	      ltefn = gte;
	      ltfn = gt;
	      comp = '<';
	      ecomp = '<=';
	      break;
	    default:
	      throw new TypeError('Must provide a hilo val of "<" or ">"');
	  }
	  if (satisfies(version, range, loose)) {
	    return false;
	  }
	  for (var i = 0; i < range.set.length; ++i) {
	    var comparators = range.set[i];
	    var high = null;
	    var low = null;
	    comparators.forEach(function(comparator) {
	      if (comparator.semver === ANY) {
	        comparator = new Comparator('>=0.0.0');
	      }
	      high = high || comparator;
	      low = low || comparator;
	      if (gtfn(comparator.semver, high.semver, loose)) {
	        high = comparator;
	      } else if (ltfn(comparator.semver, low.semver, loose)) {
	        low = comparator;
	      }
	    });
	    if (high.operator === comp || high.operator === ecomp) {
	      return false;
	    }
	    if ((!low.operator || low.operator === comp) &&
	        ltefn(version, low.semver)) {
	      return false;
	    } else if (low.operator === ecomp && ltfn(version, low.semver)) {
	      return false;
	    }
	  }
	  return true;
	}
	exports.prerelease = prerelease;
	function prerelease(version, loose) {
	  var parsed = parse(version, loose);
	  return (parsed && parsed.prerelease.length) ? parsed.prerelease : null;
	}
	exports.intersects = intersects;
	function intersects(r1, r2, loose) {
	  r1 = new Range(r1, loose);
	  r2 = new Range(r2, loose);
	  return r1.intersects(r2)
	}
	exports.coerce = coerce;
	function coerce(version) {
	  if (version instanceof SemVer)
	    return version;
	  if (typeof version !== 'string')
	    return null;
	  var match = version.match(re[COERCE]);
	  if (match == null)
	    return null;
	  return parse((match[1] || '0') + '.' + (match[2] || '0') + '.' + (match[3] || '0'));
	}
} (_virtual_semver_js__WEBPACK_IMPORTED_MODULE_0__.__module, _virtual_semver_js__WEBPACK_IMPORTED_MODULE_0__.__module.exports));
var semverExports = _virtual_semver_js__WEBPACK_IMPORTED_MODULE_0__.__module.exports;



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/actions.js":
/*!******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/actions.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Action: () => (/* binding */ Action),
/* harmony export */   ActionRunner: () => (/* binding */ ActionRunner),
/* harmony export */   EmptySubmenuAction: () => (/* binding */ EmptySubmenuAction),
/* harmony export */   Separator: () => (/* binding */ Separator),
/* harmony export */   SubmenuAction: () => (/* binding */ SubmenuAction),
/* harmony export */   toAction: () => (/* binding */ toAction)
/* harmony export */ });
/* harmony import */ var _event_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _lifecycle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");
/* harmony import */ var _nls_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../nls.js */ "./node_modules/vscode/vscode/src/vs/nls.js");



const _moduleId = "vs/base/common/actions";
class Action extends _lifecycle_js__WEBPACK_IMPORTED_MODULE_1__.Disposable {
    constructor(id, label = '', cssClass = '', enabled = true, actionCallback) {
        super();
        this._onDidChange = this._register(( (new _event_js__WEBPACK_IMPORTED_MODULE_0__.Emitter())));
        this.onDidChange = this._onDidChange.event;
        this._enabled = true;
        this._id = id;
        this._label = label;
        this._cssClass = cssClass;
        this._enabled = enabled;
        this._actionCallback = actionCallback;
    }
    get id() {
        return this._id;
    }
    get label() {
        return this._label;
    }
    set label(value) {
        this._setLabel(value);
    }
    _setLabel(value) {
        if (this._label !== value) {
            this._label = value;
            this._onDidChange.fire({ label: value });
        }
    }
    get tooltip() {
        return this._tooltip || '';
    }
    set tooltip(value) {
        this._setTooltip(value);
    }
    _setTooltip(value) {
        if (this._tooltip !== value) {
            this._tooltip = value;
            this._onDidChange.fire({ tooltip: value });
        }
    }
    get class() {
        return this._cssClass;
    }
    set class(value) {
        this._setClass(value);
    }
    _setClass(value) {
        if (this._cssClass !== value) {
            this._cssClass = value;
            this._onDidChange.fire({ class: value });
        }
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        this._setEnabled(value);
    }
    _setEnabled(value) {
        if (this._enabled !== value) {
            this._enabled = value;
            this._onDidChange.fire({ enabled: value });
        }
    }
    get checked() {
        return this._checked;
    }
    set checked(value) {
        this._setChecked(value);
    }
    _setChecked(value) {
        if (this._checked !== value) {
            this._checked = value;
            this._onDidChange.fire({ checked: value });
        }
    }
    async run(event, data) {
        if (this._actionCallback) {
            await this._actionCallback(event);
        }
    }
}
class ActionRunner extends _lifecycle_js__WEBPACK_IMPORTED_MODULE_1__.Disposable {
    constructor() {
        super(...arguments);
        this._onWillRun = this._register(( (new _event_js__WEBPACK_IMPORTED_MODULE_0__.Emitter())));
        this.onWillRun = this._onWillRun.event;
        this._onDidRun = this._register(( (new _event_js__WEBPACK_IMPORTED_MODULE_0__.Emitter())));
        this.onDidRun = this._onDidRun.event;
    }
    async run(action, context) {
        if (!action.enabled) {
            return;
        }
        this._onWillRun.fire({ action });
        let error = undefined;
        try {
            await this.runAction(action, context);
        }
        catch (e) {
            error = e;
        }
        this._onDidRun.fire({ action, error });
    }
    async runAction(action, context) {
        await action.run(context);
    }
}
class Separator {
    constructor() {
        this.id = Separator.ID;
        this.label = '';
        this.tooltip = '';
        this.class = 'separator';
        this.enabled = false;
        this.checked = false;
    }
    static join(...actionLists) {
        let out = [];
        for (const list of actionLists) {
            if (!list.length) ;
            else if (out.length) {
                out = [...out, ( (new Separator())), ...list];
            }
            else {
                out = list;
            }
        }
        return out;
    }
    static { this.ID = 'vs.actions.separator'; }
    async run() { }
}
class SubmenuAction {
    get actions() { return this._actions; }
    constructor(id, label, actions, cssClass) {
        this.tooltip = '';
        this.enabled = true;
        this.checked = undefined;
        this.id = id;
        this.label = label;
        this.class = cssClass;
        this._actions = actions;
    }
    async run() { }
}
class EmptySubmenuAction extends Action {
    static { this.ID = 'vs.actions.empty'; }
    constructor() {
        super(EmptySubmenuAction.ID, ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(_moduleId, 0, '(empty)')), undefined, false);
    }
}
function toAction(props) {
    return {
        id: props.id,
        label: props.label,
        tooltip: props.tooltip ?? props.label,
        class: props.class,
        enabled: props.enabled ?? true,
        checked: props.checked,
        run: async (...args) => props.run(...args),
    };
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/async.js":
/*!****************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/async.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractIdleValue: () => (/* binding */ AbstractIdleValue),
/* harmony export */   AsyncIterableObject: () => (/* binding */ AsyncIterableObject),
/* harmony export */   AsyncIterableSource: () => (/* binding */ AsyncIterableSource),
/* harmony export */   AutoOpenBarrier: () => (/* binding */ AutoOpenBarrier),
/* harmony export */   Barrier: () => (/* binding */ Barrier),
/* harmony export */   CancelableAsyncIterableObject: () => (/* binding */ CancelableAsyncIterableObject),
/* harmony export */   DeferredPromise: () => (/* binding */ DeferredPromise),
/* harmony export */   Delayer: () => (/* binding */ Delayer),
/* harmony export */   GlobalIdleValue: () => (/* binding */ GlobalIdleValue),
/* harmony export */   IntervalCounter: () => (/* binding */ IntervalCounter),
/* harmony export */   IntervalTimer: () => (/* binding */ IntervalTimer),
/* harmony export */   LazyStatefulPromise: () => (/* binding */ LazyStatefulPromise),
/* harmony export */   Limiter: () => (/* binding */ Limiter),
/* harmony export */   Promises: () => (/* binding */ Promises),
/* harmony export */   Queue: () => (/* binding */ Queue),
/* harmony export */   ResourceQueue: () => (/* binding */ ResourceQueue),
/* harmony export */   RunOnceScheduler: () => (/* binding */ RunOnceScheduler),
/* harmony export */   RunOnceWorker: () => (/* binding */ RunOnceWorker),
/* harmony export */   Sequencer: () => (/* binding */ Sequencer),
/* harmony export */   SequencerByKey: () => (/* binding */ SequencerByKey),
/* harmony export */   StatefulPromise: () => (/* binding */ StatefulPromise),
/* harmony export */   TaskSequentializer: () => (/* binding */ TaskSequentializer),
/* harmony export */   ThrottledDelayer: () => (/* binding */ ThrottledDelayer),
/* harmony export */   Throttler: () => (/* binding */ Throttler),
/* harmony export */   TimeoutTimer: () => (/* binding */ TimeoutTimer),
/* harmony export */   _runWhenIdle: () => (/* binding */ _runWhenIdle),
/* harmony export */   asPromise: () => (/* binding */ asPromise),
/* harmony export */   createCancelableAsyncIterable: () => (/* binding */ createCancelableAsyncIterable),
/* harmony export */   createCancelablePromise: () => (/* binding */ createCancelablePromise),
/* harmony export */   disposableTimeout: () => (/* binding */ disposableTimeout),
/* harmony export */   first: () => (/* binding */ first),
/* harmony export */   isThenable: () => (/* binding */ isThenable),
/* harmony export */   promiseWithResolvers: () => (/* binding */ promiseWithResolvers),
/* harmony export */   raceCancellablePromises: () => (/* binding */ raceCancellablePromises),
/* harmony export */   raceCancellation: () => (/* binding */ raceCancellation),
/* harmony export */   raceCancellationError: () => (/* binding */ raceCancellationError),
/* harmony export */   raceTimeout: () => (/* binding */ raceTimeout),
/* harmony export */   retry: () => (/* binding */ retry),
/* harmony export */   runWhenGlobalIdle: () => (/* binding */ runWhenGlobalIdle),
/* harmony export */   sequence: () => (/* binding */ sequence),
/* harmony export */   timeout: () => (/* binding */ timeout)
/* harmony export */ });
/* harmony import */ var _cancellation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cancellation.js */ "./node_modules/vscode/vscode/src/vs/base/common/cancellation.js");
/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _event_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _lifecycle_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");
/* harmony import */ var _resources_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./resources.js */ "./node_modules/vscode/vscode/src/vs/base/common/resources.js");
/* harmony import */ var _platform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _symbols_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./symbols.js */ "./node_modules/vscode/vscode/src/vs/base/common/symbols.js");
/* harmony import */ var _lazy_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./lazy.js */ "./node_modules/vscode/vscode/src/vs/base/common/lazy.js");








function isThenable(obj) {
    return !!obj && typeof obj.then === 'function';
}
function createCancelablePromise(callback) {
    const source = ( new _cancellation_js__WEBPACK_IMPORTED_MODULE_0__.CancellationTokenSource());
    const thenable = callback(source.token);
    const promise = ( new Promise((resolve, reject) => {
        const subscription = source.token.onCancellationRequested(() => {
            subscription.dispose();
            reject(( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.CancellationError()));
        });
        Promise.resolve(thenable).then(value => {
            subscription.dispose();
            source.dispose();
            resolve(value);
        }, err => {
            subscription.dispose();
            source.dispose();
            reject(err);
        });
    }));
    return new (class {
        cancel() {
            source.cancel();
            source.dispose();
        }
        then(resolve, reject) {
            return promise.then(resolve, reject);
        }
        catch(reject) {
            return this.then(undefined, reject);
        }
        finally(onfinally) {
            return promise.finally(onfinally);
        }
    });
}
function raceCancellation(promise, token, defaultValue) {
    return ( new Promise((resolve, reject) => {
        const ref = token.onCancellationRequested(() => {
            ref.dispose();
            resolve(defaultValue);
        });
        promise.then(resolve, reject).finally(() => ref.dispose());
    }));
}
function raceCancellationError(promise, token) {
    return ( new Promise((resolve, reject) => {
        const ref = token.onCancellationRequested(() => {
            ref.dispose();
            reject(( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.CancellationError()));
        });
        promise.then(resolve, reject).finally(() => ref.dispose());
    }));
}
async function raceCancellablePromises(cancellablePromises) {
    let resolvedPromiseIndex = -1;
    const promises = ( cancellablePromises.map(
        (promise, index) => promise.then(result => { resolvedPromiseIndex = index; return result; })
    ));
    try {
        const result = await Promise.race(promises);
        return result;
    }
    finally {
        cancellablePromises.forEach((cancellablePromise, index) => {
            if (index !== resolvedPromiseIndex) {
                cancellablePromise.cancel();
            }
        });
    }
}
function raceTimeout(promise, timeout, onTimeout) {
    let promiseResolve = undefined;
    const timer = setTimeout(() => {
        promiseResolve?.(undefined);
        onTimeout?.();
    }, timeout);
    return Promise.race([
        promise.finally(() => clearTimeout(timer)),
        ( new Promise(resolve => promiseResolve = resolve))
    ]);
}
function asPromise(callback) {
    return ( new Promise((resolve, reject) => {
        const item = callback();
        if (isThenable(item)) {
            item.then(resolve, reject);
        }
        else {
            resolve(item);
        }
    }));
}
function promiseWithResolvers() {
    let resolve;
    let reject;
    const promise = ( new Promise((res, rej) => {
        resolve = res;
        reject = rej;
    }));
    return { promise, resolve: resolve, reject: reject };
}
class Throttler {
    constructor() {
        this.isDisposed = false;
        this.activePromise = null;
        this.queuedPromise = null;
        this.queuedPromiseFactory = null;
    }
    queue(promiseFactory) {
        if (this.isDisposed) {
            return Promise.reject(( new Error('Throttler is disposed')));
        }
        if (this.activePromise) {
            this.queuedPromiseFactory = promiseFactory;
            if (!this.queuedPromise) {
                const onComplete = () => {
                    this.queuedPromise = null;
                    if (this.isDisposed) {
                        return;
                    }
                    const result = this.queue(this.queuedPromiseFactory);
                    this.queuedPromiseFactory = null;
                    return result;
                };
                this.queuedPromise = ( new Promise(resolve => {
                    this.activePromise.then(onComplete, onComplete).then(resolve);
                }));
            }
            return ( new Promise((resolve, reject) => {
                this.queuedPromise.then(resolve, reject);
            }));
        }
        this.activePromise = promiseFactory();
        return ( new Promise((resolve, reject) => {
            this.activePromise.then((result) => {
                this.activePromise = null;
                resolve(result);
            }, (err) => {
                this.activePromise = null;
                reject(err);
            });
        }));
    }
    dispose() {
        this.isDisposed = true;
    }
}
class Sequencer {
    constructor() {
        this.current = Promise.resolve(null);
    }
    queue(promiseTask) {
        return this.current = this.current.then(() => promiseTask(), () => promiseTask());
    }
}
class SequencerByKey {
    constructor() {
        this.promiseMap = ( new Map());
    }
    queue(key, promiseTask) {
        const runningPromise = this.promiseMap.get(key) ?? Promise.resolve();
        const newPromise = runningPromise
            .catch(() => { })
            .then(promiseTask)
            .finally(() => {
            if (this.promiseMap.get(key) === newPromise) {
                this.promiseMap.delete(key);
            }
        });
        this.promiseMap.set(key, newPromise);
        return newPromise;
    }
}
const timeoutDeferred = (timeout, fn) => {
    let scheduled = true;
    const handle = setTimeout(() => {
        scheduled = false;
        fn();
    }, timeout);
    return {
        isTriggered: () => scheduled,
        dispose: () => {
            clearTimeout(handle);
            scheduled = false;
        },
    };
};
const microtaskDeferred = (fn) => {
    let scheduled = true;
    queueMicrotask(() => {
        if (scheduled) {
            scheduled = false;
            fn();
        }
    });
    return {
        isTriggered: () => scheduled,
        dispose: () => { scheduled = false; },
    };
};
class Delayer {
    constructor(defaultDelay) {
        this.defaultDelay = defaultDelay;
        this.deferred = null;
        this.completionPromise = null;
        this.doResolve = null;
        this.doReject = null;
        this.task = null;
    }
    trigger(task, delay = this.defaultDelay) {
        this.task = task;
        this.cancelTimeout();
        if (!this.completionPromise) {
            this.completionPromise = ( new Promise((resolve, reject) => {
                this.doResolve = resolve;
                this.doReject = reject;
            })).then(() => {
                this.completionPromise = null;
                this.doResolve = null;
                if (this.task) {
                    const task = this.task;
                    this.task = null;
                    return task();
                }
                return undefined;
            });
        }
        const fn = () => {
            this.deferred = null;
            this.doResolve?.(null);
        };
        this.deferred = delay === _symbols_js__WEBPACK_IMPORTED_MODULE_6__.MicrotaskDelay ? microtaskDeferred(fn) : timeoutDeferred(delay, fn);
        return this.completionPromise;
    }
    isTriggered() {
        return !!this.deferred?.isTriggered();
    }
    cancel() {
        this.cancelTimeout();
        if (this.completionPromise) {
            this.doReject?.(( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.CancellationError()));
            this.completionPromise = null;
        }
    }
    cancelTimeout() {
        this.deferred?.dispose();
        this.deferred = null;
    }
    dispose() {
        this.cancel();
    }
}
class ThrottledDelayer {
    constructor(defaultDelay) {
        this.delayer = ( new Delayer(defaultDelay));
        this.throttler = ( new Throttler());
    }
    trigger(promiseFactory, delay) {
        return this.delayer.trigger(() => this.throttler.queue(promiseFactory), delay);
    }
    isTriggered() {
        return this.delayer.isTriggered();
    }
    cancel() {
        this.delayer.cancel();
    }
    dispose() {
        this.delayer.dispose();
        this.throttler.dispose();
    }
}
class Barrier {
    constructor() {
        this._isOpen = false;
        this._promise = ( new Promise((c, e) => {
            this._completePromise = c;
        }));
    }
    isOpen() {
        return this._isOpen;
    }
    open() {
        this._isOpen = true;
        this._completePromise(true);
    }
    wait() {
        return this._promise;
    }
}
class AutoOpenBarrier extends Barrier {
    constructor(autoOpenTimeMs) {
        super();
        this._timeout = setTimeout(() => this.open(), autoOpenTimeMs);
    }
    open() {
        clearTimeout(this._timeout);
        super.open();
    }
}
function timeout(millis, token) {
    if (!token) {
        return createCancelablePromise(token => timeout(millis, token));
    }
    return ( new Promise((resolve, reject) => {
        const handle = setTimeout(() => {
            disposable.dispose();
            resolve();
        }, millis);
        const disposable = token.onCancellationRequested(() => {
            clearTimeout(handle);
            disposable.dispose();
            reject(( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.CancellationError()));
        });
    }));
}
function disposableTimeout(handler, timeout = 0, store) {
    const timer = setTimeout(() => {
        handler();
        if (store) {
            disposable.dispose();
        }
    }, timeout);
    const disposable = (0,_lifecycle_js__WEBPACK_IMPORTED_MODULE_3__.toDisposable)(() => {
        clearTimeout(timer);
        store?.deleteAndLeak(disposable);
    });
    store?.add(disposable);
    return disposable;
}
function sequence(promiseFactories) {
    const results = [];
    let index = 0;
    const len = promiseFactories.length;
    function next() {
        return index < len ? promiseFactories[index++]() : null;
    }
    function thenHandler(result) {
        if (result !== undefined && result !== null) {
            results.push(result);
        }
        const n = next();
        if (n) {
            return n.then(thenHandler);
        }
        return Promise.resolve(results);
    }
    return Promise.resolve(null).then(thenHandler);
}
function first(promiseFactories, shouldStop = t => !!t, defaultValue = null) {
    let index = 0;
    const len = promiseFactories.length;
    const loop = () => {
        if (index >= len) {
            return Promise.resolve(defaultValue);
        }
        const factory = promiseFactories[index++];
        const promise = Promise.resolve(factory());
        return promise.then(result => {
            if (shouldStop(result)) {
                return Promise.resolve(result);
            }
            return loop();
        });
    };
    return loop();
}
class Limiter {
    constructor(maxDegreeOfParalellism) {
        this._size = 0;
        this._isDisposed = false;
        this.maxDegreeOfParalellism = maxDegreeOfParalellism;
        this.outstandingPromises = [];
        this.runningPromises = 0;
        this._onDrained = ( new _event_js__WEBPACK_IMPORTED_MODULE_2__.Emitter());
    }
    whenIdle() {
        return this.size > 0
            ? _event_js__WEBPACK_IMPORTED_MODULE_2__.Event.toPromise(this.onDrained)
            : Promise.resolve();
    }
    get onDrained() {
        return this._onDrained.event;
    }
    get size() {
        return this._size;
    }
    queue(factory) {
        if (this._isDisposed) {
            throw ( new Error('Object has been disposed'));
        }
        this._size++;
        return ( new Promise((c, e) => {
            this.outstandingPromises.push({ factory, c, e });
            this.consume();
        }));
    }
    consume() {
        while (this.outstandingPromises.length && this.runningPromises < this.maxDegreeOfParalellism) {
            const iLimitedTask = this.outstandingPromises.shift();
            this.runningPromises++;
            const promise = iLimitedTask.factory();
            promise.then(iLimitedTask.c, iLimitedTask.e);
            promise.then(() => this.consumed(), () => this.consumed());
        }
    }
    consumed() {
        if (this._isDisposed) {
            return;
        }
        this.runningPromises--;
        if (--this._size === 0) {
            this._onDrained.fire();
        }
        if (this.outstandingPromises.length > 0) {
            this.consume();
        }
    }
    clear() {
        if (this._isDisposed) {
            throw ( new Error('Object has been disposed'));
        }
        this.outstandingPromises.length = 0;
        this._size = this.runningPromises;
    }
    dispose() {
        this._isDisposed = true;
        this.outstandingPromises.length = 0;
        this._size = 0;
        this._onDrained.dispose();
    }
}
class Queue extends Limiter {
    constructor() {
        super(1);
    }
}
class ResourceQueue {
    constructor() {
        this.queues = ( new Map());
        this.drainers = ( new Set());
        this.drainListeners = undefined;
        this.drainListenerCount = 0;
    }
    async whenDrained() {
        if (this.isDrained()) {
            return;
        }
        const promise = ( new DeferredPromise());
        this.drainers.add(promise);
        return promise.p;
    }
    isDrained() {
        for (const [, queue] of this.queues) {
            if (queue.size > 0) {
                return false;
            }
        }
        return true;
    }
    queueSize(resource, extUri$1 = _resources_js__WEBPACK_IMPORTED_MODULE_4__.extUri) {
        const key = extUri$1.getComparisonKey(resource);
        return this.queues.get(key)?.size ?? 0;
    }
    queueFor(resource, factory, extUri$1 = _resources_js__WEBPACK_IMPORTED_MODULE_4__.extUri) {
        const key = extUri$1.getComparisonKey(resource);
        let queue = this.queues.get(key);
        if (!queue) {
            queue = ( new Queue());
            const drainListenerId = this.drainListenerCount++;
            const drainListener = _event_js__WEBPACK_IMPORTED_MODULE_2__.Event.once(queue.onDrained)(() => {
                queue?.dispose();
                this.queues.delete(key);
                this.onDidQueueDrain();
                this.drainListeners?.deleteAndDispose(drainListenerId);
                if (this.drainListeners?.size === 0) {
                    this.drainListeners.dispose();
                    this.drainListeners = undefined;
                }
            });
            if (!this.drainListeners) {
                this.drainListeners = ( new _lifecycle_js__WEBPACK_IMPORTED_MODULE_3__.DisposableMap());
            }
            this.drainListeners.set(drainListenerId, drainListener);
            this.queues.set(key, queue);
        }
        return queue.queue(factory);
    }
    onDidQueueDrain() {
        if (!this.isDrained()) {
            return;
        }
        this.releaseDrainers();
    }
    releaseDrainers() {
        for (const drainer of this.drainers) {
            drainer.complete();
        }
        this.drainers.clear();
    }
    dispose() {
        for (const [, queue] of this.queues) {
            queue.dispose();
        }
        this.queues.clear();
        this.releaseDrainers();
        this.drainListeners?.dispose();
    }
}
class TimeoutTimer {
    constructor(runner, timeout) {
        this._isDisposed = false;
        this._token = -1;
        if (typeof runner === 'function' && typeof timeout === 'number') {
            this.setIfNotSet(runner, timeout);
        }
    }
    dispose() {
        this.cancel();
        this._isDisposed = true;
    }
    cancel() {
        if (this._token !== -1) {
            clearTimeout(this._token);
            this._token = -1;
        }
    }
    cancelAndSet(runner, timeout) {
        if (this._isDisposed) {
            throw ( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.BugIndicatingError(`Calling 'cancelAndSet' on a disposed TimeoutTimer`));
        }
        this.cancel();
        this._token = setTimeout(() => {
            this._token = -1;
            runner();
        }, timeout);
    }
    setIfNotSet(runner, timeout) {
        if (this._isDisposed) {
            throw ( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.BugIndicatingError(`Calling 'setIfNotSet' on a disposed TimeoutTimer`));
        }
        if (this._token !== -1) {
            return;
        }
        this._token = setTimeout(() => {
            this._token = -1;
            runner();
        }, timeout);
    }
}
class IntervalTimer {
    constructor() {
        this.disposable = undefined;
        this.isDisposed = false;
    }
    cancel() {
        this.disposable?.dispose();
        this.disposable = undefined;
    }
    cancelAndSet(runner, interval, context = globalThis) {
        if (this.isDisposed) {
            throw ( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.BugIndicatingError(`Calling 'cancelAndSet' on a disposed IntervalTimer`));
        }
        this.cancel();
        const handle = context.setInterval(() => {
            runner();
        }, interval);
        this.disposable = (0,_lifecycle_js__WEBPACK_IMPORTED_MODULE_3__.toDisposable)(() => {
            context.clearInterval(handle);
            this.disposable = undefined;
        });
    }
    dispose() {
        this.cancel();
        this.isDisposed = true;
    }
}
class RunOnceScheduler {
    constructor(runner, delay) {
        this.timeoutToken = -1;
        this.runner = runner;
        this.timeout = delay;
        this.timeoutHandler = this.onTimeout.bind(this);
    }
    dispose() {
        this.cancel();
        this.runner = null;
    }
    cancel() {
        if (this.isScheduled()) {
            clearTimeout(this.timeoutToken);
            this.timeoutToken = -1;
        }
    }
    schedule(delay = this.timeout) {
        this.cancel();
        this.timeoutToken = setTimeout(this.timeoutHandler, delay);
    }
    get delay() {
        return this.timeout;
    }
    set delay(value) {
        this.timeout = value;
    }
    isScheduled() {
        return this.timeoutToken !== -1;
    }
    flush() {
        if (this.isScheduled()) {
            this.cancel();
            this.doRun();
        }
    }
    onTimeout() {
        this.timeoutToken = -1;
        if (this.runner) {
            this.doRun();
        }
    }
    doRun() {
        this.runner?.();
    }
}
class RunOnceWorker extends RunOnceScheduler {
    constructor(runner, timeout) {
        super(runner, timeout);
        this.units = [];
    }
    work(unit) {
        this.units.push(unit);
        if (!this.isScheduled()) {
            this.schedule();
        }
    }
    doRun() {
        const units = this.units;
        this.units = [];
        this.runner?.(units);
    }
    dispose() {
        this.units = [];
        super.dispose();
    }
}
let runWhenGlobalIdle;
let _runWhenIdle;
(function () {
    if (typeof globalThis.requestIdleCallback !== 'function' || typeof globalThis.cancelIdleCallback !== 'function') {
        _runWhenIdle = (_targetWindow, runner) => {
            (0,_platform_js__WEBPACK_IMPORTED_MODULE_5__.setTimeout0)(() => {
                if (disposed) {
                    return;
                }
                const end = Date.now() + 15;
                const deadline = {
                    didTimeout: true,
                    timeRemaining() {
                        return Math.max(0, end - Date.now());
                    }
                };
                runner(( Object.freeze(deadline)));
            });
            let disposed = false;
            return {
                dispose() {
                    if (disposed) {
                        return;
                    }
                    disposed = true;
                }
            };
        };
    }
    else {
        _runWhenIdle = (targetWindow, runner, timeout) => {
            const handle = targetWindow.requestIdleCallback(runner, typeof timeout === 'number' ? { timeout } : undefined);
            let disposed = false;
            return {
                dispose() {
                    if (disposed) {
                        return;
                    }
                    disposed = true;
                    targetWindow.cancelIdleCallback(handle);
                }
            };
        };
    }
    runWhenGlobalIdle = (runner) => _runWhenIdle(globalThis, runner);
})();
class AbstractIdleValue {
    constructor(targetWindow, executor) {
        this._didRun = false;
        this._executor = () => {
            try {
                this._value = executor();
            }
            catch (err) {
                this._error = err;
            }
            finally {
                this._didRun = true;
            }
        };
        this._handle = _runWhenIdle(targetWindow, () => this._executor());
    }
    dispose() {
        this._handle.dispose();
    }
    get value() {
        if (!this._didRun) {
            this._handle.dispose();
            this._executor();
        }
        if (this._error) {
            throw this._error;
        }
        return this._value;
    }
    get isInitialized() {
        return this._didRun;
    }
}
class GlobalIdleValue extends AbstractIdleValue {
    constructor(executor) {
        super(globalThis, executor);
    }
}
async function retry(task, delay, retries) {
    let lastError;
    for (let i = 0; i < retries; i++) {
        try {
            return await task();
        }
        catch (error) {
            lastError = error;
            await timeout(delay);
        }
    }
    throw lastError;
}
class TaskSequentializer {
    isRunning(taskId) {
        if (typeof taskId === 'number') {
            return this._running?.taskId === taskId;
        }
        return !!this._running;
    }
    get running() {
        return this._running?.promise;
    }
    cancelRunning() {
        this._running?.cancel();
    }
    run(taskId, promise, onCancel) {
        this._running = { taskId, cancel: () => onCancel?.(), promise };
        promise.then(() => this.doneRunning(taskId), () => this.doneRunning(taskId));
        return promise;
    }
    doneRunning(taskId) {
        if (this._running && taskId === this._running.taskId) {
            this._running = undefined;
            this.runQueued();
        }
    }
    runQueued() {
        if (this._queued) {
            const queued = this._queued;
            this._queued = undefined;
            queued.run().then(queued.promiseResolve, queued.promiseReject);
        }
    }
    queue(run) {
        if (!this._queued) {
            const { promise, resolve: promiseResolve, reject: promiseReject } = promiseWithResolvers();
            this._queued = {
                run,
                promise,
                promiseResolve: promiseResolve,
                promiseReject: promiseReject
            };
        }
        else {
            this._queued.run = run;
        }
        return this._queued.promise;
    }
    hasQueued() {
        return !!this._queued;
    }
    async join() {
        return this._queued?.promise ?? this._running?.promise;
    }
}
class IntervalCounter {
    constructor(interval, nowFn = () => Date.now()) {
        this.interval = interval;
        this.nowFn = nowFn;
        this.lastIncrementTime = 0;
        this.value = 0;
    }
    increment() {
        const now = this.nowFn();
        if (now - this.lastIncrementTime > this.interval) {
            this.lastIncrementTime = now;
            this.value = 0;
        }
        this.value++;
        return this.value;
    }
}
var DeferredOutcome;
( (function(DeferredOutcome) {
    DeferredOutcome[DeferredOutcome["Resolved"] = 0] = "Resolved";
    DeferredOutcome[DeferredOutcome["Rejected"] = 1] = "Rejected";
})(DeferredOutcome || (DeferredOutcome = {})));
class DeferredPromise {
    get isRejected() {
        return this.outcome?.outcome === DeferredOutcome.Rejected;
    }
    get isResolved() {
        return this.outcome?.outcome === DeferredOutcome.Resolved;
    }
    get isSettled() {
        return !!this.outcome;
    }
    get value() {
        return this.outcome?.outcome === DeferredOutcome.Resolved ? this.outcome?.value : undefined;
    }
    constructor() {
        this.p = ( new Promise((c, e) => {
            this.completeCallback = c;
            this.errorCallback = e;
        }));
    }
    complete(value) {
        return ( new Promise(resolve => {
            this.completeCallback(value);
            this.outcome = { outcome: DeferredOutcome.Resolved, value };
            resolve();
        }));
    }
    error(err) {
        return ( new Promise(resolve => {
            this.errorCallback(err);
            this.outcome = { outcome: DeferredOutcome.Rejected, value: err };
            resolve();
        }));
    }
    cancel() {
        return this.error(( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.CancellationError()));
    }
}
var Promises;
( (function(Promises) {
    async function settled(promises) {
        let firstError = undefined;
        const result = await Promise.all(( promises.map(promise => promise.then(value => value, error => {
            if (!firstError) {
                firstError = error;
            }
            return undefined;
        }))));
        if (typeof firstError !== 'undefined') {
            throw firstError;
        }
        return result;
    }
    Promises.settled = settled;
    function withAsyncBody(bodyFn) {
        return ( new Promise(async (resolve, reject) => {
            try {
                await bodyFn(resolve, reject);
            }
            catch (error) {
                reject(error);
            }
        }));
    }
    Promises.withAsyncBody = withAsyncBody;
})(Promises || (Promises = {})));
class StatefulPromise {
    get value() { return this._value; }
    get error() { return this._error; }
    get isResolved() { return this._isResolved; }
    constructor(promise) {
        this._value = undefined;
        this._error = undefined;
        this._isResolved = false;
        this.promise = promise.then(value => {
            this._value = value;
            this._isResolved = true;
            return value;
        }, error => {
            this._error = error;
            this._isResolved = true;
            throw error;
        });
    }
    requireValue() {
        if (!this._isResolved) {
            throw ( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.BugIndicatingError('Promise is not resolved yet'));
        }
        if (this._error) {
            throw this._error;
        }
        return this._value;
    }
}
class LazyStatefulPromise {
    constructor(_compute) {
        this._compute = _compute;
        this._promise = ( new _lazy_js__WEBPACK_IMPORTED_MODULE_7__.Lazy(() => ( new StatefulPromise(this._compute()))));
    }
    requireValue() {
        return this._promise.value.requireValue();
    }
    getPromise() {
        return this._promise.value.promise;
    }
    get currentValue() {
        return this._promise.rawValue?.value;
    }
}
var AsyncIterableSourceState;
( (function(AsyncIterableSourceState) {
    AsyncIterableSourceState[AsyncIterableSourceState["Initial"] = 0] = "Initial";
    AsyncIterableSourceState[AsyncIterableSourceState["DoneOK"] = 1] = "DoneOK";
    AsyncIterableSourceState[AsyncIterableSourceState["DoneError"] = 2] = "DoneError";
})(AsyncIterableSourceState || (AsyncIterableSourceState = {})));
class AsyncIterableObject {
    static fromArray(items) {
        return ( new AsyncIterableObject((writer) => {
            writer.emitMany(items);
        }));
    }
    static fromPromise(promise) {
        return ( new AsyncIterableObject(async (emitter) => {
            emitter.emitMany(await promise);
        }));
    }
    static fromPromises(promises) {
        return ( new AsyncIterableObject(async (emitter) => {
            await Promise.all(( promises.map(async (p) => emitter.emitOne(await p))));
        }));
    }
    static merge(iterables) {
        return ( new AsyncIterableObject(async (emitter) => {
            await Promise.all(( iterables.map(async (iterable) => {
                for await (const item of iterable) {
                    emitter.emitOne(item);
                }
            })));
        }));
    }
    static { this.EMPTY = AsyncIterableObject.fromArray([]); }
    constructor(executor, onReturn) {
        this._state = AsyncIterableSourceState.Initial;
        this._results = [];
        this._error = null;
        this._onReturn = onReturn;
        this._onStateChanged = ( new _event_js__WEBPACK_IMPORTED_MODULE_2__.Emitter());
        queueMicrotask(async () => {
            const writer = {
                emitOne: (item) => this.emitOne(item),
                emitMany: (items) => this.emitMany(items),
                reject: (error) => this.reject(error)
            };
            try {
                await Promise.resolve(executor(writer));
                this.resolve();
            }
            catch (err) {
                this.reject(err);
            }
            finally {
                writer.emitOne = undefined;
                writer.emitMany = undefined;
                writer.reject = undefined;
            }
        });
    }
    [Symbol.asyncIterator]() {
        let i = 0;
        return {
            next: async () => {
                do {
                    if (this._state === AsyncIterableSourceState.DoneError) {
                        throw this._error;
                    }
                    if (i < this._results.length) {
                        return { done: false, value: this._results[i++] };
                    }
                    if (this._state === AsyncIterableSourceState.DoneOK) {
                        return { done: true, value: undefined };
                    }
                    await _event_js__WEBPACK_IMPORTED_MODULE_2__.Event.toPromise(this._onStateChanged.event);
                } while (true);
            },
            return: async () => {
                this._onReturn?.();
                return { done: true, value: undefined };
            }
        };
    }
    static map(iterable, mapFn) {
        return ( new AsyncIterableObject(async (emitter) => {
            for await (const item of iterable) {
                emitter.emitOne(mapFn(item));
            }
        }));
    }
    map(mapFn) {
        return ( AsyncIterableObject.map(this, mapFn));
    }
    static filter(iterable, filterFn) {
        return ( new AsyncIterableObject(async (emitter) => {
            for await (const item of iterable) {
                if (filterFn(item)) {
                    emitter.emitOne(item);
                }
            }
        }));
    }
    filter(filterFn) {
        return AsyncIterableObject.filter(this, filterFn);
    }
    static coalesce(iterable) {
        return AsyncIterableObject.filter(iterable, item => !!item);
    }
    coalesce() {
        return AsyncIterableObject.coalesce(this);
    }
    static async toPromise(iterable) {
        const result = [];
        for await (const item of iterable) {
            result.push(item);
        }
        return result;
    }
    toPromise() {
        return AsyncIterableObject.toPromise(this);
    }
    emitOne(value) {
        if (this._state !== AsyncIterableSourceState.Initial) {
            return;
        }
        this._results.push(value);
        this._onStateChanged.fire();
    }
    emitMany(values) {
        if (this._state !== AsyncIterableSourceState.Initial) {
            return;
        }
        this._results = this._results.concat(values);
        this._onStateChanged.fire();
    }
    resolve() {
        if (this._state !== AsyncIterableSourceState.Initial) {
            return;
        }
        this._state = AsyncIterableSourceState.DoneOK;
        this._onStateChanged.fire();
    }
    reject(error) {
        if (this._state !== AsyncIterableSourceState.Initial) {
            return;
        }
        this._state = AsyncIterableSourceState.DoneError;
        this._error = error;
        this._onStateChanged.fire();
    }
}
class CancelableAsyncIterableObject extends AsyncIterableObject {
    constructor(_source, executor) {
        super(executor);
        this._source = _source;
    }
    cancel() {
        this._source.cancel();
    }
}
function createCancelableAsyncIterable(callback) {
    const source = ( new _cancellation_js__WEBPACK_IMPORTED_MODULE_0__.CancellationTokenSource());
    const innerIterable = callback(source.token);
    return ( new CancelableAsyncIterableObject(source, async (emitter) => {
        const subscription = source.token.onCancellationRequested(() => {
            subscription.dispose();
            source.dispose();
            emitter.reject(( new _errors_js__WEBPACK_IMPORTED_MODULE_1__.CancellationError()));
        });
        try {
            for await (const item of innerIterable) {
                if (source.token.isCancellationRequested) {
                    return;
                }
                emitter.emitOne(item);
            }
            subscription.dispose();
            source.dispose();
        }
        catch (err) {
            subscription.dispose();
            source.dispose();
            emitter.reject(err);
        }
    }));
}
class AsyncIterableSource {
    constructor(onReturn) {
        this._deferred = ( new DeferredPromise());
        this._asyncIterable = ( new AsyncIterableObject(emitter => {
            if (earlyError) {
                emitter.reject(earlyError);
                return;
            }
            if (earlyItems) {
                emitter.emitMany(earlyItems);
            }
            this._errorFn = (error) => emitter.reject(error);
            this._emitFn = (item) => emitter.emitOne(item);
            return this._deferred.p;
        }, onReturn));
        let earlyError;
        let earlyItems;
        this._emitFn = (item) => {
            if (!earlyItems) {
                earlyItems = [];
            }
            earlyItems.push(item);
        };
        this._errorFn = (error) => {
            if (!earlyError) {
                earlyError = error;
            }
        };
    }
    get asyncIterable() {
        return this._asyncIterable;
    }
    resolve() {
        this._deferred.complete();
    }
    reject(error) {
        this._errorFn(error);
        this._deferred.complete();
    }
    emitOne(item) {
        this._emitFn(item);
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/buffer.js":
/*!*****************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/buffer.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   VSBuffer: () => (/* binding */ VSBuffer),
/* harmony export */   binaryIndexOf: () => (/* binding */ binaryIndexOf),
/* harmony export */   bufferToReadable: () => (/* binding */ bufferToReadable),
/* harmony export */   bufferToStream: () => (/* binding */ bufferToStream),
/* harmony export */   bufferedStreamToBuffer: () => (/* binding */ bufferedStreamToBuffer),
/* harmony export */   decodeBase64: () => (/* binding */ decodeBase64),
/* harmony export */   encodeBase64: () => (/* binding */ encodeBase64),
/* harmony export */   newWriteableBufferStream: () => (/* binding */ newWriteableBufferStream),
/* harmony export */   prefixedBufferReadable: () => (/* binding */ prefixedBufferReadable),
/* harmony export */   prefixedBufferStream: () => (/* binding */ prefixedBufferStream),
/* harmony export */   readUInt16LE: () => (/* binding */ readUInt16LE),
/* harmony export */   readUInt32BE: () => (/* binding */ readUInt32BE),
/* harmony export */   readUInt32LE: () => (/* binding */ readUInt32LE),
/* harmony export */   readUInt8: () => (/* binding */ readUInt8),
/* harmony export */   readableToBuffer: () => (/* binding */ readableToBuffer),
/* harmony export */   streamToBuffer: () => (/* binding */ streamToBuffer),
/* harmony export */   writeUInt16LE: () => (/* binding */ writeUInt16LE),
/* harmony export */   writeUInt32BE: () => (/* binding */ writeUInt32BE),
/* harmony export */   writeUInt32LE: () => (/* binding */ writeUInt32LE),
/* harmony export */   writeUInt8: () => (/* binding */ writeUInt8)
/* harmony export */ });
/* harmony import */ var _lazy_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lazy.js */ "./node_modules/vscode/vscode/src/vs/base/common/lazy.js");
/* harmony import */ var _stream_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stream.js */ "./node_modules/vscode/vscode/src/vs/base/common/stream.js");


const hasBuffer = (typeof Buffer !== 'undefined');
const indexOfTable = ( new _lazy_js__WEBPACK_IMPORTED_MODULE_0__.Lazy(() => ( new Uint8Array(256))));
let textEncoder;
let textDecoder;
class VSBuffer {
    static alloc(byteLength) {
        if (hasBuffer) {
            return ( new VSBuffer(Buffer.allocUnsafe(byteLength)));
        }
        else {
            return ( new VSBuffer(( new Uint8Array(byteLength))));
        }
    }
    static wrap(actual) {
        if (hasBuffer && !(Buffer.isBuffer(actual))) {
            actual = Buffer.from(actual.buffer, actual.byteOffset, actual.byteLength);
        }
        return ( new VSBuffer(actual));
    }
    static fromString(source, options) {
        const dontUseNodeBuffer = options?.dontUseNodeBuffer || false;
        if (!dontUseNodeBuffer && hasBuffer) {
            return ( new VSBuffer(Buffer.from(source)));
        }
        else {
            if (!textEncoder) {
                textEncoder = ( new TextEncoder());
            }
            return ( new VSBuffer(textEncoder.encode(source)));
        }
    }
    static fromByteArray(source) {
        const result = VSBuffer.alloc(source.length);
        for (let i = 0, len = source.length; i < len; i++) {
            result.buffer[i] = source[i];
        }
        return result;
    }
    static concat(buffers, totalLength) {
        if (typeof totalLength === 'undefined') {
            totalLength = 0;
            for (let i = 0, len = buffers.length; i < len; i++) {
                totalLength += buffers[i].byteLength;
            }
        }
        const ret = VSBuffer.alloc(totalLength);
        let offset = 0;
        for (let i = 0, len = buffers.length; i < len; i++) {
            const element = buffers[i];
            ret.set(element, offset);
            offset += element.byteLength;
        }
        return ret;
    }
    constructor(buffer) {
        this.buffer = buffer;
        this.byteLength = this.buffer.byteLength;
    }
    clone() {
        const result = VSBuffer.alloc(this.byteLength);
        result.set(this);
        return result;
    }
    toString() {
        if (hasBuffer) {
            return ( this.buffer.toString());
        }
        else {
            if (!textDecoder) {
                textDecoder = ( new TextDecoder());
            }
            return textDecoder.decode(this.buffer);
        }
    }
    slice(start, end) {
        return ( new VSBuffer(this.buffer.subarray(start, end)));
    }
    set(array, offset) {
        if (array instanceof VSBuffer) {
            this.buffer.set(array.buffer, offset);
        }
        else if (array instanceof Uint8Array) {
            this.buffer.set(array, offset);
        }
        else if (array instanceof ArrayBuffer) {
            this.buffer.set(( new Uint8Array(array)), offset);
        }
        else if (ArrayBuffer.isView(array)) {
            this.buffer.set(( new Uint8Array(array.buffer, array.byteOffset, array.byteLength)), offset);
        }
        else {
            throw ( new Error(`Unknown argument 'array'`));
        }
    }
    readUInt32BE(offset) {
        return readUInt32BE(this.buffer, offset);
    }
    writeUInt32BE(value, offset) {
        writeUInt32BE(this.buffer, value, offset);
    }
    readUInt32LE(offset) {
        return readUInt32LE(this.buffer, offset);
    }
    writeUInt32LE(value, offset) {
        writeUInt32LE(this.buffer, value, offset);
    }
    readUInt8(offset) {
        return readUInt8(this.buffer, offset);
    }
    writeUInt8(value, offset) {
        writeUInt8(this.buffer, value, offset);
    }
    indexOf(subarray, offset = 0) {
        return binaryIndexOf(this.buffer, subarray instanceof VSBuffer ? subarray.buffer : subarray, offset);
    }
}
function binaryIndexOf(haystack, needle, offset = 0) {
    const needleLen = needle.byteLength;
    const haystackLen = haystack.byteLength;
    if (needleLen === 0) {
        return 0;
    }
    if (needleLen === 1) {
        return haystack.indexOf(needle[0]);
    }
    if (needleLen > haystackLen - offset) {
        return -1;
    }
    const table = indexOfTable.value;
    table.fill(needle.length);
    for (let i = 0; i < needle.length; i++) {
        table[needle[i]] = needle.length - i - 1;
    }
    let i = offset + needle.length - 1;
    let j = i;
    let result = -1;
    while (i < haystackLen) {
        if (haystack[i] === needle[j]) {
            if (j === 0) {
                result = i;
                break;
            }
            i--;
            j--;
        }
        else {
            i += Math.max(needle.length - j, table[haystack[i]]);
            j = needle.length - 1;
        }
    }
    return result;
}
function readUInt16LE(source, offset) {
    return (((source[offset + 0] << 0) >>> 0) |
        ((source[offset + 1] << 8) >>> 0));
}
function writeUInt16LE(destination, value, offset) {
    destination[offset + 0] = (value & 0b11111111);
    value = value >>> 8;
    destination[offset + 1] = (value & 0b11111111);
}
function readUInt32BE(source, offset) {
    return (source[offset] * 2 ** 24
        + source[offset + 1] * 2 ** 16
        + source[offset + 2] * 2 ** 8
        + source[offset + 3]);
}
function writeUInt32BE(destination, value, offset) {
    destination[offset + 3] = value;
    value = value >>> 8;
    destination[offset + 2] = value;
    value = value >>> 8;
    destination[offset + 1] = value;
    value = value >>> 8;
    destination[offset] = value;
}
function readUInt32LE(source, offset) {
    return (((source[offset + 0] << 0) >>> 0) |
        ((source[offset + 1] << 8) >>> 0) |
        ((source[offset + 2] << 16) >>> 0) |
        ((source[offset + 3] << 24) >>> 0));
}
function writeUInt32LE(destination, value, offset) {
    destination[offset + 0] = (value & 0b11111111);
    value = value >>> 8;
    destination[offset + 1] = (value & 0b11111111);
    value = value >>> 8;
    destination[offset + 2] = (value & 0b11111111);
    value = value >>> 8;
    destination[offset + 3] = (value & 0b11111111);
}
function readUInt8(source, offset) {
    return source[offset];
}
function writeUInt8(destination, value, offset) {
    destination[offset] = value;
}
function readableToBuffer(readable) {
    return (0,_stream_js__WEBPACK_IMPORTED_MODULE_1__.consumeReadable)(readable, chunks => VSBuffer.concat(chunks));
}
function bufferToReadable(buffer) {
    return (0,_stream_js__WEBPACK_IMPORTED_MODULE_1__.toReadable)(buffer);
}
function streamToBuffer(stream) {
    return (0,_stream_js__WEBPACK_IMPORTED_MODULE_1__.consumeStream)(stream, chunks => VSBuffer.concat(chunks));
}
async function bufferedStreamToBuffer(bufferedStream) {
    if (bufferedStream.ended) {
        return VSBuffer.concat(bufferedStream.buffer);
    }
    return VSBuffer.concat([
        ...bufferedStream.buffer,
        await streamToBuffer(bufferedStream.stream)
    ]);
}
function bufferToStream(buffer) {
    return (0,_stream_js__WEBPACK_IMPORTED_MODULE_1__.toStream)(buffer, chunks => VSBuffer.concat(chunks));
}
function newWriteableBufferStream(options) {
    return (0,_stream_js__WEBPACK_IMPORTED_MODULE_1__.newWriteableStream)(chunks => VSBuffer.concat(chunks), options);
}
function prefixedBufferReadable(prefix, readable) {
    return (0,_stream_js__WEBPACK_IMPORTED_MODULE_1__.prefixedReadable)(prefix, readable, chunks => VSBuffer.concat(chunks));
}
function prefixedBufferStream(prefix, stream) {
    return (0,_stream_js__WEBPACK_IMPORTED_MODULE_1__.prefixedStream)(prefix, stream, chunks => VSBuffer.concat(chunks));
}
function decodeBase64(encoded) {
    let building = 0;
    let remainder = 0;
    let bufi = 0;
    const buffer = ( new Uint8Array(Math.floor(encoded.length / 4 * 3)));
    const append = (value) => {
        switch (remainder) {
            case 3:
                buffer[bufi++] = building | value;
                remainder = 0;
                break;
            case 2:
                buffer[bufi++] = building | (value >>> 2);
                building = value << 6;
                remainder = 3;
                break;
            case 1:
                buffer[bufi++] = building | (value >>> 4);
                building = value << 4;
                remainder = 2;
                break;
            default:
                building = value << 2;
                remainder = 1;
        }
    };
    for (let i = 0; i < encoded.length; i++) {
        const code = encoded.charCodeAt(i);
        if (code >= 65 && code <= 90) {
            append(code - 65);
        }
        else if (code >= 97 && code <= 122) {
            append(code - 97 + 26);
        }
        else if (code >= 48 && code <= 57) {
            append(code - 48 + 52);
        }
        else if (code === 43 || code === 45) {
            append(62);
        }
        else if (code === 47 || code === 95) {
            append(63);
        }
        else if (code === 61) {
            break;
        }
        else {
            throw ( new SyntaxError(`Unexpected base64 character ${encoded[i]}`));
        }
    }
    const unpadded = bufi;
    while (remainder > 0) {
        append(0);
    }
    return VSBuffer.wrap(buffer).slice(0, unpadded);
}
const base64Alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
const base64UrlSafeAlphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_';
function encodeBase64({ buffer }, padded = true, urlSafe = false) {
    const dictionary = urlSafe ? base64UrlSafeAlphabet : base64Alphabet;
    let output = '';
    const remainder = buffer.byteLength % 3;
    let i = 0;
    for (; i < buffer.byteLength - remainder; i += 3) {
        const a = buffer[i + 0];
        const b = buffer[i + 1];
        const c = buffer[i + 2];
        output += dictionary[a >>> 2];
        output += dictionary[(a << 4 | b >>> 4) & 0b111111];
        output += dictionary[(b << 2 | c >>> 6) & 0b111111];
        output += dictionary[c & 0b111111];
    }
    if (remainder === 1) {
        const a = buffer[i + 0];
        output += dictionary[a >>> 2];
        output += dictionary[(a << 4) & 0b111111];
        if (padded) {
            output += '==';
        }
    }
    else if (remainder === 2) {
        const a = buffer[i + 0];
        const b = buffer[i + 1];
        output += dictionary[a >>> 2];
        output += dictionary[(a << 4 | b >>> 4) & 0b111111];
        output += dictionary[(b << 2) & 0b111111];
        if (padded) {
            output += '=';
        }
    }
    return output;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/comparers.js":
/*!********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/comparers.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   compareAnything: () => (/* binding */ compareAnything),
/* harmony export */   compareByPrefix: () => (/* binding */ compareByPrefix),
/* harmony export */   compareFileExtensions: () => (/* binding */ compareFileExtensions),
/* harmony export */   compareFileExtensionsDefault: () => (/* binding */ compareFileExtensionsDefault),
/* harmony export */   compareFileExtensionsLower: () => (/* binding */ compareFileExtensionsLower),
/* harmony export */   compareFileExtensionsUnicode: () => (/* binding */ compareFileExtensionsUnicode),
/* harmony export */   compareFileExtensionsUpper: () => (/* binding */ compareFileExtensionsUpper),
/* harmony export */   compareFileNames: () => (/* binding */ compareFileNames),
/* harmony export */   compareFileNamesDefault: () => (/* binding */ compareFileNamesDefault),
/* harmony export */   compareFileNamesLower: () => (/* binding */ compareFileNamesLower),
/* harmony export */   compareFileNamesUnicode: () => (/* binding */ compareFileNamesUnicode),
/* harmony export */   compareFileNamesUpper: () => (/* binding */ compareFileNamesUpper),
/* harmony export */   comparePaths: () => (/* binding */ comparePaths)
/* harmony export */ });
/* harmony import */ var _lazy_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lazy.js */ "./node_modules/vscode/vscode/src/vs/base/common/lazy.js");
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./path.js */ "./node_modules/vscode/vscode/src/vs/base/common/path.js");


const intlFileNameCollatorBaseNumeric = ( new _lazy_js__WEBPACK_IMPORTED_MODULE_0__.Lazy(() => {
    const collator = new Intl.Collator(undefined, { numeric: true, sensitivity: 'base' });
    return {
        collator,
        collatorIsNumeric: collator.resolvedOptions().numeric
    };
}));
const intlFileNameCollatorNumeric = ( new _lazy_js__WEBPACK_IMPORTED_MODULE_0__.Lazy(() => {
    const collator = new Intl.Collator(undefined, { numeric: true });
    return {
        collator
    };
}));
const intlFileNameCollatorNumericCaseInsensitive = ( new _lazy_js__WEBPACK_IMPORTED_MODULE_0__.Lazy(() => {
    const collator = new Intl.Collator(undefined, { numeric: true, sensitivity: 'accent' });
    return {
        collator
    };
}));
function compareFileNames(one, other, caseSensitive = false) {
    const a = one || '';
    const b = other || '';
    const result = intlFileNameCollatorBaseNumeric.value.collator.compare(a, b);
    if (intlFileNameCollatorBaseNumeric.value.collatorIsNumeric && result === 0 && a !== b) {
        return a < b ? -1 : 1;
    }
    return result;
}
function compareFileNamesDefault(one, other) {
    const collatorNumeric = intlFileNameCollatorNumeric.value.collator;
    one = one || '';
    other = other || '';
    return compareAndDisambiguateByLength(collatorNumeric, one, other);
}
function compareFileNamesUpper(one, other) {
    const collatorNumeric = intlFileNameCollatorNumeric.value.collator;
    one = one || '';
    other = other || '';
    return compareCaseUpperFirst(one, other) || compareAndDisambiguateByLength(collatorNumeric, one, other);
}
function compareFileNamesLower(one, other) {
    const collatorNumeric = intlFileNameCollatorNumeric.value.collator;
    one = one || '';
    other = other || '';
    return compareCaseLowerFirst(one, other) || compareAndDisambiguateByLength(collatorNumeric, one, other);
}
function compareFileNamesUnicode(one, other) {
    one = one || '';
    other = other || '';
    if (one === other) {
        return 0;
    }
    return one < other ? -1 : 1;
}
function compareFileExtensions(one, other) {
    const [oneName, oneExtension] = extractNameAndExtension(one);
    const [otherName, otherExtension] = extractNameAndExtension(other);
    let result = intlFileNameCollatorBaseNumeric.value.collator.compare(oneExtension, otherExtension);
    if (result === 0) {
        if (intlFileNameCollatorBaseNumeric.value.collatorIsNumeric && oneExtension !== otherExtension) {
            return oneExtension < otherExtension ? -1 : 1;
        }
        result = intlFileNameCollatorBaseNumeric.value.collator.compare(oneName, otherName);
        if (intlFileNameCollatorBaseNumeric.value.collatorIsNumeric && result === 0 && oneName !== otherName) {
            return oneName < otherName ? -1 : 1;
        }
    }
    return result;
}
function compareFileExtensionsDefault(one, other) {
    one = one || '';
    other = other || '';
    const oneExtension = extractExtension(one);
    const otherExtension = extractExtension(other);
    const collatorNumeric = intlFileNameCollatorNumeric.value.collator;
    const collatorNumericCaseInsensitive = intlFileNameCollatorNumericCaseInsensitive.value.collator;
    return compareAndDisambiguateByLength(collatorNumericCaseInsensitive, oneExtension, otherExtension) ||
        compareAndDisambiguateByLength(collatorNumeric, one, other);
}
function compareFileExtensionsUpper(one, other) {
    one = one || '';
    other = other || '';
    const oneExtension = extractExtension(one);
    const otherExtension = extractExtension(other);
    const collatorNumeric = intlFileNameCollatorNumeric.value.collator;
    const collatorNumericCaseInsensitive = intlFileNameCollatorNumericCaseInsensitive.value.collator;
    return compareAndDisambiguateByLength(collatorNumericCaseInsensitive, oneExtension, otherExtension) ||
        compareCaseUpperFirst(one, other) ||
        compareAndDisambiguateByLength(collatorNumeric, one, other);
}
function compareFileExtensionsLower(one, other) {
    one = one || '';
    other = other || '';
    const oneExtension = extractExtension(one);
    const otherExtension = extractExtension(other);
    const collatorNumeric = intlFileNameCollatorNumeric.value.collator;
    const collatorNumericCaseInsensitive = intlFileNameCollatorNumericCaseInsensitive.value.collator;
    return compareAndDisambiguateByLength(collatorNumericCaseInsensitive, oneExtension, otherExtension) ||
        compareCaseLowerFirst(one, other) ||
        compareAndDisambiguateByLength(collatorNumeric, one, other);
}
function compareFileExtensionsUnicode(one, other) {
    one = one || '';
    other = other || '';
    const oneExtension = extractExtension(one).toLowerCase();
    const otherExtension = extractExtension(other).toLowerCase();
    if (oneExtension !== otherExtension) {
        return oneExtension < otherExtension ? -1 : 1;
    }
    if (one !== other) {
        return one < other ? -1 : 1;
    }
    return 0;
}
const FileNameMatch = /^(.*?)(\.([^.]*))?$/;
function extractNameAndExtension(str, dotfilesAsNames = false) {
    const match = str ? FileNameMatch.exec(str) : [];
    let result = [(match && match[1]) || '', (match && match[3]) || ''];
    if (dotfilesAsNames && (!result[0] && result[1] || result[0] && result[0].charAt(0) === '.')) {
        result = [result[0] + '.' + result[1], ''];
    }
    return result;
}
function extractExtension(str) {
    const match = str ? FileNameMatch.exec(str) : [];
    return (match && match[1] && match[1].charAt(0) !== '.' && match[3]) || '';
}
function compareAndDisambiguateByLength(collator, one, other) {
    const result = collator.compare(one, other);
    if (result !== 0) {
        return result;
    }
    if (one.length !== other.length) {
        return one.length < other.length ? -1 : 1;
    }
    return 0;
}
function startsWithLower(string) {
    const character = string.charAt(0);
    return (character.toLocaleUpperCase() !== character) ? true : false;
}
function startsWithUpper(string) {
    const character = string.charAt(0);
    return (character.toLocaleLowerCase() !== character) ? true : false;
}
function compareCaseLowerFirst(one, other) {
    if (startsWithLower(one) && startsWithUpper(other)) {
        return -1;
    }
    return (startsWithUpper(one) && startsWithLower(other)) ? 1 : 0;
}
function compareCaseUpperFirst(one, other) {
    if (startsWithUpper(one) && startsWithLower(other)) {
        return -1;
    }
    return (startsWithLower(one) && startsWithUpper(other)) ? 1 : 0;
}
function comparePathComponents(one, other, caseSensitive = false) {
    if (!caseSensitive) {
        one = one && one.toLowerCase();
        other = other && other.toLowerCase();
    }
    if (one === other) {
        return 0;
    }
    return one < other ? -1 : 1;
}
function comparePaths(one, other, caseSensitive = false) {
    const oneParts = one.split(_path_js__WEBPACK_IMPORTED_MODULE_1__.sep);
    const otherParts = other.split(_path_js__WEBPACK_IMPORTED_MODULE_1__.sep);
    const lastOne = oneParts.length - 1;
    const lastOther = otherParts.length - 1;
    let endOne, endOther;
    for (let i = 0;; i++) {
        endOne = lastOne === i;
        endOther = lastOther === i;
        if (endOne && endOther) {
            return compareFileNames(oneParts[i], otherParts[i], caseSensitive);
        }
        else if (endOne) {
            return -1;
        }
        else if (endOther) {
            return 1;
        }
        const result = comparePathComponents(oneParts[i], otherParts[i], caseSensitive);
        if (result !== 0) {
            return result;
        }
    }
}
function compareAnything(one, other, lookFor) {
    const elementAName = one.toLowerCase();
    const elementBName = other.toLowerCase();
    const prefixCompare = compareByPrefix(one, other, lookFor);
    if (prefixCompare) {
        return prefixCompare;
    }
    const elementASuffixMatch = elementAName.endsWith(lookFor);
    const elementBSuffixMatch = elementBName.endsWith(lookFor);
    if (elementASuffixMatch !== elementBSuffixMatch) {
        return elementASuffixMatch ? -1 : 1;
    }
    const r = compareFileNames(elementAName, elementBName);
    if (r !== 0) {
        return r;
    }
    return elementAName.localeCompare(elementBName);
}
function compareByPrefix(one, other, lookFor) {
    const elementAName = one.toLowerCase();
    const elementBName = other.toLowerCase();
    const elementAPrefixMatch = elementAName.startsWith(lookFor);
    const elementBPrefixMatch = elementBName.startsWith(lookFor);
    if (elementAPrefixMatch !== elementBPrefixMatch) {
        return elementAPrefixMatch ? -1 : 1;
    }
    else if (elementAPrefixMatch && elementBPrefixMatch) {
        if (elementAName.length < elementBName.length) {
            return -1;
        }
        if (elementAName.length > elementBName.length) {
            return 1;
        }
    }
    return 0;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/dataTransfer.js":
/*!***********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/dataTransfer.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UriList: () => (/* binding */ UriList),
/* harmony export */   VSDataTransfer: () => (/* binding */ VSDataTransfer),
/* harmony export */   createFileDataTransferItem: () => (/* binding */ createFileDataTransferItem),
/* harmony export */   createStringDataTransferItem: () => (/* binding */ createStringDataTransferItem),
/* harmony export */   matchesMimeType: () => (/* binding */ matchesMimeType)
/* harmony export */ });
/* harmony import */ var _arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./iterator.js */ "./node_modules/vscode/vscode/src/vs/base/common/iterator.js");
/* harmony import */ var _uuid_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./uuid.js */ "./node_modules/vscode/vscode/src/vs/base/common/uuid.js");



function createStringDataTransferItem(stringOrPromise) {
    return {
        asString: async () => stringOrPromise,
        asFile: () => undefined,
        value: typeof stringOrPromise === 'string' ? stringOrPromise : undefined,
    };
}
function createFileDataTransferItem(fileName, uri, data) {
    const file = { id: (0,_uuid_js__WEBPACK_IMPORTED_MODULE_2__.generateUuid)(), name: fileName, uri, data };
    return {
        asString: async () => '',
        asFile: () => file,
        value: undefined,
    };
}
class VSDataTransfer {
    constructor() {
        this._entries = ( new Map());
    }
    get size() {
        let size = 0;
        for (const _ of this._entries) {
            size++;
        }
        return size;
    }
    has(mimeType) {
        return ( this._entries.has(this.toKey(mimeType)));
    }
    matches(pattern) {
        const mimes = [...( this._entries.keys())];
        if (( _iterator_js__WEBPACK_IMPORTED_MODULE_1__.Iterable.some(this, ([_, item]) => item.asFile()))) {
            mimes.push('files');
        }
        return matchesMimeType_normalized(normalizeMimeType(pattern), mimes);
    }
    get(mimeType) {
        return this._entries.get(this.toKey(mimeType))?.[0];
    }
    append(mimeType, value) {
        const existing = this._entries.get(mimeType);
        if (existing) {
            existing.push(value);
        }
        else {
            this._entries.set(this.toKey(mimeType), [value]);
        }
    }
    replace(mimeType, value) {
        this._entries.set(this.toKey(mimeType), [value]);
    }
    delete(mimeType) {
        this._entries.delete(this.toKey(mimeType));
    }
    *[Symbol.iterator]() {
        for (const [mine, items] of this._entries) {
            for (const item of items) {
                yield [mine, item];
            }
        }
    }
    toKey(mimeType) {
        return normalizeMimeType(mimeType);
    }
}
function normalizeMimeType(mimeType) {
    return mimeType.toLowerCase();
}
function matchesMimeType(pattern, mimeTypes) {
    return matchesMimeType_normalized(normalizeMimeType(pattern), ( mimeTypes.map(normalizeMimeType)));
}
function matchesMimeType_normalized(normalizedPattern, normalizedMimeTypes) {
    if (normalizedPattern === '*/*') {
        return normalizedMimeTypes.length > 0;
    }
    if (normalizedMimeTypes.includes(normalizedPattern)) {
        return true;
    }
    const wildcard = normalizedPattern.match(/^([a-z]+)\/([a-z]+|\*)$/i);
    if (!wildcard) {
        return false;
    }
    const [_, type, subtype] = wildcard;
    if (subtype === '*') {
        return ( normalizedMimeTypes.some(mime => mime.startsWith(type + '/')));
    }
    return false;
}
const UriList = ( Object.freeze({
    create: (entries) => {
        return (0,_arrays_js__WEBPACK_IMPORTED_MODULE_0__.distinct)(( entries.map(x => ( x.toString())))).join('\r\n');
    },
    split: (str) => {
        return str.split('\r\n');
    },
    parse: (str) => {
        return UriList.split(str).filter(value => !value.startsWith('#'));
    }
}));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/date.js":
/*!***************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/date.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fromNow: () => (/* binding */ fromNow),
/* harmony export */   getDurationString: () => (/* binding */ getDurationString),
/* harmony export */   toLocalISOString: () => (/* binding */ toLocalISOString)
/* harmony export */ });
/* harmony import */ var _nls_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../nls.js */ "./node_modules/vscode/vscode/src/vs/nls.js");

const _moduleId = "vs/base/common/date";
const minute = 60;
const hour = minute * 60;
const day = hour * 24;
const week = day * 7;
const month = day * 30;
const year = day * 365;
function fromNow(date, appendAgoLabel, useFullTimeWords, disallowNow) {
    if (typeof date !== 'number') {
        date = date.getTime();
    }
    const seconds = Math.round((( (new Date())).getTime() - date) / 1000);
    if (seconds < -30) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(
            _moduleId,
            0,
            'in {0}',
            fromNow(( (new Date())).getTime() + seconds * 1000, false)
        ));
    }
    if (!disallowNow && seconds < 30) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 1, 'now'));
    }
    let value;
    if (seconds < minute) {
        value = seconds;
        if (appendAgoLabel) {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 2, '{0} second ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 3, '{0} sec ago', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 4, '{0} seconds ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 5, '{0} secs ago', value));
            }
        }
        else {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 6, '{0} second', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 7, '{0} sec', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 8, '{0} seconds', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 9, '{0} secs', value));
            }
        }
    }
    if (seconds < hour) {
        value = Math.floor(seconds / minute);
        if (appendAgoLabel) {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 10, '{0} minute ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 11, '{0} min ago', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 12, '{0} minutes ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 13, '{0} mins ago', value));
            }
        }
        else {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 14, '{0} minute', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 15, '{0} min', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 16, '{0} minutes', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 17, '{0} mins', value));
            }
        }
    }
    if (seconds < day) {
        value = Math.floor(seconds / hour);
        if (appendAgoLabel) {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 18, '{0} hour ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 19, '{0} hr ago', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 20, '{0} hours ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 21, '{0} hrs ago', value));
            }
        }
        else {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 22, '{0} hour', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 23, '{0} hr', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 24, '{0} hours', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 25, '{0} hrs', value));
            }
        }
    }
    if (seconds < week) {
        value = Math.floor(seconds / day);
        if (appendAgoLabel) {
            return value === 1
                ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 26, '{0} day ago', value))
                : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 27, '{0} days ago', value));
        }
        else {
            return value === 1
                ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 28, '{0} day', value))
                : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 29, '{0} days', value));
        }
    }
    if (seconds < month) {
        value = Math.floor(seconds / week);
        if (appendAgoLabel) {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 30, '{0} week ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 31, '{0} wk ago', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 32, '{0} weeks ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 33, '{0} wks ago', value));
            }
        }
        else {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 34, '{0} week', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 35, '{0} wk', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 36, '{0} weeks', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 37, '{0} wks', value));
            }
        }
    }
    if (seconds < year) {
        value = Math.floor(seconds / month);
        if (appendAgoLabel) {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 38, '{0} month ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 39, '{0} mo ago', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 40, '{0} months ago', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 41, '{0} mos ago', value));
            }
        }
        else {
            if (value === 1) {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 42, '{0} month', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 43, '{0} mo', value));
            }
            else {
                return useFullTimeWords
                    ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 44, '{0} months', value))
                    : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 45, '{0} mos', value));
            }
        }
    }
    value = Math.floor(seconds / year);
    if (appendAgoLabel) {
        if (value === 1) {
            return useFullTimeWords
                ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 46, '{0} year ago', value))
                : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 47, '{0} yr ago', value));
        }
        else {
            return useFullTimeWords
                ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 48, '{0} years ago', value))
                : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 49, '{0} yrs ago', value));
        }
    }
    else {
        if (value === 1) {
            return useFullTimeWords
                ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 50, '{0} year', value))
                : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 51, '{0} yr', value));
        }
        else {
            return useFullTimeWords
                ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 52, '{0} years', value))
                : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 53, '{0} yrs', value));
        }
    }
}
function getDurationString(ms, useFullTimeWords) {
    const seconds = Math.abs(ms / 1000);
    if (seconds < 1) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 55, '{0}ms', ms));
    }
    if (seconds < minute) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 57, '{0}s', Math.round(ms) / 1000));
    }
    if (seconds < hour) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 59, '{0} mins', Math.round(ms / (1000 * minute))));
    }
    if (seconds < day) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 61, '{0} hrs', Math.round(ms / (1000 * hour))));
    }
    return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_0__.localizeWithPath)(_moduleId, 62, '{0} days', Math.round(ms / (1000 * day))));
}
function toLocalISOString(date) {
    return date.getFullYear() +
        '-' + String(date.getMonth() + 1).padStart(2, '0') +
        '-' + String(date.getDate()).padStart(2, '0') +
        'T' + String(date.getHours()).padStart(2, '0') +
        ':' + String(date.getMinutes()).padStart(2, '0') +
        ':' + String(date.getSeconds()).padStart(2, '0') +
        '.' + (date.getMilliseconds() / 1000).toFixed(3).slice(2, 5) +
        'Z';
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/decorators.js":
/*!*********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/decorators.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: () => (/* binding */ debounce),
/* harmony export */   memoize: () => (/* binding */ memoize),
/* harmony export */   throttle: () => (/* binding */ throttle)
/* harmony export */ });
function createDecorator(mapFn) {
    return (target, key, descriptor) => {
        let fnKey = null;
        let fn = null;
        if (typeof descriptor.value === 'function') {
            fnKey = 'value';
            fn = descriptor.value;
        }
        else if (typeof descriptor.get === 'function') {
            fnKey = 'get';
            fn = descriptor.get;
        }
        if (!fn) {
            throw ( new Error('not supported'));
        }
        descriptor[fnKey] = mapFn(fn, key);
    };
}
function memoize(_target, key, descriptor) {
    let fnKey = null;
    let fn = null;
    if (typeof descriptor.value === 'function') {
        fnKey = 'value';
        fn = descriptor.value;
        if (fn.length !== 0) {
            console.warn('Memoize should only be used in functions with zero parameters');
        }
    }
    else if (typeof descriptor.get === 'function') {
        fnKey = 'get';
        fn = descriptor.get;
    }
    if (!fn) {
        throw ( new Error('not supported'));
    }
    const memoizeKey = `$memoize$${key}`;
    descriptor[fnKey] = function (...args) {
        if (!this.hasOwnProperty(memoizeKey)) {
            Object.defineProperty(this, memoizeKey, {
                configurable: false,
                enumerable: false,
                writable: false,
                value: fn.apply(this, args)
            });
        }
        return this[memoizeKey];
    };
}
function debounce(delay, reducer, initialValueProvider) {
    return ( createDecorator((fn, key) => {
        const timerKey = `$debounce$${key}`;
        const resultKey = `$debounce$result$${key}`;
        return function (...args) {
            if (!this[resultKey]) {
                this[resultKey] = undefined;
            }
            clearTimeout(this[timerKey]);
            this[timerKey] = setTimeout(() => {
                fn.apply(this, args);
                this[resultKey] = undefined;
            }, delay);
        };
    }));
}
function throttle(delay, reducer, initialValueProvider) {
    return ( createDecorator((fn, key) => {
        const timerKey = `$throttle$timer$${key}`;
        const resultKey = `$throttle$result$${key}`;
        const lastRunKey = `$throttle$lastRun$${key}`;
        const pendingKey = `$throttle$pending$${key}`;
        return function (...args) {
            if (!this[resultKey]) {
                this[resultKey] = initialValueProvider ? initialValueProvider() : undefined;
            }
            if (this[lastRunKey] === null || this[lastRunKey] === undefined) {
                this[lastRunKey] = -Number.MAX_VALUE;
            }
            if (reducer) {
                this[resultKey] = reducer(this[resultKey], ...args);
            }
            if (this[pendingKey]) {
                return;
            }
            const nextTime = this[lastRunKey] + delay;
            if (nextTime <= Date.now()) {
                this[lastRunKey] = Date.now();
                fn.apply(this, [this[resultKey]]);
                this[resultKey] = initialValueProvider ? initialValueProvider() : undefined;
            }
            else {
                this[pendingKey] = true;
                this[timerKey] = setTimeout(() => {
                    this[pendingKey] = false;
                    this[lastRunKey] = Date.now();
                    fn.apply(this, [this[resultKey]]);
                    this[resultKey] = initialValueProvider ? initialValueProvider() : undefined;
                }, nextTime - Date.now());
            }
        };
    }));
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/equals.js":
/*!*****************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/equals.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   equalsIfDefined: () => (/* binding */ equalsIfDefined),
/* harmony export */   getStructuralKey: () => (/* binding */ getStructuralKey),
/* harmony export */   itemEquals: () => (/* binding */ itemEquals),
/* harmony export */   itemsEquals: () => (/* binding */ itemsEquals),
/* harmony export */   strictEquals: () => (/* binding */ strictEquals),
/* harmony export */   structuralEquals: () => (/* binding */ structuralEquals)
/* harmony export */ });
/* harmony import */ var _arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");

const strictEquals = (a, b) => a === b;
function itemsEquals(itemEquals = strictEquals) {
    return (a, b) => (0,_arrays_js__WEBPACK_IMPORTED_MODULE_0__.equals)(a, b, itemEquals);
}
function itemEquals() {
    return (a, b) => a.equals(b);
}
function equalsIfDefined(equalsOrV1, v2, equals) {
    if (equals !== undefined) {
        const v1 = equalsOrV1;
        if (v1 === undefined || v1 === null || v2 === undefined || v2 === null) {
            return v2 === v1;
        }
        return equals(v1, v2);
    }
    else {
        const equals = equalsOrV1;
        return (v1, v2) => {
            if (v1 === undefined || v1 === null || v2 === undefined || v2 === null) {
                return v2 === v1;
            }
            return equals(v1, v2);
        };
    }
}
function structuralEquals(a, b) {
    if (a === b) {
        return true;
    }
    if (Array.isArray(a) && Array.isArray(b)) {
        if (a.length !== b.length) {
            return false;
        }
        for (let i = 0; i < a.length; i++) {
            if (!structuralEquals(a[i], b[i])) {
                return false;
            }
        }
        return true;
    }
    if (a && typeof a === 'object' && b && typeof b === 'object') {
        if (Object.getPrototypeOf(a) === Object.prototype && Object.getPrototypeOf(b) === Object.prototype) {
            const aObj = a;
            const bObj = b;
            const keysA = ( Object.keys(aObj));
            const keysB = ( Object.keys(bObj));
            const keysBSet = ( new Set(keysB));
            if (keysA.length !== keysB.length) {
                return false;
            }
            for (const key of keysA) {
                if (!( keysBSet.has(key))) {
                    return false;
                }
                if (!structuralEquals(aObj[key], bObj[key])) {
                    return false;
                }
            }
            return true;
        }
    }
    return false;
}
function getStructuralKey(t) {
    return JSON.stringify(toNormalizedJsonStructure(t));
}
let objectId = 0;
const objIds = ( new WeakMap());
function toNormalizedJsonStructure(t) {
    if (Array.isArray(t)) {
        return ( t.map(toNormalizedJsonStructure));
    }
    if (t && typeof t === 'object') {
        if (Object.getPrototypeOf(t) === Object.prototype) {
            const tObj = t;
            const res = Object.create(null);
            for (const key of ( Object.keys(tObj)).sort()) {
                res[key] = toNormalizedJsonStructure(tObj[key]);
            }
            return res;
        }
        else {
            let objId = objIds.get(t);
            if (objId === undefined) {
                objId = objectId++;
                objIds.set(t, objId);
            }
            return objId + '----2b76a038c20c4bcc';
        }
    }
    return t;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/errorMessage.js":
/*!***********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/errorMessage.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createErrorWithActions: () => (/* binding */ createErrorWithActions),
/* harmony export */   isErrorWithActions: () => (/* binding */ isErrorWithActions),
/* harmony export */   toErrorMessage: () => (/* binding */ toErrorMessage)
/* harmony export */ });
/* harmony import */ var _arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _types_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./types.js */ "./node_modules/vscode/vscode/src/vs/base/common/types.js");
/* harmony import */ var _nls_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../nls.js */ "./node_modules/vscode/vscode/src/vs/nls.js");



const _moduleId = "vs/base/common/errorMessage";
function exceptionToErrorMessage(exception, verbose) {
    if (verbose && (exception.stack || exception.stacktrace)) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(
            _moduleId,
            0,
            "{0}: {1}",
            detectSystemErrorMessage(exception),
            stackToString(exception.stack) || stackToString(exception.stacktrace)
        ));
    }
    return detectSystemErrorMessage(exception);
}
function stackToString(stack) {
    if (Array.isArray(stack)) {
        return stack.join('\n');
    }
    return stack;
}
function detectSystemErrorMessage(exception) {
    if (exception.code === 'ERR_UNC_HOST_NOT_ALLOWED') {
        return `${exception.message}. Please update the 'security.allowedUNCHosts' setting if you want to allow this host.`;
    }
    if (typeof exception.code === 'string' && typeof exception.errno === 'number' && typeof exception.syscall === 'string') {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(_moduleId, 1, "A system error occurred ({0})", exception.message));
    }
    return exception.message || ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(
        _moduleId,
        2,
        "An unknown error occurred. Please consult the log for more details."
    ));
}
function toErrorMessage(error = null, verbose = false) {
    if (!error) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(
            _moduleId,
            2,
            "An unknown error occurred. Please consult the log for more details."
        ));
    }
    if (Array.isArray(error)) {
        const errors = (0,_arrays_js__WEBPACK_IMPORTED_MODULE_0__.coalesce)(error);
        const msg = toErrorMessage(errors[0], verbose);
        if (errors.length > 1) {
            return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(_moduleId, 3, "{0} ({1} errors in total)", msg, errors.length));
        }
        return msg;
    }
    if ((0,_types_js__WEBPACK_IMPORTED_MODULE_1__.isString)(error)) {
        return error;
    }
    if (error.detail) {
        const detail = error.detail;
        if (detail.error) {
            return exceptionToErrorMessage(detail.error, verbose);
        }
        if (detail.exception) {
            return exceptionToErrorMessage(detail.exception, verbose);
        }
    }
    if (error.stack) {
        return exceptionToErrorMessage(error, verbose);
    }
    if (error.message) {
        return error.message;
    }
    return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(
        _moduleId,
        2,
        "An unknown error occurred. Please consult the log for more details."
    ));
}
function isErrorWithActions(obj) {
    const candidate = obj;
    return candidate instanceof Error && Array.isArray(candidate.actions);
}
function createErrorWithActions(messageOrError, actions) {
    let error;
    if (typeof messageOrError === 'string') {
        error = ( (new Error(messageOrError)));
    }
    else {
        error = messageOrError;
    }
    error.actions = actions;
    return error;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/extpath.js":
/*!******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/extpath.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getDriveLetter: () => (/* binding */ getDriveLetter),
/* harmony export */   getRoot: () => (/* binding */ getRoot),
/* harmony export */   hasDriveLetter: () => (/* binding */ hasDriveLetter),
/* harmony export */   indexOfPath: () => (/* binding */ indexOfPath),
/* harmony export */   isEqual: () => (/* binding */ isEqual),
/* harmony export */   isEqualOrParent: () => (/* binding */ isEqualOrParent),
/* harmony export */   isPathSeparator: () => (/* binding */ isPathSeparator),
/* harmony export */   isUNC: () => (/* binding */ isUNC),
/* harmony export */   isValidBasename: () => (/* binding */ isValidBasename),
/* harmony export */   isWindowsDriveLetter: () => (/* binding */ isWindowsDriveLetter),
/* harmony export */   parseLineAndColumnAware: () => (/* binding */ parseLineAndColumnAware),
/* harmony export */   randomPath: () => (/* binding */ randomPath),
/* harmony export */   toPosixPath: () => (/* binding */ toPosixPath),
/* harmony export */   toSlashes: () => (/* binding */ toSlashes)
/* harmony export */ });
/* harmony import */ var _charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./path.js */ "./node_modules/vscode/vscode/src/vs/base/common/path.js");
/* harmony import */ var _platform_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _types_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./types.js */ "./node_modules/vscode/vscode/src/vs/base/common/types.js");





function isPathSeparator(code) {
    return code === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Slash || code === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Backslash;
}
function toSlashes(osPath) {
    return osPath.replace(/[\\/]/g, _path_js__WEBPACK_IMPORTED_MODULE_1__.posix.sep);
}
function toPosixPath(osPath) {
    if (osPath.indexOf('/') === -1) {
        osPath = toSlashes(osPath);
    }
    if (/^[a-zA-Z]:(\/|$)/.test(osPath)) {
        osPath = '/' + osPath;
    }
    return osPath;
}
function getRoot(path, sep = _path_js__WEBPACK_IMPORTED_MODULE_1__.posix.sep) {
    if (!path) {
        return '';
    }
    const len = path.length;
    const firstLetter = path.charCodeAt(0);
    if (isPathSeparator(firstLetter)) {
        if (isPathSeparator(path.charCodeAt(1))) {
            if (!isPathSeparator(path.charCodeAt(2))) {
                let pos = 3;
                const start = pos;
                for (; pos < len; pos++) {
                    if (isPathSeparator(path.charCodeAt(pos))) {
                        break;
                    }
                }
                if (start !== pos && !isPathSeparator(path.charCodeAt(pos + 1))) {
                    pos += 1;
                    for (; pos < len; pos++) {
                        if (isPathSeparator(path.charCodeAt(pos))) {
                            return path.slice(0, pos + 1)
                                .replace(/[\\/]/g, sep);
                        }
                    }
                }
            }
        }
        return sep;
    }
    else if (isWindowsDriveLetter(firstLetter)) {
        if (path.charCodeAt(1) === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Colon) {
            if (isPathSeparator(path.charCodeAt(2))) {
                return path.slice(0, 2) + sep;
            }
            else {
                return path.slice(0, 2);
            }
        }
    }
    let pos = path.indexOf('://');
    if (pos !== -1) {
        pos += 3;
        for (; pos < len; pos++) {
            if (isPathSeparator(path.charCodeAt(pos))) {
                return path.slice(0, pos + 1);
            }
        }
    }
    return '';
}
function isUNC(path) {
    if (!_platform_js__WEBPACK_IMPORTED_MODULE_2__.isWindows) {
        return false;
    }
    if (!path || path.length < 5) {
        return false;
    }
    let code = path.charCodeAt(0);
    if (code !== _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Backslash) {
        return false;
    }
    code = path.charCodeAt(1);
    if (code !== _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Backslash) {
        return false;
    }
    let pos = 2;
    const start = pos;
    for (; pos < path.length; pos++) {
        code = path.charCodeAt(pos);
        if (code === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Backslash) {
            break;
        }
    }
    if (start === pos) {
        return false;
    }
    code = path.charCodeAt(pos + 1);
    if (isNaN(code) || code === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Backslash) {
        return false;
    }
    return true;
}
const WINDOWS_INVALID_FILE_CHARS = /[\\/:\*\?"<>\|]/g;
const UNIX_INVALID_FILE_CHARS = /[/]/g;
const WINDOWS_FORBIDDEN_NAMES = /^(con|prn|aux|clock\$|nul|lpt[0-9]|com[0-9])(\.(.*?))?$/i;
function isValidBasename(name, isWindowsOS = _platform_js__WEBPACK_IMPORTED_MODULE_2__.isWindows) {
    const invalidFileChars = isWindowsOS ? WINDOWS_INVALID_FILE_CHARS : UNIX_INVALID_FILE_CHARS;
    if (!name || name.length === 0 || /^\s+$/.test(name)) {
        return false;
    }
    invalidFileChars.lastIndex = 0;
    if (invalidFileChars.test(name)) {
        return false;
    }
    if (isWindowsOS && WINDOWS_FORBIDDEN_NAMES.test(name)) {
        return false;
    }
    if (name === '.' || name === '..') {
        return false;
    }
    if (isWindowsOS && name[name.length - 1] === '.') {
        return false;
    }
    if (isWindowsOS && name.length !== name.trim().length) {
        return false;
    }
    if (name.length > 255) {
        return false;
    }
    return true;
}
function isEqual(pathA, pathB, ignoreCase) {
    const identityEquals = (pathA === pathB);
    if (!ignoreCase || identityEquals) {
        return identityEquals;
    }
    if (!pathA || !pathB) {
        return false;
    }
    return (0,_strings_js__WEBPACK_IMPORTED_MODULE_3__.equalsIgnoreCase)(pathA, pathB);
}
function isEqualOrParent(base, parentCandidate, ignoreCase, separator = _path_js__WEBPACK_IMPORTED_MODULE_1__.sep) {
    if (base === parentCandidate) {
        return true;
    }
    if (!base || !parentCandidate) {
        return false;
    }
    if (parentCandidate.length > base.length) {
        return false;
    }
    if (ignoreCase) {
        const beginsWith = (0,_strings_js__WEBPACK_IMPORTED_MODULE_3__.startsWithIgnoreCase)(base, parentCandidate);
        if (!beginsWith) {
            return false;
        }
        if (parentCandidate.length === base.length) {
            return true;
        }
        let sepOffset = parentCandidate.length;
        if (parentCandidate.charAt(parentCandidate.length - 1) === separator) {
            sepOffset--;
        }
        return base.charAt(sepOffset) === separator;
    }
    if (parentCandidate.charAt(parentCandidate.length - 1) !== separator) {
        parentCandidate += separator;
    }
    return base.indexOf(parentCandidate) === 0;
}
function isWindowsDriveLetter(char0) {
    return char0 >= _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.A && char0 <= _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Z || char0 >= _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.a && char0 <= _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.z;
}
function hasDriveLetter(path, isWindowsOS = _platform_js__WEBPACK_IMPORTED_MODULE_2__.isWindows) {
    if (isWindowsOS) {
        return isWindowsDriveLetter(path.charCodeAt(0)) && path.charCodeAt(1) === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Colon;
    }
    return false;
}
function getDriveLetter(path, isWindowsOS = _platform_js__WEBPACK_IMPORTED_MODULE_2__.isWindows) {
    return hasDriveLetter(path, isWindowsOS) ? path[0] : undefined;
}
function indexOfPath(path, candidate, ignoreCase) {
    if (candidate.length > path.length) {
        return -1;
    }
    if (path === candidate) {
        return 0;
    }
    if (ignoreCase) {
        path = path.toLowerCase();
        candidate = candidate.toLowerCase();
    }
    return path.indexOf(candidate);
}
function parseLineAndColumnAware(rawPath) {
    const segments = rawPath.split(':');
    let path = undefined;
    let line = undefined;
    let column = undefined;
    for (const segment of segments) {
        const segmentAsNumber = Number(segment);
        if (!(0,_types_js__WEBPACK_IMPORTED_MODULE_4__.isNumber)(segmentAsNumber)) {
            path = !!path ? [path, segment].join(':') : segment;
        }
        else if (line === undefined) {
            line = segmentAsNumber;
        }
        else if (column === undefined) {
            column = segmentAsNumber;
        }
    }
    if (!path) {
        throw ( new Error('Format for `--goto` should be: `FILE:LINE(:COLUMN)`'));
    }
    return {
        path,
        line: line !== undefined ? line : undefined,
        column: column !== undefined ? column : line !== undefined ? 1 : undefined
    };
}
const pathChars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
const windowsSafePathFirstChars = 'BDEFGHIJKMOQRSTUVWXYZbdefghijkmoqrstuvwxyz0123456789';
function randomPath(parent, prefix, randomLength = 8) {
    let suffix = '';
    for (let i = 0; i < randomLength; i++) {
        let pathCharsTouse;
        if (i === 0 && _platform_js__WEBPACK_IMPORTED_MODULE_2__.isWindows && !prefix && (randomLength === 3 || randomLength === 4)) {
            pathCharsTouse = windowsSafePathFirstChars;
        }
        else {
            pathCharsTouse = pathChars;
        }
        suffix += pathCharsTouse.charAt(Math.floor(Math.random() * pathCharsTouse.length));
    }
    let randomFileName;
    {
        randomFileName = suffix;
    }
    return randomFileName;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/filters.js":
/*!******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/filters.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FuzzyScore: () => (/* binding */ FuzzyScore),
/* harmony export */   FuzzyScoreOptions: () => (/* binding */ FuzzyScoreOptions),
/* harmony export */   anyScore: () => (/* binding */ anyScore),
/* harmony export */   createMatches: () => (/* binding */ createMatches),
/* harmony export */   fuzzyScore: () => (/* binding */ fuzzyScore),
/* harmony export */   fuzzyScoreGracefulAggressive: () => (/* binding */ fuzzyScoreGracefulAggressive),
/* harmony export */   isPatternInWord: () => (/* binding */ isPatternInWord),
/* harmony export */   isUpper: () => (/* binding */ isUpper),
/* harmony export */   matchesCamelCase: () => (/* binding */ matchesCamelCase),
/* harmony export */   matchesContiguousSubString: () => (/* binding */ matchesContiguousSubString),
/* harmony export */   matchesFuzzy: () => (/* binding */ matchesFuzzy),
/* harmony export */   matchesFuzzy2: () => (/* binding */ matchesFuzzy2),
/* harmony export */   matchesPrefix: () => (/* binding */ matchesPrefix),
/* harmony export */   matchesSubString: () => (/* binding */ matchesSubString),
/* harmony export */   matchesWords: () => (/* binding */ matchesWords),
/* harmony export */   or: () => (/* binding */ or)
/* harmony export */ });
/* harmony import */ var _charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./map.js */ "./node_modules/vscode/vscode/src/vs/base/common/map.js");
/* harmony import */ var _naturalLanguage_korean_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./naturalLanguage/korean.js */ "./node_modules/vscode/vscode/src/vs/base/common/naturalLanguage/korean.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");




function or(...filter) {
    return function (word, wordToMatchAgainst) {
        for (let i = 0, len = filter.length; i < len; i++) {
            const match = filter[i](word, wordToMatchAgainst);
            if (match) {
                return match;
            }
        }
        return null;
    };
}
_matchesPrefix.bind(undefined, false);
const matchesPrefix = _matchesPrefix.bind(undefined, true);
function _matchesPrefix(ignoreCase, word, wordToMatchAgainst) {
    if (!wordToMatchAgainst || wordToMatchAgainst.length < word.length) {
        return null;
    }
    let matches;
    if (ignoreCase) {
        matches = (0,_strings_js__WEBPACK_IMPORTED_MODULE_3__.startsWithIgnoreCase)(wordToMatchAgainst, word);
    }
    else {
        matches = wordToMatchAgainst.indexOf(word) === 0;
    }
    if (!matches) {
        return null;
    }
    return word.length > 0 ? [{ start: 0, end: word.length }] : [];
}
function matchesContiguousSubString(word, wordToMatchAgainst) {
    const index = wordToMatchAgainst.toLowerCase().indexOf(word.toLowerCase());
    if (index === -1) {
        return null;
    }
    return [{ start: index, end: index + word.length }];
}
function matchesSubString(word, wordToMatchAgainst) {
    return _matchesSubString(word.toLowerCase(), wordToMatchAgainst.toLowerCase(), 0, 0);
}
function _matchesSubString(word, wordToMatchAgainst, i, j) {
    if (i === word.length) {
        return [];
    }
    else if (j === wordToMatchAgainst.length) {
        return null;
    }
    else {
        if (word[i] === wordToMatchAgainst[j]) {
            let result = null;
            if (result = _matchesSubString(word, wordToMatchAgainst, i + 1, j + 1)) {
                return join({ start: j, end: j + 1 }, result);
            }
            return null;
        }
        return _matchesSubString(word, wordToMatchAgainst, i, j + 1);
    }
}
function isLower(code) {
    return _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.a <= code && code <= _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.z;
}
function isUpper(code) {
    return _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.A <= code && code <= _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Z;
}
function isNumber(code) {
    return _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit0 <= code && code <= _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit9;
}
function isWhitespace(code) {
    return (code === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Space
        || code === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Tab
        || code === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed
        || code === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn);
}
const wordSeparators = ( new Set());
'()[]{}<>`\'"-/;:,.?!'
    .split('')
    .forEach(s => wordSeparators.add(s.charCodeAt(0)));
function isWordSeparator(code) {
    return isWhitespace(code) || ( wordSeparators.has(code));
}
function charactersMatch(codeA, codeB) {
    return (codeA === codeB) || (isWordSeparator(codeA) && isWordSeparator(codeB));
}
const alternateCharsCache = ( new Map());
function getAlternateCodes(code) {
    if (( alternateCharsCache.has(code))) {
        return alternateCharsCache.get(code);
    }
    let result;
    const codes = (0,_naturalLanguage_korean_js__WEBPACK_IMPORTED_MODULE_2__.getKoreanAltChars)(code);
    if (codes) {
        result = codes;
    }
    alternateCharsCache.set(code, result);
    return result;
}
function isAlphanumeric(code) {
    return isLower(code) || isUpper(code) || isNumber(code);
}
function join(head, tail) {
    if (tail.length === 0) {
        tail = [head];
    }
    else if (head.end === tail[0].start) {
        tail[0].start = head.start;
    }
    else {
        tail.unshift(head);
    }
    return tail;
}
function nextAnchor(camelCaseWord, start) {
    for (let i = start; i < camelCaseWord.length; i++) {
        const c = camelCaseWord.charCodeAt(i);
        if (isUpper(c) || isNumber(c) || (i > 0 && !isAlphanumeric(camelCaseWord.charCodeAt(i - 1)))) {
            return i;
        }
    }
    return camelCaseWord.length;
}
function _matchesCamelCase(word, camelCaseWord, i, j) {
    if (i === word.length) {
        return [];
    }
    else if (j === camelCaseWord.length) {
        return null;
    }
    else if (word[i] !== camelCaseWord[j].toLowerCase()) {
        return null;
    }
    else {
        let result = null;
        let nextUpperIndex = j + 1;
        result = _matchesCamelCase(word, camelCaseWord, i + 1, j + 1);
        while (!result && (nextUpperIndex = nextAnchor(camelCaseWord, nextUpperIndex)) < camelCaseWord.length) {
            result = _matchesCamelCase(word, camelCaseWord, i + 1, nextUpperIndex);
            nextUpperIndex++;
        }
        return result === null ? null : join({ start: j, end: j + 1 }, result);
    }
}
function analyzeCamelCaseWord(word) {
    let upper = 0, lower = 0, alpha = 0, numeric = 0, code = 0;
    for (let i = 0; i < word.length; i++) {
        code = word.charCodeAt(i);
        if (isUpper(code)) {
            upper++;
        }
        if (isLower(code)) {
            lower++;
        }
        if (isAlphanumeric(code)) {
            alpha++;
        }
        if (isNumber(code)) {
            numeric++;
        }
    }
    const upperPercent = upper / word.length;
    const lowerPercent = lower / word.length;
    const alphaPercent = alpha / word.length;
    const numericPercent = numeric / word.length;
    return { upperPercent, lowerPercent, alphaPercent, numericPercent };
}
function isUpperCaseWord(analysis) {
    const { upperPercent, lowerPercent } = analysis;
    return lowerPercent === 0 && upperPercent > 0.6;
}
function isCamelCaseWord(analysis) {
    const { upperPercent, lowerPercent, alphaPercent, numericPercent } = analysis;
    return lowerPercent > 0.2 && upperPercent < 0.8 && alphaPercent > 0.6 && numericPercent < 0.2;
}
function isCamelCasePattern(word) {
    let upper = 0, lower = 0, code = 0, whitespace = 0;
    for (let i = 0; i < word.length; i++) {
        code = word.charCodeAt(i);
        if (isUpper(code)) {
            upper++;
        }
        if (isLower(code)) {
            lower++;
        }
        if (isWhitespace(code)) {
            whitespace++;
        }
    }
    if ((upper === 0 || lower === 0) && whitespace === 0) {
        return word.length <= 30;
    }
    else {
        return upper <= 5;
    }
}
function matchesCamelCase(word, camelCaseWord) {
    if (!camelCaseWord) {
        return null;
    }
    camelCaseWord = camelCaseWord.trim();
    if (camelCaseWord.length === 0) {
        return null;
    }
    if (!isCamelCasePattern(word)) {
        return null;
    }
    if (camelCaseWord.length > 60) {
        camelCaseWord = camelCaseWord.substring(0, 60);
    }
    const analysis = analyzeCamelCaseWord(camelCaseWord);
    if (!isCamelCaseWord(analysis)) {
        if (!isUpperCaseWord(analysis)) {
            return null;
        }
        camelCaseWord = camelCaseWord.toLowerCase();
    }
    let result = null;
    let i = 0;
    word = word.toLowerCase();
    while (i < camelCaseWord.length && (result = _matchesCamelCase(word, camelCaseWord, 0, i)) === null) {
        i = nextAnchor(camelCaseWord, i + 1);
    }
    return result;
}
function matchesWords(word, target, contiguous = false) {
    if (!target || target.length === 0) {
        return null;
    }
    let result = null;
    let targetIndex = 0;
    word = word.toLowerCase();
    target = target.toLowerCase();
    while (targetIndex < target.length) {
        result = _matchesWords(word, target, 0, targetIndex, contiguous);
        if (result !== null) {
            break;
        }
        targetIndex = nextWord(target, targetIndex + 1);
    }
    return result;
}
function _matchesWords(word, target, wordIndex, targetIndex, contiguous) {
    let targetIndexOffset = 0;
    if (wordIndex === word.length) {
        return [];
    }
    else if (targetIndex === target.length) {
        return null;
    }
    else if (!charactersMatch(word.charCodeAt(wordIndex), target.charCodeAt(targetIndex))) {
        const altChars = getAlternateCodes(word.charCodeAt(wordIndex));
        if (!altChars) {
            return null;
        }
        for (let k = 0; k < altChars.length; k++) {
            if (!charactersMatch(altChars[k], target.charCodeAt(targetIndex + k))) {
                return null;
            }
        }
        targetIndexOffset += altChars.length - 1;
    }
    let result = null;
    let nextWordIndex = targetIndex + targetIndexOffset + 1;
    result = _matchesWords(word, target, wordIndex + 1, nextWordIndex, contiguous);
    if (!contiguous) {
        while (!result && (nextWordIndex = nextWord(target, nextWordIndex)) < target.length) {
            result = _matchesWords(word, target, wordIndex + 1, nextWordIndex, contiguous);
            nextWordIndex++;
        }
    }
    if (!result) {
        return null;
    }
    if (word.charCodeAt(wordIndex) !== target.charCodeAt(targetIndex)) {
        const altChars = getAlternateCodes(word.charCodeAt(wordIndex));
        if (!altChars) {
            return result;
        }
        for (let k = 0; k < altChars.length; k++) {
            if (altChars[k] !== target.charCodeAt(targetIndex + k)) {
                return result;
            }
        }
    }
    return join({ start: targetIndex, end: targetIndex + targetIndexOffset + 1 }, result);
}
function nextWord(word, start) {
    for (let i = start; i < word.length; i++) {
        if (isWordSeparator(word.charCodeAt(i)) ||
            (i > 0 && isWordSeparator(word.charCodeAt(i - 1)))) {
            return i;
        }
    }
    return word.length;
}
const fuzzyContiguousFilter = or(matchesPrefix, matchesCamelCase, matchesContiguousSubString);
const fuzzySeparateFilter = or(matchesPrefix, matchesCamelCase, matchesSubString);
const fuzzyRegExpCache = ( new _map_js__WEBPACK_IMPORTED_MODULE_1__.LRUCache(10000));
function matchesFuzzy(word, wordToMatchAgainst, enableSeparateSubstringMatching = false) {
    if (typeof word !== 'string' || typeof wordToMatchAgainst !== 'string') {
        return null;
    }
    let regexp = fuzzyRegExpCache.get(word);
    if (!regexp) {
        regexp = ( new RegExp((0,_strings_js__WEBPACK_IMPORTED_MODULE_3__.convertSimple2RegExpPattern)(word), 'i'));
        fuzzyRegExpCache.set(word, regexp);
    }
    const match = regexp.exec(wordToMatchAgainst);
    if (match) {
        return [{ start: match.index, end: match.index + match[0].length }];
    }
    return enableSeparateSubstringMatching ? fuzzySeparateFilter(word, wordToMatchAgainst) : fuzzyContiguousFilter(word, wordToMatchAgainst);
}
function matchesFuzzy2(pattern, word) {
    const score = fuzzyScore(pattern, pattern.toLowerCase(), 0, word, word.toLowerCase(), 0, { firstMatchCanBeWeak: true, boostFullMatch: true });
    return score ? createMatches(score) : null;
}
function anyScore(pattern, lowPattern, patternPos, word, lowWord, wordPos) {
    const max = Math.min(13, pattern.length);
    for (; patternPos < max; patternPos++) {
        const result = fuzzyScore(pattern, lowPattern, patternPos, word, lowWord, wordPos, { firstMatchCanBeWeak: true, boostFullMatch: true });
        if (result) {
            return result;
        }
    }
    return [0, wordPos];
}
function createMatches(score) {
    if (typeof score === 'undefined') {
        return [];
    }
    const res = [];
    const wordPos = score[1];
    for (let i = score.length - 1; i > 1; i--) {
        const pos = score[i] + wordPos;
        const last = res[res.length - 1];
        if (last && last.end === pos) {
            last.end = pos + 1;
        }
        else {
            res.push({ start: pos, end: pos + 1 });
        }
    }
    return res;
}
const _maxLen = 128;
function initTable() {
    const table = [];
    const row = [];
    for (let i = 0; i <= _maxLen; i++) {
        row[i] = 0;
    }
    for (let i = 0; i <= _maxLen; i++) {
        table.push(row.slice(0));
    }
    return table;
}
function initArr(maxLen) {
    const row = [];
    for (let i = 0; i <= maxLen; i++) {
        row[i] = 0;
    }
    return row;
}
const _minWordMatchPos = initArr(2 * _maxLen);
const _maxWordMatchPos = initArr(2 * _maxLen);
const _diag = initTable();
const _table = initTable();
const _arrows = initTable();
function isSeparatorAtPos(value, index) {
    if (index < 0 || index >= value.length) {
        return false;
    }
    const code = value.codePointAt(index);
    switch (code) {
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Underline:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Dash:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Period:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Space:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Slash:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Backslash:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.SingleQuote:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.DoubleQuote:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Colon:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.DollarSign:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LessThan:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.GreaterThan:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.OpenParen:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CloseParen:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.OpenSquareBracket:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CloseSquareBracket:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.OpenCurlyBrace:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CloseCurlyBrace:
            return true;
        case undefined:
            return false;
        default:
            if ((0,_strings_js__WEBPACK_IMPORTED_MODULE_3__.isEmojiImprecise)(code)) {
                return true;
            }
            return false;
    }
}
function isWhitespaceAtPos(value, index) {
    if (index < 0 || index >= value.length) {
        return false;
    }
    const code = value.charCodeAt(index);
    switch (code) {
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Space:
        case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Tab:
            return true;
        default:
            return false;
    }
}
function isUpperCaseAtPos(pos, word, wordLow) {
    return word[pos] !== wordLow[pos];
}
function isPatternInWord(patternLow, patternPos, patternLen, wordLow, wordPos, wordLen, fillMinWordPosArr = false) {
    while (patternPos < patternLen && wordPos < wordLen) {
        if (patternLow[patternPos] === wordLow[wordPos]) {
            if (fillMinWordPosArr) {
                _minWordMatchPos[patternPos] = wordPos;
            }
            patternPos += 1;
        }
        wordPos += 1;
    }
    return patternPos === patternLen;
}
var Arrow;
( (function(Arrow) {
    Arrow[Arrow["Diag"] = 1] = "Diag";
    Arrow[Arrow["Left"] = 2] = "Left";
    Arrow[Arrow["LeftLeft"] = 3] = "LeftLeft";
})(Arrow || (Arrow = {})));
var FuzzyScore;
( (function(FuzzyScore) {
    FuzzyScore.Default = ([-100, 0]);
    function isDefault(score) {
        return !score || (score.length === 2 && score[0] === -100 && score[1] === 0);
    }
    FuzzyScore.isDefault = isDefault;
})(FuzzyScore || (FuzzyScore = {})));
class FuzzyScoreOptions {
    static { this.default = { boostFullMatch: true, firstMatchCanBeWeak: false }; }
    constructor(firstMatchCanBeWeak, boostFullMatch) {
        this.firstMatchCanBeWeak = firstMatchCanBeWeak;
        this.boostFullMatch = boostFullMatch;
    }
}
function fuzzyScore(pattern, patternLow, patternStart, word, wordLow, wordStart, options = FuzzyScoreOptions.default) {
    const patternLen = pattern.length > _maxLen ? _maxLen : pattern.length;
    const wordLen = word.length > _maxLen ? _maxLen : word.length;
    if (patternStart >= patternLen || wordStart >= wordLen || (patternLen - patternStart) > (wordLen - wordStart)) {
        return undefined;
    }
    if (!isPatternInWord(patternLow, patternStart, patternLen, wordLow, wordStart, wordLen, true)) {
        return undefined;
    }
    _fillInMaxWordMatchPos(patternLen, wordLen, patternStart, wordStart, patternLow, wordLow);
    let row = 1;
    let column = 1;
    let patternPos = patternStart;
    let wordPos = wordStart;
    const hasStrongFirstMatch = [false];
    for (row = 1, patternPos = patternStart; patternPos < patternLen; row++, patternPos++) {
        const minWordMatchPos = _minWordMatchPos[patternPos];
        const maxWordMatchPos = _maxWordMatchPos[patternPos];
        const nextMaxWordMatchPos = (patternPos + 1 < patternLen ? _maxWordMatchPos[patternPos + 1] : wordLen);
        for (column = minWordMatchPos - wordStart + 1, wordPos = minWordMatchPos; wordPos < nextMaxWordMatchPos; column++, wordPos++) {
            let score = Number.MIN_SAFE_INTEGER;
            let canComeDiag = false;
            if (wordPos <= maxWordMatchPos) {
                score = _doScore(pattern, patternLow, patternPos, patternStart, word, wordLow, wordPos, wordLen, wordStart, _diag[row - 1][column - 1] === 0, hasStrongFirstMatch);
            }
            let diagScore = 0;
            if (score !== Number.MAX_SAFE_INTEGER) {
                canComeDiag = true;
                diagScore = score + _table[row - 1][column - 1];
            }
            const canComeLeft = wordPos > minWordMatchPos;
            const leftScore = canComeLeft ? _table[row][column - 1] + (_diag[row][column - 1] > 0 ? -5 : 0) : 0;
            const canComeLeftLeft = wordPos > minWordMatchPos + 1 && _diag[row][column - 1] > 0;
            const leftLeftScore = canComeLeftLeft ? _table[row][column - 2] + (_diag[row][column - 2] > 0 ? -5 : 0) : 0;
            if (canComeLeftLeft && (!canComeLeft || leftLeftScore >= leftScore) && (!canComeDiag || leftLeftScore >= diagScore)) {
                _table[row][column] = leftLeftScore;
                _arrows[row][column] = Arrow.LeftLeft;
                _diag[row][column] = 0;
            }
            else if (canComeLeft && (!canComeDiag || leftScore >= diagScore)) {
                _table[row][column] = leftScore;
                _arrows[row][column] = Arrow.Left;
                _diag[row][column] = 0;
            }
            else if (canComeDiag) {
                _table[row][column] = diagScore;
                _arrows[row][column] = Arrow.Diag;
                _diag[row][column] = _diag[row - 1][column - 1] + 1;
            }
            else {
                throw ( new Error(`not possible`));
            }
        }
    }
    if (!hasStrongFirstMatch[0] && !options.firstMatchCanBeWeak) {
        return undefined;
    }
    row--;
    column--;
    const result = [_table[row][column], wordStart];
    let backwardsDiagLength = 0;
    let maxMatchColumn = 0;
    while (row >= 1) {
        let diagColumn = column;
        do {
            const arrow = _arrows[row][diagColumn];
            if (arrow === Arrow.LeftLeft) {
                diagColumn = diagColumn - 2;
            }
            else if (arrow === Arrow.Left) {
                diagColumn = diagColumn - 1;
            }
            else {
                break;
            }
        } while (diagColumn >= 1);
        if (backwardsDiagLength > 1
            && patternLow[patternStart + row - 1] === wordLow[wordStart + column - 1]
            && !isUpperCaseAtPos(diagColumn + wordStart - 1, word, wordLow)
            && backwardsDiagLength + 1 > _diag[row][diagColumn]
        ) {
            diagColumn = column;
        }
        if (diagColumn === column) {
            backwardsDiagLength++;
        }
        else {
            backwardsDiagLength = 1;
        }
        if (!maxMatchColumn) {
            maxMatchColumn = diagColumn;
        }
        row--;
        column = diagColumn - 1;
        result.push(column);
    }
    if (wordLen - wordStart === patternLen && options.boostFullMatch) {
        result[0] += 2;
    }
    const skippedCharsCount = maxMatchColumn - patternLen;
    result[0] -= skippedCharsCount;
    return result;
}
function _fillInMaxWordMatchPos(patternLen, wordLen, patternStart, wordStart, patternLow, wordLow) {
    let patternPos = patternLen - 1;
    let wordPos = wordLen - 1;
    while (patternPos >= patternStart && wordPos >= wordStart) {
        if (patternLow[patternPos] === wordLow[wordPos]) {
            _maxWordMatchPos[patternPos] = wordPos;
            patternPos--;
        }
        wordPos--;
    }
}
function _doScore(pattern, patternLow, patternPos, patternStart, word, wordLow, wordPos, wordLen, wordStart, newMatchStart, outFirstMatchStrong) {
    if (patternLow[patternPos] !== wordLow[wordPos]) {
        return Number.MIN_SAFE_INTEGER;
    }
    let score = 1;
    let isGapLocation = false;
    if (wordPos === (patternPos - patternStart)) {
        score = pattern[patternPos] === word[wordPos] ? 7 : 5;
    }
    else if (isUpperCaseAtPos(wordPos, word, wordLow) && (wordPos === 0 || !isUpperCaseAtPos(wordPos - 1, word, wordLow))) {
        score = pattern[patternPos] === word[wordPos] ? 7 : 5;
        isGapLocation = true;
    }
    else if (isSeparatorAtPos(wordLow, wordPos) && (wordPos === 0 || !isSeparatorAtPos(wordLow, wordPos - 1))) {
        score = 5;
    }
    else if (isSeparatorAtPos(wordLow, wordPos - 1) || isWhitespaceAtPos(wordLow, wordPos - 1)) {
        score = 5;
        isGapLocation = true;
    }
    if (score > 1 && patternPos === patternStart) {
        outFirstMatchStrong[0] = true;
    }
    if (!isGapLocation) {
        isGapLocation = isUpperCaseAtPos(wordPos, word, wordLow) || isSeparatorAtPos(wordLow, wordPos - 1) || isWhitespaceAtPos(wordLow, wordPos - 1);
    }
    if (patternPos === patternStart) {
        if (wordPos > wordStart) {
            score -= isGapLocation ? 3 : 5;
        }
    }
    else {
        if (newMatchStart) {
            score += isGapLocation ? 2 : 0;
        }
        else {
            score += isGapLocation ? 0 : 1;
        }
    }
    if (wordPos + 1 === wordLen) {
        score -= isGapLocation ? 3 : 5;
    }
    return score;
}
function fuzzyScoreGracefulAggressive(pattern, lowPattern, patternPos, word, lowWord, wordPos, options) {
    return fuzzyScoreWithPermutations(pattern, lowPattern, patternPos, word, lowWord, wordPos, true, options);
}
function fuzzyScoreWithPermutations(pattern, lowPattern, patternPos, word, lowWord, wordPos, aggressive, options) {
    let top = fuzzyScore(pattern, lowPattern, patternPos, word, lowWord, wordPos, options);
    if (top && !aggressive) {
        return top;
    }
    if (pattern.length >= 3) {
        const tries = Math.min(7, pattern.length - 1);
        for (let movingPatternPos = patternPos + 1; movingPatternPos < tries; movingPatternPos++) {
            const newPattern = nextTypoPermutation(pattern, movingPatternPos);
            if (newPattern) {
                const candidate = fuzzyScore(newPattern, newPattern.toLowerCase(), patternPos, word, lowWord, wordPos, options);
                if (candidate) {
                    candidate[0] -= 3;
                    if (!top || candidate[0] > top[0]) {
                        top = candidate;
                    }
                }
            }
        }
    }
    return top;
}
function nextTypoPermutation(pattern, patternPos) {
    if (patternPos + 1 >= pattern.length) {
        return undefined;
    }
    const swap1 = pattern[patternPos];
    const swap2 = pattern[patternPos + 1];
    if (swap1 === swap2) {
        return undefined;
    }
    return pattern.slice(0, patternPos)
        + swap2
        + swap1
        + pattern.slice(patternPos + 2);
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/glob.js":
/*!***************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/glob.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GLOBSTAR: () => (/* binding */ GLOBSTAR),
/* harmony export */   GLOB_SPLIT: () => (/* binding */ GLOB_SPLIT),
/* harmony export */   getEmptyExpression: () => (/* binding */ getEmptyExpression),
/* harmony export */   isRelativePattern: () => (/* binding */ isRelativePattern),
/* harmony export */   match: () => (/* binding */ match),
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   splitGlobAware: () => (/* binding */ splitGlobAware)
/* harmony export */ });
/* harmony import */ var _arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _async_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./async.js */ "./node_modules/vscode/vscode/src/vs/base/common/async.js");
/* harmony import */ var _charCode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _extpath_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./extpath.js */ "./node_modules/vscode/vscode/src/vs/base/common/extpath.js");
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./map.js */ "./node_modules/vscode/vscode/src/vs/base/common/map.js");
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./path.js */ "./node_modules/vscode/vscode/src/vs/base/common/path.js");
/* harmony import */ var _platform_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");








function getEmptyExpression() {
    return Object.create(null);
}
const GLOBSTAR = '**';
const GLOB_SPLIT = '/';
const PATH_REGEX = '[/\\\\]';
const NO_PATH_REGEX = '[^/\\\\]';
const ALL_FORWARD_SLASHES = /\//g;
function starsToRegExp(starCount, isLastPattern) {
    switch (starCount) {
        case 0:
            return '';
        case 1:
            return `${NO_PATH_REGEX}*?`;
        default:
            return `(?:${PATH_REGEX}|${NO_PATH_REGEX}+${PATH_REGEX}${isLastPattern ? `|${PATH_REGEX}${NO_PATH_REGEX}+` : ''})*?`;
    }
}
function splitGlobAware(pattern, splitChar) {
    if (!pattern) {
        return [];
    }
    const segments = [];
    let inBraces = false;
    let inBrackets = false;
    let curVal = '';
    for (const char of pattern) {
        switch (char) {
            case splitChar:
                if (!inBraces && !inBrackets) {
                    segments.push(curVal);
                    curVal = '';
                    continue;
                }
                break;
            case '{':
                inBraces = true;
                break;
            case '}':
                inBraces = false;
                break;
            case '[':
                inBrackets = true;
                break;
            case ']':
                inBrackets = false;
                break;
        }
        curVal += char;
    }
    if (curVal) {
        segments.push(curVal);
    }
    return segments;
}
function parseRegExp(pattern) {
    if (!pattern) {
        return '';
    }
    let regEx = '';
    const segments = splitGlobAware(pattern, GLOB_SPLIT);
    if (segments.every(segment => segment === GLOBSTAR)) {
        regEx = '.*';
    }
    else {
        let previousSegmentWasGlobStar = false;
        segments.forEach((segment, index) => {
            if (segment === GLOBSTAR) {
                if (previousSegmentWasGlobStar) {
                    return;
                }
                regEx += starsToRegExp(2, index === segments.length - 1);
            }
            else {
                let inBraces = false;
                let braceVal = '';
                let inBrackets = false;
                let bracketVal = '';
                for (const char of segment) {
                    if (char !== '}' && inBraces) {
                        braceVal += char;
                        continue;
                    }
                    if (inBrackets && (char !== ']' || !bracketVal) ) {
                        let res;
                        if (char === '-') {
                            res = char;
                        }
                        else if ((char === '^' || char === '!') && !bracketVal) {
                            res = '^';
                        }
                        else if (char === GLOB_SPLIT) {
                            res = '';
                        }
                        else {
                            res = (0,_strings_js__WEBPACK_IMPORTED_MODULE_7__.escapeRegExpCharacters)(char);
                        }
                        bracketVal += res;
                        continue;
                    }
                    switch (char) {
                        case '{':
                            inBraces = true;
                            continue;
                        case '[':
                            inBrackets = true;
                            continue;
                        case '}': {
                            const choices = splitGlobAware(braceVal, ',');
                            const braceRegExp = `(?:${( choices.map(choice => parseRegExp(choice))).join('|')})`;
                            regEx += braceRegExp;
                            inBraces = false;
                            braceVal = '';
                            break;
                        }
                        case ']': {
                            regEx += ('[' + bracketVal + ']');
                            inBrackets = false;
                            bracketVal = '';
                            break;
                        }
                        case '?':
                            regEx += NO_PATH_REGEX;
                            continue;
                        case '*':
                            regEx += starsToRegExp(1);
                            continue;
                        default:
                            regEx += (0,_strings_js__WEBPACK_IMPORTED_MODULE_7__.escapeRegExpCharacters)(char);
                    }
                }
                if (index < segments.length - 1 &&
                    ((
                segments[index + 1] !== GLOBSTAR || index + 2 < segments.length)
                    )) {
                    regEx += PATH_REGEX;
                }
            }
            previousSegmentWasGlobStar = (segment === GLOBSTAR);
        });
    }
    return regEx;
}
const T1 = /^\*\*\/\*\.[\w\.-]+$/;
const T2 = /^\*\*\/([\w\.-]+)\/?$/;
const T3 = /^{\*\*\/\*?[\w\.-]+\/?(,\*\*\/\*?[\w\.-]+\/?)*}$/;
const T3_2 = /^{\*\*\/\*?[\w\.-]+(\/(\*\*)?)?(,\*\*\/\*?[\w\.-]+(\/(\*\*)?)?)*}$/;
const T4 = /^\*\*((\/[\w\.-]+)+)\/?$/;
const T5 = /^([\w\.-]+(\/[\w\.-]+)*)\/?$/;
const CACHE = ( new _map_js__WEBPACK_IMPORTED_MODULE_4__.LRUCache(10000));
const FALSE = function () {
    return false;
};
const NULL = function () {
    return null;
};
function parsePattern(arg1, options) {
    if (!arg1) {
        return NULL;
    }
    let pattern;
    if (typeof arg1 !== 'string') {
        pattern = arg1.pattern;
    }
    else {
        pattern = arg1;
    }
    pattern = pattern.trim();
    const patternKey = `${pattern}_${!!options.trimForExclusions}`;
    let parsedPattern = CACHE.get(patternKey);
    if (parsedPattern) {
        return wrapRelativePattern(parsedPattern, arg1);
    }
    let match;
    if (T1.test(pattern)) {
        parsedPattern = trivia1(pattern.substr(4), pattern);
    }
    else if (match = T2.exec(trimForExclusions(pattern, options))) {
        parsedPattern = trivia2(match[1], pattern);
    }
    else if ((options.trimForExclusions ? T3_2 : T3).test(pattern)) {
        parsedPattern = trivia3(pattern, options);
    }
    else if (match = T4.exec(trimForExclusions(pattern, options))) {
        parsedPattern = trivia4and5(match[1].substr(1), pattern, true);
    }
    else if (match = T5.exec(trimForExclusions(pattern, options))) {
        parsedPattern = trivia4and5(match[1], pattern, false);
    }
    else {
        parsedPattern = toRegExp(pattern);
    }
    CACHE.set(patternKey, parsedPattern);
    return wrapRelativePattern(parsedPattern, arg1);
}
function wrapRelativePattern(parsedPattern, arg2) {
    if (typeof arg2 === 'string') {
        return parsedPattern;
    }
    const wrappedPattern = function (path, basename) {
        if (!(0,_extpath_js__WEBPACK_IMPORTED_MODULE_3__.isEqualOrParent)(path, arg2.base, !_platform_js__WEBPACK_IMPORTED_MODULE_6__.isLinux)) {
            return null;
        }
        return parsedPattern((0,_strings_js__WEBPACK_IMPORTED_MODULE_7__.ltrim)(path.substr(arg2.base.length), _path_js__WEBPACK_IMPORTED_MODULE_5__.sep), basename);
    };
    wrappedPattern.allBasenames = parsedPattern.allBasenames;
    wrappedPattern.allPaths = parsedPattern.allPaths;
    wrappedPattern.basenames = parsedPattern.basenames;
    wrappedPattern.patterns = parsedPattern.patterns;
    return wrappedPattern;
}
function trimForExclusions(pattern, options) {
    return options.trimForExclusions && pattern.endsWith('/**') ? pattern.substr(0, pattern.length - 2) : pattern;
}
function trivia1(base, pattern) {
    return function (path, basename) {
        return typeof path === 'string' && path.endsWith(base) ? pattern : null;
    };
}
function trivia2(base, pattern) {
    const slashBase = `/${base}`;
    const backslashBase = `\\${base}`;
    const parsedPattern = function (path, basename) {
        if (typeof path !== 'string') {
            return null;
        }
        if (basename) {
            return basename === base ? pattern : null;
        }
        return path === base || path.endsWith(slashBase) || path.endsWith(backslashBase) ? pattern : null;
    };
    const basenames = [base];
    parsedPattern.basenames = basenames;
    parsedPattern.patterns = [pattern];
    parsedPattern.allBasenames = basenames;
    return parsedPattern;
}
function trivia3(pattern, options) {
    const parsedPatterns = aggregateBasenameMatches(( pattern.slice(1, -1)
        .split(',')
        .map(pattern => parsePattern(pattern, options)))
        .filter(pattern => pattern !== NULL), pattern);
    const patternsLength = parsedPatterns.length;
    if (!patternsLength) {
        return NULL;
    }
    if (patternsLength === 1) {
        return parsedPatterns[0];
    }
    const parsedPattern = function (path, basename) {
        for (let i = 0, n = parsedPatterns.length; i < n; i++) {
            if (parsedPatterns[i](path, basename)) {
                return pattern;
            }
        }
        return null;
    };
    const withBasenames = parsedPatterns.find(pattern => !!pattern.allBasenames);
    if (withBasenames) {
        parsedPattern.allBasenames = withBasenames.allBasenames;
    }
    const allPaths = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
    if (allPaths.length) {
        parsedPattern.allPaths = allPaths;
    }
    return parsedPattern;
}
function trivia4and5(targetPath, pattern, matchPathEnds) {
    const usingPosixSep = _path_js__WEBPACK_IMPORTED_MODULE_5__.sep === _path_js__WEBPACK_IMPORTED_MODULE_5__.posix.sep;
    const nativePath = usingPosixSep ? targetPath : targetPath.replace(ALL_FORWARD_SLASHES, _path_js__WEBPACK_IMPORTED_MODULE_5__.sep);
    const nativePathEnd = _path_js__WEBPACK_IMPORTED_MODULE_5__.sep + nativePath;
    const targetPathEnd = _path_js__WEBPACK_IMPORTED_MODULE_5__.posix.sep + targetPath;
    let parsedPattern;
    if (matchPathEnds) {
        parsedPattern = function (path, basename) {
            return typeof path === 'string' && ((path === nativePath || path.endsWith(nativePathEnd)) || !usingPosixSep && (path === targetPath || path.endsWith(targetPathEnd))) ? pattern : null;
        };
    }
    else {
        parsedPattern = function (path, basename) {
            return typeof path === 'string' && (path === nativePath || (!usingPosixSep && path === targetPath)) ? pattern : null;
        };
    }
    parsedPattern.allPaths = [(matchPathEnds ? '*/' : './') + targetPath];
    return parsedPattern;
}
function toRegExp(pattern) {
    try {
        const regExp = ( new RegExp(`^${parseRegExp(pattern)}$`));
        return function (path) {
            regExp.lastIndex = 0;
            return typeof path === 'string' && regExp.test(path) ? pattern : null;
        };
    }
    catch (error) {
        return NULL;
    }
}
function match(arg1, path, hasSibling) {
    if (!arg1 || typeof path !== 'string') {
        return false;
    }
    return parse(arg1)(path, undefined, hasSibling);
}
function parse(arg1, options = {}) {
    if (!arg1) {
        return FALSE;
    }
    if (typeof arg1 === 'string' || isRelativePattern(arg1)) {
        const parsedPattern = parsePattern(arg1, options);
        if (parsedPattern === NULL) {
            return FALSE;
        }
        const resultPattern = function (path, basename) {
            return !!parsedPattern(path, basename);
        };
        if (parsedPattern.allBasenames) {
            resultPattern.allBasenames = parsedPattern.allBasenames;
        }
        if (parsedPattern.allPaths) {
            resultPattern.allPaths = parsedPattern.allPaths;
        }
        return resultPattern;
    }
    return parsedExpression(arg1, options);
}
function isRelativePattern(obj) {
    const rp = obj;
    if (!rp) {
        return false;
    }
    return typeof rp.base === 'string' && typeof rp.pattern === 'string';
}
function parsedExpression(expression, options) {
    const parsedPatterns = aggregateBasenameMatches(( Object.getOwnPropertyNames(expression)
        .map(pattern => parseExpressionPattern(pattern, expression[pattern], options)))
        .filter(pattern => pattern !== NULL));
    const patternsLength = parsedPatterns.length;
    if (!patternsLength) {
        return NULL;
    }
    if (!( parsedPatterns.some(parsedPattern => !!parsedPattern.requiresSiblings))) {
        if (patternsLength === 1) {
            return parsedPatterns[0];
        }
        const resultExpression = function (path, basename) {
            let resultPromises = undefined;
            for (let i = 0, n = parsedPatterns.length; i < n; i++) {
                const result = parsedPatterns[i](path, basename);
                if (typeof result === 'string') {
                    return result;
                }
                if ((0,_async_js__WEBPACK_IMPORTED_MODULE_1__.isThenable)(result)) {
                    if (!resultPromises) {
                        resultPromises = [];
                    }
                    resultPromises.push(result);
                }
            }
            if (resultPromises) {
                return (async () => {
                    for (const resultPromise of resultPromises) {
                        const result = await resultPromise;
                        if (typeof result === 'string') {
                            return result;
                        }
                    }
                    return null;
                })();
            }
            return null;
        };
        const withBasenames = parsedPatterns.find(pattern => !!pattern.allBasenames);
        if (withBasenames) {
            resultExpression.allBasenames = withBasenames.allBasenames;
        }
        const allPaths = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
        if (allPaths.length) {
            resultExpression.allPaths = allPaths;
        }
        return resultExpression;
    }
    const resultExpression = function (path, base, hasSibling) {
        let name = undefined;
        let resultPromises = undefined;
        for (let i = 0, n = parsedPatterns.length; i < n; i++) {
            const parsedPattern = parsedPatterns[i];
            if (parsedPattern.requiresSiblings && hasSibling) {
                if (!base) {
                    base = (0,_path_js__WEBPACK_IMPORTED_MODULE_5__.basename)(path);
                }
                if (!name) {
                    name = base.substr(0, base.length - (0,_path_js__WEBPACK_IMPORTED_MODULE_5__.extname)(path).length);
                }
            }
            const result = parsedPattern(path, base, name, hasSibling);
            if (typeof result === 'string') {
                return result;
            }
            if ((0,_async_js__WEBPACK_IMPORTED_MODULE_1__.isThenable)(result)) {
                if (!resultPromises) {
                    resultPromises = [];
                }
                resultPromises.push(result);
            }
        }
        if (resultPromises) {
            return (async () => {
                for (const resultPromise of resultPromises) {
                    const result = await resultPromise;
                    if (typeof result === 'string') {
                        return result;
                    }
                }
                return null;
            })();
        }
        return null;
    };
    const withBasenames = parsedPatterns.find(pattern => !!pattern.allBasenames);
    if (withBasenames) {
        resultExpression.allBasenames = withBasenames.allBasenames;
    }
    const allPaths = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
    if (allPaths.length) {
        resultExpression.allPaths = allPaths;
    }
    return resultExpression;
}
function parseExpressionPattern(pattern, value, options) {
    if (value === false) {
        return NULL;
    }
    const parsedPattern = parsePattern(pattern, options);
    if (parsedPattern === NULL) {
        return NULL;
    }
    if (typeof value === 'boolean') {
        return parsedPattern;
    }
    if (value) {
        const when = value.when;
        if (typeof when === 'string') {
            const result = (path, basename, name, hasSibling) => {
                if (!hasSibling || !parsedPattern(path, basename)) {
                    return null;
                }
                const clausePattern = when.replace('$(basename)', () => name);
                const matched = hasSibling(clausePattern);
                return (0,_async_js__WEBPACK_IMPORTED_MODULE_1__.isThenable)(matched) ?
                    matched.then(match => match ? pattern : null) :
                    matched ? pattern : null;
            };
            result.requiresSiblings = true;
            return result;
        }
    }
    return parsedPattern;
}
function aggregateBasenameMatches(parsedPatterns, result) {
    const basenamePatterns = parsedPatterns.filter(parsedPattern => !!parsedPattern.basenames);
    if (basenamePatterns.length < 2) {
        return parsedPatterns;
    }
    const basenames = basenamePatterns.reduce((all, current) => {
        const basenames = current.basenames;
        return basenames ? all.concat(basenames) : all;
    }, []);
    let patterns;
    if (result) {
        patterns = [];
        for (let i = 0, n = basenames.length; i < n; i++) {
            patterns.push(result);
        }
    }
    else {
        patterns = basenamePatterns.reduce((all, current) => {
            const patterns = current.patterns;
            return patterns ? all.concat(patterns) : all;
        }, []);
    }
    const aggregate = function (path, basename) {
        if (typeof path !== 'string') {
            return null;
        }
        if (!basename) {
            let i;
            for (i = path.length; i > 0; i--) {
                const ch = path.charCodeAt(i - 1);
                if (ch === _charCode_js__WEBPACK_IMPORTED_MODULE_2__.CharCode.Slash || ch === _charCode_js__WEBPACK_IMPORTED_MODULE_2__.CharCode.Backslash) {
                    break;
                }
            }
            basename = path.substr(i);
        }
        const index = basenames.indexOf(basename);
        return index !== -1 ? patterns[index] : null;
    };
    aggregate.basenames = basenames;
    aggregate.patterns = patterns;
    aggregate.allBasenames = basenames;
    const aggregatedPatterns = parsedPatterns.filter(parsedPattern => !parsedPattern.basenames);
    aggregatedPatterns.push(aggregate);
    return aggregatedPatterns;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/htmlContent.js":
/*!**********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/htmlContent.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MarkdownString: () => (/* binding */ MarkdownString),
/* harmony export */   MarkdownStringTextNewlineStyle: () => (/* binding */ MarkdownStringTextNewlineStyle),
/* harmony export */   appendEscapedMarkdownCodeBlockFence: () => (/* binding */ appendEscapedMarkdownCodeBlockFence),
/* harmony export */   escapeDoubleQuotes: () => (/* binding */ escapeDoubleQuotes),
/* harmony export */   escapeMarkdownSyntaxTokens: () => (/* binding */ escapeMarkdownSyntaxTokens),
/* harmony export */   isEmptyMarkdownString: () => (/* binding */ isEmptyMarkdownString),
/* harmony export */   isMarkdownString: () => (/* binding */ isMarkdownString),
/* harmony export */   markdownStringEqual: () => (/* binding */ markdownStringEqual),
/* harmony export */   parseHrefAndDimensions: () => (/* binding */ parseHrefAndDimensions),
/* harmony export */   removeMarkdownEscapes: () => (/* binding */ removeMarkdownEscapes)
/* harmony export */ });
/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _iconLabels_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./iconLabels.js */ "./node_modules/vscode/vscode/src/vs/base/common/iconLabels.js");
/* harmony import */ var _resources_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./resources.js */ "./node_modules/vscode/vscode/src/vs/base/common/resources.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _uri_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");





var MarkdownStringTextNewlineStyle;
( (function(MarkdownStringTextNewlineStyle) {
    MarkdownStringTextNewlineStyle[MarkdownStringTextNewlineStyle["Paragraph"] = 0] = "Paragraph";
    MarkdownStringTextNewlineStyle[MarkdownStringTextNewlineStyle["Break"] = 1] = "Break";
})(MarkdownStringTextNewlineStyle || (MarkdownStringTextNewlineStyle = {})));
class MarkdownString {
    constructor(value = '', isTrustedOrOptions = false) {
        this.value = value;
        if (typeof this.value !== 'string') {
            throw (0,_errors_js__WEBPACK_IMPORTED_MODULE_0__.illegalArgument)('value');
        }
        if (typeof isTrustedOrOptions === 'boolean') {
            this.isTrusted = isTrustedOrOptions;
            this.supportThemeIcons = false;
            this.supportHtml = false;
        }
        else {
            this.isTrusted = isTrustedOrOptions.isTrusted ?? undefined;
            this.supportThemeIcons = isTrustedOrOptions.supportThemeIcons ?? false;
            this.supportHtml = isTrustedOrOptions.supportHtml ?? false;
        }
    }
    appendText(value, newlineStyle = MarkdownStringTextNewlineStyle.Paragraph) {
        this.value += escapeMarkdownSyntaxTokens(this.supportThemeIcons ? (0,_iconLabels_js__WEBPACK_IMPORTED_MODULE_1__.escapeIcons)(value) : value)
            .replace(/([ \t]+)/g, (_match, g1) => '&nbsp;'.repeat(g1.length))
            .replace(/\>/gm, '\\>')
            .replace(/\n/g, newlineStyle === MarkdownStringTextNewlineStyle.Break ? '\\\n' : '\n\n');
        return this;
    }
    appendMarkdown(value) {
        this.value += value;
        return this;
    }
    appendCodeblock(langId, code) {
        this.value += `\n${appendEscapedMarkdownCodeBlockFence(code, langId)}\n`;
        return this;
    }
    appendLink(target, label, title) {
        this.value += '[';
        this.value += this._escape(label, ']');
        this.value += '](';
        this.value += this._escape(String(target), ')');
        if (title) {
            this.value += ` "${this._escape(this._escape(title, '"'), ')')}"`;
        }
        this.value += ')';
        return this;
    }
    _escape(value, ch) {
        const r = ( new RegExp((0,_strings_js__WEBPACK_IMPORTED_MODULE_3__.escapeRegExpCharacters)(ch), 'g'));
        return value.replace(r, (match, offset) => {
            if (value.charAt(offset - 1) !== '\\') {
                return `\\${match}`;
            }
            else {
                return match;
            }
        });
    }
}
function isEmptyMarkdownString(oneOrMany) {
    if (isMarkdownString(oneOrMany)) {
        return !oneOrMany.value;
    }
    else if (Array.isArray(oneOrMany)) {
        return oneOrMany.every(isEmptyMarkdownString);
    }
    else {
        return true;
    }
}
function isMarkdownString(thing) {
    if (thing instanceof MarkdownString) {
        return true;
    }
    else if (thing && typeof thing === 'object') {
        return typeof thing.value === 'string'
            && (typeof thing.isTrusted === 'boolean' || typeof thing.isTrusted === 'object' || thing.isTrusted === undefined)
            && (typeof thing.supportThemeIcons === 'boolean' || thing.supportThemeIcons === undefined);
    }
    return false;
}
function markdownStringEqual(a, b) {
    if (a === b) {
        return true;
    }
    else if (!a || !b) {
        return false;
    }
    else {
        return a.value === b.value
            && a.isTrusted === b.isTrusted
            && a.supportThemeIcons === b.supportThemeIcons
            && a.supportHtml === b.supportHtml
            && (a.baseUri === b.baseUri || !!a.baseUri && !!b.baseUri && (0,_resources_js__WEBPACK_IMPORTED_MODULE_2__.isEqual)(( _uri_js__WEBPACK_IMPORTED_MODULE_4__.URI.from(a.baseUri)), ( _uri_js__WEBPACK_IMPORTED_MODULE_4__.URI.from(b.baseUri))));
    }
}
function escapeMarkdownSyntaxTokens(text) {
    return text.replace(/[\\`*_{}[\]()#+\-!~]/g, '\\$&');
}
function appendEscapedMarkdownCodeBlockFence(code, langId) {
    const longestFenceLength = code.match(/^`+/gm)?.reduce((a, b) => (a.length > b.length ? a : b)).length ??
        0;
    const desiredFenceLength = longestFenceLength >= 3 ? longestFenceLength + 1 : 3;
    return [
        `${'`'.repeat(desiredFenceLength)}${langId}`,
        code,
        `${'`'.repeat(desiredFenceLength)}`,
    ].join('\n');
}
function escapeDoubleQuotes(input) {
    return input.replace(/"/g, '&quot;');
}
function removeMarkdownEscapes(text) {
    if (!text) {
        return text;
    }
    return text.replace(/\\([\\`*_{}[\]()#+\-.!~])/g, '$1');
}
function parseHrefAndDimensions(href) {
    const dimensions = [];
    const splitted = ( href.split('|').map(s => s.trim()));
    href = splitted[0];
    const parameters = splitted[1];
    if (parameters) {
        const heightFromParams = /height=(\d+)/.exec(parameters);
        const widthFromParams = /width=(\d+)/.exec(parameters);
        const height = heightFromParams ? heightFromParams[1] : '';
        const width = widthFromParams ? widthFromParams[1] : '';
        const widthIsFinite = isFinite(parseInt(width));
        const heightIsFinite = isFinite(parseInt(height));
        if (widthIsFinite) {
            dimensions.push(`width="${width}"`);
        }
        if (heightIsFinite) {
            dimensions.push(`height="${height}"`);
        }
    }
    return { href, dimensions };
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/iconLabels.js":
/*!*********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/iconLabels.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   escapeIcons: () => (/* binding */ escapeIcons),
/* harmony export */   getCodiconAriaLabel: () => (/* binding */ getCodiconAriaLabel),
/* harmony export */   markdownEscapeEscapedIcons: () => (/* binding */ markdownEscapeEscapedIcons),
/* harmony export */   matchesFuzzyIconAware: () => (/* binding */ matchesFuzzyIconAware),
/* harmony export */   parseLabelWithIcons: () => (/* binding */ parseLabelWithIcons),
/* harmony export */   stripIcons: () => (/* binding */ stripIcons)
/* harmony export */ });
/* harmony import */ var _filters_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./filters.js */ "./node_modules/vscode/vscode/src/vs/base/common/filters.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _themables_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./themables.js */ "./node_modules/vscode/vscode/src/vs/base/common/themables.js");



const iconStartMarker = '$(';
const iconsRegex = ( new RegExp(
    `\\$\\(${_themables_js__WEBPACK_IMPORTED_MODULE_2__.ThemeIcon.iconNameExpression}(?:${_themables_js__WEBPACK_IMPORTED_MODULE_2__.ThemeIcon.iconModifierExpression})?\\)`,
    'g'
));
const escapeIconsRegex = ( new RegExp(`(\\\\)?${iconsRegex.source}`, 'g'));
function escapeIcons(text) {
    return text.replace(escapeIconsRegex, (match, escaped) => escaped ? match : `\\${match}`);
}
const markdownEscapedIconsRegex = ( new RegExp(`\\\\${iconsRegex.source}`, 'g'));
function markdownEscapeEscapedIcons(text) {
    return text.replace(markdownEscapedIconsRegex, match => `\\${match}`);
}
const stripIconsRegex = ( new RegExp(`(\\s)?(\\\\)?${iconsRegex.source}(\\s)?`, 'g'));
function stripIcons(text) {
    if (text.indexOf(iconStartMarker) === -1) {
        return text;
    }
    return text.replace(stripIconsRegex, (match, preWhitespace, escaped, postWhitespace) => escaped ? match : preWhitespace || postWhitespace || '');
}
function getCodiconAriaLabel(text) {
    if (!text) {
        return '';
    }
    return text.replace(/\$\((.*?)\)/g, (_match, codiconName) => ` ${codiconName} `).trim();
}
const _parseIconsRegex = ( new RegExp(`\\$\\(${_themables_js__WEBPACK_IMPORTED_MODULE_2__.ThemeIcon.iconNameCharacter}+\\)`, 'g'));
function parseLabelWithIcons(input) {
    _parseIconsRegex.lastIndex = 0;
    let text = '';
    const iconOffsets = [];
    let iconsOffset = 0;
    while (true) {
        const pos = _parseIconsRegex.lastIndex;
        const match = _parseIconsRegex.exec(input);
        const chars = input.substring(pos, match?.index);
        if (chars.length > 0) {
            text += chars;
            for (let i = 0; i < chars.length; i++) {
                iconOffsets.push(iconsOffset);
            }
        }
        if (!match) {
            break;
        }
        iconsOffset += match[0].length;
    }
    return { text, iconOffsets };
}
function matchesFuzzyIconAware(query, target, enableSeparateSubstringMatching = false) {
    const { text, iconOffsets } = target;
    if (!iconOffsets || iconOffsets.length === 0) {
        return (0,_filters_js__WEBPACK_IMPORTED_MODULE_0__.matchesFuzzy)(query, text, enableSeparateSubstringMatching);
    }
    const wordToMatchAgainstWithoutIconsTrimmed = (0,_strings_js__WEBPACK_IMPORTED_MODULE_1__.ltrim)(text, ' ');
    const leadingWhitespaceOffset = text.length - wordToMatchAgainstWithoutIconsTrimmed.length;
    const matches = (0,_filters_js__WEBPACK_IMPORTED_MODULE_0__.matchesFuzzy)(query, wordToMatchAgainstWithoutIconsTrimmed, enableSeparateSubstringMatching);
    if (matches) {
        for (const match of matches) {
            const iconOffset = iconOffsets[match.start + leadingWhitespaceOffset]  + leadingWhitespaceOffset ;
            match.start += iconOffset;
            match.end += iconOffset;
        }
    }
    return matches;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/idGenerator.js":
/*!**********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/idGenerator.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IdGenerator: () => (/* binding */ IdGenerator),
/* harmony export */   defaultGenerator: () => (/* binding */ defaultGenerator)
/* harmony export */ });
class IdGenerator {
    constructor(prefix) {
        this._prefix = prefix;
        this._lastId = 0;
    }
    nextId() {
        return this._prefix + (++this._lastId);
    }
}
const defaultGenerator = ( new IdGenerator('id#'));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/json.js":
/*!***************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/json.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ParseErrorCode: () => (/* binding */ ParseErrorCode),
/* harmony export */   ParseOptions: () => (/* binding */ ParseOptions),
/* harmony export */   ScanError: () => (/* binding */ ScanError),
/* harmony export */   SyntaxKind: () => (/* binding */ SyntaxKind),
/* harmony export */   createScanner: () => (/* binding */ createScanner),
/* harmony export */   findNodeAtLocation: () => (/* binding */ findNodeAtLocation),
/* harmony export */   getLocation: () => (/* binding */ getLocation),
/* harmony export */   getNodeType: () => (/* binding */ getNodeType),
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   parseTree: () => (/* binding */ parseTree),
/* harmony export */   visit: () => (/* binding */ visit)
/* harmony export */ });
var ScanError;
( (function(ScanError) {
    ScanError[ScanError["None"] = 0] = "None";
    ScanError[ScanError["UnexpectedEndOfComment"] = 1] = "UnexpectedEndOfComment";
    ScanError[ScanError["UnexpectedEndOfString"] = 2] = "UnexpectedEndOfString";
    ScanError[ScanError["UnexpectedEndOfNumber"] = 3] = "UnexpectedEndOfNumber";
    ScanError[ScanError["InvalidUnicode"] = 4] = "InvalidUnicode";
    ScanError[ScanError["InvalidEscapeCharacter"] = 5] = "InvalidEscapeCharacter";
    ScanError[ScanError["InvalidCharacter"] = 6] = "InvalidCharacter";
})(ScanError || (ScanError = {})));
var SyntaxKind;
( (function(SyntaxKind) {
    SyntaxKind[SyntaxKind["OpenBraceToken"] = 1] = "OpenBraceToken";
    SyntaxKind[SyntaxKind["CloseBraceToken"] = 2] = "CloseBraceToken";
    SyntaxKind[SyntaxKind["OpenBracketToken"] = 3] = "OpenBracketToken";
    SyntaxKind[SyntaxKind["CloseBracketToken"] = 4] = "CloseBracketToken";
    SyntaxKind[SyntaxKind["CommaToken"] = 5] = "CommaToken";
    SyntaxKind[SyntaxKind["ColonToken"] = 6] = "ColonToken";
    SyntaxKind[SyntaxKind["NullKeyword"] = 7] = "NullKeyword";
    SyntaxKind[SyntaxKind["TrueKeyword"] = 8] = "TrueKeyword";
    SyntaxKind[SyntaxKind["FalseKeyword"] = 9] = "FalseKeyword";
    SyntaxKind[SyntaxKind["StringLiteral"] = 10] = "StringLiteral";
    SyntaxKind[SyntaxKind["NumericLiteral"] = 11] = "NumericLiteral";
    SyntaxKind[SyntaxKind["LineCommentTrivia"] = 12] = "LineCommentTrivia";
    SyntaxKind[SyntaxKind["BlockCommentTrivia"] = 13] = "BlockCommentTrivia";
    SyntaxKind[SyntaxKind["LineBreakTrivia"] = 14] = "LineBreakTrivia";
    SyntaxKind[SyntaxKind["Trivia"] = 15] = "Trivia";
    SyntaxKind[SyntaxKind["Unknown"] = 16] = "Unknown";
    SyntaxKind[SyntaxKind["EOF"] = 17] = "EOF";
})(SyntaxKind || (SyntaxKind = {})));
var ParseErrorCode;
( (function(ParseErrorCode) {
    ParseErrorCode[ParseErrorCode["InvalidSymbol"] = 1] = "InvalidSymbol";
    ParseErrorCode[ParseErrorCode["InvalidNumberFormat"] = 2] = "InvalidNumberFormat";
    ParseErrorCode[ParseErrorCode["PropertyNameExpected"] = 3] = "PropertyNameExpected";
    ParseErrorCode[ParseErrorCode["ValueExpected"] = 4] = "ValueExpected";
    ParseErrorCode[ParseErrorCode["ColonExpected"] = 5] = "ColonExpected";
    ParseErrorCode[ParseErrorCode["CommaExpected"] = 6] = "CommaExpected";
    ParseErrorCode[ParseErrorCode["CloseBraceExpected"] = 7] = "CloseBraceExpected";
    ParseErrorCode[ParseErrorCode["CloseBracketExpected"] = 8] = "CloseBracketExpected";
    ParseErrorCode[ParseErrorCode["EndOfFileExpected"] = 9] = "EndOfFileExpected";
    ParseErrorCode[ParseErrorCode["InvalidCommentToken"] = 10] = "InvalidCommentToken";
    ParseErrorCode[ParseErrorCode["UnexpectedEndOfComment"] = 11] = "UnexpectedEndOfComment";
    ParseErrorCode[ParseErrorCode["UnexpectedEndOfString"] = 12] = "UnexpectedEndOfString";
    ParseErrorCode[ParseErrorCode["UnexpectedEndOfNumber"] = 13] = "UnexpectedEndOfNumber";
    ParseErrorCode[ParseErrorCode["InvalidUnicode"] = 14] = "InvalidUnicode";
    ParseErrorCode[ParseErrorCode["InvalidEscapeCharacter"] = 15] = "InvalidEscapeCharacter";
    ParseErrorCode[ParseErrorCode["InvalidCharacter"] = 16] = "InvalidCharacter";
})(ParseErrorCode || (ParseErrorCode = {})));
var ParseOptions;
( (function(ParseOptions) {
    ParseOptions.DEFAULT = {
        allowTrailingComma: true
    };
})(ParseOptions || (ParseOptions = {})));
function createScanner(text, ignoreTrivia = false) {
    let pos = 0;
    const len = text.length;
    let value = '';
    let tokenOffset = 0;
    let token = SyntaxKind.Unknown;
    let scanError = ScanError.None;
    function scanHexDigits(count) {
        let digits = 0;
        let hexValue = 0;
        while (digits < count) {
            const ch = text.charCodeAt(pos);
            if (ch >= CharacterCodes._0 && ch <= CharacterCodes._9) {
                hexValue = hexValue * 16 + ch - CharacterCodes._0;
            }
            else if (ch >= CharacterCodes.A && ch <= CharacterCodes.F) {
                hexValue = hexValue * 16 + ch - CharacterCodes.A + 10;
            }
            else if (ch >= CharacterCodes.a && ch <= CharacterCodes.f) {
                hexValue = hexValue * 16 + ch - CharacterCodes.a + 10;
            }
            else {
                break;
            }
            pos++;
            digits++;
        }
        if (digits < count) {
            hexValue = -1;
        }
        return hexValue;
    }
    function setPosition(newPosition) {
        pos = newPosition;
        value = '';
        tokenOffset = 0;
        token = SyntaxKind.Unknown;
        scanError = ScanError.None;
    }
    function scanNumber() {
        const start = pos;
        if (text.charCodeAt(pos) === CharacterCodes._0) {
            pos++;
        }
        else {
            pos++;
            while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
            }
        }
        if (pos < text.length && text.charCodeAt(pos) === CharacterCodes.dot) {
            pos++;
            if (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
                while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                    pos++;
                }
            }
            else {
                scanError = ScanError.UnexpectedEndOfNumber;
                return text.substring(start, pos);
            }
        }
        let end = pos;
        if (pos < text.length && (text.charCodeAt(pos) === CharacterCodes.E || text.charCodeAt(pos) === CharacterCodes.e)) {
            pos++;
            if (pos < text.length && text.charCodeAt(pos) === CharacterCodes.plus || text.charCodeAt(pos) === CharacterCodes.minus) {
                pos++;
            }
            if (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
                while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                    pos++;
                }
                end = pos;
            }
            else {
                scanError = ScanError.UnexpectedEndOfNumber;
            }
        }
        return text.substring(start, end);
    }
    function scanString() {
        let result = '', start = pos;
        while (true) {
            if (pos >= len) {
                result += text.substring(start, pos);
                scanError = ScanError.UnexpectedEndOfString;
                break;
            }
            const ch = text.charCodeAt(pos);
            if (ch === CharacterCodes.doubleQuote) {
                result += text.substring(start, pos);
                pos++;
                break;
            }
            if (ch === CharacterCodes.backslash) {
                result += text.substring(start, pos);
                pos++;
                if (pos >= len) {
                    scanError = ScanError.UnexpectedEndOfString;
                    break;
                }
                const ch2 = text.charCodeAt(pos++);
                switch (ch2) {
                    case CharacterCodes.doubleQuote:
                        result += '\"';
                        break;
                    case CharacterCodes.backslash:
                        result += '\\';
                        break;
                    case CharacterCodes.slash:
                        result += '/';
                        break;
                    case CharacterCodes.b:
                        result += '\b';
                        break;
                    case CharacterCodes.f:
                        result += '\f';
                        break;
                    case CharacterCodes.n:
                        result += '\n';
                        break;
                    case CharacterCodes.r:
                        result += '\r';
                        break;
                    case CharacterCodes.t:
                        result += '\t';
                        break;
                    case CharacterCodes.u: {
                        const ch3 = scanHexDigits(4);
                        if (ch3 >= 0) {
                            result += String.fromCharCode(ch3);
                        }
                        else {
                            scanError = ScanError.InvalidUnicode;
                        }
                        break;
                    }
                    default:
                        scanError = ScanError.InvalidEscapeCharacter;
                }
                start = pos;
                continue;
            }
            if (ch >= 0 && ch <= 0x1F) {
                if (isLineBreak(ch)) {
                    result += text.substring(start, pos);
                    scanError = ScanError.UnexpectedEndOfString;
                    break;
                }
                else {
                    scanError = ScanError.InvalidCharacter;
                }
            }
            pos++;
        }
        return result;
    }
    function scanNext() {
        value = '';
        scanError = ScanError.None;
        tokenOffset = pos;
        if (pos >= len) {
            tokenOffset = len;
            return token = SyntaxKind.EOF;
        }
        let code = text.charCodeAt(pos);
        if (isWhitespace(code)) {
            do {
                pos++;
                value += String.fromCharCode(code);
                code = text.charCodeAt(pos);
            } while (isWhitespace(code));
            return token = SyntaxKind.Trivia;
        }
        if (isLineBreak(code)) {
            pos++;
            value += String.fromCharCode(code);
            if (code === CharacterCodes.carriageReturn && text.charCodeAt(pos) === CharacterCodes.lineFeed) {
                pos++;
                value += '\n';
            }
            return token = SyntaxKind.LineBreakTrivia;
        }
        switch (code) {
            case CharacterCodes.openBrace:
                pos++;
                return token = SyntaxKind.OpenBraceToken;
            case CharacterCodes.closeBrace:
                pos++;
                return token = SyntaxKind.CloseBraceToken;
            case CharacterCodes.openBracket:
                pos++;
                return token = SyntaxKind.OpenBracketToken;
            case CharacterCodes.closeBracket:
                pos++;
                return token = SyntaxKind.CloseBracketToken;
            case CharacterCodes.colon:
                pos++;
                return token = SyntaxKind.ColonToken;
            case CharacterCodes.comma:
                pos++;
                return token = SyntaxKind.CommaToken;
            case CharacterCodes.doubleQuote:
                pos++;
                value = scanString();
                return token = SyntaxKind.StringLiteral;
            case CharacterCodes.slash: {
                const start = pos - 1;
                if (text.charCodeAt(pos + 1) === CharacterCodes.slash) {
                    pos += 2;
                    while (pos < len) {
                        if (isLineBreak(text.charCodeAt(pos))) {
                            break;
                        }
                        pos++;
                    }
                    value = text.substring(start, pos);
                    return token = SyntaxKind.LineCommentTrivia;
                }
                if (text.charCodeAt(pos + 1) === CharacterCodes.asterisk) {
                    pos += 2;
                    const safeLength = len - 1;
                    let commentClosed = false;
                    while (pos < safeLength) {
                        const ch = text.charCodeAt(pos);
                        if (ch === CharacterCodes.asterisk && text.charCodeAt(pos + 1) === CharacterCodes.slash) {
                            pos += 2;
                            commentClosed = true;
                            break;
                        }
                        pos++;
                    }
                    if (!commentClosed) {
                        pos++;
                        scanError = ScanError.UnexpectedEndOfComment;
                    }
                    value = text.substring(start, pos);
                    return token = SyntaxKind.BlockCommentTrivia;
                }
                value += String.fromCharCode(code);
                pos++;
                return token = SyntaxKind.Unknown;
            }
            case CharacterCodes.minus:
                value += String.fromCharCode(code);
                pos++;
                if (pos === len || !isDigit(text.charCodeAt(pos))) {
                    return token = SyntaxKind.Unknown;
                }
            case CharacterCodes._0:
            case CharacterCodes._1:
            case CharacterCodes._2:
            case CharacterCodes._3:
            case CharacterCodes._4:
            case CharacterCodes._5:
            case CharacterCodes._6:
            case CharacterCodes._7:
            case CharacterCodes._8:
            case CharacterCodes._9:
                value += scanNumber();
                return token = SyntaxKind.NumericLiteral;
            default:
                while (pos < len && isUnknownContentCharacter(code)) {
                    pos++;
                    code = text.charCodeAt(pos);
                }
                if (tokenOffset !== pos) {
                    value = text.substring(tokenOffset, pos);
                    switch (value) {
                        case 'true': return token = SyntaxKind.TrueKeyword;
                        case 'false': return token = SyntaxKind.FalseKeyword;
                        case 'null': return token = SyntaxKind.NullKeyword;
                    }
                    return token = SyntaxKind.Unknown;
                }
                value += String.fromCharCode(code);
                pos++;
                return token = SyntaxKind.Unknown;
        }
    }
    function isUnknownContentCharacter(code) {
        if (isWhitespace(code) || isLineBreak(code)) {
            return false;
        }
        switch (code) {
            case CharacterCodes.closeBrace:
            case CharacterCodes.closeBracket:
            case CharacterCodes.openBrace:
            case CharacterCodes.openBracket:
            case CharacterCodes.doubleQuote:
            case CharacterCodes.colon:
            case CharacterCodes.comma:
            case CharacterCodes.slash:
                return false;
        }
        return true;
    }
    function scanNextNonTrivia() {
        let result;
        do {
            result = scanNext();
        } while (result >= SyntaxKind.LineCommentTrivia && result <= SyntaxKind.Trivia);
        return result;
    }
    return {
        setPosition: setPosition,
        getPosition: () => pos,
        scan: ignoreTrivia ? scanNextNonTrivia : scanNext,
        getToken: () => token,
        getTokenValue: () => value,
        getTokenOffset: () => tokenOffset,
        getTokenLength: () => pos - tokenOffset,
        getTokenError: () => scanError
    };
}
function isWhitespace(ch) {
    return ch === CharacterCodes.space || ch === CharacterCodes.tab || ch === CharacterCodes.verticalTab || ch === CharacterCodes.formFeed ||
        ch === CharacterCodes.nonBreakingSpace || ch === CharacterCodes.ogham || ch >= CharacterCodes.enQuad && ch <= CharacterCodes.zeroWidthSpace ||
        ch === CharacterCodes.narrowNoBreakSpace || ch === CharacterCodes.mathematicalSpace || ch === CharacterCodes.ideographicSpace || ch === CharacterCodes.byteOrderMark;
}
function isLineBreak(ch) {
    return ch === CharacterCodes.lineFeed || ch === CharacterCodes.carriageReturn || ch === CharacterCodes.lineSeparator || ch === CharacterCodes.paragraphSeparator;
}
function isDigit(ch) {
    return ch >= CharacterCodes._0 && ch <= CharacterCodes._9;
}
var CharacterCodes;
( (function(CharacterCodes) {
    CharacterCodes[CharacterCodes["nullCharacter"] = 0] = "nullCharacter";
    CharacterCodes[CharacterCodes["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
    CharacterCodes[CharacterCodes["lineFeed"] = 10] = "lineFeed";
    CharacterCodes[CharacterCodes["carriageReturn"] = 13] = "carriageReturn";
    CharacterCodes[CharacterCodes["lineSeparator"] = 8232] = "lineSeparator";
    CharacterCodes[CharacterCodes["paragraphSeparator"] = 8233] = "paragraphSeparator";
    CharacterCodes[CharacterCodes["nextLine"] = 133] = "nextLine";
    CharacterCodes[CharacterCodes["space"] = 32] = "space";
    CharacterCodes[CharacterCodes["nonBreakingSpace"] = 160] = "nonBreakingSpace";
    CharacterCodes[CharacterCodes["enQuad"] = 8192] = "enQuad";
    CharacterCodes[CharacterCodes["emQuad"] = 8193] = "emQuad";
    CharacterCodes[CharacterCodes["enSpace"] = 8194] = "enSpace";
    CharacterCodes[CharacterCodes["emSpace"] = 8195] = "emSpace";
    CharacterCodes[CharacterCodes["threePerEmSpace"] = 8196] = "threePerEmSpace";
    CharacterCodes[CharacterCodes["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
    CharacterCodes[CharacterCodes["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
    CharacterCodes[CharacterCodes["figureSpace"] = 8199] = "figureSpace";
    CharacterCodes[CharacterCodes["punctuationSpace"] = 8200] = "punctuationSpace";
    CharacterCodes[CharacterCodes["thinSpace"] = 8201] = "thinSpace";
    CharacterCodes[CharacterCodes["hairSpace"] = 8202] = "hairSpace";
    CharacterCodes[CharacterCodes["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
    CharacterCodes[CharacterCodes["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
    CharacterCodes[CharacterCodes["ideographicSpace"] = 12288] = "ideographicSpace";
    CharacterCodes[CharacterCodes["mathematicalSpace"] = 8287] = "mathematicalSpace";
    CharacterCodes[CharacterCodes["ogham"] = 5760] = "ogham";
    CharacterCodes[CharacterCodes["_"] = 95] = "_";
    CharacterCodes[CharacterCodes["$"] = 36] = "$";
    CharacterCodes[CharacterCodes["_0"] = 48] = "_0";
    CharacterCodes[CharacterCodes["_1"] = 49] = "_1";
    CharacterCodes[CharacterCodes["_2"] = 50] = "_2";
    CharacterCodes[CharacterCodes["_3"] = 51] = "_3";
    CharacterCodes[CharacterCodes["_4"] = 52] = "_4";
    CharacterCodes[CharacterCodes["_5"] = 53] = "_5";
    CharacterCodes[CharacterCodes["_6"] = 54] = "_6";
    CharacterCodes[CharacterCodes["_7"] = 55] = "_7";
    CharacterCodes[CharacterCodes["_8"] = 56] = "_8";
    CharacterCodes[CharacterCodes["_9"] = 57] = "_9";
    CharacterCodes[CharacterCodes["a"] = 97] = "a";
    CharacterCodes[CharacterCodes["b"] = 98] = "b";
    CharacterCodes[CharacterCodes["c"] = 99] = "c";
    CharacterCodes[CharacterCodes["d"] = 100] = "d";
    CharacterCodes[CharacterCodes["e"] = 101] = "e";
    CharacterCodes[CharacterCodes["f"] = 102] = "f";
    CharacterCodes[CharacterCodes["g"] = 103] = "g";
    CharacterCodes[CharacterCodes["h"] = 104] = "h";
    CharacterCodes[CharacterCodes["i"] = 105] = "i";
    CharacterCodes[CharacterCodes["j"] = 106] = "j";
    CharacterCodes[CharacterCodes["k"] = 107] = "k";
    CharacterCodes[CharacterCodes["l"] = 108] = "l";
    CharacterCodes[CharacterCodes["m"] = 109] = "m";
    CharacterCodes[CharacterCodes["n"] = 110] = "n";
    CharacterCodes[CharacterCodes["o"] = 111] = "o";
    CharacterCodes[CharacterCodes["p"] = 112] = "p";
    CharacterCodes[CharacterCodes["q"] = 113] = "q";
    CharacterCodes[CharacterCodes["r"] = 114] = "r";
    CharacterCodes[CharacterCodes["s"] = 115] = "s";
    CharacterCodes[CharacterCodes["t"] = 116] = "t";
    CharacterCodes[CharacterCodes["u"] = 117] = "u";
    CharacterCodes[CharacterCodes["v"] = 118] = "v";
    CharacterCodes[CharacterCodes["w"] = 119] = "w";
    CharacterCodes[CharacterCodes["x"] = 120] = "x";
    CharacterCodes[CharacterCodes["y"] = 121] = "y";
    CharacterCodes[CharacterCodes["z"] = 122] = "z";
    CharacterCodes[CharacterCodes["A"] = 65] = "A";
    CharacterCodes[CharacterCodes["B"] = 66] = "B";
    CharacterCodes[CharacterCodes["C"] = 67] = "C";
    CharacterCodes[CharacterCodes["D"] = 68] = "D";
    CharacterCodes[CharacterCodes["E"] = 69] = "E";
    CharacterCodes[CharacterCodes["F"] = 70] = "F";
    CharacterCodes[CharacterCodes["G"] = 71] = "G";
    CharacterCodes[CharacterCodes["H"] = 72] = "H";
    CharacterCodes[CharacterCodes["I"] = 73] = "I";
    CharacterCodes[CharacterCodes["J"] = 74] = "J";
    CharacterCodes[CharacterCodes["K"] = 75] = "K";
    CharacterCodes[CharacterCodes["L"] = 76] = "L";
    CharacterCodes[CharacterCodes["M"] = 77] = "M";
    CharacterCodes[CharacterCodes["N"] = 78] = "N";
    CharacterCodes[CharacterCodes["O"] = 79] = "O";
    CharacterCodes[CharacterCodes["P"] = 80] = "P";
    CharacterCodes[CharacterCodes["Q"] = 81] = "Q";
    CharacterCodes[CharacterCodes["R"] = 82] = "R";
    CharacterCodes[CharacterCodes["S"] = 83] = "S";
    CharacterCodes[CharacterCodes["T"] = 84] = "T";
    CharacterCodes[CharacterCodes["U"] = 85] = "U";
    CharacterCodes[CharacterCodes["V"] = 86] = "V";
    CharacterCodes[CharacterCodes["W"] = 87] = "W";
    CharacterCodes[CharacterCodes["X"] = 88] = "X";
    CharacterCodes[CharacterCodes["Y"] = 89] = "Y";
    CharacterCodes[CharacterCodes["Z"] = 90] = "Z";
    CharacterCodes[CharacterCodes["ampersand"] = 38] = "ampersand";
    CharacterCodes[CharacterCodes["asterisk"] = 42] = "asterisk";
    CharacterCodes[CharacterCodes["at"] = 64] = "at";
    CharacterCodes[CharacterCodes["backslash"] = 92] = "backslash";
    CharacterCodes[CharacterCodes["bar"] = 124] = "bar";
    CharacterCodes[CharacterCodes["caret"] = 94] = "caret";
    CharacterCodes[CharacterCodes["closeBrace"] = 125] = "closeBrace";
    CharacterCodes[CharacterCodes["closeBracket"] = 93] = "closeBracket";
    CharacterCodes[CharacterCodes["closeParen"] = 41] = "closeParen";
    CharacterCodes[CharacterCodes["colon"] = 58] = "colon";
    CharacterCodes[CharacterCodes["comma"] = 44] = "comma";
    CharacterCodes[CharacterCodes["dot"] = 46] = "dot";
    CharacterCodes[CharacterCodes["doubleQuote"] = 34] = "doubleQuote";
    CharacterCodes[CharacterCodes["equals"] = 61] = "equals";
    CharacterCodes[CharacterCodes["exclamation"] = 33] = "exclamation";
    CharacterCodes[CharacterCodes["greaterThan"] = 62] = "greaterThan";
    CharacterCodes[CharacterCodes["lessThan"] = 60] = "lessThan";
    CharacterCodes[CharacterCodes["minus"] = 45] = "minus";
    CharacterCodes[CharacterCodes["openBrace"] = 123] = "openBrace";
    CharacterCodes[CharacterCodes["openBracket"] = 91] = "openBracket";
    CharacterCodes[CharacterCodes["openParen"] = 40] = "openParen";
    CharacterCodes[CharacterCodes["percent"] = 37] = "percent";
    CharacterCodes[CharacterCodes["plus"] = 43] = "plus";
    CharacterCodes[CharacterCodes["question"] = 63] = "question";
    CharacterCodes[CharacterCodes["semicolon"] = 59] = "semicolon";
    CharacterCodes[CharacterCodes["singleQuote"] = 39] = "singleQuote";
    CharacterCodes[CharacterCodes["slash"] = 47] = "slash";
    CharacterCodes[CharacterCodes["tilde"] = 126] = "tilde";
    CharacterCodes[CharacterCodes["backspace"] = 8] = "backspace";
    CharacterCodes[CharacterCodes["formFeed"] = 12] = "formFeed";
    CharacterCodes[CharacterCodes["byteOrderMark"] = 65279] = "byteOrderMark";
    CharacterCodes[CharacterCodes["tab"] = 9] = "tab";
    CharacterCodes[CharacterCodes["verticalTab"] = 11] = "verticalTab";
})(CharacterCodes || (CharacterCodes = {})));
function getLocation(text, position) {
    const segments = [];
    const earlyReturnException = ( new Object());
    let previousNode = undefined;
    const previousNodeInst = {
        value: {},
        offset: 0,
        length: 0,
        type: 'object',
        parent: undefined
    };
    let isAtPropertyKey = false;
    function setPreviousNode(value, offset, length, type) {
        previousNodeInst.value = value;
        previousNodeInst.offset = offset;
        previousNodeInst.length = length;
        previousNodeInst.type = type;
        previousNodeInst.colonOffset = undefined;
        previousNode = previousNodeInst;
    }
    try {
        visit(text, {
            onObjectBegin: (offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                isAtPropertyKey = position > offset;
                segments.push('');
            },
            onObjectProperty: (name, offset, length) => {
                if (position < offset) {
                    throw earlyReturnException;
                }
                setPreviousNode(name, offset, length, 'property');
                segments[segments.length - 1] = name;
                if (position <= offset + length) {
                    throw earlyReturnException;
                }
            },
            onObjectEnd: (offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.pop();
            },
            onArrayBegin: (offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.push(0);
            },
            onArrayEnd: (offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.pop();
            },
            onLiteralValue: (value, offset, length) => {
                if (position < offset) {
                    throw earlyReturnException;
                }
                setPreviousNode(value, offset, length, getNodeType(value));
                if (position <= offset + length) {
                    throw earlyReturnException;
                }
            },
            onSeparator: (sep, offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                if (sep === ':' && previousNode && previousNode.type === 'property') {
                    previousNode.colonOffset = offset;
                    isAtPropertyKey = false;
                    previousNode = undefined;
                }
                else if (sep === ',') {
                    const last = segments[segments.length - 1];
                    if (typeof last === 'number') {
                        segments[segments.length - 1] = last + 1;
                    }
                    else {
                        isAtPropertyKey = true;
                        segments[segments.length - 1] = '';
                    }
                    previousNode = undefined;
                }
            }
        });
    }
    catch (e) {
        if (e !== earlyReturnException) {
            throw e;
        }
    }
    return {
        path: segments,
        previousNode,
        isAtPropertyKey,
        matches: (pattern) => {
            let k = 0;
            for (let i = 0; k < pattern.length && i < segments.length; i++) {
                if (pattern[k] === segments[i] || pattern[k] === '*') {
                    k++;
                }
                else if (pattern[k] !== '**') {
                    return false;
                }
            }
            return k === pattern.length;
        }
    };
}
function parse(text, errors = [], options = ParseOptions.DEFAULT) {
    let currentProperty = null;
    let currentParent = [];
    const previousParents = [];
    function onValue(value) {
        if (Array.isArray(currentParent)) {
            currentParent.push(value);
        }
        else if (currentProperty !== null) {
            currentParent[currentProperty] = value;
        }
    }
    const visitor = {
        onObjectBegin: () => {
            const object = {};
            onValue(object);
            previousParents.push(currentParent);
            currentParent = object;
            currentProperty = null;
        },
        onObjectProperty: (name) => {
            currentProperty = name;
        },
        onObjectEnd: () => {
            currentParent = previousParents.pop();
        },
        onArrayBegin: () => {
            const array = [];
            onValue(array);
            previousParents.push(currentParent);
            currentParent = array;
            currentProperty = null;
        },
        onArrayEnd: () => {
            currentParent = previousParents.pop();
        },
        onLiteralValue: onValue,
        onError: (error, offset, length) => {
            errors.push({ error, offset, length });
        }
    };
    visit(text, visitor, options);
    return currentParent[0];
}
function parseTree(text, errors = [], options = ParseOptions.DEFAULT) {
    let currentParent = { type: 'array', offset: -1, length: -1, children: [], parent: undefined };
    function ensurePropertyComplete(endOffset) {
        if (currentParent.type === 'property') {
            currentParent.length = endOffset - currentParent.offset;
            currentParent = currentParent.parent;
        }
    }
    function onValue(valueNode) {
        currentParent.children.push(valueNode);
        return valueNode;
    }
    const visitor = {
        onObjectBegin: (offset) => {
            currentParent = onValue({ type: 'object', offset, length: -1, parent: currentParent, children: [] });
        },
        onObjectProperty: (name, offset, length) => {
            currentParent = onValue({ type: 'property', offset, length: -1, parent: currentParent, children: [] });
            currentParent.children.push({ type: 'string', value: name, offset, length, parent: currentParent });
        },
        onObjectEnd: (offset, length) => {
            currentParent.length = offset + length - currentParent.offset;
            currentParent = currentParent.parent;
            ensurePropertyComplete(offset + length);
        },
        onArrayBegin: (offset, length) => {
            currentParent = onValue({ type: 'array', offset, length: -1, parent: currentParent, children: [] });
        },
        onArrayEnd: (offset, length) => {
            currentParent.length = offset + length - currentParent.offset;
            currentParent = currentParent.parent;
            ensurePropertyComplete(offset + length);
        },
        onLiteralValue: (value, offset, length) => {
            onValue({ type: getNodeType(value), offset, length, parent: currentParent, value });
            ensurePropertyComplete(offset + length);
        },
        onSeparator: (sep, offset, length) => {
            if (currentParent.type === 'property') {
                if (sep === ':') {
                    currentParent.colonOffset = offset;
                }
                else if (sep === ',') {
                    ensurePropertyComplete(offset);
                }
            }
        },
        onError: (error, offset, length) => {
            errors.push({ error, offset, length });
        }
    };
    visit(text, visitor, options);
    const result = currentParent.children[0];
    if (result) {
        delete result.parent;
    }
    return result;
}
function findNodeAtLocation(root, path) {
    if (!root) {
        return undefined;
    }
    let node = root;
    for (const segment of path) {
        if (typeof segment === 'string') {
            if (node.type !== 'object' || !Array.isArray(node.children)) {
                return undefined;
            }
            let found = false;
            for (const propertyNode of node.children) {
                if (Array.isArray(propertyNode.children) && propertyNode.children[0].value === segment) {
                    node = propertyNode.children[1];
                    found = true;
                    break;
                }
            }
            if (!found) {
                return undefined;
            }
        }
        else {
            const index = segment;
            if (node.type !== 'array' || index < 0 || !Array.isArray(node.children) || index >= node.children.length) {
                return undefined;
            }
            node = node.children[index];
        }
    }
    return node;
}
function visit(text, visitor, options = ParseOptions.DEFAULT) {
    const _scanner = createScanner(text, false);
    function toNoArgVisit(visitFunction) {
        return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength()) : () => true;
    }
    function toOneArgVisit(visitFunction) {
        return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength()) : () => true;
    }
    const onObjectBegin = toNoArgVisit(visitor.onObjectBegin), onObjectProperty = toOneArgVisit(visitor.onObjectProperty), onObjectEnd = toNoArgVisit(visitor.onObjectEnd), onArrayBegin = toNoArgVisit(visitor.onArrayBegin), onArrayEnd = toNoArgVisit(visitor.onArrayEnd), onLiteralValue = toOneArgVisit(visitor.onLiteralValue), onSeparator = toOneArgVisit(visitor.onSeparator), onComment = toNoArgVisit(visitor.onComment), onError = toOneArgVisit(visitor.onError);
    const disallowComments = options && options.disallowComments;
    const allowTrailingComma = options && options.allowTrailingComma;
    function scanNext() {
        while (true) {
            const token = _scanner.scan();
            switch (_scanner.getTokenError()) {
                case ScanError.InvalidUnicode:
                    handleError(ParseErrorCode.InvalidUnicode);
                    break;
                case ScanError.InvalidEscapeCharacter:
                    handleError(ParseErrorCode.InvalidEscapeCharacter);
                    break;
                case ScanError.UnexpectedEndOfNumber:
                    handleError(ParseErrorCode.UnexpectedEndOfNumber);
                    break;
                case ScanError.UnexpectedEndOfComment:
                    if (!disallowComments) {
                        handleError(ParseErrorCode.UnexpectedEndOfComment);
                    }
                    break;
                case ScanError.UnexpectedEndOfString:
                    handleError(ParseErrorCode.UnexpectedEndOfString);
                    break;
                case ScanError.InvalidCharacter:
                    handleError(ParseErrorCode.InvalidCharacter);
                    break;
            }
            switch (token) {
                case SyntaxKind.LineCommentTrivia:
                case SyntaxKind.BlockCommentTrivia:
                    if (disallowComments) {
                        handleError(ParseErrorCode.InvalidCommentToken);
                    }
                    else {
                        onComment();
                    }
                    break;
                case SyntaxKind.Unknown:
                    handleError(ParseErrorCode.InvalidSymbol);
                    break;
                case SyntaxKind.Trivia:
                case SyntaxKind.LineBreakTrivia:
                    break;
                default:
                    return token;
            }
        }
    }
    function handleError(error, skipUntilAfter = [], skipUntil = []) {
        onError(error);
        if (skipUntilAfter.length + skipUntil.length > 0) {
            let token = _scanner.getToken();
            while (token !== SyntaxKind.EOF) {
                if (skipUntilAfter.indexOf(token) !== -1) {
                    scanNext();
                    break;
                }
                else if (skipUntil.indexOf(token) !== -1) {
                    break;
                }
                token = scanNext();
            }
        }
    }
    function parseString(isValue) {
        const value = _scanner.getTokenValue();
        if (isValue) {
            onLiteralValue(value);
        }
        else {
            onObjectProperty(value);
        }
        scanNext();
        return true;
    }
    function parseLiteral() {
        switch (_scanner.getToken()) {
            case SyntaxKind.NumericLiteral: {
                let value = 0;
                try {
                    value = JSON.parse(_scanner.getTokenValue());
                    if (typeof value !== 'number') {
                        handleError(ParseErrorCode.InvalidNumberFormat);
                        value = 0;
                    }
                }
                catch (e) {
                    handleError(ParseErrorCode.InvalidNumberFormat);
                }
                onLiteralValue(value);
                break;
            }
            case SyntaxKind.NullKeyword:
                onLiteralValue(null);
                break;
            case SyntaxKind.TrueKeyword:
                onLiteralValue(true);
                break;
            case SyntaxKind.FalseKeyword:
                onLiteralValue(false);
                break;
            default:
                return false;
        }
        scanNext();
        return true;
    }
    function parseProperty() {
        if (_scanner.getToken() !== SyntaxKind.StringLiteral) {
            handleError(ParseErrorCode.PropertyNameExpected, [], [SyntaxKind.CloseBraceToken, SyntaxKind.CommaToken]);
            return false;
        }
        parseString(false);
        if (_scanner.getToken() === SyntaxKind.ColonToken) {
            onSeparator(':');
            scanNext();
            if (!parseValue()) {
                handleError(ParseErrorCode.ValueExpected, [], [SyntaxKind.CloseBraceToken, SyntaxKind.CommaToken]);
            }
        }
        else {
            handleError(ParseErrorCode.ColonExpected, [], [SyntaxKind.CloseBraceToken, SyntaxKind.CommaToken]);
        }
        return true;
    }
    function parseObject() {
        onObjectBegin();
        scanNext();
        let needsComma = false;
        while (_scanner.getToken() !== SyntaxKind.CloseBraceToken && _scanner.getToken() !== SyntaxKind.EOF) {
            if (_scanner.getToken() === SyntaxKind.CommaToken) {
                if (!needsComma) {
                    handleError(ParseErrorCode.ValueExpected, [], []);
                }
                onSeparator(',');
                scanNext();
                if (_scanner.getToken() === SyntaxKind.CloseBraceToken && allowTrailingComma) {
                    break;
                }
            }
            else if (needsComma) {
                handleError(ParseErrorCode.CommaExpected, [], []);
            }
            if (!parseProperty()) {
                handleError(ParseErrorCode.ValueExpected, [], [SyntaxKind.CloseBraceToken, SyntaxKind.CommaToken]);
            }
            needsComma = true;
        }
        onObjectEnd();
        if (_scanner.getToken() !== SyntaxKind.CloseBraceToken) {
            handleError(ParseErrorCode.CloseBraceExpected, [SyntaxKind.CloseBraceToken], []);
        }
        else {
            scanNext();
        }
        return true;
    }
    function parseArray() {
        onArrayBegin();
        scanNext();
        let needsComma = false;
        while (_scanner.getToken() !== SyntaxKind.CloseBracketToken && _scanner.getToken() !== SyntaxKind.EOF) {
            if (_scanner.getToken() === SyntaxKind.CommaToken) {
                if (!needsComma) {
                    handleError(ParseErrorCode.ValueExpected, [], []);
                }
                onSeparator(',');
                scanNext();
                if (_scanner.getToken() === SyntaxKind.CloseBracketToken && allowTrailingComma) {
                    break;
                }
            }
            else if (needsComma) {
                handleError(ParseErrorCode.CommaExpected, [], []);
            }
            if (!parseValue()) {
                handleError(ParseErrorCode.ValueExpected, [], [SyntaxKind.CloseBracketToken, SyntaxKind.CommaToken]);
            }
            needsComma = true;
        }
        onArrayEnd();
        if (_scanner.getToken() !== SyntaxKind.CloseBracketToken) {
            handleError(ParseErrorCode.CloseBracketExpected, [SyntaxKind.CloseBracketToken], []);
        }
        else {
            scanNext();
        }
        return true;
    }
    function parseValue() {
        switch (_scanner.getToken()) {
            case SyntaxKind.OpenBracketToken:
                return parseArray();
            case SyntaxKind.OpenBraceToken:
                return parseObject();
            case SyntaxKind.StringLiteral:
                return parseString(true);
            default:
                return parseLiteral();
        }
    }
    scanNext();
    if (_scanner.getToken() === SyntaxKind.EOF) {
        if (options.allowEmptyContent) {
            return true;
        }
        handleError(ParseErrorCode.ValueExpected, [], []);
        return false;
    }
    if (!parseValue()) {
        handleError(ParseErrorCode.ValueExpected, [], []);
        return false;
    }
    if (_scanner.getToken() !== SyntaxKind.EOF) {
        handleError(ParseErrorCode.EndOfFileExpected, [], []);
    }
    return true;
}
function getNodeType(value) {
    switch (typeof value) {
        case 'boolean': return 'boolean';
        case 'number': return 'number';
        case 'string': return 'string';
        case 'object': {
            if (!value) {
                return 'null';
            }
            else if (Array.isArray(value)) {
                return 'array';
            }
            return 'object';
        }
        default: return 'null';
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/labels.js":
/*!*****************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/labels.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getPathLabel: () => (/* binding */ getPathLabel),
/* harmony export */   mnemonicButtonLabel: () => (/* binding */ mnemonicButtonLabel),
/* harmony export */   mnemonicMenuLabel: () => (/* binding */ mnemonicMenuLabel),
/* harmony export */   normalizeDriveLetter: () => (/* binding */ normalizeDriveLetter),
/* harmony export */   shorten: () => (/* binding */ shorten),
/* harmony export */   splitRecentLabel: () => (/* binding */ splitRecentLabel),
/* harmony export */   template: () => (/* binding */ template),
/* harmony export */   tildify: () => (/* binding */ tildify),
/* harmony export */   unmnemonicLabel: () => (/* binding */ unmnemonicLabel),
/* harmony export */   untildify: () => (/* binding */ untildify)
/* harmony export */ });
/* harmony import */ var _arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _extpath_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./extpath.js */ "./node_modules/vscode/vscode/src/vs/base/common/extpath.js");
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./path.js */ "./node_modules/vscode/vscode/src/vs/base/common/path.js");
/* harmony import */ var _platform_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _resources_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./resources.js */ "./node_modules/vscode/vscode/src/vs/base/common/resources.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");






function getPathLabel(resource, formatting) {
    const { os, tildify: tildifier, relative: relatifier } = formatting;
    if (relatifier) {
        const relativePath = getRelativePathLabel(resource, relatifier, os);
        if (typeof relativePath === 'string') {
            return relativePath;
        }
    }
    let absolutePath = resource.fsPath;
    if (os === _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Windows && !_platform_js__WEBPACK_IMPORTED_MODULE_3__.isWindows) {
        absolutePath = absolutePath.replace(/\//g, '\\');
    }
    else if (os !== _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Windows && _platform_js__WEBPACK_IMPORTED_MODULE_3__.isWindows) {
        absolutePath = absolutePath.replace(/\\/g, '/');
    }
    if (os !== _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Windows && tildifier?.userHome) {
        const userHome = tildifier.userHome.fsPath;
        let userHomeCandidate;
        if (resource.scheme !== tildifier.userHome.scheme && resource.path[0] === _path_js__WEBPACK_IMPORTED_MODULE_2__.posix.sep && resource.path[1] !== _path_js__WEBPACK_IMPORTED_MODULE_2__.posix.sep) {
            userHomeCandidate = tildifier.userHome.with({ path: resource.path }).fsPath;
        }
        else {
            userHomeCandidate = absolutePath;
        }
        absolutePath = tildify(userHomeCandidate, userHome, os);
    }
    const pathLib = os === _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Windows ? _path_js__WEBPACK_IMPORTED_MODULE_2__.win32 : _path_js__WEBPACK_IMPORTED_MODULE_2__.posix;
    return pathLib.normalize(normalizeDriveLetter(absolutePath, os === _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Windows));
}
function getRelativePathLabel(resource, relativePathProvider, os) {
    const pathLib = os === _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Windows ? _path_js__WEBPACK_IMPORTED_MODULE_2__.win32 : _path_js__WEBPACK_IMPORTED_MODULE_2__.posix;
    const extUriLib = os === _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Linux ? _resources_js__WEBPACK_IMPORTED_MODULE_4__.extUri : _resources_js__WEBPACK_IMPORTED_MODULE_4__.extUriIgnorePathCase;
    const workspace = relativePathProvider.getWorkspace();
    const firstFolder = (0,_arrays_js__WEBPACK_IMPORTED_MODULE_0__.firstOrDefault)(workspace.folders);
    if (!firstFolder) {
        return undefined;
    }
    if (resource.scheme !== firstFolder.uri.scheme && resource.path[0] === _path_js__WEBPACK_IMPORTED_MODULE_2__.posix.sep && resource.path[1] !== _path_js__WEBPACK_IMPORTED_MODULE_2__.posix.sep) {
        resource = firstFolder.uri.with({ path: resource.path });
    }
    const folder = relativePathProvider.getWorkspaceFolder(resource);
    if (!folder) {
        return undefined;
    }
    let relativePathLabel = undefined;
    if (extUriLib.isEqual(folder.uri, resource)) {
        relativePathLabel = '';
    }
    else {
        relativePathLabel = extUriLib.relativePath(folder.uri, resource) ?? '';
    }
    if (relativePathLabel) {
        relativePathLabel = pathLib.normalize(relativePathLabel);
    }
    if (workspace.folders.length > 1 && !relativePathProvider.noPrefix) {
        const rootName = folder.name ? folder.name : extUriLib.basenameOrAuthority(folder.uri);
        relativePathLabel = relativePathLabel ? `${rootName} • ${relativePathLabel}` : rootName;
    }
    return relativePathLabel;
}
function normalizeDriveLetter(path, isWindowsOS = _platform_js__WEBPACK_IMPORTED_MODULE_3__.isWindows) {
    if ((0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.hasDriveLetter)(path, isWindowsOS)) {
        return path.charAt(0).toUpperCase() + path.slice(1);
    }
    return path;
}
let normalizedUserHomeCached = Object.create(null);
function tildify(path, userHome, os = _platform_js__WEBPACK_IMPORTED_MODULE_3__.OS) {
    if (os === _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Windows || !path || !userHome) {
        return path;
    }
    let normalizedUserHome = normalizedUserHomeCached.original === userHome ? normalizedUserHomeCached.normalized : undefined;
    if (!normalizedUserHome) {
        normalizedUserHome = userHome;
        if (_platform_js__WEBPACK_IMPORTED_MODULE_3__.isWindows) {
            normalizedUserHome = (0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.toSlashes)(normalizedUserHome);
        }
        normalizedUserHome = `${(0,_strings_js__WEBPACK_IMPORTED_MODULE_5__.rtrim)(normalizedUserHome, _path_js__WEBPACK_IMPORTED_MODULE_2__.posix.sep)}${_path_js__WEBPACK_IMPORTED_MODULE_2__.posix.sep}`;
        normalizedUserHomeCached = { original: userHome, normalized: normalizedUserHome };
    }
    let normalizedPath = path;
    if (_platform_js__WEBPACK_IMPORTED_MODULE_3__.isWindows) {
        normalizedPath = (0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.toSlashes)(normalizedPath);
    }
    if (os === _platform_js__WEBPACK_IMPORTED_MODULE_3__.OperatingSystem.Linux ? normalizedPath.startsWith(normalizedUserHome) : (0,_strings_js__WEBPACK_IMPORTED_MODULE_5__.startsWithIgnoreCase)(normalizedPath, normalizedUserHome)) {
        return `~/${normalizedPath.substr(normalizedUserHome.length)}`;
    }
    return path;
}
function untildify(path, userHome) {
    return path.replace(/^~($|\/|\\)/, `${userHome}$1`);
}
const ellipsis = '\u2026';
const unc = '\\\\';
const home = '~';
function shorten(paths, pathSeparator = _path_js__WEBPACK_IMPORTED_MODULE_2__.sep) {
    const shortenedPaths = ( new Array(paths.length));
    let match = false;
    for (let pathIndex = 0; pathIndex < paths.length; pathIndex++) {
        const originalPath = paths[pathIndex];
        if (originalPath === '') {
            shortenedPaths[pathIndex] = `.${pathSeparator}`;
            continue;
        }
        if (!originalPath) {
            shortenedPaths[pathIndex] = originalPath;
            continue;
        }
        match = true;
        let prefix = '';
        let trimmedPath = originalPath;
        if (trimmedPath.indexOf(unc) === 0) {
            prefix = trimmedPath.substr(0, trimmedPath.indexOf(unc) + unc.length);
            trimmedPath = trimmedPath.substr(trimmedPath.indexOf(unc) + unc.length);
        }
        else if (trimmedPath.indexOf(pathSeparator) === 0) {
            prefix = trimmedPath.substr(0, trimmedPath.indexOf(pathSeparator) + pathSeparator.length);
            trimmedPath = trimmedPath.substr(trimmedPath.indexOf(pathSeparator) + pathSeparator.length);
        }
        else if (trimmedPath.indexOf(home) === 0) {
            prefix = trimmedPath.substr(0, trimmedPath.indexOf(home) + home.length);
            trimmedPath = trimmedPath.substr(trimmedPath.indexOf(home) + home.length);
        }
        const segments = trimmedPath.split(pathSeparator);
        for (let subpathLength = 1; match && subpathLength <= segments.length; subpathLength++) {
            for (let start = segments.length - subpathLength; match && start >= 0; start--) {
                match = false;
                let subpath = segments.slice(start, start + subpathLength).join(pathSeparator);
                for (let otherPathIndex = 0; !match && otherPathIndex < paths.length; otherPathIndex++) {
                    if (otherPathIndex !== pathIndex && paths[otherPathIndex] && paths[otherPathIndex].indexOf(subpath) > -1) {
                        const isSubpathEnding = (start + subpathLength === segments.length);
                        const subpathWithSep = (start > 0 && paths[otherPathIndex].indexOf(pathSeparator) > -1) ? pathSeparator + subpath : subpath;
                        const isOtherPathEnding = paths[otherPathIndex].endsWith(subpathWithSep);
                        match = !isSubpathEnding || isOtherPathEnding;
                    }
                }
                if (!match) {
                    let result = '';
                    if (segments[0].endsWith(':') || prefix !== '') {
                        if (start === 1) {
                            start = 0;
                            subpathLength++;
                            subpath = segments[0] + pathSeparator + subpath;
                        }
                        if (start > 0) {
                            result = segments[0] + pathSeparator;
                        }
                        result = prefix + result;
                    }
                    if (start > 0) {
                        result = result + ellipsis + pathSeparator;
                    }
                    result = result + subpath;
                    if (start + subpathLength < segments.length) {
                        result = result + pathSeparator + ellipsis;
                    }
                    shortenedPaths[pathIndex] = result;
                }
            }
        }
        if (match) {
            shortenedPaths[pathIndex] = originalPath;
        }
    }
    return shortenedPaths;
}
var Type;
( (function(Type) {
    Type[Type["TEXT"] = 0] = "TEXT";
    Type[Type["VARIABLE"] = 1] = "VARIABLE";
    Type[Type["SEPARATOR"] = 2] = "SEPARATOR";
})(Type || (Type = {})));
function template(template, values = Object.create(null)) {
    const segments = [];
    let inVariable = false;
    let curVal = '';
    for (const char of template) {
        if (char === '$' || (inVariable && char === '{')) {
            if (curVal) {
                segments.push({ value: curVal, type: Type.TEXT });
            }
            curVal = '';
            inVariable = true;
        }
        else if (char === '}' && inVariable) {
            const resolved = values[curVal];
            if (typeof resolved === 'string') {
                if (resolved.length) {
                    segments.push({ value: resolved, type: Type.VARIABLE });
                }
            }
            else if (resolved) {
                const prevSegment = segments[segments.length - 1];
                if (!prevSegment || prevSegment.type !== Type.SEPARATOR) {
                    segments.push({ value: resolved.label, type: Type.SEPARATOR });
                }
            }
            curVal = '';
            inVariable = false;
        }
        else {
            curVal += char;
        }
    }
    if (curVal && !inVariable) {
        segments.push({ value: curVal, type: Type.TEXT });
    }
    return ( segments.filter((segment, index) => {
        if (segment.type === Type.SEPARATOR) {
            const left = segments[index - 1];
            const right = segments[index + 1];
            return [left, right].every(segment => segment && (segment.type === Type.VARIABLE || segment.type === Type.TEXT) && segment.value.length > 0);
        }
        return true;
    }).map(segment => segment.value)).join('');
}
function mnemonicMenuLabel(label, forceDisableMnemonics) {
    if (_platform_js__WEBPACK_IMPORTED_MODULE_3__.isMacintosh || forceDisableMnemonics) {
        return label.replace(/\(&&\w\)|&&/g, '').replace(/&/g, _platform_js__WEBPACK_IMPORTED_MODULE_3__.isMacintosh ? '&' : '&&');
    }
    return label.replace(/&&|&/g, m => m === '&' ? '&&' : '&');
}
function mnemonicButtonLabel(label, forceDisableMnemonics) {
    if (_platform_js__WEBPACK_IMPORTED_MODULE_3__.isMacintosh || forceDisableMnemonics) {
        return label.replace(/\(&&\w\)|&&/g, '');
    }
    if (_platform_js__WEBPACK_IMPORTED_MODULE_3__.isWindows) {
        return label.replace(/&&|&/g, m => m === '&' ? '&&' : '&');
    }
    return label.replace(/&&/g, '_');
}
function unmnemonicLabel(label) {
    return label.replace(/&/g, '&&');
}
function splitRecentLabel(recentLabel) {
    if (recentLabel.endsWith(']')) {
        const lastIndexOfSquareBracket = recentLabel.lastIndexOf(' [', recentLabel.length - 2);
        if (lastIndexOfSquareBracket !== -1) {
            const split = splitName(recentLabel.substring(0, lastIndexOfSquareBracket));
            const remoteNameWithSpace = recentLabel.substring(lastIndexOfSquareBracket);
            return { name: split.name + remoteNameWithSpace, parentPath: split.parentPath };
        }
    }
    return splitName(recentLabel);
}
function splitName(fullPath) {
    const p = fullPath.indexOf('/') !== -1 ? _path_js__WEBPACK_IMPORTED_MODULE_2__.posix : _path_js__WEBPACK_IMPORTED_MODULE_2__.win32;
    const name = p.basename(fullPath);
    const parentPath = p.dirname(fullPath);
    if (name.length) {
        return { name, parentPath };
    }
    return { name: parentPath, parentPath: '' };
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/marshalling.js":
/*!**********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/marshalling.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   revive: () => (/* binding */ revive),
/* harmony export */   stringify: () => (/* binding */ stringify)
/* harmony export */ });
/* harmony import */ var _buffer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./buffer.js */ "./node_modules/vscode/vscode/src/vs/base/common/buffer.js");
/* harmony import */ var _uri_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");
/* harmony import */ var _marshallingIds_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./marshallingIds.js */ "./node_modules/vscode/vscode/src/vs/base/common/marshallingIds.js");



function stringify(obj) {
    return JSON.stringify(obj, replacer);
}
function parse(text) {
    let data = JSON.parse(text);
    data = revive(data);
    return data;
}
function replacer(key, value) {
    if (value instanceof RegExp) {
        return {
            $mid: _marshallingIds_js__WEBPACK_IMPORTED_MODULE_2__.MarshalledId.Regexp,
            source: value.source,
            flags: value.flags,
        };
    }
    return value;
}
function revive(obj, depth = 0) {
    if (!obj || depth > 200) {
        return obj;
    }
    if (typeof obj === 'object') {
        switch (obj.$mid) {
            case _marshallingIds_js__WEBPACK_IMPORTED_MODULE_2__.MarshalledId.Uri: return _uri_js__WEBPACK_IMPORTED_MODULE_1__.URI.revive(obj);
            case _marshallingIds_js__WEBPACK_IMPORTED_MODULE_2__.MarshalledId.Regexp: return ( new RegExp(obj.source, obj.flags));
            case _marshallingIds_js__WEBPACK_IMPORTED_MODULE_2__.MarshalledId.Date: return ( new Date(obj.source));
        }
        if (obj instanceof _buffer_js__WEBPACK_IMPORTED_MODULE_0__.VSBuffer
            || obj instanceof Uint8Array) {
            return obj;
        }
        if (Array.isArray(obj)) {
            for (let i = 0; i < obj.length; ++i) {
                obj[i] = revive(obj[i], depth + 1);
            }
        }
        else {
            for (const key in obj) {
                if (Object.hasOwnProperty.call(obj, key)) {
                    obj[key] = revive(obj[key], depth + 1);
                }
            }
        }
    }
    return obj;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/mime.js":
/*!***************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/mime.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mimes: () => (/* binding */ Mimes),
/* harmony export */   getExtensionForMimeType: () => (/* binding */ getExtensionForMimeType),
/* harmony export */   getMediaMime: () => (/* binding */ getMediaMime),
/* harmony export */   getMediaOrTextMime: () => (/* binding */ getMediaOrTextMime),
/* harmony export */   normalizeMimeType: () => (/* binding */ normalizeMimeType)
/* harmony export */ });
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./path.js */ "./node_modules/vscode/vscode/src/vs/base/common/path.js");

const Mimes = ( Object.freeze({
    text: 'text/plain',
    binary: 'application/octet-stream',
    unknown: 'application/unknown',
    markdown: 'text/markdown',
    latex: 'text/latex',
    uriList: 'text/uri-list',
}));
const mapExtToTextMimes = {
    '.css': 'text/css',
    '.csv': 'text/csv',
    '.htm': 'text/html',
    '.html': 'text/html',
    '.ics': 'text/calendar',
    '.js': 'text/javascript',
    '.mjs': 'text/javascript',
    '.txt': 'text/plain',
    '.xml': 'text/xml'
};
const mapExtToMediaMimes = {
    '.aac': 'audio/x-aac',
    '.avi': 'video/x-msvideo',
    '.bmp': 'image/bmp',
    '.flv': 'video/x-flv',
    '.gif': 'image/gif',
    '.ico': 'image/x-icon',
    '.jpe': 'image/jpg',
    '.jpeg': 'image/jpg',
    '.jpg': 'image/jpg',
    '.m1v': 'video/mpeg',
    '.m2a': 'audio/mpeg',
    '.m2v': 'video/mpeg',
    '.m3a': 'audio/mpeg',
    '.mid': 'audio/midi',
    '.midi': 'audio/midi',
    '.mk3d': 'video/x-matroska',
    '.mks': 'video/x-matroska',
    '.mkv': 'video/x-matroska',
    '.mov': 'video/quicktime',
    '.movie': 'video/x-sgi-movie',
    '.mp2': 'audio/mpeg',
    '.mp2a': 'audio/mpeg',
    '.mp3': 'audio/mpeg',
    '.mp4': 'video/mp4',
    '.mp4a': 'audio/mp4',
    '.mp4v': 'video/mp4',
    '.mpe': 'video/mpeg',
    '.mpeg': 'video/mpeg',
    '.mpg': 'video/mpeg',
    '.mpg4': 'video/mp4',
    '.mpga': 'audio/mpeg',
    '.oga': 'audio/ogg',
    '.ogg': 'audio/ogg',
    '.opus': 'audio/opus',
    '.ogv': 'video/ogg',
    '.png': 'image/png',
    '.psd': 'image/vnd.adobe.photoshop',
    '.qt': 'video/quicktime',
    '.spx': 'audio/ogg',
    '.svg': 'image/svg+xml',
    '.tga': 'image/x-tga',
    '.tif': 'image/tiff',
    '.tiff': 'image/tiff',
    '.wav': 'audio/x-wav',
    '.webm': 'video/webm',
    '.webp': 'image/webp',
    '.wma': 'audio/x-ms-wma',
    '.wmv': 'video/x-ms-wmv',
    '.woff': 'application/font-woff',
};
function getMediaOrTextMime(path) {
    const ext = (0,_path_js__WEBPACK_IMPORTED_MODULE_0__.extname)(path);
    const textMime = mapExtToTextMimes[ext.toLowerCase()];
    if (textMime !== undefined) {
        return textMime;
    }
    else {
        return getMediaMime(path);
    }
}
function getMediaMime(path) {
    const ext = (0,_path_js__WEBPACK_IMPORTED_MODULE_0__.extname)(path);
    return mapExtToMediaMimes[ext.toLowerCase()];
}
function getExtensionForMimeType(mimeType) {
    for (const extension in mapExtToMediaMimes) {
        if (mapExtToMediaMimes[extension] === mimeType) {
            return extension;
        }
    }
    return undefined;
}
const _simplePattern = /^(.+)\/(.+?)(;.+)?$/;
function normalizeMimeType(mimeType, strict) {
    const match = _simplePattern.exec(mimeType);
    if (!match) {
        return strict
            ? undefined
            : mimeType;
    }
    return `${match[1].toLowerCase()}/${match[2].toLowerCase()}${match[3] ?? ''}`;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/naturalLanguage/korean.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/naturalLanguage/korean.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getKoreanAltChars: () => (/* binding */ getKoreanAltChars)
/* harmony export */ });
function getKoreanAltChars(code) {
    const result = disassembleKorean(code);
    if (result && result.length > 0) {
        return ( new Uint32Array(result));
    }
    return undefined;
}
let codeBufferLength = 0;
const codeBuffer = ( new Uint32Array(10));
function disassembleKorean(code) {
    codeBufferLength = 0;
    getCodesFromArray(code, modernConsonants, HangulRangeStartCode.InitialConsonant);
    if (codeBufferLength > 0) {
        return codeBuffer.subarray(0, codeBufferLength);
    }
    getCodesFromArray(code, modernVowels, HangulRangeStartCode.Vowel);
    if (codeBufferLength > 0) {
        return codeBuffer.subarray(0, codeBufferLength);
    }
    getCodesFromArray(code, modernFinalConsonants, HangulRangeStartCode.FinalConsonant);
    if (codeBufferLength > 0) {
        return codeBuffer.subarray(0, codeBufferLength);
    }
    getCodesFromArray(code, compatibilityJamo, HangulRangeStartCode.CompatibilityJamo);
    if (codeBufferLength) {
        return codeBuffer.subarray(0, codeBufferLength);
    }
    if (code >= 0xAC00 && code <= 0xD7A3) {
        const hangulIndex = code - 0xAC00;
        const vowelAndFinalConsonantProduct = hangulIndex % 588;
        const initialConsonantIndex = Math.floor(hangulIndex / 588);
        const vowelIndex = Math.floor(vowelAndFinalConsonantProduct / 28);
        const finalConsonantIndex = vowelAndFinalConsonantProduct % 28 - 1;
        if (initialConsonantIndex < modernConsonants.length) {
            getCodesFromArray(initialConsonantIndex, modernConsonants, 0);
        }
        else if (HangulRangeStartCode.InitialConsonant + initialConsonantIndex - HangulRangeStartCode.CompatibilityJamo < compatibilityJamo.length) {
            getCodesFromArray(HangulRangeStartCode.InitialConsonant + initialConsonantIndex, compatibilityJamo, HangulRangeStartCode.CompatibilityJamo);
        }
        if (vowelIndex < modernVowels.length) {
            getCodesFromArray(vowelIndex, modernVowels, 0);
        }
        else if (HangulRangeStartCode.Vowel + vowelIndex - HangulRangeStartCode.CompatibilityJamo < compatibilityJamo.length) {
            getCodesFromArray(HangulRangeStartCode.Vowel + vowelIndex - HangulRangeStartCode.CompatibilityJamo, compatibilityJamo, HangulRangeStartCode.CompatibilityJamo);
        }
        if (finalConsonantIndex >= 0) {
            if (finalConsonantIndex < modernFinalConsonants.length) {
                getCodesFromArray(finalConsonantIndex, modernFinalConsonants, 0);
            }
            else if (HangulRangeStartCode.FinalConsonant + finalConsonantIndex - HangulRangeStartCode.CompatibilityJamo < compatibilityJamo.length) {
                getCodesFromArray(HangulRangeStartCode.FinalConsonant + finalConsonantIndex - HangulRangeStartCode.CompatibilityJamo, compatibilityJamo, HangulRangeStartCode.CompatibilityJamo);
            }
        }
        if (codeBufferLength > 0) {
            return codeBuffer.subarray(0, codeBufferLength);
        }
    }
    return undefined;
}
function getCodesFromArray(code, array, arrayStartIndex) {
    if (code >= arrayStartIndex && code < arrayStartIndex + array.length) {
        addCodesToBuffer(array[code - arrayStartIndex]);
    }
}
function addCodesToBuffer(codes) {
    if (codes === AsciiCode.NUL) {
        return;
    }
    codeBuffer[codeBufferLength++] = codes & 0xFF;
    if (codes >> 8) {
        codeBuffer[codeBufferLength++] = (codes >> 8) & 0xFF;
    }
    if (codes >> 16) {
        codeBuffer[codeBufferLength++] = (codes >> 16) & 0xFF;
    }
}
var HangulRangeStartCode;
( (function(HangulRangeStartCode) {
    HangulRangeStartCode[HangulRangeStartCode["InitialConsonant"] = 4352] = "InitialConsonant";
    HangulRangeStartCode[HangulRangeStartCode["Vowel"] = 4449] = "Vowel";
    HangulRangeStartCode[HangulRangeStartCode["FinalConsonant"] = 4520] = "FinalConsonant";
    HangulRangeStartCode[HangulRangeStartCode["CompatibilityJamo"] = 12593] = "CompatibilityJamo";
})(HangulRangeStartCode || (HangulRangeStartCode = {})));
var AsciiCode;
( (function(AsciiCode) {
    AsciiCode[AsciiCode["NUL"] = 0] = "NUL";
    AsciiCode[AsciiCode["A"] = 65] = "A";
    AsciiCode[AsciiCode["B"] = 66] = "B";
    AsciiCode[AsciiCode["C"] = 67] = "C";
    AsciiCode[AsciiCode["D"] = 68] = "D";
    AsciiCode[AsciiCode["E"] = 69] = "E";
    AsciiCode[AsciiCode["F"] = 70] = "F";
    AsciiCode[AsciiCode["G"] = 71] = "G";
    AsciiCode[AsciiCode["H"] = 72] = "H";
    AsciiCode[AsciiCode["I"] = 73] = "I";
    AsciiCode[AsciiCode["J"] = 74] = "J";
    AsciiCode[AsciiCode["K"] = 75] = "K";
    AsciiCode[AsciiCode["L"] = 76] = "L";
    AsciiCode[AsciiCode["M"] = 77] = "M";
    AsciiCode[AsciiCode["N"] = 78] = "N";
    AsciiCode[AsciiCode["O"] = 79] = "O";
    AsciiCode[AsciiCode["P"] = 80] = "P";
    AsciiCode[AsciiCode["Q"] = 81] = "Q";
    AsciiCode[AsciiCode["R"] = 82] = "R";
    AsciiCode[AsciiCode["S"] = 83] = "S";
    AsciiCode[AsciiCode["T"] = 84] = "T";
    AsciiCode[AsciiCode["U"] = 85] = "U";
    AsciiCode[AsciiCode["V"] = 86] = "V";
    AsciiCode[AsciiCode["W"] = 87] = "W";
    AsciiCode[AsciiCode["X"] = 88] = "X";
    AsciiCode[AsciiCode["Y"] = 89] = "Y";
    AsciiCode[AsciiCode["Z"] = 90] = "Z";
    AsciiCode[AsciiCode["a"] = 97] = "a";
    AsciiCode[AsciiCode["b"] = 98] = "b";
    AsciiCode[AsciiCode["c"] = 99] = "c";
    AsciiCode[AsciiCode["d"] = 100] = "d";
    AsciiCode[AsciiCode["e"] = 101] = "e";
    AsciiCode[AsciiCode["f"] = 102] = "f";
    AsciiCode[AsciiCode["g"] = 103] = "g";
    AsciiCode[AsciiCode["h"] = 104] = "h";
    AsciiCode[AsciiCode["i"] = 105] = "i";
    AsciiCode[AsciiCode["j"] = 106] = "j";
    AsciiCode[AsciiCode["k"] = 107] = "k";
    AsciiCode[AsciiCode["l"] = 108] = "l";
    AsciiCode[AsciiCode["m"] = 109] = "m";
    AsciiCode[AsciiCode["n"] = 110] = "n";
    AsciiCode[AsciiCode["o"] = 111] = "o";
    AsciiCode[AsciiCode["p"] = 112] = "p";
    AsciiCode[AsciiCode["q"] = 113] = "q";
    AsciiCode[AsciiCode["r"] = 114] = "r";
    AsciiCode[AsciiCode["s"] = 115] = "s";
    AsciiCode[AsciiCode["t"] = 116] = "t";
    AsciiCode[AsciiCode["u"] = 117] = "u";
    AsciiCode[AsciiCode["v"] = 118] = "v";
    AsciiCode[AsciiCode["w"] = 119] = "w";
    AsciiCode[AsciiCode["x"] = 120] = "x";
    AsciiCode[AsciiCode["y"] = 121] = "y";
    AsciiCode[AsciiCode["z"] = 122] = "z";
})(AsciiCode || (AsciiCode = {})));
var AsciiCodeCombo;
( (function(AsciiCodeCombo) {
    AsciiCodeCombo[AsciiCodeCombo["fa"] = 24934] = "fa";
    AsciiCodeCombo[AsciiCodeCombo["fg"] = 26470] = "fg";
    AsciiCodeCombo[AsciiCodeCombo["fq"] = 29030] = "fq";
    AsciiCodeCombo[AsciiCodeCombo["fr"] = 29286] = "fr";
    AsciiCodeCombo[AsciiCodeCombo["ft"] = 29798] = "ft";
    AsciiCodeCombo[AsciiCodeCombo["fv"] = 30310] = "fv";
    AsciiCodeCombo[AsciiCodeCombo["fx"] = 30822] = "fx";
    AsciiCodeCombo[AsciiCodeCombo["hk"] = 27496] = "hk";
    AsciiCodeCombo[AsciiCodeCombo["hl"] = 27752] = "hl";
    AsciiCodeCombo[AsciiCodeCombo["ho"] = 28520] = "ho";
    AsciiCodeCombo[AsciiCodeCombo["ml"] = 27757] = "ml";
    AsciiCodeCombo[AsciiCodeCombo["nj"] = 27246] = "nj";
    AsciiCodeCombo[AsciiCodeCombo["nl"] = 27758] = "nl";
    AsciiCodeCombo[AsciiCodeCombo["np"] = 28782] = "np";
    AsciiCodeCombo[AsciiCodeCombo["qt"] = 29809] = "qt";
    AsciiCodeCombo[AsciiCodeCombo["rt"] = 29810] = "rt";
    AsciiCodeCombo[AsciiCodeCombo["sg"] = 26483] = "sg";
    AsciiCodeCombo[AsciiCodeCombo["sw"] = 30579] = "sw";
})(AsciiCodeCombo || (AsciiCodeCombo = {})));
const modernConsonants = ( new Uint8Array([
    AsciiCode.r,
    AsciiCode.R,
    AsciiCode.s,
    AsciiCode.e,
    AsciiCode.E,
    AsciiCode.f,
    AsciiCode.a,
    AsciiCode.q,
    AsciiCode.Q,
    AsciiCode.t,
    AsciiCode.T,
    AsciiCode.d,
    AsciiCode.w,
    AsciiCode.W,
    AsciiCode.c,
    AsciiCode.z,
    AsciiCode.x,
    AsciiCode.v,
    AsciiCode.g,
]));
const modernVowels = ( new Uint16Array([
    AsciiCode.k,
    AsciiCode.o,
    AsciiCode.i,
    AsciiCode.O,
    AsciiCode.j,
    AsciiCode.p,
    AsciiCode.u,
    AsciiCode.P,
    AsciiCode.h,
    AsciiCodeCombo.hk,
    AsciiCodeCombo.ho,
    AsciiCodeCombo.hl,
    AsciiCode.y,
    AsciiCode.n,
    AsciiCodeCombo.nj,
    AsciiCodeCombo.np,
    AsciiCodeCombo.nl,
    AsciiCode.b,
    AsciiCode.m,
    AsciiCodeCombo.ml,
    AsciiCode.l,
]));
const modernFinalConsonants = ( new Uint16Array([
    AsciiCode.r,
    AsciiCode.R,
    AsciiCodeCombo.rt,
    AsciiCode.s,
    AsciiCodeCombo.sw,
    AsciiCodeCombo.sg,
    AsciiCode.e,
    AsciiCode.f,
    AsciiCodeCombo.fr,
    AsciiCodeCombo.fa,
    AsciiCodeCombo.fq,
    AsciiCodeCombo.ft,
    AsciiCodeCombo.fx,
    AsciiCodeCombo.fv,
    AsciiCodeCombo.fg,
    AsciiCode.a,
    AsciiCode.q,
    AsciiCodeCombo.qt,
    AsciiCode.t,
    AsciiCode.T,
    AsciiCode.d,
    AsciiCode.w,
    AsciiCode.c,
    AsciiCode.z,
    AsciiCode.x,
    AsciiCode.v,
    AsciiCode.g,
]));
const compatibilityJamo = ( new Uint16Array([
    AsciiCode.r,
    AsciiCode.R,
    AsciiCodeCombo.rt,
    AsciiCode.s,
    AsciiCodeCombo.sw,
    AsciiCodeCombo.sg,
    AsciiCode.e,
    AsciiCode.E,
    AsciiCode.f,
    AsciiCodeCombo.fr,
    AsciiCodeCombo.fa,
    AsciiCodeCombo.fq,
    AsciiCodeCombo.ft,
    AsciiCodeCombo.fx,
    AsciiCodeCombo.fv,
    AsciiCodeCombo.fg,
    AsciiCode.a,
    AsciiCode.q,
    AsciiCode.Q,
    AsciiCodeCombo.qt,
    AsciiCode.t,
    AsciiCode.T,
    AsciiCode.d,
    AsciiCode.w,
    AsciiCode.W,
    AsciiCode.c,
    AsciiCode.z,
    AsciiCode.x,
    AsciiCode.v,
    AsciiCode.g,
    AsciiCode.k,
    AsciiCode.o,
    AsciiCode.i,
    AsciiCode.O,
    AsciiCode.j,
    AsciiCode.p,
    AsciiCode.u,
    AsciiCode.P,
    AsciiCode.h,
    AsciiCodeCombo.hk,
    AsciiCodeCombo.ho,
    AsciiCodeCombo.hl,
    AsciiCode.y,
    AsciiCode.n,
    AsciiCodeCombo.nj,
    AsciiCodeCombo.np,
    AsciiCodeCombo.nl,
    AsciiCode.b,
    AsciiCode.m,
    AsciiCodeCombo.ml,
    AsciiCode.l,
]));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/network.js":
/*!******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/network.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COI: () => (/* binding */ COI),
/* harmony export */   FileAccess: () => (/* binding */ FileAccess),
/* harmony export */   RemoteAuthorities: () => (/* binding */ RemoteAuthorities),
/* harmony export */   Schemas: () => (/* binding */ Schemas),
/* harmony export */   VSCODE_AUTHORITY: () => (/* binding */ VSCODE_AUTHORITY),
/* harmony export */   connectionTokenQueryName: () => (/* binding */ connectionTokenQueryName),
/* harmony export */   getServerRootPath: () => (/* binding */ getServerRootPath),
/* harmony export */   matchesScheme: () => (/* binding */ matchesScheme),
/* harmony export */   matchesSomeScheme: () => (/* binding */ matchesSomeScheme),
/* harmony export */   nodeModulesAsarPath: () => (/* binding */ nodeModulesAsarPath),
/* harmony export */   nodeModulesAsarUnpackedPath: () => (/* binding */ nodeModulesAsarUnpackedPath),
/* harmony export */   nodeModulesPath: () => (/* binding */ nodeModulesPath)
/* harmony export */ });
/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _lifecycle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./map.js */ "./node_modules/vscode/vscode/src/vs/base/common/map.js");
/* harmony import */ var _platform_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _uri_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./path.js */ "./node_modules/vscode/vscode/src/vs/base/common/path.js");







var Schemas;
( (function(Schemas) {
    Schemas.inMemory = 'inmemory';
    Schemas.vscode = 'vscode';
    Schemas.internal = 'private';
    Schemas.walkThrough = 'walkThrough';
    Schemas.walkThroughSnippet = 'walkThroughSnippet';
    Schemas.http = 'http';
    Schemas.https = 'https';
    Schemas.file = 'file';
    Schemas.mailto = 'mailto';
    Schemas.untitled = 'untitled';
    Schemas.data = 'data';
    Schemas.command = 'command';
    Schemas.vscodeRemote = 'vscode-remote';
    Schemas.vscodeRemoteResource = 'vscode-remote-resource';
    Schemas.vscodeManagedRemoteResource = 'vscode-managed-remote-resource';
    Schemas.vscodeUserData = 'vscode-userdata';
    Schemas.vscodeCustomEditor = 'vscode-custom-editor';
    Schemas.vscodeNotebookCell = 'vscode-notebook-cell';
    Schemas.vscodeNotebookCellMetadata = 'vscode-notebook-cell-metadata';
    Schemas.vscodeNotebookCellOutput = 'vscode-notebook-cell-output';
    Schemas.vscodeInteractiveInput = 'vscode-interactive-input';
    Schemas.vscodeSettings = 'vscode-settings';
    Schemas.vscodeWorkspaceTrust = 'vscode-workspace-trust';
    Schemas.vscodeTerminal = 'vscode-terminal';
    Schemas.vscodeChatCodeBlock = 'vscode-chat-code-block';
    Schemas.vscodeCopilotBackingChatCodeBlock = 'vscode-copilot-chat-code-block';
    Schemas.vscodeChatCodeCompareBlock = 'vscode-chat-code-compare-block';
    Schemas.vscodeChatSesssion = 'vscode-chat-editor';
    Schemas.webviewPanel = 'webview-panel';
    Schemas.vscodeWebview = 'vscode-webview';
    Schemas.extension = 'extension';
    Schemas.vscodeFileResource = 'vscode-file';
    Schemas.tmp = 'tmp';
    Schemas.vsls = 'vsls';
    Schemas.vscodeSourceControl = 'vscode-scm';
    Schemas.commentsInput = 'comment';
    Schemas.codeSetting = 'code-setting';
})(Schemas || (Schemas = {})));
function matchesScheme(target, scheme) {
    if (_uri_js__WEBPACK_IMPORTED_MODULE_5__.URI.isUri(target)) {
        return (0,_strings_js__WEBPACK_IMPORTED_MODULE_4__.equalsIgnoreCase)(target.scheme, scheme);
    }
    else {
        return (0,_strings_js__WEBPACK_IMPORTED_MODULE_4__.startsWithIgnoreCase)(target, scheme + ':');
    }
}
function matchesSomeScheme(target, ...schemes) {
    return ( schemes.some(scheme => matchesScheme(target, scheme)));
}
const connectionTokenQueryName = 'tkn';
class RemoteAuthoritiesImpl {
    constructor() {
        this._hosts = Object.create(null);
        this._ports = Object.create(null);
        this._connectionTokens = Object.create(null);
        this._preferredWebSchema = 'http';
        this._delegate = null;
        this._serverRootPath = '/';
    }
    setPreferredWebSchema(schema) {
        this._preferredWebSchema = schema;
    }
    setDelegate(delegate) {
        this._delegate = delegate;
    }
    setServerRootPath(product, serverBasePath) {
        this._serverRootPath = getServerRootPath(product, serverBasePath);
    }
    getServerRootPath() {
        return this._serverRootPath;
    }
    get _remoteResourcesPath() {
        return _path_js__WEBPACK_IMPORTED_MODULE_6__.posix.join(this._serverRootPath, Schemas.vscodeRemoteResource);
    }
    set(authority, host, port) {
        this._hosts[authority] = host;
        this._ports[authority] = port;
    }
    setConnectionToken(authority, connectionToken) {
        this._connectionTokens[authority] = connectionToken;
    }
    getPreferredWebSchema() {
        return this._preferredWebSchema;
    }
    rewrite(uri) {
        if (this._delegate) {
            try {
                return this._delegate(uri);
            }
            catch (err) {
                (0,_errors_js__WEBPACK_IMPORTED_MODULE_0__.onUnexpectedError)(err);
                return uri;
            }
        }
        const authority = uri.authority;
        let host = this._hosts[authority];
        if (host && host.indexOf(':') !== -1 && host.indexOf('[') === -1) {
            host = `[${host}]`;
        }
        const port = this._ports[authority];
        const connectionToken = this._connectionTokens[authority];
        let query = `path=${encodeURIComponent(uri.path)}`;
        if (typeof connectionToken === 'string') {
            query += `&${connectionTokenQueryName}=${encodeURIComponent(connectionToken)}`;
        }
        return ( _uri_js__WEBPACK_IMPORTED_MODULE_5__.URI.from({
            scheme: _platform_js__WEBPACK_IMPORTED_MODULE_3__.isWeb ? this._preferredWebSchema : Schemas.vscodeRemoteResource,
            authority: `${host}:${port}`,
            path: this._remoteResourcesPath,
            query
        }));
    }
}
const RemoteAuthorities = ( new RemoteAuthoritiesImpl());
function getServerRootPath(product, basePath) {
    return _path_js__WEBPACK_IMPORTED_MODULE_6__.posix.join(basePath ?? '/', `${product.quality ?? 'oss'}-${product.commit ?? 'dev'}`);
}
const nodeModulesPath = 'vs/../../node_modules';
const nodeModulesAsarPath = 'vs/../../node_modules.asar';
const nodeModulesAsarUnpackedPath = 'vs/../../node_modules.asar.unpacked';
const VSCODE_AUTHORITY = 'vscode-app';
class FileAccessImpl {
    constructor() {
        this.staticBrowserUris = ( new _map_js__WEBPACK_IMPORTED_MODULE_2__.ResourceMap());
        this.appResourcePathUrls = ( new Map());
        this.moduleContentProvider = ( new Map());
    }
    static { this.FALLBACK_AUTHORITY = VSCODE_AUTHORITY; }
    registerModuleContentProvider(moduleId, contentLoader) {
        this.moduleContentProvider.set(moduleId, contentLoader);
    }
    toModuleContent(moduleId) {
        return this.moduleContentProvider.get(moduleId)();
    }
    registerAppResourcePathUrl(moduleId, url) {
        this.appResourcePathUrls.set(moduleId, url);
    }
    toUrl(moduleId) {
        let url = this.appResourcePathUrls.get(moduleId);
        if (typeof url === 'function') {
            url = url();
        }
        return ( ( new URL(url ?? moduleId, globalThis.location?.href ?? "file:///Users/mcaballero/Proyectos/intino-lowcode-platform/monaco/node_modules/vscode/vscode/src/vs/base/common/network.js")).toString());
    }
    asBrowserUri(resourcePath) {
        const uri = this.toUri(resourcePath, { toUrl: this.toUrl.bind(this) });
        return this.uriToBrowserUri(uri);
    }
    uriToBrowserUri(uri) {
        if (uri.scheme === Schemas.vscodeRemote) {
            return RemoteAuthorities.rewrite(uri);
        }
        if (
        uri.scheme === Schemas.file &&
            (
            (
            _platform_js__WEBPACK_IMPORTED_MODULE_3__.isNative || (_platform_js__WEBPACK_IMPORTED_MODULE_3__.webWorkerOrigin === `${Schemas.vscodeFileResource}://${FileAccessImpl.FALLBACK_AUTHORITY}`)))) {
            return uri.with({
                scheme: Schemas.vscodeFileResource,
                authority: uri.authority || FileAccessImpl.FALLBACK_AUTHORITY,
                query: null,
                fragment: null
            });
        }
        return this.staticBrowserUris.get(uri) ?? uri;
    }
    asFileUri(resourcePath) {
        const uri = this.toUri(resourcePath, { toUrl: this.toUrl.bind(this) });
        return this.uriToFileUri(uri);
    }
    uriToFileUri(uri) {
        if (uri.scheme === Schemas.vscodeFileResource) {
            return uri.with({
                scheme: Schemas.file,
                authority: uri.authority !== FileAccessImpl.FALLBACK_AUTHORITY ? uri.authority : null,
                query: null,
                fragment: null
            });
        }
        return uri;
    }
    toUri(uriOrModule, moduleIdToUrl) {
        if (_uri_js__WEBPACK_IMPORTED_MODULE_5__.URI.isUri(uriOrModule)) {
            return uriOrModule;
        }
        return ( _uri_js__WEBPACK_IMPORTED_MODULE_5__.URI.parse(moduleIdToUrl.toUrl(uriOrModule)));
    }
    registerStaticBrowserUri(uri, browserUri) {
        this.staticBrowserUris.set(uri, browserUri);
        return (0,_lifecycle_js__WEBPACK_IMPORTED_MODULE_1__.toDisposable)(() => {
            if (this.staticBrowserUris.get(uri) === browserUri) {
                this.staticBrowserUris.delete(uri);
            }
        });
    }
    getRegisteredBrowserUris() {
        return ( this.staticBrowserUris.keys());
    }
}
const FileAccess = ( new FileAccessImpl());
var COI;
( (function(COI) {
    const coiHeaders = ( new Map([
        ['1', { 'Cross-Origin-Opener-Policy': 'same-origin' }],
        ['2', { 'Cross-Origin-Embedder-Policy': 'require-corp' }],
        ['3', { 'Cross-Origin-Opener-Policy': 'same-origin', 'Cross-Origin-Embedder-Policy': 'require-corp' }],
    ]));
    COI.CoopAndCoep = ( Object.freeze(coiHeaders.get('3')));
    const coiSearchParamName = 'vscode-coi';
    function getHeadersFromQuery(url) {
        let params;
        if (typeof url === 'string') {
            params = ( new URL(url)).searchParams;
        }
        else if (url instanceof URL) {
            params = url.searchParams;
        }
        else if (_uri_js__WEBPACK_IMPORTED_MODULE_5__.URI.isUri(url)) {
            params = ( new URL(( url.toString(true)))).searchParams;
        }
        const value = params?.get(coiSearchParamName);
        if (!value) {
            return undefined;
        }
        return coiHeaders.get(value);
    }
    COI.getHeadersFromQuery = getHeadersFromQuery;
    function addSearchParam(urlOrSearch, coop, coep) {
        if (!globalThis.crossOriginIsolated) {
            return;
        }
        const value = coop && coep ? '3' : coep ? '2' : '1';
        if (urlOrSearch instanceof URLSearchParams) {
            urlOrSearch.set(coiSearchParamName, value);
        }
        else {
            urlOrSearch[coiSearchParamName] = value;
        }
    }
    COI.addSearchParam = addSearchParam;
})(COI || (COI = {})));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/numbers.js":
/*!******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/numbers.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Counter: () => (/* binding */ Counter),
/* harmony export */   MovingAverage: () => (/* binding */ MovingAverage),
/* harmony export */   SlidingWindowAverage: () => (/* binding */ SlidingWindowAverage),
/* harmony export */   clamp: () => (/* binding */ clamp),
/* harmony export */   isPointWithinTriangle: () => (/* binding */ isPointWithinTriangle),
/* harmony export */   rot: () => (/* binding */ rot)
/* harmony export */ });
function clamp(value, min, max) {
    return Math.min(Math.max(value, min), max);
}
function rot(index, modulo) {
    return (modulo + (index % modulo)) % modulo;
}
class Counter {
    constructor() {
        this._next = 0;
    }
    getNext() {
        return this._next++;
    }
}
class MovingAverage {
    constructor() {
        this._n = 1;
        this._val = 0;
    }
    update(value) {
        this._val = this._val + (value - this._val) / this._n;
        this._n += 1;
        return this._val;
    }
    get value() {
        return this._val;
    }
}
class SlidingWindowAverage {
    constructor(size) {
        this._n = 0;
        this._val = 0;
        this._values = [];
        this._index = 0;
        this._sum = 0;
        this._values = ( new Array(size));
        this._values.fill(0, 0, size);
    }
    update(value) {
        const oldValue = this._values[this._index];
        this._values[this._index] = value;
        this._index = (this._index + 1) % this._values.length;
        this._sum -= oldValue;
        this._sum += value;
        if (this._n < this._values.length) {
            this._n += 1;
        }
        this._val = this._sum / this._n;
        return this._val;
    }
    get value() {
        return this._val;
    }
}
function isPointWithinTriangle(x, y, ax, ay, bx, by, cx, cy) {
    const v0x = cx - ax;
    const v0y = cy - ay;
    const v1x = bx - ax;
    const v1y = by - ay;
    const v2x = x - ax;
    const v2y = y - ay;
    const dot00 = v0x * v0x + v0y * v0y;
    const dot01 = v0x * v1x + v0y * v1y;
    const dot02 = v0x * v2x + v0y * v2y;
    const dot11 = v1x * v1x + v1y * v1y;
    const dot12 = v1x * v2x + v1y * v2y;
    const invDenom = 1 / (dot00 * dot11 - dot01 * dot01);
    const u = (dot11 * dot02 - dot01 * dot12) * invDenom;
    const v = (dot00 * dot12 - dot01 * dot02) * invDenom;
    return u >= 0 && v >= 0 && u + v < 1;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/observableInternal/base.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/observableInternal/base.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseObservable: () => (/* binding */ BaseObservable),
/* harmony export */   ConvenientObservable: () => (/* binding */ ConvenientObservable),
/* harmony export */   DisposableObservableValue: () => (/* binding */ DisposableObservableValue),
/* harmony export */   ObservableValue: () => (/* binding */ ObservableValue),
/* harmony export */   TransactionImpl: () => (/* binding */ TransactionImpl),
/* harmony export */   _setDerivedOpts: () => (/* binding */ _setDerivedOpts),
/* harmony export */   _setKeepObserved: () => (/* binding */ _setKeepObserved),
/* harmony export */   _setRecomputeInitiallyAndOnChange: () => (/* binding */ _setRecomputeInitiallyAndOnChange),
/* harmony export */   asyncTransaction: () => (/* binding */ asyncTransaction),
/* harmony export */   disposableObservableValue: () => (/* binding */ disposableObservableValue),
/* harmony export */   globalTransaction: () => (/* binding */ globalTransaction),
/* harmony export */   observableValue: () => (/* binding */ observableValue),
/* harmony export */   subtransaction: () => (/* binding */ subtransaction),
/* harmony export */   transaction: () => (/* binding */ transaction)
/* harmony export */ });
/* harmony import */ var _equals_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../equals.js */ "./node_modules/vscode/vscode/src/vs/base/common/equals.js");
/* harmony import */ var _debugName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./debugName.js */ "./node_modules/vscode/vscode/src/vs/base/common/observableInternal/debugName.js");
/* harmony import */ var _logging_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./logging.js */ "./node_modules/vscode/vscode/src/vs/base/common/observableInternal/logging.js");



let _recomputeInitiallyAndOnChange;
function _setRecomputeInitiallyAndOnChange(recomputeInitiallyAndOnChange) {
    _recomputeInitiallyAndOnChange = recomputeInitiallyAndOnChange;
}
let _keepObserved;
function _setKeepObserved(keepObserved) {
    _keepObserved = keepObserved;
}
let _derived;
function _setDerivedOpts(derived) {
    _derived = derived;
}
class ConvenientObservable {
    get TChange() { return null; }
    reportChanges() {
        this.get();
    }
    read(reader) {
        if (reader) {
            return reader.readObservable(this);
        }
        else {
            return this.get();
        }
    }
    map(fnOrOwner, fnOrUndefined) {
        const owner = fnOrUndefined === undefined ? undefined : fnOrOwner;
        const fn = fnOrUndefined === undefined ? fnOrOwner : fnOrUndefined;
        return _derived({
            owner,
            debugName: () => {
                const name = (0,_debugName_js__WEBPACK_IMPORTED_MODULE_1__.getFunctionName)(fn);
                if (name !== undefined) {
                    return name;
                }
                const regexp = /^\s*\(?\s*([a-zA-Z_$][a-zA-Z_$0-9]*)\s*\)?\s*=>\s*\1(?:\??)\.([a-zA-Z_$][a-zA-Z_$0-9]*)\s*$/;
                const match = regexp.exec(( fn.toString()));
                if (match) {
                    return `${this.debugName}.${match[2]}`;
                }
                if (!owner) {
                    return `${this.debugName} (mapped)`;
                }
                return undefined;
            },
            debugReferenceFn: fn,
        }, (reader) => fn(this.read(reader), reader));
    }
    recomputeInitiallyAndOnChange(store, handleValue) {
        store.add(_recomputeInitiallyAndOnChange(this, handleValue));
        return this;
    }
    keepObserved(store) {
        store.add(_keepObserved(this));
        return this;
    }
    get debugValue() {
        return this.get();
    }
}
class BaseObservable extends ConvenientObservable {
    constructor() {
        super(...arguments);
        this.observers = ( new Set());
    }
    addObserver(observer) {
        const len = this.observers.size;
        this.observers.add(observer);
        if (len === 0) {
            this.onFirstObserverAdded();
        }
    }
    removeObserver(observer) {
        const deleted = this.observers.delete(observer);
        if (deleted && this.observers.size === 0) {
            this.onLastObserverRemoved();
        }
    }
    onFirstObserverAdded() { }
    onLastObserverRemoved() { }
}
function transaction(fn, getDebugName) {
    const tx = ( new TransactionImpl(fn, getDebugName));
    try {
        fn(tx);
    }
    finally {
        tx.finish();
    }
}
let _globalTransaction = undefined;
function globalTransaction(fn) {
    if (_globalTransaction) {
        fn(_globalTransaction);
    }
    else {
        const tx = ( new TransactionImpl(fn, undefined));
        _globalTransaction = tx;
        try {
            fn(tx);
        }
        finally {
            tx.finish();
            _globalTransaction = undefined;
        }
    }
}
async function asyncTransaction(fn, getDebugName) {
    const tx = ( new TransactionImpl(fn, getDebugName));
    try {
        await fn(tx);
    }
    finally {
        tx.finish();
    }
}
function subtransaction(tx, fn, getDebugName) {
    if (!tx) {
        transaction(fn, getDebugName);
    }
    else {
        fn(tx);
    }
}
class TransactionImpl {
    constructor(_fn, _getDebugName) {
        this._fn = _fn;
        this._getDebugName = _getDebugName;
        this.updatingObservers = [];
    }
    getDebugName() {
        if (this._getDebugName) {
            return this._getDebugName();
        }
        return (0,_debugName_js__WEBPACK_IMPORTED_MODULE_1__.getFunctionName)(this._fn);
    }
    updateObserver(observer, observable) {
        this.updatingObservers.push({ observer, observable });
        observer.beginUpdate(observable);
    }
    finish() {
        const updatingObservers = this.updatingObservers;
        for (let i = 0; i < updatingObservers.length; i++) {
            const { observer, observable } = updatingObservers[i];
            observer.endUpdate(observable);
        }
        this.updatingObservers = null;
    }
}
function observableValue(nameOrOwner, initialValue) {
    let debugNameData;
    if (typeof nameOrOwner === 'string') {
        debugNameData = ( new _debugName_js__WEBPACK_IMPORTED_MODULE_1__.DebugNameData(undefined, nameOrOwner, undefined));
    }
    else {
        debugNameData = ( new _debugName_js__WEBPACK_IMPORTED_MODULE_1__.DebugNameData(nameOrOwner, undefined, undefined));
    }
    return ( new ObservableValue(debugNameData, initialValue, _equals_js__WEBPACK_IMPORTED_MODULE_0__.strictEquals));
}
class ObservableValue extends BaseObservable {
    get debugName() {
        return this._debugNameData.getDebugName(this) ?? 'ObservableValue';
    }
    constructor(_debugNameData, initialValue, _equalityComparator) {
        super();
        this._debugNameData = _debugNameData;
        this._equalityComparator = _equalityComparator;
        this._value = initialValue;
    }
    get() {
        return this._value;
    }
    set(value, tx, change) {
        if (change === undefined && this._equalityComparator(this._value, value)) {
            return;
        }
        let _tx;
        if (!tx) {
            tx = _tx = ( new TransactionImpl(() => { }, () => `Setting ${this.debugName}`));
        }
        try {
            const oldValue = this._value;
            this._setValue(value);
            (0,_logging_js__WEBPACK_IMPORTED_MODULE_2__.getLogger)()?.handleObservableChanged(this, { oldValue, newValue: value, change, didChange: true, hadValue: true });
            for (const observer of this.observers) {
                tx.updateObserver(observer, this);
                observer.handleChange(this, change);
            }
        }
        finally {
            if (_tx) {
                _tx.finish();
            }
        }
    }
    toString() {
        return `${this.debugName}: ${this._value}`;
    }
    _setValue(newValue) {
        this._value = newValue;
    }
}
function disposableObservableValue(nameOrOwner, initialValue) {
    let debugNameData;
    if (typeof nameOrOwner === 'string') {
        debugNameData = ( new _debugName_js__WEBPACK_IMPORTED_MODULE_1__.DebugNameData(undefined, nameOrOwner, undefined));
    }
    else {
        debugNameData = ( new _debugName_js__WEBPACK_IMPORTED_MODULE_1__.DebugNameData(nameOrOwner, undefined, undefined));
    }
    return ( new DisposableObservableValue(debugNameData, initialValue, _equals_js__WEBPACK_IMPORTED_MODULE_0__.strictEquals));
}
class DisposableObservableValue extends ObservableValue {
    _setValue(newValue) {
        if (this._value === newValue) {
            return;
        }
        if (this._value) {
            this._value.dispose();
        }
        this._value = newValue;
    }
    dispose() {
        this._value?.dispose();
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/observableInternal/debugName.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/observableInternal/debugName.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DebugNameData: () => (/* binding */ DebugNameData),
/* harmony export */   getDebugName: () => (/* binding */ getDebugName),
/* harmony export */   getFunctionName: () => (/* binding */ getFunctionName)
/* harmony export */ });
class DebugNameData {
    constructor(owner, debugNameSource, referenceFn) {
        this.owner = owner;
        this.debugNameSource = debugNameSource;
        this.referenceFn = referenceFn;
    }
    getDebugName(target) {
        return getDebugName(target, this);
    }
}
const countPerName = ( new Map());
const cachedDebugName = ( new WeakMap());
function getDebugName(target, data) {
    const cached = cachedDebugName.get(target);
    if (cached) {
        return cached;
    }
    const dbgName = computeDebugName(target, data);
    if (dbgName) {
        let count = countPerName.get(dbgName) ?? 0;
        count++;
        countPerName.set(dbgName, count);
        const result = count === 1 ? dbgName : `${dbgName}#${count}`;
        cachedDebugName.set(target, result);
        return result;
    }
    return undefined;
}
function computeDebugName(self, data) {
    const cached = cachedDebugName.get(self);
    if (cached) {
        return cached;
    }
    const ownerStr = data.owner ? formatOwner(data.owner) + `.` : '';
    let result;
    const debugNameSource = data.debugNameSource;
    if (debugNameSource !== undefined) {
        if (typeof debugNameSource === 'function') {
            result = debugNameSource();
            if (result !== undefined) {
                return ownerStr + result;
            }
        }
        else {
            return ownerStr + debugNameSource;
        }
    }
    const referenceFn = data.referenceFn;
    if (referenceFn !== undefined) {
        result = getFunctionName(referenceFn);
        if (result !== undefined) {
            return ownerStr + result;
        }
    }
    if (data.owner !== undefined) {
        const key = findKey(data.owner, self);
        if (key !== undefined) {
            return ownerStr + key;
        }
    }
    return undefined;
}
function findKey(obj, value) {
    for (const key in obj) {
        if (obj[key] === value) {
            return key;
        }
    }
    return undefined;
}
const countPerClassName = ( new Map());
const ownerId = ( new WeakMap());
function formatOwner(owner) {
    const id = ownerId.get(owner);
    if (id) {
        return id;
    }
    const className = getClassName(owner);
    let count = countPerClassName.get(className) ?? 0;
    count++;
    countPerClassName.set(className, count);
    const result = count === 1 ? className : `${className}#${count}`;
    ownerId.set(owner, result);
    return result;
}
function getClassName(obj) {
    const ctor = obj.constructor;
    if (ctor) {
        return ctor.name;
    }
    return 'Object';
}
function getFunctionName(fn) {
    const fnSrc = ( fn.toString());
    const regexp = /\/\*\*\s*@description\s*([^*]*)\*\//;
    const match = regexp.exec(fnSrc);
    const result = match ? match[1] : undefined;
    return result?.trim();
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/observableInternal/logging.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/observableInternal/logging.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getLogger: () => (/* binding */ getLogger)
/* harmony export */ });
let globalObservableLogger;
function getLogger() {
    return globalObservableLogger;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/performance.js":
/*!**********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/performance.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getMarks: () => (/* binding */ getMarks),
/* harmony export */   mark: () => (/* binding */ mark)
/* harmony export */ });
const mark = (name) => {
	performance.mark(name);
};
const getMarks = () => {
	let timeOrigin = performance.timeOrigin;
	if (typeof timeOrigin !== 'number') {
		timeOrigin = performance.timing.navigationStart || performance.timing.redirectStart || performance.timing.fetchStart;
	}
	const result = [{ name: 'code/timeOrigin', startTime: Math.round(timeOrigin) }];
	for (const entry of performance.getEntriesByType('mark')) {
		result.push({
			name: entry.name,
			startTime: Math.round(timeOrigin + entry.startTime)
		});
	}
	return result;
};



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/prefixTree.js":
/*!*********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/prefixTree.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WellDefinedPrefixTree: () => (/* binding */ WellDefinedPrefixTree)
/* harmony export */ });
/* harmony import */ var _iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./iterator.js */ "./node_modules/vscode/vscode/src/vs/base/common/iterator.js");

const unset = Symbol('unset');
class WellDefinedPrefixTree {
    constructor() {
        this.root = ( new Node());
        this._size = 0;
    }
    get size() {
        return this._size;
    }
    get nodes() {
        return this.root.children?.values() || _iterator_js__WEBPACK_IMPORTED_MODULE_0__.Iterable.empty();
    }
    insert(key, value, onNode) {
        this.opNode(key, n => n._value = value, onNode);
    }
    mutate(key, mutate) {
        this.opNode(key, n => n._value = mutate(n._value === unset ? undefined : n._value));
    }
    mutatePath(key, mutate) {
        this.opNode(key, () => { }, n => mutate(n));
    }
    delete(key) {
        const path = this.getPathToKey(key);
        if (!path) {
            return;
        }
        let i = path.length - 1;
        const value = path[i].node._value;
        if (value === unset) {
            return;
        }
        this._size--;
        path[i].node._value = unset;
        for (; i > 0; i--) {
            const { node, part } = path[i];
            if (node.children?.size || node._value !== unset) {
                break;
            }
            path[i - 1].node.children.delete(part);
        }
        return value;
    }
    *deleteRecursive(key) {
        const path = this.getPathToKey(key);
        if (!path) {
            return;
        }
        const subtree = path[path.length - 1].node;
        for (let i = path.length - 1; i > 0; i--) {
            const parent = path[i - 1];
            parent.node.children.delete(path[i].part);
            if (parent.node.children.size > 0 || parent.node._value !== unset) {
                break;
            }
        }
        for (const node of bfsIterate(subtree)) {
            if (node._value !== unset) {
                this._size--;
                yield node._value;
            }
        }
    }
    find(key) {
        let node = this.root;
        for (const segment of key) {
            const next = node.children?.get(segment);
            if (!next) {
                return undefined;
            }
            node = next;
        }
        return node._value === unset ? undefined : node._value;
    }
    hasKeyOrParent(key) {
        let node = this.root;
        for (const segment of key) {
            const next = node.children?.get(segment);
            if (!next) {
                return false;
            }
            if (next._value !== unset) {
                return true;
            }
            node = next;
        }
        return false;
    }
    hasKeyOrChildren(key) {
        let node = this.root;
        for (const segment of key) {
            const next = node.children?.get(segment);
            if (!next) {
                return false;
            }
            node = next;
        }
        return true;
    }
    hasKey(key) {
        let node = this.root;
        for (const segment of key) {
            const next = node.children?.get(segment);
            if (!next) {
                return false;
            }
            node = next;
        }
        return node._value !== unset;
    }
    getPathToKey(key) {
        const path = [{ part: '', node: this.root }];
        let i = 0;
        for (const part of key) {
            const node = path[i].node.children?.get(part);
            if (!node) {
                return;
            }
            path.push({ part, node });
            i++;
        }
        return path;
    }
    opNode(key, fn, onDescend) {
        let node = this.root;
        for (const part of key) {
            if (!node.children) {
                const next = ( new Node());
                node.children = ( new Map([[part, next]]));
                node = next;
            }
            else if (!( node.children.has(part))) {
                const next = ( new Node());
                node.children.set(part, next);
                node = next;
            }
            else {
                node = node.children.get(part);
            }
            onDescend?.(node);
        }
        const sizeBefore = node._value === unset ? 0 : 1;
        fn(node);
        const sizeAfter = node._value === unset ? 0 : 1;
        this._size += sizeAfter - sizeBefore;
    }
    *values() {
        for (const { _value } of bfsIterate(this.root)) {
            if (_value !== unset) {
                yield _value;
            }
        }
    }
}
function* bfsIterate(root) {
    const stack = [root];
    while (stack.length > 0) {
        const node = stack.pop();
        yield node;
        if (node.children) {
            for (const child of ( node.children.values())) {
                stack.push(child);
            }
        }
    }
}
class Node {
    constructor() {
        this._value = unset;
    }
    get value() {
        return this._value === unset ? undefined : this._value;
    }
    set value(value) {
        this._value = value === undefined ? unset : value;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/resources.js":
/*!********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/resources.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DataUri: () => (/* binding */ DataUri),
/* harmony export */   ExtUri: () => (/* binding */ ExtUri),
/* harmony export */   addTrailingPathSeparator: () => (/* binding */ addTrailingPathSeparator),
/* harmony export */   basename: () => (/* binding */ basename),
/* harmony export */   basenameOrAuthority: () => (/* binding */ basenameOrAuthority),
/* harmony export */   dirname: () => (/* binding */ dirname),
/* harmony export */   distinctParents: () => (/* binding */ distinctParents),
/* harmony export */   extUri: () => (/* binding */ extUri),
/* harmony export */   extUriBiasedIgnorePathCase: () => (/* binding */ extUriBiasedIgnorePathCase),
/* harmony export */   extUriIgnorePathCase: () => (/* binding */ extUriIgnorePathCase),
/* harmony export */   extname: () => (/* binding */ extname),
/* harmony export */   hasTrailingPathSeparator: () => (/* binding */ hasTrailingPathSeparator),
/* harmony export */   isAbsolutePath: () => (/* binding */ isAbsolutePath),
/* harmony export */   isEqual: () => (/* binding */ isEqual),
/* harmony export */   isEqualAuthority: () => (/* binding */ isEqualAuthority),
/* harmony export */   isEqualOrParent: () => (/* binding */ isEqualOrParent),
/* harmony export */   joinPath: () => (/* binding */ joinPath),
/* harmony export */   normalizePath: () => (/* binding */ normalizePath),
/* harmony export */   originalFSPath: () => (/* binding */ originalFSPath),
/* harmony export */   relativePath: () => (/* binding */ relativePath),
/* harmony export */   removeTrailingPathSeparator: () => (/* binding */ removeTrailingPathSeparator),
/* harmony export */   resolvePath: () => (/* binding */ resolvePath),
/* harmony export */   toLocalResource: () => (/* binding */ toLocalResource)
/* harmony export */ });
/* harmony import */ var _charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _extpath_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./extpath.js */ "./node_modules/vscode/vscode/src/vs/base/common/extpath.js");
/* harmony import */ var _network_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./network.js */ "./node_modules/vscode/vscode/src/vs/base/common/network.js");
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./path.js */ "./node_modules/vscode/vscode/src/vs/base/common/path.js");
/* harmony import */ var _platform_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _uri_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");







function originalFSPath(uri) {
    return (0,_uri_js__WEBPACK_IMPORTED_MODULE_6__.uriToFsPath)(uri, true);
}
class ExtUri {
    constructor(_ignorePathCasing) {
        this._ignorePathCasing = _ignorePathCasing;
    }
    compare(uri1, uri2, ignoreFragment = false) {
        if (uri1 === uri2) {
            return 0;
        }
        return (0,_strings_js__WEBPACK_IMPORTED_MODULE_5__.compare)(this.getComparisonKey(uri1, ignoreFragment), this.getComparisonKey(uri2, ignoreFragment));
    }
    isEqual(uri1, uri2, ignoreFragment = false) {
        if (uri1 === uri2) {
            return true;
        }
        if (!uri1 || !uri2) {
            return false;
        }
        return this.getComparisonKey(uri1, ignoreFragment) === this.getComparisonKey(uri2, ignoreFragment);
    }
    getComparisonKey(uri, ignoreFragment = false) {
        return ( uri.with({
            path: this._ignorePathCasing(uri) ? uri.path.toLowerCase() : undefined,
            fragment: ignoreFragment ? null : undefined
        }).toString());
    }
    ignorePathCasing(uri) {
        return this._ignorePathCasing(uri);
    }
    isEqualOrParent(base, parentCandidate, ignoreFragment = false) {
        if (base.scheme === parentCandidate.scheme) {
            if (base.scheme === _network_js__WEBPACK_IMPORTED_MODULE_2__.Schemas.file) {
                return (0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.isEqualOrParent)(originalFSPath(base), originalFSPath(parentCandidate), this._ignorePathCasing(base)) && base.query === parentCandidate.query && (ignoreFragment || base.fragment === parentCandidate.fragment);
            }
            if (isEqualAuthority(base.authority, parentCandidate.authority)) {
                return (0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.isEqualOrParent)(base.path, parentCandidate.path, this._ignorePathCasing(base), '/') && base.query === parentCandidate.query && (ignoreFragment || base.fragment === parentCandidate.fragment);
            }
        }
        return false;
    }
    joinPath(resource, ...pathFragment) {
        return _uri_js__WEBPACK_IMPORTED_MODULE_6__.URI.joinPath(resource, ...pathFragment);
    }
    basenameOrAuthority(resource) {
        return basename(resource) || resource.authority;
    }
    basename(resource) {
        return _path_js__WEBPACK_IMPORTED_MODULE_3__.posix.basename(resource.path);
    }
    extname(resource) {
        return _path_js__WEBPACK_IMPORTED_MODULE_3__.posix.extname(resource.path);
    }
    dirname(resource) {
        if (resource.path.length === 0) {
            return resource;
        }
        let dirname;
        if (resource.scheme === _network_js__WEBPACK_IMPORTED_MODULE_2__.Schemas.file) {
            dirname = _uri_js__WEBPACK_IMPORTED_MODULE_6__.URI.file((0,_path_js__WEBPACK_IMPORTED_MODULE_3__.dirname)(originalFSPath(resource))).path;
        }
        else {
            dirname = _path_js__WEBPACK_IMPORTED_MODULE_3__.posix.dirname(resource.path);
            if (resource.authority && dirname.length && dirname.charCodeAt(0) !== _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Slash) {
                console.error(`dirname("${resource.toString})) resulted in a relative path`);
                dirname = '/';
            }
        }
        return resource.with({
            path: dirname
        });
    }
    normalizePath(resource) {
        if (!resource.path.length) {
            return resource;
        }
        let normalizedPath;
        if (resource.scheme === _network_js__WEBPACK_IMPORTED_MODULE_2__.Schemas.file) {
            normalizedPath = _uri_js__WEBPACK_IMPORTED_MODULE_6__.URI.file((0,_path_js__WEBPACK_IMPORTED_MODULE_3__.normalize)(originalFSPath(resource))).path;
        }
        else {
            normalizedPath = _path_js__WEBPACK_IMPORTED_MODULE_3__.posix.normalize(resource.path);
        }
        return resource.with({
            path: normalizedPath
        });
    }
    relativePath(from, to) {
        if (from.scheme !== to.scheme || !isEqualAuthority(from.authority, to.authority)) {
            return undefined;
        }
        if (from.scheme === _network_js__WEBPACK_IMPORTED_MODULE_2__.Schemas.file) {
            const relativePath = (0,_path_js__WEBPACK_IMPORTED_MODULE_3__.relative)(originalFSPath(from), originalFSPath(to));
            return _platform_js__WEBPACK_IMPORTED_MODULE_4__.isWindows ? (0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.toSlashes)(relativePath) : relativePath;
        }
        let fromPath = from.path || '/';
        const toPath = to.path || '/';
        if (this._ignorePathCasing(from)) {
            let i = 0;
            for (const len = Math.min(fromPath.length, toPath.length); i < len; i++) {
                if (fromPath.charCodeAt(i) !== toPath.charCodeAt(i)) {
                    if (fromPath.charAt(i).toLowerCase() !== toPath.charAt(i).toLowerCase()) {
                        break;
                    }
                }
            }
            fromPath = toPath.substr(0, i) + fromPath.substr(i);
        }
        return _path_js__WEBPACK_IMPORTED_MODULE_3__.posix.relative(fromPath, toPath);
    }
    resolvePath(base, path) {
        if (base.scheme === _network_js__WEBPACK_IMPORTED_MODULE_2__.Schemas.file) {
            const newURI = _uri_js__WEBPACK_IMPORTED_MODULE_6__.URI.file((0,_path_js__WEBPACK_IMPORTED_MODULE_3__.resolve)(originalFSPath(base), path));
            return base.with({
                authority: newURI.authority,
                path: newURI.path
            });
        }
        path = (0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.toPosixPath)(path);
        return base.with({
            path: _path_js__WEBPACK_IMPORTED_MODULE_3__.posix.resolve(base.path, path)
        });
    }
    isAbsolutePath(resource) {
        return !!resource.path && resource.path[0] === '/';
    }
    isEqualAuthority(a1, a2) {
        return a1 === a2 || (a1 !== undefined && a2 !== undefined && (0,_strings_js__WEBPACK_IMPORTED_MODULE_5__.equalsIgnoreCase)(a1, a2));
    }
    hasTrailingPathSeparator(resource, sep$1 = _path_js__WEBPACK_IMPORTED_MODULE_3__.sep) {
        if (resource.scheme === _network_js__WEBPACK_IMPORTED_MODULE_2__.Schemas.file) {
            const fsp = originalFSPath(resource);
            return fsp.length > (0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.getRoot)(fsp).length && fsp[fsp.length - 1] === sep$1;
        }
        else {
            const p = resource.path;
            return (p.length > 1 && p.charCodeAt(p.length - 1) === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Slash) && !(/^[a-zA-Z]:(\/$|\\$)/.test(resource.fsPath));
        }
    }
    removeTrailingPathSeparator(resource, sep$1 = _path_js__WEBPACK_IMPORTED_MODULE_3__.sep) {
        if (hasTrailingPathSeparator(resource, sep$1)) {
            return resource.with({ path: resource.path.substr(0, resource.path.length - 1) });
        }
        return resource;
    }
    addTrailingPathSeparator(resource, sep$1 = _path_js__WEBPACK_IMPORTED_MODULE_3__.sep) {
        let isRootSep = false;
        if (resource.scheme === _network_js__WEBPACK_IMPORTED_MODULE_2__.Schemas.file) {
            const fsp = originalFSPath(resource);
            isRootSep = ((fsp !== undefined) && (fsp.length === (0,_extpath_js__WEBPACK_IMPORTED_MODULE_1__.getRoot)(fsp).length) && (fsp[fsp.length - 1] === sep$1));
        }
        else {
            sep$1 = '/';
            const p = resource.path;
            isRootSep = p.length === 1 && p.charCodeAt(p.length - 1) === _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Slash;
        }
        if (!isRootSep && !hasTrailingPathSeparator(resource, sep$1)) {
            return resource.with({ path: resource.path + '/' });
        }
        return resource;
    }
}
const extUri = ( new ExtUri(() => false));
const extUriBiasedIgnorePathCase = ( new ExtUri(uri => {
    return uri.scheme === _network_js__WEBPACK_IMPORTED_MODULE_2__.Schemas.file ? !_platform_js__WEBPACK_IMPORTED_MODULE_4__.isLinux : true;
}));
const extUriIgnorePathCase = ( new ExtUri(_ => true));
const isEqual = extUri.isEqual.bind(extUri);
const isEqualOrParent = extUri.isEqualOrParent.bind(extUri);
extUri.getComparisonKey.bind(extUri);
const basenameOrAuthority = extUri.basenameOrAuthority.bind(extUri);
const basename = extUri.basename.bind(extUri);
const extname = extUri.extname.bind(extUri);
const dirname = extUri.dirname.bind(extUri);
const joinPath = extUri.joinPath.bind(extUri);
const normalizePath = extUri.normalizePath.bind(extUri);
const relativePath = extUri.relativePath.bind(extUri);
const resolvePath = extUri.resolvePath.bind(extUri);
const isAbsolutePath = extUri.isAbsolutePath.bind(extUri);
const isEqualAuthority = extUri.isEqualAuthority.bind(extUri);
const hasTrailingPathSeparator = extUri.hasTrailingPathSeparator.bind(extUri);
const removeTrailingPathSeparator = extUri.removeTrailingPathSeparator.bind(extUri);
const addTrailingPathSeparator = extUri.addTrailingPathSeparator.bind(extUri);
function distinctParents(items, resourceAccessor) {
    const distinctParents = [];
    for (let i = 0; i < items.length; i++) {
        const candidateResource = resourceAccessor(items[i]);
        if (( items.some((otherItem, index) => {
            if (index === i) {
                return false;
            }
            return isEqualOrParent(candidateResource, resourceAccessor(otherItem));
        }))) {
            continue;
        }
        distinctParents.push(items[i]);
    }
    return distinctParents;
}
var DataUri;
( (function(DataUri) {
    DataUri.META_DATA_LABEL = 'label';
    DataUri.META_DATA_DESCRIPTION = 'description';
    DataUri.META_DATA_SIZE = 'size';
    DataUri.META_DATA_MIME = 'mime';
    function parseMetaData(dataUri) {
        const metadata = ( new Map());
        const meta = dataUri.path.substring(dataUri.path.indexOf(';') + 1, dataUri.path.lastIndexOf(';'));
        meta.split(';').forEach(property => {
            const [key, value] = property.split(':');
            if (key && value) {
                metadata.set(key, value);
            }
        });
        const mime = dataUri.path.substring(0, dataUri.path.indexOf(';'));
        if (mime) {
            metadata.set(DataUri.META_DATA_MIME, mime);
        }
        return metadata;
    }
    DataUri.parseMetaData = parseMetaData;
})(DataUri || (DataUri = {})));
function toLocalResource(resource, authority, localScheme) {
    if (authority) {
        let path = resource.path;
        if (path && path[0] !== _path_js__WEBPACK_IMPORTED_MODULE_3__.posix.sep) {
            path = _path_js__WEBPACK_IMPORTED_MODULE_3__.posix.sep + path;
        }
        return resource.with({ scheme: localScheme, authority, path });
    }
    return resource.with({ scheme: localScheme });
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/scrollable.js":
/*!*********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/scrollable.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScrollState: () => (/* binding */ ScrollState),
/* harmony export */   Scrollable: () => (/* binding */ Scrollable),
/* harmony export */   ScrollbarVisibility: () => (/* binding */ ScrollbarVisibility),
/* harmony export */   SmoothScrollingOperation: () => (/* binding */ SmoothScrollingOperation),
/* harmony export */   SmoothScrollingUpdate: () => (/* binding */ SmoothScrollingUpdate)
/* harmony export */ });
/* harmony import */ var _event_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _lifecycle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");


var ScrollbarVisibility;
( (function(ScrollbarVisibility) {
    ScrollbarVisibility[ScrollbarVisibility["Auto"] = 1] = "Auto";
    ScrollbarVisibility[ScrollbarVisibility["Hidden"] = 2] = "Hidden";
    ScrollbarVisibility[ScrollbarVisibility["Visible"] = 3] = "Visible";
})(ScrollbarVisibility || (ScrollbarVisibility = {})));
class ScrollState {
    constructor(_forceIntegerValues, width, scrollWidth, scrollLeft, height, scrollHeight, scrollTop) {
        this._forceIntegerValues = _forceIntegerValues;
        this._scrollStateBrand = undefined;
        if (this._forceIntegerValues) {
            width = width | 0;
            scrollWidth = scrollWidth | 0;
            scrollLeft = scrollLeft | 0;
            height = height | 0;
            scrollHeight = scrollHeight | 0;
            scrollTop = scrollTop | 0;
        }
        this.rawScrollLeft = scrollLeft;
        this.rawScrollTop = scrollTop;
        if (width < 0) {
            width = 0;
        }
        if (scrollLeft + width > scrollWidth) {
            scrollLeft = scrollWidth - width;
        }
        if (scrollLeft < 0) {
            scrollLeft = 0;
        }
        if (height < 0) {
            height = 0;
        }
        if (scrollTop + height > scrollHeight) {
            scrollTop = scrollHeight - height;
        }
        if (scrollTop < 0) {
            scrollTop = 0;
        }
        this.width = width;
        this.scrollWidth = scrollWidth;
        this.scrollLeft = scrollLeft;
        this.height = height;
        this.scrollHeight = scrollHeight;
        this.scrollTop = scrollTop;
    }
    equals(other) {
        return (this.rawScrollLeft === other.rawScrollLeft
            && this.rawScrollTop === other.rawScrollTop
            && this.width === other.width
            && this.scrollWidth === other.scrollWidth
            && this.scrollLeft === other.scrollLeft
            && this.height === other.height
            && this.scrollHeight === other.scrollHeight
            && this.scrollTop === other.scrollTop);
    }
    withScrollDimensions(update, useRawScrollPositions) {
        return ( new ScrollState(
            this._forceIntegerValues,
            (typeof update.width !== 'undefined' ? update.width : this.width),
            (typeof update.scrollWidth !== 'undefined' ? update.scrollWidth : this.scrollWidth),
            useRawScrollPositions ? this.rawScrollLeft : this.scrollLeft,
            (typeof update.height !== 'undefined' ? update.height : this.height),
            (typeof update.scrollHeight !== 'undefined' ? update.scrollHeight : this.scrollHeight),
            useRawScrollPositions ? this.rawScrollTop : this.scrollTop
        ));
    }
    withScrollPosition(update) {
        return ( new ScrollState(
            this._forceIntegerValues,
            this.width,
            this.scrollWidth,
            (typeof update.scrollLeft !== 'undefined' ? update.scrollLeft : this.rawScrollLeft),
            this.height,
            this.scrollHeight,
            (typeof update.scrollTop !== 'undefined' ? update.scrollTop : this.rawScrollTop)
        ));
    }
    createScrollEvent(previous, inSmoothScrolling) {
        const widthChanged = (this.width !== previous.width);
        const scrollWidthChanged = (this.scrollWidth !== previous.scrollWidth);
        const scrollLeftChanged = (this.scrollLeft !== previous.scrollLeft);
        const heightChanged = (this.height !== previous.height);
        const scrollHeightChanged = (this.scrollHeight !== previous.scrollHeight);
        const scrollTopChanged = (this.scrollTop !== previous.scrollTop);
        return {
            inSmoothScrolling: inSmoothScrolling,
            oldWidth: previous.width,
            oldScrollWidth: previous.scrollWidth,
            oldScrollLeft: previous.scrollLeft,
            width: this.width,
            scrollWidth: this.scrollWidth,
            scrollLeft: this.scrollLeft,
            oldHeight: previous.height,
            oldScrollHeight: previous.scrollHeight,
            oldScrollTop: previous.scrollTop,
            height: this.height,
            scrollHeight: this.scrollHeight,
            scrollTop: this.scrollTop,
            widthChanged: widthChanged,
            scrollWidthChanged: scrollWidthChanged,
            scrollLeftChanged: scrollLeftChanged,
            heightChanged: heightChanged,
            scrollHeightChanged: scrollHeightChanged,
            scrollTopChanged: scrollTopChanged,
        };
    }
}
class Scrollable extends _lifecycle_js__WEBPACK_IMPORTED_MODULE_1__.Disposable {
    constructor(options) {
        super();
        this._scrollableBrand = undefined;
        this._onScroll = this._register(( new _event_js__WEBPACK_IMPORTED_MODULE_0__.Emitter()));
        this.onScroll = this._onScroll.event;
        this._smoothScrollDuration = options.smoothScrollDuration;
        this._scheduleAtNextAnimationFrame = options.scheduleAtNextAnimationFrame;
        this._state = ( new ScrollState(options.forceIntegerValues, 0, 0, 0, 0, 0, 0));
        this._smoothScrolling = null;
    }
    dispose() {
        if (this._smoothScrolling) {
            this._smoothScrolling.dispose();
            this._smoothScrolling = null;
        }
        super.dispose();
    }
    setSmoothScrollDuration(smoothScrollDuration) {
        this._smoothScrollDuration = smoothScrollDuration;
    }
    validateScrollPosition(scrollPosition) {
        return this._state.withScrollPosition(scrollPosition);
    }
    getScrollDimensions() {
        return this._state;
    }
    setScrollDimensions(dimensions, useRawScrollPositions) {
        const newState = this._state.withScrollDimensions(dimensions, useRawScrollPositions);
        this._setState(newState, Boolean(this._smoothScrolling));
        this._smoothScrolling?.acceptScrollDimensions(this._state);
    }
    getFutureScrollPosition() {
        if (this._smoothScrolling) {
            return this._smoothScrolling.to;
        }
        return this._state;
    }
    getCurrentScrollPosition() {
        return this._state;
    }
    setScrollPositionNow(update) {
        const newState = this._state.withScrollPosition(update);
        if (this._smoothScrolling) {
            this._smoothScrolling.dispose();
            this._smoothScrolling = null;
        }
        this._setState(newState, false);
    }
    setScrollPositionSmooth(update, reuseAnimation) {
        if (this._smoothScrollDuration === 0) {
            return this.setScrollPositionNow(update);
        }
        if (this._smoothScrolling) {
            update = {
                scrollLeft: (typeof update.scrollLeft === 'undefined' ? this._smoothScrolling.to.scrollLeft : update.scrollLeft),
                scrollTop: (typeof update.scrollTop === 'undefined' ? this._smoothScrolling.to.scrollTop : update.scrollTop)
            };
            const validTarget = this._state.withScrollPosition(update);
            if (this._smoothScrolling.to.scrollLeft === validTarget.scrollLeft && this._smoothScrolling.to.scrollTop === validTarget.scrollTop) {
                return;
            }
            let newSmoothScrolling;
            if (reuseAnimation) {
                newSmoothScrolling = ( new SmoothScrollingOperation(
                    this._smoothScrolling.from,
                    validTarget,
                    this._smoothScrolling.startTime,
                    this._smoothScrolling.duration
                ));
            }
            else {
                newSmoothScrolling = this._smoothScrolling.combine(this._state, validTarget, this._smoothScrollDuration);
            }
            this._smoothScrolling.dispose();
            this._smoothScrolling = newSmoothScrolling;
        }
        else {
            const validTarget = this._state.withScrollPosition(update);
            this._smoothScrolling = SmoothScrollingOperation.start(this._state, validTarget, this._smoothScrollDuration);
        }
        this._smoothScrolling.animationFrameDisposable = this._scheduleAtNextAnimationFrame(() => {
            if (!this._smoothScrolling) {
                return;
            }
            this._smoothScrolling.animationFrameDisposable = null;
            this._performSmoothScrolling();
        });
    }
    hasPendingScrollAnimation() {
        return Boolean(this._smoothScrolling);
    }
    _performSmoothScrolling() {
        if (!this._smoothScrolling) {
            return;
        }
        const update = this._smoothScrolling.tick();
        const newState = this._state.withScrollPosition(update);
        this._setState(newState, true);
        if (!this._smoothScrolling) {
            return;
        }
        if (update.isDone) {
            this._smoothScrolling.dispose();
            this._smoothScrolling = null;
            return;
        }
        this._smoothScrolling.animationFrameDisposable = this._scheduleAtNextAnimationFrame(() => {
            if (!this._smoothScrolling) {
                return;
            }
            this._smoothScrolling.animationFrameDisposable = null;
            this._performSmoothScrolling();
        });
    }
    _setState(newState, inSmoothScrolling) {
        const oldState = this._state;
        if (oldState.equals(newState)) {
            return;
        }
        this._state = newState;
        this._onScroll.fire(this._state.createScrollEvent(oldState, inSmoothScrolling));
    }
}
class SmoothScrollingUpdate {
    constructor(scrollLeft, scrollTop, isDone) {
        this.scrollLeft = scrollLeft;
        this.scrollTop = scrollTop;
        this.isDone = isDone;
    }
}
function createEaseOutCubic(from, to) {
    const delta = to - from;
    return function (completion) {
        return from + delta * easeOutCubic(completion);
    };
}
function createComposed(a, b, cut) {
    return function (completion) {
        if (completion < cut) {
            return a(completion / cut);
        }
        return b((completion - cut) / (1 - cut));
    };
}
class SmoothScrollingOperation {
    constructor(from, to, startTime, duration) {
        this.from = from;
        this.to = to;
        this.duration = duration;
        this.startTime = startTime;
        this.animationFrameDisposable = null;
        this._initAnimations();
    }
    _initAnimations() {
        this.scrollLeft = this._initAnimation(this.from.scrollLeft, this.to.scrollLeft, this.to.width);
        this.scrollTop = this._initAnimation(this.from.scrollTop, this.to.scrollTop, this.to.height);
    }
    _initAnimation(from, to, viewportSize) {
        const delta = Math.abs(from - to);
        if (delta > 2.5 * viewportSize) {
            let stop1, stop2;
            if (from < to) {
                stop1 = from + 0.75 * viewportSize;
                stop2 = to - 0.75 * viewportSize;
            }
            else {
                stop1 = from - 0.75 * viewportSize;
                stop2 = to + 0.75 * viewportSize;
            }
            return createComposed(createEaseOutCubic(from, stop1), createEaseOutCubic(stop2, to), 0.33);
        }
        return createEaseOutCubic(from, to);
    }
    dispose() {
        if (this.animationFrameDisposable !== null) {
            this.animationFrameDisposable.dispose();
            this.animationFrameDisposable = null;
        }
    }
    acceptScrollDimensions(state) {
        this.to = state.withScrollPosition(this.to);
        this._initAnimations();
    }
    tick() {
        return this._tick(Date.now());
    }
    _tick(now) {
        const completion = (now - this.startTime) / this.duration;
        if (completion < 1) {
            const newScrollLeft = this.scrollLeft(completion);
            const newScrollTop = this.scrollTop(completion);
            return ( new SmoothScrollingUpdate(newScrollLeft, newScrollTop, false));
        }
        return ( new SmoothScrollingUpdate(this.to.scrollLeft, this.to.scrollTop, true));
    }
    combine(from, to, duration) {
        return SmoothScrollingOperation.start(from, to, duration);
    }
    static start(from, to, duration) {
        duration = duration + 10;
        const startTime = Date.now() - 10;
        return ( new SmoothScrollingOperation(from, to, startTime, duration));
    }
}
function easeInCubic(t) {
    return Math.pow(t, 3);
}
function easeOutCubic(t) {
    return 1 - easeInCubic(1 - t);
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/severity.js":
/*!*******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/severity.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Severity$1)
/* harmony export */ });
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");

var Severity;
( (function(Severity) {
    Severity[Severity["Ignore"] = 0] = "Ignore";
    Severity[Severity["Info"] = 1] = "Info";
    Severity[Severity["Warning"] = 2] = "Warning";
    Severity[Severity["Error"] = 3] = "Error";
})(Severity || (Severity = {})));
( (function(Severity) {
    const _error = 'error';
    const _warning = 'warning';
    const _warn = 'warn';
    const _info = 'info';
    const _ignore = 'ignore';
    function fromValue(value) {
        if (!value) {
            return Severity.Ignore;
        }
        if ((0,_strings_js__WEBPACK_IMPORTED_MODULE_0__.equalsIgnoreCase)(_error, value)) {
            return Severity.Error;
        }
        if ((0,_strings_js__WEBPACK_IMPORTED_MODULE_0__.equalsIgnoreCase)(_warning, value) || (0,_strings_js__WEBPACK_IMPORTED_MODULE_0__.equalsIgnoreCase)(_warn, value)) {
            return Severity.Warning;
        }
        if ((0,_strings_js__WEBPACK_IMPORTED_MODULE_0__.equalsIgnoreCase)(_info, value)) {
            return Severity.Info;
        }
        return Severity.Ignore;
    }
    Severity.fromValue = fromValue;
    function toString(severity) {
        switch (severity) {
            case Severity.Error: return _error;
            case Severity.Warning: return _warning;
            case Severity.Info: return _info;
            default: return _ignore;
        }
    }
    Severity.toString = toString;
})(Severity || (Severity = {})));
var Severity$1 = Severity;



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/stream.js":
/*!*****************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/stream.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   consumeReadable: () => (/* binding */ consumeReadable),
/* harmony export */   consumeStream: () => (/* binding */ consumeStream),
/* harmony export */   emptyStream: () => (/* binding */ emptyStream),
/* harmony export */   isReadableBufferedStream: () => (/* binding */ isReadableBufferedStream),
/* harmony export */   isReadableStream: () => (/* binding */ isReadableStream),
/* harmony export */   listenStream: () => (/* binding */ listenStream),
/* harmony export */   newWriteableStream: () => (/* binding */ newWriteableStream),
/* harmony export */   peekReadable: () => (/* binding */ peekReadable),
/* harmony export */   peekStream: () => (/* binding */ peekStream),
/* harmony export */   prefixedReadable: () => (/* binding */ prefixedReadable),
/* harmony export */   prefixedStream: () => (/* binding */ prefixedStream),
/* harmony export */   toReadable: () => (/* binding */ toReadable),
/* harmony export */   toStream: () => (/* binding */ toStream),
/* harmony export */   transform: () => (/* binding */ transform)
/* harmony export */ });
/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _lifecycle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");


function isReadableStream(obj) {
    const candidate = obj;
    if (!candidate) {
        return false;
    }
    return [candidate.on, candidate.pause, candidate.resume, candidate.destroy].every(fn => typeof fn === 'function');
}
function isReadableBufferedStream(obj) {
    const candidate = obj;
    if (!candidate) {
        return false;
    }
    return isReadableStream(candidate.stream) && Array.isArray(candidate.buffer) && typeof candidate.ended === 'boolean';
}
function newWriteableStream(reducer, options) {
    return ( new WriteableStreamImpl(reducer, options));
}
class WriteableStreamImpl {
    constructor(reducer, options) {
        this.reducer = reducer;
        this.options = options;
        this.state = {
            flowing: false,
            ended: false,
            destroyed: false
        };
        this.buffer = {
            data: [],
            error: []
        };
        this.listeners = {
            data: [],
            error: [],
            end: []
        };
        this.pendingWritePromises = [];
    }
    pause() {
        if (this.state.destroyed) {
            return;
        }
        this.state.flowing = false;
    }
    resume() {
        if (this.state.destroyed) {
            return;
        }
        if (!this.state.flowing) {
            this.state.flowing = true;
            this.flowData();
            this.flowErrors();
            this.flowEnd();
        }
    }
    write(data) {
        if (this.state.destroyed) {
            return;
        }
        if (this.state.flowing) {
            this.emitData(data);
        }
        else {
            this.buffer.data.push(data);
            if (typeof this.options?.highWaterMark === 'number' && this.buffer.data.length > this.options.highWaterMark) {
                return ( new Promise(resolve => this.pendingWritePromises.push(resolve)));
            }
        }
    }
    error(error) {
        if (this.state.destroyed) {
            return;
        }
        if (this.state.flowing) {
            this.emitError(error);
        }
        else {
            this.buffer.error.push(error);
        }
    }
    end(result) {
        if (this.state.destroyed) {
            return;
        }
        if (typeof result !== 'undefined') {
            this.write(result);
        }
        if (this.state.flowing) {
            this.emitEnd();
            this.destroy();
        }
        else {
            this.state.ended = true;
        }
    }
    emitData(data) {
        this.listeners.data.slice(0).forEach(listener => listener(data));
    }
    emitError(error) {
        if (this.listeners.error.length === 0) {
            (0,_errors_js__WEBPACK_IMPORTED_MODULE_0__.onUnexpectedError)(error);
        }
        else {
            this.listeners.error.slice(0).forEach(listener => listener(error));
        }
    }
    emitEnd() {
        this.listeners.end.slice(0).forEach(listener => listener());
    }
    on(event, callback) {
        if (this.state.destroyed) {
            return;
        }
        switch (event) {
            case 'data':
                this.listeners.data.push(callback);
                this.resume();
                break;
            case 'end':
                this.listeners.end.push(callback);
                if (this.state.flowing && this.flowEnd()) {
                    this.destroy();
                }
                break;
            case 'error':
                this.listeners.error.push(callback);
                if (this.state.flowing) {
                    this.flowErrors();
                }
                break;
        }
    }
    removeListener(event, callback) {
        if (this.state.destroyed) {
            return;
        }
        let listeners = undefined;
        switch (event) {
            case 'data':
                listeners = this.listeners.data;
                break;
            case 'end':
                listeners = this.listeners.end;
                break;
            case 'error':
                listeners = this.listeners.error;
                break;
        }
        if (listeners) {
            const index = listeners.indexOf(callback);
            if (index >= 0) {
                listeners.splice(index, 1);
            }
        }
    }
    flowData() {
        if (this.buffer.data.length > 0) {
            const fullDataBuffer = this.reducer(this.buffer.data);
            this.emitData(fullDataBuffer);
            this.buffer.data.length = 0;
            const pendingWritePromises = [...this.pendingWritePromises];
            this.pendingWritePromises.length = 0;
            pendingWritePromises.forEach(pendingWritePromise => pendingWritePromise());
        }
    }
    flowErrors() {
        if (this.listeners.error.length > 0) {
            for (const error of this.buffer.error) {
                this.emitError(error);
            }
            this.buffer.error.length = 0;
        }
    }
    flowEnd() {
        if (this.state.ended) {
            this.emitEnd();
            return this.listeners.end.length > 0;
        }
        return false;
    }
    destroy() {
        if (!this.state.destroyed) {
            this.state.destroyed = true;
            this.state.ended = true;
            this.buffer.data.length = 0;
            this.buffer.error.length = 0;
            this.listeners.data.length = 0;
            this.listeners.error.length = 0;
            this.listeners.end.length = 0;
            this.pendingWritePromises.length = 0;
        }
    }
}
function consumeReadable(readable, reducer) {
    const chunks = [];
    let chunk;
    while ((chunk = readable.read()) !== null) {
        chunks.push(chunk);
    }
    return reducer(chunks);
}
function peekReadable(readable, reducer, maxChunks) {
    const chunks = [];
    let chunk = undefined;
    while ((chunk = readable.read()) !== null && chunks.length < maxChunks) {
        chunks.push(chunk);
    }
    if (chunk === null && chunks.length > 0) {
        return reducer(chunks);
    }
    return {
        read: () => {
            if (chunks.length > 0) {
                return chunks.shift();
            }
            if (typeof chunk !== 'undefined') {
                const lastReadChunk = chunk;
                chunk = undefined;
                return lastReadChunk;
            }
            return readable.read();
        }
    };
}
function consumeStream(stream, reducer) {
    return ( new Promise((resolve, reject) => {
        const chunks = [];
        listenStream(stream, {
            onData: chunk => {
                if (reducer) {
                    chunks.push(chunk);
                }
            },
            onError: error => {
                if (reducer) {
                    reject(error);
                }
                else {
                    resolve(undefined);
                }
            },
            onEnd: () => {
                if (reducer) {
                    resolve(reducer(chunks));
                }
                else {
                    resolve(undefined);
                }
            }
        });
    }));
}
function listenStream(stream, listener, token) {
    stream.on('error', error => {
        if (!token?.isCancellationRequested) {
            listener.onError(error);
        }
    });
    stream.on('end', () => {
        if (!token?.isCancellationRequested) {
            listener.onEnd();
        }
    });
    stream.on('data', data => {
        if (!token?.isCancellationRequested) {
            listener.onData(data);
        }
    });
}
function peekStream(stream, maxChunks) {
    return ( new Promise((resolve, reject) => {
        const streamListeners = ( new _lifecycle_js__WEBPACK_IMPORTED_MODULE_1__.DisposableStore());
        const buffer = [];
        const dataListener = (chunk) => {
            buffer.push(chunk);
            if (buffer.length > maxChunks) {
                streamListeners.dispose();
                stream.pause();
                return resolve({ stream, buffer, ended: false });
            }
        };
        const errorListener = (error) => {
            streamListeners.dispose();
            return reject(error);
        };
        const endListener = () => {
            streamListeners.dispose();
            return resolve({ stream, buffer, ended: true });
        };
        streamListeners.add((0,_lifecycle_js__WEBPACK_IMPORTED_MODULE_1__.toDisposable)(() => stream.removeListener('error', errorListener)));
        stream.on('error', errorListener);
        streamListeners.add((0,_lifecycle_js__WEBPACK_IMPORTED_MODULE_1__.toDisposable)(() => stream.removeListener('end', endListener)));
        stream.on('end', endListener);
        streamListeners.add((0,_lifecycle_js__WEBPACK_IMPORTED_MODULE_1__.toDisposable)(() => stream.removeListener('data', dataListener)));
        stream.on('data', dataListener);
    }));
}
function toStream(t, reducer) {
    const stream = newWriteableStream(reducer);
    stream.end(t);
    return stream;
}
function emptyStream() {
    const stream = newWriteableStream(() => { throw ( new Error('not supported')); });
    stream.end();
    return stream;
}
function toReadable(t) {
    let consumed = false;
    return {
        read: () => {
            if (consumed) {
                return null;
            }
            consumed = true;
            return t;
        }
    };
}
function transform(stream, transformer, reducer) {
    const target = newWriteableStream(reducer);
    listenStream(stream, {
        onData: data => target.write(transformer.data(data)),
        onError: error => target.error(transformer.error ? transformer.error(error) : error),
        onEnd: () => target.end()
    });
    return target;
}
function prefixedReadable(prefix, readable, reducer) {
    let prefixHandled = false;
    return {
        read: () => {
            const chunk = readable.read();
            if (!prefixHandled) {
                prefixHandled = true;
                if (chunk !== null) {
                    return reducer([prefix, chunk]);
                }
                return prefix;
            }
            return chunk;
        }
    };
}
function prefixedStream(prefix, stream, reducer) {
    let prefixHandled = false;
    const target = newWriteableStream(reducer);
    listenStream(stream, {
        onData: data => {
            if (!prefixHandled) {
                prefixHandled = true;
                return target.write(reducer([prefix, data]));
            }
            return target.write(data);
        },
        onError: error => target.error(error),
        onEnd: () => {
            if (!prefixHandled) {
                prefixHandled = true;
                target.write(prefix);
            }
            target.end();
        }
    });
    return target;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/symbols.js":
/*!******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/symbols.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MicrotaskDelay: () => (/* binding */ MicrotaskDelay)
/* harmony export */ });
const MicrotaskDelay = Symbol('MicrotaskDelay');



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/ternarySearchTree.js":
/*!****************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/ternarySearchTree.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfigKeysIterator: () => (/* binding */ ConfigKeysIterator),
/* harmony export */   PathIterator: () => (/* binding */ PathIterator),
/* harmony export */   StringIterator: () => (/* binding */ StringIterator),
/* harmony export */   TernarySearchTree: () => (/* binding */ TernarySearchTree),
/* harmony export */   UriIterator: () => (/* binding */ UriIterator)
/* harmony export */ });
/* harmony import */ var _arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _charCode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");



class StringIterator {
    constructor() {
        this._value = '';
        this._pos = 0;
    }
    reset(key) {
        this._value = key;
        this._pos = 0;
        return this;
    }
    next() {
        this._pos += 1;
        return this;
    }
    hasNext() {
        return this._pos < this._value.length - 1;
    }
    cmp(a) {
        const aCode = a.charCodeAt(0);
        const thisCode = this._value.charCodeAt(this._pos);
        return aCode - thisCode;
    }
    value() {
        return this._value[this._pos];
    }
}
class ConfigKeysIterator {
    constructor(_caseSensitive = true) {
        this._caseSensitive = _caseSensitive;
    }
    reset(key) {
        this._value = key;
        this._from = 0;
        this._to = 0;
        return this.next();
    }
    hasNext() {
        return this._to < this._value.length;
    }
    next() {
        this._from = this._to;
        let justSeps = true;
        for (; this._to < this._value.length; this._to++) {
            const ch = this._value.charCodeAt(this._to);
            if (ch === _charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Period) {
                if (justSeps) {
                    this._from++;
                }
                else {
                    break;
                }
            }
            else {
                justSeps = false;
            }
        }
        return this;
    }
    cmp(a) {
        return this._caseSensitive
            ? (0,_strings_js__WEBPACK_IMPORTED_MODULE_2__.compareSubstring)(a, this._value, 0, a.length, this._from, this._to)
            : (0,_strings_js__WEBPACK_IMPORTED_MODULE_2__.compareSubstringIgnoreCase)(a, this._value, 0, a.length, this._from, this._to);
    }
    value() {
        return this._value.substring(this._from, this._to);
    }
}
class PathIterator {
    constructor(_splitOnBackslash = true, _caseSensitive = true) {
        this._splitOnBackslash = _splitOnBackslash;
        this._caseSensitive = _caseSensitive;
    }
    reset(key) {
        this._from = 0;
        this._to = 0;
        this._value = key;
        this._valueLen = key.length;
        for (let pos = key.length - 1; pos >= 0; pos--, this._valueLen--) {
            const ch = this._value.charCodeAt(pos);
            if (!(ch === _charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Slash || this._splitOnBackslash && ch === _charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Backslash)) {
                break;
            }
        }
        return this.next();
    }
    hasNext() {
        return this._to < this._valueLen;
    }
    next() {
        this._from = this._to;
        let justSeps = true;
        for (; this._to < this._valueLen; this._to++) {
            const ch = this._value.charCodeAt(this._to);
            if (ch === _charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Slash || this._splitOnBackslash && ch === _charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Backslash) {
                if (justSeps) {
                    this._from++;
                }
                else {
                    break;
                }
            }
            else {
                justSeps = false;
            }
        }
        return this;
    }
    cmp(a) {
        return this._caseSensitive
            ? (0,_strings_js__WEBPACK_IMPORTED_MODULE_2__.compareSubstring)(a, this._value, 0, a.length, this._from, this._to)
            : (0,_strings_js__WEBPACK_IMPORTED_MODULE_2__.compareSubstringIgnoreCase)(a, this._value, 0, a.length, this._from, this._to);
    }
    value() {
        return this._value.substring(this._from, this._to);
    }
}
var UriIteratorState;
( (function(UriIteratorState) {
    UriIteratorState[UriIteratorState["Scheme"] = 1] = "Scheme";
    UriIteratorState[UriIteratorState["Authority"] = 2] = "Authority";
    UriIteratorState[UriIteratorState["Path"] = 3] = "Path";
    UriIteratorState[UriIteratorState["Query"] = 4] = "Query";
    UriIteratorState[UriIteratorState["Fragment"] = 5] = "Fragment";
})(UriIteratorState || (UriIteratorState = {})));
class UriIterator {
    constructor(_ignorePathCasing, _ignoreQueryAndFragment) {
        this._ignorePathCasing = _ignorePathCasing;
        this._ignoreQueryAndFragment = _ignoreQueryAndFragment;
        this._states = [];
        this._stateIdx = 0;
    }
    reset(key) {
        this._value = key;
        this._states = [];
        if (this._value.scheme) {
            this._states.push(UriIteratorState.Scheme);
        }
        if (this._value.authority) {
            this._states.push(UriIteratorState.Authority);
        }
        if (this._value.path) {
            this._pathIterator = ( new PathIterator(false, !this._ignorePathCasing(key)));
            this._pathIterator.reset(key.path);
            if (this._pathIterator.value()) {
                this._states.push(UriIteratorState.Path);
            }
        }
        if (!this._ignoreQueryAndFragment(key)) {
            if (this._value.query) {
                this._states.push(UriIteratorState.Query);
            }
            if (this._value.fragment) {
                this._states.push(UriIteratorState.Fragment);
            }
        }
        this._stateIdx = 0;
        return this;
    }
    next() {
        if (this._states[this._stateIdx] === UriIteratorState.Path && this._pathIterator.hasNext()) {
            this._pathIterator.next();
        }
        else {
            this._stateIdx += 1;
        }
        return this;
    }
    hasNext() {
        return (this._states[this._stateIdx] === UriIteratorState.Path && this._pathIterator.hasNext())
            || this._stateIdx < this._states.length - 1;
    }
    cmp(a) {
        if (this._states[this._stateIdx] === UriIteratorState.Scheme) {
            return (0,_strings_js__WEBPACK_IMPORTED_MODULE_2__.compareIgnoreCase)(a, this._value.scheme);
        }
        else if (this._states[this._stateIdx] === UriIteratorState.Authority) {
            return (0,_strings_js__WEBPACK_IMPORTED_MODULE_2__.compareIgnoreCase)(a, this._value.authority);
        }
        else if (this._states[this._stateIdx] === UriIteratorState.Path) {
            return this._pathIterator.cmp(a);
        }
        else if (this._states[this._stateIdx] === UriIteratorState.Query) {
            return (0,_strings_js__WEBPACK_IMPORTED_MODULE_2__.compare)(a, this._value.query);
        }
        else if (this._states[this._stateIdx] === UriIteratorState.Fragment) {
            return (0,_strings_js__WEBPACK_IMPORTED_MODULE_2__.compare)(a, this._value.fragment);
        }
        throw ( new Error());
    }
    value() {
        if (this._states[this._stateIdx] === UriIteratorState.Scheme) {
            return this._value.scheme;
        }
        else if (this._states[this._stateIdx] === UriIteratorState.Authority) {
            return this._value.authority;
        }
        else if (this._states[this._stateIdx] === UriIteratorState.Path) {
            return this._pathIterator.value();
        }
        else if (this._states[this._stateIdx] === UriIteratorState.Query) {
            return this._value.query;
        }
        else if (this._states[this._stateIdx] === UriIteratorState.Fragment) {
            return this._value.fragment;
        }
        throw ( new Error());
    }
}
class TernarySearchTreeNode {
    constructor() {
        this.height = 1;
    }
    isEmpty() {
        return !this.left && !this.mid && !this.right && !this.value;
    }
    rotateLeft() {
        const tmp = this.right;
        this.right = tmp.left;
        tmp.left = this;
        this.updateHeight();
        tmp.updateHeight();
        return tmp;
    }
    rotateRight() {
        const tmp = this.left;
        this.left = tmp.right;
        tmp.right = this;
        this.updateHeight();
        tmp.updateHeight();
        return tmp;
    }
    updateHeight() {
        this.height = 1 + Math.max(this.heightLeft, this.heightRight);
    }
    balanceFactor() {
        return this.heightRight - this.heightLeft;
    }
    get heightLeft() {
        return this.left?.height ?? 0;
    }
    get heightRight() {
        return this.right?.height ?? 0;
    }
}
var Dir;
( (function(Dir) {
    Dir[Dir["Left"] = -1] = "Left";
    Dir[Dir["Mid"] = 0] = "Mid";
    Dir[Dir["Right"] = 1] = "Right";
})(Dir || (Dir = {})));
class TernarySearchTree {
    static forUris(ignorePathCasing = () => false, ignoreQueryAndFragment = () => false) {
        return ( new TernarySearchTree(( new UriIterator(ignorePathCasing, ignoreQueryAndFragment))));
    }
    static forPaths(ignorePathCasing = false) {
        return ( new TernarySearchTree(( new PathIterator(undefined, !ignorePathCasing))));
    }
    static forStrings() {
        return ( new TernarySearchTree(( new StringIterator())));
    }
    static forConfigKeys() {
        return ( new TernarySearchTree(( new ConfigKeysIterator())));
    }
    constructor(segments) {
        this._iter = segments;
    }
    clear() {
        this._root = undefined;
    }
    fill(values, keys) {
        if (keys) {
            const arr = keys.slice(0);
            (0,_arrays_js__WEBPACK_IMPORTED_MODULE_0__.shuffle)(arr);
            for (const k of arr) {
                this.set(k, values);
            }
        }
        else {
            const arr = values.slice(0);
            (0,_arrays_js__WEBPACK_IMPORTED_MODULE_0__.shuffle)(arr);
            for (const entry of arr) {
                this.set(entry[0], entry[1]);
            }
        }
    }
    set(key, element) {
        const iter = this._iter.reset(key);
        let node;
        if (!this._root) {
            this._root = ( new TernarySearchTreeNode());
            this._root.segment = iter.value();
        }
        const stack = [];
        node = this._root;
        while (true) {
            const val = iter.cmp(node.segment);
            if (val > 0) {
                if (!node.left) {
                    node.left = ( new TernarySearchTreeNode());
                    node.left.segment = iter.value();
                }
                stack.push([Dir.Left, node]);
                node = node.left;
            }
            else if (val < 0) {
                if (!node.right) {
                    node.right = ( new TernarySearchTreeNode());
                    node.right.segment = iter.value();
                }
                stack.push([Dir.Right, node]);
                node = node.right;
            }
            else if (iter.hasNext()) {
                iter.next();
                if (!node.mid) {
                    node.mid = ( new TernarySearchTreeNode());
                    node.mid.segment = iter.value();
                }
                stack.push([Dir.Mid, node]);
                node = node.mid;
            }
            else {
                break;
            }
        }
        const oldElement = node.value;
        node.value = element;
        node.key = key;
        for (let i = stack.length - 1; i >= 0; i--) {
            const node = stack[i][1];
            node.updateHeight();
            const bf = node.balanceFactor();
            if (bf < -1 || bf > 1) {
                const d1 = stack[i][0];
                const d2 = stack[i + 1][0];
                if (d1 === Dir.Right && d2 === Dir.Right) {
                    stack[i][1] = node.rotateLeft();
                }
                else if (d1 === Dir.Left && d2 === Dir.Left) {
                    stack[i][1] = node.rotateRight();
                }
                else if (d1 === Dir.Right && d2 === Dir.Left) {
                    node.right = stack[i + 1][1] = stack[i + 1][1].rotateRight();
                    stack[i][1] = node.rotateLeft();
                }
                else if (d1 === Dir.Left && d2 === Dir.Right) {
                    node.left = stack[i + 1][1] = stack[i + 1][1].rotateLeft();
                    stack[i][1] = node.rotateRight();
                }
                else {
                    throw ( new Error());
                }
                if (i > 0) {
                    switch (stack[i - 1][0]) {
                        case Dir.Left:
                            stack[i - 1][1].left = stack[i][1];
                            break;
                        case Dir.Right:
                            stack[i - 1][1].right = stack[i][1];
                            break;
                        case Dir.Mid:
                            stack[i - 1][1].mid = stack[i][1];
                            break;
                    }
                }
                else {
                    this._root = stack[0][1];
                }
            }
        }
        return oldElement;
    }
    get(key) {
        return this._getNode(key)?.value;
    }
    _getNode(key) {
        const iter = this._iter.reset(key);
        let node = this._root;
        while (node) {
            const val = iter.cmp(node.segment);
            if (val > 0) {
                node = node.left;
            }
            else if (val < 0) {
                node = node.right;
            }
            else if (iter.hasNext()) {
                iter.next();
                node = node.mid;
            }
            else {
                break;
            }
        }
        return node;
    }
    has(key) {
        const node = this._getNode(key);
        return !(node?.value === undefined && node?.mid === undefined);
    }
    delete(key) {
        return this._delete(key, false);
    }
    deleteSuperstr(key) {
        return this._delete(key, true);
    }
    _delete(key, superStr) {
        const iter = this._iter.reset(key);
        const stack = [];
        let node = this._root;
        while (node) {
            const val = iter.cmp(node.segment);
            if (val > 0) {
                stack.push([Dir.Left, node]);
                node = node.left;
            }
            else if (val < 0) {
                stack.push([Dir.Right, node]);
                node = node.right;
            }
            else if (iter.hasNext()) {
                iter.next();
                stack.push([Dir.Mid, node]);
                node = node.mid;
            }
            else {
                break;
            }
        }
        if (!node) {
            return;
        }
        if (superStr) {
            node.left = undefined;
            node.mid = undefined;
            node.right = undefined;
            node.height = 1;
        }
        else {
            node.key = undefined;
            node.value = undefined;
        }
        if (!node.mid && !node.value) {
            if (node.left && node.right) {
                const min = this._min(node.right);
                if (min.key) {
                    const { key, value, segment } = min;
                    this._delete(min.key, false);
                    node.key = key;
                    node.value = value;
                    node.segment = segment;
                }
            }
            else {
                const newChild = node.left ?? node.right;
                if (stack.length > 0) {
                    const [dir, parent] = stack[stack.length - 1];
                    switch (dir) {
                        case Dir.Left:
                            parent.left = newChild;
                            break;
                        case Dir.Mid:
                            parent.mid = newChild;
                            break;
                        case Dir.Right:
                            parent.right = newChild;
                            break;
                    }
                }
                else {
                    this._root = newChild;
                }
            }
        }
        for (let i = stack.length - 1; i >= 0; i--) {
            const node = stack[i][1];
            node.updateHeight();
            const bf = node.balanceFactor();
            if (bf > 1) {
                if (node.right.balanceFactor() >= 0) {
                    stack[i][1] = node.rotateLeft();
                }
                else {
                    node.right = node.right.rotateRight();
                    stack[i][1] = node.rotateLeft();
                }
            }
            else if (bf < -1) {
                if (node.left.balanceFactor() <= 0) {
                    stack[i][1] = node.rotateRight();
                }
                else {
                    node.left = node.left.rotateLeft();
                    stack[i][1] = node.rotateRight();
                }
            }
            if (i > 0) {
                switch (stack[i - 1][0]) {
                    case Dir.Left:
                        stack[i - 1][1].left = stack[i][1];
                        break;
                    case Dir.Right:
                        stack[i - 1][1].right = stack[i][1];
                        break;
                    case Dir.Mid:
                        stack[i - 1][1].mid = stack[i][1];
                        break;
                }
            }
            else {
                this._root = stack[0][1];
            }
        }
    }
    _min(node) {
        while (node.left) {
            node = node.left;
        }
        return node;
    }
    findSubstr(key) {
        const iter = this._iter.reset(key);
        let node = this._root;
        let candidate = undefined;
        while (node) {
            const val = iter.cmp(node.segment);
            if (val > 0) {
                node = node.left;
            }
            else if (val < 0) {
                node = node.right;
            }
            else if (iter.hasNext()) {
                iter.next();
                candidate = node.value || candidate;
                node = node.mid;
            }
            else {
                break;
            }
        }
        return node && node.value || candidate;
    }
    findSuperstr(key) {
        return this._findSuperstrOrElement(key, false);
    }
    _findSuperstrOrElement(key, allowValue) {
        const iter = this._iter.reset(key);
        let node = this._root;
        while (node) {
            const val = iter.cmp(node.segment);
            if (val > 0) {
                node = node.left;
            }
            else if (val < 0) {
                node = node.right;
            }
            else if (iter.hasNext()) {
                iter.next();
                node = node.mid;
            }
            else {
                if (!node.mid) {
                    if (allowValue) {
                        return node.value;
                    }
                    else {
                        return undefined;
                    }
                }
                else {
                    return this._entries(node.mid);
                }
            }
        }
        return undefined;
    }
    hasElementOrSubtree(key) {
        return this._findSuperstrOrElement(key, true) !== undefined;
    }
    forEach(callback) {
        for (const [key, value] of this) {
            callback(value, key);
        }
    }
    *[Symbol.iterator]() {
        yield* this._entries(this._root);
    }
    _entries(node) {
        const result = [];
        this._dfsEntries(node, result);
        return result[Symbol.iterator]();
    }
    _dfsEntries(node, bucket) {
        if (!node) {
            return;
        }
        if (node.left) {
            this._dfsEntries(node.left, bucket);
        }
        if (node.value) {
            bucket.push([node.key, node.value]);
        }
        if (node.mid) {
            this._dfsEntries(node.mid, bucket);
        }
        if (node.right) {
            this._dfsEntries(node.right, bucket);
        }
    }
    _isBalanced() {
        const nodeIsBalanced = (node) => {
            if (!node) {
                return true;
            }
            const bf = node.balanceFactor();
            if (bf < -1 || bf > 1) {
                return false;
            }
            return nodeIsBalanced(node.left) && nodeIsBalanced(node.right);
        };
        return nodeIsBalanced(this._root);
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/themables.js":
/*!********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/themables.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThemeColor: () => (/* binding */ ThemeColor),
/* harmony export */   ThemeIcon: () => (/* binding */ ThemeIcon),
/* harmony export */   themeColorFromId: () => (/* binding */ themeColorFromId)
/* harmony export */ });
/* harmony import */ var _codicons_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./codicons.js */ "./node_modules/vscode/vscode/src/vs/base/common/codicons.js");

var ThemeColor;
( (function(ThemeColor) {
    function isThemeColor(obj) {
        return obj && typeof obj === 'object' && typeof obj.id === 'string';
    }
    ThemeColor.isThemeColor = isThemeColor;
})(ThemeColor || (ThemeColor = {})));
function themeColorFromId(id) {
    return { id };
}
var ThemeIcon;
( (function(ThemeIcon) {
    ThemeIcon.iconNameSegment = '[A-Za-z0-9]+';
    ThemeIcon.iconNameExpression = '[A-Za-z0-9-]+';
    ThemeIcon.iconModifierExpression = '~[A-Za-z]+';
    ThemeIcon.iconNameCharacter = '[A-Za-z0-9~-]';
    const ThemeIconIdRegex = ( new RegExp(
        `^(${ThemeIcon.iconNameExpression})(${ThemeIcon.iconModifierExpression})?$`
    ));
    function asClassNameArray(icon) {
        const match = ThemeIconIdRegex.exec(icon.id);
        if (!match) {
            return asClassNameArray(_codicons_js__WEBPACK_IMPORTED_MODULE_0__.Codicon.error);
        }
        const [, id, modifier] = match;
        const classNames = ['codicon', 'codicon-' + id];
        if (modifier) {
            classNames.push('codicon-modifier-' + modifier.substring(1));
        }
        return classNames;
    }
    ThemeIcon.asClassNameArray = asClassNameArray;
    function asClassName(icon) {
        return asClassNameArray(icon).join(' ');
    }
    ThemeIcon.asClassName = asClassName;
    function asCSSSelector(icon) {
        return '.' + asClassNameArray(icon).join('.');
    }
    ThemeIcon.asCSSSelector = asCSSSelector;
    function isThemeIcon(obj) {
        return obj && typeof obj === 'object' && typeof obj.id === 'string' && (typeof obj.color === 'undefined' || ThemeColor.isThemeColor(obj.color));
    }
    ThemeIcon.isThemeIcon = isThemeIcon;
    const _regexFromString = ( new RegExp(
        `^\\$\\((${ThemeIcon.iconNameExpression}(?:${ThemeIcon.iconModifierExpression})?)\\)$`
    ));
    function fromString(str) {
        const match = _regexFromString.exec(str);
        if (!match) {
            return undefined;
        }
        const [, name] = match;
        return { id: name };
    }
    ThemeIcon.fromString = fromString;
    function fromId(id) {
        return { id };
    }
    ThemeIcon.fromId = fromId;
    function modify(icon, modifier) {
        let id = icon.id;
        const tildeIndex = id.lastIndexOf('~');
        if (tildeIndex !== -1) {
            id = id.substring(0, tildeIndex);
        }
        if (modifier) {
            id = `${id}~${modifier}`;
        }
        return { id };
    }
    ThemeIcon.modify = modify;
    function getModifier(icon) {
        const tildeIndex = icon.id.lastIndexOf('~');
        if (tildeIndex !== -1) {
            return icon.id.substring(tildeIndex + 1);
        }
        return undefined;
    }
    ThemeIcon.getModifier = getModifier;
    function isEqual(ti1, ti2) {
        return ti1.id === ti2.id && ti1.color?.id === ti2.color?.id;
    }
    ThemeIcon.isEqual = isEqual;
})(ThemeIcon || (ThemeIcon = {})));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/uriIpc.js":
/*!*****************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/uriIpc.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultURITransformer: () => (/* binding */ DefaultURITransformer),
/* harmony export */   transformAndReviveIncomingURIs: () => (/* binding */ transformAndReviveIncomingURIs),
/* harmony export */   transformIncomingURIs: () => (/* binding */ transformIncomingURIs)
/* harmony export */ });
/* harmony import */ var _buffer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./buffer.js */ "./node_modules/vscode/vscode/src/vs/base/common/buffer.js");
/* harmony import */ var _marshallingIds_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./marshallingIds.js */ "./node_modules/vscode/vscode/src/vs/base/common/marshallingIds.js");
/* harmony import */ var _uri_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");



const DefaultURITransformer = new class {
    transformIncoming(uri) {
        return uri;
    }
    transformOutgoing(uri) {
        return uri;
    }
    transformOutgoingURI(uri) {
        return uri;
    }
    transformOutgoingScheme(scheme) {
        return scheme;
    }
};
function _transformIncomingURIs(obj, transformer, revive, depth) {
    if (!obj || depth > 200) {
        return null;
    }
    if (typeof obj === 'object') {
        if (obj.$mid === _marshallingIds_js__WEBPACK_IMPORTED_MODULE_1__.MarshalledId.Uri) {
            return revive ? _uri_js__WEBPACK_IMPORTED_MODULE_2__.URI.revive(transformer.transformIncoming(obj)) : transformer.transformIncoming(obj);
        }
        if (obj instanceof _buffer_js__WEBPACK_IMPORTED_MODULE_0__.VSBuffer) {
            return null;
        }
        for (const key in obj) {
            if (Object.hasOwnProperty.call(obj, key)) {
                const r = _transformIncomingURIs(obj[key], transformer, revive, depth + 1);
                if (r !== null) {
                    obj[key] = r;
                }
            }
        }
    }
    return null;
}
function transformIncomingURIs(obj, transformer) {
    const result = _transformIncomingURIs(obj, transformer, false, 0);
    if (result === null) {
        return obj;
    }
    return result;
}
function transformAndReviveIncomingURIs(obj, transformer) {
    const result = _transformIncomingURIs(obj, transformer, true, 0);
    if (result === null) {
        return obj;
    }
    return result;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/uuid.js":
/*!***************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/uuid.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   generateUuid: () => (/* binding */ generateUuid),
/* harmony export */   isUUID: () => (/* binding */ isUUID)
/* harmony export */ });
const _UUIDPattern = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
function isUUID(value) {
    return _UUIDPattern.test(value);
}
const generateUuid = ( (function() {
    if (typeof crypto === 'object' && typeof crypto.randomUUID === 'function') {
        return crypto.randomUUID.bind(crypto);
    }
    let getRandomValues;
    if (typeof crypto === 'object' && typeof crypto.getRandomValues === 'function') {
        getRandomValues = crypto.getRandomValues.bind(crypto);
    }
    else {
        getRandomValues = function (bucket) {
            for (let i = 0; i < bucket.length; i++) {
                bucket[i] = Math.floor(Math.random() * 256);
            }
            return bucket;
        };
    }
    const _data = ( new Uint8Array(16));
    const _hex = [];
    for (let i = 0; i < 256; i++) {
        _hex.push(( i.toString(16)).padStart(2, '0'));
    }
    return function generateUuid() {
        getRandomValues(_data);
        _data[6] = (_data[6] & 0x0f) | 0x40;
        _data[8] = (_data[8] & 0x3f) | 0x80;
        let i = 0;
        let result = '';
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += '-';
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += '-';
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += '-';
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += '-';
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        return result;
    };
})());



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/parts/storage/common/storage.js":
/*!********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/parts/storage/common/storage.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InMemoryStorageDatabase: () => (/* binding */ InMemoryStorageDatabase),
/* harmony export */   Storage: () => (/* binding */ Storage),
/* harmony export */   StorageHint: () => (/* binding */ StorageHint),
/* harmony export */   StorageState: () => (/* binding */ StorageState),
/* harmony export */   isStorageItemsChangeEvent: () => (/* binding */ isStorageItemsChangeEvent)
/* harmony export */ });
/* harmony import */ var _common_async_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/async.js */ "./node_modules/vscode/vscode/src/vs/base/common/async.js");
/* harmony import */ var _common_event_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _common_lifecycle_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");
/* harmony import */ var _common_marshalling_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/marshalling.js */ "./node_modules/vscode/vscode/src/vs/base/common/marshalling.js");
/* harmony import */ var _common_types_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/types.js */ "./node_modules/vscode/vscode/src/vs/base/common/types.js");





var StorageHint;
( (function(StorageHint) {
    StorageHint[StorageHint["STORAGE_DOES_NOT_EXIST"] = 0] = "STORAGE_DOES_NOT_EXIST";
    StorageHint[StorageHint["STORAGE_IN_MEMORY"] = 1] = "STORAGE_IN_MEMORY";
})(StorageHint || (StorageHint = {})));
function isStorageItemsChangeEvent(thing) {
    const candidate = thing;
    return candidate?.changed instanceof Map || candidate?.deleted instanceof Set;
}
var StorageState;
( (function(StorageState) {
    StorageState[StorageState["None"] = 0] = "None";
    StorageState[StorageState["Initialized"] = 1] = "Initialized";
    StorageState[StorageState["Closed"] = 2] = "Closed";
})(StorageState || (StorageState = {})));
class Storage extends _common_lifecycle_js__WEBPACK_IMPORTED_MODULE_2__.Disposable {
    static { this.DEFAULT_FLUSH_DELAY = 100; }
    constructor(database, options = Object.create(null)) {
        super();
        this.database = database;
        this.options = options;
        this._onDidChangeStorage = this._register(( new _common_event_js__WEBPACK_IMPORTED_MODULE_1__.PauseableEmitter()));
        this.onDidChangeStorage = this._onDidChangeStorage.event;
        this.state = StorageState.None;
        this.cache = ( new Map());
        this.flushDelayer = this._register(( new _common_async_js__WEBPACK_IMPORTED_MODULE_0__.ThrottledDelayer(Storage.DEFAULT_FLUSH_DELAY)));
        this.pendingDeletes = ( new Set());
        this.pendingInserts = ( new Map());
        this.pendingClose = undefined;
        this.whenFlushedCallbacks = [];
        this.registerListeners();
    }
    registerListeners() {
        this._register(this.database.onDidChangeItemsExternal(e => this.onDidChangeItemsExternal(e)));
    }
    onDidChangeItemsExternal(e) {
        this._onDidChangeStorage.pause();
        try {
            e.changed?.forEach((value, key) => this.acceptExternal(key, value));
            e.deleted?.forEach(key => this.acceptExternal(key, undefined));
        }
        finally {
            this._onDidChangeStorage.resume();
        }
    }
    acceptExternal(key, value) {
        if (this.state === StorageState.Closed) {
            return;
        }
        let changed = false;
        if ((0,_common_types_js__WEBPACK_IMPORTED_MODULE_4__.isUndefinedOrNull)(value)) {
            changed = this.cache.delete(key);
        }
        else {
            const currentValue = this.cache.get(key);
            if (currentValue !== value) {
                this.cache.set(key, value);
                changed = true;
            }
        }
        if (changed) {
            this._onDidChangeStorage.fire({ key, external: true });
        }
    }
    get items() {
        return this.cache;
    }
    get size() {
        return this.cache.size;
    }
    async init() {
        if (this.state !== StorageState.None) {
            return;
        }
        this.state = StorageState.Initialized;
        if (this.options.hint === StorageHint.STORAGE_DOES_NOT_EXIST) {
            return;
        }
        this.cache = await this.database.getItems();
    }
    get(key, fallbackValue) {
        const value = this.cache.get(key);
        if ((0,_common_types_js__WEBPACK_IMPORTED_MODULE_4__.isUndefinedOrNull)(value)) {
            return fallbackValue;
        }
        return value;
    }
    getBoolean(key, fallbackValue) {
        const value = this.get(key);
        if ((0,_common_types_js__WEBPACK_IMPORTED_MODULE_4__.isUndefinedOrNull)(value)) {
            return fallbackValue;
        }
        return value === 'true';
    }
    getNumber(key, fallbackValue) {
        const value = this.get(key);
        if ((0,_common_types_js__WEBPACK_IMPORTED_MODULE_4__.isUndefinedOrNull)(value)) {
            return fallbackValue;
        }
        return parseInt(value, 10);
    }
    getObject(key, fallbackValue) {
        const value = this.get(key);
        if ((0,_common_types_js__WEBPACK_IMPORTED_MODULE_4__.isUndefinedOrNull)(value)) {
            return fallbackValue;
        }
        return (0,_common_marshalling_js__WEBPACK_IMPORTED_MODULE_3__.parse)(value);
    }
    async set(key, value, external = false) {
        if (this.state === StorageState.Closed) {
            return;
        }
        if ((0,_common_types_js__WEBPACK_IMPORTED_MODULE_4__.isUndefinedOrNull)(value)) {
            return this.delete(key, external);
        }
        const valueStr = (0,_common_types_js__WEBPACK_IMPORTED_MODULE_4__.isObject)(value) || Array.isArray(value) ? (0,_common_marshalling_js__WEBPACK_IMPORTED_MODULE_3__.stringify)(value) : String(value);
        const currentValue = this.cache.get(key);
        if (currentValue === valueStr) {
            return;
        }
        this.cache.set(key, valueStr);
        this.pendingInserts.set(key, valueStr);
        this.pendingDeletes.delete(key);
        this._onDidChangeStorage.fire({ key, external });
        return this.doFlush();
    }
    async delete(key, external = false) {
        if (this.state === StorageState.Closed) {
            return;
        }
        const wasDeleted = this.cache.delete(key);
        if (!wasDeleted) {
            return;
        }
        if (!( this.pendingDeletes.has(key))) {
            this.pendingDeletes.add(key);
        }
        this.pendingInserts.delete(key);
        this._onDidChangeStorage.fire({ key, external });
        return this.doFlush();
    }
    async optimize() {
        if (this.state === StorageState.Closed) {
            return;
        }
        await this.flush(0);
        return this.database.optimize();
    }
    async close() {
        if (!this.pendingClose) {
            this.pendingClose = this.doClose();
        }
        return this.pendingClose;
    }
    async doClose() {
        this.state = StorageState.Closed;
        try {
            await this.doFlush(0 );
        }
        catch (error) {
        }
        await this.database.close(() => this.cache);
    }
    get hasPending() {
        return this.pendingInserts.size > 0 || this.pendingDeletes.size > 0;
    }
    async flushPending() {
        if (!this.hasPending) {
            return;
        }
        const updateRequest = { insert: this.pendingInserts, delete: this.pendingDeletes };
        this.pendingDeletes = ( new Set());
        this.pendingInserts = ( new Map());
        return this.database.updateItems(updateRequest).finally(() => {
            if (!this.hasPending) {
                while (this.whenFlushedCallbacks.length) {
                    this.whenFlushedCallbacks.pop()?.();
                }
            }
        });
    }
    async flush(delay) {
        if (this.state === StorageState.Closed ||
            this.pendingClose
        ) {
            return;
        }
        return this.doFlush(delay);
    }
    async doFlush(delay) {
        if (this.options.hint === StorageHint.STORAGE_IN_MEMORY) {
            return this.flushPending();
        }
        return this.flushDelayer.trigger(() => this.flushPending(), delay);
    }
    async whenFlushed() {
        if (!this.hasPending) {
            return;
        }
        return ( new Promise(resolve => this.whenFlushedCallbacks.push(resolve)));
    }
    isInMemory() {
        return this.options.hint === StorageHint.STORAGE_IN_MEMORY;
    }
}
class InMemoryStorageDatabase {
    constructor() {
        this.onDidChangeItemsExternal = _common_event_js__WEBPACK_IMPORTED_MODULE_1__.Event.None;
        this.items = ( new Map());
    }
    async getItems() {
        return this.items;
    }
    async updateItems(request) {
        request.insert?.forEach((value, key) => this.items.set(key, value));
        request.delete?.forEach(key => this.items.delete(key));
    }
    async optimize() { }
    async close() { }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/config/editorOptions.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/config/editorOptions.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ApplyUpdateResult: () => (/* binding */ ApplyUpdateResult),
/* harmony export */   ComputeOptionsMemory: () => (/* binding */ ComputeOptionsMemory),
/* harmony export */   ConfigurationChangedEvent: () => (/* binding */ ConfigurationChangedEvent),
/* harmony export */   EDITOR_FONT_DEFAULTS: () => (/* binding */ EDITOR_FONT_DEFAULTS),
/* harmony export */   EditorAutoIndentStrategy: () => (/* binding */ EditorAutoIndentStrategy),
/* harmony export */   EditorFontLigatures: () => (/* binding */ EditorFontLigatures),
/* harmony export */   EditorFontVariations: () => (/* binding */ EditorFontVariations),
/* harmony export */   EditorLayoutInfoComputer: () => (/* binding */ EditorLayoutInfoComputer),
/* harmony export */   EditorOption: () => (/* binding */ EditorOption),
/* harmony export */   EditorOptions: () => (/* binding */ EditorOptions),
/* harmony export */   MINIMAP_GUTTER_WIDTH: () => (/* binding */ MINIMAP_GUTTER_WIDTH),
/* harmony export */   RenderLineNumbersType: () => (/* binding */ RenderLineNumbersType),
/* harmony export */   RenderMinimap: () => (/* binding */ RenderMinimap),
/* harmony export */   ShowLightbulbIconMode: () => (/* binding */ ShowLightbulbIconMode),
/* harmony export */   TextEditorCursorBlinkingStyle: () => (/* binding */ TextEditorCursorBlinkingStyle),
/* harmony export */   TextEditorCursorStyle: () => (/* binding */ TextEditorCursorStyle),
/* harmony export */   WrappingIndent: () => (/* binding */ WrappingIndent),
/* harmony export */   boolean: () => (/* binding */ boolean),
/* harmony export */   clampedFloat: () => (/* binding */ clampedFloat),
/* harmony export */   clampedInt: () => (/* binding */ clampedInt),
/* harmony export */   cursorStyleToString: () => (/* binding */ cursorStyleToString),
/* harmony export */   editorOptionsRegistry: () => (/* binding */ editorOptionsRegistry),
/* harmony export */   filterValidationDecorations: () => (/* binding */ filterValidationDecorations),
/* harmony export */   inUntrustedWorkspace: () => (/* binding */ inUntrustedWorkspace),
/* harmony export */   stringSet: () => (/* binding */ stringSet),
/* harmony export */   unicodeHighlightConfigKeys: () => (/* binding */ unicodeHighlightConfigKeys)
/* harmony export */ });
/* harmony import */ var _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _base_common_objects_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/objects.js */ "./node_modules/vscode/vscode/src/vs/base/common/objects.js");
/* harmony import */ var _base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../base/common/platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _base_common_scrollable_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../base/common/scrollable.js */ "./node_modules/vscode/vscode/src/vs/base/common/scrollable.js");
/* harmony import */ var _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../base/common/uint.js */ "./node_modules/vscode/vscode/src/vs/base/common/uint.js");
/* harmony import */ var _core_textModelDefaults_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/textModelDefaults.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/textModelDefaults.js");
/* harmony import */ var _core_wordHelper_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/wordHelper.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/wordHelper.js");
/* harmony import */ var _nls_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../nls.js */ "./node_modules/vscode/vscode/src/vs/nls.js");
/* harmony import */ var _platform_accessibility_common_accessibility_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../platform/accessibility/common/accessibility.js */ "./node_modules/vscode/vscode/src/vs/platform/accessibility/common/accessibility.js");









const _moduleId = "vs/editor/common/config/editorOptions";
var EditorAutoIndentStrategy;
( ((function(EditorAutoIndentStrategy) {
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["None"] = 0] = "None";
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["Keep"] = 1] = "Keep";
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["Brackets"] = 2] = "Brackets";
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["Advanced"] = 3] = "Advanced";
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["Full"] = 4] = "Full";
})(EditorAutoIndentStrategy || (EditorAutoIndentStrategy = {}))));
const MINIMAP_GUTTER_WIDTH = 8;
class ConfigurationChangedEvent {
    constructor(values) {
        this._values = values;
    }
    hasChanged(id) {
        return this._values[id];
    }
}
class ComputeOptionsMemory {
    constructor() {
        this.stableMinimapLayoutInput = null;
        this.stableFitMaxMinimapScale = 0;
        this.stableFitRemainingWidth = 0;
    }
}
class BaseEditorOption {
    constructor(id, name, defaultValue, schema) {
        this.id = id;
        this.name = name;
        this.defaultValue = defaultValue;
        this.schema = schema;
    }
    applyUpdate(value, update) {
        return applyUpdate(value, update);
    }
    compute(env, options, value) {
        return value;
    }
}
class ApplyUpdateResult {
    constructor(newValue, didChange) {
        this.newValue = newValue;
        this.didChange = didChange;
    }
}
function applyUpdate(value, update) {
    if (typeof value !== 'object' || typeof update !== 'object' || !value || !update) {
        return (
             (new ApplyUpdateResult(update, value !== update))
        );
    }
    if (Array.isArray(value) || Array.isArray(update)) {
        const arrayEquals = Array.isArray(value) && Array.isArray(update) && (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.equals)(value, update);
        return (
             (new ApplyUpdateResult(update, !arrayEquals))
        );
    }
    let didChange = false;
    for (const key in update) {
        if (update.hasOwnProperty(key)) {
            const result = applyUpdate(value[key], update[key]);
            if (result.didChange) {
                value[key] = result.newValue;
                didChange = true;
            }
        }
    }
    return (
         (new ApplyUpdateResult(value, didChange))
    );
}
class ComputedEditorOption {
    constructor(id) {
        this.schema = undefined;
        this.id = id;
        this.name = '_never_';
        this.defaultValue = undefined;
    }
    applyUpdate(value, update) {
        return applyUpdate(value, update);
    }
    validate(input) {
        return this.defaultValue;
    }
}
class SimpleEditorOption {
    constructor(id, name, defaultValue, schema) {
        this.id = id;
        this.name = name;
        this.defaultValue = defaultValue;
        this.schema = schema;
    }
    applyUpdate(value, update) {
        return applyUpdate(value, update);
    }
    validate(input) {
        if (typeof input === 'undefined') {
            return this.defaultValue;
        }
        return input;
    }
    compute(env, options, value) {
        return value;
    }
}
function boolean(value, defaultValue) {
    if (typeof value === 'undefined') {
        return defaultValue;
    }
    if (value === 'false') {
        return false;
    }
    return Boolean(value);
}
class EditorBooleanOption extends SimpleEditorOption {
    constructor(id, name, defaultValue, schema = undefined) {
        if (typeof schema !== 'undefined') {
            schema.type = 'boolean';
            schema.default = defaultValue;
        }
        super(id, name, defaultValue, schema);
    }
    validate(input) {
        return boolean(input, this.defaultValue);
    }
}
function clampedInt(value, defaultValue, minimum, maximum) {
    if (typeof value === 'undefined') {
        return defaultValue;
    }
    let r = parseInt(value, 10);
    if (isNaN(r)) {
        return defaultValue;
    }
    r = Math.max(minimum, r);
    r = Math.min(maximum, r);
    return r | 0;
}
class EditorIntOption extends SimpleEditorOption {
    static clampedInt(value, defaultValue, minimum, maximum) {
        return clampedInt(value, defaultValue, minimum, maximum);
    }
    constructor(id, name, defaultValue, minimum, maximum, schema = undefined) {
        if (typeof schema !== 'undefined') {
            schema.type = 'integer';
            schema.default = defaultValue;
            schema.minimum = minimum;
            schema.maximum = maximum;
        }
        super(id, name, defaultValue, schema);
        this.minimum = minimum;
        this.maximum = maximum;
    }
    validate(input) {
        return EditorIntOption.clampedInt(input, this.defaultValue, this.minimum, this.maximum);
    }
}
function clampedFloat(value, defaultValue, minimum, maximum) {
    if (typeof value === 'undefined') {
        return defaultValue;
    }
    const r = EditorFloatOption.float(value, defaultValue);
    return EditorFloatOption.clamp(r, minimum, maximum);
}
class EditorFloatOption extends SimpleEditorOption {
    static clamp(n, min, max) {
        if (n < min) {
            return min;
        }
        if (n > max) {
            return max;
        }
        return n;
    }
    static float(value, defaultValue) {
        if (typeof value === 'number') {
            return value;
        }
        if (typeof value === 'undefined') {
            return defaultValue;
        }
        const r = parseFloat(value);
        return (isNaN(r) ? defaultValue : r);
    }
    constructor(id, name, defaultValue, validationFn, schema) {
        if (typeof schema !== 'undefined') {
            schema.type = 'number';
            schema.default = defaultValue;
        }
        super(id, name, defaultValue, schema);
        this.validationFn = validationFn;
    }
    validate(input) {
        return this.validationFn(EditorFloatOption.float(input, this.defaultValue));
    }
}
class EditorStringOption extends SimpleEditorOption {
    static string(value, defaultValue) {
        if (typeof value !== 'string') {
            return defaultValue;
        }
        return value;
    }
    constructor(id, name, defaultValue, schema = undefined) {
        if (typeof schema !== 'undefined') {
            schema.type = 'string';
            schema.default = defaultValue;
        }
        super(id, name, defaultValue, schema);
    }
    validate(input) {
        return EditorStringOption.string(input, this.defaultValue);
    }
}
function stringSet(value, defaultValue, allowedValues, renamedValues) {
    if (typeof value !== 'string') {
        return defaultValue;
    }
    if (renamedValues && value in renamedValues) {
        return renamedValues[value];
    }
    if (allowedValues.indexOf(value) === -1) {
        return defaultValue;
    }
    return value;
}
class EditorStringEnumOption extends SimpleEditorOption {
    constructor(id, name, defaultValue, allowedValues, schema = undefined) {
        if (typeof schema !== 'undefined') {
            schema.type = 'string';
            schema.enum = allowedValues;
            schema.default = defaultValue;
        }
        super(id, name, defaultValue, schema);
        this._allowedValues = allowedValues;
    }
    validate(input) {
        return stringSet(input, this.defaultValue, this._allowedValues);
    }
}
class EditorEnumOption extends BaseEditorOption {
    constructor(id, name, defaultValue, defaultStringValue, allowedValues, convert, schema = undefined) {
        if (typeof schema !== 'undefined') {
            schema.type = 'string';
            schema.enum = allowedValues;
            schema.default = defaultStringValue;
        }
        super(id, name, defaultValue, schema);
        this._allowedValues = allowedValues;
        this._convert = convert;
    }
    validate(input) {
        if (typeof input !== 'string') {
            return this.defaultValue;
        }
        if (this._allowedValues.indexOf(input) === -1) {
            return this.defaultValue;
        }
        return this._convert(input);
    }
}
function _autoIndentFromString(autoIndent) {
    switch (autoIndent) {
        case 'none': return EditorAutoIndentStrategy.None;
        case 'keep': return EditorAutoIndentStrategy.Keep;
        case 'brackets': return EditorAutoIndentStrategy.Brackets;
        case 'advanced': return EditorAutoIndentStrategy.Advanced;
        case 'full': return EditorAutoIndentStrategy.Full;
    }
}
class EditorAccessibilitySupport extends BaseEditorOption {
    constructor() {
        super(EditorOption.accessibilitySupport, 'accessibilitySupport', _platform_accessibility_common_accessibility_js__WEBPACK_IMPORTED_MODULE_8__.AccessibilitySupport.Unknown, {
            type: 'string',
            enum: ['auto', 'on', 'off'],
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    0,
                    "Use platform APIs to detect when a Screen Reader is attached."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 1, "Optimize for usage with a Screen Reader.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 2, "Assume a screen reader is not attached.")),
            ],
            default: 'auto',
            tags: ['accessibility'],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                3,
                "Controls if the UI should run in a mode where it is optimized for screen readers."
            ))
        });
    }
    validate(input) {
        switch (input) {
            case 'auto': return _platform_accessibility_common_accessibility_js__WEBPACK_IMPORTED_MODULE_8__.AccessibilitySupport.Unknown;
            case 'off': return _platform_accessibility_common_accessibility_js__WEBPACK_IMPORTED_MODULE_8__.AccessibilitySupport.Disabled;
            case 'on': return _platform_accessibility_common_accessibility_js__WEBPACK_IMPORTED_MODULE_8__.AccessibilitySupport.Enabled;
        }
        return this.defaultValue;
    }
    compute(env, options, value) {
        if (value === _platform_accessibility_common_accessibility_js__WEBPACK_IMPORTED_MODULE_8__.AccessibilitySupport.Unknown) {
            return env.accessibilitySupport;
        }
        return value;
    }
}
class EditorComments extends BaseEditorOption {
    constructor() {
        const defaults = {
            insertSpace: true,
            ignoreEmptyLines: true,
        };
        super(EditorOption.comments, 'comments', defaults, {
            'editor.comments.insertSpace': {
                type: 'boolean',
                default: defaults.insertSpace,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    4,
                    "Controls whether a space character is inserted when commenting."
                ))
            },
            'editor.comments.ignoreEmptyLines': {
                type: 'boolean',
                default: defaults.ignoreEmptyLines,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    5,
                    'Controls if empty lines should be ignored with toggle, add or remove actions for line comments.'
                ))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            insertSpace: boolean(input.insertSpace, this.defaultValue.insertSpace),
            ignoreEmptyLines: boolean(input.ignoreEmptyLines, this.defaultValue.ignoreEmptyLines),
        };
    }
}
var TextEditorCursorBlinkingStyle;
( ((function(TextEditorCursorBlinkingStyle) {
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Hidden"] = 0] = "Hidden";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Blink"] = 1] = "Blink";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Smooth"] = 2] = "Smooth";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Phase"] = 3] = "Phase";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Expand"] = 4] = "Expand";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Solid"] = 5] = "Solid";
})(TextEditorCursorBlinkingStyle || (TextEditorCursorBlinkingStyle = {}))));
function _cursorBlinkingStyleFromString(cursorBlinkingStyle) {
    switch (cursorBlinkingStyle) {
        case 'blink': return TextEditorCursorBlinkingStyle.Blink;
        case 'smooth': return TextEditorCursorBlinkingStyle.Smooth;
        case 'phase': return TextEditorCursorBlinkingStyle.Phase;
        case 'expand': return TextEditorCursorBlinkingStyle.Expand;
        case 'solid': return TextEditorCursorBlinkingStyle.Solid;
    }
}
var TextEditorCursorStyle;
( ((function(TextEditorCursorStyle) {
    TextEditorCursorStyle[TextEditorCursorStyle["Line"] = 1] = "Line";
    TextEditorCursorStyle[TextEditorCursorStyle["Block"] = 2] = "Block";
    TextEditorCursorStyle[TextEditorCursorStyle["Underline"] = 3] = "Underline";
    TextEditorCursorStyle[TextEditorCursorStyle["LineThin"] = 4] = "LineThin";
    TextEditorCursorStyle[TextEditorCursorStyle["BlockOutline"] = 5] = "BlockOutline";
    TextEditorCursorStyle[TextEditorCursorStyle["UnderlineThin"] = 6] = "UnderlineThin";
})(TextEditorCursorStyle || (TextEditorCursorStyle = {}))));
function cursorStyleToString(cursorStyle) {
    switch (cursorStyle) {
        case TextEditorCursorStyle.Line: return 'line';
        case TextEditorCursorStyle.Block: return 'block';
        case TextEditorCursorStyle.Underline: return 'underline';
        case TextEditorCursorStyle.LineThin: return 'line-thin';
        case TextEditorCursorStyle.BlockOutline: return 'block-outline';
        case TextEditorCursorStyle.UnderlineThin: return 'underline-thin';
    }
}
function _cursorStyleFromString(cursorStyle) {
    switch (cursorStyle) {
        case 'line': return TextEditorCursorStyle.Line;
        case 'block': return TextEditorCursorStyle.Block;
        case 'underline': return TextEditorCursorStyle.Underline;
        case 'line-thin': return TextEditorCursorStyle.LineThin;
        case 'block-outline': return TextEditorCursorStyle.BlockOutline;
        case 'underline-thin': return TextEditorCursorStyle.UnderlineThin;
    }
}
class EditorClassName extends ComputedEditorOption {
    constructor() {
        super(EditorOption.editorClassName);
    }
    compute(env, options, _) {
        const classNames = ['monaco-editor'];
        if (options.get(EditorOption.extraEditorClassName)) {
            classNames.push(options.get(EditorOption.extraEditorClassName));
        }
        if (env.extraEditorClassName) {
            classNames.push(env.extraEditorClassName);
        }
        if (options.get(EditorOption.mouseStyle) === 'default') {
            classNames.push('mouse-default');
        }
        else if (options.get(EditorOption.mouseStyle) === 'copy') {
            classNames.push('mouse-copy');
        }
        if (options.get(EditorOption.showUnused)) {
            classNames.push('showUnused');
        }
        if (options.get(EditorOption.showDeprecated)) {
            classNames.push('showDeprecated');
        }
        return classNames.join(' ');
    }
}
class EditorEmptySelectionClipboard extends EditorBooleanOption {
    constructor() {
        super(EditorOption.emptySelectionClipboard, 'emptySelectionClipboard', true, { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            6,
            "Controls whether copying without a selection copies the current line."
        )) });
    }
    compute(env, options, value) {
        return value && env.emptySelectionClipboard;
    }
}
class EditorFind extends BaseEditorOption {
    constructor() {
        const defaults = {
            cursorMoveOnType: true,
            seedSearchStringFromSelection: 'always',
            autoFindInSelection: 'never',
            globalFindClipboard: false,
            addExtraSpaceOnTop: true,
            loop: true
        };
        super(EditorOption.find, 'find', defaults, {
            'editor.find.cursorMoveOnType': {
                type: 'boolean',
                default: defaults.cursorMoveOnType,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    7,
                    "Controls whether the cursor should jump to find matches while typing."
                ))
            },
            'editor.find.seedSearchStringFromSelection': {
                type: 'string',
                enum: ['never', 'always', 'selection'],
                default: defaults.seedSearchStringFromSelection,
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 8, 'Never seed search string from the editor selection.')),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        9,
                        'Always seed search string from the editor selection, including word at cursor position.'
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 10, 'Only seed search string from the editor selection.'))
                ],
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    11,
                    "Controls whether the search string in the Find Widget is seeded from the editor selection."
                ))
            },
            'editor.find.autoFindInSelection': {
                type: 'string',
                enum: ['never', 'always', 'multiline'],
                default: defaults.autoFindInSelection,
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 12, 'Never turn on Find in Selection automatically (default).')),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 13, 'Always turn on Find in Selection automatically.')),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        14,
                        'Turn on Find in Selection automatically when multiple lines of content are selected.'
                    ))
                ],
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    15,
                    "Controls the condition for turning on Find in Selection automatically."
                ))
            },
            'editor.find.globalFindClipboard': {
                type: 'boolean',
                default: defaults.globalFindClipboard,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    16,
                    "Controls whether the Find Widget should read or modify the shared find clipboard on macOS."
                )),
                included: _base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isMacintosh
            },
            'editor.find.addExtraSpaceOnTop': {
                type: 'boolean',
                default: defaults.addExtraSpaceOnTop,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    17,
                    "Controls whether the Find Widget should add extra lines on top of the editor. When true, you can scroll beyond the first line when the Find Widget is visible."
                ))
            },
            'editor.find.loop': {
                type: 'boolean',
                default: defaults.loop,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    18,
                    "Controls whether the search automatically restarts from the beginning (or the end) when no further matches can be found."
                ))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            cursorMoveOnType: boolean(input.cursorMoveOnType, this.defaultValue.cursorMoveOnType),
            seedSearchStringFromSelection: typeof _input.seedSearchStringFromSelection === 'boolean'
                ? (_input.seedSearchStringFromSelection ? 'always' : 'never')
                : stringSet(input.seedSearchStringFromSelection, this.defaultValue.seedSearchStringFromSelection, ['never', 'always', 'selection']),
            autoFindInSelection: typeof _input.autoFindInSelection === 'boolean'
                ? (_input.autoFindInSelection ? 'always' : 'never')
                : stringSet(input.autoFindInSelection, this.defaultValue.autoFindInSelection, ['never', 'always', 'multiline']),
            globalFindClipboard: boolean(input.globalFindClipboard, this.defaultValue.globalFindClipboard),
            addExtraSpaceOnTop: boolean(input.addExtraSpaceOnTop, this.defaultValue.addExtraSpaceOnTop),
            loop: boolean(input.loop, this.defaultValue.loop),
        };
    }
}
class EditorFontLigatures extends BaseEditorOption {
    static { this.OFF = '"liga" off, "calt" off'; }
    static { this.ON = '"liga" on, "calt" on'; }
    constructor() {
        super(EditorOption.fontLigatures, 'fontLigatures', EditorFontLigatures.OFF, {
            anyOf: [
                {
                    type: 'boolean',
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        19,
                        "Enables/Disables font ligatures ('calt' and 'liga' font features). Change this to a string for fine-grained control of the 'font-feature-settings' CSS property."
                    )),
                },
                {
                    type: 'string',
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        20,
                        "Explicit 'font-feature-settings' CSS property. A boolean can be passed instead if one only needs to turn on/off ligatures."
                    ))
                }
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                21,
                "Configures font ligatures or font features. Can be either a boolean to enable/disable ligatures or a string for the value of the CSS 'font-feature-settings' property."
            )),
            default: false
        });
    }
    validate(input) {
        if (typeof input === 'undefined') {
            return this.defaultValue;
        }
        if (typeof input === 'string') {
            if (input === 'false' || input.length === 0) {
                return EditorFontLigatures.OFF;
            }
            if (input === 'true') {
                return EditorFontLigatures.ON;
            }
            return input;
        }
        if (Boolean(input)) {
            return EditorFontLigatures.ON;
        }
        return EditorFontLigatures.OFF;
    }
}
class EditorFontVariations extends BaseEditorOption {
    static { this.OFF = 'normal'; }
    static { this.TRANSLATE = 'translate'; }
    constructor() {
        super(EditorOption.fontVariations, 'fontVariations', EditorFontVariations.OFF, {
            anyOf: [
                {
                    type: 'boolean',
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        22,
                        "Enables/Disables the translation from font-weight to font-variation-settings. Change this to a string for fine-grained control of the 'font-variation-settings' CSS property."
                    )),
                },
                {
                    type: 'string',
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        23,
                        "Explicit 'font-variation-settings' CSS property. A boolean can be passed instead if one only needs to translate font-weight to font-variation-settings."
                    ))
                }
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                24,
                "Configures font variations. Can be either a boolean to enable/disable the translation from font-weight to font-variation-settings or a string for the value of the CSS 'font-variation-settings' property."
            )),
            default: false
        });
    }
    validate(input) {
        if (typeof input === 'undefined') {
            return this.defaultValue;
        }
        if (typeof input === 'string') {
            if (input === 'false') {
                return EditorFontVariations.OFF;
            }
            if (input === 'true') {
                return EditorFontVariations.TRANSLATE;
            }
            return input;
        }
        if (Boolean(input)) {
            return EditorFontVariations.TRANSLATE;
        }
        return EditorFontVariations.OFF;
    }
    compute(env, options, value) {
        return env.fontInfo.fontVariationSettings;
    }
}
class EditorFontInfo extends ComputedEditorOption {
    constructor() {
        super(EditorOption.fontInfo);
    }
    compute(env, options, _) {
        return env.fontInfo;
    }
}
class EditorFontSize extends SimpleEditorOption {
    constructor() {
        super(EditorOption.fontSize, 'fontSize', EDITOR_FONT_DEFAULTS.fontSize, {
            type: 'number',
            minimum: 6,
            maximum: 100,
            default: EDITOR_FONT_DEFAULTS.fontSize,
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 25, "Controls the font size in pixels."))
        });
    }
    validate(input) {
        const r = EditorFloatOption.float(input, this.defaultValue);
        if (r === 0) {
            return EDITOR_FONT_DEFAULTS.fontSize;
        }
        return EditorFloatOption.clamp(r, 6, 100);
    }
    compute(env, options, value) {
        return env.fontInfo.fontSize;
    }
}
class EditorFontWeight extends BaseEditorOption {
    static { this.SUGGESTION_VALUES = ['normal', 'bold', '100', '200', '300', '400', '500', '600', '700', '800', '900']; }
    static { this.MINIMUM_VALUE = 1; }
    static { this.MAXIMUM_VALUE = 1000; }
    constructor() {
        super(EditorOption.fontWeight, 'fontWeight', EDITOR_FONT_DEFAULTS.fontWeight, {
            anyOf: [
                {
                    type: 'number',
                    minimum: EditorFontWeight.MINIMUM_VALUE,
                    maximum: EditorFontWeight.MAXIMUM_VALUE,
                    errorMessage: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        26,
                        "Only \"normal\" and \"bold\" keywords or numbers between 1 and 1000 are allowed."
                    ))
                },
                {
                    type: 'string',
                    pattern: '^(normal|bold|1000|[1-9][0-9]{0,2})$'
                },
                {
                    enum: EditorFontWeight.SUGGESTION_VALUES
                }
            ],
            default: EDITOR_FONT_DEFAULTS.fontWeight,
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                27,
                "Controls the font weight. Accepts \"normal\" and \"bold\" keywords or numbers between 1 and 1000."
            ))
        });
    }
    validate(input) {
        if (input === 'normal' || input === 'bold') {
            return input;
        }
        return String(EditorIntOption.clampedInt(input, EDITOR_FONT_DEFAULTS.fontWeight, EditorFontWeight.MINIMUM_VALUE, EditorFontWeight.MAXIMUM_VALUE));
    }
}
class EditorGoToLocation extends BaseEditorOption {
    constructor() {
        const defaults = {
            multiple: 'peek',
            multipleDefinitions: 'peek',
            multipleTypeDefinitions: 'peek',
            multipleDeclarations: 'peek',
            multipleImplementations: 'peek',
            multipleReferences: 'peek',
            alternativeDefinitionCommand: 'editor.action.goToReferences',
            alternativeTypeDefinitionCommand: 'editor.action.goToReferences',
            alternativeDeclarationCommand: 'editor.action.goToReferences',
            alternativeImplementationCommand: '',
            alternativeReferenceCommand: '',
        };
        const jsonSubset = {
            type: 'string',
            enum: ['peek', 'gotoAndPeek', 'goto'],
            default: defaults.multiple,
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 28, 'Show Peek view of the results (default)')),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 29, 'Go to the primary result and show a Peek view')),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    30,
                    'Go to the primary result and enable Peek-less navigation to others'
                ))
            ]
        };
        const alternativeCommandOptions = ['', 'editor.action.referenceSearch.trigger', 'editor.action.goToReferences', 'editor.action.peekImplementation', 'editor.action.goToImplementation', 'editor.action.peekTypeDefinition', 'editor.action.goToTypeDefinition', 'editor.action.peekDeclaration', 'editor.action.revealDeclaration', 'editor.action.peekDefinition', 'editor.action.revealDefinitionAside', 'editor.action.revealDefinition'];
        super(EditorOption.gotoLocation, 'gotoLocation', defaults, {
            'editor.gotoLocation.multiple': {
                deprecationMessage: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    31,
                    "This setting is deprecated, please use separate settings like 'editor.editor.gotoLocation.multipleDefinitions' or 'editor.editor.gotoLocation.multipleImplementations' instead."
                )),
            },
            'editor.gotoLocation.multipleDefinitions': {
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    32,
                    "Controls the behavior the 'Go to Definition'-command when multiple target locations exist."
                )),
                ...jsonSubset,
            },
            'editor.gotoLocation.multipleTypeDefinitions': {
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    33,
                    "Controls the behavior the 'Go to Type Definition'-command when multiple target locations exist."
                )),
                ...jsonSubset,
            },
            'editor.gotoLocation.multipleDeclarations': {
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    34,
                    "Controls the behavior the 'Go to Declaration'-command when multiple target locations exist."
                )),
                ...jsonSubset,
            },
            'editor.gotoLocation.multipleImplementations': {
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    35,
                    "Controls the behavior the 'Go to Implementations'-command when multiple target locations exist."
                )),
                ...jsonSubset,
            },
            'editor.gotoLocation.multipleReferences': {
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    36,
                    "Controls the behavior the 'Go to References'-command when multiple target locations exist."
                )),
                ...jsonSubset,
            },
            'editor.gotoLocation.alternativeDefinitionCommand': {
                type: 'string',
                default: defaults.alternativeDefinitionCommand,
                enum: alternativeCommandOptions,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    37,
                    "Alternative command id that is being executed when the result of 'Go to Definition' is the current location."
                ))
            },
            'editor.gotoLocation.alternativeTypeDefinitionCommand': {
                type: 'string',
                default: defaults.alternativeTypeDefinitionCommand,
                enum: alternativeCommandOptions,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    38,
                    "Alternative command id that is being executed when the result of 'Go to Type Definition' is the current location."
                ))
            },
            'editor.gotoLocation.alternativeDeclarationCommand': {
                type: 'string',
                default: defaults.alternativeDeclarationCommand,
                enum: alternativeCommandOptions,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    39,
                    "Alternative command id that is being executed when the result of 'Go to Declaration' is the current location."
                ))
            },
            'editor.gotoLocation.alternativeImplementationCommand': {
                type: 'string',
                default: defaults.alternativeImplementationCommand,
                enum: alternativeCommandOptions,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    40,
                    "Alternative command id that is being executed when the result of 'Go to Implementation' is the current location."
                ))
            },
            'editor.gotoLocation.alternativeReferenceCommand': {
                type: 'string',
                default: defaults.alternativeReferenceCommand,
                enum: alternativeCommandOptions,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    41,
                    "Alternative command id that is being executed when the result of 'Go to Reference' is the current location."
                ))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            multiple: stringSet(input.multiple, this.defaultValue.multiple, ['peek', 'gotoAndPeek', 'goto']),
            multipleDefinitions: input.multipleDefinitions ?? stringSet(input.multipleDefinitions, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            multipleTypeDefinitions: input.multipleTypeDefinitions ?? stringSet(input.multipleTypeDefinitions, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            multipleDeclarations: input.multipleDeclarations ?? stringSet(input.multipleDeclarations, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            multipleImplementations: input.multipleImplementations ?? stringSet(input.multipleImplementations, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            multipleReferences: input.multipleReferences ?? stringSet(input.multipleReferences, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            alternativeDefinitionCommand: EditorStringOption.string(input.alternativeDefinitionCommand, this.defaultValue.alternativeDefinitionCommand),
            alternativeTypeDefinitionCommand: EditorStringOption.string(input.alternativeTypeDefinitionCommand, this.defaultValue.alternativeTypeDefinitionCommand),
            alternativeDeclarationCommand: EditorStringOption.string(input.alternativeDeclarationCommand, this.defaultValue.alternativeDeclarationCommand),
            alternativeImplementationCommand: EditorStringOption.string(input.alternativeImplementationCommand, this.defaultValue.alternativeImplementationCommand),
            alternativeReferenceCommand: EditorStringOption.string(input.alternativeReferenceCommand, this.defaultValue.alternativeReferenceCommand),
        };
    }
}
class EditorHover extends BaseEditorOption {
    constructor() {
        const defaults = {
            enabled: true,
            delay: 300,
            hidingDelay: 300,
            sticky: true,
            above: true,
        };
        super(EditorOption.hover, 'hover', defaults, {
            'editor.hover.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 42, "Controls whether the hover is shown."))
            },
            'editor.hover.delay': {
                type: 'number',
                default: defaults.delay,
                minimum: 0,
                maximum: 10000,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    43,
                    "Controls the delay in milliseconds after which the hover is shown."
                ))
            },
            'editor.hover.sticky': {
                type: 'boolean',
                default: defaults.sticky,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    44,
                    "Controls whether the hover should remain visible when mouse is moved over it."
                ))
            },
            'editor.hover.hidingDelay': {
                type: 'integer',
                minimum: 0,
                default: defaults.hidingDelay,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    45,
                    "Controls the delay in milliseconds after which the hover is hidden. Requires `editor.hover.sticky` to be enabled."
                ))
            },
            'editor.hover.above': {
                type: 'boolean',
                default: defaults.above,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 46, "Prefer showing hovers above the line, if there's space."))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            delay: EditorIntOption.clampedInt(input.delay, this.defaultValue.delay, 0, 10000),
            sticky: boolean(input.sticky, this.defaultValue.sticky),
            hidingDelay: EditorIntOption.clampedInt(input.hidingDelay, this.defaultValue.hidingDelay, 0, 600000),
            above: boolean(input.above, this.defaultValue.above),
        };
    }
}
var RenderMinimap;
( ((function(RenderMinimap) {
    RenderMinimap[RenderMinimap["None"] = 0] = "None";
    RenderMinimap[RenderMinimap["Text"] = 1] = "Text";
    RenderMinimap[RenderMinimap["Blocks"] = 2] = "Blocks";
})(RenderMinimap || (RenderMinimap = {}))));
class EditorLayoutInfoComputer extends ComputedEditorOption {
    constructor() {
        super(EditorOption.layoutInfo);
    }
    compute(env, options, _) {
        return EditorLayoutInfoComputer.computeLayout(options, {
            memory: env.memory,
            outerWidth: env.outerWidth,
            outerHeight: env.outerHeight,
            isDominatedByLongLines: env.isDominatedByLongLines,
            lineHeight: env.fontInfo.lineHeight,
            viewLineCount: env.viewLineCount,
            lineNumbersDigitCount: env.lineNumbersDigitCount,
            typicalHalfwidthCharacterWidth: env.fontInfo.typicalHalfwidthCharacterWidth,
            maxDigitWidth: env.fontInfo.maxDigitWidth,
            pixelRatio: env.pixelRatio,
            glyphMarginDecorationLaneCount: env.glyphMarginDecorationLaneCount
        });
    }
    static computeContainedMinimapLineCount(input) {
        const typicalViewportLineCount = input.height / input.lineHeight;
        const extraLinesBeforeFirstLine = Math.floor(input.paddingTop / input.lineHeight);
        let extraLinesBeyondLastLine = Math.floor(input.paddingBottom / input.lineHeight);
        if (input.scrollBeyondLastLine) {
            extraLinesBeyondLastLine = Math.max(extraLinesBeyondLastLine, typicalViewportLineCount - 1);
        }
        const desiredRatio = (extraLinesBeforeFirstLine + input.viewLineCount + extraLinesBeyondLastLine) / (input.pixelRatio * input.height);
        const minimapLineCount = Math.floor(input.viewLineCount / desiredRatio);
        return { typicalViewportLineCount, extraLinesBeforeFirstLine, extraLinesBeyondLastLine, desiredRatio, minimapLineCount };
    }
    static _computeMinimapLayout(input, memory) {
        const outerWidth = input.outerWidth;
        const outerHeight = input.outerHeight;
        const pixelRatio = input.pixelRatio;
        if (!input.minimap.enabled) {
            return {
                renderMinimap: RenderMinimap.None,
                minimapLeft: 0,
                minimapWidth: 0,
                minimapHeightIsEditorHeight: false,
                minimapIsSampling: false,
                minimapScale: 1,
                minimapLineHeight: 1,
                minimapCanvasInnerWidth: 0,
                minimapCanvasInnerHeight: Math.floor(pixelRatio * outerHeight),
                minimapCanvasOuterWidth: 0,
                minimapCanvasOuterHeight: outerHeight,
            };
        }
        const stableMinimapLayoutInput = memory.stableMinimapLayoutInput;
        const couldUseMemory = (stableMinimapLayoutInput
            && input.outerHeight === stableMinimapLayoutInput.outerHeight
            && input.lineHeight === stableMinimapLayoutInput.lineHeight
            && input.typicalHalfwidthCharacterWidth === stableMinimapLayoutInput.typicalHalfwidthCharacterWidth
            && input.pixelRatio === stableMinimapLayoutInput.pixelRatio
            && input.scrollBeyondLastLine === stableMinimapLayoutInput.scrollBeyondLastLine
            && input.paddingTop === stableMinimapLayoutInput.paddingTop
            && input.paddingBottom === stableMinimapLayoutInput.paddingBottom
            && input.minimap.enabled === stableMinimapLayoutInput.minimap.enabled
            && input.minimap.side === stableMinimapLayoutInput.minimap.side
            && input.minimap.size === stableMinimapLayoutInput.minimap.size
            && input.minimap.showSlider === stableMinimapLayoutInput.minimap.showSlider
            && input.minimap.renderCharacters === stableMinimapLayoutInput.minimap.renderCharacters
            && input.minimap.maxColumn === stableMinimapLayoutInput.minimap.maxColumn
            && input.minimap.scale === stableMinimapLayoutInput.minimap.scale
            && input.verticalScrollbarWidth === stableMinimapLayoutInput.verticalScrollbarWidth
            && input.isViewportWrapping === stableMinimapLayoutInput.isViewportWrapping);
        const lineHeight = input.lineHeight;
        const typicalHalfwidthCharacterWidth = input.typicalHalfwidthCharacterWidth;
        const scrollBeyondLastLine = input.scrollBeyondLastLine;
        const minimapRenderCharacters = input.minimap.renderCharacters;
        let minimapScale = (pixelRatio >= 2 ? Math.round(input.minimap.scale * 2) : input.minimap.scale);
        const minimapMaxColumn = input.minimap.maxColumn;
        const minimapSize = input.minimap.size;
        const minimapSide = input.minimap.side;
        const verticalScrollbarWidth = input.verticalScrollbarWidth;
        const viewLineCount = input.viewLineCount;
        const remainingWidth = input.remainingWidth;
        const isViewportWrapping = input.isViewportWrapping;
        const baseCharHeight = minimapRenderCharacters ? 2 : 3;
        let minimapCanvasInnerHeight = Math.floor(pixelRatio * outerHeight);
        const minimapCanvasOuterHeight = minimapCanvasInnerHeight / pixelRatio;
        let minimapHeightIsEditorHeight = false;
        let minimapIsSampling = false;
        let minimapLineHeight = baseCharHeight * minimapScale;
        let minimapCharWidth = minimapScale / pixelRatio;
        let minimapWidthMultiplier = 1;
        if (minimapSize === 'fill' || minimapSize === 'fit') {
            const { typicalViewportLineCount, extraLinesBeforeFirstLine, extraLinesBeyondLastLine, desiredRatio, minimapLineCount } = EditorLayoutInfoComputer.computeContainedMinimapLineCount({
                viewLineCount: viewLineCount,
                scrollBeyondLastLine: scrollBeyondLastLine,
                paddingTop: input.paddingTop,
                paddingBottom: input.paddingBottom,
                height: outerHeight,
                lineHeight: lineHeight,
                pixelRatio: pixelRatio
            });
            const ratio = viewLineCount / minimapLineCount;
            if (ratio > 1) {
                minimapHeightIsEditorHeight = true;
                minimapIsSampling = true;
                minimapScale = 1;
                minimapLineHeight = 1;
                minimapCharWidth = minimapScale / pixelRatio;
            }
            else {
                let fitBecomesFill = false;
                let maxMinimapScale = minimapScale + 1;
                if (minimapSize === 'fit') {
                    const effectiveMinimapHeight = Math.ceil((extraLinesBeforeFirstLine + viewLineCount + extraLinesBeyondLastLine) * minimapLineHeight);
                    if (isViewportWrapping && couldUseMemory && remainingWidth <= memory.stableFitRemainingWidth) {
                        fitBecomesFill = true;
                        maxMinimapScale = memory.stableFitMaxMinimapScale;
                    }
                    else {
                        fitBecomesFill = (effectiveMinimapHeight > minimapCanvasInnerHeight);
                    }
                }
                if (minimapSize === 'fill' || fitBecomesFill) {
                    minimapHeightIsEditorHeight = true;
                    const configuredMinimapScale = minimapScale;
                    minimapLineHeight = Math.min(lineHeight * pixelRatio, Math.max(1, Math.floor(1 / desiredRatio)));
                    if (isViewportWrapping && couldUseMemory && remainingWidth <= memory.stableFitRemainingWidth) {
                        maxMinimapScale = memory.stableFitMaxMinimapScale;
                    }
                    minimapScale = Math.min(maxMinimapScale, Math.max(1, Math.floor(minimapLineHeight / baseCharHeight)));
                    if (minimapScale > configuredMinimapScale) {
                        minimapWidthMultiplier = Math.min(2, minimapScale / configuredMinimapScale);
                    }
                    minimapCharWidth = minimapScale / pixelRatio / minimapWidthMultiplier;
                    minimapCanvasInnerHeight = Math.ceil((Math.max(typicalViewportLineCount, extraLinesBeforeFirstLine + viewLineCount + extraLinesBeyondLastLine)) * minimapLineHeight);
                    if (isViewportWrapping) {
                        memory.stableMinimapLayoutInput = input;
                        memory.stableFitRemainingWidth = remainingWidth;
                        memory.stableFitMaxMinimapScale = minimapScale;
                    }
                    else {
                        memory.stableMinimapLayoutInput = null;
                        memory.stableFitRemainingWidth = 0;
                    }
                }
            }
        }
        const minimapMaxWidth = Math.floor(minimapMaxColumn * minimapCharWidth);
        const minimapWidth = Math.min(minimapMaxWidth, Math.max(0, Math.floor(((remainingWidth - verticalScrollbarWidth - 2) * minimapCharWidth) / (typicalHalfwidthCharacterWidth + minimapCharWidth))) + MINIMAP_GUTTER_WIDTH);
        let minimapCanvasInnerWidth = Math.floor(pixelRatio * minimapWidth);
        const minimapCanvasOuterWidth = minimapCanvasInnerWidth / pixelRatio;
        minimapCanvasInnerWidth = Math.floor(minimapCanvasInnerWidth * minimapWidthMultiplier);
        const renderMinimap = (minimapRenderCharacters ? RenderMinimap.Text : RenderMinimap.Blocks);
        const minimapLeft = (minimapSide === 'left' ? 0 : (outerWidth - minimapWidth - verticalScrollbarWidth));
        return {
            renderMinimap,
            minimapLeft,
            minimapWidth,
            minimapHeightIsEditorHeight,
            minimapIsSampling,
            minimapScale,
            minimapLineHeight,
            minimapCanvasInnerWidth,
            minimapCanvasInnerHeight,
            minimapCanvasOuterWidth,
            minimapCanvasOuterHeight,
        };
    }
    static computeLayout(options, env) {
        const outerWidth = env.outerWidth | 0;
        const outerHeight = env.outerHeight | 0;
        const lineHeight = env.lineHeight | 0;
        const lineNumbersDigitCount = env.lineNumbersDigitCount | 0;
        const typicalHalfwidthCharacterWidth = env.typicalHalfwidthCharacterWidth;
        const maxDigitWidth = env.maxDigitWidth;
        const pixelRatio = env.pixelRatio;
        const viewLineCount = env.viewLineCount;
        const wordWrapOverride2 = options.get(EditorOption.wordWrapOverride2);
        const wordWrapOverride1 = (wordWrapOverride2 === 'inherit' ? options.get(EditorOption.wordWrapOverride1) : wordWrapOverride2);
        const wordWrap = (wordWrapOverride1 === 'inherit' ? options.get(EditorOption.wordWrap) : wordWrapOverride1);
        const wordWrapColumn = options.get(EditorOption.wordWrapColumn);
        const isDominatedByLongLines = env.isDominatedByLongLines;
        const showGlyphMargin = options.get(EditorOption.glyphMargin);
        const showLineNumbers = (options.get(EditorOption.lineNumbers).renderType !== RenderLineNumbersType.Off);
        const lineNumbersMinChars = options.get(EditorOption.lineNumbersMinChars);
        const scrollBeyondLastLine = options.get(EditorOption.scrollBeyondLastLine);
        const padding = options.get(EditorOption.padding);
        const minimap = options.get(EditorOption.minimap);
        const scrollbar = options.get(EditorOption.scrollbar);
        const verticalScrollbarWidth = scrollbar.verticalScrollbarSize;
        const verticalScrollbarHasArrows = scrollbar.verticalHasArrows;
        const scrollbarArrowSize = scrollbar.arrowSize;
        const horizontalScrollbarHeight = scrollbar.horizontalScrollbarSize;
        const folding = options.get(EditorOption.folding);
        const showFoldingDecoration = options.get(EditorOption.showFoldingControls) !== 'never';
        let lineDecorationsWidth = options.get(EditorOption.lineDecorationsWidth);
        if (folding && showFoldingDecoration) {
            lineDecorationsWidth += 16;
        }
        let lineNumbersWidth = 0;
        if (showLineNumbers) {
            const digitCount = Math.max(lineNumbersDigitCount, lineNumbersMinChars);
            lineNumbersWidth = Math.round(digitCount * maxDigitWidth);
        }
        let glyphMarginWidth = 0;
        if (showGlyphMargin) {
            glyphMarginWidth = lineHeight * env.glyphMarginDecorationLaneCount;
        }
        let glyphMarginLeft = 0;
        let lineNumbersLeft = glyphMarginLeft + glyphMarginWidth;
        let decorationsLeft = lineNumbersLeft + lineNumbersWidth;
        let contentLeft = decorationsLeft + lineDecorationsWidth;
        const remainingWidth = outerWidth - glyphMarginWidth - lineNumbersWidth - lineDecorationsWidth;
        let isWordWrapMinified = false;
        let isViewportWrapping = false;
        let wrappingColumn = -1;
        if (wordWrapOverride1 === 'inherit' && isDominatedByLongLines) {
            isWordWrapMinified = true;
            isViewportWrapping = true;
        }
        else if (wordWrap === 'on' || wordWrap === 'bounded') {
            isViewportWrapping = true;
        }
        else if (wordWrap === 'wordWrapColumn') {
            wrappingColumn = wordWrapColumn;
        }
        const minimapLayout = EditorLayoutInfoComputer._computeMinimapLayout({
            outerWidth: outerWidth,
            outerHeight: outerHeight,
            lineHeight: lineHeight,
            typicalHalfwidthCharacterWidth: typicalHalfwidthCharacterWidth,
            pixelRatio: pixelRatio,
            scrollBeyondLastLine: scrollBeyondLastLine,
            paddingTop: padding.top,
            paddingBottom: padding.bottom,
            minimap: minimap,
            verticalScrollbarWidth: verticalScrollbarWidth,
            viewLineCount: viewLineCount,
            remainingWidth: remainingWidth,
            isViewportWrapping: isViewportWrapping,
        }, env.memory || ( (new ComputeOptionsMemory())));
        if (minimapLayout.renderMinimap !== RenderMinimap.None && minimapLayout.minimapLeft === 0) {
            glyphMarginLeft += minimapLayout.minimapWidth;
            lineNumbersLeft += minimapLayout.minimapWidth;
            decorationsLeft += minimapLayout.minimapWidth;
            contentLeft += minimapLayout.minimapWidth;
        }
        const contentWidth = remainingWidth - minimapLayout.minimapWidth;
        const viewportColumn = Math.max(1, Math.floor((contentWidth - verticalScrollbarWidth - 2) / typicalHalfwidthCharacterWidth));
        const verticalArrowSize = (verticalScrollbarHasArrows ? scrollbarArrowSize : 0);
        if (isViewportWrapping) {
            wrappingColumn = Math.max(1, viewportColumn);
            if (wordWrap === 'bounded') {
                wrappingColumn = Math.min(wrappingColumn, wordWrapColumn);
            }
        }
        return {
            width: outerWidth,
            height: outerHeight,
            glyphMarginLeft: glyphMarginLeft,
            glyphMarginWidth: glyphMarginWidth,
            glyphMarginDecorationLaneCount: env.glyphMarginDecorationLaneCount,
            lineNumbersLeft: lineNumbersLeft,
            lineNumbersWidth: lineNumbersWidth,
            decorationsLeft: decorationsLeft,
            decorationsWidth: lineDecorationsWidth,
            contentLeft: contentLeft,
            contentWidth: contentWidth,
            minimap: minimapLayout,
            viewportColumn: viewportColumn,
            isWordWrapMinified: isWordWrapMinified,
            isViewportWrapping: isViewportWrapping,
            wrappingColumn: wrappingColumn,
            verticalScrollbarWidth: verticalScrollbarWidth,
            horizontalScrollbarHeight: horizontalScrollbarHeight,
            overviewRuler: {
                top: verticalArrowSize,
                width: verticalScrollbarWidth,
                height: (outerHeight - 2 * verticalArrowSize),
                right: 0
            }
        };
    }
}
class WrappingStrategy extends BaseEditorOption {
    constructor() {
        super(EditorOption.wrappingStrategy, 'wrappingStrategy', 'simple', {
            'editor.wrappingStrategy': {
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        47,
                        "Assumes that all characters are of the same width. This is a fast algorithm that works correctly for monospace fonts and certain scripts (like Latin characters) where glyphs are of equal width."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        48,
                        "Delegates wrapping points computation to the browser. This is a slow algorithm, that might cause freezes for large files, but it works correctly in all cases."
                    ))
                ],
                type: 'string',
                enum: ['simple', 'advanced'],
                default: 'simple',
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    49,
                    "Controls the algorithm that computes wrapping points. Note that when in accessibility mode, advanced will be used for the best experience."
                ))
            }
        });
    }
    validate(input) {
        return stringSet(input, 'simple', ['simple', 'advanced']);
    }
    compute(env, options, value) {
        const accessibilitySupport = options.get(EditorOption.accessibilitySupport);
        if (accessibilitySupport === _platform_accessibility_common_accessibility_js__WEBPACK_IMPORTED_MODULE_8__.AccessibilitySupport.Enabled) {
            return 'advanced';
        }
        return value;
    }
}
var ShowLightbulbIconMode;
( ((function(ShowLightbulbIconMode) {
    ShowLightbulbIconMode["Off"] = "off";
    ShowLightbulbIconMode["OnCode"] = "onCode";
    ShowLightbulbIconMode["On"] = "on";
})(ShowLightbulbIconMode || (ShowLightbulbIconMode = {}))));
class EditorLightbulb extends BaseEditorOption {
    constructor() {
        const defaults = { enabled: ShowLightbulbIconMode.On };
        super(EditorOption.lightbulb, 'lightbulb', defaults, {
            'editor.lightbulb.enabled': {
                type: 'string',
                tags: ['experimental'],
                enum: [ShowLightbulbIconMode.Off, ShowLightbulbIconMode.OnCode, ShowLightbulbIconMode.On],
                default: defaults.enabled,
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 50, 'Disable the code action menu.')),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        51,
                        'Show the code action menu when the cursor is on lines with code.'
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        52,
                        'Show the code action menu when the cursor is on lines with code or on empty lines.'
                    )),
                ],
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 53, "Enables the Code Action lightbulb in the editor."))
            }
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: stringSet(input.enabled, this.defaultValue.enabled, [ShowLightbulbIconMode.Off, ShowLightbulbIconMode.OnCode, ShowLightbulbIconMode.On])
        };
    }
}
class EditorStickyScroll extends BaseEditorOption {
    constructor() {
        const defaults = { enabled: true, maxLineCount: 5, defaultModel: 'outlineModel', scrollWithEditor: true };
        super(EditorOption.stickyScroll, 'stickyScroll', defaults, {
            'editor.stickyScroll.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    54,
                    "Shows the nested current scopes during the scroll at the top of the editor."
                )),
                tags: ['experimental']
            },
            'editor.stickyScroll.maxLineCount': {
                type: 'number',
                default: defaults.maxLineCount,
                minimum: 1,
                maximum: 20,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 55, "Defines the maximum number of sticky lines to show."))
            },
            'editor.stickyScroll.defaultModel': {
                type: 'string',
                enum: ['outlineModel', 'foldingProviderModel', 'indentationModel'],
                default: defaults.defaultModel,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    56,
                    "Defines the model to use for determining which lines to stick. If the outline model does not exist, it will fall back on the folding provider model which falls back on the indentation model. This order is respected in all three cases."
                ))
            },
            'editor.stickyScroll.scrollWithEditor': {
                type: 'boolean',
                default: defaults.scrollWithEditor,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    57,
                    "Enable scrolling of Sticky Scroll with the editor's horizontal scrollbar."
                ))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            maxLineCount: EditorIntOption.clampedInt(input.maxLineCount, this.defaultValue.maxLineCount, 1, 20),
            defaultModel: stringSet(input.defaultModel, this.defaultValue.defaultModel, ['outlineModel', 'foldingProviderModel', 'indentationModel']),
            scrollWithEditor: boolean(input.scrollWithEditor, this.defaultValue.scrollWithEditor)
        };
    }
}
class EditorInlayHints extends BaseEditorOption {
    constructor() {
        const defaults = { enabled: 'on', fontSize: 0, fontFamily: '', padding: false };
        super(EditorOption.inlayHints, 'inlayHints', defaults, {
            'editor.inlayHints.enabled': {
                type: 'string',
                default: defaults.enabled,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 58, "Enables the inlay hints in the editor.")),
                enum: ['on', 'onUnlessPressed', 'offUnlessPressed', 'off'],
                markdownEnumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 59, "Inlay hints are enabled")),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        60,
                        "Inlay hints are showing by default and hide when holding {0}",
                        _base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isMacintosh ? `Ctrl+Option` : `Ctrl+Alt`
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        61,
                        "Inlay hints are hidden by default and show when holding {0}",
                        _base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isMacintosh ? `Ctrl+Option` : `Ctrl+Alt`
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 62, "Inlay hints are disabled")),
                ],
            },
            'editor.inlayHints.fontSize': {
                type: 'number',
                default: defaults.fontSize,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    63,
                    "Controls font size of inlay hints in the editor. As default the {0} is used when the configured value is less than {1} or greater than the editor font size.",
                    '`#editor.fontSize#`',
                    '`5`'
                ))
            },
            'editor.inlayHints.fontFamily': {
                type: 'string',
                default: defaults.fontFamily,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    64,
                    "Controls font family of inlay hints in the editor. When set to empty, the {0} is used.",
                    '`#editor.fontFamily#`'
                ))
            },
            'editor.inlayHints.padding': {
                type: 'boolean',
                default: defaults.padding,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 65, "Enables the padding around the inlay hints in the editor."))
            }
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        if (typeof input.enabled === 'boolean') {
            input.enabled = input.enabled ? 'on' : 'off';
        }
        return {
            enabled: stringSet(input.enabled, this.defaultValue.enabled, ['on', 'off', 'offUnlessPressed', 'onUnlessPressed']),
            fontSize: EditorIntOption.clampedInt(input.fontSize, this.defaultValue.fontSize, 0, 100),
            fontFamily: EditorStringOption.string(input.fontFamily, this.defaultValue.fontFamily),
            padding: boolean(input.padding, this.defaultValue.padding)
        };
    }
}
class EditorLineDecorationsWidth extends BaseEditorOption {
    constructor() {
        super(EditorOption.lineDecorationsWidth, 'lineDecorationsWidth', 10);
    }
    validate(input) {
        if (typeof input === 'string' && /^\d+(\.\d+)?ch$/.test(input)) {
            const multiple = parseFloat(input.substring(0, input.length - 2));
            return -multiple;
        }
        else {
            return EditorIntOption.clampedInt(input, this.defaultValue, 0, 1000);
        }
    }
    compute(env, options, value) {
        if (value < 0) {
            return EditorIntOption.clampedInt(-value * env.fontInfo.typicalHalfwidthCharacterWidth, this.defaultValue, 0, 1000);
        }
        else {
            return value;
        }
    }
}
class EditorLineHeight extends EditorFloatOption {
    constructor() {
        super(EditorOption.lineHeight, 'lineHeight', EDITOR_FONT_DEFAULTS.lineHeight, x => EditorFloatOption.clamp(x, 0, 150), { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            66,
            "Controls the line height. \n - Use 0 to automatically compute the line height from the font size.\n - Values between 0 and 8 will be used as a multiplier with the font size.\n - Values greater than or equal to 8 will be used as effective values."
        )) });
    }
    compute(env, options, value) {
        return env.fontInfo.lineHeight;
    }
}
class EditorMinimap extends BaseEditorOption {
    constructor() {
        const defaults = {
            enabled: true,
            size: 'proportional',
            side: 'right',
            showSlider: 'mouseover',
            autohide: false,
            renderCharacters: true,
            maxColumn: 120,
            scale: 1,
            showRegionSectionHeaders: true,
            showMarkSectionHeaders: true,
            sectionHeaderFontSize: 9,
            sectionHeaderLetterSpacing: 1,
        };
        super(EditorOption.minimap, 'minimap', defaults, {
            'editor.minimap.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 67, "Controls whether the minimap is shown."))
            },
            'editor.minimap.autohide': {
                type: 'boolean',
                default: defaults.autohide,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 68, "Controls whether the minimap is hidden automatically."))
            },
            'editor.minimap.size': {
                type: 'string',
                enum: ['proportional', 'fill', 'fit'],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        69,
                        "The minimap has the same size as the editor contents (and might scroll)."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        70,
                        "The minimap will stretch or shrink as necessary to fill the height of the editor (no scrolling)."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        71,
                        "The minimap will shrink as necessary to never be larger than the editor (no scrolling)."
                    )),
                ],
                default: defaults.size,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 72, "Controls the size of the minimap."))
            },
            'editor.minimap.side': {
                type: 'string',
                enum: ['left', 'right'],
                default: defaults.side,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 73, "Controls the side where to render the minimap."))
            },
            'editor.minimap.showSlider': {
                type: 'string',
                enum: ['always', 'mouseover'],
                default: defaults.showSlider,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 74, "Controls when the minimap slider is shown."))
            },
            'editor.minimap.scale': {
                type: 'number',
                default: defaults.scale,
                minimum: 1,
                maximum: 3,
                enum: [1, 2, 3],
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 75, "Scale of content drawn in the minimap: 1, 2 or 3."))
            },
            'editor.minimap.renderCharacters': {
                type: 'boolean',
                default: defaults.renderCharacters,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    76,
                    "Render the actual characters on a line as opposed to color blocks."
                ))
            },
            'editor.minimap.maxColumn': {
                type: 'number',
                default: defaults.maxColumn,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    77,
                    "Limit the width of the minimap to render at most a certain number of columns."
                ))
            },
            'editor.minimap.showRegionSectionHeaders': {
                type: 'boolean',
                default: defaults.showRegionSectionHeaders,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    78,
                    "Controls whether named regions are shown as section headers in the minimap."
                ))
            },
            'editor.minimap.showMarkSectionHeaders': {
                type: 'boolean',
                default: defaults.showMarkSectionHeaders,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    79,
                    "Controls whether MARK: comments are shown as section headers in the minimap."
                ))
            },
            'editor.minimap.sectionHeaderFontSize': {
                type: 'number',
                default: defaults.sectionHeaderFontSize,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 80, "Controls the font size of section headers in the minimap."))
            },
            'editor.minimap.sectionHeaderLetterSpacing': {
                type: 'number',
                default: defaults.sectionHeaderLetterSpacing,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    81,
                    "Controls the amount of space (in pixels) between characters of section header. This helps the readability of the header in small font sizes."
                ))
            }
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            autohide: boolean(input.autohide, this.defaultValue.autohide),
            size: stringSet(input.size, this.defaultValue.size, ['proportional', 'fill', 'fit']),
            side: stringSet(input.side, this.defaultValue.side, ['right', 'left']),
            showSlider: stringSet(input.showSlider, this.defaultValue.showSlider, ['always', 'mouseover']),
            renderCharacters: boolean(input.renderCharacters, this.defaultValue.renderCharacters),
            scale: EditorIntOption.clampedInt(input.scale, 1, 1, 3),
            maxColumn: EditorIntOption.clampedInt(input.maxColumn, this.defaultValue.maxColumn, 1, 10000),
            showRegionSectionHeaders: boolean(input.showRegionSectionHeaders, this.defaultValue.showRegionSectionHeaders),
            showMarkSectionHeaders: boolean(input.showMarkSectionHeaders, this.defaultValue.showMarkSectionHeaders),
            sectionHeaderFontSize: EditorFloatOption.clamp(input.sectionHeaderFontSize ?? this.defaultValue.sectionHeaderFontSize, 4, 32),
            sectionHeaderLetterSpacing: EditorFloatOption.clamp(input.sectionHeaderLetterSpacing ?? this.defaultValue.sectionHeaderLetterSpacing, 0, 5),
        };
    }
}
function _multiCursorModifierFromString(multiCursorModifier) {
    if (multiCursorModifier === 'ctrlCmd') {
        return (_base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isMacintosh ? 'metaKey' : 'ctrlKey');
    }
    return 'altKey';
}
class EditorPadding extends BaseEditorOption {
    constructor() {
        super(EditorOption.padding, 'padding', { top: 0, bottom: 0 }, {
            'editor.padding.top': {
                type: 'number',
                default: 0,
                minimum: 0,
                maximum: 1000,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    82,
                    "Controls the amount of space between the top edge of the editor and the first line."
                ))
            },
            'editor.padding.bottom': {
                type: 'number',
                default: 0,
                minimum: 0,
                maximum: 1000,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    83,
                    "Controls the amount of space between the bottom edge of the editor and the last line."
                ))
            }
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            top: EditorIntOption.clampedInt(input.top, 0, 0, 1000),
            bottom: EditorIntOption.clampedInt(input.bottom, 0, 0, 1000)
        };
    }
}
class EditorParameterHints extends BaseEditorOption {
    constructor() {
        const defaults = {
            enabled: true,
            cycle: true
        };
        super(EditorOption.parameterHints, 'parameterHints', defaults, {
            'editor.parameterHints.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    84,
                    "Enables a pop-up that shows parameter documentation and type information as you type."
                ))
            },
            'editor.parameterHints.cycle': {
                type: 'boolean',
                default: defaults.cycle,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    85,
                    "Controls whether the parameter hints menu cycles or closes when reaching the end of the list."
                ))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            cycle: boolean(input.cycle, this.defaultValue.cycle)
        };
    }
}
class EditorPixelRatio extends ComputedEditorOption {
    constructor() {
        super(EditorOption.pixelRatio);
    }
    compute(env, options, _) {
        return env.pixelRatio;
    }
}
class PlaceholderOption extends BaseEditorOption {
    constructor() {
        super(EditorOption.placeholder, 'placeholder', undefined);
    }
    validate(input) {
        if (typeof input === 'undefined') {
            return this.defaultValue;
        }
        if (typeof input === 'string') {
            return input;
        }
        return this.defaultValue;
    }
}
class EditorQuickSuggestions extends BaseEditorOption {
    constructor() {
        const defaults = {
            other: 'on',
            comments: 'off',
            strings: 'off'
        };
        const types = [
            { type: 'boolean' },
            {
                type: 'string',
                enum: ['on', 'inline', 'off'],
                enumDescriptions: [( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 86, "Quick suggestions show inside the suggest widget")), ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 87, "Quick suggestions show as ghost text")), ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 88, "Quick suggestions are disabled"))]
            }
        ];
        super(EditorOption.quickSuggestions, 'quickSuggestions', defaults, {
            type: 'object',
            additionalProperties: false,
            properties: {
                strings: {
                    anyOf: types,
                    default: defaults.strings,
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 89, "Enable quick suggestions inside strings."))
                },
                comments: {
                    anyOf: types,
                    default: defaults.comments,
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 90, "Enable quick suggestions inside comments."))
                },
                other: {
                    anyOf: types,
                    default: defaults.other,
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 91, "Enable quick suggestions outside of strings and comments."))
                },
            },
            default: defaults,
            markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                92,
                "Controls whether suggestions should automatically show up while typing. This can be controlled for typing in comments, strings, and other code. Quick suggestion can be configured to show as ghost text or with the suggest widget. Also be aware of the {0}-setting which controls if suggestions are triggered by special characters.",
                '`#editor.suggestOnTriggerCharacters#`'
            ))
        });
        this.defaultValue = defaults;
    }
    validate(input) {
        if (typeof input === 'boolean') {
            const value = input ? 'on' : 'off';
            return { comments: value, strings: value, other: value };
        }
        if (!input || typeof input !== 'object') {
            return this.defaultValue;
        }
        const { other, comments, strings } = input;
        const allowedValues = ['on', 'inline', 'off'];
        let validatedOther;
        let validatedComments;
        let validatedStrings;
        if (typeof other === 'boolean') {
            validatedOther = other ? 'on' : 'off';
        }
        else {
            validatedOther = stringSet(other, this.defaultValue.other, allowedValues);
        }
        if (typeof comments === 'boolean') {
            validatedComments = comments ? 'on' : 'off';
        }
        else {
            validatedComments = stringSet(comments, this.defaultValue.comments, allowedValues);
        }
        if (typeof strings === 'boolean') {
            validatedStrings = strings ? 'on' : 'off';
        }
        else {
            validatedStrings = stringSet(strings, this.defaultValue.strings, allowedValues);
        }
        return {
            other: validatedOther,
            comments: validatedComments,
            strings: validatedStrings
        };
    }
}
var RenderLineNumbersType;
( ((function(RenderLineNumbersType) {
    RenderLineNumbersType[RenderLineNumbersType["Off"] = 0] = "Off";
    RenderLineNumbersType[RenderLineNumbersType["On"] = 1] = "On";
    RenderLineNumbersType[RenderLineNumbersType["Relative"] = 2] = "Relative";
    RenderLineNumbersType[RenderLineNumbersType["Interval"] = 3] = "Interval";
    RenderLineNumbersType[RenderLineNumbersType["Custom"] = 4] = "Custom";
})(RenderLineNumbersType || (RenderLineNumbersType = {}))));
class EditorRenderLineNumbersOption extends BaseEditorOption {
    constructor() {
        super(EditorOption.lineNumbers, 'lineNumbers', { renderType: RenderLineNumbersType.On, renderFn: null }, {
            type: 'string',
            enum: ['off', 'on', 'relative', 'interval'],
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 93, "Line numbers are not rendered.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 94, "Line numbers are rendered as absolute number.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    95,
                    "Line numbers are rendered as distance in lines to cursor position."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 96, "Line numbers are rendered every 10 lines."))
            ],
            default: 'on',
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 97, "Controls the display of line numbers."))
        });
    }
    validate(lineNumbers) {
        let renderType = this.defaultValue.renderType;
        let renderFn = this.defaultValue.renderFn;
        if (typeof lineNumbers !== 'undefined') {
            if (typeof lineNumbers === 'function') {
                renderType = RenderLineNumbersType.Custom;
                renderFn = lineNumbers;
            }
            else if (lineNumbers === 'interval') {
                renderType = RenderLineNumbersType.Interval;
            }
            else if (lineNumbers === 'relative') {
                renderType = RenderLineNumbersType.Relative;
            }
            else if (lineNumbers === 'on') {
                renderType = RenderLineNumbersType.On;
            }
            else {
                renderType = RenderLineNumbersType.Off;
            }
        }
        return {
            renderType,
            renderFn
        };
    }
}
function filterValidationDecorations(options) {
    const renderValidationDecorations = options.get(EditorOption.renderValidationDecorations);
    if (renderValidationDecorations === 'editable') {
        return options.get(EditorOption.readOnly);
    }
    return renderValidationDecorations === 'on' ? false : true;
}
class EditorRulers extends BaseEditorOption {
    constructor() {
        const defaults = [];
        const columnSchema = { type: 'number', description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            98,
            "Number of monospace characters at which this editor ruler will render."
        )) };
        super(EditorOption.rulers, 'rulers', defaults, {
            type: 'array',
            items: {
                anyOf: [
                    columnSchema,
                    {
                        type: [
                            'object'
                        ],
                        properties: {
                            column: columnSchema,
                            color: {
                                type: 'string',
                                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 99, "Color of this editor ruler.")),
                                format: 'color-hex'
                            }
                        }
                    }
                ]
            },
            default: defaults,
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                100,
                "Render vertical rulers after a certain number of monospace characters. Use multiple values for multiple rulers. No rulers are drawn if array is empty."
            ))
        });
    }
    validate(input) {
        if (Array.isArray(input)) {
            const rulers = [];
            for (const _element of input) {
                if (typeof _element === 'number') {
                    rulers.push({
                        column: EditorIntOption.clampedInt(_element, 0, 0, 10000),
                        color: null
                    });
                }
                else if (_element && typeof _element === 'object') {
                    const element = _element;
                    rulers.push({
                        column: EditorIntOption.clampedInt(element.column, 0, 0, 10000),
                        color: element.color
                    });
                }
            }
            rulers.sort((a, b) => a.column - b.column);
            return rulers;
        }
        return this.defaultValue;
    }
}
class ReadonlyMessage extends BaseEditorOption {
    constructor() {
        const defaults = undefined;
        super(EditorOption.readOnlyMessage, 'readOnlyMessage', defaults);
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        return _input;
    }
}
function _scrollbarVisibilityFromString(visibility, defaultValue) {
    if (typeof visibility !== 'string') {
        return defaultValue;
    }
    switch (visibility) {
        case 'hidden': return _base_common_scrollable_js__WEBPACK_IMPORTED_MODULE_3__.ScrollbarVisibility.Hidden;
        case 'visible': return _base_common_scrollable_js__WEBPACK_IMPORTED_MODULE_3__.ScrollbarVisibility.Visible;
        default: return _base_common_scrollable_js__WEBPACK_IMPORTED_MODULE_3__.ScrollbarVisibility.Auto;
    }
}
class EditorScrollbar extends BaseEditorOption {
    constructor() {
        const defaults = {
            vertical: _base_common_scrollable_js__WEBPACK_IMPORTED_MODULE_3__.ScrollbarVisibility.Auto,
            horizontal: _base_common_scrollable_js__WEBPACK_IMPORTED_MODULE_3__.ScrollbarVisibility.Auto,
            arrowSize: 11,
            useShadows: true,
            verticalHasArrows: false,
            horizontalHasArrows: false,
            horizontalScrollbarSize: 12,
            horizontalSliderSize: 12,
            verticalScrollbarSize: 14,
            verticalSliderSize: 14,
            handleMouseWheel: true,
            alwaysConsumeMouseWheel: true,
            scrollByPage: false,
            ignoreHorizontalScrollbarInContentHeight: false,
        };
        super(EditorOption.scrollbar, 'scrollbar', defaults, {
            'editor.scrollbar.vertical': {
                type: 'string',
                enum: ['auto', 'visible', 'hidden'],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        101,
                        "The vertical scrollbar will be visible only when necessary."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 102, "The vertical scrollbar will always be visible.")),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 103, "The vertical scrollbar will always be hidden.")),
                ],
                default: 'auto',
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 104, "Controls the visibility of the vertical scrollbar."))
            },
            'editor.scrollbar.horizontal': {
                type: 'string',
                enum: ['auto', 'visible', 'hidden'],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        105,
                        "The horizontal scrollbar will be visible only when necessary."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 106, "The horizontal scrollbar will always be visible.")),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 107, "The horizontal scrollbar will always be hidden.")),
                ],
                default: 'auto',
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 108, "Controls the visibility of the horizontal scrollbar."))
            },
            'editor.scrollbar.verticalScrollbarSize': {
                type: 'number',
                default: defaults.verticalScrollbarSize,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 109, "The width of the vertical scrollbar."))
            },
            'editor.scrollbar.horizontalScrollbarSize': {
                type: 'number',
                default: defaults.horizontalScrollbarSize,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 110, "The height of the horizontal scrollbar."))
            },
            'editor.scrollbar.scrollByPage': {
                type: 'boolean',
                default: defaults.scrollByPage,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    111,
                    "Controls whether clicks scroll by page or jump to click position."
                ))
            },
            'editor.scrollbar.ignoreHorizontalScrollbarInContentHeight': {
                type: 'boolean',
                default: defaults.ignoreHorizontalScrollbarInContentHeight,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    112,
                    "When set, the horizontal scrollbar will not increase the size of the editor's content."
                ))
            }
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        const horizontalScrollbarSize = EditorIntOption.clampedInt(input.horizontalScrollbarSize, this.defaultValue.horizontalScrollbarSize, 0, 1000);
        const verticalScrollbarSize = EditorIntOption.clampedInt(input.verticalScrollbarSize, this.defaultValue.verticalScrollbarSize, 0, 1000);
        return {
            arrowSize: EditorIntOption.clampedInt(input.arrowSize, this.defaultValue.arrowSize, 0, 1000),
            vertical: _scrollbarVisibilityFromString(input.vertical, this.defaultValue.vertical),
            horizontal: _scrollbarVisibilityFromString(input.horizontal, this.defaultValue.horizontal),
            useShadows: boolean(input.useShadows, this.defaultValue.useShadows),
            verticalHasArrows: boolean(input.verticalHasArrows, this.defaultValue.verticalHasArrows),
            horizontalHasArrows: boolean(input.horizontalHasArrows, this.defaultValue.horizontalHasArrows),
            handleMouseWheel: boolean(input.handleMouseWheel, this.defaultValue.handleMouseWheel),
            alwaysConsumeMouseWheel: boolean(input.alwaysConsumeMouseWheel, this.defaultValue.alwaysConsumeMouseWheel),
            horizontalScrollbarSize: horizontalScrollbarSize,
            horizontalSliderSize: EditorIntOption.clampedInt(input.horizontalSliderSize, horizontalScrollbarSize, 0, 1000),
            verticalScrollbarSize: verticalScrollbarSize,
            verticalSliderSize: EditorIntOption.clampedInt(input.verticalSliderSize, verticalScrollbarSize, 0, 1000),
            scrollByPage: boolean(input.scrollByPage, this.defaultValue.scrollByPage),
            ignoreHorizontalScrollbarInContentHeight: boolean(input.ignoreHorizontalScrollbarInContentHeight, this.defaultValue.ignoreHorizontalScrollbarInContentHeight),
        };
    }
}
const inUntrustedWorkspace = 'inUntrustedWorkspace';
const unicodeHighlightConfigKeys = {
    allowedCharacters: 'editor.unicodeHighlight.allowedCharacters',
    invisibleCharacters: 'editor.unicodeHighlight.invisibleCharacters',
    nonBasicASCII: 'editor.unicodeHighlight.nonBasicASCII',
    ambiguousCharacters: 'editor.unicodeHighlight.ambiguousCharacters',
    includeComments: 'editor.unicodeHighlight.includeComments',
    includeStrings: 'editor.unicodeHighlight.includeStrings',
    allowedLocales: 'editor.unicodeHighlight.allowedLocales',
};
class UnicodeHighlight extends BaseEditorOption {
    constructor() {
        const defaults = {
            nonBasicASCII: inUntrustedWorkspace,
            invisibleCharacters: true,
            ambiguousCharacters: true,
            includeComments: inUntrustedWorkspace,
            includeStrings: true,
            allowedCharacters: {},
            allowedLocales: { _os: true, _vscode: true },
        };
        super(EditorOption.unicodeHighlighting, 'unicodeHighlight', defaults, {
            [unicodeHighlightConfigKeys.nonBasicASCII]: {
                restricted: true,
                type: ['boolean', 'string'],
                enum: [true, false, inUntrustedWorkspace],
                default: defaults.nonBasicASCII,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    113,
                    "Controls whether all non-basic ASCII characters are highlighted. Only characters between U+0020 and U+007E, tab, line-feed and carriage-return are considered basic ASCII."
                ))
            },
            [unicodeHighlightConfigKeys.invisibleCharacters]: {
                restricted: true,
                type: 'boolean',
                default: defaults.invisibleCharacters,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    114,
                    "Controls whether characters that just reserve space or have no width at all are highlighted."
                ))
            },
            [unicodeHighlightConfigKeys.ambiguousCharacters]: {
                restricted: true,
                type: 'boolean',
                default: defaults.ambiguousCharacters,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    115,
                    "Controls whether characters are highlighted that can be confused with basic ASCII characters, except those that are common in the current user locale."
                ))
            },
            [unicodeHighlightConfigKeys.includeComments]: {
                restricted: true,
                type: ['boolean', 'string'],
                enum: [true, false, inUntrustedWorkspace],
                default: defaults.includeComments,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    116,
                    "Controls whether characters in comments should also be subject to Unicode highlighting."
                ))
            },
            [unicodeHighlightConfigKeys.includeStrings]: {
                restricted: true,
                type: ['boolean', 'string'],
                enum: [true, false, inUntrustedWorkspace],
                default: defaults.includeStrings,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    117,
                    "Controls whether characters in strings should also be subject to Unicode highlighting."
                ))
            },
            [unicodeHighlightConfigKeys.allowedCharacters]: {
                restricted: true,
                type: 'object',
                default: defaults.allowedCharacters,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    118,
                    "Defines allowed characters that are not being highlighted."
                )),
                additionalProperties: {
                    type: 'boolean'
                }
            },
            [unicodeHighlightConfigKeys.allowedLocales]: {
                restricted: true,
                type: 'object',
                additionalProperties: {
                    type: 'boolean'
                },
                default: defaults.allowedLocales,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    119,
                    "Unicode characters that are common in allowed locales are not being highlighted."
                ))
            },
        });
    }
    applyUpdate(value, update) {
        let didChange = false;
        if (update.allowedCharacters && value) {
            if (!(0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_1__.equals)(value.allowedCharacters, update.allowedCharacters)) {
                value = { ...value, allowedCharacters: update.allowedCharacters };
                didChange = true;
            }
        }
        if (update.allowedLocales && value) {
            if (!(0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_1__.equals)(value.allowedLocales, update.allowedLocales)) {
                value = { ...value, allowedLocales: update.allowedLocales };
                didChange = true;
            }
        }
        const result = super.applyUpdate(value, update);
        if (didChange) {
            return (
                 (new ApplyUpdateResult(result.newValue, true))
            );
        }
        return result;
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            nonBasicASCII: primitiveSet(input.nonBasicASCII, inUntrustedWorkspace, [true, false, inUntrustedWorkspace]),
            invisibleCharacters: boolean(input.invisibleCharacters, this.defaultValue.invisibleCharacters),
            ambiguousCharacters: boolean(input.ambiguousCharacters, this.defaultValue.ambiguousCharacters),
            includeComments: primitiveSet(input.includeComments, inUntrustedWorkspace, [true, false, inUntrustedWorkspace]),
            includeStrings: primitiveSet(input.includeStrings, inUntrustedWorkspace, [true, false, inUntrustedWorkspace]),
            allowedCharacters: this.validateBooleanMap(_input.allowedCharacters, this.defaultValue.allowedCharacters),
            allowedLocales: this.validateBooleanMap(_input.allowedLocales, this.defaultValue.allowedLocales),
        };
    }
    validateBooleanMap(map, defaultValue) {
        if ((typeof map !== 'object') || !map) {
            return defaultValue;
        }
        const result = {};
        for (const [key, value] of Object.entries(map)) {
            if (value === true) {
                result[key] = true;
            }
        }
        return result;
    }
}
class InlineEditorSuggest extends BaseEditorOption {
    constructor() {
        const defaults = {
            enabled: true,
            mode: 'subwordSmart',
            showToolbar: 'onHover',
            suppressSuggestions: false,
            keepOnBlur: false,
            fontFamily: 'default'
        };
        super(EditorOption.inlineSuggest, 'inlineSuggest', defaults, {
            'editor.inlineSuggest.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    120,
                    "Controls whether to automatically show inline suggestions in the editor."
                ))
            },
            'editor.inlineSuggest.showToolbar': {
                type: 'string',
                default: defaults.showToolbar,
                enum: ['always', 'onHover', 'never'],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        121,
                        "Show the inline suggestion toolbar whenever an inline suggestion is shown."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        122,
                        "Show the inline suggestion toolbar when hovering over an inline suggestion."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 123, "Never show the inline suggestion toolbar.")),
                ],
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 124, "Controls when to show the inline suggestion toolbar.")),
            },
            'editor.inlineSuggest.suppressSuggestions': {
                type: 'boolean',
                default: defaults.suppressSuggestions,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    125,
                    "Controls how inline suggestions interact with the suggest widget. If enabled, the suggest widget is not shown automatically when inline suggestions are available."
                ))
            },
            'editor.inlineSuggest.fontFamily': {
                type: 'string',
                default: defaults.fontFamily,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 126, "Controls the font family of the inline suggestions."))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            mode: stringSet(input.mode, this.defaultValue.mode, ['prefix', 'subword', 'subwordSmart']),
            showToolbar: stringSet(input.showToolbar, this.defaultValue.showToolbar, ['always', 'onHover', 'never']),
            suppressSuggestions: boolean(input.suppressSuggestions, this.defaultValue.suppressSuggestions),
            keepOnBlur: boolean(input.keepOnBlur, this.defaultValue.keepOnBlur),
            fontFamily: EditorStringOption.string(input.fontFamily, this.defaultValue.fontFamily)
        };
    }
}
class InlineEditorEdit extends BaseEditorOption {
    constructor() {
        const defaults = {
            enabled: false,
            showToolbar: 'onHover',
            fontFamily: 'default',
            keepOnBlur: false,
            backgroundColoring: false,
        };
        super(EditorOption.inlineEdit, 'experimentalInlineEdit', defaults, {
            'editor.experimentalInlineEdit.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 127, "Controls whether to show inline edits in the editor."))
            },
            'editor.experimentalInlineEdit.showToolbar': {
                type: 'string',
                default: defaults.showToolbar,
                enum: ['always', 'onHover', 'never'],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        128,
                        "Show the inline edit toolbar whenever an inline suggestion is shown."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        129,
                        "Show the inline edit toolbar when hovering over an inline suggestion."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 130, "Never show the inline edit toolbar.")),
                ],
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 131, "Controls when to show the inline edit toolbar.")),
            },
            'editor.experimentalInlineEdit.fontFamily': {
                type: 'string',
                default: defaults.fontFamily,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 132, "Controls the font family of the inline edit."))
            },
            'editor.experimentalInlineEdit.backgroundColoring': {
                type: 'boolean',
                default: defaults.backgroundColoring,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    133,
                    "Controls whether to color the background of inline edits."
                ))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            showToolbar: stringSet(input.showToolbar, this.defaultValue.showToolbar, ['always', 'onHover', 'never']),
            fontFamily: EditorStringOption.string(input.fontFamily, this.defaultValue.fontFamily),
            keepOnBlur: boolean(input.keepOnBlur, this.defaultValue.keepOnBlur),
            backgroundColoring: boolean(input.backgroundColoring, this.defaultValue.backgroundColoring)
        };
    }
}
class BracketPairColorization extends BaseEditorOption {
    constructor() {
        const defaults = {
            enabled: _core_textModelDefaults_js__WEBPACK_IMPORTED_MODULE_5__.EDITOR_MODEL_DEFAULTS.bracketPairColorizationOptions.enabled,
            independentColorPoolPerBracketType: _core_textModelDefaults_js__WEBPACK_IMPORTED_MODULE_5__.EDITOR_MODEL_DEFAULTS.bracketPairColorizationOptions.independentColorPoolPerBracketType,
        };
        super(EditorOption.bracketPairColorization, 'bracketPairColorization', defaults, {
            'editor.bracketPairColorization.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    134,
                    "Controls whether bracket pair colorization is enabled or not. Use {0} to override the bracket highlight colors.",
                    '`#workbench.colorCustomizations#`'
                ))
            },
            'editor.bracketPairColorization.independentColorPoolPerBracketType': {
                type: 'boolean',
                default: defaults.independentColorPoolPerBracketType,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    135,
                    "Controls whether each bracket type has its own independent color pool."
                ))
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            independentColorPoolPerBracketType: boolean(input.independentColorPoolPerBracketType, this.defaultValue.independentColorPoolPerBracketType),
        };
    }
}
class GuideOptions extends BaseEditorOption {
    constructor() {
        const defaults = {
            bracketPairs: false,
            bracketPairsHorizontal: 'active',
            highlightActiveBracketPair: true,
            indentation: true,
            highlightActiveIndentation: true
        };
        super(EditorOption.guides, 'guides', defaults, {
            'editor.guides.bracketPairs': {
                type: ['boolean', 'string'],
                enum: [true, 'active', false],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 136, "Enables bracket pair guides.")),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        137,
                        "Enables bracket pair guides only for the active bracket pair."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 138, "Disables bracket pair guides.")),
                ],
                default: defaults.bracketPairs,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 139, "Controls whether bracket pair guides are enabled or not."))
            },
            'editor.guides.bracketPairsHorizontal': {
                type: ['boolean', 'string'],
                enum: [true, 'active', false],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        140,
                        "Enables horizontal guides as addition to vertical bracket pair guides."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        141,
                        "Enables horizontal guides only for the active bracket pair."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 142, "Disables horizontal bracket pair guides.")),
                ],
                default: defaults.bracketPairsHorizontal,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    143,
                    "Controls whether horizontal bracket pair guides are enabled or not."
                ))
            },
            'editor.guides.highlightActiveBracketPair': {
                type: 'boolean',
                default: defaults.highlightActiveBracketPair,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    144,
                    "Controls whether the editor should highlight the active bracket pair."
                ))
            },
            'editor.guides.indentation': {
                type: 'boolean',
                default: defaults.indentation,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 145, "Controls whether the editor should render indent guides."))
            },
            'editor.guides.highlightActiveIndentation': {
                type: ['boolean', 'string'],
                enum: [true, 'always', false],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 146, "Highlights the active indent guide.")),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        147,
                        "Highlights the active indent guide even if bracket guides are highlighted."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 148, "Do not highlight the active indent guide.")),
                ],
                default: defaults.highlightActiveIndentation,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    149,
                    "Controls whether the editor should highlight the active indent guide."
                ))
            }
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            bracketPairs: primitiveSet(input.bracketPairs, this.defaultValue.bracketPairs, [true, false, 'active']),
            bracketPairsHorizontal: primitiveSet(input.bracketPairsHorizontal, this.defaultValue.bracketPairsHorizontal, [true, false, 'active']),
            highlightActiveBracketPair: boolean(input.highlightActiveBracketPair, this.defaultValue.highlightActiveBracketPair),
            indentation: boolean(input.indentation, this.defaultValue.indentation),
            highlightActiveIndentation: primitiveSet(input.highlightActiveIndentation, this.defaultValue.highlightActiveIndentation, [true, false, 'always']),
        };
    }
}
function primitiveSet(value, defaultValue, allowedValues) {
    const idx = allowedValues.indexOf(value);
    if (idx === -1) {
        return defaultValue;
    }
    return allowedValues[idx];
}
class EditorSuggest extends BaseEditorOption {
    constructor() {
        const defaults = {
            insertMode: 'insert',
            filterGraceful: true,
            snippetsPreventQuickSuggestions: false,
            localityBonus: false,
            shareSuggestSelections: false,
            selectionMode: 'always',
            showIcons: true,
            showStatusBar: false,
            preview: false,
            previewMode: 'subwordSmart',
            showInlineDetails: true,
            showMethods: true,
            showFunctions: true,
            showConstructors: true,
            showDeprecated: true,
            matchOnWordStartOnly: true,
            showFields: true,
            showVariables: true,
            showClasses: true,
            showStructs: true,
            showInterfaces: true,
            showModules: true,
            showProperties: true,
            showEvents: true,
            showOperators: true,
            showUnits: true,
            showValues: true,
            showConstants: true,
            showEnums: true,
            showEnumMembers: true,
            showKeywords: true,
            showWords: true,
            showColors: true,
            showFiles: true,
            showReferences: true,
            showFolders: true,
            showTypeParameters: true,
            showSnippets: true,
            showUsers: true,
            showIssues: true,
        };
        super(EditorOption.suggest, 'suggest', defaults, {
            'editor.suggest.insertMode': {
                type: 'string',
                enum: ['insert', 'replace'],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        150,
                        "Insert suggestion without overwriting text right of the cursor."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        151,
                        "Insert suggestion and overwrite text right of the cursor."
                    )),
                ],
                default: defaults.insertMode,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    152,
                    "Controls whether words are overwritten when accepting completions. Note that this depends on extensions opting into this feature."
                ))
            },
            'editor.suggest.filterGraceful': {
                type: 'boolean',
                default: defaults.filterGraceful,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    153,
                    "Controls whether filtering and sorting suggestions accounts for small typos."
                ))
            },
            'editor.suggest.localityBonus': {
                type: 'boolean',
                default: defaults.localityBonus,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    154,
                    "Controls whether sorting favors words that appear close to the cursor."
                ))
            },
            'editor.suggest.shareSuggestSelections': {
                type: 'boolean',
                default: defaults.shareSuggestSelections,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    155,
                    "Controls whether remembered suggestion selections are shared between multiple workspaces and windows (needs `#editor.suggestSelection#`)."
                ))
            },
            'editor.suggest.selectionMode': {
                type: 'string',
                enum: ['always', 'never', 'whenTriggerCharacter', 'whenQuickSuggestion'],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        156,
                        "Always select a suggestion when automatically triggering IntelliSense."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        157,
                        "Never select a suggestion when automatically triggering IntelliSense."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        158,
                        "Select a suggestion only when triggering IntelliSense from a trigger character."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        159,
                        "Select a suggestion only when triggering IntelliSense as you type."
                    )),
                ],
                default: defaults.selectionMode,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    160,
                    "Controls whether a suggestion is selected when the widget shows. Note that this only applies to automatically triggered suggestions ({0} and {1}) and that a suggestion is always selected when explicitly invoked, e.g via `Ctrl+Space`.",
                    '`#editor.quickSuggestions#`',
                    '`#editor.suggestOnTriggerCharacters#`'
                ))
            },
            'editor.suggest.snippetsPreventQuickSuggestions': {
                type: 'boolean',
                default: defaults.snippetsPreventQuickSuggestions,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    161,
                    "Controls whether an active snippet prevents quick suggestions."
                ))
            },
            'editor.suggest.showIcons': {
                type: 'boolean',
                default: defaults.showIcons,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 162, "Controls whether to show or hide icons in suggestions."))
            },
            'editor.suggest.showStatusBar': {
                type: 'boolean',
                default: defaults.showStatusBar,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    163,
                    "Controls the visibility of the status bar at the bottom of the suggest widget."
                ))
            },
            'editor.suggest.preview': {
                type: 'boolean',
                default: defaults.preview,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    164,
                    "Controls whether to preview the suggestion outcome in the editor."
                ))
            },
            'editor.suggest.showInlineDetails': {
                type: 'boolean',
                default: defaults.showInlineDetails,
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    165,
                    "Controls whether suggest details show inline with the label or only in the details widget."
                ))
            },
            'editor.suggest.maxVisibleSuggestions': {
                type: 'number',
                deprecationMessage: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    166,
                    "This setting is deprecated. The suggest widget can now be resized."
                )),
            },
            'editor.suggest.filteredTypes': {
                type: 'object',
                deprecationMessage: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    167,
                    "This setting is deprecated, please use separate settings like 'editor.suggest.showKeywords' or 'editor.suggest.showSnippets' instead."
                ))
            },
            'editor.suggest.showMethods': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 168, "When enabled IntelliSense shows `method`-suggestions."))
            },
            'editor.suggest.showFunctions': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 169, "When enabled IntelliSense shows `function`-suggestions."))
            },
            'editor.suggest.showConstructors': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    170,
                    "When enabled IntelliSense shows `constructor`-suggestions."
                ))
            },
            'editor.suggest.showDeprecated': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    171,
                    "When enabled IntelliSense shows `deprecated`-suggestions."
                ))
            },
            'editor.suggest.matchOnWordStartOnly': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    172,
                    "When enabled IntelliSense filtering requires that the first character matches on a word start. For example, `c` on `Console` or `WebContext` but _not_ on `description`. When disabled IntelliSense will show more results but still sorts them by match quality."
                ))
            },
            'editor.suggest.showFields': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 173, "When enabled IntelliSense shows `field`-suggestions."))
            },
            'editor.suggest.showVariables': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 174, "When enabled IntelliSense shows `variable`-suggestions."))
            },
            'editor.suggest.showClasses': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 175, "When enabled IntelliSense shows `class`-suggestions."))
            },
            'editor.suggest.showStructs': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 176, "When enabled IntelliSense shows `struct`-suggestions."))
            },
            'editor.suggest.showInterfaces': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 177, "When enabled IntelliSense shows `interface`-suggestions."))
            },
            'editor.suggest.showModules': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 178, "When enabled IntelliSense shows `module`-suggestions."))
            },
            'editor.suggest.showProperties': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 179, "When enabled IntelliSense shows `property`-suggestions."))
            },
            'editor.suggest.showEvents': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 180, "When enabled IntelliSense shows `event`-suggestions."))
            },
            'editor.suggest.showOperators': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 181, "When enabled IntelliSense shows `operator`-suggestions."))
            },
            'editor.suggest.showUnits': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 182, "When enabled IntelliSense shows `unit`-suggestions."))
            },
            'editor.suggest.showValues': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 183, "When enabled IntelliSense shows `value`-suggestions."))
            },
            'editor.suggest.showConstants': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 184, "When enabled IntelliSense shows `constant`-suggestions."))
            },
            'editor.suggest.showEnums': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 185, "When enabled IntelliSense shows `enum`-suggestions."))
            },
            'editor.suggest.showEnumMembers': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    186,
                    "When enabled IntelliSense shows `enumMember`-suggestions."
                ))
            },
            'editor.suggest.showKeywords': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 187, "When enabled IntelliSense shows `keyword`-suggestions."))
            },
            'editor.suggest.showWords': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 188, "When enabled IntelliSense shows `text`-suggestions."))
            },
            'editor.suggest.showColors': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 189, "When enabled IntelliSense shows `color`-suggestions."))
            },
            'editor.suggest.showFiles': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 190, "When enabled IntelliSense shows `file`-suggestions."))
            },
            'editor.suggest.showReferences': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 191, "When enabled IntelliSense shows `reference`-suggestions."))
            },
            'editor.suggest.showCustomcolors': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    192,
                    "When enabled IntelliSense shows `customcolor`-suggestions."
                ))
            },
            'editor.suggest.showFolders': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 193, "When enabled IntelliSense shows `folder`-suggestions."))
            },
            'editor.suggest.showTypeParameters': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    194,
                    "When enabled IntelliSense shows `typeParameter`-suggestions."
                ))
            },
            'editor.suggest.showSnippets': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 195, "When enabled IntelliSense shows `snippet`-suggestions."))
            },
            'editor.suggest.showUsers': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 196, "When enabled IntelliSense shows `user`-suggestions."))
            },
            'editor.suggest.showIssues': {
                type: 'boolean',
                default: true,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 197, "When enabled IntelliSense shows `issues`-suggestions."))
            }
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            insertMode: stringSet(input.insertMode, this.defaultValue.insertMode, ['insert', 'replace']),
            filterGraceful: boolean(input.filterGraceful, this.defaultValue.filterGraceful),
            snippetsPreventQuickSuggestions: boolean(input.snippetsPreventQuickSuggestions, this.defaultValue.filterGraceful),
            localityBonus: boolean(input.localityBonus, this.defaultValue.localityBonus),
            shareSuggestSelections: boolean(input.shareSuggestSelections, this.defaultValue.shareSuggestSelections),
            selectionMode: stringSet(input.selectionMode, this.defaultValue.selectionMode, ['always', 'never', 'whenQuickSuggestion', 'whenTriggerCharacter']),
            showIcons: boolean(input.showIcons, this.defaultValue.showIcons),
            showStatusBar: boolean(input.showStatusBar, this.defaultValue.showStatusBar),
            preview: boolean(input.preview, this.defaultValue.preview),
            previewMode: stringSet(input.previewMode, this.defaultValue.previewMode, ['prefix', 'subword', 'subwordSmart']),
            showInlineDetails: boolean(input.showInlineDetails, this.defaultValue.showInlineDetails),
            showMethods: boolean(input.showMethods, this.defaultValue.showMethods),
            showFunctions: boolean(input.showFunctions, this.defaultValue.showFunctions),
            showConstructors: boolean(input.showConstructors, this.defaultValue.showConstructors),
            showDeprecated: boolean(input.showDeprecated, this.defaultValue.showDeprecated),
            matchOnWordStartOnly: boolean(input.matchOnWordStartOnly, this.defaultValue.matchOnWordStartOnly),
            showFields: boolean(input.showFields, this.defaultValue.showFields),
            showVariables: boolean(input.showVariables, this.defaultValue.showVariables),
            showClasses: boolean(input.showClasses, this.defaultValue.showClasses),
            showStructs: boolean(input.showStructs, this.defaultValue.showStructs),
            showInterfaces: boolean(input.showInterfaces, this.defaultValue.showInterfaces),
            showModules: boolean(input.showModules, this.defaultValue.showModules),
            showProperties: boolean(input.showProperties, this.defaultValue.showProperties),
            showEvents: boolean(input.showEvents, this.defaultValue.showEvents),
            showOperators: boolean(input.showOperators, this.defaultValue.showOperators),
            showUnits: boolean(input.showUnits, this.defaultValue.showUnits),
            showValues: boolean(input.showValues, this.defaultValue.showValues),
            showConstants: boolean(input.showConstants, this.defaultValue.showConstants),
            showEnums: boolean(input.showEnums, this.defaultValue.showEnums),
            showEnumMembers: boolean(input.showEnumMembers, this.defaultValue.showEnumMembers),
            showKeywords: boolean(input.showKeywords, this.defaultValue.showKeywords),
            showWords: boolean(input.showWords, this.defaultValue.showWords),
            showColors: boolean(input.showColors, this.defaultValue.showColors),
            showFiles: boolean(input.showFiles, this.defaultValue.showFiles),
            showReferences: boolean(input.showReferences, this.defaultValue.showReferences),
            showFolders: boolean(input.showFolders, this.defaultValue.showFolders),
            showTypeParameters: boolean(input.showTypeParameters, this.defaultValue.showTypeParameters),
            showSnippets: boolean(input.showSnippets, this.defaultValue.showSnippets),
            showUsers: boolean(input.showUsers, this.defaultValue.showUsers),
            showIssues: boolean(input.showIssues, this.defaultValue.showIssues),
        };
    }
}
class SmartSelect extends BaseEditorOption {
    constructor() {
        super(EditorOption.smartSelect, 'smartSelect', {
            selectLeadingAndTrailingWhitespace: true,
            selectSubwords: true,
        }, {
            'editor.smartSelect.selectLeadingAndTrailingWhitespace': {
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    198,
                    "Whether leading and trailing whitespace should always be selected."
                )),
                default: true,
                type: 'boolean'
            },
            'editor.smartSelect.selectSubwords': {
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    199,
                    "Whether subwords (like 'foo' in 'fooBar' or 'foo_bar') should be selected."
                )),
                default: true,
                type: 'boolean'
            }
        });
    }
    validate(input) {
        if (!input || typeof input !== 'object') {
            return this.defaultValue;
        }
        return {
            selectLeadingAndTrailingWhitespace: boolean(input.selectLeadingAndTrailingWhitespace, this.defaultValue.selectLeadingAndTrailingWhitespace),
            selectSubwords: boolean(input.selectSubwords, this.defaultValue.selectSubwords),
        };
    }
}
class WordSegmenterLocales extends BaseEditorOption {
    constructor() {
        const defaults = [];
        super(EditorOption.wordSegmenterLocales, 'wordSegmenterLocales', defaults, {
            anyOf: [
                {
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        200,
                        "Locales to be used for word segmentation when doing word related navigations or operations. Specify the BCP 47 language tag of the word you wish to recognize (e.g., ja, zh-CN, zh-Hant-TW, etc.)."
                    )),
                    type: 'string',
                }, {
                    description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        200,
                        "Locales to be used for word segmentation when doing word related navigations or operations. Specify the BCP 47 language tag of the word you wish to recognize (e.g., ja, zh-CN, zh-Hant-TW, etc.)."
                    )),
                    type: 'array',
                    items: {
                        type: 'string'
                    }
                }
            ]
        });
    }
    validate(input) {
        if (typeof input === 'string') {
            input = [input];
        }
        if (Array.isArray(input)) {
            const validLocales = [];
            for (const locale of input) {
                if (typeof locale === 'string') {
                    try {
                        if (Intl.Segmenter.supportedLocalesOf(locale).length > 0) {
                            validLocales.push(locale);
                        }
                    }
                    catch {
                    }
                }
            }
            return validLocales;
        }
        return this.defaultValue;
    }
}
var WrappingIndent;
( ((function(WrappingIndent) {
    WrappingIndent[WrappingIndent["None"] = 0] = "None";
    WrappingIndent[WrappingIndent["Same"] = 1] = "Same";
    WrappingIndent[WrappingIndent["Indent"] = 2] = "Indent";
    WrappingIndent[WrappingIndent["DeepIndent"] = 3] = "DeepIndent";
})(WrappingIndent || (WrappingIndent = {}))));
class WrappingIndentOption extends BaseEditorOption {
    constructor() {
        super(EditorOption.wrappingIndent, 'wrappingIndent', WrappingIndent.Same, {
            'editor.wrappingIndent': {
                type: 'string',
                enum: ['none', 'same', 'indent', 'deepIndent'],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 201, "No indentation. Wrapped lines begin at column 1.")),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 202, "Wrapped lines get the same indentation as the parent.")),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 203, "Wrapped lines get +1 indentation toward the parent.")),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 204, "Wrapped lines get +2 indentation toward the parent.")),
                ],
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 205, "Controls the indentation of wrapped lines.")),
                default: 'same'
            }
        });
    }
    validate(input) {
        switch (input) {
            case 'none': return WrappingIndent.None;
            case 'same': return WrappingIndent.Same;
            case 'indent': return WrappingIndent.Indent;
            case 'deepIndent': return WrappingIndent.DeepIndent;
        }
        return WrappingIndent.Same;
    }
    compute(env, options, value) {
        const accessibilitySupport = options.get(EditorOption.accessibilitySupport);
        if (accessibilitySupport === _platform_accessibility_common_accessibility_js__WEBPACK_IMPORTED_MODULE_8__.AccessibilitySupport.Enabled) {
            return WrappingIndent.None;
        }
        return value;
    }
}
class EditorWrappingInfoComputer extends ComputedEditorOption {
    constructor() {
        super(EditorOption.wrappingInfo);
    }
    compute(env, options, _) {
        const layoutInfo = options.get(EditorOption.layoutInfo);
        return {
            isDominatedByLongLines: env.isDominatedByLongLines,
            isWordWrapMinified: layoutInfo.isWordWrapMinified,
            isViewportWrapping: layoutInfo.isViewportWrapping,
            wrappingColumn: layoutInfo.wrappingColumn,
        };
    }
}
class EditorDropIntoEditor extends BaseEditorOption {
    constructor() {
        const defaults = { enabled: true, showDropSelector: 'afterDrop' };
        super(EditorOption.dropIntoEditor, 'dropIntoEditor', defaults, {
            'editor.dropIntoEditor.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    206,
                    "Controls whether you can drag and drop a file into a text editor by holding down the `Shift` key (instead of opening the file in an editor)."
                )),
            },
            'editor.dropIntoEditor.showDropSelector': {
                type: 'string',
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    207,
                    "Controls if a widget is shown when dropping files into the editor. This widget lets you control how the file is dropped."
                )),
                enum: [
                    'afterDrop',
                    'never'
                ],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        208,
                        "Show the drop selector widget after a file is dropped into the editor."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        209,
                        "Never show the drop selector widget. Instead the default drop provider is always used."
                    )),
                ],
                default: 'afterDrop',
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            showDropSelector: stringSet(input.showDropSelector, this.defaultValue.showDropSelector, ['afterDrop', 'never']),
        };
    }
}
class EditorPasteAs extends BaseEditorOption {
    constructor() {
        const defaults = { enabled: true, showPasteSelector: 'afterPaste' };
        super(EditorOption.pasteAs, 'pasteAs', defaults, {
            'editor.pasteAs.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    210,
                    "Controls whether you can paste content in different ways."
                )),
            },
            'editor.pasteAs.showPasteSelector': {
                type: 'string',
                markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    211,
                    "Controls if a widget is shown when pasting content in to the editor. This widget lets you control how the file is pasted."
                )),
                enum: [
                    'afterPaste',
                    'never'
                ],
                enumDescriptions: [
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        212,
                        "Show the paste selector widget after content is pasted into the editor."
                    )),
                    ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                        _moduleId,
                        213,
                        "Never show the paste selector widget. Instead the default pasting behavior is always used."
                    )),
                ],
                default: 'afterPaste',
            },
        });
    }
    validate(_input) {
        if (!_input || typeof _input !== 'object') {
            return this.defaultValue;
        }
        const input = _input;
        return {
            enabled: boolean(input.enabled, this.defaultValue.enabled),
            showPasteSelector: stringSet(input.showPasteSelector, this.defaultValue.showPasteSelector, ['afterPaste', 'never']),
        };
    }
}
const DEFAULT_WINDOWS_FONT_FAMILY = 'Consolas, \'Courier New\', monospace';
const DEFAULT_MAC_FONT_FAMILY = 'Menlo, Monaco, \'Courier New\', monospace';
const DEFAULT_LINUX_FONT_FAMILY = '\'Droid Sans Mono\', \'monospace\', monospace';
const EDITOR_FONT_DEFAULTS = {
    fontFamily: (_base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isMacintosh ? DEFAULT_MAC_FONT_FAMILY : (_base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isLinux ? DEFAULT_LINUX_FONT_FAMILY : DEFAULT_WINDOWS_FONT_FAMILY)),
    fontWeight: 'normal',
    fontSize: (_base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isMacintosh ? 12 : 14),
    lineHeight: 0,
    letterSpacing: 0,
};
const editorOptionsRegistry = [];
function register(option) {
    editorOptionsRegistry[option.id] = option;
    return option;
}
var EditorOption;
( ((function(EditorOption) {
    EditorOption[EditorOption["acceptSuggestionOnCommitCharacter"] = 0] = "acceptSuggestionOnCommitCharacter";
    EditorOption[EditorOption["acceptSuggestionOnEnter"] = 1] = "acceptSuggestionOnEnter";
    EditorOption[EditorOption["accessibilitySupport"] = 2] = "accessibilitySupport";
    EditorOption[EditorOption["accessibilityPageSize"] = 3] = "accessibilityPageSize";
    EditorOption[EditorOption["ariaLabel"] = 4] = "ariaLabel";
    EditorOption[EditorOption["ariaRequired"] = 5] = "ariaRequired";
    EditorOption[EditorOption["autoClosingBrackets"] = 6] = "autoClosingBrackets";
    EditorOption[EditorOption["autoClosingComments"] = 7] = "autoClosingComments";
    EditorOption[EditorOption["screenReaderAnnounceInlineSuggestion"] = 8] = "screenReaderAnnounceInlineSuggestion";
    EditorOption[EditorOption["autoClosingDelete"] = 9] = "autoClosingDelete";
    EditorOption[EditorOption["autoClosingOvertype"] = 10] = "autoClosingOvertype";
    EditorOption[EditorOption["autoClosingQuotes"] = 11] = "autoClosingQuotes";
    EditorOption[EditorOption["autoIndent"] = 12] = "autoIndent";
    EditorOption[EditorOption["automaticLayout"] = 13] = "automaticLayout";
    EditorOption[EditorOption["autoSurround"] = 14] = "autoSurround";
    EditorOption[EditorOption["bracketPairColorization"] = 15] = "bracketPairColorization";
    EditorOption[EditorOption["guides"] = 16] = "guides";
    EditorOption[EditorOption["codeLens"] = 17] = "codeLens";
    EditorOption[EditorOption["codeLensFontFamily"] = 18] = "codeLensFontFamily";
    EditorOption[EditorOption["codeLensFontSize"] = 19] = "codeLensFontSize";
    EditorOption[EditorOption["colorDecorators"] = 20] = "colorDecorators";
    EditorOption[EditorOption["colorDecoratorsLimit"] = 21] = "colorDecoratorsLimit";
    EditorOption[EditorOption["columnSelection"] = 22] = "columnSelection";
    EditorOption[EditorOption["comments"] = 23] = "comments";
    EditorOption[EditorOption["contextmenu"] = 24] = "contextmenu";
    EditorOption[EditorOption["copyWithSyntaxHighlighting"] = 25] = "copyWithSyntaxHighlighting";
    EditorOption[EditorOption["cursorBlinking"] = 26] = "cursorBlinking";
    EditorOption[EditorOption["cursorSmoothCaretAnimation"] = 27] = "cursorSmoothCaretAnimation";
    EditorOption[EditorOption["cursorStyle"] = 28] = "cursorStyle";
    EditorOption[EditorOption["cursorSurroundingLines"] = 29] = "cursorSurroundingLines";
    EditorOption[EditorOption["cursorSurroundingLinesStyle"] = 30] = "cursorSurroundingLinesStyle";
    EditorOption[EditorOption["cursorWidth"] = 31] = "cursorWidth";
    EditorOption[EditorOption["disableLayerHinting"] = 32] = "disableLayerHinting";
    EditorOption[EditorOption["disableMonospaceOptimizations"] = 33] = "disableMonospaceOptimizations";
    EditorOption[EditorOption["domReadOnly"] = 34] = "domReadOnly";
    EditorOption[EditorOption["dragAndDrop"] = 35] = "dragAndDrop";
    EditorOption[EditorOption["dropIntoEditor"] = 36] = "dropIntoEditor";
    EditorOption[EditorOption["emptySelectionClipboard"] = 37] = "emptySelectionClipboard";
    EditorOption[EditorOption["experimentalWhitespaceRendering"] = 38] = "experimentalWhitespaceRendering";
    EditorOption[EditorOption["extraEditorClassName"] = 39] = "extraEditorClassName";
    EditorOption[EditorOption["fastScrollSensitivity"] = 40] = "fastScrollSensitivity";
    EditorOption[EditorOption["find"] = 41] = "find";
    EditorOption[EditorOption["fixedOverflowWidgets"] = 42] = "fixedOverflowWidgets";
    EditorOption[EditorOption["folding"] = 43] = "folding";
    EditorOption[EditorOption["foldingStrategy"] = 44] = "foldingStrategy";
    EditorOption[EditorOption["foldingHighlight"] = 45] = "foldingHighlight";
    EditorOption[EditorOption["foldingImportsByDefault"] = 46] = "foldingImportsByDefault";
    EditorOption[EditorOption["foldingMaximumRegions"] = 47] = "foldingMaximumRegions";
    EditorOption[EditorOption["unfoldOnClickAfterEndOfLine"] = 48] = "unfoldOnClickAfterEndOfLine";
    EditorOption[EditorOption["fontFamily"] = 49] = "fontFamily";
    EditorOption[EditorOption["fontInfo"] = 50] = "fontInfo";
    EditorOption[EditorOption["fontLigatures"] = 51] = "fontLigatures";
    EditorOption[EditorOption["fontSize"] = 52] = "fontSize";
    EditorOption[EditorOption["fontWeight"] = 53] = "fontWeight";
    EditorOption[EditorOption["fontVariations"] = 54] = "fontVariations";
    EditorOption[EditorOption["formatOnPaste"] = 55] = "formatOnPaste";
    EditorOption[EditorOption["formatOnType"] = 56] = "formatOnType";
    EditorOption[EditorOption["glyphMargin"] = 57] = "glyphMargin";
    EditorOption[EditorOption["gotoLocation"] = 58] = "gotoLocation";
    EditorOption[EditorOption["hideCursorInOverviewRuler"] = 59] = "hideCursorInOverviewRuler";
    EditorOption[EditorOption["hover"] = 60] = "hover";
    EditorOption[EditorOption["inDiffEditor"] = 61] = "inDiffEditor";
    EditorOption[EditorOption["inlineSuggest"] = 62] = "inlineSuggest";
    EditorOption[EditorOption["inlineEdit"] = 63] = "inlineEdit";
    EditorOption[EditorOption["letterSpacing"] = 64] = "letterSpacing";
    EditorOption[EditorOption["lightbulb"] = 65] = "lightbulb";
    EditorOption[EditorOption["lineDecorationsWidth"] = 66] = "lineDecorationsWidth";
    EditorOption[EditorOption["lineHeight"] = 67] = "lineHeight";
    EditorOption[EditorOption["lineNumbers"] = 68] = "lineNumbers";
    EditorOption[EditorOption["lineNumbersMinChars"] = 69] = "lineNumbersMinChars";
    EditorOption[EditorOption["linkedEditing"] = 70] = "linkedEditing";
    EditorOption[EditorOption["links"] = 71] = "links";
    EditorOption[EditorOption["matchBrackets"] = 72] = "matchBrackets";
    EditorOption[EditorOption["minimap"] = 73] = "minimap";
    EditorOption[EditorOption["mouseStyle"] = 74] = "mouseStyle";
    EditorOption[EditorOption["mouseWheelScrollSensitivity"] = 75] = "mouseWheelScrollSensitivity";
    EditorOption[EditorOption["mouseWheelZoom"] = 76] = "mouseWheelZoom";
    EditorOption[EditorOption["multiCursorMergeOverlapping"] = 77] = "multiCursorMergeOverlapping";
    EditorOption[EditorOption["multiCursorModifier"] = 78] = "multiCursorModifier";
    EditorOption[EditorOption["multiCursorPaste"] = 79] = "multiCursorPaste";
    EditorOption[EditorOption["multiCursorLimit"] = 80] = "multiCursorLimit";
    EditorOption[EditorOption["occurrencesHighlight"] = 81] = "occurrencesHighlight";
    EditorOption[EditorOption["overviewRulerBorder"] = 82] = "overviewRulerBorder";
    EditorOption[EditorOption["overviewRulerLanes"] = 83] = "overviewRulerLanes";
    EditorOption[EditorOption["padding"] = 84] = "padding";
    EditorOption[EditorOption["pasteAs"] = 85] = "pasteAs";
    EditorOption[EditorOption["parameterHints"] = 86] = "parameterHints";
    EditorOption[EditorOption["peekWidgetDefaultFocus"] = 87] = "peekWidgetDefaultFocus";
    EditorOption[EditorOption["placeholder"] = 88] = "placeholder";
    EditorOption[EditorOption["definitionLinkOpensInPeek"] = 89] = "definitionLinkOpensInPeek";
    EditorOption[EditorOption["quickSuggestions"] = 90] = "quickSuggestions";
    EditorOption[EditorOption["quickSuggestionsDelay"] = 91] = "quickSuggestionsDelay";
    EditorOption[EditorOption["readOnly"] = 92] = "readOnly";
    EditorOption[EditorOption["readOnlyMessage"] = 93] = "readOnlyMessage";
    EditorOption[EditorOption["renameOnType"] = 94] = "renameOnType";
    EditorOption[EditorOption["renderControlCharacters"] = 95] = "renderControlCharacters";
    EditorOption[EditorOption["renderFinalNewline"] = 96] = "renderFinalNewline";
    EditorOption[EditorOption["renderLineHighlight"] = 97] = "renderLineHighlight";
    EditorOption[EditorOption["renderLineHighlightOnlyWhenFocus"] = 98] = "renderLineHighlightOnlyWhenFocus";
    EditorOption[EditorOption["renderValidationDecorations"] = 99] = "renderValidationDecorations";
    EditorOption[EditorOption["renderWhitespace"] = 100] = "renderWhitespace";
    EditorOption[EditorOption["revealHorizontalRightPadding"] = 101] = "revealHorizontalRightPadding";
    EditorOption[EditorOption["roundedSelection"] = 102] = "roundedSelection";
    EditorOption[EditorOption["rulers"] = 103] = "rulers";
    EditorOption[EditorOption["scrollbar"] = 104] = "scrollbar";
    EditorOption[EditorOption["scrollBeyondLastColumn"] = 105] = "scrollBeyondLastColumn";
    EditorOption[EditorOption["scrollBeyondLastLine"] = 106] = "scrollBeyondLastLine";
    EditorOption[EditorOption["scrollPredominantAxis"] = 107] = "scrollPredominantAxis";
    EditorOption[EditorOption["selectionClipboard"] = 108] = "selectionClipboard";
    EditorOption[EditorOption["selectionHighlight"] = 109] = "selectionHighlight";
    EditorOption[EditorOption["selectOnLineNumbers"] = 110] = "selectOnLineNumbers";
    EditorOption[EditorOption["showFoldingControls"] = 111] = "showFoldingControls";
    EditorOption[EditorOption["showUnused"] = 112] = "showUnused";
    EditorOption[EditorOption["snippetSuggestions"] = 113] = "snippetSuggestions";
    EditorOption[EditorOption["smartSelect"] = 114] = "smartSelect";
    EditorOption[EditorOption["smoothScrolling"] = 115] = "smoothScrolling";
    EditorOption[EditorOption["stickyScroll"] = 116] = "stickyScroll";
    EditorOption[EditorOption["stickyTabStops"] = 117] = "stickyTabStops";
    EditorOption[EditorOption["stopRenderingLineAfter"] = 118] = "stopRenderingLineAfter";
    EditorOption[EditorOption["suggest"] = 119] = "suggest";
    EditorOption[EditorOption["suggestFontSize"] = 120] = "suggestFontSize";
    EditorOption[EditorOption["suggestLineHeight"] = 121] = "suggestLineHeight";
    EditorOption[EditorOption["suggestOnTriggerCharacters"] = 122] = "suggestOnTriggerCharacters";
    EditorOption[EditorOption["suggestSelection"] = 123] = "suggestSelection";
    EditorOption[EditorOption["tabCompletion"] = 124] = "tabCompletion";
    EditorOption[EditorOption["tabIndex"] = 125] = "tabIndex";
    EditorOption[EditorOption["unicodeHighlighting"] = 126] = "unicodeHighlighting";
    EditorOption[EditorOption["unusualLineTerminators"] = 127] = "unusualLineTerminators";
    EditorOption[EditorOption["useShadowDOM"] = 128] = "useShadowDOM";
    EditorOption[EditorOption["useTabStops"] = 129] = "useTabStops";
    EditorOption[EditorOption["wordBreak"] = 130] = "wordBreak";
    EditorOption[EditorOption["wordSegmenterLocales"] = 131] = "wordSegmenterLocales";
    EditorOption[EditorOption["wordSeparators"] = 132] = "wordSeparators";
    EditorOption[EditorOption["wordWrap"] = 133] = "wordWrap";
    EditorOption[EditorOption["wordWrapBreakAfterCharacters"] = 134] = "wordWrapBreakAfterCharacters";
    EditorOption[EditorOption["wordWrapBreakBeforeCharacters"] = 135] = "wordWrapBreakBeforeCharacters";
    EditorOption[EditorOption["wordWrapColumn"] = 136] = "wordWrapColumn";
    EditorOption[EditorOption["wordWrapOverride1"] = 137] = "wordWrapOverride1";
    EditorOption[EditorOption["wordWrapOverride2"] = 138] = "wordWrapOverride2";
    EditorOption[EditorOption["wrappingIndent"] = 139] = "wrappingIndent";
    EditorOption[EditorOption["wrappingStrategy"] = 140] = "wrappingStrategy";
    EditorOption[EditorOption["showDeprecated"] = 141] = "showDeprecated";
    EditorOption[EditorOption["inlayHints"] = 142] = "inlayHints";
    EditorOption[EditorOption["editorClassName"] = 143] = "editorClassName";
    EditorOption[EditorOption["pixelRatio"] = 144] = "pixelRatio";
    EditorOption[EditorOption["tabFocusMode"] = 145] = "tabFocusMode";
    EditorOption[EditorOption["layoutInfo"] = 146] = "layoutInfo";
    EditorOption[EditorOption["wrappingInfo"] = 147] = "wrappingInfo";
    EditorOption[EditorOption["defaultColorDecorators"] = 148] = "defaultColorDecorators";
    EditorOption[EditorOption["colorDecoratorsActivatedOn"] = 149] = "colorDecoratorsActivatedOn";
    EditorOption[EditorOption["inlineCompletionsAccessibilityVerbose"] = 150] = "inlineCompletionsAccessibilityVerbose";
})(EditorOption || (EditorOption = {}))));
const EditorOptions = {
    acceptSuggestionOnCommitCharacter: register(( (new EditorBooleanOption(
        EditorOption.acceptSuggestionOnCommitCharacter,
        'acceptSuggestionOnCommitCharacter',
        true,
        { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            214,
            "Controls whether suggestions should be accepted on commit characters. For example, in JavaScript, the semi-colon (`;`) can be a commit character that accepts a suggestion and types that character."
        )) }
    )))),
    acceptSuggestionOnEnter: register(( (new EditorStringEnumOption(
        EditorOption.acceptSuggestionOnEnter,
        'acceptSuggestionOnEnter',
        'on',
        ['on', 'smart', 'off'],
        {
            markdownEnumDescriptions: [
                '',
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    215,
                    "Only accept a suggestion with `Enter` when it makes a textual change."
                )),
                ''
            ],
            markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                216,
                "Controls whether suggestions should be accepted on `Enter`, in addition to `Tab`. Helps to avoid ambiguity between inserting new lines or accepting suggestions."
            ))
        }
    )))),
    accessibilitySupport: register(( (new EditorAccessibilitySupport()))),
    accessibilityPageSize: register(( (new EditorIntOption(
        EditorOption.accessibilityPageSize,
        'accessibilityPageSize',
        10,
        1,
        _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__.Constants.MAX_SAFE_SMALL_INTEGER,
        {
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                217,
                "Controls the number of lines in the editor that can be read out by a screen reader at once. When we detect a screen reader we automatically set the default to be 500. Warning: this has a performance implication for numbers larger than the default."
            )),
            tags: ['accessibility']
        }
    )))),
    ariaLabel: register(( (new EditorStringOption(EditorOption.ariaLabel, 'ariaLabel', ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 218, "Editor content")))))),
    ariaRequired: register(( (new EditorBooleanOption(EditorOption.ariaRequired, 'ariaRequired', false, undefined)))),
    screenReaderAnnounceInlineSuggestion: register(( (new EditorBooleanOption(
        EditorOption.screenReaderAnnounceInlineSuggestion,
        'screenReaderAnnounceInlineSuggestion',
        true,
        {
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                219,
                "Control whether inline suggestions are announced by a screen reader."
            )),
            tags: ['accessibility']
        }
    )))),
    autoClosingBrackets: register(( (new EditorStringEnumOption(
        EditorOption.autoClosingBrackets,
        'autoClosingBrackets',
        'languageDefined',
        ['always', 'languageDefined', 'beforeWhitespace', 'never'],
        {
            enumDescriptions: [
                '',
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    220,
                    "Use language configurations to determine when to autoclose brackets."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    221,
                    "Autoclose brackets only when the cursor is to the left of whitespace."
                )),
                '',
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                222,
                "Controls whether the editor should automatically close brackets after the user adds an opening bracket."
            ))
        }
    )))),
    autoClosingComments: register(( (new EditorStringEnumOption(
        EditorOption.autoClosingComments,
        'autoClosingComments',
        'languageDefined',
        ['always', 'languageDefined', 'beforeWhitespace', 'never'],
        {
            enumDescriptions: [
                '',
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    223,
                    "Use language configurations to determine when to autoclose comments."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    224,
                    "Autoclose comments only when the cursor is to the left of whitespace."
                )),
                '',
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                225,
                "Controls whether the editor should automatically close comments after the user adds an opening comment."
            ))
        }
    )))),
    autoClosingDelete: register(( (new EditorStringEnumOption(
        EditorOption.autoClosingDelete,
        'autoClosingDelete',
        'auto',
        ['always', 'auto', 'never'],
        {
            enumDescriptions: [
                '',
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    226,
                    "Remove adjacent closing quotes or brackets only if they were automatically inserted."
                )),
                '',
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                227,
                "Controls whether the editor should remove adjacent closing quotes or brackets when deleting."
            ))
        }
    )))),
    autoClosingOvertype: register(( (new EditorStringEnumOption(
        EditorOption.autoClosingOvertype,
        'autoClosingOvertype',
        'auto',
        ['always', 'auto', 'never'],
        {
            enumDescriptions: [
                '',
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    228,
                    "Type over closing quotes or brackets only if they were automatically inserted."
                )),
                '',
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                229,
                "Controls whether the editor should type over closing quotes or brackets."
            ))
        }
    )))),
    autoClosingQuotes: register(( (new EditorStringEnumOption(
        EditorOption.autoClosingQuotes,
        'autoClosingQuotes',
        'languageDefined',
        ['always', 'languageDefined', 'beforeWhitespace', 'never'],
        {
            enumDescriptions: [
                '',
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    230,
                    "Use language configurations to determine when to autoclose quotes."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    231,
                    "Autoclose quotes only when the cursor is to the left of whitespace."
                )),
                '',
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                232,
                "Controls whether the editor should automatically close quotes after the user adds an opening quote."
            ))
        }
    )))),
    autoIndent: register(( (new EditorEnumOption(
        EditorOption.autoIndent,
        'autoIndent',
        EditorAutoIndentStrategy.Full,
        'full',
        ['none', 'keep', 'brackets', 'advanced', 'full'],
        _autoIndentFromString,
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 233, "The editor will not insert indentation automatically.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 234, "The editor will keep the current line's indentation.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    235,
                    "The editor will keep the current line's indentation and honor language defined brackets."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    236,
                    "The editor will keep the current line's indentation, honor language defined brackets and invoke special onEnterRules defined by languages."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    237,
                    "The editor will keep the current line's indentation, honor language defined brackets, invoke special onEnterRules defined by languages, and honor indentationRules defined by languages."
                )),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                238,
                "Controls whether the editor should automatically adjust the indentation when users type, paste, move or indent lines."
            ))
        }
    )))),
    automaticLayout: register(( (new EditorBooleanOption(EditorOption.automaticLayout, 'automaticLayout', false)))),
    autoSurround: register(( (new EditorStringEnumOption(
        EditorOption.autoSurround,
        'autoSurround',
        'languageDefined',
        ['languageDefined', 'quotes', 'brackets', 'never'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    239,
                    "Use language configurations to determine when to automatically surround selections."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 240, "Surround with quotes but not brackets.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 241, "Surround with brackets but not quotes.")),
                ''
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                242,
                "Controls whether the editor should automatically surround selections when typing quotes or brackets."
            ))
        }
    )))),
    bracketPairColorization: register(( (new BracketPairColorization()))),
    bracketPairGuides: register(( (new GuideOptions()))),
    stickyTabStops: register(( (new EditorBooleanOption(
        EditorOption.stickyTabStops,
        'stickyTabStops',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            243,
            "Emulate selection behavior of tab characters when using spaces for indentation. Selection will stick to tab stops."
        )) }
    )))),
    codeLens: register(( (new EditorBooleanOption(EditorOption.codeLens, 'codeLens', true, { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 244, "Controls whether the editor shows CodeLens.")) })))),
    codeLensFontFamily: register(( (new EditorStringOption(
        EditorOption.codeLensFontFamily,
        'codeLensFontFamily',
        '',
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 245, "Controls the font family for CodeLens.")) }
    )))),
    codeLensFontSize: register(( (new EditorIntOption(EditorOption.codeLensFontSize, 'codeLensFontSize', 0, 0, 100, {
        type: 'number',
        default: 0,
        minimum: 0,
        maximum: 100,
        markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            246,
            "Controls the font size in pixels for CodeLens. When set to 0, 90% of `#editor.fontSize#` is used."
        ))
    })))),
    colorDecorators: register(( (new EditorBooleanOption(
        EditorOption.colorDecorators,
        'colorDecorators',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            247,
            "Controls whether the editor should render the inline color decorators and color picker."
        )) }
    )))),
    colorDecoratorActivatedOn: register(( (new EditorStringEnumOption(
        EditorOption.colorDecoratorsActivatedOn,
        'colorDecoratorsActivatedOn',
        'clickAndHover',
        ['clickAndHover', 'hover', 'click'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    248,
                    "Make the color picker appear both on click and hover of the color decorator"
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    249,
                    "Make the color picker appear on hover of the color decorator"
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    250,
                    "Make the color picker appear on click of the color decorator"
                ))
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                251,
                "Controls the condition to make a color picker appear from a color decorator"
            ))
        }
    )))),
    colorDecoratorsLimit: register(( (new EditorIntOption(
        EditorOption.colorDecoratorsLimit,
        'colorDecoratorsLimit',
        500,
        1,
        1000000,
        {
            markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                252,
                "Controls the max number of color decorators that can be rendered in an editor at once."
            ))
        }
    )))),
    columnSelection: register(( (new EditorBooleanOption(
        EditorOption.columnSelection,
        'columnSelection',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            253,
            "Enable that the selection with the mouse and keys is doing column selection."
        )) }
    )))),
    comments: register(( (new EditorComments()))),
    contextmenu: register(( (new EditorBooleanOption(EditorOption.contextmenu, 'contextmenu', true)))),
    copyWithSyntaxHighlighting: register(( (new EditorBooleanOption(
        EditorOption.copyWithSyntaxHighlighting,
        'copyWithSyntaxHighlighting',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            254,
            "Controls whether syntax highlighting should be copied into the clipboard."
        )) }
    )))),
    cursorBlinking: register(( (new EditorEnumOption(
        EditorOption.cursorBlinking,
        'cursorBlinking',
        TextEditorCursorBlinkingStyle.Blink,
        'blink',
        ['blink', 'smooth', 'phase', 'expand', 'solid'],
        _cursorBlinkingStyleFromString,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 255, "Control the cursor animation style.")) }
    )))),
    cursorSmoothCaretAnimation: register(( (new EditorStringEnumOption(
        EditorOption.cursorSmoothCaretAnimation,
        'cursorSmoothCaretAnimation',
        'off',
        ['off', 'explicit', 'on'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 256, "Smooth caret animation is disabled.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    257,
                    "Smooth caret animation is enabled only when the user moves the cursor with an explicit gesture."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 258, "Smooth caret animation is always enabled."))
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                259,
                "Controls whether the smooth caret animation should be enabled."
            ))
        }
    )))),
    cursorStyle: register(( (new EditorEnumOption(
        EditorOption.cursorStyle,
        'cursorStyle',
        TextEditorCursorStyle.Line,
        'line',
        ['line', 'block', 'underline', 'line-thin', 'block-outline', 'underline-thin'],
        _cursorStyleFromString,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 260, "Controls the cursor style.")) }
    )))),
    cursorSurroundingLines: register(( (new EditorIntOption(
        EditorOption.cursorSurroundingLines,
        'cursorSurroundingLines',
        0,
        0,
        _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__.Constants.MAX_SAFE_SMALL_INTEGER,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            261,
            "Controls the minimal number of visible leading lines (minimum 0) and trailing lines (minimum 1) surrounding the cursor. Known as 'scrollOff' or 'scrollOffset' in some other editors."
        )) }
    )))),
    cursorSurroundingLinesStyle: register(( (new EditorStringEnumOption(
        EditorOption.cursorSurroundingLinesStyle,
        'cursorSurroundingLinesStyle',
        'default',
        ['default', 'all'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    262,
                    "`cursorSurroundingLines` is enforced only when triggered via the keyboard or API."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 263, "`cursorSurroundingLines` is enforced always."))
            ],
            markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                264,
                "Controls when `#editor.cursorSurroundingLines#` should be enforced."
            ))
        }
    )))),
    cursorWidth: register(( (new EditorIntOption(
        EditorOption.cursorWidth,
        'cursorWidth',
        0,
        0,
        _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__.Constants.MAX_SAFE_SMALL_INTEGER,
        { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            265,
            "Controls the width of the cursor when `#editor.cursorStyle#` is set to `line`."
        )) }
    )))),
    disableLayerHinting: register(( (new EditorBooleanOption(EditorOption.disableLayerHinting, 'disableLayerHinting', false)))),
    disableMonospaceOptimizations: register(( (new EditorBooleanOption(
        EditorOption.disableMonospaceOptimizations,
        'disableMonospaceOptimizations',
        false
    )))),
    domReadOnly: register(( (new EditorBooleanOption(EditorOption.domReadOnly, 'domReadOnly', false)))),
    dragAndDrop: register(( (new EditorBooleanOption(
        EditorOption.dragAndDrop,
        'dragAndDrop',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            266,
            "Controls whether the editor should allow moving selections via drag and drop."
        )) }
    )))),
    emptySelectionClipboard: register(( (new EditorEmptySelectionClipboard()))),
    dropIntoEditor: register(( (new EditorDropIntoEditor()))),
    stickyScroll: register(( (new EditorStickyScroll()))),
    experimentalWhitespaceRendering: register(( (new EditorStringEnumOption(
        EditorOption.experimentalWhitespaceRendering,
        'experimentalWhitespaceRendering',
        'svg',
        ['svg', 'font', 'off'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 267, "Use a new rendering method with svgs.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 268, "Use a new rendering method with font characters.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 269, "Use the stable rendering method.")),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                270,
                "Controls whether whitespace is rendered with a new, experimental method."
            ))
        }
    )))),
    extraEditorClassName: register(( (new EditorStringOption(EditorOption.extraEditorClassName, 'extraEditorClassName', '')))),
    fastScrollSensitivity: register(( (new EditorFloatOption(
        EditorOption.fastScrollSensitivity,
        'fastScrollSensitivity',
        5,
        x => (x <= 0 ? 5 : x),
        { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 271, "Scrolling speed multiplier when pressing `Alt`.")) }
    )))),
    find: register(( (new EditorFind()))),
    fixedOverflowWidgets: register(( (new EditorBooleanOption(EditorOption.fixedOverflowWidgets, 'fixedOverflowWidgets', false)))),
    folding: register(( (new EditorBooleanOption(EditorOption.folding, 'folding', true, { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 272, "Controls whether the editor has code folding enabled.")) })))),
    foldingStrategy: register(( (new EditorStringEnumOption(
        EditorOption.foldingStrategy,
        'foldingStrategy',
        'auto',
        ['auto', 'indentation'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    273,
                    "Use a language-specific folding strategy if available, else the indentation-based one."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 274, "Use the indentation-based folding strategy.")),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 275, "Controls the strategy for computing folding ranges."))
        }
    )))),
    foldingHighlight: register(( (new EditorBooleanOption(
        EditorOption.foldingHighlight,
        'foldingHighlight',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            276,
            "Controls whether the editor should highlight folded ranges."
        )) }
    )))),
    foldingImportsByDefault: register(( (new EditorBooleanOption(
        EditorOption.foldingImportsByDefault,
        'foldingImportsByDefault',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            277,
            "Controls whether the editor automatically collapses import ranges."
        )) }
    )))),
    foldingMaximumRegions: register(( (new EditorIntOption(
        EditorOption.foldingMaximumRegions,
        'foldingMaximumRegions',
        5000,
        10,
        65000,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            278,
            "The maximum number of foldable regions. Increasing this value may result in the editor becoming less responsive when the current source has a large number of foldable regions."
        )) }
    )))),
    unfoldOnClickAfterEndOfLine: register(( (new EditorBooleanOption(
        EditorOption.unfoldOnClickAfterEndOfLine,
        'unfoldOnClickAfterEndOfLine',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            279,
            "Controls whether clicking on the empty content after a folded line will unfold the line."
        )) }
    )))),
    fontFamily: register(( (new EditorStringOption(
        EditorOption.fontFamily,
        'fontFamily',
        EDITOR_FONT_DEFAULTS.fontFamily,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 280, "Controls the font family.")) }
    )))),
    fontInfo: register(( (new EditorFontInfo()))),
    fontLigatures2: register(( (new EditorFontLigatures()))),
    fontSize: register(( (new EditorFontSize()))),
    fontWeight: register(( (new EditorFontWeight()))),
    fontVariations: register(( (new EditorFontVariations()))),
    formatOnPaste: register(( (new EditorBooleanOption(
        EditorOption.formatOnPaste,
        'formatOnPaste',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            281,
            "Controls whether the editor should automatically format the pasted content. A formatter must be available and the formatter should be able to format a range in a document."
        )) }
    )))),
    formatOnType: register(( (new EditorBooleanOption(
        EditorOption.formatOnType,
        'formatOnType',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            282,
            "Controls whether the editor should automatically format the line after typing."
        )) }
    )))),
    glyphMargin: register(( (new EditorBooleanOption(
        EditorOption.glyphMargin,
        'glyphMargin',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            283,
            "Controls whether the editor should render the vertical glyph margin. Glyph margin is mostly used for debugging."
        )) }
    )))),
    gotoLocation: register(( (new EditorGoToLocation()))),
    hideCursorInOverviewRuler: register(( (new EditorBooleanOption(
        EditorOption.hideCursorInOverviewRuler,
        'hideCursorInOverviewRuler',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            284,
            "Controls whether the cursor should be hidden in the overview ruler."
        )) }
    )))),
    hover: register(( (new EditorHover()))),
    inDiffEditor: register(( (new EditorBooleanOption(EditorOption.inDiffEditor, 'inDiffEditor', false)))),
    letterSpacing: register(( (new EditorFloatOption(
        EditorOption.letterSpacing,
        'letterSpacing',
        EDITOR_FONT_DEFAULTS.letterSpacing,
        x => EditorFloatOption.clamp(x, -5, 20),
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 285, "Controls the letter spacing in pixels.")) }
    )))),
    lightbulb: register(( (new EditorLightbulb()))),
    lineDecorationsWidth: register(( (new EditorLineDecorationsWidth()))),
    lineHeight: register(( (new EditorLineHeight()))),
    lineNumbers: register(( (new EditorRenderLineNumbersOption()))),
    lineNumbersMinChars: register(( (new EditorIntOption(EditorOption.lineNumbersMinChars, 'lineNumbersMinChars', 5, 1, 300)))),
    linkedEditing: register(( (new EditorBooleanOption(
        EditorOption.linkedEditing,
        'linkedEditing',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            286,
            "Controls whether the editor has linked editing enabled. Depending on the language, related symbols such as HTML tags, are updated while editing."
        )) }
    )))),
    links: register(( (new EditorBooleanOption(EditorOption.links, 'links', true, { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
        _moduleId,
        287,
        "Controls whether the editor should detect links and make them clickable."
    )) })))),
    matchBrackets: register(( (new EditorStringEnumOption(
        EditorOption.matchBrackets,
        'matchBrackets',
        'always',
        ['always', 'near', 'never'],
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 288, "Highlight matching brackets.")) }
    )))),
    minimap: register(( (new EditorMinimap()))),
    mouseStyle: register(( (new EditorStringEnumOption(EditorOption.mouseStyle, 'mouseStyle', 'text', ['text', 'default', 'copy'])))),
    mouseWheelScrollSensitivity: register(( (new EditorFloatOption(
        EditorOption.mouseWheelScrollSensitivity,
        'mouseWheelScrollSensitivity',
        1,
        x => (x === 0 ? 1 : x),
        { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            289,
            "A multiplier to be used on the `deltaX` and `deltaY` of mouse wheel scroll events."
        )) }
    )))),
    mouseWheelZoom: register(( (new EditorBooleanOption(EditorOption.mouseWheelZoom, 'mouseWheelZoom', false, {
        markdownDescription: _base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isMacintosh
            ? ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            290,
            "Zoom the font of the editor when using mouse wheel and holding `Cmd`."
        ))
            : ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            291,
            "Zoom the font of the editor when using mouse wheel and holding `Ctrl`."
        ))
    })))),
    multiCursorMergeOverlapping: register(( (new EditorBooleanOption(
        EditorOption.multiCursorMergeOverlapping,
        'multiCursorMergeOverlapping',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 292, "Merge multiple cursors when they are overlapping.")) }
    )))),
    multiCursorModifier: register(( (new EditorEnumOption(
        EditorOption.multiCursorModifier,
        'multiCursorModifier',
        'altKey',
        'alt',
        ['ctrlCmd', 'alt'],
        _multiCursorModifierFromString,
        {
            markdownEnumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    293,
                    "Maps to `Control` on Windows and Linux and to `Command` on macOS."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    294,
                    "Maps to `Alt` on Windows and Linux and to `Option` on macOS."
                ))
            ],
            markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                295,
                "The modifier to be used to add multiple cursors with the mouse. The Go to Definition and Open Link mouse gestures will adapt such that they do not conflict with the [multicursor modifier](https://code.visualstudio.com/docs/editor/codebasics#_multicursor-modifier)."
            ))
        }
    )))),
    multiCursorPaste: register(( (new EditorStringEnumOption(
        EditorOption.multiCursorPaste,
        'multiCursorPaste',
        'spread',
        ['spread', 'full'],
        {
            markdownEnumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 296, "Each cursor pastes a single line of the text.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 297, "Each cursor pastes the full text."))
            ],
            markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                298,
                "Controls pasting when the line count of the pasted text matches the cursor count."
            ))
        }
    )))),
    multiCursorLimit: register(( (new EditorIntOption(EditorOption.multiCursorLimit, 'multiCursorLimit', 10000, 1, 100000, {
        markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            299,
            "Controls the max number of cursors that can be in an active editor at once."
        ))
    })))),
    occurrencesHighlight: register(( (new EditorStringEnumOption(
        EditorOption.occurrencesHighlight,
        'occurrencesHighlight',
        'singleFile',
        ['off', 'singleFile', 'multiFile'],
        {
            markdownEnumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 300, "Does not highlight occurrences.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 301, "Highlights occurrences only in the current file.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    302,
                    "Experimental: Highlights occurrences across all valid open files."
                ))
            ],
            markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                303,
                "Controls whether occurrences should be highlighted across open files."
            ))
        }
    )))),
    overviewRulerBorder: register(( (new EditorBooleanOption(
        EditorOption.overviewRulerBorder,
        'overviewRulerBorder',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            304,
            "Controls whether a border should be drawn around the overview ruler."
        )) }
    )))),
    overviewRulerLanes: register(( (new EditorIntOption(EditorOption.overviewRulerLanes, 'overviewRulerLanes', 3, 0, 3)))),
    padding: register(( (new EditorPadding()))),
    pasteAs: register(( (new EditorPasteAs()))),
    parameterHints: register(( (new EditorParameterHints()))),
    peekWidgetDefaultFocus: register(( (new EditorStringEnumOption(
        EditorOption.peekWidgetDefaultFocus,
        'peekWidgetDefaultFocus',
        'tree',
        ['tree', 'editor'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 305, "Focus the tree when opening peek")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 306, "Focus the editor when opening peek"))
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                307,
                "Controls whether to focus the inline editor or the tree in the peek widget."
            ))
        }
    )))),
    placeholder: register(( (new PlaceholderOption()))),
    definitionLinkOpensInPeek: register(( (new EditorBooleanOption(
        EditorOption.definitionLinkOpensInPeek,
        'definitionLinkOpensInPeek',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            308,
            "Controls whether the Go to Definition mouse gesture always opens the peek widget."
        )) }
    )))),
    quickSuggestions: register(( (new EditorQuickSuggestions()))),
    quickSuggestionsDelay: register(( (new EditorIntOption(
        EditorOption.quickSuggestionsDelay,
        'quickSuggestionsDelay',
        10,
        0,
        _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__.Constants.MAX_SAFE_SMALL_INTEGER,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            309,
            "Controls the delay in milliseconds after which quick suggestions will show up."
        )) }
    )))),
    readOnly: register(( (new EditorBooleanOption(EditorOption.readOnly, 'readOnly', false)))),
    readOnlyMessage: register(( (new ReadonlyMessage()))),
    renameOnType: register(( (new EditorBooleanOption(
        EditorOption.renameOnType,
        'renameOnType',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 310, "Controls whether the editor auto renames on type.")), markdownDeprecationMessage: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 311, "Deprecated, use `editor.linkedEditing` instead.")) }
    )))),
    renderControlCharacters: register(( (new EditorBooleanOption(
        EditorOption.renderControlCharacters,
        'renderControlCharacters',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            312,
            "Controls whether the editor should render control characters."
        )), restricted: true }
    )))),
    renderFinalNewline: register(( (new EditorStringEnumOption(
        EditorOption.renderFinalNewline,
        'renderFinalNewline',
        (_base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isLinux ? 'dimmed' : 'on'),
        ['off', 'on', 'dimmed'],
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            313,
            "Render last line number when the file ends with a newline."
        )) }
    )))),
    renderLineHighlight: register(( (new EditorStringEnumOption(
        EditorOption.renderLineHighlight,
        'renderLineHighlight',
        'line',
        ['none', 'gutter', 'line', 'all'],
        {
            enumDescriptions: [
                '',
                '',
                '',
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 314, "Highlights both the gutter and the current line.")),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                315,
                "Controls how the editor should render the current line highlight."
            ))
        }
    )))),
    renderLineHighlightOnlyWhenFocus: register(( (new EditorBooleanOption(
        EditorOption.renderLineHighlightOnlyWhenFocus,
        'renderLineHighlightOnlyWhenFocus',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            316,
            "Controls if the editor should render the current line highlight only when the editor is focused."
        )) }
    )))),
    renderValidationDecorations: register(( (new EditorStringEnumOption(
        EditorOption.renderValidationDecorations,
        'renderValidationDecorations',
        'editable',
        ['editable', 'on', 'off']
    )))),
    renderWhitespace: register(( (new EditorStringEnumOption(
        EditorOption.renderWhitespace,
        'renderWhitespace',
        'selection',
        ['none', 'boundary', 'selection', 'trailing', 'all'],
        {
            enumDescriptions: [
                '',
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    317,
                    "Render whitespace characters except for single spaces between words."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 318, "Render whitespace characters only on selected text.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 319, "Render only trailing whitespace characters.")),
                ''
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                320,
                "Controls how the editor should render whitespace characters."
            ))
        }
    )))),
    revealHorizontalRightPadding: register(( (new EditorIntOption(
        EditorOption.revealHorizontalRightPadding,
        'revealHorizontalRightPadding',
        15,
        0,
        1000
    )))),
    roundedSelection: register(( (new EditorBooleanOption(
        EditorOption.roundedSelection,
        'roundedSelection',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 321, "Controls whether selections should have rounded corners.")) }
    )))),
    rulers: register(( (new EditorRulers()))),
    scrollbar: register(( (new EditorScrollbar()))),
    scrollBeyondLastColumn: register(( (new EditorIntOption(
        EditorOption.scrollBeyondLastColumn,
        'scrollBeyondLastColumn',
        4,
        0,
        _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__.Constants.MAX_SAFE_SMALL_INTEGER,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            322,
            "Controls the number of extra characters beyond which the editor will scroll horizontally."
        )) }
    )))),
    scrollBeyondLastLine: register(( (new EditorBooleanOption(
        EditorOption.scrollBeyondLastLine,
        'scrollBeyondLastLine',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            323,
            "Controls whether the editor will scroll beyond the last line."
        )) }
    )))),
    scrollPredominantAxis: register(( (new EditorBooleanOption(
        EditorOption.scrollPredominantAxis,
        'scrollPredominantAxis',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            324,
            "Scroll only along the predominant axis when scrolling both vertically and horizontally at the same time. Prevents horizontal drift when scrolling vertically on a trackpad."
        )) }
    )))),
    selectionClipboard: register(( (new EditorBooleanOption(EditorOption.selectionClipboard, 'selectionClipboard', true, {
        description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            325,
            "Controls whether the Linux primary clipboard should be supported."
        )),
        included: _base_common_platform_js__WEBPACK_IMPORTED_MODULE_2__.isLinux
    })))),
    selectionHighlight: register(( (new EditorBooleanOption(
        EditorOption.selectionHighlight,
        'selectionHighlight',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            326,
            "Controls whether the editor should highlight matches similar to the selection."
        )) }
    )))),
    selectOnLineNumbers: register(( (new EditorBooleanOption(EditorOption.selectOnLineNumbers, 'selectOnLineNumbers', true)))),
    showFoldingControls: register(( (new EditorStringEnumOption(
        EditorOption.showFoldingControls,
        'showFoldingControls',
        'mouseover',
        ['always', 'never', 'mouseover'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 327, "Always show the folding controls.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    328,
                    "Never show the folding controls and reduce the gutter size."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    329,
                    "Only show the folding controls when the mouse is over the gutter."
                )),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                330,
                "Controls when the folding controls on the gutter are shown."
            ))
        }
    )))),
    showUnused: register(( (new EditorBooleanOption(EditorOption.showUnused, 'showUnused', true, { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 331, "Controls fading out of unused code.")) })))),
    showDeprecated: register(( (new EditorBooleanOption(
        EditorOption.showDeprecated,
        'showDeprecated',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 332, "Controls strikethrough deprecated variables.")) }
    )))),
    inlayHints: register(( (new EditorInlayHints()))),
    snippetSuggestions: register(( (new EditorStringEnumOption(
        EditorOption.snippetSuggestions,
        'snippetSuggestions',
        'inline',
        ['top', 'bottom', 'inline', 'none'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 333, "Show snippet suggestions on top of other suggestions.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 334, "Show snippet suggestions below other suggestions.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 335, "Show snippets suggestions with other suggestions.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 336, "Do not show snippet suggestions.")),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                337,
                "Controls whether snippets are shown with other suggestions and how they are sorted."
            ))
        }
    )))),
    smartSelect: register(( (new SmartSelect()))),
    smoothScrolling: register(( (new EditorBooleanOption(
        EditorOption.smoothScrolling,
        'smoothScrolling',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            338,
            "Controls whether the editor will scroll using an animation."
        )) }
    )))),
    stopRenderingLineAfter: register(( (new EditorIntOption(
        EditorOption.stopRenderingLineAfter,
        'stopRenderingLineAfter',
        10000,
        -1,
        _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__.Constants.MAX_SAFE_SMALL_INTEGER
    )))),
    suggest: register(( (new EditorSuggest()))),
    inlineSuggest: register(( (new InlineEditorSuggest()))),
    inlineEdit: register(( (new InlineEditorEdit()))),
    inlineCompletionsAccessibilityVerbose: register(( (new EditorBooleanOption(
        EditorOption.inlineCompletionsAccessibilityVerbose,
        'inlineCompletionsAccessibilityVerbose',
        false,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            339,
            "Controls whether the accessibility hint should be provided to screen reader users when an inline completion is shown."
        )) }
    )))),
    suggestFontSize: register(( (new EditorIntOption(
        EditorOption.suggestFontSize,
        'suggestFontSize',
        0,
        0,
        1000,
        { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            340,
            "Font size for the suggest widget. When set to {0}, the value of {1} is used.",
            '`0`',
            '`#editor.fontSize#`'
        )) }
    )))),
    suggestLineHeight: register(( (new EditorIntOption(
        EditorOption.suggestLineHeight,
        'suggestLineHeight',
        0,
        0,
        1000,
        { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            341,
            "Line height for the suggest widget. When set to {0}, the value of {1} is used. The minimum value is 8.",
            '`0`',
            '`#editor.lineHeight#`'
        )) }
    )))),
    suggestOnTriggerCharacters: register(( (new EditorBooleanOption(
        EditorOption.suggestOnTriggerCharacters,
        'suggestOnTriggerCharacters',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            342,
            "Controls whether suggestions should automatically show up when typing trigger characters."
        )) }
    )))),
    suggestSelection: register(( (new EditorStringEnumOption(
        EditorOption.suggestSelection,
        'suggestSelection',
        'first',
        ['first', 'recentlyUsed', 'recentlyUsedByPrefix'],
        {
            markdownEnumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 343, "Always select the first suggestion.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    344,
                    "Select recent suggestions unless further typing selects one, e.g. `console.| -> console.log` because `log` has been completed recently."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    345,
                    "Select suggestions based on previous prefixes that have completed those suggestions, e.g. `co -> console` and `con -> const`."
                )),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                346,
                "Controls how suggestions are pre-selected when showing the suggest list."
            ))
        }
    )))),
    tabCompletion: register(( (new EditorStringEnumOption(
        EditorOption.tabCompletion,
        'tabCompletion',
        'off',
        ['on', 'off', 'onlySnippets'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    347,
                    "Tab complete will insert the best matching suggestion when pressing tab."
                )),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 348, "Disable tab completions.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    349,
                    "Tab complete snippets when their prefix match. Works best when 'quickSuggestions' aren't enabled."
                )),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 350, "Enables tab completions."))
        }
    )))),
    tabIndex: register(( (new EditorIntOption(EditorOption.tabIndex, 'tabIndex', 0, -1, _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__.Constants.MAX_SAFE_SMALL_INTEGER)))),
    unicodeHighlight: register(( (new UnicodeHighlight()))),
    unusualLineTerminators: register(( (new EditorStringEnumOption(
        EditorOption.unusualLineTerminators,
        'unusualLineTerminators',
        'prompt',
        ['auto', 'off', 'prompt'],
        {
            enumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 351, "Unusual line terminators are automatically removed.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 352, "Unusual line terminators are ignored.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 353, "Unusual line terminators prompt to be removed.")),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                354,
                "Remove unusual line terminators that might cause problems."
            ))
        }
    )))),
    useShadowDOM: register(( (new EditorBooleanOption(EditorOption.useShadowDOM, 'useShadowDOM', true)))),
    useTabStops: register(( (new EditorBooleanOption(
        EditorOption.useTabStops,
        'useTabStops',
        true,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            355,
            "Spaces and tabs are inserted and deleted in alignment with tab stops."
        )) }
    )))),
    wordBreak: register(( (new EditorStringEnumOption(EditorOption.wordBreak, 'wordBreak', 'normal', ['normal', 'keepAll'], {
        markdownEnumDescriptions: [
            ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 356, "Use the default line break rule.")),
            ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                357,
                "Word breaks should not be used for Chinese/Japanese/Korean (CJK) text. Non-CJK text behavior is the same as for normal."
            )),
        ],
        description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            358,
            "Controls the word break rules used for Chinese/Japanese/Korean (CJK) text."
        ))
    })))),
    wordSegmenterLocales: register(( (new WordSegmenterLocales()))),
    wordSeparators: register(( (new EditorStringOption(
        EditorOption.wordSeparators,
        'wordSeparators',
        _core_wordHelper_js__WEBPACK_IMPORTED_MODULE_6__.USUAL_WORD_SEPARATORS,
        { description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            359,
            "Characters that will be used as word separators when doing word related navigations or operations."
        )) }
    )))),
    wordWrap: register(( (new EditorStringEnumOption(
        EditorOption.wordWrap,
        'wordWrap',
        'off',
        ['off', 'on', 'wordWrapColumn', 'bounded'],
        {
            markdownEnumDescriptions: [
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 360, "Lines will never wrap.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 361, "Lines will wrap at the viewport width.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 362, "Lines will wrap at `#editor.wordWrapColumn#`.")),
                ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                    _moduleId,
                    363,
                    "Lines will wrap at the minimum of viewport and `#editor.wordWrapColumn#`."
                )),
            ],
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(_moduleId, 364, "Controls how lines should wrap."))
        }
    )))),
    wordWrapBreakAfterCharacters: register(( (new EditorStringOption(
        EditorOption.wordWrapBreakAfterCharacters,
        'wordWrapBreakAfterCharacters',
        ' \t})]?|/&.,;¢°′″‰℃、。｡､￠，．：；？！％・･ゝゞヽヾーァィゥェォッャュョヮヵヶぁぃぅぇぉっゃゅょゎゕゖㇰㇱㇲㇳㇴㇵㇶㇷㇸㇹㇺㇻㇼㇽㇾㇿ々〻ｧｨｩｪｫｬｭｮｯｰ”〉》」』】〕）］｝｣'
    )))),
    wordWrapBreakBeforeCharacters: register(( (new EditorStringOption(
        EditorOption.wordWrapBreakBeforeCharacters,
        'wordWrapBreakBeforeCharacters',
        '([{‘“〈《「『【〔（［｛｢£¥＄￡￥+＋'
    )))),
    wordWrapColumn: register(( (new EditorIntOption(
        EditorOption.wordWrapColumn,
        'wordWrapColumn',
        80,
        1,
        _base_common_uint_js__WEBPACK_IMPORTED_MODULE_4__.Constants.MAX_SAFE_SMALL_INTEGER,
        {
            markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
                _moduleId,
                365,
                "Controls the wrapping column of the editor when `#editor.wordWrap#` is `wordWrapColumn` or `bounded`."
            ))
        }
    )))),
    wordWrapOverride1: register(( (new EditorStringEnumOption(
        EditorOption.wordWrapOverride1,
        'wordWrapOverride1',
        'inherit',
        ['off', 'on', 'inherit']
    )))),
    wordWrapOverride2: register(( (new EditorStringEnumOption(
        EditorOption.wordWrapOverride2,
        'wordWrapOverride2',
        'inherit',
        ['off', 'on', 'inherit']
    )))),
    editorClassName: register(( (new EditorClassName()))),
    defaultColorDecorators: register(( (new EditorBooleanOption(
        EditorOption.defaultColorDecorators,
        'defaultColorDecorators',
        false,
        { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            366,
            "Controls whether inline color decorations should be shown using the default document color provider"
        )) }
    )))),
    pixelRatio: register(( (new EditorPixelRatio()))),
    tabFocusMode: register(( (new EditorBooleanOption(
        EditorOption.tabFocusMode,
        'tabFocusMode',
        false,
        { markdownDescription: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_7__.localizeWithPath)(
            _moduleId,
            367,
            "Controls whether the editor receives tabs or defers them to the workbench for navigation."
        )) }
    )))),
    layoutInfo: register(( (new EditorLayoutInfoComputer()))),
    wrappingInfo: register(( (new EditorWrappingInfoComputer()))),
    wrappingIndent: register(( (new WrappingIndentOption()))),
    wrappingStrategy: register(( (new WrappingStrategy())))
};



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/eolCounter.js":
/*!****************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/eolCounter.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StringEOL: () => (/* binding */ StringEOL),
/* harmony export */   countEOL: () => (/* binding */ countEOL)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");

var StringEOL;
( (function(StringEOL) {
    StringEOL[StringEOL["Unknown"] = 0] = "Unknown";
    StringEOL[StringEOL["Invalid"] = 3] = "Invalid";
    StringEOL[StringEOL["LF"] = 1] = "LF";
    StringEOL[StringEOL["CRLF"] = 2] = "CRLF";
})(StringEOL || (StringEOL = {})));
function countEOL(text) {
    let eolCount = 0;
    let firstLineLength = 0;
    let lastLineStart = 0;
    let eol = StringEOL.Unknown;
    for (let i = 0, len = text.length; i < len; i++) {
        const chr = text.charCodeAt(i);
        if (chr === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn) {
            if (eolCount === 0) {
                firstLineLength = i;
            }
            eolCount++;
            if (i + 1 < len && text.charCodeAt(i + 1) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
                eol |= StringEOL.CRLF;
                i++;
            }
            else {
                eol |= StringEOL.Invalid;
            }
            lastLineStart = i + 1;
        }
        else if (chr === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
            eol |= StringEOL.LF;
            if (eolCount === 0) {
                firstLineLength = i;
            }
            eolCount++;
            lastLineStart = i + 1;
        }
    }
    if (eolCount === 0) {
        firstLineLength = text.length;
    }
    return [eolCount, firstLineLength, text.length - lastLineStart, eol];
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/stringBuilder.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/stringBuilder.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StringBuilder: () => (/* binding */ StringBuilder),
/* harmony export */   decodeUTF16LE: () => (/* binding */ decodeUTF16LE),
/* harmony export */   getPlatformTextDecoder: () => (/* binding */ getPlatformTextDecoder)
/* harmony export */ });
/* harmony import */ var _base_common_strings_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _base_common_buffer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../base/common/buffer.js */ "./node_modules/vscode/vscode/src/vs/base/common/buffer.js");



let _utf16LE_TextDecoder;
function getUTF16LE_TextDecoder() {
    if (!_utf16LE_TextDecoder) {
        _utf16LE_TextDecoder = ( new TextDecoder('UTF-16LE'));
    }
    return _utf16LE_TextDecoder;
}
let _utf16BE_TextDecoder;
function getUTF16BE_TextDecoder() {
    if (!_utf16BE_TextDecoder) {
        _utf16BE_TextDecoder = ( new TextDecoder('UTF-16BE'));
    }
    return _utf16BE_TextDecoder;
}
let _platformTextDecoder;
function getPlatformTextDecoder() {
    if (!_platformTextDecoder) {
        _platformTextDecoder = (0,_base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isLittleEndian)() ? getUTF16LE_TextDecoder() : getUTF16BE_TextDecoder();
    }
    return _platformTextDecoder;
}
function decodeUTF16LE(source, offset, len) {
    const view = ( new Uint16Array(source.buffer, offset, len));
    if (len > 0 && (view[0] === 0xFEFF || view[0] === 0xFFFE)) {
        return compatDecodeUTF16LE(source, offset, len);
    }
    return getUTF16LE_TextDecoder().decode(view);
}
function compatDecodeUTF16LE(source, offset, len) {
    const result = [];
    let resultLen = 0;
    for (let i = 0; i < len; i++) {
        const charCode = (0,_base_common_buffer_js__WEBPACK_IMPORTED_MODULE_2__.readUInt16LE)(source, offset);
        offset += 2;
        result[resultLen++] = String.fromCharCode(charCode);
    }
    return result.join('');
}
class StringBuilder {
    constructor(capacity) {
        this._capacity = capacity | 0;
        this._buffer = ( new Uint16Array(this._capacity));
        this._completedStrings = null;
        this._bufferLength = 0;
    }
    reset() {
        this._completedStrings = null;
        this._bufferLength = 0;
    }
    build() {
        if (this._completedStrings !== null) {
            this._flushBuffer();
            return this._completedStrings.join('');
        }
        return this._buildBuffer();
    }
    _buildBuffer() {
        if (this._bufferLength === 0) {
            return '';
        }
        const view = ( new Uint16Array(this._buffer.buffer, 0, this._bufferLength));
        return getPlatformTextDecoder().decode(view);
    }
    _flushBuffer() {
        const bufferString = this._buildBuffer();
        this._bufferLength = 0;
        if (this._completedStrings === null) {
            this._completedStrings = [bufferString];
        }
        else {
            this._completedStrings[this._completedStrings.length] = bufferString;
        }
    }
    appendCharCode(charCode) {
        const remainingSpace = this._capacity - this._bufferLength;
        if (remainingSpace <= 1) {
            if (remainingSpace === 0 || (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_0__.isHighSurrogate)(charCode)) {
                this._flushBuffer();
            }
        }
        this._buffer[this._bufferLength++] = charCode;
    }
    appendASCIICharCode(charCode) {
        if (this._bufferLength === this._capacity) {
            this._flushBuffer();
        }
        this._buffer[this._bufferLength++] = charCode;
    }
    appendString(str) {
        const strLen = str.length;
        if (this._bufferLength + strLen >= this._capacity) {
            this._flushBuffer();
            this._completedStrings[this._completedStrings.length] = str;
            return;
        }
        for (let i = 0; i < strLen; i++) {
            this._buffer[this._bufferLength++] = str.charCodeAt(i);
        }
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/textChange.js":
/*!****************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/textChange.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextChange: () => (/* binding */ TextChange),
/* harmony export */   compressConsecutiveTextChanges: () => (/* binding */ compressConsecutiveTextChanges)
/* harmony export */ });
/* harmony import */ var _base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/buffer.js */ "./node_modules/vscode/vscode/src/vs/base/common/buffer.js");
/* harmony import */ var _stringBuilder_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stringBuilder.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/stringBuilder.js");


function escapeNewLine(str) {
    return (str
        .replace(/\n/g, '\\n')
        .replace(/\r/g, '\\r'));
}
class TextChange {
    get oldLength() {
        return this.oldText.length;
    }
    get oldEnd() {
        return this.oldPosition + this.oldText.length;
    }
    get newLength() {
        return this.newText.length;
    }
    get newEnd() {
        return this.newPosition + this.newText.length;
    }
    constructor(oldPosition, oldText, newPosition, newText) {
        this.oldPosition = oldPosition;
        this.oldText = oldText;
        this.newPosition = newPosition;
        this.newText = newText;
    }
    toString() {
        if (this.oldText.length === 0) {
            return `(insert@${this.oldPosition} "${escapeNewLine(this.newText)}")`;
        }
        if (this.newText.length === 0) {
            return `(delete@${this.oldPosition} "${escapeNewLine(this.oldText)}")`;
        }
        return `(replace@${this.oldPosition} "${escapeNewLine(this.oldText)}" with "${escapeNewLine(this.newText)}")`;
    }
    static _writeStringSize(str) {
        return (4 + 2 * str.length);
    }
    static _writeString(b, str, offset) {
        const len = str.length;
        (0,_base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__.writeUInt32BE)(b, len, offset);
        offset += 4;
        for (let i = 0; i < len; i++) {
            (0,_base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__.writeUInt16LE)(b, str.charCodeAt(i), offset);
            offset += 2;
        }
        return offset;
    }
    static _readString(b, offset) {
        const len = (0,_base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__.readUInt32BE)(b, offset);
        offset += 4;
        return (0,_stringBuilder_js__WEBPACK_IMPORTED_MODULE_1__.decodeUTF16LE)(b, offset, len);
    }
    writeSize() {
        return (+4
            + 4
            + TextChange._writeStringSize(this.oldText)
            + TextChange._writeStringSize(this.newText));
    }
    write(b, offset) {
        (0,_base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__.writeUInt32BE)(b, this.oldPosition, offset);
        offset += 4;
        (0,_base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__.writeUInt32BE)(b, this.newPosition, offset);
        offset += 4;
        offset = TextChange._writeString(b, this.oldText, offset);
        offset = TextChange._writeString(b, this.newText, offset);
        return offset;
    }
    static read(b, offset, dest) {
        const oldPosition = (0,_base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__.readUInt32BE)(b, offset);
        offset += 4;
        const newPosition = (0,_base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__.readUInt32BE)(b, offset);
        offset += 4;
        const oldText = TextChange._readString(b, offset);
        offset += TextChange._writeStringSize(oldText);
        const newText = TextChange._readString(b, offset);
        offset += TextChange._writeStringSize(newText);
        dest.push(( new TextChange(oldPosition, oldText, newPosition, newText)));
        return offset;
    }
}
function compressConsecutiveTextChanges(prevEdits, currEdits) {
    if (prevEdits === null || prevEdits.length === 0) {
        return currEdits;
    }
    const compressor = ( new TextChangeCompressor(prevEdits, currEdits));
    return compressor.compress();
}
class TextChangeCompressor {
    constructor(prevEdits, currEdits) {
        this._prevEdits = prevEdits;
        this._currEdits = currEdits;
        this._result = [];
        this._resultLen = 0;
        this._prevLen = this._prevEdits.length;
        this._prevDeltaOffset = 0;
        this._currLen = this._currEdits.length;
        this._currDeltaOffset = 0;
    }
    compress() {
        let prevIndex = 0;
        let currIndex = 0;
        let prevEdit = this._getPrev(prevIndex);
        let currEdit = this._getCurr(currIndex);
        while (prevIndex < this._prevLen || currIndex < this._currLen) {
            if (prevEdit === null) {
                this._acceptCurr(currEdit);
                currEdit = this._getCurr(++currIndex);
                continue;
            }
            if (currEdit === null) {
                this._acceptPrev(prevEdit);
                prevEdit = this._getPrev(++prevIndex);
                continue;
            }
            if (currEdit.oldEnd <= prevEdit.newPosition) {
                this._acceptCurr(currEdit);
                currEdit = this._getCurr(++currIndex);
                continue;
            }
            if (prevEdit.newEnd <= currEdit.oldPosition) {
                this._acceptPrev(prevEdit);
                prevEdit = this._getPrev(++prevIndex);
                continue;
            }
            if (currEdit.oldPosition < prevEdit.newPosition) {
                const [e1, e2] = TextChangeCompressor._splitCurr(currEdit, prevEdit.newPosition - currEdit.oldPosition);
                this._acceptCurr(e1);
                currEdit = e2;
                continue;
            }
            if (prevEdit.newPosition < currEdit.oldPosition) {
                const [e1, e2] = TextChangeCompressor._splitPrev(prevEdit, currEdit.oldPosition - prevEdit.newPosition);
                this._acceptPrev(e1);
                prevEdit = e2;
                continue;
            }
            let mergePrev;
            let mergeCurr;
            if (currEdit.oldEnd === prevEdit.newEnd) {
                mergePrev = prevEdit;
                mergeCurr = currEdit;
                prevEdit = this._getPrev(++prevIndex);
                currEdit = this._getCurr(++currIndex);
            }
            else if (currEdit.oldEnd < prevEdit.newEnd) {
                const [e1, e2] = TextChangeCompressor._splitPrev(prevEdit, currEdit.oldLength);
                mergePrev = e1;
                mergeCurr = currEdit;
                prevEdit = e2;
                currEdit = this._getCurr(++currIndex);
            }
            else {
                const [e1, e2] = TextChangeCompressor._splitCurr(currEdit, prevEdit.newLength);
                mergePrev = prevEdit;
                mergeCurr = e1;
                prevEdit = this._getPrev(++prevIndex);
                currEdit = e2;
            }
            this._result[this._resultLen++] = ( new TextChange(
                mergePrev.oldPosition,
                mergePrev.oldText,
                mergeCurr.newPosition,
                mergeCurr.newText
            ));
            this._prevDeltaOffset += mergePrev.newLength - mergePrev.oldLength;
            this._currDeltaOffset += mergeCurr.newLength - mergeCurr.oldLength;
        }
        const merged = TextChangeCompressor._merge(this._result);
        const cleaned = TextChangeCompressor._removeNoOps(merged);
        return cleaned;
    }
    _acceptCurr(currEdit) {
        this._result[this._resultLen++] = TextChangeCompressor._rebaseCurr(this._prevDeltaOffset, currEdit);
        this._currDeltaOffset += currEdit.newLength - currEdit.oldLength;
    }
    _getCurr(currIndex) {
        return (currIndex < this._currLen ? this._currEdits[currIndex] : null);
    }
    _acceptPrev(prevEdit) {
        this._result[this._resultLen++] = TextChangeCompressor._rebasePrev(this._currDeltaOffset, prevEdit);
        this._prevDeltaOffset += prevEdit.newLength - prevEdit.oldLength;
    }
    _getPrev(prevIndex) {
        return (prevIndex < this._prevLen ? this._prevEdits[prevIndex] : null);
    }
    static _rebaseCurr(prevDeltaOffset, currEdit) {
        return ( new TextChange(
            currEdit.oldPosition - prevDeltaOffset,
            currEdit.oldText,
            currEdit.newPosition,
            currEdit.newText
        ));
    }
    static _rebasePrev(currDeltaOffset, prevEdit) {
        return ( new TextChange(
            prevEdit.oldPosition,
            prevEdit.oldText,
            prevEdit.newPosition + currDeltaOffset,
            prevEdit.newText
        ));
    }
    static _splitPrev(edit, offset) {
        const preText = edit.newText.substr(0, offset);
        const postText = edit.newText.substr(offset);
        return [
            ( new TextChange(edit.oldPosition, edit.oldText, edit.newPosition, preText)),
            ( new TextChange(edit.oldEnd, '', edit.newPosition + offset, postText))
        ];
    }
    static _splitCurr(edit, offset) {
        const preText = edit.oldText.substr(0, offset);
        const postText = edit.oldText.substr(offset);
        return [
            ( new TextChange(edit.oldPosition, preText, edit.newPosition, edit.newText)),
            ( new TextChange(edit.oldPosition + offset, postText, edit.newEnd, ''))
        ];
    }
    static _merge(edits) {
        if (edits.length === 0) {
            return edits;
        }
        const result = [];
        let resultLen = 0;
        let prev = edits[0];
        for (let i = 1; i < edits.length; i++) {
            const curr = edits[i];
            if (prev.oldEnd === curr.oldPosition) {
                prev = ( new TextChange(
                    prev.oldPosition,
                    prev.oldText + curr.oldText,
                    prev.newPosition,
                    prev.newText + curr.newText
                ));
            }
            else {
                result[resultLen++] = prev;
                prev = curr;
            }
        }
        result[resultLen++] = prev;
        return result;
    }
    static _removeNoOps(edits) {
        if (edits.length === 0) {
            return edits;
        }
        const result = [];
        let resultLen = 0;
        for (let i = 0; i < edits.length; i++) {
            const edit = edits[i];
            if (edit.oldText === edit.newText) {
                continue;
            }
            result[resultLen++] = edit;
        }
        return result;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/textModelDefaults.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/textModelDefaults.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EDITOR_MODEL_DEFAULTS: () => (/* binding */ EDITOR_MODEL_DEFAULTS)
/* harmony export */ });
const EDITOR_MODEL_DEFAULTS = {
    tabSize: 4,
    indentSize: 4,
    insertSpaces: true,
    detectIndentation: true,
    trimAutoWhitespace: true,
    largeFileOptimizations: true,
    bracketPairColorizationOptions: {
        enabled: true,
        independentColorPoolPerBracketType: false,
    },
};



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/languageSelector.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/languageSelector.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   score: () => (/* binding */ score),
/* harmony export */   targetsNotebooks: () => (/* binding */ targetsNotebooks)
/* harmony export */ });
/* harmony import */ var _base_common_glob_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../base/common/glob.js */ "./node_modules/vscode/vscode/src/vs/base/common/glob.js");
/* harmony import */ var _base_common_path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../base/common/path.js */ "./node_modules/vscode/vscode/src/vs/base/common/path.js");


function score(selector, candidateUri, candidateLanguage, candidateIsSynchronized, candidateNotebookUri, candidateNotebookType) {
    if (Array.isArray(selector)) {
        let ret = 0;
        for (const filter of selector) {
            const value = score(filter, candidateUri, candidateLanguage, candidateIsSynchronized, candidateNotebookUri, candidateNotebookType);
            if (value === 10) {
                return value;
            }
            if (value > ret) {
                ret = value;
            }
        }
        return ret;
    }
    else if (typeof selector === 'string') {
        if (!candidateIsSynchronized) {
            return 0;
        }
        if (selector === '*') {
            return 5;
        }
        else if (selector === candidateLanguage) {
            return 10;
        }
        else {
            return 0;
        }
    }
    else if (selector) {
        const { language, pattern, scheme, hasAccessToAllModels, notebookType } = selector;
        if (!candidateIsSynchronized && !hasAccessToAllModels) {
            return 0;
        }
        if (notebookType && candidateNotebookUri) {
            candidateUri = candidateNotebookUri;
        }
        let ret = 0;
        if (scheme) {
            if (scheme === candidateUri.scheme) {
                ret = 10;
            }
            else if (scheme === '*') {
                ret = 5;
            }
            else {
                return 0;
            }
        }
        if (language) {
            if (language === candidateLanguage) {
                ret = 10;
            }
            else if (language === '*') {
                ret = Math.max(ret, 5);
            }
            else {
                return 0;
            }
        }
        if (notebookType) {
            if (notebookType === candidateNotebookType) {
                ret = 10;
            }
            else if (notebookType === '*' && candidateNotebookType !== undefined) {
                ret = Math.max(ret, 5);
            }
            else {
                return 0;
            }
        }
        if (pattern) {
            let normalizedPattern;
            if (typeof pattern === 'string') {
                normalizedPattern = pattern;
            }
            else {
                normalizedPattern = { ...pattern, base: (0,_base_common_path_js__WEBPACK_IMPORTED_MODULE_1__.normalize)(pattern.base) };
            }
            if (normalizedPattern === candidateUri.fsPath || (0,_base_common_glob_js__WEBPACK_IMPORTED_MODULE_0__.match)(normalizedPattern, candidateUri.fsPath)) {
                ret = 10;
            }
            else {
                return 0;
            }
        }
        return ret;
    }
    else {
        return 0;
    }
}
function targetsNotebooks(selector) {
    if (typeof selector === 'string') {
        return false;
    }
    else if (Array.isArray(selector)) {
        return ( selector.some(targetsNotebooks));
    }
    else {
        return !!selector.notebookType;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/languages/languageConfiguration.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/languages/languageConfiguration.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AutoClosingPairs: () => (/* binding */ AutoClosingPairs),
/* harmony export */   IndentAction: () => (/* binding */ IndentAction),
/* harmony export */   StandardAutoClosingPairConditional: () => (/* binding */ StandardAutoClosingPairConditional)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _encodedTokenAttributes_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../encodedTokenAttributes.js */ "./node_modules/vscode/vscode/src/vs/editor/common/encodedTokenAttributes.js");


var IndentAction;
( (function(IndentAction) {
    IndentAction[IndentAction["None"] = 0] = "None";
    IndentAction[IndentAction["Indent"] = 1] = "Indent";
    IndentAction[IndentAction["IndentOutdent"] = 2] = "IndentOutdent";
    IndentAction[IndentAction["Outdent"] = 3] = "Outdent";
})(IndentAction || (IndentAction = {})));
class StandardAutoClosingPairConditional {
    constructor(source) {
        this._neutralCharacter = null;
        this._neutralCharacterSearched = false;
        this.open = source.open;
        this.close = source.close;
        this._inString = true;
        this._inComment = true;
        this._inRegEx = true;
        if (Array.isArray(source.notIn)) {
            for (let i = 0, len = source.notIn.length; i < len; i++) {
                const notIn = source.notIn[i];
                switch (notIn) {
                    case 'string':
                        this._inString = false;
                        break;
                    case 'comment':
                        this._inComment = false;
                        break;
                    case 'regex':
                        this._inRegEx = false;
                        break;
                }
            }
        }
    }
    isOK(standardToken) {
        switch (standardToken) {
            case _encodedTokenAttributes_js__WEBPACK_IMPORTED_MODULE_1__.StandardTokenType.Other:
                return true;
            case _encodedTokenAttributes_js__WEBPACK_IMPORTED_MODULE_1__.StandardTokenType.Comment:
                return this._inComment;
            case _encodedTokenAttributes_js__WEBPACK_IMPORTED_MODULE_1__.StandardTokenType.String:
                return this._inString;
            case _encodedTokenAttributes_js__WEBPACK_IMPORTED_MODULE_1__.StandardTokenType.RegEx:
                return this._inRegEx;
        }
    }
    shouldAutoClose(context, column) {
        if (context.getTokenCount() === 0) {
            return true;
        }
        const tokenIndex = context.findTokenIndexAtOffset(column - 2);
        const standardTokenType = context.getStandardTokenType(tokenIndex);
        return this.isOK(standardTokenType);
    }
    _findNeutralCharacterInRange(fromCharCode, toCharCode) {
        for (let charCode = fromCharCode; charCode <= toCharCode; charCode++) {
            const character = String.fromCharCode(charCode);
            if (!this.open.includes(character) && !this.close.includes(character)) {
                return character;
            }
        }
        return null;
    }
    findNeutralCharacter() {
        if (!this._neutralCharacterSearched) {
            this._neutralCharacterSearched = true;
            if (!this._neutralCharacter) {
                this._neutralCharacter = this._findNeutralCharacterInRange(_base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit0, _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit9);
            }
            if (!this._neutralCharacter) {
                this._neutralCharacter = this._findNeutralCharacterInRange(_base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.a, _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.z);
            }
            if (!this._neutralCharacter) {
                this._neutralCharacter = this._findNeutralCharacterInRange(_base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.A, _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Z);
            }
        }
        return this._neutralCharacter;
    }
}
class AutoClosingPairs {
    constructor(autoClosingPairs) {
        this.autoClosingPairsOpenByStart = ( new Map());
        this.autoClosingPairsOpenByEnd = ( new Map());
        this.autoClosingPairsCloseByStart = ( new Map());
        this.autoClosingPairsCloseByEnd = ( new Map());
        this.autoClosingPairsCloseSingleChar = ( new Map());
        for (const pair of autoClosingPairs) {
            appendEntry(this.autoClosingPairsOpenByStart, pair.open.charAt(0), pair);
            appendEntry(this.autoClosingPairsOpenByEnd, pair.open.charAt(pair.open.length - 1), pair);
            appendEntry(this.autoClosingPairsCloseByStart, pair.close.charAt(0), pair);
            appendEntry(this.autoClosingPairsCloseByEnd, pair.close.charAt(pair.close.length - 1), pair);
            if (pair.close.length === 1 && pair.open.length === 1) {
                appendEntry(this.autoClosingPairsCloseSingleChar, pair.close, pair);
            }
        }
    }
}
function appendEntry(target, key, value) {
    if (( target.has(key))) {
        target.get(key).push(value);
    }
    else {
        target.set(key, [value]);
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeBase.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeBase.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Piece: () => (/* binding */ Piece),
/* harmony export */   PieceTreeBase: () => (/* binding */ PieceTreeBase),
/* harmony export */   StringBuffer: () => (/* binding */ StringBuffer),
/* harmony export */   createLineStarts: () => (/* binding */ createLineStarts),
/* harmony export */   createLineStartsFast: () => (/* binding */ createLineStartsFast)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _core_position_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/position.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/position.js");
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _model_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../model.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model.js");
/* harmony import */ var _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./rbTreeBase.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/rbTreeBase.js");
/* harmony import */ var _textModelSearch_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../textModelSearch.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model/textModelSearch.js");






const AverageBufferSize = 65535;
function createUintArray(arr) {
    let r;
    if (arr[arr.length - 1] < 65536) {
        r = ( new Uint16Array(arr.length));
    }
    else {
        r = ( new Uint32Array(arr.length));
    }
    r.set(arr, 0);
    return r;
}
class LineStarts {
    constructor(lineStarts, cr, lf, crlf, isBasicASCII) {
        this.lineStarts = lineStarts;
        this.cr = cr;
        this.lf = lf;
        this.crlf = crlf;
        this.isBasicASCII = isBasicASCII;
    }
}
function createLineStartsFast(str, readonly = true) {
    const r = [0];
    let rLength = 1;
    for (let i = 0, len = str.length; i < len; i++) {
        const chr = str.charCodeAt(i);
        if (chr === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn) {
            if (i + 1 < len && str.charCodeAt(i + 1) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
                r[rLength++] = i + 2;
                i++;
            }
            else {
                r[rLength++] = i + 1;
            }
        }
        else if (chr === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
            r[rLength++] = i + 1;
        }
    }
    if (readonly) {
        return createUintArray(r);
    }
    else {
        return r;
    }
}
function createLineStarts(r, str) {
    r.length = 0;
    r[0] = 0;
    let rLength = 1;
    let cr = 0, lf = 0, crlf = 0;
    let isBasicASCII = true;
    for (let i = 0, len = str.length; i < len; i++) {
        const chr = str.charCodeAt(i);
        if (chr === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn) {
            if (i + 1 < len && str.charCodeAt(i + 1) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
                crlf++;
                r[rLength++] = i + 2;
                i++;
            }
            else {
                cr++;
                r[rLength++] = i + 1;
            }
        }
        else if (chr === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
            lf++;
            r[rLength++] = i + 1;
        }
        else {
            if (isBasicASCII) {
                if (chr !== _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Tab && (chr < 32 || chr > 126)) {
                    isBasicASCII = false;
                }
            }
        }
    }
    const result = ( new LineStarts(createUintArray(r), cr, lf, crlf, isBasicASCII));
    r.length = 0;
    return result;
}
class Piece {
    constructor(bufferIndex, start, end, lineFeedCnt, length) {
        this.bufferIndex = bufferIndex;
        this.start = start;
        this.end = end;
        this.lineFeedCnt = lineFeedCnt;
        this.length = length;
    }
}
class StringBuffer {
    constructor(buffer, lineStarts) {
        this.buffer = buffer;
        this.lineStarts = lineStarts;
    }
}
class PieceTreeSnapshot {
    constructor(tree, BOM) {
        this._pieces = [];
        this._tree = tree;
        this._BOM = BOM;
        this._index = 0;
        if (tree.root !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            tree.iterate(tree.root, node => {
                if (node !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
                    this._pieces.push(node.piece);
                }
                return true;
            });
        }
    }
    read() {
        if (this._pieces.length === 0) {
            if (this._index === 0) {
                this._index++;
                return this._BOM;
            }
            else {
                return null;
            }
        }
        if (this._index > this._pieces.length - 1) {
            return null;
        }
        if (this._index === 0) {
            return this._BOM + this._tree.getPieceContent(this._pieces[this._index++]);
        }
        return this._tree.getPieceContent(this._pieces[this._index++]);
    }
}
class PieceTreeSearchCache {
    constructor(limit) {
        this._limit = limit;
        this._cache = [];
    }
    get(offset) {
        for (let i = this._cache.length - 1; i >= 0; i--) {
            const nodePos = this._cache[i];
            if (nodePos.nodeStartOffset <= offset && nodePos.nodeStartOffset + nodePos.node.piece.length >= offset) {
                return nodePos;
            }
        }
        return null;
    }
    get2(lineNumber) {
        for (let i = this._cache.length - 1; i >= 0; i--) {
            const nodePos = this._cache[i];
            if (nodePos.nodeStartLineNumber && nodePos.nodeStartLineNumber < lineNumber && nodePos.nodeStartLineNumber + nodePos.node.piece.lineFeedCnt >= lineNumber) {
                return nodePos;
            }
        }
        return null;
    }
    set(nodePosition) {
        if (this._cache.length >= this._limit) {
            this._cache.shift();
        }
        this._cache.push(nodePosition);
    }
    validate(offset) {
        let hasInvalidVal = false;
        const tmp = this._cache;
        for (let i = 0; i < tmp.length; i++) {
            const nodePos = tmp[i];
            if (nodePos.node.parent === null || nodePos.nodeStartOffset >= offset) {
                tmp[i] = null;
                hasInvalidVal = true;
                continue;
            }
        }
        if (hasInvalidVal) {
            const newArr = [];
            for (const entry of tmp) {
                if (entry !== null) {
                    newArr.push(entry);
                }
            }
            this._cache = newArr;
        }
    }
}
class PieceTreeBase {
    constructor(chunks, eol, eolNormalized) {
        this.create(chunks, eol, eolNormalized);
    }
    create(chunks, eol, eolNormalized) {
        this._buffers = [
            ( new StringBuffer('', [0]))
        ];
        this._lastChangeBufferPos = { line: 0, column: 0 };
        this.root = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL;
        this._lineCnt = 1;
        this._length = 0;
        this._EOL = eol;
        this._EOLLength = eol.length;
        this._EOLNormalized = eolNormalized;
        let lastNode = null;
        for (let i = 0, len = chunks.length; i < len; i++) {
            if (chunks[i].buffer.length > 0) {
                if (!chunks[i].lineStarts) {
                    chunks[i].lineStarts = createLineStartsFast(chunks[i].buffer);
                }
                const piece = ( new Piece(
                    i + 1,
                    { line: 0, column: 0 },
                    { line: chunks[i].lineStarts.length - 1, column: chunks[i].buffer.length - chunks[i].lineStarts[chunks[i].lineStarts.length - 1] },
                    chunks[i].lineStarts.length - 1,
                    chunks[i].buffer.length
                ));
                this._buffers.push(chunks[i]);
                lastNode = this.rbInsertRight(lastNode, piece);
            }
        }
        this._searchCache = ( new PieceTreeSearchCache(1));
        this._lastVisitedLine = { lineNumber: 0, value: '' };
        this.computeBufferMetadata();
    }
    normalizeEOL(eol) {
        const averageBufferSize = AverageBufferSize;
        const min = averageBufferSize - Math.floor(averageBufferSize / 3);
        const max = min * 2;
        let tempChunk = '';
        let tempChunkLen = 0;
        const chunks = [];
        this.iterate(this.root, node => {
            const str = this.getNodeContent(node);
            const len = str.length;
            if (tempChunkLen <= min || tempChunkLen + len < max) {
                tempChunk += str;
                tempChunkLen += len;
                return true;
            }
            const text = tempChunk.replace(/\r\n|\r|\n/g, eol);
            chunks.push(( new StringBuffer(text, createLineStartsFast(text))));
            tempChunk = str;
            tempChunkLen = len;
            return true;
        });
        if (tempChunkLen > 0) {
            const text = tempChunk.replace(/\r\n|\r|\n/g, eol);
            chunks.push(( new StringBuffer(text, createLineStartsFast(text))));
        }
        this.create(chunks, eol, true);
    }
    getEOL() {
        return this._EOL;
    }
    setEOL(newEOL) {
        this._EOL = newEOL;
        this._EOLLength = this._EOL.length;
        this.normalizeEOL(newEOL);
    }
    createSnapshot(BOM) {
        return ( new PieceTreeSnapshot(this, BOM));
    }
    equal(other) {
        if (this.getLength() !== other.getLength()) {
            return false;
        }
        if (this.getLineCount() !== other.getLineCount()) {
            return false;
        }
        let offset = 0;
        const ret = this.iterate(this.root, node => {
            if (node === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
                return true;
            }
            const str = this.getNodeContent(node);
            const len = str.length;
            const startPosition = other.nodeAt(offset);
            const endPosition = other.nodeAt(offset + len);
            const val = other.getValueInRange2(startPosition, endPosition);
            offset += len;
            return str === val;
        });
        return ret;
    }
    getOffsetAt(lineNumber, column) {
        let leftLen = 0;
        let x = this.root;
        while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            if (x.left !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL && x.lf_left + 1 >= lineNumber) {
                x = x.left;
            }
            else if (x.lf_left + x.piece.lineFeedCnt + 1 >= lineNumber) {
                leftLen += x.size_left;
                const accumualtedValInCurrentIndex = this.getAccumulatedValue(x, lineNumber - x.lf_left - 2);
                return leftLen += accumualtedValInCurrentIndex + column - 1;
            }
            else {
                lineNumber -= x.lf_left + x.piece.lineFeedCnt;
                leftLen += x.size_left + x.piece.length;
                x = x.right;
            }
        }
        return leftLen;
    }
    getPositionAt(offset) {
        offset = Math.floor(offset);
        offset = Math.max(0, offset);
        let x = this.root;
        let lfCnt = 0;
        const originalOffset = offset;
        while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            if (x.size_left !== 0 && x.size_left >= offset) {
                x = x.left;
            }
            else if (x.size_left + x.piece.length >= offset) {
                const out = this.getIndexOf(x, offset - x.size_left);
                lfCnt += x.lf_left + out.index;
                if (out.index === 0) {
                    const lineStartOffset = this.getOffsetAt(lfCnt + 1, 1);
                    const column = originalOffset - lineStartOffset;
                    return ( new _core_position_js__WEBPACK_IMPORTED_MODULE_1__.Position(lfCnt + 1, column + 1));
                }
                return ( new _core_position_js__WEBPACK_IMPORTED_MODULE_1__.Position(lfCnt + 1, out.remainder + 1));
            }
            else {
                offset -= x.size_left + x.piece.length;
                lfCnt += x.lf_left + x.piece.lineFeedCnt;
                if (x.right === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
                    const lineStartOffset = this.getOffsetAt(lfCnt + 1, 1);
                    const column = originalOffset - offset - lineStartOffset;
                    return ( new _core_position_js__WEBPACK_IMPORTED_MODULE_1__.Position(lfCnt + 1, column + 1));
                }
                else {
                    x = x.right;
                }
            }
        }
        return ( new _core_position_js__WEBPACK_IMPORTED_MODULE_1__.Position(1, 1));
    }
    getValueInRange(range, eol) {
        if (range.startLineNumber === range.endLineNumber && range.startColumn === range.endColumn) {
            return '';
        }
        const startPosition = this.nodeAt2(range.startLineNumber, range.startColumn);
        const endPosition = this.nodeAt2(range.endLineNumber, range.endColumn);
        const value = this.getValueInRange2(startPosition, endPosition);
        if (eol) {
            if (eol !== this._EOL || !this._EOLNormalized) {
                return value.replace(/\r\n|\r|\n/g, eol);
            }
            if (eol === this.getEOL() && this._EOLNormalized) {
                return value;
            }
            return value.replace(/\r\n|\r|\n/g, eol);
        }
        return value;
    }
    getValueInRange2(startPosition, endPosition) {
        if (startPosition.node === endPosition.node) {
            const node = startPosition.node;
            const buffer = this._buffers[node.piece.bufferIndex].buffer;
            const startOffset = this.offsetInBuffer(node.piece.bufferIndex, node.piece.start);
            return buffer.substring(startOffset + startPosition.remainder, startOffset + endPosition.remainder);
        }
        let x = startPosition.node;
        const buffer = this._buffers[x.piece.bufferIndex].buffer;
        const startOffset = this.offsetInBuffer(x.piece.bufferIndex, x.piece.start);
        let ret = buffer.substring(startOffset + startPosition.remainder, startOffset + x.piece.length);
        x = x.next();
        while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            const buffer = this._buffers[x.piece.bufferIndex].buffer;
            const startOffset = this.offsetInBuffer(x.piece.bufferIndex, x.piece.start);
            if (x === endPosition.node) {
                ret += buffer.substring(startOffset, startOffset + endPosition.remainder);
                break;
            }
            else {
                ret += buffer.substr(startOffset, x.piece.length);
            }
            x = x.next();
        }
        return ret;
    }
    getLinesContent() {
        const lines = [];
        let linesLength = 0;
        let currentLine = '';
        let danglingCR = false;
        this.iterate(this.root, node => {
            if (node === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
                return true;
            }
            const piece = node.piece;
            let pieceLength = piece.length;
            if (pieceLength === 0) {
                return true;
            }
            const buffer = this._buffers[piece.bufferIndex].buffer;
            const lineStarts = this._buffers[piece.bufferIndex].lineStarts;
            const pieceStartLine = piece.start.line;
            const pieceEndLine = piece.end.line;
            let pieceStartOffset = lineStarts[pieceStartLine] + piece.start.column;
            if (danglingCR) {
                if (buffer.charCodeAt(pieceStartOffset) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
                    pieceStartOffset++;
                    pieceLength--;
                }
                lines[linesLength++] = currentLine;
                currentLine = '';
                danglingCR = false;
                if (pieceLength === 0) {
                    return true;
                }
            }
            if (pieceStartLine === pieceEndLine) {
                if (!this._EOLNormalized && buffer.charCodeAt(pieceStartOffset + pieceLength - 1) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn) {
                    danglingCR = true;
                    currentLine += buffer.substr(pieceStartOffset, pieceLength - 1);
                }
                else {
                    currentLine += buffer.substr(pieceStartOffset, pieceLength);
                }
                return true;
            }
            currentLine += (this._EOLNormalized
                ? buffer.substring(pieceStartOffset, Math.max(pieceStartOffset, lineStarts[pieceStartLine + 1] - this._EOLLength))
                : buffer.substring(pieceStartOffset, lineStarts[pieceStartLine + 1]).replace(/(\r\n|\r|\n)$/, ''));
            lines[linesLength++] = currentLine;
            for (let line = pieceStartLine + 1; line < pieceEndLine; line++) {
                currentLine = (this._EOLNormalized
                    ? buffer.substring(lineStarts[line], lineStarts[line + 1] - this._EOLLength)
                    : buffer.substring(lineStarts[line], lineStarts[line + 1]).replace(/(\r\n|\r|\n)$/, ''));
                lines[linesLength++] = currentLine;
            }
            if (!this._EOLNormalized && buffer.charCodeAt(lineStarts[pieceEndLine] + piece.end.column - 1) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn) {
                danglingCR = true;
                if (piece.end.column === 0) {
                    linesLength--;
                }
                else {
                    currentLine = buffer.substr(lineStarts[pieceEndLine], piece.end.column - 1);
                }
            }
            else {
                currentLine = buffer.substr(lineStarts[pieceEndLine], piece.end.column);
            }
            return true;
        });
        if (danglingCR) {
            lines[linesLength++] = currentLine;
            currentLine = '';
        }
        lines[linesLength++] = currentLine;
        return lines;
    }
    getLength() {
        return this._length;
    }
    getLineCount() {
        return this._lineCnt;
    }
    getLineContent(lineNumber) {
        if (this._lastVisitedLine.lineNumber === lineNumber) {
            return this._lastVisitedLine.value;
        }
        this._lastVisitedLine.lineNumber = lineNumber;
        if (lineNumber === this._lineCnt) {
            this._lastVisitedLine.value = this.getLineRawContent(lineNumber);
        }
        else if (this._EOLNormalized) {
            this._lastVisitedLine.value = this.getLineRawContent(lineNumber, this._EOLLength);
        }
        else {
            this._lastVisitedLine.value = this.getLineRawContent(lineNumber).replace(/(\r\n|\r|\n)$/, '');
        }
        return this._lastVisitedLine.value;
    }
    _getCharCode(nodePos) {
        if (nodePos.remainder === nodePos.node.piece.length) {
            const matchingNode = nodePos.node.next();
            if (!matchingNode) {
                return 0;
            }
            const buffer = this._buffers[matchingNode.piece.bufferIndex];
            const startOffset = this.offsetInBuffer(matchingNode.piece.bufferIndex, matchingNode.piece.start);
            return buffer.buffer.charCodeAt(startOffset);
        }
        else {
            const buffer = this._buffers[nodePos.node.piece.bufferIndex];
            const startOffset = this.offsetInBuffer(nodePos.node.piece.bufferIndex, nodePos.node.piece.start);
            const targetOffset = startOffset + nodePos.remainder;
            return buffer.buffer.charCodeAt(targetOffset);
        }
    }
    getLineCharCode(lineNumber, index) {
        const nodePos = this.nodeAt2(lineNumber, index + 1);
        return this._getCharCode(nodePos);
    }
    getLineLength(lineNumber) {
        if (lineNumber === this.getLineCount()) {
            const startOffset = this.getOffsetAt(lineNumber, 1);
            return this.getLength() - startOffset;
        }
        return this.getOffsetAt(lineNumber + 1, 1) - this.getOffsetAt(lineNumber, 1) - this._EOLLength;
    }
    getCharCode(offset) {
        const nodePos = this.nodeAt(offset);
        return this._getCharCode(nodePos);
    }
    getNearestChunk(offset) {
        const nodePos = this.nodeAt(offset);
        if (nodePos.remainder === nodePos.node.piece.length) {
            const matchingNode = nodePos.node.next();
            if (!matchingNode || matchingNode === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
                return '';
            }
            const buffer = this._buffers[matchingNode.piece.bufferIndex];
            const startOffset = this.offsetInBuffer(matchingNode.piece.bufferIndex, matchingNode.piece.start);
            return buffer.buffer.substring(startOffset, startOffset + matchingNode.piece.length);
        }
        else {
            const buffer = this._buffers[nodePos.node.piece.bufferIndex];
            const startOffset = this.offsetInBuffer(nodePos.node.piece.bufferIndex, nodePos.node.piece.start);
            const targetOffset = startOffset + nodePos.remainder;
            const targetEnd = startOffset + nodePos.node.piece.length;
            return buffer.buffer.substring(targetOffset, targetEnd);
        }
    }
    findMatchesInNode(node, searcher, startLineNumber, startColumn, startCursor, endCursor, searchData, captureMatches, limitResultCount, resultLen, result) {
        const buffer = this._buffers[node.piece.bufferIndex];
        const startOffsetInBuffer = this.offsetInBuffer(node.piece.bufferIndex, node.piece.start);
        const start = this.offsetInBuffer(node.piece.bufferIndex, startCursor);
        const end = this.offsetInBuffer(node.piece.bufferIndex, endCursor);
        let m;
        const ret = { line: 0, column: 0 };
        let searchText;
        let offsetInBuffer;
        if (searcher._wordSeparators) {
            searchText = buffer.buffer.substring(start, end);
            offsetInBuffer = (offset) => offset + start;
            searcher.reset(0);
        }
        else {
            searchText = buffer.buffer;
            offsetInBuffer = (offset) => offset;
            searcher.reset(start);
        }
        do {
            m = searcher.next(searchText);
            if (m) {
                if (offsetInBuffer(m.index) >= end) {
                    return resultLen;
                }
                this.positionInBuffer(node, offsetInBuffer(m.index) - startOffsetInBuffer, ret);
                const lineFeedCnt = this.getLineFeedCnt(node.piece.bufferIndex, startCursor, ret);
                const retStartColumn = ret.line === startCursor.line ? ret.column - startCursor.column + startColumn : ret.column + 1;
                const retEndColumn = retStartColumn + m[0].length;
                result[resultLen++] = (0,_textModelSearch_js__WEBPACK_IMPORTED_MODULE_5__.createFindMatch)(( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                    startLineNumber + lineFeedCnt,
                    retStartColumn,
                    startLineNumber + lineFeedCnt,
                    retEndColumn
                )), m, captureMatches);
                if (offsetInBuffer(m.index) + m[0].length >= end) {
                    return resultLen;
                }
                if (resultLen >= limitResultCount) {
                    return resultLen;
                }
            }
        } while (m);
        return resultLen;
    }
    findMatchesLineByLine(searchRange, searchData, captureMatches, limitResultCount) {
        const result = [];
        let resultLen = 0;
        const searcher = ( new _textModelSearch_js__WEBPACK_IMPORTED_MODULE_5__.Searcher(searchData.wordSeparators, searchData.regex));
        let startPosition = this.nodeAt2(searchRange.startLineNumber, searchRange.startColumn);
        if (startPosition === null) {
            return [];
        }
        const endPosition = this.nodeAt2(searchRange.endLineNumber, searchRange.endColumn);
        if (endPosition === null) {
            return [];
        }
        let start = this.positionInBuffer(startPosition.node, startPosition.remainder);
        const end = this.positionInBuffer(endPosition.node, endPosition.remainder);
        if (startPosition.node === endPosition.node) {
            this.findMatchesInNode(startPosition.node, searcher, searchRange.startLineNumber, searchRange.startColumn, start, end, searchData, captureMatches, limitResultCount, resultLen, result);
            return result;
        }
        let startLineNumber = searchRange.startLineNumber;
        let currentNode = startPosition.node;
        while (currentNode !== endPosition.node) {
            const lineBreakCnt = this.getLineFeedCnt(currentNode.piece.bufferIndex, start, currentNode.piece.end);
            if (lineBreakCnt >= 1) {
                const lineStarts = this._buffers[currentNode.piece.bufferIndex].lineStarts;
                const startOffsetInBuffer = this.offsetInBuffer(currentNode.piece.bufferIndex, currentNode.piece.start);
                const nextLineStartOffset = lineStarts[start.line + lineBreakCnt];
                const startColumn = startLineNumber === searchRange.startLineNumber ? searchRange.startColumn : 1;
                resultLen = this.findMatchesInNode(currentNode, searcher, startLineNumber, startColumn, start, this.positionInBuffer(currentNode, nextLineStartOffset - startOffsetInBuffer), searchData, captureMatches, limitResultCount, resultLen, result);
                if (resultLen >= limitResultCount) {
                    return result;
                }
                startLineNumber += lineBreakCnt;
            }
            const startColumn = startLineNumber === searchRange.startLineNumber ? searchRange.startColumn - 1 : 0;
            if (startLineNumber === searchRange.endLineNumber) {
                const text = this.getLineContent(startLineNumber).substring(startColumn, searchRange.endColumn - 1);
                resultLen = this._findMatchesInLine(searchData, searcher, text, searchRange.endLineNumber, startColumn, resultLen, result, captureMatches, limitResultCount);
                return result;
            }
            resultLen = this._findMatchesInLine(searchData, searcher, this.getLineContent(startLineNumber).substr(startColumn), startLineNumber, startColumn, resultLen, result, captureMatches, limitResultCount);
            if (resultLen >= limitResultCount) {
                return result;
            }
            startLineNumber++;
            startPosition = this.nodeAt2(startLineNumber, 1);
            currentNode = startPosition.node;
            start = this.positionInBuffer(startPosition.node, startPosition.remainder);
        }
        if (startLineNumber === searchRange.endLineNumber) {
            const startColumn = startLineNumber === searchRange.startLineNumber ? searchRange.startColumn - 1 : 0;
            const text = this.getLineContent(startLineNumber).substring(startColumn, searchRange.endColumn - 1);
            resultLen = this._findMatchesInLine(searchData, searcher, text, searchRange.endLineNumber, startColumn, resultLen, result, captureMatches, limitResultCount);
            return result;
        }
        const startColumn = startLineNumber === searchRange.startLineNumber ? searchRange.startColumn : 1;
        resultLen = this.findMatchesInNode(endPosition.node, searcher, startLineNumber, startColumn, start, end, searchData, captureMatches, limitResultCount, resultLen, result);
        return result;
    }
    _findMatchesInLine(searchData, searcher, text, lineNumber, deltaOffset, resultLen, result, captureMatches, limitResultCount) {
        const wordSeparators = searchData.wordSeparators;
        if (!captureMatches && searchData.simpleSearch) {
            const searchString = searchData.simpleSearch;
            const searchStringLen = searchString.length;
            const textLength = text.length;
            let lastMatchIndex = -searchStringLen;
            while ((lastMatchIndex = text.indexOf(searchString, lastMatchIndex + searchStringLen)) !== -1) {
                if (!wordSeparators || (0,_textModelSearch_js__WEBPACK_IMPORTED_MODULE_5__.isValidMatch)(wordSeparators, text, textLength, lastMatchIndex, searchStringLen)) {
                    result[resultLen++] = ( new _model_js__WEBPACK_IMPORTED_MODULE_3__.FindMatch(( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                        lineNumber,
                        lastMatchIndex + 1 + deltaOffset,
                        lineNumber,
                        lastMatchIndex + 1 + searchStringLen + deltaOffset
                    )), null));
                    if (resultLen >= limitResultCount) {
                        return resultLen;
                    }
                }
            }
            return resultLen;
        }
        let m;
        searcher.reset(0);
        do {
            m = searcher.next(text);
            if (m) {
                result[resultLen++] = (0,_textModelSearch_js__WEBPACK_IMPORTED_MODULE_5__.createFindMatch)(( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                    lineNumber,
                    m.index + 1 + deltaOffset,
                    lineNumber,
                    m.index + 1 + m[0].length + deltaOffset
                )), m, captureMatches);
                if (resultLen >= limitResultCount) {
                    return resultLen;
                }
            }
        } while (m);
        return resultLen;
    }
    insert(offset, value, eolNormalized = false) {
        this._EOLNormalized = this._EOLNormalized && eolNormalized;
        this._lastVisitedLine.lineNumber = 0;
        this._lastVisitedLine.value = '';
        if (this.root !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            const { node, remainder, nodeStartOffset } = this.nodeAt(offset);
            const piece = node.piece;
            const bufferIndex = piece.bufferIndex;
            const insertPosInBuffer = this.positionInBuffer(node, remainder);
            if (node.piece.bufferIndex === 0 &&
                piece.end.line === this._lastChangeBufferPos.line &&
                piece.end.column === this._lastChangeBufferPos.column &&
                (nodeStartOffset + piece.length === offset) &&
                value.length < AverageBufferSize) {
                this.appendToNode(node, value);
                this.computeBufferMetadata();
                return;
            }
            if (nodeStartOffset === offset) {
                this.insertContentToNodeLeft(value, node);
                this._searchCache.validate(offset);
            }
            else if (nodeStartOffset + node.piece.length > offset) {
                const nodesToDel = [];
                let newRightPiece = ( new Piece(
                    piece.bufferIndex,
                    insertPosInBuffer,
                    piece.end,
                    this.getLineFeedCnt(piece.bufferIndex, insertPosInBuffer, piece.end),
                    this.offsetInBuffer(bufferIndex, piece.end) - this.offsetInBuffer(bufferIndex, insertPosInBuffer)
                ));
                if (this.shouldCheckCRLF() && this.endWithCR(value)) {
                    const headOfRight = this.nodeCharCodeAt(node, remainder);
                    if (headOfRight === 10 ) {
                        const newStart = { line: newRightPiece.start.line + 1, column: 0 };
                        newRightPiece = ( new Piece(
                            newRightPiece.bufferIndex,
                            newStart,
                            newRightPiece.end,
                            this.getLineFeedCnt(newRightPiece.bufferIndex, newStart, newRightPiece.end),
                            newRightPiece.length - 1
                        ));
                        value += '\n';
                    }
                }
                if (this.shouldCheckCRLF() && this.startWithLF(value)) {
                    const tailOfLeft = this.nodeCharCodeAt(node, remainder - 1);
                    if (tailOfLeft === 13 ) {
                        const previousPos = this.positionInBuffer(node, remainder - 1);
                        this.deleteNodeTail(node, previousPos);
                        value = '\r' + value;
                        if (node.piece.length === 0) {
                            nodesToDel.push(node);
                        }
                    }
                    else {
                        this.deleteNodeTail(node, insertPosInBuffer);
                    }
                }
                else {
                    this.deleteNodeTail(node, insertPosInBuffer);
                }
                const newPieces = this.createNewPieces(value);
                if (newRightPiece.length > 0) {
                    this.rbInsertRight(node, newRightPiece);
                }
                let tmpNode = node;
                for (let k = 0; k < newPieces.length; k++) {
                    tmpNode = this.rbInsertRight(tmpNode, newPieces[k]);
                }
                this.deleteNodes(nodesToDel);
            }
            else {
                this.insertContentToNodeRight(value, node);
            }
        }
        else {
            const pieces = this.createNewPieces(value);
            let node = this.rbInsertLeft(null, pieces[0]);
            for (let k = 1; k < pieces.length; k++) {
                node = this.rbInsertRight(node, pieces[k]);
            }
        }
        this.computeBufferMetadata();
    }
    delete(offset, cnt) {
        this._lastVisitedLine.lineNumber = 0;
        this._lastVisitedLine.value = '';
        if (cnt <= 0 || this.root === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            return;
        }
        const startPosition = this.nodeAt(offset);
        const endPosition = this.nodeAt(offset + cnt);
        const startNode = startPosition.node;
        const endNode = endPosition.node;
        if (startNode === endNode) {
            const startSplitPosInBuffer = this.positionInBuffer(startNode, startPosition.remainder);
            const endSplitPosInBuffer = this.positionInBuffer(startNode, endPosition.remainder);
            if (startPosition.nodeStartOffset === offset) {
                if (cnt === startNode.piece.length) {
                    const next = startNode.next();
                    (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.rbDelete)(this, startNode);
                    this.validateCRLFWithPrevNode(next);
                    this.computeBufferMetadata();
                    return;
                }
                this.deleteNodeHead(startNode, endSplitPosInBuffer);
                this._searchCache.validate(offset);
                this.validateCRLFWithPrevNode(startNode);
                this.computeBufferMetadata();
                return;
            }
            if (startPosition.nodeStartOffset + startNode.piece.length === offset + cnt) {
                this.deleteNodeTail(startNode, startSplitPosInBuffer);
                this.validateCRLFWithNextNode(startNode);
                this.computeBufferMetadata();
                return;
            }
            this.shrinkNode(startNode, startSplitPosInBuffer, endSplitPosInBuffer);
            this.computeBufferMetadata();
            return;
        }
        const nodesToDel = [];
        const startSplitPosInBuffer = this.positionInBuffer(startNode, startPosition.remainder);
        this.deleteNodeTail(startNode, startSplitPosInBuffer);
        this._searchCache.validate(offset);
        if (startNode.piece.length === 0) {
            nodesToDel.push(startNode);
        }
        const endSplitPosInBuffer = this.positionInBuffer(endNode, endPosition.remainder);
        this.deleteNodeHead(endNode, endSplitPosInBuffer);
        if (endNode.piece.length === 0) {
            nodesToDel.push(endNode);
        }
        const secondNode = startNode.next();
        for (let node = secondNode; node !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL && node !== endNode; node = node.next()) {
            nodesToDel.push(node);
        }
        const prev = startNode.piece.length === 0 ? startNode.prev() : startNode;
        this.deleteNodes(nodesToDel);
        this.validateCRLFWithNextNode(prev);
        this.computeBufferMetadata();
    }
    insertContentToNodeLeft(value, node) {
        const nodesToDel = [];
        if (this.shouldCheckCRLF() && this.endWithCR(value) && this.startWithLF(node)) {
            const piece = node.piece;
            const newStart = { line: piece.start.line + 1, column: 0 };
            const nPiece = ( new Piece(
                piece.bufferIndex,
                newStart,
                piece.end,
                this.getLineFeedCnt(piece.bufferIndex, newStart, piece.end),
                piece.length - 1
            ));
            node.piece = nPiece;
            value += '\n';
            (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.updateTreeMetadata)(this, node, -1, -1);
            if (node.piece.length === 0) {
                nodesToDel.push(node);
            }
        }
        const newPieces = this.createNewPieces(value);
        let newNode = this.rbInsertLeft(node, newPieces[newPieces.length - 1]);
        for (let k = newPieces.length - 2; k >= 0; k--) {
            newNode = this.rbInsertLeft(newNode, newPieces[k]);
        }
        this.validateCRLFWithPrevNode(newNode);
        this.deleteNodes(nodesToDel);
    }
    insertContentToNodeRight(value, node) {
        if (this.adjustCarriageReturnFromNext(value, node)) {
            value += '\n';
        }
        const newPieces = this.createNewPieces(value);
        const newNode = this.rbInsertRight(node, newPieces[0]);
        let tmpNode = newNode;
        for (let k = 1; k < newPieces.length; k++) {
            tmpNode = this.rbInsertRight(tmpNode, newPieces[k]);
        }
        this.validateCRLFWithPrevNode(newNode);
    }
    positionInBuffer(node, remainder, ret) {
        const piece = node.piece;
        const bufferIndex = node.piece.bufferIndex;
        const lineStarts = this._buffers[bufferIndex].lineStarts;
        const startOffset = lineStarts[piece.start.line] + piece.start.column;
        const offset = startOffset + remainder;
        let low = piece.start.line;
        let high = piece.end.line;
        let mid = 0;
        let midStop = 0;
        let midStart = 0;
        while (low <= high) {
            mid = low + ((high - low) / 2) | 0;
            midStart = lineStarts[mid];
            if (mid === high) {
                break;
            }
            midStop = lineStarts[mid + 1];
            if (offset < midStart) {
                high = mid - 1;
            }
            else if (offset >= midStop) {
                low = mid + 1;
            }
            else {
                break;
            }
        }
        if (ret) {
            ret.line = mid;
            ret.column = offset - midStart;
            return null;
        }
        return {
            line: mid,
            column: offset - midStart
        };
    }
    getLineFeedCnt(bufferIndex, start, end) {
        if (end.column === 0) {
            return end.line - start.line;
        }
        const lineStarts = this._buffers[bufferIndex].lineStarts;
        if (end.line === lineStarts.length - 1) {
            return end.line - start.line;
        }
        const nextLineStartOffset = lineStarts[end.line + 1];
        const endOffset = lineStarts[end.line] + end.column;
        if (nextLineStartOffset > endOffset + 1) {
            return end.line - start.line;
        }
        const previousCharOffset = endOffset - 1;
        const buffer = this._buffers[bufferIndex].buffer;
        if (buffer.charCodeAt(previousCharOffset) === 13) {
            return end.line - start.line + 1;
        }
        else {
            return end.line - start.line;
        }
    }
    offsetInBuffer(bufferIndex, cursor) {
        const lineStarts = this._buffers[bufferIndex].lineStarts;
        return lineStarts[cursor.line] + cursor.column;
    }
    deleteNodes(nodes) {
        for (let i = 0; i < nodes.length; i++) {
            (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.rbDelete)(this, nodes[i]);
        }
    }
    createNewPieces(text) {
        if (text.length > AverageBufferSize) {
            const newPieces = [];
            while (text.length > AverageBufferSize) {
                const lastChar = text.charCodeAt(AverageBufferSize - 1);
                let splitText;
                if (lastChar === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn || (lastChar >= 0xD800 && lastChar <= 0xDBFF)) {
                    splitText = text.substring(0, AverageBufferSize - 1);
                    text = text.substring(AverageBufferSize - 1);
                }
                else {
                    splitText = text.substring(0, AverageBufferSize);
                    text = text.substring(AverageBufferSize);
                }
                const lineStarts = createLineStartsFast(splitText);
                newPieces.push(( new Piece(
                    this._buffers.length,
                     { line: 0, column: 0 },
                    { line: lineStarts.length - 1, column: splitText.length - lineStarts[lineStarts.length - 1] },
                    lineStarts.length - 1,
                    splitText.length
                )));
                this._buffers.push(( new StringBuffer(splitText, lineStarts)));
            }
            const lineStarts = createLineStartsFast(text);
            newPieces.push(( new Piece(
                this._buffers.length,
                 { line: 0, column: 0 },
                { line: lineStarts.length - 1, column: text.length - lineStarts[lineStarts.length - 1] },
                lineStarts.length - 1,
                text.length
            )));
            this._buffers.push(( new StringBuffer(text, lineStarts)));
            return newPieces;
        }
        let startOffset = this._buffers[0].buffer.length;
        const lineStarts = createLineStartsFast(text, false);
        let start = this._lastChangeBufferPos;
        if (this._buffers[0].lineStarts[this._buffers[0].lineStarts.length - 1] === startOffset
            && startOffset !== 0
            && this.startWithLF(text)
            && this.endWithCR(this._buffers[0].buffer)
        ) {
            this._lastChangeBufferPos = { line: this._lastChangeBufferPos.line, column: this._lastChangeBufferPos.column + 1 };
            start = this._lastChangeBufferPos;
            for (let i = 0; i < lineStarts.length; i++) {
                lineStarts[i] += startOffset + 1;
            }
            this._buffers[0].lineStarts = this._buffers[0].lineStarts.concat(lineStarts.slice(1));
            this._buffers[0].buffer += '_' + text;
            startOffset += 1;
        }
        else {
            if (startOffset !== 0) {
                for (let i = 0; i < lineStarts.length; i++) {
                    lineStarts[i] += startOffset;
                }
            }
            this._buffers[0].lineStarts = this._buffers[0].lineStarts.concat(lineStarts.slice(1));
            this._buffers[0].buffer += text;
        }
        const endOffset = this._buffers[0].buffer.length;
        const endIndex = this._buffers[0].lineStarts.length - 1;
        const endColumn = endOffset - this._buffers[0].lineStarts[endIndex];
        const endPos = { line: endIndex, column: endColumn };
        const newPiece = ( new Piece(
            0,
             start,
            endPos,
            this.getLineFeedCnt(0, start, endPos),
            endOffset - startOffset
        ));
        this._lastChangeBufferPos = endPos;
        return [newPiece];
    }
    getLinesRawContent() {
        return this.getContentOfSubTree(this.root);
    }
    getLineRawContent(lineNumber, endOffset = 0) {
        let x = this.root;
        let ret = '';
        const cache = this._searchCache.get2(lineNumber);
        if (cache) {
            x = cache.node;
            const prevAccumulatedValue = this.getAccumulatedValue(x, lineNumber - cache.nodeStartLineNumber - 1);
            const buffer = this._buffers[x.piece.bufferIndex].buffer;
            const startOffset = this.offsetInBuffer(x.piece.bufferIndex, x.piece.start);
            if (cache.nodeStartLineNumber + x.piece.lineFeedCnt === lineNumber) {
                ret = buffer.substring(startOffset + prevAccumulatedValue, startOffset + x.piece.length);
            }
            else {
                const accumulatedValue = this.getAccumulatedValue(x, lineNumber - cache.nodeStartLineNumber);
                return buffer.substring(startOffset + prevAccumulatedValue, startOffset + accumulatedValue - endOffset);
            }
        }
        else {
            let nodeStartOffset = 0;
            const originalLineNumber = lineNumber;
            while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
                if (x.left !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL && x.lf_left >= lineNumber - 1) {
                    x = x.left;
                }
                else if (x.lf_left + x.piece.lineFeedCnt > lineNumber - 1) {
                    const prevAccumulatedValue = this.getAccumulatedValue(x, lineNumber - x.lf_left - 2);
                    const accumulatedValue = this.getAccumulatedValue(x, lineNumber - x.lf_left - 1);
                    const buffer = this._buffers[x.piece.bufferIndex].buffer;
                    const startOffset = this.offsetInBuffer(x.piece.bufferIndex, x.piece.start);
                    nodeStartOffset += x.size_left;
                    this._searchCache.set({
                        node: x,
                        nodeStartOffset,
                        nodeStartLineNumber: originalLineNumber - (lineNumber - 1 - x.lf_left)
                    });
                    return buffer.substring(startOffset + prevAccumulatedValue, startOffset + accumulatedValue - endOffset);
                }
                else if (x.lf_left + x.piece.lineFeedCnt === lineNumber - 1) {
                    const prevAccumulatedValue = this.getAccumulatedValue(x, lineNumber - x.lf_left - 2);
                    const buffer = this._buffers[x.piece.bufferIndex].buffer;
                    const startOffset = this.offsetInBuffer(x.piece.bufferIndex, x.piece.start);
                    ret = buffer.substring(startOffset + prevAccumulatedValue, startOffset + x.piece.length);
                    break;
                }
                else {
                    lineNumber -= x.lf_left + x.piece.lineFeedCnt;
                    nodeStartOffset += x.size_left + x.piece.length;
                    x = x.right;
                }
            }
        }
        x = x.next();
        while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            const buffer = this._buffers[x.piece.bufferIndex].buffer;
            if (x.piece.lineFeedCnt > 0) {
                const accumulatedValue = this.getAccumulatedValue(x, 0);
                const startOffset = this.offsetInBuffer(x.piece.bufferIndex, x.piece.start);
                ret += buffer.substring(startOffset, startOffset + accumulatedValue - endOffset);
                return ret;
            }
            else {
                const startOffset = this.offsetInBuffer(x.piece.bufferIndex, x.piece.start);
                ret += buffer.substr(startOffset, x.piece.length);
            }
            x = x.next();
        }
        return ret;
    }
    computeBufferMetadata() {
        let x = this.root;
        let lfCnt = 1;
        let len = 0;
        while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            lfCnt += x.lf_left + x.piece.lineFeedCnt;
            len += x.size_left + x.piece.length;
            x = x.right;
        }
        this._lineCnt = lfCnt;
        this._length = len;
        this._searchCache.validate(this._length);
    }
    getIndexOf(node, accumulatedValue) {
        const piece = node.piece;
        const pos = this.positionInBuffer(node, accumulatedValue);
        const lineCnt = pos.line - piece.start.line;
        if (this.offsetInBuffer(piece.bufferIndex, piece.end) - this.offsetInBuffer(piece.bufferIndex, piece.start) === accumulatedValue) {
            const realLineCnt = this.getLineFeedCnt(node.piece.bufferIndex, piece.start, pos);
            if (realLineCnt !== lineCnt) {
                return { index: realLineCnt, remainder: 0 };
            }
        }
        return { index: lineCnt, remainder: pos.column };
    }
    getAccumulatedValue(node, index) {
        if (index < 0) {
            return 0;
        }
        const piece = node.piece;
        const lineStarts = this._buffers[piece.bufferIndex].lineStarts;
        const expectedLineStartIndex = piece.start.line + index + 1;
        if (expectedLineStartIndex > piece.end.line) {
            return lineStarts[piece.end.line] + piece.end.column - lineStarts[piece.start.line] - piece.start.column;
        }
        else {
            return lineStarts[expectedLineStartIndex] - lineStarts[piece.start.line] - piece.start.column;
        }
    }
    deleteNodeTail(node, pos) {
        const piece = node.piece;
        const originalLFCnt = piece.lineFeedCnt;
        const originalEndOffset = this.offsetInBuffer(piece.bufferIndex, piece.end);
        const newEnd = pos;
        const newEndOffset = this.offsetInBuffer(piece.bufferIndex, newEnd);
        const newLineFeedCnt = this.getLineFeedCnt(piece.bufferIndex, piece.start, newEnd);
        const lf_delta = newLineFeedCnt - originalLFCnt;
        const size_delta = newEndOffset - originalEndOffset;
        const newLength = piece.length + size_delta;
        node.piece = ( new Piece(piece.bufferIndex, piece.start, newEnd, newLineFeedCnt, newLength));
        (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.updateTreeMetadata)(this, node, size_delta, lf_delta);
    }
    deleteNodeHead(node, pos) {
        const piece = node.piece;
        const originalLFCnt = piece.lineFeedCnt;
        const originalStartOffset = this.offsetInBuffer(piece.bufferIndex, piece.start);
        const newStart = pos;
        const newLineFeedCnt = this.getLineFeedCnt(piece.bufferIndex, newStart, piece.end);
        const newStartOffset = this.offsetInBuffer(piece.bufferIndex, newStart);
        const lf_delta = newLineFeedCnt - originalLFCnt;
        const size_delta = originalStartOffset - newStartOffset;
        const newLength = piece.length + size_delta;
        node.piece = ( new Piece(piece.bufferIndex, newStart, piece.end, newLineFeedCnt, newLength));
        (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.updateTreeMetadata)(this, node, size_delta, lf_delta);
    }
    shrinkNode(node, start, end) {
        const piece = node.piece;
        const originalStartPos = piece.start;
        const originalEndPos = piece.end;
        const oldLength = piece.length;
        const oldLFCnt = piece.lineFeedCnt;
        const newEnd = start;
        const newLineFeedCnt = this.getLineFeedCnt(piece.bufferIndex, piece.start, newEnd);
        const newLength = this.offsetInBuffer(piece.bufferIndex, start) - this.offsetInBuffer(piece.bufferIndex, originalStartPos);
        node.piece = ( new Piece(piece.bufferIndex, piece.start, newEnd, newLineFeedCnt, newLength));
        (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.updateTreeMetadata)(this, node, newLength - oldLength, newLineFeedCnt - oldLFCnt);
        const newPiece = ( new Piece(
            piece.bufferIndex,
            end,
            originalEndPos,
            this.getLineFeedCnt(piece.bufferIndex, end, originalEndPos),
            this.offsetInBuffer(piece.bufferIndex, originalEndPos) - this.offsetInBuffer(piece.bufferIndex, end)
        ));
        const newNode = this.rbInsertRight(node, newPiece);
        this.validateCRLFWithPrevNode(newNode);
    }
    appendToNode(node, value) {
        if (this.adjustCarriageReturnFromNext(value, node)) {
            value += '\n';
        }
        const hitCRLF = this.shouldCheckCRLF() && this.startWithLF(value) && this.endWithCR(node);
        const startOffset = this._buffers[0].buffer.length;
        this._buffers[0].buffer += value;
        const lineStarts = createLineStartsFast(value, false);
        for (let i = 0; i < lineStarts.length; i++) {
            lineStarts[i] += startOffset;
        }
        if (hitCRLF) {
            const prevStartOffset = this._buffers[0].lineStarts[this._buffers[0].lineStarts.length - 2];
            this._buffers[0].lineStarts.pop();
            this._lastChangeBufferPos = { line: this._lastChangeBufferPos.line - 1, column: startOffset - prevStartOffset };
        }
        this._buffers[0].lineStarts = this._buffers[0].lineStarts.concat(lineStarts.slice(1));
        const endIndex = this._buffers[0].lineStarts.length - 1;
        const endColumn = this._buffers[0].buffer.length - this._buffers[0].lineStarts[endIndex];
        const newEnd = { line: endIndex, column: endColumn };
        const newLength = node.piece.length + value.length;
        const oldLineFeedCnt = node.piece.lineFeedCnt;
        const newLineFeedCnt = this.getLineFeedCnt(0, node.piece.start, newEnd);
        const lf_delta = newLineFeedCnt - oldLineFeedCnt;
        node.piece = ( new Piece(
            node.piece.bufferIndex,
            node.piece.start,
            newEnd,
            newLineFeedCnt,
            newLength
        ));
        this._lastChangeBufferPos = newEnd;
        (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.updateTreeMetadata)(this, node, value.length, lf_delta);
    }
    nodeAt(offset) {
        let x = this.root;
        const cache = this._searchCache.get(offset);
        if (cache) {
            return {
                node: cache.node,
                nodeStartOffset: cache.nodeStartOffset,
                remainder: offset - cache.nodeStartOffset
            };
        }
        let nodeStartOffset = 0;
        while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            if (x.size_left > offset) {
                x = x.left;
            }
            else if (x.size_left + x.piece.length >= offset) {
                nodeStartOffset += x.size_left;
                const ret = {
                    node: x,
                    remainder: offset - x.size_left,
                    nodeStartOffset
                };
                this._searchCache.set(ret);
                return ret;
            }
            else {
                offset -= x.size_left + x.piece.length;
                nodeStartOffset += x.size_left + x.piece.length;
                x = x.right;
            }
        }
        return null;
    }
    nodeAt2(lineNumber, column) {
        let x = this.root;
        let nodeStartOffset = 0;
        while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            if (x.left !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL && x.lf_left >= lineNumber - 1) {
                x = x.left;
            }
            else if (x.lf_left + x.piece.lineFeedCnt > lineNumber - 1) {
                const prevAccumualtedValue = this.getAccumulatedValue(x, lineNumber - x.lf_left - 2);
                const accumulatedValue = this.getAccumulatedValue(x, lineNumber - x.lf_left - 1);
                nodeStartOffset += x.size_left;
                return {
                    node: x,
                    remainder: Math.min(prevAccumualtedValue + column - 1, accumulatedValue),
                    nodeStartOffset
                };
            }
            else if (x.lf_left + x.piece.lineFeedCnt === lineNumber - 1) {
                const prevAccumualtedValue = this.getAccumulatedValue(x, lineNumber - x.lf_left - 2);
                if (prevAccumualtedValue + column - 1 <= x.piece.length) {
                    return {
                        node: x,
                        remainder: prevAccumualtedValue + column - 1,
                        nodeStartOffset
                    };
                }
                else {
                    column -= x.piece.length - prevAccumualtedValue;
                    break;
                }
            }
            else {
                lineNumber -= x.lf_left + x.piece.lineFeedCnt;
                nodeStartOffset += x.size_left + x.piece.length;
                x = x.right;
            }
        }
        x = x.next();
        while (x !== _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            if (x.piece.lineFeedCnt > 0) {
                const accumulatedValue = this.getAccumulatedValue(x, 0);
                const nodeStartOffset = this.offsetOfNode(x);
                return {
                    node: x,
                    remainder: Math.min(column - 1, accumulatedValue),
                    nodeStartOffset
                };
            }
            else {
                if (x.piece.length >= column - 1) {
                    const nodeStartOffset = this.offsetOfNode(x);
                    return {
                        node: x,
                        remainder: column - 1,
                        nodeStartOffset
                    };
                }
                else {
                    column -= x.piece.length;
                }
            }
            x = x.next();
        }
        return null;
    }
    nodeCharCodeAt(node, offset) {
        if (node.piece.lineFeedCnt < 1) {
            return -1;
        }
        const buffer = this._buffers[node.piece.bufferIndex];
        const newOffset = this.offsetInBuffer(node.piece.bufferIndex, node.piece.start) + offset;
        return buffer.buffer.charCodeAt(newOffset);
    }
    offsetOfNode(node) {
        if (!node) {
            return 0;
        }
        let pos = node.size_left;
        while (node !== this.root) {
            if (node.parent.right === node) {
                pos += node.parent.size_left + node.parent.piece.length;
            }
            node = node.parent;
        }
        return pos;
    }
    shouldCheckCRLF() {
        return !(this._EOLNormalized && this._EOL === '\n');
    }
    startWithLF(val) {
        if (typeof val === 'string') {
            return val.charCodeAt(0) === 10;
        }
        if (val === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL || val.piece.lineFeedCnt === 0) {
            return false;
        }
        const piece = val.piece;
        const lineStarts = this._buffers[piece.bufferIndex].lineStarts;
        const line = piece.start.line;
        const startOffset = lineStarts[line] + piece.start.column;
        if (line === lineStarts.length - 1) {
            return false;
        }
        const nextLineOffset = lineStarts[line + 1];
        if (nextLineOffset > startOffset + 1) {
            return false;
        }
        return this._buffers[piece.bufferIndex].buffer.charCodeAt(startOffset) === 10;
    }
    endWithCR(val) {
        if (typeof val === 'string') {
            return val.charCodeAt(val.length - 1) === 13;
        }
        if (val === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL || val.piece.lineFeedCnt === 0) {
            return false;
        }
        return this.nodeCharCodeAt(val, val.piece.length - 1) === 13;
    }
    validateCRLFWithPrevNode(nextNode) {
        if (this.shouldCheckCRLF() && this.startWithLF(nextNode)) {
            const node = nextNode.prev();
            if (this.endWithCR(node)) {
                this.fixCRLF(node, nextNode);
            }
        }
    }
    validateCRLFWithNextNode(node) {
        if (this.shouldCheckCRLF() && this.endWithCR(node)) {
            const nextNode = node.next();
            if (this.startWithLF(nextNode)) {
                this.fixCRLF(node, nextNode);
            }
        }
    }
    fixCRLF(prev, next) {
        const nodesToDel = [];
        const lineStarts = this._buffers[prev.piece.bufferIndex].lineStarts;
        let newEnd;
        if (prev.piece.end.column === 0) {
            newEnd = { line: prev.piece.end.line - 1, column: lineStarts[prev.piece.end.line] - lineStarts[prev.piece.end.line - 1] - 1 };
        }
        else {
            newEnd = { line: prev.piece.end.line, column: prev.piece.end.column - 1 };
        }
        const prevNewLength = prev.piece.length - 1;
        const prevNewLFCnt = prev.piece.lineFeedCnt - 1;
        prev.piece = ( new Piece(
            prev.piece.bufferIndex,
            prev.piece.start,
            newEnd,
            prevNewLFCnt,
            prevNewLength
        ));
        (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.updateTreeMetadata)(this, prev, -1, -1);
        if (prev.piece.length === 0) {
            nodesToDel.push(prev);
        }
        const newStart = { line: next.piece.start.line + 1, column: 0 };
        const newLength = next.piece.length - 1;
        const newLineFeedCnt = this.getLineFeedCnt(next.piece.bufferIndex, newStart, next.piece.end);
        next.piece = ( new Piece(
            next.piece.bufferIndex,
            newStart,
            next.piece.end,
            newLineFeedCnt,
            newLength
        ));
        (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.updateTreeMetadata)(this, next, -1, -1);
        if (next.piece.length === 0) {
            nodesToDel.push(next);
        }
        const pieces = this.createNewPieces('\r\n');
        this.rbInsertRight(prev, pieces[0]);
        for (let i = 0; i < nodesToDel.length; i++) {
            (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.rbDelete)(this, nodesToDel[i]);
        }
    }
    adjustCarriageReturnFromNext(value, node) {
        if (this.shouldCheckCRLF() && this.endWithCR(value)) {
            const nextNode = node.next();
            if (this.startWithLF(nextNode)) {
                value += '\n';
                if (nextNode.piece.length === 1) {
                    (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.rbDelete)(this, nextNode);
                }
                else {
                    const piece = nextNode.piece;
                    const newStart = { line: piece.start.line + 1, column: 0 };
                    const newLength = piece.length - 1;
                    const newLineFeedCnt = this.getLineFeedCnt(piece.bufferIndex, newStart, piece.end);
                    nextNode.piece = ( new Piece(piece.bufferIndex, newStart, piece.end, newLineFeedCnt, newLength));
                    (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.updateTreeMetadata)(this, nextNode, -1, -1);
                }
                return true;
            }
        }
        return false;
    }
    iterate(node, callback) {
        if (node === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            return callback(_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL);
        }
        const leftRet = this.iterate(node.left, callback);
        if (!leftRet) {
            return leftRet;
        }
        return callback(node) && this.iterate(node.right, callback);
    }
    getNodeContent(node) {
        if (node === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            return '';
        }
        const buffer = this._buffers[node.piece.bufferIndex];
        const piece = node.piece;
        const startOffset = this.offsetInBuffer(piece.bufferIndex, piece.start);
        const endOffset = this.offsetInBuffer(piece.bufferIndex, piece.end);
        const currentContent = buffer.buffer.substring(startOffset, endOffset);
        return currentContent;
    }
    getPieceContent(piece) {
        const buffer = this._buffers[piece.bufferIndex];
        const startOffset = this.offsetInBuffer(piece.bufferIndex, piece.start);
        const endOffset = this.offsetInBuffer(piece.bufferIndex, piece.end);
        const currentContent = buffer.buffer.substring(startOffset, endOffset);
        return currentContent;
    }
    rbInsertRight(node, p) {
        const z = ( new _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.TreeNode(p, _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.NodeColor.Red));
        z.left = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL;
        z.right = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL;
        z.parent = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL;
        z.size_left = 0;
        z.lf_left = 0;
        const x = this.root;
        if (x === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            this.root = z;
            z.color = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.NodeColor.Black;
        }
        else if (node.right === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            node.right = z;
            z.parent = node;
        }
        else {
            const nextNode = (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.leftest)(node.right);
            nextNode.left = z;
            z.parent = nextNode;
        }
        (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.fixInsert)(this, z);
        return z;
    }
    rbInsertLeft(node, p) {
        const z = ( new _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.TreeNode(p, _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.NodeColor.Red));
        z.left = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL;
        z.right = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL;
        z.parent = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL;
        z.size_left = 0;
        z.lf_left = 0;
        if (this.root === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            this.root = z;
            z.color = _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.NodeColor.Black;
        }
        else if (node.left === _rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.SENTINEL) {
            node.left = z;
            z.parent = node;
        }
        else {
            const prevNode = (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.righttest)(node.left);
            prevNode.right = z;
            z.parent = prevNode;
        }
        (0,_rbTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.fixInsert)(this, z);
        return z;
    }
    getContentOfSubTree(node) {
        let str = '';
        this.iterate(node, node => {
            str += this.getNodeContent(node);
            return true;
        });
        return str;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeTextBuffer.js":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeTextBuffer.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PieceTreeTextBuffer: () => (/* binding */ PieceTreeTextBuffer)
/* harmony export */ });
/* harmony import */ var _base_common_event_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../base/common/event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../base/common/strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _model_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../model.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model.js");
/* harmony import */ var _pieceTreeBase_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./pieceTreeBase.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeBase.js");
/* harmony import */ var _core_eolCounter_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/eolCounter.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/eolCounter.js");
/* harmony import */ var _core_textChange_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/textChange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/textChange.js");
/* harmony import */ var _base_common_lifecycle_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../base/common/lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");








class PieceTreeTextBuffer extends _base_common_lifecycle_js__WEBPACK_IMPORTED_MODULE_7__.Disposable {
    constructor(chunks, BOM, eol, containsRTL, containsUnusualLineTerminators, isBasicASCII, eolNormalized) {
        super();
        this._onDidChangeContent = this._register(( new _base_common_event_js__WEBPACK_IMPORTED_MODULE_0__.Emitter()));
        this.onDidChangeContent = this._onDidChangeContent.event;
        this._BOM = BOM;
        this._mightContainNonBasicASCII = !isBasicASCII;
        this._mightContainRTL = containsRTL;
        this._mightContainUnusualLineTerminators = containsUnusualLineTerminators;
        this._pieceTree = ( new _pieceTreeBase_js__WEBPACK_IMPORTED_MODULE_4__.PieceTreeBase(chunks, eol, eolNormalized));
    }
    equals(other) {
        if (!(other instanceof PieceTreeTextBuffer)) {
            return false;
        }
        if (this._BOM !== other._BOM) {
            return false;
        }
        if (this.getEOL() !== other.getEOL()) {
            return false;
        }
        return this._pieceTree.equal(other._pieceTree);
    }
    mightContainRTL() {
        return this._mightContainRTL;
    }
    mightContainUnusualLineTerminators() {
        return this._mightContainUnusualLineTerminators;
    }
    resetMightContainUnusualLineTerminators() {
        this._mightContainUnusualLineTerminators = false;
    }
    mightContainNonBasicASCII() {
        return this._mightContainNonBasicASCII;
    }
    getBOM() {
        return this._BOM;
    }
    getEOL() {
        return this._pieceTree.getEOL();
    }
    createSnapshot(preserveBOM) {
        return this._pieceTree.createSnapshot(preserveBOM ? this._BOM : '');
    }
    getOffsetAt(lineNumber, column) {
        return this._pieceTree.getOffsetAt(lineNumber, column);
    }
    getPositionAt(offset) {
        return this._pieceTree.getPositionAt(offset);
    }
    getRangeAt(start, length) {
        const end = start + length;
        const startPosition = this.getPositionAt(start);
        const endPosition = this.getPositionAt(end);
        return ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
            startPosition.lineNumber,
            startPosition.column,
            endPosition.lineNumber,
            endPosition.column
        ));
    }
    getValueInRange(range, eol = _model_js__WEBPACK_IMPORTED_MODULE_3__.EndOfLinePreference.TextDefined) {
        if (range.isEmpty()) {
            return '';
        }
        const lineEnding = this._getEndOfLine(eol);
        return this._pieceTree.getValueInRange(range, lineEnding);
    }
    getValueLengthInRange(range, eol = _model_js__WEBPACK_IMPORTED_MODULE_3__.EndOfLinePreference.TextDefined) {
        if (range.isEmpty()) {
            return 0;
        }
        if (range.startLineNumber === range.endLineNumber) {
            return (range.endColumn - range.startColumn);
        }
        const startOffset = this.getOffsetAt(range.startLineNumber, range.startColumn);
        const endOffset = this.getOffsetAt(range.endLineNumber, range.endColumn);
        let eolOffsetCompensation = 0;
        const desiredEOL = this._getEndOfLine(eol);
        const actualEOL = this.getEOL();
        if (desiredEOL.length !== actualEOL.length) {
            const delta = desiredEOL.length - actualEOL.length;
            const eolCount = range.endLineNumber - range.startLineNumber;
            eolOffsetCompensation = delta * eolCount;
        }
        return endOffset - startOffset + eolOffsetCompensation;
    }
    getCharacterCountInRange(range, eol = _model_js__WEBPACK_IMPORTED_MODULE_3__.EndOfLinePreference.TextDefined) {
        if (this._mightContainNonBasicASCII) {
            let result = 0;
            const fromLineNumber = range.startLineNumber;
            const toLineNumber = range.endLineNumber;
            for (let lineNumber = fromLineNumber; lineNumber <= toLineNumber; lineNumber++) {
                const lineContent = this.getLineContent(lineNumber);
                const fromOffset = (lineNumber === fromLineNumber ? range.startColumn - 1 : 0);
                const toOffset = (lineNumber === toLineNumber ? range.endColumn - 1 : lineContent.length);
                for (let offset = fromOffset; offset < toOffset; offset++) {
                    if ((0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.isHighSurrogate)(lineContent.charCodeAt(offset))) {
                        result = result + 1;
                        offset = offset + 1;
                    }
                    else {
                        result = result + 1;
                    }
                }
            }
            result += this._getEndOfLine(eol).length * (toLineNumber - fromLineNumber);
            return result;
        }
        return this.getValueLengthInRange(range, eol);
    }
    getNearestChunk(offset) {
        return this._pieceTree.getNearestChunk(offset);
    }
    getLength() {
        return this._pieceTree.getLength();
    }
    getLineCount() {
        return this._pieceTree.getLineCount();
    }
    getLinesContent() {
        return this._pieceTree.getLinesContent();
    }
    getLineContent(lineNumber) {
        return this._pieceTree.getLineContent(lineNumber);
    }
    getLineCharCode(lineNumber, index) {
        return this._pieceTree.getLineCharCode(lineNumber, index);
    }
    getCharCode(offset) {
        return this._pieceTree.getCharCode(offset);
    }
    getLineLength(lineNumber) {
        return this._pieceTree.getLineLength(lineNumber);
    }
    getLineMinColumn(lineNumber) {
        return 1;
    }
    getLineMaxColumn(lineNumber) {
        return this.getLineLength(lineNumber) + 1;
    }
    getLineFirstNonWhitespaceColumn(lineNumber) {
        const result = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.firstNonWhitespaceIndex)(this.getLineContent(lineNumber));
        if (result === -1) {
            return 0;
        }
        return result + 1;
    }
    getLineLastNonWhitespaceColumn(lineNumber) {
        const result = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.lastNonWhitespaceIndex)(this.getLineContent(lineNumber));
        if (result === -1) {
            return 0;
        }
        return result + 2;
    }
    _getEndOfLine(eol) {
        switch (eol) {
            case _model_js__WEBPACK_IMPORTED_MODULE_3__.EndOfLinePreference.LF:
                return '\n';
            case _model_js__WEBPACK_IMPORTED_MODULE_3__.EndOfLinePreference.CRLF:
                return '\r\n';
            case _model_js__WEBPACK_IMPORTED_MODULE_3__.EndOfLinePreference.TextDefined:
                return this.getEOL();
            default:
                throw ( new Error('Unknown EOL preference'));
        }
    }
    setEOL(newEOL) {
        this._pieceTree.setEOL(newEOL);
    }
    applyEdits(rawOperations, recordTrimAutoWhitespace, computeUndoEdits) {
        let mightContainRTL = this._mightContainRTL;
        let mightContainUnusualLineTerminators = this._mightContainUnusualLineTerminators;
        let mightContainNonBasicASCII = this._mightContainNonBasicASCII;
        let canReduceOperations = true;
        let operations = [];
        for (let i = 0; i < rawOperations.length; i++) {
            const op = rawOperations[i];
            if (canReduceOperations && op._isTracked) {
                canReduceOperations = false;
            }
            const validatedRange = op.range;
            if (op.text) {
                let textMightContainNonBasicASCII = true;
                if (!mightContainNonBasicASCII) {
                    textMightContainNonBasicASCII = !(0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.isBasicASCII)(op.text);
                    mightContainNonBasicASCII = textMightContainNonBasicASCII;
                }
                if (!mightContainRTL && textMightContainNonBasicASCII) {
                    mightContainRTL = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.containsRTL)(op.text);
                }
                if (!mightContainUnusualLineTerminators && textMightContainNonBasicASCII) {
                    mightContainUnusualLineTerminators = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.containsUnusualLineTerminators)(op.text);
                }
            }
            let validText = '';
            let eolCount = 0;
            let firstLineLength = 0;
            let lastLineLength = 0;
            if (op.text) {
                let strEOL;
                [eolCount, firstLineLength, lastLineLength, strEOL] = (0,_core_eolCounter_js__WEBPACK_IMPORTED_MODULE_5__.countEOL)(op.text);
                const bufferEOL = this.getEOL();
                const expectedStrEOL = (bufferEOL === '\r\n' ? _core_eolCounter_js__WEBPACK_IMPORTED_MODULE_5__.StringEOL.CRLF : _core_eolCounter_js__WEBPACK_IMPORTED_MODULE_5__.StringEOL.LF);
                if (strEOL === _core_eolCounter_js__WEBPACK_IMPORTED_MODULE_5__.StringEOL.Unknown || strEOL === expectedStrEOL) {
                    validText = op.text;
                }
                else {
                    validText = op.text.replace(/\r\n|\r|\n/g, bufferEOL);
                }
            }
            operations[i] = {
                sortIndex: i,
                identifier: op.identifier || null,
                range: validatedRange,
                rangeOffset: this.getOffsetAt(validatedRange.startLineNumber, validatedRange.startColumn),
                rangeLength: this.getValueLengthInRange(validatedRange),
                text: validText,
                eolCount: eolCount,
                firstLineLength: firstLineLength,
                lastLineLength: lastLineLength,
                forceMoveMarkers: Boolean(op.forceMoveMarkers),
                isAutoWhitespaceEdit: op.isAutoWhitespaceEdit || false
            };
        }
        operations.sort(PieceTreeTextBuffer._sortOpsAscending);
        let hasTouchingRanges = false;
        for (let i = 0, count = operations.length - 1; i < count; i++) {
            const rangeEnd = operations[i].range.getEndPosition();
            const nextRangeStart = operations[i + 1].range.getStartPosition();
            if (nextRangeStart.isBeforeOrEqual(rangeEnd)) {
                if (nextRangeStart.isBefore(rangeEnd)) {
                    throw ( new Error('Overlapping ranges are not allowed!'));
                }
                hasTouchingRanges = true;
            }
        }
        if (canReduceOperations) {
            operations = this._reduceOperations(operations);
        }
        const reverseRanges = (computeUndoEdits || recordTrimAutoWhitespace ? PieceTreeTextBuffer._getInverseEditRanges(operations) : []);
        const newTrimAutoWhitespaceCandidates = [];
        if (recordTrimAutoWhitespace) {
            for (let i = 0; i < operations.length; i++) {
                const op = operations[i];
                const reverseRange = reverseRanges[i];
                if (op.isAutoWhitespaceEdit && op.range.isEmpty()) {
                    for (let lineNumber = reverseRange.startLineNumber; lineNumber <= reverseRange.endLineNumber; lineNumber++) {
                        let currentLineContent = '';
                        if (lineNumber === reverseRange.startLineNumber) {
                            currentLineContent = this.getLineContent(op.range.startLineNumber);
                            if ((0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.firstNonWhitespaceIndex)(currentLineContent) !== -1) {
                                continue;
                            }
                        }
                        newTrimAutoWhitespaceCandidates.push({ lineNumber: lineNumber, oldContent: currentLineContent });
                    }
                }
            }
        }
        let reverseOperations = null;
        if (computeUndoEdits) {
            let reverseRangeDeltaOffset = 0;
            reverseOperations = [];
            for (let i = 0; i < operations.length; i++) {
                const op = operations[i];
                const reverseRange = reverseRanges[i];
                const bufferText = this.getValueInRange(op.range);
                const reverseRangeOffset = op.rangeOffset + reverseRangeDeltaOffset;
                reverseRangeDeltaOffset += (op.text.length - bufferText.length);
                reverseOperations[i] = {
                    sortIndex: op.sortIndex,
                    identifier: op.identifier,
                    range: reverseRange,
                    text: bufferText,
                    textChange: ( new _core_textChange_js__WEBPACK_IMPORTED_MODULE_6__.TextChange(op.rangeOffset, bufferText, reverseRangeOffset, op.text))
                };
            }
            if (!hasTouchingRanges) {
                reverseOperations.sort((a, b) => a.sortIndex - b.sortIndex);
            }
        }
        this._mightContainRTL = mightContainRTL;
        this._mightContainUnusualLineTerminators = mightContainUnusualLineTerminators;
        this._mightContainNonBasicASCII = mightContainNonBasicASCII;
        const contentChanges = this._doApplyEdits(operations);
        let trimAutoWhitespaceLineNumbers = null;
        if (recordTrimAutoWhitespace && newTrimAutoWhitespaceCandidates.length > 0) {
            newTrimAutoWhitespaceCandidates.sort((a, b) => b.lineNumber - a.lineNumber);
            trimAutoWhitespaceLineNumbers = [];
            for (let i = 0, len = newTrimAutoWhitespaceCandidates.length; i < len; i++) {
                const lineNumber = newTrimAutoWhitespaceCandidates[i].lineNumber;
                if (i > 0 && newTrimAutoWhitespaceCandidates[i - 1].lineNumber === lineNumber) {
                    continue;
                }
                const prevContent = newTrimAutoWhitespaceCandidates[i].oldContent;
                const lineContent = this.getLineContent(lineNumber);
                if (lineContent.length === 0 || lineContent === prevContent || (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.firstNonWhitespaceIndex)(lineContent) !== -1) {
                    continue;
                }
                trimAutoWhitespaceLineNumbers.push(lineNumber);
            }
        }
        this._onDidChangeContent.fire();
        return ( new _model_js__WEBPACK_IMPORTED_MODULE_3__.ApplyEditsResult(reverseOperations, contentChanges, trimAutoWhitespaceLineNumbers));
    }
    _reduceOperations(operations) {
        if (operations.length < 1000) {
            return operations;
        }
        return [this._toSingleEditOperation(operations)];
    }
    _toSingleEditOperation(operations) {
        let forceMoveMarkers = false;
        const firstEditRange = operations[0].range;
        const lastEditRange = operations[operations.length - 1].range;
        const entireEditRange = ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
            firstEditRange.startLineNumber,
            firstEditRange.startColumn,
            lastEditRange.endLineNumber,
            lastEditRange.endColumn
        ));
        let lastEndLineNumber = firstEditRange.startLineNumber;
        let lastEndColumn = firstEditRange.startColumn;
        const result = [];
        for (let i = 0, len = operations.length; i < len; i++) {
            const operation = operations[i];
            const range = operation.range;
            forceMoveMarkers = forceMoveMarkers || operation.forceMoveMarkers;
            result.push(this.getValueInRange(( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(lastEndLineNumber, lastEndColumn, range.startLineNumber, range.startColumn))));
            if (operation.text.length > 0) {
                result.push(operation.text);
            }
            lastEndLineNumber = range.endLineNumber;
            lastEndColumn = range.endColumn;
        }
        const text = result.join('');
        const [eolCount, firstLineLength, lastLineLength] = (0,_core_eolCounter_js__WEBPACK_IMPORTED_MODULE_5__.countEOL)(text);
        return {
            sortIndex: 0,
            identifier: operations[0].identifier,
            range: entireEditRange,
            rangeOffset: this.getOffsetAt(entireEditRange.startLineNumber, entireEditRange.startColumn),
            rangeLength: this.getValueLengthInRange(entireEditRange, _model_js__WEBPACK_IMPORTED_MODULE_3__.EndOfLinePreference.TextDefined),
            text: text,
            eolCount: eolCount,
            firstLineLength: firstLineLength,
            lastLineLength: lastLineLength,
            forceMoveMarkers: forceMoveMarkers,
            isAutoWhitespaceEdit: false
        };
    }
    _doApplyEdits(operations) {
        operations.sort(PieceTreeTextBuffer._sortOpsDescending);
        const contentChanges = [];
        for (let i = 0; i < operations.length; i++) {
            const op = operations[i];
            const startLineNumber = op.range.startLineNumber;
            const startColumn = op.range.startColumn;
            const endLineNumber = op.range.endLineNumber;
            const endColumn = op.range.endColumn;
            if (startLineNumber === endLineNumber && startColumn === endColumn && op.text.length === 0) {
                continue;
            }
            if (op.text) {
                this._pieceTree.delete(op.rangeOffset, op.rangeLength);
                this._pieceTree.insert(op.rangeOffset, op.text, true);
            }
            else {
                this._pieceTree.delete(op.rangeOffset, op.rangeLength);
            }
            const contentChangeRange = ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(startLineNumber, startColumn, endLineNumber, endColumn));
            contentChanges.push({
                range: contentChangeRange,
                rangeLength: op.rangeLength,
                text: op.text,
                rangeOffset: op.rangeOffset,
                forceMoveMarkers: op.forceMoveMarkers
            });
        }
        return contentChanges;
    }
    findMatchesLineByLine(searchRange, searchData, captureMatches, limitResultCount) {
        return this._pieceTree.findMatchesLineByLine(searchRange, searchData, captureMatches, limitResultCount);
    }
    getPieceTree() {
        return this._pieceTree;
    }
    static _getInverseEditRange(range, text) {
        const startLineNumber = range.startLineNumber;
        const startColumn = range.startColumn;
        const [eolCount, firstLineLength, lastLineLength] = (0,_core_eolCounter_js__WEBPACK_IMPORTED_MODULE_5__.countEOL)(text);
        let resultRange;
        if (text.length > 0) {
            const lineCount = eolCount + 1;
            if (lineCount === 1) {
                resultRange = ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                    startLineNumber,
                    startColumn,
                    startLineNumber,
                    startColumn + firstLineLength
                ));
            }
            else {
                resultRange = ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                    startLineNumber,
                    startColumn,
                    startLineNumber + lineCount - 1,
                    lastLineLength + 1
                ));
            }
        }
        else {
            resultRange = ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(startLineNumber, startColumn, startLineNumber, startColumn));
        }
        return resultRange;
    }
    static _getInverseEditRanges(operations) {
        const result = [];
        let prevOpEndLineNumber = 0;
        let prevOpEndColumn = 0;
        let prevOp = null;
        for (let i = 0, len = operations.length; i < len; i++) {
            const op = operations[i];
            let startLineNumber;
            let startColumn;
            if (prevOp) {
                if (prevOp.range.endLineNumber === op.range.startLineNumber) {
                    startLineNumber = prevOpEndLineNumber;
                    startColumn = prevOpEndColumn + (op.range.startColumn - prevOp.range.endColumn);
                }
                else {
                    startLineNumber = prevOpEndLineNumber + (op.range.startLineNumber - prevOp.range.endLineNumber);
                    startColumn = op.range.startColumn;
                }
            }
            else {
                startLineNumber = op.range.startLineNumber;
                startColumn = op.range.startColumn;
            }
            let resultRange;
            if (op.text.length > 0) {
                const lineCount = op.eolCount + 1;
                if (lineCount === 1) {
                    resultRange = ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                        startLineNumber,
                        startColumn,
                        startLineNumber,
                        startColumn + op.firstLineLength
                    ));
                }
                else {
                    resultRange = ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                        startLineNumber,
                        startColumn,
                        startLineNumber + lineCount - 1,
                        op.lastLineLength + 1
                    ));
                }
            }
            else {
                resultRange = ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(startLineNumber, startColumn, startLineNumber, startColumn));
            }
            prevOpEndLineNumber = resultRange.endLineNumber;
            prevOpEndColumn = resultRange.endColumn;
            result.push(resultRange);
            prevOp = op;
        }
        return result;
    }
    static _sortOpsAscending(a, b) {
        const r = _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range.compareRangesUsingEnds(a.range, b.range);
        if (r === 0) {
            return a.sortIndex - b.sortIndex;
        }
        return r;
    }
    static _sortOpsDescending(a, b) {
        const r = _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range.compareRangesUsingEnds(a.range, b.range);
        if (r === 0) {
            return b.sortIndex - a.sortIndex;
        }
        return -r;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeTextBufferBuilder.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeTextBufferBuilder.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PieceTreeTextBufferBuilder: () => (/* binding */ PieceTreeTextBufferBuilder)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../base/common/strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _model_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../model.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model.js");
/* harmony import */ var _pieceTreeBase_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pieceTreeBase.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeBase.js");
/* harmony import */ var _pieceTreeTextBuffer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./pieceTreeTextBuffer.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/pieceTreeTextBuffer.js");





class PieceTreeTextBufferFactory {
    constructor(_chunks, _bom, _cr, _lf, _crlf, _containsRTL, _containsUnusualLineTerminators, _isBasicASCII, _normalizeEOL) {
        this._chunks = _chunks;
        this._bom = _bom;
        this._cr = _cr;
        this._lf = _lf;
        this._crlf = _crlf;
        this._containsRTL = _containsRTL;
        this._containsUnusualLineTerminators = _containsUnusualLineTerminators;
        this._isBasicASCII = _isBasicASCII;
        this._normalizeEOL = _normalizeEOL;
    }
    _getEOL(defaultEOL) {
        const totalEOLCount = this._cr + this._lf + this._crlf;
        const totalCRCount = this._cr + this._crlf;
        if (totalEOLCount === 0) {
            return (defaultEOL === _model_js__WEBPACK_IMPORTED_MODULE_2__.DefaultEndOfLine.LF ? '\n' : '\r\n');
        }
        if (totalCRCount > totalEOLCount / 2) {
            return '\r\n';
        }
        return '\n';
    }
    create(defaultEOL) {
        const eol = this._getEOL(defaultEOL);
        const chunks = this._chunks;
        if (this._normalizeEOL &&
            ((eol === '\r\n' && (this._cr > 0 || this._lf > 0))
                || (eol === '\n' && (this._cr > 0 || this._crlf > 0)))) {
            for (let i = 0, len = chunks.length; i < len; i++) {
                const str = chunks[i].buffer.replace(/\r\n|\r|\n/g, eol);
                const newLineStart = (0,_pieceTreeBase_js__WEBPACK_IMPORTED_MODULE_3__.createLineStartsFast)(str);
                chunks[i] = ( new _pieceTreeBase_js__WEBPACK_IMPORTED_MODULE_3__.StringBuffer(str, newLineStart));
            }
        }
        const textBuffer = ( new _pieceTreeTextBuffer_js__WEBPACK_IMPORTED_MODULE_4__.PieceTreeTextBuffer(
            chunks,
            this._bom,
            eol,
            this._containsRTL,
            this._containsUnusualLineTerminators,
            this._isBasicASCII,
            this._normalizeEOL
        ));
        return { textBuffer: textBuffer, disposable: textBuffer };
    }
    getFirstLineText(lengthLimit) {
        return this._chunks[0].buffer.substr(0, lengthLimit).split(/\r\n|\r|\n/)[0];
    }
}
class PieceTreeTextBufferBuilder {
    constructor() {
        this.chunks = [];
        this.BOM = '';
        this._hasPreviousChar = false;
        this._previousChar = 0;
        this._tmpLineStarts = [];
        this.cr = 0;
        this.lf = 0;
        this.crlf = 0;
        this.containsRTL = false;
        this.containsUnusualLineTerminators = false;
        this.isBasicASCII = true;
    }
    acceptChunk(chunk) {
        if (chunk.length === 0) {
            return;
        }
        if (this.chunks.length === 0) {
            if ((0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.startsWithUTF8BOM)(chunk)) {
                this.BOM = _base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.UTF8_BOM_CHARACTER;
                chunk = chunk.substr(1);
            }
        }
        const lastChar = chunk.charCodeAt(chunk.length - 1);
        if (lastChar === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn || (lastChar >= 0xD800 && lastChar <= 0xDBFF)) {
            this._acceptChunk1(chunk.substr(0, chunk.length - 1), false);
            this._hasPreviousChar = true;
            this._previousChar = lastChar;
        }
        else {
            this._acceptChunk1(chunk, false);
            this._hasPreviousChar = false;
            this._previousChar = lastChar;
        }
    }
    _acceptChunk1(chunk, allowEmptyStrings) {
        if (!allowEmptyStrings && chunk.length === 0) {
            return;
        }
        if (this._hasPreviousChar) {
            this._acceptChunk2(String.fromCharCode(this._previousChar) + chunk);
        }
        else {
            this._acceptChunk2(chunk);
        }
    }
    _acceptChunk2(chunk) {
        const lineStarts = (0,_pieceTreeBase_js__WEBPACK_IMPORTED_MODULE_3__.createLineStarts)(this._tmpLineStarts, chunk);
        this.chunks.push(( new _pieceTreeBase_js__WEBPACK_IMPORTED_MODULE_3__.StringBuffer(chunk, lineStarts.lineStarts)));
        this.cr += lineStarts.cr;
        this.lf += lineStarts.lf;
        this.crlf += lineStarts.crlf;
        if (!lineStarts.isBasicASCII) {
            this.isBasicASCII = false;
            if (!this.containsRTL) {
                this.containsRTL = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.containsRTL)(chunk);
            }
            if (!this.containsUnusualLineTerminators) {
                this.containsUnusualLineTerminators = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_1__.containsUnusualLineTerminators)(chunk);
            }
        }
    }
    finish(normalizeEOL = true) {
        this._finish();
        return ( new PieceTreeTextBufferFactory(
            this.chunks,
            this.BOM,
            this.cr,
            this.lf,
            this.crlf,
            this.containsRTL,
            this.containsUnusualLineTerminators,
            this.isBasicASCII,
            normalizeEOL
        ));
    }
    _finish() {
        if (this.chunks.length === 0) {
            this._acceptChunk1('', true);
        }
        if (this._hasPreviousChar) {
            this._hasPreviousChar = false;
            const lastChunk = this.chunks[this.chunks.length - 1];
            lastChunk.buffer += String.fromCharCode(this._previousChar);
            const newLineStarts = (0,_pieceTreeBase_js__WEBPACK_IMPORTED_MODULE_3__.createLineStartsFast)(lastChunk.buffer);
            lastChunk.lineStarts = newLineStarts;
            if (this._previousChar === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CarriageReturn) {
                this.cr++;
            }
        }
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/rbTreeBase.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/model/pieceTreeTextBuffer/rbTreeBase.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NodeColor: () => (/* binding */ NodeColor),
/* harmony export */   SENTINEL: () => (/* binding */ SENTINEL),
/* harmony export */   TreeNode: () => (/* binding */ TreeNode),
/* harmony export */   fixInsert: () => (/* binding */ fixInsert),
/* harmony export */   leftRotate: () => (/* binding */ leftRotate),
/* harmony export */   leftest: () => (/* binding */ leftest),
/* harmony export */   rbDelete: () => (/* binding */ rbDelete),
/* harmony export */   recomputeTreeMetadata: () => (/* binding */ recomputeTreeMetadata),
/* harmony export */   rightRotate: () => (/* binding */ rightRotate),
/* harmony export */   righttest: () => (/* binding */ righttest),
/* harmony export */   updateTreeMetadata: () => (/* binding */ updateTreeMetadata)
/* harmony export */ });
class TreeNode {
    constructor(piece, color) {
        this.piece = piece;
        this.color = color;
        this.size_left = 0;
        this.lf_left = 0;
        this.parent = this;
        this.left = this;
        this.right = this;
    }
    next() {
        if (this.right !== SENTINEL) {
            return leftest(this.right);
        }
        let node = this;
        while (node.parent !== SENTINEL) {
            if (node.parent.left === node) {
                break;
            }
            node = node.parent;
        }
        if (node.parent === SENTINEL) {
            return SENTINEL;
        }
        else {
            return node.parent;
        }
    }
    prev() {
        if (this.left !== SENTINEL) {
            return righttest(this.left);
        }
        let node = this;
        while (node.parent !== SENTINEL) {
            if (node.parent.right === node) {
                break;
            }
            node = node.parent;
        }
        if (node.parent === SENTINEL) {
            return SENTINEL;
        }
        else {
            return node.parent;
        }
    }
    detach() {
        this.parent = null;
        this.left = null;
        this.right = null;
    }
}
var NodeColor;
( (function(NodeColor) {
    NodeColor[NodeColor["Black"] = 0] = "Black";
    NodeColor[NodeColor["Red"] = 1] = "Red";
})(NodeColor || (NodeColor = {})));
const SENTINEL = ( new TreeNode(null, NodeColor.Black));
SENTINEL.parent = SENTINEL;
SENTINEL.left = SENTINEL;
SENTINEL.right = SENTINEL;
SENTINEL.color = NodeColor.Black;
function leftest(node) {
    while (node.left !== SENTINEL) {
        node = node.left;
    }
    return node;
}
function righttest(node) {
    while (node.right !== SENTINEL) {
        node = node.right;
    }
    return node;
}
function calculateSize(node) {
    if (node === SENTINEL) {
        return 0;
    }
    return node.size_left + node.piece.length + calculateSize(node.right);
}
function calculateLF(node) {
    if (node === SENTINEL) {
        return 0;
    }
    return node.lf_left + node.piece.lineFeedCnt + calculateLF(node.right);
}
function resetSentinel() {
    SENTINEL.parent = SENTINEL;
}
function leftRotate(tree, x) {
    const y = x.right;
    y.size_left += x.size_left + (x.piece ? x.piece.length : 0);
    y.lf_left += x.lf_left + (x.piece ? x.piece.lineFeedCnt : 0);
    x.right = y.left;
    if (y.left !== SENTINEL) {
        y.left.parent = x;
    }
    y.parent = x.parent;
    if (x.parent === SENTINEL) {
        tree.root = y;
    }
    else if (x.parent.left === x) {
        x.parent.left = y;
    }
    else {
        x.parent.right = y;
    }
    y.left = x;
    x.parent = y;
}
function rightRotate(tree, y) {
    const x = y.left;
    y.left = x.right;
    if (x.right !== SENTINEL) {
        x.right.parent = y;
    }
    x.parent = y.parent;
    y.size_left -= x.size_left + (x.piece ? x.piece.length : 0);
    y.lf_left -= x.lf_left + (x.piece ? x.piece.lineFeedCnt : 0);
    if (y.parent === SENTINEL) {
        tree.root = x;
    }
    else if (y === y.parent.right) {
        y.parent.right = x;
    }
    else {
        y.parent.left = x;
    }
    x.right = y;
    y.parent = x;
}
function rbDelete(tree, z) {
    let x;
    let y;
    if (z.left === SENTINEL) {
        y = z;
        x = y.right;
    }
    else if (z.right === SENTINEL) {
        y = z;
        x = y.left;
    }
    else {
        y = leftest(z.right);
        x = y.right;
    }
    if (y === tree.root) {
        tree.root = x;
        x.color = NodeColor.Black;
        z.detach();
        resetSentinel();
        tree.root.parent = SENTINEL;
        return;
    }
    const yWasRed = (y.color === NodeColor.Red);
    if (y === y.parent.left) {
        y.parent.left = x;
    }
    else {
        y.parent.right = x;
    }
    if (y === z) {
        x.parent = y.parent;
        recomputeTreeMetadata(tree, x);
    }
    else {
        if (y.parent === z) {
            x.parent = y;
        }
        else {
            x.parent = y.parent;
        }
        recomputeTreeMetadata(tree, x);
        y.left = z.left;
        y.right = z.right;
        y.parent = z.parent;
        y.color = z.color;
        if (z === tree.root) {
            tree.root = y;
        }
        else {
            if (z === z.parent.left) {
                z.parent.left = y;
            }
            else {
                z.parent.right = y;
            }
        }
        if (y.left !== SENTINEL) {
            y.left.parent = y;
        }
        if (y.right !== SENTINEL) {
            y.right.parent = y;
        }
        y.size_left = z.size_left;
        y.lf_left = z.lf_left;
        recomputeTreeMetadata(tree, y);
    }
    z.detach();
    if (x.parent.left === x) {
        const newSizeLeft = calculateSize(x);
        const newLFLeft = calculateLF(x);
        if (newSizeLeft !== x.parent.size_left || newLFLeft !== x.parent.lf_left) {
            const delta = newSizeLeft - x.parent.size_left;
            const lf_delta = newLFLeft - x.parent.lf_left;
            x.parent.size_left = newSizeLeft;
            x.parent.lf_left = newLFLeft;
            updateTreeMetadata(tree, x.parent, delta, lf_delta);
        }
    }
    recomputeTreeMetadata(tree, x.parent);
    if (yWasRed) {
        resetSentinel();
        return;
    }
    let w;
    while (x !== tree.root && x.color === NodeColor.Black) {
        if (x === x.parent.left) {
            w = x.parent.right;
            if (w.color === NodeColor.Red) {
                w.color = NodeColor.Black;
                x.parent.color = NodeColor.Red;
                leftRotate(tree, x.parent);
                w = x.parent.right;
            }
            if (w.left.color === NodeColor.Black && w.right.color === NodeColor.Black) {
                w.color = NodeColor.Red;
                x = x.parent;
            }
            else {
                if (w.right.color === NodeColor.Black) {
                    w.left.color = NodeColor.Black;
                    w.color = NodeColor.Red;
                    rightRotate(tree, w);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = NodeColor.Black;
                w.right.color = NodeColor.Black;
                leftRotate(tree, x.parent);
                x = tree.root;
            }
        }
        else {
            w = x.parent.left;
            if (w.color === NodeColor.Red) {
                w.color = NodeColor.Black;
                x.parent.color = NodeColor.Red;
                rightRotate(tree, x.parent);
                w = x.parent.left;
            }
            if (w.left.color === NodeColor.Black && w.right.color === NodeColor.Black) {
                w.color = NodeColor.Red;
                x = x.parent;
            }
            else {
                if (w.left.color === NodeColor.Black) {
                    w.right.color = NodeColor.Black;
                    w.color = NodeColor.Red;
                    leftRotate(tree, w);
                    w = x.parent.left;
                }
                w.color = x.parent.color;
                x.parent.color = NodeColor.Black;
                w.left.color = NodeColor.Black;
                rightRotate(tree, x.parent);
                x = tree.root;
            }
        }
    }
    x.color = NodeColor.Black;
    resetSentinel();
}
function fixInsert(tree, x) {
    recomputeTreeMetadata(tree, x);
    while (x !== tree.root && x.parent.color === NodeColor.Red) {
        if (x.parent === x.parent.parent.left) {
            const y = x.parent.parent.right;
            if (y.color === NodeColor.Red) {
                x.parent.color = NodeColor.Black;
                y.color = NodeColor.Black;
                x.parent.parent.color = NodeColor.Red;
                x = x.parent.parent;
            }
            else {
                if (x === x.parent.right) {
                    x = x.parent;
                    leftRotate(tree, x);
                }
                x.parent.color = NodeColor.Black;
                x.parent.parent.color = NodeColor.Red;
                rightRotate(tree, x.parent.parent);
            }
        }
        else {
            const y = x.parent.parent.left;
            if (y.color === NodeColor.Red) {
                x.parent.color = NodeColor.Black;
                y.color = NodeColor.Black;
                x.parent.parent.color = NodeColor.Red;
                x = x.parent.parent;
            }
            else {
                if (x === x.parent.left) {
                    x = x.parent;
                    rightRotate(tree, x);
                }
                x.parent.color = NodeColor.Black;
                x.parent.parent.color = NodeColor.Red;
                leftRotate(tree, x.parent.parent);
            }
        }
    }
    tree.root.color = NodeColor.Black;
}
function updateTreeMetadata(tree, x, delta, lineFeedCntDelta) {
    while (x !== tree.root && x !== SENTINEL) {
        if (x.parent.left === x) {
            x.parent.size_left += delta;
            x.parent.lf_left += lineFeedCntDelta;
        }
        x = x.parent;
    }
}
function recomputeTreeMetadata(tree, x) {
    let delta = 0;
    let lf_delta = 0;
    if (x === tree.root) {
        return;
    }
    while (x !== tree.root && x === x.parent.right) {
        x = x.parent;
    }
    if (x === tree.root) {
        return;
    }
    x = x.parent;
    delta = calculateSize(x.left) - x.size_left;
    lf_delta = calculateLF(x.left) - x.lf_left;
    x.size_left += delta;
    x.lf_left += lf_delta;
    while (x !== tree.root && (delta !== 0 || lf_delta !== 0)) {
        if (x.parent.left === x) {
            x.parent.size_left += delta;
            x.parent.lf_left += lf_delta;
        }
        x = x.parent;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/services/semanticTokensDto.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/services/semanticTokensDto.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeSemanticTokensDto: () => (/* binding */ decodeSemanticTokensDto),
/* harmony export */   encodeSemanticTokensDto: () => (/* binding */ encodeSemanticTokensDto)
/* harmony export */ });
/* harmony import */ var _base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/buffer.js */ "./node_modules/vscode/vscode/src/vs/base/common/buffer.js");
/* harmony import */ var _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");


var EncodedSemanticTokensType;
( (function(EncodedSemanticTokensType) {
    EncodedSemanticTokensType[EncodedSemanticTokensType["Full"] = 1] = "Full";
    EncodedSemanticTokensType[EncodedSemanticTokensType["Delta"] = 2] = "Delta";
})(EncodedSemanticTokensType || (EncodedSemanticTokensType = {})));
function reverseEndianness(arr) {
    for (let i = 0, len = arr.length; i < len; i += 4) {
        const b0 = arr[i + 0];
        const b1 = arr[i + 1];
        const b2 = arr[i + 2];
        const b3 = arr[i + 3];
        arr[i + 0] = b3;
        arr[i + 1] = b2;
        arr[i + 2] = b1;
        arr[i + 3] = b0;
    }
}
function toLittleEndianBuffer(arr) {
    const uint8Arr = ( new Uint8Array(arr.buffer, arr.byteOffset, arr.length * 4));
    if (!(0,_base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isLittleEndian)()) {
        reverseEndianness(uint8Arr);
    }
    return _base_common_buffer_js__WEBPACK_IMPORTED_MODULE_0__.VSBuffer.wrap(uint8Arr);
}
function fromLittleEndianBuffer(buff) {
    const uint8Arr = buff.buffer;
    if (!(0,_base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isLittleEndian)()) {
        reverseEndianness(uint8Arr);
    }
    if (uint8Arr.byteOffset % 4 === 0) {
        return ( new Uint32Array(uint8Arr.buffer, uint8Arr.byteOffset, uint8Arr.length / 4));
    }
    else {
        const data = ( new Uint8Array(uint8Arr.byteLength));
        data.set(uint8Arr);
        return ( new Uint32Array(data.buffer, data.byteOffset, data.length / 4));
    }
}
function encodeSemanticTokensDto(semanticTokens) {
    const dest = ( new Uint32Array(encodeSemanticTokensDtoSize(semanticTokens)));
    let offset = 0;
    dest[offset++] = semanticTokens.id;
    if (semanticTokens.type === 'full') {
        dest[offset++] = EncodedSemanticTokensType.Full;
        dest[offset++] = semanticTokens.data.length;
        dest.set(semanticTokens.data, offset);
        offset += semanticTokens.data.length;
    }
    else {
        dest[offset++] = EncodedSemanticTokensType.Delta;
        dest[offset++] = semanticTokens.deltas.length;
        for (const delta of semanticTokens.deltas) {
            dest[offset++] = delta.start;
            dest[offset++] = delta.deleteCount;
            if (delta.data) {
                dest[offset++] = delta.data.length;
                dest.set(delta.data, offset);
                offset += delta.data.length;
            }
            else {
                dest[offset++] = 0;
            }
        }
    }
    return toLittleEndianBuffer(dest);
}
function encodeSemanticTokensDtoSize(semanticTokens) {
    let result = 0;
    result += ((
    +1 + 1)
    );
    if (semanticTokens.type === 'full') {
        result += (+1
            + semanticTokens.data.length);
    }
    else {
        result += ((+1)
        );
        result += ((
        +1
            + 1 + 1)
        ) * semanticTokens.deltas.length;
        for (const delta of semanticTokens.deltas) {
            if (delta.data) {
                result += delta.data.length;
            }
        }
    }
    return result;
}
function decodeSemanticTokensDto(_buff) {
    const src = fromLittleEndianBuffer(_buff);
    let offset = 0;
    const id = src[offset++];
    const type = src[offset++];
    if (type === EncodedSemanticTokensType.Full) {
        const length = src[offset++];
        const data = src.subarray(offset, offset + length);
        offset += length;
        return {
            id: id,
            type: 'full',
            data: data
        };
    }
    const deltaCount = src[offset++];
    const deltas = [];
    for (let i = 0; i < deltaCount; i++) {
        const start = src[offset++];
        const deleteCount = src[offset++];
        const length = src[offset++];
        let data;
        if (length > 0) {
            data = src.subarray(offset, offset + length);
            offset += length;
        }
        deltas[i] = { start, deleteCount, data };
    }
    return {
        id: id,
        type: 'delta',
        deltas: deltas
    };
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/services/treeViewsDnd.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/services/treeViewsDnd.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DraggedTreeItemsIdentifier: () => (/* binding */ DraggedTreeItemsIdentifier),
/* harmony export */   TreeViewsDnDService: () => (/* binding */ TreeViewsDnDService)
/* harmony export */ });
class TreeViewsDnDService {
    constructor() {
        this._dragOperations = ( new Map());
    }
    removeDragOperationTransfer(uuid) {
        if ((uuid && ( this._dragOperations.has(uuid)))) {
            const operation = this._dragOperations.get(uuid);
            this._dragOperations.delete(uuid);
            return operation;
        }
        return undefined;
    }
    addDragOperationTransfer(uuid, transferPromise) {
        this._dragOperations.set(uuid, transferPromise);
    }
}
class DraggedTreeItemsIdentifier {
    constructor(identifier) {
        this.identifier = identifier;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/platform/accessibility/common/accessibility.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/platform/accessibility/common/accessibility.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCESSIBLE_VIEW_SHOWN_STORAGE_PREFIX: () => (/* binding */ ACCESSIBLE_VIEW_SHOWN_STORAGE_PREFIX),
/* harmony export */   AccessibilitySupport: () => (/* binding */ AccessibilitySupport),
/* harmony export */   CONTEXT_ACCESSIBILITY_MODE_ENABLED: () => (/* binding */ CONTEXT_ACCESSIBILITY_MODE_ENABLED),
/* harmony export */   isAccessibilityInformation: () => (/* binding */ isAccessibilityInformation)
/* harmony export */ });
/* harmony import */ var _contextkey_common_contextkey_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../contextkey/common/contextkey.js */ "./node_modules/vscode/vscode/src/vs/platform/contextkey/common/contextkey.js");

var AccessibilitySupport;
( (function(AccessibilitySupport) {
    AccessibilitySupport[AccessibilitySupport["Unknown"] = 0] = "Unknown";
    AccessibilitySupport[AccessibilitySupport["Disabled"] = 1] = "Disabled";
    AccessibilitySupport[AccessibilitySupport["Enabled"] = 2] = "Enabled";
})(AccessibilitySupport || (AccessibilitySupport = {})));
const CONTEXT_ACCESSIBILITY_MODE_ENABLED = ( new _contextkey_common_contextkey_js__WEBPACK_IMPORTED_MODULE_0__.RawContextKey('accessibilityModeEnabled', false));
function isAccessibilityInformation(obj) {
    return obj && typeof obj === 'object'
        && typeof obj.label === 'string'
        && (typeof obj.role === 'undefined' || typeof obj.role === 'string');
}
const ACCESSIBLE_VIEW_SHOWN_STORAGE_PREFIX = 'ACCESSIBLE_VIEW_SHOWN_';



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/platform/configuration/common/configuration.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/platform/configuration/common/configuration.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfigurationTarget: () => (/* binding */ ConfigurationTarget),
/* harmony export */   ConfigurationTargetToString: () => (/* binding */ ConfigurationTargetToString),
/* harmony export */   addToValueTree: () => (/* binding */ addToValueTree),
/* harmony export */   getConfigurationValue: () => (/* binding */ getConfigurationValue),
/* harmony export */   getLanguageTagSettingPlainKey: () => (/* binding */ getLanguageTagSettingPlainKey),
/* harmony export */   isConfigurationOverrides: () => (/* binding */ isConfigurationOverrides),
/* harmony export */   isConfigurationUpdateOverrides: () => (/* binding */ isConfigurationUpdateOverrides),
/* harmony export */   isConfigured: () => (/* binding */ isConfigured),
/* harmony export */   removeFromValueTree: () => (/* binding */ removeFromValueTree),
/* harmony export */   toValuesTree: () => (/* binding */ toValuesTree)
/* harmony export */ });
/* harmony import */ var _base_common_uri_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");

function isConfigurationOverrides(thing) {
    return thing
        && typeof thing === 'object'
        && (!thing.overrideIdentifier || typeof thing.overrideIdentifier === 'string')
        && (!thing.resource || thing.resource instanceof _base_common_uri_js__WEBPACK_IMPORTED_MODULE_0__.URI);
}
function isConfigurationUpdateOverrides(thing) {
    return thing
        && typeof thing === 'object'
        && (!thing.overrideIdentifiers || Array.isArray(thing.overrideIdentifiers))
        && !thing.overrideIdentifier
        && (!thing.resource || thing.resource instanceof _base_common_uri_js__WEBPACK_IMPORTED_MODULE_0__.URI);
}
var ConfigurationTarget;
( (function(ConfigurationTarget) {
    ConfigurationTarget[ConfigurationTarget["APPLICATION"] = 1] = "APPLICATION";
    ConfigurationTarget[ConfigurationTarget["USER"] = 2] = "USER";
    ConfigurationTarget[ConfigurationTarget["USER_LOCAL"] = 3] = "USER_LOCAL";
    ConfigurationTarget[ConfigurationTarget["USER_REMOTE"] = 4] = "USER_REMOTE";
    ConfigurationTarget[ConfigurationTarget["WORKSPACE"] = 5] = "WORKSPACE";
    ConfigurationTarget[ConfigurationTarget["WORKSPACE_FOLDER"] = 6] = "WORKSPACE_FOLDER";
    ConfigurationTarget[ConfigurationTarget["DEFAULT"] = 7] = "DEFAULT";
    ConfigurationTarget[ConfigurationTarget["MEMORY"] = 8] = "MEMORY";
})(ConfigurationTarget || (ConfigurationTarget = {})));
function ConfigurationTargetToString(configurationTarget) {
    switch (configurationTarget) {
        case ConfigurationTarget.APPLICATION: return 'APPLICATION';
        case ConfigurationTarget.USER: return 'USER';
        case ConfigurationTarget.USER_LOCAL: return 'USER_LOCAL';
        case ConfigurationTarget.USER_REMOTE: return 'USER_REMOTE';
        case ConfigurationTarget.WORKSPACE: return 'WORKSPACE';
        case ConfigurationTarget.WORKSPACE_FOLDER: return 'WORKSPACE_FOLDER';
        case ConfigurationTarget.DEFAULT: return 'DEFAULT';
        case ConfigurationTarget.MEMORY: return 'MEMORY';
    }
}
function isConfigured(configValue) {
    return configValue.applicationValue !== undefined ||
        configValue.userValue !== undefined ||
        configValue.userLocalValue !== undefined ||
        configValue.userRemoteValue !== undefined ||
        configValue.workspaceValue !== undefined ||
        configValue.workspaceFolderValue !== undefined;
}
function toValuesTree(properties, conflictReporter) {
    const root = Object.create(null);
    for (const key in properties) {
        addToValueTree(root, key, properties[key], conflictReporter);
    }
    return root;
}
function addToValueTree(settingsTreeRoot, key, value, conflictReporter) {
    const segments = key.split('.');
    const last = segments.pop();
    let curr = settingsTreeRoot;
    for (let i = 0; i < segments.length; i++) {
        const s = segments[i];
        let obj = curr[s];
        switch (typeof obj) {
            case 'undefined':
                obj = curr[s] = Object.create(null);
                break;
            case 'object':
                if (obj === null) {
                    conflictReporter(`Ignoring ${key} as ${segments.slice(0, i + 1).join('.')} is null`);
                    return;
                }
                break;
            default:
                conflictReporter(`Ignoring ${key} as ${segments.slice(0, i + 1).join('.')} is ${JSON.stringify(obj)}`);
                return;
        }
        curr = obj;
    }
    if (typeof curr === 'object' && curr !== null) {
        try {
            curr[last] = value;
        }
        catch (e) {
            conflictReporter(`Ignoring ${key} as ${segments.join('.')} is ${JSON.stringify(curr)}`);
        }
    }
    else {
        conflictReporter(`Ignoring ${key} as ${segments.join('.')} is ${JSON.stringify(curr)}`);
    }
}
function removeFromValueTree(valueTree, key) {
    const segments = key.split('.');
    doRemoveFromValueTree(valueTree, segments);
}
function doRemoveFromValueTree(valueTree, segments) {
    const first = segments.shift();
    if (segments.length === 0) {
        delete valueTree[first];
        return;
    }
    if (( Object.keys(valueTree)).indexOf(first) !== -1) {
        const value = valueTree[first];
        if (typeof value === 'object' && !Array.isArray(value)) {
            doRemoveFromValueTree(value, segments);
            if (( Object.keys(value)).length === 0) {
                delete valueTree[first];
            }
        }
    }
}
function getConfigurationValue(config, settingPath, defaultValue) {
    function accessSetting(config, path) {
        let current = config;
        for (const component of path) {
            if (typeof current !== 'object' || current === null) {
                return undefined;
            }
            current = current[component];
        }
        return current;
    }
    const path = settingPath.split('.');
    const result = accessSetting(config, path);
    return typeof result === 'undefined' ? defaultValue : result;
}
function getLanguageTagSettingPlainKey(settingKey) {
    return settingKey.replace(/[\[\]]/g, '');
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/platform/configuration/common/configuration.service.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/platform/configuration/common/configuration.service.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IConfigurationService: () => (/* binding */ IConfigurationService)
/* harmony export */ });
/* harmony import */ var _instantiation_common_instantiation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../instantiation/common/instantiation.js */ "./node_modules/vscode/vscode/src/vs/platform/instantiation/common/instantiation.js");

const IConfigurationService = ( (0,_instantiation_common_instantiation_js__WEBPACK_IMPORTED_MODULE_0__.createDecorator)('configurationService'));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/platform/configuration/common/configurationModels.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/platform/configuration/common/configurationModels.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Configuration: () => (/* binding */ Configuration$1),
/* harmony export */   ConfigurationChangeEvent: () => (/* binding */ ConfigurationChangeEvent),
/* harmony export */   ConfigurationModel: () => (/* binding */ ConfigurationModel),
/* harmony export */   ConfigurationModelParser: () => (/* binding */ ConfigurationModelParser),
/* harmony export */   UserSettings: () => (/* binding */ UserSettings),
/* harmony export */   mergeChanges: () => (/* binding */ mergeChanges)
/* harmony export */ });
/* harmony import */ var _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _base_common_event_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _base_common_json_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../base/common/json.js */ "./node_modules/vscode/vscode/src/vs/base/common/json.js");
/* harmony import */ var _base_common_lifecycle_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../base/common/lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");
/* harmony import */ var _base_common_map_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../base/common/map.js */ "./node_modules/vscode/vscode/src/vs/base/common/map.js");
/* harmony import */ var _base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../base/common/objects.js */ "./node_modules/vscode/vscode/src/vs/base/common/objects.js");
/* harmony import */ var _base_common_types_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../base/common/types.js */ "./node_modules/vscode/vscode/src/vs/base/common/types.js");
/* harmony import */ var _base_common_uri_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../base/common/uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");
/* harmony import */ var _configuration_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./configuration.js */ "./node_modules/vscode/vscode/src/vs/platform/configuration/common/configuration.js");
/* harmony import */ var _configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./configurationRegistry.js */ "./node_modules/vscode/vscode/src/vs/platform/configuration/common/configurationRegistry.js");
/* harmony import */ var _files_common_files_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../files/common/files.js */ "./node_modules/vscode/vscode/src/vs/platform/files/common/files.js");
/* harmony import */ var _registry_common_platform_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../registry/common/platform.js */ "./node_modules/vscode/vscode/src/vs/platform/registry/common/platform.js");












function freeze(data) {
    return Object.isFrozen(data) ? data : (0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.deepFreeze)(data);
}
class ConfigurationModel {
    static createEmptyModel(logService) {
        return ( new ConfigurationModel({}, [], [], undefined, logService));
    }
    constructor(_contents, _keys, _overrides, raw, logService) {
        this._contents = _contents;
        this._keys = _keys;
        this._overrides = _overrides;
        this.raw = raw;
        this.logService = logService;
        this.overrideConfigurations = ( new Map());
    }
    get rawConfiguration() {
        if (!this._rawConfiguration) {
            if (this.raw?.length) {
                const rawConfigurationModels = ( this.raw.map(raw => {
                    if (raw instanceof ConfigurationModel) {
                        return raw;
                    }
                    const parser = ( new ConfigurationModelParser('', this.logService));
                    parser.parseRaw(raw);
                    return parser.configurationModel;
                }));
                this._rawConfiguration = rawConfigurationModels.reduce((previous, current) => current === previous ? current : previous.merge(current), rawConfigurationModels[0]);
            }
            else {
                this._rawConfiguration = this;
            }
        }
        return this._rawConfiguration;
    }
    get contents() {
        return this._contents;
    }
    get overrides() {
        return this._overrides;
    }
    get keys() {
        return this._keys;
    }
    isEmpty() {
        return this._keys.length === 0 && ( Object.keys(this._contents)).length === 0 && this._overrides.length === 0;
    }
    getValue(section) {
        return section ? (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.getConfigurationValue)(this.contents, section) : this.contents;
    }
    inspect(section, overrideIdentifier) {
        const that = this;
        return {
            get value() {
                return freeze(that.rawConfiguration.getValue(section));
            },
            get override() {
                return overrideIdentifier ? freeze(that.rawConfiguration.getOverrideValue(section, overrideIdentifier)) : undefined;
            },
            get merged() {
                return freeze(overrideIdentifier ? that.rawConfiguration.override(overrideIdentifier).getValue(section) : that.rawConfiguration.getValue(section));
            },
            get overrides() {
                const overrides = [];
                for (const { contents, identifiers, keys } of that.rawConfiguration.overrides) {
                    const value = ( new ConfigurationModel(contents, keys, [], undefined, that.logService)).getValue(section);
                    if (value !== undefined) {
                        overrides.push({ identifiers, value });
                    }
                }
                return overrides.length ? freeze(overrides) : undefined;
            }
        };
    }
    getOverrideValue(section, overrideIdentifier) {
        const overrideContents = this.getContentsForOverrideIdentifer(overrideIdentifier);
        return overrideContents
            ? section ? (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.getConfigurationValue)(overrideContents, section) : overrideContents
            : undefined;
    }
    getKeysForOverrideIdentifier(identifier) {
        const keys = [];
        for (const override of this.overrides) {
            if (override.identifiers.includes(identifier)) {
                keys.push(...override.keys);
            }
        }
        return (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.distinct)(keys);
    }
    getAllOverrideIdentifiers() {
        const result = [];
        for (const override of this.overrides) {
            result.push(...override.identifiers);
        }
        return (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.distinct)(result);
    }
    override(identifier) {
        let overrideConfigurationModel = this.overrideConfigurations.get(identifier);
        if (!overrideConfigurationModel) {
            overrideConfigurationModel = this.createOverrideConfigurationModel(identifier);
            this.overrideConfigurations.set(identifier, overrideConfigurationModel);
        }
        return overrideConfigurationModel;
    }
    merge(...others) {
        const contents = (0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.deepClone)(this.contents);
        const overrides = (0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.deepClone)(this.overrides);
        const keys = [...this.keys];
        const raws = this.raw?.length ? [...this.raw] : [this];
        for (const other of others) {
            raws.push(...(other.raw?.length ? other.raw : [other]));
            if (other.isEmpty()) {
                continue;
            }
            this.mergeContents(contents, other.contents);
            for (const otherOverride of other.overrides) {
                const [override] = overrides.filter(o => (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.equals)(o.identifiers, otherOverride.identifiers));
                if (override) {
                    this.mergeContents(override.contents, otherOverride.contents);
                    override.keys.push(...otherOverride.keys);
                    override.keys = (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.distinct)(override.keys);
                }
                else {
                    overrides.push((0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.deepClone)(otherOverride));
                }
            }
            for (const key of other.keys) {
                if (keys.indexOf(key) === -1) {
                    keys.push(key);
                }
            }
        }
        return ( new ConfigurationModel(
            contents,
            keys,
            overrides,
            raws.every(raw => raw instanceof ConfigurationModel) ? undefined : raws,
            this.logService
        ));
    }
    createOverrideConfigurationModel(identifier) {
        const overrideContents = this.getContentsForOverrideIdentifer(identifier);
        if (!overrideContents || typeof overrideContents !== 'object' || !( Object.keys(overrideContents)).length) {
            return this;
        }
        const contents = {};
        for (const key of (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.distinct)([...( Object.keys(this.contents)), ...( Object.keys(overrideContents))])) {
            let contentsForKey = this.contents[key];
            const overrideContentsForKey = overrideContents[key];
            if (overrideContentsForKey) {
                if (typeof contentsForKey === 'object' && typeof overrideContentsForKey === 'object') {
                    contentsForKey = (0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.deepClone)(contentsForKey);
                    this.mergeContents(contentsForKey, overrideContentsForKey);
                }
                else {
                    contentsForKey = overrideContentsForKey;
                }
            }
            contents[key] = contentsForKey;
        }
        return ( new ConfigurationModel(contents, this.keys, this.overrides, undefined, this.logService));
    }
    mergeContents(source, target) {
        for (const key of ( Object.keys(target))) {
            if (key in source) {
                if ((0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_6__.isObject)(source[key]) && (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_6__.isObject)(target[key])) {
                    this.mergeContents(source[key], target[key]);
                    continue;
                }
            }
            source[key] = (0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.deepClone)(target[key]);
        }
    }
    getContentsForOverrideIdentifer(identifier) {
        let contentsForIdentifierOnly = null;
        let contents = null;
        const mergeContents = (contentsToMerge) => {
            if (contentsToMerge) {
                if (contents) {
                    this.mergeContents(contents, contentsToMerge);
                }
                else {
                    contents = (0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.deepClone)(contentsToMerge);
                }
            }
        };
        for (const override of this.overrides) {
            if (override.identifiers.length === 1 && override.identifiers[0] === identifier) {
                contentsForIdentifierOnly = override.contents;
            }
            else if (override.identifiers.includes(identifier)) {
                mergeContents(override.contents);
            }
        }
        mergeContents(contentsForIdentifierOnly);
        return contents;
    }
    toJSON() {
        return {
            contents: this.contents,
            overrides: this.overrides,
            keys: this.keys
        };
    }
    addValue(key, value) {
        this.updateValue(key, value, true);
    }
    setValue(key, value) {
        this.updateValue(key, value, false);
    }
    removeValue(key) {
        const index = this.keys.indexOf(key);
        if (index === -1) {
            return;
        }
        this.keys.splice(index, 1);
        (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.removeFromValueTree)(this.contents, key);
        if (_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.OVERRIDE_PROPERTY_REGEX.test(key)) {
            this.overrides.splice(this.overrides.findIndex(o => (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.equals)(o.identifiers, (0,_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.overrideIdentifiersFromKey)(key))), 1);
        }
    }
    updateValue(key, value, add) {
        (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.addToValueTree)(this.contents, key, value, e => this.logService.error(e));
        add = add || this.keys.indexOf(key) === -1;
        if (add) {
            this.keys.push(key);
        }
        if (_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.OVERRIDE_PROPERTY_REGEX.test(key)) {
            this.overrides.push({
                identifiers: (0,_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.overrideIdentifiersFromKey)(key),
                keys: ( Object.keys(this.contents[key])),
                contents: (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.toValuesTree)(this.contents[key], message => this.logService.error(message)),
            });
        }
    }
}
class ConfigurationModelParser {
    constructor(_name, logService) {
        this._name = _name;
        this.logService = logService;
        this._raw = null;
        this._configurationModel = null;
        this._restrictedConfigurations = [];
        this._parseErrors = [];
    }
    get configurationModel() {
        return this._configurationModel || ConfigurationModel.createEmptyModel(this.logService);
    }
    get restrictedConfigurations() {
        return this._restrictedConfigurations;
    }
    get errors() {
        return this._parseErrors;
    }
    parse(content, options) {
        if (!(0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_6__.isUndefinedOrNull)(content)) {
            const raw = this.doParseContent(content);
            this.parseRaw(raw, options);
        }
    }
    reparse(options) {
        if (this._raw) {
            this.parseRaw(this._raw, options);
        }
    }
    parseRaw(raw, options) {
        this._raw = raw;
        const { contents, keys, overrides, restricted, hasExcludedProperties } = this.doParseRaw(raw, options);
        this._configurationModel = ( new ConfigurationModel(
            contents,
            keys,
            overrides,
            hasExcludedProperties ? [raw] : undefined ,
            this.logService
        ));
        this._restrictedConfigurations = restricted || [];
    }
    doParseContent(content) {
        let raw = {};
        let currentProperty = null;
        let currentParent = [];
        const previousParents = [];
        function onValue(value) {
            if (Array.isArray(currentParent)) {
                currentParent.push(value);
            }
            else if (currentProperty !== null) {
                currentParent[currentProperty] = value;
            }
        }
        const visitor = {
            onObjectBegin: () => {
                const object = {};
                onValue(object);
                previousParents.push(currentParent);
                currentParent = object;
                currentProperty = null;
            },
            onObjectProperty: (name) => {
                currentProperty = name;
            },
            onObjectEnd: () => {
                currentParent = previousParents.pop();
            },
            onArrayBegin: () => {
                const array = [];
                onValue(array);
                previousParents.push(currentParent);
                currentParent = array;
                currentProperty = null;
            },
            onArrayEnd: () => {
                currentParent = previousParents.pop();
            },
            onLiteralValue: onValue,
            onError: (error, offset, length) => {
            }
        };
        if (content) {
            try {
                (0,_base_common_json_js__WEBPACK_IMPORTED_MODULE_2__.visit)(content, visitor);
                raw = currentParent[0] || {};
            }
            catch (e) {
                this.logService.error(`Error while parsing settings file ${this._name}: ${e}`);
                this._parseErrors = [e];
            }
        }
        return raw;
    }
    doParseRaw(raw, options) {
        const configurationProperties = ( _registry_common_platform_js__WEBPACK_IMPORTED_MODULE_11__.Registry.as(_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.Extensions.Configuration)).getConfigurationProperties();
        const filtered = this.filter(raw, configurationProperties, true, options);
        raw = filtered.raw;
        const contents = (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.toValuesTree)(raw, message => this.logService.error(`Conflict in settings file ${this._name}: ${message}`));
        const keys = ( Object.keys(raw));
        const overrides = this.toOverrides(raw, message => this.logService.error(`Conflict in settings file ${this._name}: ${message}`));
        return { contents, keys, overrides, restricted: filtered.restricted, hasExcludedProperties: filtered.hasExcludedProperties };
    }
    filter(properties, configurationProperties, filterOverriddenProperties, options) {
        let hasExcludedProperties = false;
        if (!options?.scopes && !options?.skipRestricted && !options?.exclude?.length) {
            return { raw: properties, restricted: [], hasExcludedProperties };
        }
        const raw = {};
        const restricted = [];
        for (const key in properties) {
            if (_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.OVERRIDE_PROPERTY_REGEX.test(key) && filterOverriddenProperties) {
                const result = this.filter(properties[key], configurationProperties, false, options);
                raw[key] = result.raw;
                hasExcludedProperties = hasExcludedProperties || result.hasExcludedProperties;
                restricted.push(...result.restricted);
            }
            else {
                const propertySchema = configurationProperties[key];
                const scope = propertySchema ? typeof propertySchema.scope !== 'undefined' ? propertySchema.scope : _configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.ConfigurationScope.WINDOW : undefined;
                if (propertySchema?.restricted) {
                    restricted.push(key);
                }
                if (!options.exclude?.includes(key)
                    && (options.include?.includes(key)
                        || ((scope === undefined || options.scopes === undefined || options.scopes.includes(scope))
                            && !(options.skipRestricted && propertySchema?.restricted))))  {
                    raw[key] = properties[key];
                }
                else {
                    hasExcludedProperties = true;
                }
            }
        }
        return { raw, restricted, hasExcludedProperties };
    }
    toOverrides(raw, conflictReporter) {
        const overrides = [];
        for (const key of ( Object.keys(raw))) {
            if (_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.OVERRIDE_PROPERTY_REGEX.test(key)) {
                const overrideRaw = {};
                for (const keyInOverrideRaw in raw[key]) {
                    overrideRaw[keyInOverrideRaw] = raw[key][keyInOverrideRaw];
                }
                overrides.push({
                    identifiers: (0,_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.overrideIdentifiersFromKey)(key),
                    keys: ( Object.keys(overrideRaw)),
                    contents: (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.toValuesTree)(overrideRaw, conflictReporter)
                });
            }
        }
        return overrides;
    }
}
class UserSettings extends _base_common_lifecycle_js__WEBPACK_IMPORTED_MODULE_3__.Disposable {
    constructor(userSettingsResource, parseOptions, extUri, fileService, logService) {
        super();
        this.userSettingsResource = userSettingsResource;
        this.parseOptions = parseOptions;
        this.fileService = fileService;
        this.logService = logService;
        this._onDidChange = this._register(( new _base_common_event_js__WEBPACK_IMPORTED_MODULE_1__.Emitter()));
        this.onDidChange = this._onDidChange.event;
        this.parser = ( new ConfigurationModelParser(( this.userSettingsResource.toString()), logService));
        this._register(this.fileService.watch(extUri.dirname(this.userSettingsResource)));
        this._register(this.fileService.watch(this.userSettingsResource));
        this._register(_base_common_event_js__WEBPACK_IMPORTED_MODULE_1__.Event.any(_base_common_event_js__WEBPACK_IMPORTED_MODULE_1__.Event.filter(this.fileService.onDidFilesChange, e => e.contains(this.userSettingsResource)), _base_common_event_js__WEBPACK_IMPORTED_MODULE_1__.Event.filter(this.fileService.onDidRunOperation, e => (e.isOperation(_files_common_files_js__WEBPACK_IMPORTED_MODULE_10__.FileOperation.CREATE) || e.isOperation(_files_common_files_js__WEBPACK_IMPORTED_MODULE_10__.FileOperation.COPY) || e.isOperation(_files_common_files_js__WEBPACK_IMPORTED_MODULE_10__.FileOperation.DELETE) || e.isOperation(_files_common_files_js__WEBPACK_IMPORTED_MODULE_10__.FileOperation.WRITE)) && extUri.isEqual(e.resource, userSettingsResource)))(() => this._onDidChange.fire()));
    }
    async loadConfiguration() {
        try {
            const content = await this.fileService.readFile(this.userSettingsResource);
            this.parser.parse(( content.value.toString()) || '{}', this.parseOptions);
            return this.parser.configurationModel;
        }
        catch (e) {
            return ConfigurationModel.createEmptyModel(this.logService);
        }
    }
    reparse(parseOptions) {
        if (parseOptions) {
            this.parseOptions = parseOptions;
        }
        this.parser.reparse(this.parseOptions);
        return this.parser.configurationModel;
    }
    getRestrictedSettings() {
        return this.parser.restrictedConfigurations;
    }
}
class ConfigurationInspectValue {
    constructor(key, overrides, _value, overrideIdentifiers, defaultConfiguration, policyConfiguration, applicationConfiguration, userConfiguration, localUserConfiguration, remoteUserConfiguration, workspaceConfiguration, folderConfigurationModel, memoryConfigurationModel) {
        this.key = key;
        this.overrides = overrides;
        this._value = _value;
        this.overrideIdentifiers = overrideIdentifiers;
        this.defaultConfiguration = defaultConfiguration;
        this.policyConfiguration = policyConfiguration;
        this.applicationConfiguration = applicationConfiguration;
        this.userConfiguration = userConfiguration;
        this.localUserConfiguration = localUserConfiguration;
        this.remoteUserConfiguration = remoteUserConfiguration;
        this.workspaceConfiguration = workspaceConfiguration;
        this.folderConfigurationModel = folderConfigurationModel;
        this.memoryConfigurationModel = memoryConfigurationModel;
    }
    get value() {
        return freeze(this._value);
    }
    toInspectValue(inspectValue) {
        return inspectValue?.value !== undefined || inspectValue?.override !== undefined || inspectValue?.overrides !== undefined ? inspectValue : undefined;
    }
    get defaultInspectValue() {
        if (!this._defaultInspectValue) {
            this._defaultInspectValue = this.defaultConfiguration.inspect(this.key, this.overrides.overrideIdentifier);
        }
        return this._defaultInspectValue;
    }
    get defaultValue() {
        return this.defaultInspectValue.merged;
    }
    get default() {
        return this.toInspectValue(this.defaultInspectValue);
    }
    get policyInspectValue() {
        if (this._policyInspectValue === undefined) {
            this._policyInspectValue = this.policyConfiguration ? this.policyConfiguration.inspect(this.key) : null;
        }
        return this._policyInspectValue;
    }
    get policyValue() {
        return this.policyInspectValue?.merged;
    }
    get policy() {
        return this.policyInspectValue?.value !== undefined ? { value: this.policyInspectValue.value } : undefined;
    }
    get applicationInspectValue() {
        if (this._applicationInspectValue === undefined) {
            this._applicationInspectValue = this.applicationConfiguration ? this.applicationConfiguration.inspect(this.key) : null;
        }
        return this._applicationInspectValue;
    }
    get applicationValue() {
        return this.applicationInspectValue?.merged;
    }
    get application() {
        return this.toInspectValue(this.applicationInspectValue);
    }
    get userInspectValue() {
        if (!this._userInspectValue) {
            this._userInspectValue = this.userConfiguration.inspect(this.key, this.overrides.overrideIdentifier);
        }
        return this._userInspectValue;
    }
    get userValue() {
        return this.userInspectValue.merged;
    }
    get user() {
        return this.toInspectValue(this.userInspectValue);
    }
    get userLocalInspectValue() {
        if (!this._userLocalInspectValue) {
            this._userLocalInspectValue = this.localUserConfiguration.inspect(this.key, this.overrides.overrideIdentifier);
        }
        return this._userLocalInspectValue;
    }
    get userLocalValue() {
        return this.userLocalInspectValue.merged;
    }
    get userLocal() {
        return this.toInspectValue(this.userLocalInspectValue);
    }
    get userRemoteInspectValue() {
        if (!this._userRemoteInspectValue) {
            this._userRemoteInspectValue = this.remoteUserConfiguration.inspect(this.key, this.overrides.overrideIdentifier);
        }
        return this._userRemoteInspectValue;
    }
    get userRemoteValue() {
        return this.userRemoteInspectValue.merged;
    }
    get userRemote() {
        return this.toInspectValue(this.userRemoteInspectValue);
    }
    get workspaceInspectValue() {
        if (this._workspaceInspectValue === undefined) {
            this._workspaceInspectValue = this.workspaceConfiguration ? this.workspaceConfiguration.inspect(this.key, this.overrides.overrideIdentifier) : null;
        }
        return this._workspaceInspectValue;
    }
    get workspaceValue() {
        return this.workspaceInspectValue?.merged;
    }
    get workspace() {
        return this.toInspectValue(this.workspaceInspectValue);
    }
    get workspaceFolderInspectValue() {
        if (this._workspaceFolderInspectValue === undefined) {
            this._workspaceFolderInspectValue = this.folderConfigurationModel ? this.folderConfigurationModel.inspect(this.key, this.overrides.overrideIdentifier) : null;
        }
        return this._workspaceFolderInspectValue;
    }
    get workspaceFolderValue() {
        return this.workspaceFolderInspectValue?.merged;
    }
    get workspaceFolder() {
        return this.toInspectValue(this.workspaceFolderInspectValue);
    }
    get memoryInspectValue() {
        if (this._memoryInspectValue === undefined) {
            this._memoryInspectValue = this.memoryConfigurationModel.inspect(this.key, this.overrides.overrideIdentifier);
        }
        return this._memoryInspectValue;
    }
    get memoryValue() {
        return this.memoryInspectValue.merged;
    }
    get memory() {
        return this.toInspectValue(this.memoryInspectValue);
    }
}
let Configuration$1 = class Configuration {
    constructor(_defaultConfiguration, _policyConfiguration, _applicationConfiguration, _localUserConfiguration, _remoteUserConfiguration, _workspaceConfiguration, _folderConfigurations, _memoryConfiguration, _memoryConfigurationByResource, logService) {
        this._defaultConfiguration = _defaultConfiguration;
        this._policyConfiguration = _policyConfiguration;
        this._applicationConfiguration = _applicationConfiguration;
        this._localUserConfiguration = _localUserConfiguration;
        this._remoteUserConfiguration = _remoteUserConfiguration;
        this._workspaceConfiguration = _workspaceConfiguration;
        this._folderConfigurations = _folderConfigurations;
        this._memoryConfiguration = _memoryConfiguration;
        this._memoryConfigurationByResource = _memoryConfigurationByResource;
        this.logService = logService;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations = ( new _base_common_map_js__WEBPACK_IMPORTED_MODULE_4__.ResourceMap());
        this._userConfiguration = null;
    }
    getValue(section, overrides, workspace) {
        const consolidateConfigurationModel = this.getConsolidatedConfigurationModel(section, overrides, workspace);
        return consolidateConfigurationModel.getValue(section);
    }
    updateValue(key, value, overrides = {}) {
        let memoryConfiguration;
        if (overrides.resource) {
            memoryConfiguration = this._memoryConfigurationByResource.get(overrides.resource);
            if (!memoryConfiguration) {
                memoryConfiguration = ConfigurationModel.createEmptyModel(this.logService);
                this._memoryConfigurationByResource.set(overrides.resource, memoryConfiguration);
            }
        }
        else {
            memoryConfiguration = this._memoryConfiguration;
        }
        if (value === undefined) {
            memoryConfiguration.removeValue(key);
        }
        else {
            memoryConfiguration.setValue(key, value);
        }
        if (!overrides.resource) {
            this._workspaceConsolidatedConfiguration = null;
        }
    }
    inspect(key, overrides, workspace) {
        const consolidateConfigurationModel = this.getConsolidatedConfigurationModel(key, overrides, workspace);
        const folderConfigurationModel = this.getFolderConfigurationModelForResource(overrides.resource, workspace);
        const memoryConfigurationModel = overrides.resource ? this._memoryConfigurationByResource.get(overrides.resource) || this._memoryConfiguration : this._memoryConfiguration;
        const overrideIdentifiers = ( new Set());
        for (const override of consolidateConfigurationModel.overrides) {
            for (const overrideIdentifier of override.identifiers) {
                if (consolidateConfigurationModel.getOverrideValue(key, overrideIdentifier) !== undefined) {
                    overrideIdentifiers.add(overrideIdentifier);
                }
            }
        }
        return ( new ConfigurationInspectValue(
            key,
            overrides,
            consolidateConfigurationModel.getValue(key),
            overrideIdentifiers.size ? [...overrideIdentifiers] : undefined,
            this._defaultConfiguration,
            this._policyConfiguration.isEmpty() ? undefined : this._policyConfiguration,
            this.applicationConfiguration.isEmpty() ? undefined : this.applicationConfiguration,
            this.userConfiguration,
            this.localUserConfiguration,
            this.remoteUserConfiguration,
            workspace ? this._workspaceConfiguration : undefined,
            folderConfigurationModel ? folderConfigurationModel : undefined,
            memoryConfigurationModel
        ));
    }
    keys(workspace) {
        const folderConfigurationModel = this.getFolderConfigurationModelForResource(undefined, workspace);
        return {
            default: this._defaultConfiguration.keys.slice(0),
            user: this.userConfiguration.keys.slice(0),
            workspace: this._workspaceConfiguration.keys.slice(0),
            workspaceFolder: folderConfigurationModel ? folderConfigurationModel.keys.slice(0) : []
        };
    }
    updateDefaultConfiguration(defaultConfiguration) {
        this._defaultConfiguration = defaultConfiguration;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    }
    updatePolicyConfiguration(policyConfiguration) {
        this._policyConfiguration = policyConfiguration;
    }
    updateApplicationConfiguration(applicationConfiguration) {
        this._applicationConfiguration = applicationConfiguration;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    }
    updateLocalUserConfiguration(localUserConfiguration) {
        this._localUserConfiguration = localUserConfiguration;
        this._userConfiguration = null;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    }
    updateRemoteUserConfiguration(remoteUserConfiguration) {
        this._remoteUserConfiguration = remoteUserConfiguration;
        this._userConfiguration = null;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    }
    updateWorkspaceConfiguration(workspaceConfiguration) {
        this._workspaceConfiguration = workspaceConfiguration;
        this._workspaceConsolidatedConfiguration = null;
        this._foldersConsolidatedConfigurations.clear();
    }
    updateFolderConfiguration(resource, configuration) {
        this._folderConfigurations.set(resource, configuration);
        this._foldersConsolidatedConfigurations.delete(resource);
    }
    deleteFolderConfiguration(resource) {
        this.folderConfigurations.delete(resource);
        this._foldersConsolidatedConfigurations.delete(resource);
    }
    compareAndUpdateDefaultConfiguration(defaults, keys) {
        const overrides = [];
        if (!keys) {
            const { added, updated, removed } = compare(this._defaultConfiguration, defaults);
            keys = [...added, ...updated, ...removed];
        }
        for (const key of keys) {
            for (const overrideIdentifier of (0,_configurationRegistry_js__WEBPACK_IMPORTED_MODULE_9__.overrideIdentifiersFromKey)(key)) {
                const fromKeys = this._defaultConfiguration.getKeysForOverrideIdentifier(overrideIdentifier);
                const toKeys = defaults.getKeysForOverrideIdentifier(overrideIdentifier);
                const keys = [
                    ...toKeys.filter(key => fromKeys.indexOf(key) === -1),
                    ...fromKeys.filter(key => toKeys.indexOf(key) === -1),
                    ...fromKeys.filter(key => !(0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.equals)(this._defaultConfiguration.override(overrideIdentifier).getValue(key), defaults.override(overrideIdentifier).getValue(key)))
                ];
                overrides.push([overrideIdentifier, keys]);
            }
        }
        this.updateDefaultConfiguration(defaults);
        return { keys, overrides };
    }
    compareAndUpdatePolicyConfiguration(policyConfiguration) {
        const { added, updated, removed } = compare(this._policyConfiguration, policyConfiguration);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
            this.updatePolicyConfiguration(policyConfiguration);
        }
        return { keys, overrides: [] };
    }
    compareAndUpdateApplicationConfiguration(application) {
        const { added, updated, removed, overrides } = compare(this.applicationConfiguration, application);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
            this.updateApplicationConfiguration(application);
        }
        return { keys, overrides };
    }
    compareAndUpdateLocalUserConfiguration(user) {
        const { added, updated, removed, overrides } = compare(this.localUserConfiguration, user);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
            this.updateLocalUserConfiguration(user);
        }
        return { keys, overrides };
    }
    compareAndUpdateRemoteUserConfiguration(user) {
        const { added, updated, removed, overrides } = compare(this.remoteUserConfiguration, user);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
            this.updateRemoteUserConfiguration(user);
        }
        return { keys, overrides };
    }
    compareAndUpdateWorkspaceConfiguration(workspaceConfiguration) {
        const { added, updated, removed, overrides } = compare(this.workspaceConfiguration, workspaceConfiguration);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
            this.updateWorkspaceConfiguration(workspaceConfiguration);
        }
        return { keys, overrides };
    }
    compareAndUpdateFolderConfiguration(resource, folderConfiguration) {
        const currentFolderConfiguration = this.folderConfigurations.get(resource);
        const { added, updated, removed, overrides } = compare(currentFolderConfiguration, folderConfiguration);
        const keys = [...added, ...updated, ...removed];
        if (keys.length || !currentFolderConfiguration) {
            this.updateFolderConfiguration(resource, folderConfiguration);
        }
        return { keys, overrides };
    }
    compareAndDeleteFolderConfiguration(folder) {
        const folderConfig = this.folderConfigurations.get(folder);
        if (!folderConfig) {
            throw ( new Error('Unknown folder'));
        }
        this.deleteFolderConfiguration(folder);
        const { added, updated, removed, overrides } = compare(folderConfig, undefined);
        return { keys: [...added, ...updated, ...removed], overrides };
    }
    get defaults() {
        return this._defaultConfiguration;
    }
    get applicationConfiguration() {
        return this._applicationConfiguration;
    }
    get userConfiguration() {
        if (!this._userConfiguration) {
            this._userConfiguration = this._remoteUserConfiguration.isEmpty() ? this._localUserConfiguration : this._localUserConfiguration.merge(this._remoteUserConfiguration);
        }
        return this._userConfiguration;
    }
    get localUserConfiguration() {
        return this._localUserConfiguration;
    }
    get remoteUserConfiguration() {
        return this._remoteUserConfiguration;
    }
    get workspaceConfiguration() {
        return this._workspaceConfiguration;
    }
    get folderConfigurations() {
        return this._folderConfigurations;
    }
    getConsolidatedConfigurationModel(section, overrides, workspace) {
        let configurationModel = this.getConsolidatedConfigurationModelForResource(overrides, workspace);
        if (overrides.overrideIdentifier) {
            configurationModel = configurationModel.override(overrides.overrideIdentifier);
        }
        if (!this._policyConfiguration.isEmpty() && this._policyConfiguration.getValue(section) !== undefined) {
            configurationModel = configurationModel.merge(this._policyConfiguration);
        }
        return configurationModel;
    }
    getConsolidatedConfigurationModelForResource({ resource }, workspace) {
        let consolidateConfiguration = this.getWorkspaceConsolidatedConfiguration();
        if (workspace && resource) {
            const root = workspace.getFolder(resource);
            if (root) {
                consolidateConfiguration = this.getFolderConsolidatedConfiguration(root.uri) || consolidateConfiguration;
            }
            const memoryConfigurationForResource = this._memoryConfigurationByResource.get(resource);
            if (memoryConfigurationForResource) {
                consolidateConfiguration = consolidateConfiguration.merge(memoryConfigurationForResource);
            }
        }
        return consolidateConfiguration;
    }
    getWorkspaceConsolidatedConfiguration() {
        if (!this._workspaceConsolidatedConfiguration) {
            this._workspaceConsolidatedConfiguration = this._defaultConfiguration.merge(this.applicationConfiguration, this.userConfiguration, this._workspaceConfiguration, this._memoryConfiguration);
        }
        return this._workspaceConsolidatedConfiguration;
    }
    getFolderConsolidatedConfiguration(folder) {
        let folderConsolidatedConfiguration = this._foldersConsolidatedConfigurations.get(folder);
        if (!folderConsolidatedConfiguration) {
            const workspaceConsolidateConfiguration = this.getWorkspaceConsolidatedConfiguration();
            const folderConfiguration = this._folderConfigurations.get(folder);
            if (folderConfiguration) {
                folderConsolidatedConfiguration = workspaceConsolidateConfiguration.merge(folderConfiguration);
                this._foldersConsolidatedConfigurations.set(folder, folderConsolidatedConfiguration);
            }
            else {
                folderConsolidatedConfiguration = workspaceConsolidateConfiguration;
            }
        }
        return folderConsolidatedConfiguration;
    }
    getFolderConfigurationModelForResource(resource, workspace) {
        if (workspace && resource) {
            const root = workspace.getFolder(resource);
            if (root) {
                return this._folderConfigurations.get(root.uri);
            }
        }
        return undefined;
    }
    toData() {
        return {
            defaults: {
                contents: this._defaultConfiguration.contents,
                overrides: this._defaultConfiguration.overrides,
                keys: this._defaultConfiguration.keys
            },
            policy: {
                contents: this._policyConfiguration.contents,
                overrides: this._policyConfiguration.overrides,
                keys: this._policyConfiguration.keys
            },
            application: {
                contents: this.applicationConfiguration.contents,
                overrides: this.applicationConfiguration.overrides,
                keys: this.applicationConfiguration.keys
            },
            user: {
                contents: this.userConfiguration.contents,
                overrides: this.userConfiguration.overrides,
                keys: this.userConfiguration.keys
            },
            workspace: {
                contents: this._workspaceConfiguration.contents,
                overrides: this._workspaceConfiguration.overrides,
                keys: this._workspaceConfiguration.keys
            },
            folders: [...( this._folderConfigurations.keys())].reduce((result, folder) => {
                const { contents, overrides, keys } = this._folderConfigurations.get(folder);
                result.push([folder, { contents, overrides, keys }]);
                return result;
            }, [])
        };
    }
    allKeys() {
        const keys = ( new Set());
        this._defaultConfiguration.keys.forEach(key => keys.add(key));
        this.userConfiguration.keys.forEach(key => keys.add(key));
        this._workspaceConfiguration.keys.forEach(key => keys.add(key));
        this._folderConfigurations.forEach(folderConfiguration => folderConfiguration.keys.forEach(key => keys.add(key)));
        return [...( keys.values())];
    }
    allOverrideIdentifiers() {
        const keys = ( new Set());
        this._defaultConfiguration.getAllOverrideIdentifiers().forEach(key => keys.add(key));
        this.userConfiguration.getAllOverrideIdentifiers().forEach(key => keys.add(key));
        this._workspaceConfiguration.getAllOverrideIdentifiers().forEach(key => keys.add(key));
        this._folderConfigurations.forEach(folderConfiguration => folderConfiguration.getAllOverrideIdentifiers().forEach(key => keys.add(key)));
        return [...( keys.values())];
    }
    getAllKeysForOverrideIdentifier(overrideIdentifier) {
        const keys = ( new Set());
        this._defaultConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(key => keys.add(key));
        this.userConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(key => keys.add(key));
        this._workspaceConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(key => keys.add(key));
        this._folderConfigurations.forEach(folderConfiguration => folderConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(key => keys.add(key)));
        return [...( keys.values())];
    }
    static parse(data, logService) {
        const defaultConfiguration = this.parseConfigurationModel(data.defaults, logService);
        const policyConfiguration = this.parseConfigurationModel(data.policy, logService);
        const applicationConfiguration = this.parseConfigurationModel(data.application, logService);
        const userConfiguration = this.parseConfigurationModel(data.user, logService);
        const workspaceConfiguration = this.parseConfigurationModel(data.workspace, logService);
        const folders = data.folders.reduce((result, value) => {
            result.set(_base_common_uri_js__WEBPACK_IMPORTED_MODULE_7__.URI.revive(value[0]), this.parseConfigurationModel(value[1], logService));
            return result;
        }, ( new _base_common_map_js__WEBPACK_IMPORTED_MODULE_4__.ResourceMap()));
        return ( new Configuration(
            defaultConfiguration,
            policyConfiguration,
            applicationConfiguration,
            userConfiguration,
            ConfigurationModel.createEmptyModel(logService),
            workspaceConfiguration,
            folders,
            ConfigurationModel.createEmptyModel(logService),
            ( new _base_common_map_js__WEBPACK_IMPORTED_MODULE_4__.ResourceMap()),
            logService
        ));
    }
    static parseConfigurationModel(model, logService) {
        return ( new ConfigurationModel(model.contents, model.keys, model.overrides, undefined, logService));
    }
};
function mergeChanges(...changes) {
    if (changes.length === 0) {
        return { keys: [], overrides: [] };
    }
    if (changes.length === 1) {
        return changes[0];
    }
    const keysSet = ( new Set());
    const overridesMap = ( new Map());
    for (const change of changes) {
        change.keys.forEach(key => keysSet.add(key));
        change.overrides.forEach(([identifier, keys]) => {
            const result = (0,_base_common_map_js__WEBPACK_IMPORTED_MODULE_4__.getOrSet)(overridesMap, identifier, ( new Set()));
            keys.forEach(key => result.add(key));
        });
    }
    const overrides = [];
    overridesMap.forEach((keys, identifier) => overrides.push([identifier, [...( keys.values())]]));
    return { keys: [...( keysSet.values())], overrides };
}
class ConfigurationChangeEvent {
    constructor(change, previous, currentConfiguraiton, currentWorkspace, logService) {
        this.change = change;
        this.previous = previous;
        this.currentConfiguraiton = currentConfiguraiton;
        this.currentWorkspace = currentWorkspace;
        this.logService = logService;
        this._marker = '\n';
        this._markerCode1 = this._marker.charCodeAt(0);
        this._markerCode2 = '.'.charCodeAt(0);
        this.affectedKeys = ( new Set());
        this._previousConfiguration = undefined;
        for (const key of change.keys) {
            this.affectedKeys.add(key);
        }
        for (const [, keys] of change.overrides) {
            for (const key of keys) {
                this.affectedKeys.add(key);
            }
        }
        this._affectsConfigStr = this._marker;
        for (const key of this.affectedKeys) {
            this._affectsConfigStr += key + this._marker;
        }
    }
    get previousConfiguration() {
        if (!this._previousConfiguration && this.previous) {
            this._previousConfiguration = Configuration$1.parse(this.previous.data, this.logService);
        }
        return this._previousConfiguration;
    }
    affectsConfiguration(section, overrides) {
        const needle = this._marker + section;
        const idx = this._affectsConfigStr.indexOf(needle);
        if (idx < 0) {
            return false;
        }
        const pos = idx + needle.length;
        if (pos >= this._affectsConfigStr.length) {
            return false;
        }
        const code = this._affectsConfigStr.charCodeAt(pos);
        if (code !== this._markerCode1 && code !== this._markerCode2) {
            return false;
        }
        if (overrides) {
            const value1 = this.previousConfiguration ? this.previousConfiguration.getValue(section, overrides, this.previous?.workspace) : undefined;
            const value2 = this.currentConfiguraiton.getValue(section, overrides, this.currentWorkspace);
            return !(0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.equals)(value1, value2);
        }
        return true;
    }
}
function compare(from, to) {
    const { added, removed, updated } = compareConfigurationContents(to?.rawConfiguration, from?.rawConfiguration);
    const overrides = [];
    const fromOverrideIdentifiers = from?.getAllOverrideIdentifiers() || [];
    const toOverrideIdentifiers = to?.getAllOverrideIdentifiers() || [];
    if (to) {
        const addedOverrideIdentifiers = toOverrideIdentifiers.filter(key => !fromOverrideIdentifiers.includes(key));
        for (const identifier of addedOverrideIdentifiers) {
            overrides.push([identifier, to.getKeysForOverrideIdentifier(identifier)]);
        }
    }
    if (from) {
        const removedOverrideIdentifiers = fromOverrideIdentifiers.filter(key => !toOverrideIdentifiers.includes(key));
        for (const identifier of removedOverrideIdentifiers) {
            overrides.push([identifier, from.getKeysForOverrideIdentifier(identifier)]);
        }
    }
    if (to && from) {
        for (const identifier of fromOverrideIdentifiers) {
            if (toOverrideIdentifiers.includes(identifier)) {
                const result = compareConfigurationContents({ contents: from.getOverrideValue(undefined, identifier) || {}, keys: from.getKeysForOverrideIdentifier(identifier) }, { contents: to.getOverrideValue(undefined, identifier) || {}, keys: to.getKeysForOverrideIdentifier(identifier) });
                overrides.push([identifier, [...result.added, ...result.removed, ...result.updated]]);
            }
        }
    }
    return { added, removed, updated, overrides };
}
function compareConfigurationContents(to, from) {
    const added = to
        ? from ? to.keys.filter(key => from.keys.indexOf(key) === -1) : [...to.keys]
        : [];
    const removed = from
        ? to ? from.keys.filter(key => to.keys.indexOf(key) === -1) : [...from.keys]
        : [];
    const updated = [];
    if (to && from) {
        for (const key of from.keys) {
            if (to.keys.indexOf(key) !== -1) {
                const value1 = (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.getConfigurationValue)(from.contents, key);
                const value2 = (0,_configuration_js__WEBPACK_IMPORTED_MODULE_8__.getConfigurationValue)(to.contents, key);
                if (!(0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_5__.equals)(value1, value2)) {
                    updated.push(key);
                }
            }
        }
    }
    return { added, removed, updated };
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/platform/configuration/common/configurationRegistry.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/platform/configuration/common/configurationRegistry.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfigurationScope: () => (/* binding */ ConfigurationScope),
/* harmony export */   EditPresentationTypes: () => (/* binding */ EditPresentationTypes),
/* harmony export */   Extensions: () => (/* binding */ Extensions),
/* harmony export */   OVERRIDE_PROPERTY_PATTERN: () => (/* binding */ OVERRIDE_PROPERTY_PATTERN),
/* harmony export */   OVERRIDE_PROPERTY_REGEX: () => (/* binding */ OVERRIDE_PROPERTY_REGEX),
/* harmony export */   allSettings: () => (/* binding */ allSettings),
/* harmony export */   applicationSettings: () => (/* binding */ applicationSettings),
/* harmony export */   configurationDefaultsSchemaId: () => (/* binding */ configurationDefaultsSchemaId),
/* harmony export */   getDefaultValue: () => (/* binding */ getDefaultValue),
/* harmony export */   getScopes: () => (/* binding */ getScopes),
/* harmony export */   keyFromOverrideIdentifiers: () => (/* binding */ keyFromOverrideIdentifiers),
/* harmony export */   machineOverridableSettings: () => (/* binding */ machineOverridableSettings),
/* harmony export */   machineSettings: () => (/* binding */ machineSettings),
/* harmony export */   overrideIdentifiersFromKey: () => (/* binding */ overrideIdentifiersFromKey),
/* harmony export */   resourceLanguageSettingsSchemaId: () => (/* binding */ resourceLanguageSettingsSchemaId),
/* harmony export */   resourceSettings: () => (/* binding */ resourceSettings),
/* harmony export */   validateProperty: () => (/* binding */ validateProperty),
/* harmony export */   windowSettings: () => (/* binding */ windowSettings)
/* harmony export */ });
/* harmony import */ var _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _base_common_event_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _base_common_types_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../base/common/types.js */ "./node_modules/vscode/vscode/src/vs/base/common/types.js");
/* harmony import */ var _nls_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../nls.js */ "./node_modules/vscode/vscode/src/vs/nls.js");
/* harmony import */ var _configuration_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./configuration.js */ "./node_modules/vscode/vscode/src/vs/platform/configuration/common/configuration.js");
/* harmony import */ var _jsonschemas_common_jsonContributionRegistry_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../jsonschemas/common/jsonContributionRegistry.js */ "./node_modules/vscode/vscode/src/vs/platform/jsonschemas/common/jsonContributionRegistry.js");
/* harmony import */ var _registry_common_platform_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../registry/common/platform.js */ "./node_modules/vscode/vscode/src/vs/platform/registry/common/platform.js");







const _moduleId = "vs/platform/configuration/common/configurationRegistry";
var EditPresentationTypes;
( ((function(EditPresentationTypes) {
    EditPresentationTypes["Multiline"] = "multilineText";
    EditPresentationTypes["Singleline"] = "singlelineText";
})(EditPresentationTypes || (EditPresentationTypes = {}))));
const Extensions = {
    Configuration: 'base.contributions.configuration'
};
var ConfigurationScope;
( ((function(ConfigurationScope) {
    ConfigurationScope[ConfigurationScope["APPLICATION"] = 1] = "APPLICATION";
    ConfigurationScope[ConfigurationScope["MACHINE"] = 2] = "MACHINE";
    ConfigurationScope[ConfigurationScope["WINDOW"] = 3] = "WINDOW";
    ConfigurationScope[ConfigurationScope["RESOURCE"] = 4] = "RESOURCE";
    ConfigurationScope[ConfigurationScope["LANGUAGE_OVERRIDABLE"] = 5] = "LANGUAGE_OVERRIDABLE";
    ConfigurationScope[ConfigurationScope["MACHINE_OVERRIDABLE"] = 6] = "MACHINE_OVERRIDABLE";
})(ConfigurationScope || (ConfigurationScope = {}))));
const allSettings = { properties: {}, patternProperties: {} };
const applicationSettings = { properties: {}, patternProperties: {} };
const machineSettings = { properties: {}, patternProperties: {} };
const machineOverridableSettings = { properties: {}, patternProperties: {} };
const windowSettings = { properties: {}, patternProperties: {} };
const resourceSettings = { properties: {}, patternProperties: {} };
const resourceLanguageSettingsSchemaId = 'vscode://schemas/settings/resourceLanguage';
const configurationDefaultsSchemaId = 'vscode://schemas/settings/configurationDefaults';
const contributionRegistry = ( (_registry_common_platform_js__WEBPACK_IMPORTED_MODULE_6__.Registry.as(_jsonschemas_common_jsonContributionRegistry_js__WEBPACK_IMPORTED_MODULE_5__.Extensions.JSONContribution)));
class ConfigurationRegistry {
    constructor() {
        this.overrideIdentifiers = ( (new Set()));
        this._onDidSchemaChange = ( (new _base_common_event_js__WEBPACK_IMPORTED_MODULE_1__.Emitter()));
        this.onDidSchemaChange = this._onDidSchemaChange.event;
        this._onDidUpdateConfiguration = ( (new _base_common_event_js__WEBPACK_IMPORTED_MODULE_1__.Emitter()));
        this.onDidUpdateConfiguration = this._onDidUpdateConfiguration.event;
        this.configurationDefaultsOverrides = ( (new Map()));
        this.defaultLanguageConfigurationOverridesNode = {
            id: 'defaultOverrides',
            title: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(_moduleId, 0, "Default Language Configuration Overrides")),
            properties: {}
        };
        this.configurationContributors = [this.defaultLanguageConfigurationOverridesNode];
        this.resourceLanguageSettingsSchema = {
            properties: {},
            patternProperties: {},
            additionalProperties: true,
            allowTrailingCommas: true,
            allowComments: true
        };
        this.configurationProperties = {};
        this.policyConfigurations = ( (new Map()));
        this.excludedConfigurationProperties = {};
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this.registerOverridePropertyPatternKey();
    }
    registerConfiguration(configuration, validate = true) {
        this.registerConfigurations([configuration], validate);
    }
    registerConfigurations(configurations, validate = true) {
        const properties = ( (new Set()));
        this.doRegisterConfigurations(configurations, validate, properties);
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties });
    }
    deregisterConfigurations(configurations) {
        const properties = ( (new Set()));
        this.doDeregisterConfigurations(configurations, properties);
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties });
    }
    updateConfigurations({ add, remove }) {
        const properties = ( (new Set()));
        this.doDeregisterConfigurations(remove, properties);
        this.doRegisterConfigurations(add, false, properties);
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties });
    }
    registerDefaultConfigurations(configurationDefaults) {
        const properties = ( (new Set()));
        this.doRegisterDefaultConfigurations(configurationDefaults, properties);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties, defaultsOverrides: true });
    }
    doRegisterDefaultConfigurations(configurationDefaults, bucket) {
        const overrideIdentifiers = [];
        for (const { overrides, source } of configurationDefaults) {
            for (const key in overrides) {
                bucket.add(key);
                if (OVERRIDE_PROPERTY_REGEX.test(key)) {
                    const configurationDefaultOverride = this.configurationDefaultsOverrides.get(key);
                    const valuesSources = configurationDefaultOverride?.valuesSources ?? ( (new Map()));
                    const defaultValue = configurationDefaultOverride?.value || {};
                    for (const configuration of ( (Object.keys(overrides[key])))) {
                        const overrideValue = overrides[key][configuration];
                        const isObjectSetting = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(overrideValue) && ((0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(defaultValue[configuration]) || (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(defaultValue[configuration]));
                        if (isObjectSetting) {
                            defaultValue[configuration] = { ...(defaultValue[configuration] ?? {}), ...overrideValue };
                            if (source) {
                                let objectConfigurationSources = valuesSources.get(configuration);
                                if (!objectConfigurationSources) {
                                    objectConfigurationSources = ( (new Map()));
                                    valuesSources.set(configuration, objectConfigurationSources);
                                }
                                if (!(objectConfigurationSources instanceof Map)) {
                                    console.error('objectConfigurationSources is not a Map');
                                    continue;
                                }
                                for (const objectKey in overrideValue) {
                                    objectConfigurationSources.set(objectKey, source);
                                }
                            }
                        }
                        else {
                            defaultValue[configuration] = overrideValue;
                            if (source) {
                                valuesSources.set(configuration, source);
                            }
                        }
                    }
                    this.configurationDefaultsOverrides.set(key, { source, value: defaultValue, valuesSources });
                    const plainKey = (0,_configuration_js__WEBPACK_IMPORTED_MODULE_4__.getLanguageTagSettingPlainKey)(key);
                    const property = {
                        type: 'object',
                        default: defaultValue,
                        description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(
                            _moduleId,
                            1,
                            "Configure settings to be overridden for the {0} language.",
                            plainKey
                        )),
                        $ref: resourceLanguageSettingsSchemaId,
                        defaultDefaultValue: defaultValue,
                        source: (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isString)(source) ? undefined : source,
                        defaultValueSource: source
                    };
                    overrideIdentifiers.push(...overrideIdentifiersFromKey(key));
                    this.configurationProperties[key] = property;
                    this.defaultLanguageConfigurationOverridesNode.properties[key] = property;
                }
                else {
                    const property = this.configurationProperties[key];
                    const existingDefaultOverride = this.configurationDefaultsOverrides.get(key);
                    let existingDefaultValue = existingDefaultOverride?.value ?? property?.defaultDefaultValue;
                    let newDefaultValue = overrides[key];
                    let newDefaultValueSource = source;
                    const isObjectSetting = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(newDefaultValue) && (property !== undefined && property.type === 'object' ||
                        property === undefined && ((0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(existingDefaultValue) || (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(existingDefaultValue)));
                    if (isObjectSetting) {
                        if (!(0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(existingDefaultValue)) {
                            existingDefaultValue = {};
                        }
                        newDefaultValue = { ...existingDefaultValue, ...newDefaultValue };
                        newDefaultValueSource = existingDefaultOverride?.source ?? ( (new Map()));
                        if (!(newDefaultValueSource instanceof Map)) {
                            console.error('defaultValueSource is not a Map');
                            continue;
                        }
                        for (const overrideObjectKey in overrides[key]) {
                            if (source) {
                                newDefaultValueSource.set(overrideObjectKey, source);
                            }
                            else {
                                newDefaultValueSource.delete(overrideObjectKey);
                            }
                        }
                    }
                    this.configurationDefaultsOverrides.set(key, { value: newDefaultValue, source: newDefaultValueSource });
                    if (property) {
                        this.updatePropertyDefaultValue(key, property);
                        this.updateSchema(key, property);
                    }
                }
            }
        }
        this.doRegisterOverrideIdentifiers(overrideIdentifiers);
    }
    deregisterDefaultConfigurations(defaultConfigurations) {
        const properties = ( (new Set()));
        this.doDeregisterDefaultConfigurations(defaultConfigurations, properties);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties, defaultsOverrides: true });
    }
    doDeregisterDefaultConfigurations(defaultConfigurations, bucket) {
        for (const { overrides, source } of defaultConfigurations) {
            for (const key in overrides) {
                const id = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isString)(source) ? source : source?.id;
                const configurationDefaultsOverride = this.configurationDefaultsOverrides.get(key);
                if (!configurationDefaultsOverride) {
                    continue;
                }
                if (OVERRIDE_PROPERTY_REGEX.test(key)) {
                    for (const configuration of ( (Object.keys(overrides[key])))) {
                        const overrideValue = overrides[key][configuration];
                        if ((0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(overrideValue)) {
                            const configurationSource = configurationDefaultsOverride.valuesSources?.get(configuration);
                            for (const overrideObjectKey of ( (Object.keys(overrideValue)))) {
                                const keySource = configurationSource?.get(overrideObjectKey);
                                const keySourceId = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isString)(keySource) ? keySource : keySource?.id;
                                if (keySourceId === id) {
                                    configurationSource?.delete(overrideObjectKey);
                                    delete configurationDefaultsOverride.value[configuration][overrideObjectKey];
                                }
                            }
                            if (( (Object.keys(configurationDefaultsOverride.value[configuration]))).length === 0) {
                                delete configurationDefaultsOverride.value[configuration];
                                configurationDefaultsOverride.valuesSources?.delete(configuration);
                            }
                        }
                        else {
                            const configurationSource = configurationDefaultsOverride.valuesSources?.get(configuration);
                            const keySourceId = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isString)(configurationSource) ? configurationSource : configurationSource?.id;
                            if (keySourceId === id) {
                                configurationDefaultsOverride.valuesSources?.delete(configuration);
                                delete configurationDefaultsOverride.value[configuration];
                            }
                        }
                    }
                    const languageValues = this.configurationDefaultsOverrides.get(key);
                    if (languageValues && ( (Object.keys(languageValues.value))).length === 0) {
                        this.configurationDefaultsOverrides.delete(key);
                        delete this.configurationProperties[key];
                        delete this.defaultLanguageConfigurationOverridesNode.properties[key];
                    }
                }
                else {
                    if (configurationDefaultsOverride.source instanceof Map) {
                        const keySources = configurationDefaultsOverride.source;
                        for (const objectKey in overrides[key]) {
                            const keySource = keySources.get(objectKey);
                            const keySourceId = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isString)(keySource) ? keySource : keySource?.id;
                            if (keySourceId === id) {
                                keySources.delete(objectKey);
                                delete configurationDefaultsOverride.value[objectKey];
                            }
                        }
                        if (keySources.size === 0) {
                            this.configurationDefaultsOverrides.delete(key);
                        }
                    }
                    else {
                        const configurationDefaultsOverrideSourceId = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isString)(configurationDefaultsOverride.source) ? configurationDefaultsOverride.source : configurationDefaultsOverride.source?.id;
                        if (id !== configurationDefaultsOverrideSourceId) {
                            continue;
                        }
                        this.configurationDefaultsOverrides.delete(key);
                    }
                    const property = this.configurationProperties[key];
                    if (property) {
                        this.updatePropertyDefaultValue(key, property);
                        this.updateSchema(key, property);
                    }
                }
                bucket.add(key);
            }
        }
        this.updateOverridePropertyPatternKey();
    }
    deltaConfiguration(delta) {
        let defaultsOverrides = false;
        const properties = ( (new Set()));
        if (delta.removedDefaults) {
            this.doDeregisterDefaultConfigurations(delta.removedDefaults, properties);
            defaultsOverrides = true;
        }
        if (delta.addedDefaults) {
            this.doRegisterDefaultConfigurations(delta.addedDefaults, properties);
            defaultsOverrides = true;
        }
        if (delta.removedConfigurations) {
            this.doDeregisterConfigurations(delta.removedConfigurations, properties);
        }
        if (delta.addedConfigurations) {
            this.doRegisterConfigurations(delta.addedConfigurations, false, properties);
        }
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire({ properties, defaultsOverrides });
    }
    notifyConfigurationSchemaUpdated(...configurations) {
        this._onDidSchemaChange.fire();
    }
    registerOverrideIdentifiers(overrideIdentifiers) {
        this.doRegisterOverrideIdentifiers(overrideIdentifiers);
        this._onDidSchemaChange.fire();
    }
    doRegisterOverrideIdentifiers(overrideIdentifiers) {
        for (const overrideIdentifier of overrideIdentifiers) {
            this.overrideIdentifiers.add(overrideIdentifier);
        }
        this.updateOverridePropertyPatternKey();
    }
    doRegisterConfigurations(configurations, validate, bucket) {
        configurations.forEach(configuration => {
            this.validateAndRegisterProperties(configuration, validate, configuration.extensionInfo, configuration.restrictedProperties, undefined, bucket);
            this.configurationContributors.push(configuration);
            this.registerJSONConfiguration(configuration);
        });
    }
    doDeregisterConfigurations(configurations, bucket) {
        const deregisterConfiguration = (configuration) => {
            if (configuration.properties) {
                for (const key in configuration.properties) {
                    bucket.add(key);
                    const property = this.configurationProperties[key];
                    if (property?.policy?.name) {
                        this.policyConfigurations.delete(property.policy.name);
                    }
                    delete this.configurationProperties[key];
                    this.removeFromSchema(key, configuration.properties[key]);
                }
            }
            configuration.allOf?.forEach(node => deregisterConfiguration(node));
        };
        for (const configuration of configurations) {
            deregisterConfiguration(configuration);
            const index = this.configurationContributors.indexOf(configuration);
            if (index !== -1) {
                this.configurationContributors.splice(index, 1);
            }
        }
    }
    validateAndRegisterProperties(configuration, validate = true, extensionInfo, restrictedProperties, scope = ConfigurationScope.WINDOW, bucket) {
        scope = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isUndefinedOrNull)(configuration.scope) ? scope : configuration.scope;
        const properties = configuration.properties;
        if (properties) {
            for (const key in properties) {
                const property = properties[key];
                if (validate && validateProperty(key, property)) {
                    delete properties[key];
                    continue;
                }
                property.source = extensionInfo;
                property.defaultDefaultValue = properties[key].default;
                this.updatePropertyDefaultValue(key, property);
                if (OVERRIDE_PROPERTY_REGEX.test(key)) {
                    property.scope = undefined;
                }
                else {
                    property.scope = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isUndefinedOrNull)(property.scope) ? scope : property.scope;
                    property.restricted = (0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isUndefinedOrNull)(property.restricted) ? !!restrictedProperties?.includes(key) : property.restricted;
                }
                if (properties[key].hasOwnProperty('included') && !properties[key].included) {
                    this.excludedConfigurationProperties[key] = properties[key];
                    delete properties[key];
                    continue;
                }
                else {
                    this.configurationProperties[key] = properties[key];
                    if (properties[key].policy?.name) {
                        this.policyConfigurations.set(properties[key].policy.name, key);
                    }
                }
                if (!properties[key].deprecationMessage && properties[key].markdownDeprecationMessage) {
                    properties[key].deprecationMessage = properties[key].markdownDeprecationMessage;
                }
                bucket.add(key);
            }
        }
        const subNodes = configuration.allOf;
        if (subNodes) {
            for (const node of subNodes) {
                this.validateAndRegisterProperties(node, validate, extensionInfo, restrictedProperties, scope, bucket);
            }
        }
    }
    getConfigurations() {
        return this.configurationContributors;
    }
    getConfigurationProperties() {
        return this.configurationProperties;
    }
    getPolicyConfigurations() {
        return this.policyConfigurations;
    }
    getExcludedConfigurationProperties() {
        return this.excludedConfigurationProperties;
    }
    getConfigurationDefaultsOverrides() {
        return this.configurationDefaultsOverrides;
    }
    registerJSONConfiguration(configuration) {
        const register = (configuration) => {
            const properties = configuration.properties;
            if (properties) {
                for (const key in properties) {
                    this.updateSchema(key, properties[key]);
                }
            }
            const subNodes = configuration.allOf;
            subNodes?.forEach(register);
        };
        register(configuration);
    }
    updateSchema(key, property) {
        allSettings.properties[key] = property;
        switch (property.scope) {
            case ConfigurationScope.APPLICATION:
                applicationSettings.properties[key] = property;
                break;
            case ConfigurationScope.MACHINE:
                machineSettings.properties[key] = property;
                break;
            case ConfigurationScope.MACHINE_OVERRIDABLE:
                machineOverridableSettings.properties[key] = property;
                break;
            case ConfigurationScope.WINDOW:
                windowSettings.properties[key] = property;
                break;
            case ConfigurationScope.RESOURCE:
                resourceSettings.properties[key] = property;
                break;
            case ConfigurationScope.LANGUAGE_OVERRIDABLE:
                resourceSettings.properties[key] = property;
                this.resourceLanguageSettingsSchema.properties[key] = property;
                break;
        }
    }
    removeFromSchema(key, property) {
        delete allSettings.properties[key];
        switch (property.scope) {
            case ConfigurationScope.APPLICATION:
                delete applicationSettings.properties[key];
                break;
            case ConfigurationScope.MACHINE:
                delete machineSettings.properties[key];
                break;
            case ConfigurationScope.MACHINE_OVERRIDABLE:
                delete machineOverridableSettings.properties[key];
                break;
            case ConfigurationScope.WINDOW:
                delete windowSettings.properties[key];
                break;
            case ConfigurationScope.RESOURCE:
            case ConfigurationScope.LANGUAGE_OVERRIDABLE:
                delete resourceSettings.properties[key];
                delete this.resourceLanguageSettingsSchema.properties[key];
                break;
        }
    }
    updateOverridePropertyPatternKey() {
        for (const overrideIdentifier of ( (this.overrideIdentifiers.values()))) {
            const overrideIdentifierProperty = `[${overrideIdentifier}]`;
            const resourceLanguagePropertiesSchema = {
                type: 'object',
                description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(_moduleId, 2, "Configure editor settings to be overridden for a language.")),
                errorMessage: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(_moduleId, 3, "This setting does not support per-language configuration.")),
                $ref: resourceLanguageSettingsSchemaId,
            };
            this.updatePropertyDefaultValue(overrideIdentifierProperty, resourceLanguagePropertiesSchema);
            allSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
            applicationSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
            machineSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
            machineOverridableSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
            windowSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
            resourceSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
        }
    }
    registerOverridePropertyPatternKey() {
        const resourceLanguagePropertiesSchema = {
            type: 'object',
            description: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(_moduleId, 2, "Configure editor settings to be overridden for a language.")),
            errorMessage: ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(_moduleId, 3, "This setting does not support per-language configuration.")),
            $ref: resourceLanguageSettingsSchemaId,
        };
        allSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        applicationSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        machineSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        machineOverridableSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        windowSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        resourceSettings.patternProperties[OVERRIDE_PROPERTY_PATTERN] = resourceLanguagePropertiesSchema;
        this._onDidSchemaChange.fire();
    }
    updatePropertyDefaultValue(key, property) {
        const configurationdefaultOverride = this.configurationDefaultsOverrides.get(key);
        let defaultValue = configurationdefaultOverride?.value;
        let defaultSource = configurationdefaultOverride?.source;
        if ((0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(defaultValue)) {
            defaultValue = property.defaultDefaultValue;
            defaultSource = undefined;
        }
        if ((0,_base_common_types_js__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(defaultValue)) {
            defaultValue = getDefaultValue(property.type);
        }
        property.default = defaultValue;
        property.defaultValueSource = defaultSource;
    }
}
const OVERRIDE_IDENTIFIER_PATTERN = `\\[([^\\]]+)\\]`;
const OVERRIDE_IDENTIFIER_REGEX = ( (new RegExp(OVERRIDE_IDENTIFIER_PATTERN, 'g')));
const OVERRIDE_PROPERTY_PATTERN = `^(${OVERRIDE_IDENTIFIER_PATTERN})+$`;
const OVERRIDE_PROPERTY_REGEX = ( (new RegExp(OVERRIDE_PROPERTY_PATTERN)));
function overrideIdentifiersFromKey(key) {
    const identifiers = [];
    if (OVERRIDE_PROPERTY_REGEX.test(key)) {
        let matches = OVERRIDE_IDENTIFIER_REGEX.exec(key);
        while (matches?.length) {
            const identifier = matches[1].trim();
            if (identifier) {
                identifiers.push(identifier);
            }
            matches = OVERRIDE_IDENTIFIER_REGEX.exec(key);
        }
    }
    return (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.distinct)(identifiers);
}
function keyFromOverrideIdentifiers(overrideIdentifiers) {
    return overrideIdentifiers.reduce((result, overrideIdentifier) => `${result}[${overrideIdentifier}]`, '');
}
function getDefaultValue(type) {
    const t = Array.isArray(type) ? type[0] : type;
    switch (t) {
        case 'boolean':
            return false;
        case 'integer':
        case 'number':
            return 0;
        case 'string':
            return '';
        case 'array':
            return [];
        case 'object':
            return {};
        default:
            return null;
    }
}
const configurationRegistry = ( (new ConfigurationRegistry()));
_registry_common_platform_js__WEBPACK_IMPORTED_MODULE_6__.Registry.add(Extensions.Configuration, configurationRegistry);
function validateProperty(property, schema) {
    if (!property.trim()) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(_moduleId, 4, "Cannot register an empty property"));
    }
    if (OVERRIDE_PROPERTY_REGEX.test(property)) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(
            _moduleId,
            5,
            "Cannot register '{0}'. This matches property pattern '\\\\[.*\\\\]$' for describing language specific editor settings. Use 'configurationDefaults' contribution.",
            property
        ));
    }
    if (configurationRegistry.getConfigurationProperties()[property] !== undefined) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(
            _moduleId,
            6,
            "Cannot register '{0}'. This property is already registered.",
            property
        ));
    }
    if (schema.policy?.name && configurationRegistry.getPolicyConfigurations().get(schema.policy?.name) !== undefined) {
        return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_3__.localizeWithPath)(
            _moduleId,
            7,
            "Cannot register '{0}'. The associated policy {1} is already registered with {2}.",
            property,
            schema.policy?.name,
            configurationRegistry.getPolicyConfigurations().get(schema.policy?.name)
        ));
    }
    return null;
}
function getScopes() {
    const scopes = [];
    const configurationProperties = configurationRegistry.getConfigurationProperties();
    for (const key of ( (Object.keys(configurationProperties)))) {
        scopes.push([key, configurationProperties[key].scope]);
    }
    scopes.push(['launch', ConfigurationScope.RESOURCE]);
    scopes.push(['task', ConfigurationScope.RESOURCE]);
    return scopes;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/platform/contextkey/common/contextkey.js":
/*!************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/platform/contextkey/common/contextkey.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ContextKeyAndExpr: () => (/* binding */ ContextKeyAndExpr),
/* harmony export */   ContextKeyDefinedExpr: () => (/* binding */ ContextKeyDefinedExpr),
/* harmony export */   ContextKeyEqualsExpr: () => (/* binding */ ContextKeyEqualsExpr),
/* harmony export */   ContextKeyExpr: () => (/* binding */ ContextKeyExpr),
/* harmony export */   ContextKeyExprType: () => (/* binding */ ContextKeyExprType),
/* harmony export */   ContextKeyFalseExpr: () => (/* binding */ ContextKeyFalseExpr),
/* harmony export */   ContextKeyGreaterEqualsExpr: () => (/* binding */ ContextKeyGreaterEqualsExpr),
/* harmony export */   ContextKeyGreaterExpr: () => (/* binding */ ContextKeyGreaterExpr),
/* harmony export */   ContextKeyInExpr: () => (/* binding */ ContextKeyInExpr),
/* harmony export */   ContextKeyNotEqualsExpr: () => (/* binding */ ContextKeyNotEqualsExpr),
/* harmony export */   ContextKeyNotExpr: () => (/* binding */ ContextKeyNotExpr),
/* harmony export */   ContextKeyNotInExpr: () => (/* binding */ ContextKeyNotInExpr),
/* harmony export */   ContextKeyNotRegexExpr: () => (/* binding */ ContextKeyNotRegexExpr),
/* harmony export */   ContextKeyOrExpr: () => (/* binding */ ContextKeyOrExpr),
/* harmony export */   ContextKeyRegexExpr: () => (/* binding */ ContextKeyRegexExpr),
/* harmony export */   ContextKeySmallerEqualsExpr: () => (/* binding */ ContextKeySmallerEqualsExpr),
/* harmony export */   ContextKeySmallerExpr: () => (/* binding */ ContextKeySmallerExpr),
/* harmony export */   ContextKeyTrueExpr: () => (/* binding */ ContextKeyTrueExpr),
/* harmony export */   Parser: () => (/* binding */ Parser),
/* harmony export */   RawContextKey: () => (/* binding */ RawContextKey),
/* harmony export */   expressionsAreEqualWithConstantSubstitution: () => (/* binding */ expressionsAreEqualWithConstantSubstitution),
/* harmony export */   implies: () => (/* binding */ implies),
/* harmony export */   setConstant: () => (/* binding */ setConstant),
/* harmony export */   validateWhenClauses: () => (/* binding */ validateWhenClauses)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../base/common/strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _scanner_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./scanner.js */ "./node_modules/vscode/vscode/src/vs/platform/contextkey/common/scanner.js");
/* harmony import */ var _nls_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../nls.js */ "./node_modules/vscode/vscode/src/vs/nls.js");
/* harmony import */ var _base_common_errors_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../base/common/errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");






const _moduleId = "vs/platform/contextkey/common/contextkey";
const CONSTANT_VALUES = ( (new Map()));
CONSTANT_VALUES.set('false', false);
CONSTANT_VALUES.set('true', true);
CONSTANT_VALUES.set('isMac', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isMacintosh);
CONSTANT_VALUES.set('isLinux', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isLinux);
CONSTANT_VALUES.set('isWindows', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isWindows);
CONSTANT_VALUES.set('isWeb', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isWeb);
CONSTANT_VALUES.set('isMacNative', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isMacintosh && !_base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isWeb);
CONSTANT_VALUES.set('isEdge', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isEdge);
CONSTANT_VALUES.set('isFirefox', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isFirefox);
CONSTANT_VALUES.set('isChrome', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isChrome);
CONSTANT_VALUES.set('isSafari', _base_common_platform_js__WEBPACK_IMPORTED_MODULE_1__.isSafari);
function setConstant(key, value) {
    if (CONSTANT_VALUES.get(key) !== undefined) {
        throw (0,_base_common_errors_js__WEBPACK_IMPORTED_MODULE_5__.illegalArgument)('contextkey.setConstant(k, v) invoked with already set constant `k`');
    }
    CONSTANT_VALUES.set(key, value);
}
const hasOwnProperty = Object.prototype.hasOwnProperty;
var ContextKeyExprType;
( ((function(ContextKeyExprType) {
    ContextKeyExprType[ContextKeyExprType["False"] = 0] = "False";
    ContextKeyExprType[ContextKeyExprType["True"] = 1] = "True";
    ContextKeyExprType[ContextKeyExprType["Defined"] = 2] = "Defined";
    ContextKeyExprType[ContextKeyExprType["Not"] = 3] = "Not";
    ContextKeyExprType[ContextKeyExprType["Equals"] = 4] = "Equals";
    ContextKeyExprType[ContextKeyExprType["NotEquals"] = 5] = "NotEquals";
    ContextKeyExprType[ContextKeyExprType["And"] = 6] = "And";
    ContextKeyExprType[ContextKeyExprType["Regex"] = 7] = "Regex";
    ContextKeyExprType[ContextKeyExprType["NotRegex"] = 8] = "NotRegex";
    ContextKeyExprType[ContextKeyExprType["Or"] = 9] = "Or";
    ContextKeyExprType[ContextKeyExprType["In"] = 10] = "In";
    ContextKeyExprType[ContextKeyExprType["NotIn"] = 11] = "NotIn";
    ContextKeyExprType[ContextKeyExprType["Greater"] = 12] = "Greater";
    ContextKeyExprType[ContextKeyExprType["GreaterEquals"] = 13] = "GreaterEquals";
    ContextKeyExprType[ContextKeyExprType["Smaller"] = 14] = "Smaller";
    ContextKeyExprType[ContextKeyExprType["SmallerEquals"] = 15] = "SmallerEquals";
})(ContextKeyExprType || (ContextKeyExprType = {}))));
const defaultConfig = {
    regexParsingWithErrorRecovery: true
};
const errorEmptyString = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 0, "Empty context key expression"));
const hintEmptyString = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(
    _moduleId,
    1,
    "Did you forget to write an expression? You can also put 'false' or 'true' to always evaluate to false or true, respectively."
));
const errorNoInAfterNot = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 2, "'in' after 'not'."));
const errorClosingParenthesis = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 3, "closing parenthesis ')'"));
const errorUnexpectedToken = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 4, "Unexpected token"));
const hintUnexpectedToken = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 5, "Did you forget to put && or || before the token?"));
const errorUnexpectedEOF = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 6, "Unexpected end of expression"));
const hintUnexpectedEOF = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 7, "Did you forget to put a context key?"));
class Parser {
    static { this._parseError = ( (new Error())); }
    get lexingErrors() {
        return this._scanner.errors;
    }
    get parsingErrors() {
        return this._parsingErrors;
    }
    constructor(_config = defaultConfig) {
        this._config = _config;
        this._scanner = ( (new _scanner_js__WEBPACK_IMPORTED_MODULE_3__.Scanner()));
        this._tokens = [];
        this._current = 0;
        this._parsingErrors = [];
        this._flagsGYRe = /g|y/g;
    }
    parse(input) {
        if (input === '') {
            this._parsingErrors.push({ message: errorEmptyString, offset: 0, lexeme: '', additionalInfo: hintEmptyString });
            return undefined;
        }
        this._tokens = this._scanner.reset(input).scan();
        this._current = 0;
        this._parsingErrors = [];
        try {
            const expr = this._expr();
            if (!this._isAtEnd()) {
                const peek = this._peek();
                const additionalInfo = peek.type === _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Str ? hintUnexpectedToken : undefined;
                this._parsingErrors.push({ message: errorUnexpectedToken, offset: peek.offset, lexeme: _scanner_js__WEBPACK_IMPORTED_MODULE_3__.Scanner.getLexeme(peek), additionalInfo });
                throw Parser._parseError;
            }
            return expr;
        }
        catch (e) {
            if (!(e === Parser._parseError)) {
                throw e;
            }
            return undefined;
        }
    }
    _expr() {
        return this._or();
    }
    _or() {
        const expr = [this._and()];
        while (this._matchOne(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Or)) {
            const right = this._and();
            expr.push(right);
        }
        return expr.length === 1 ? expr[0] : ( (ContextKeyExpr.or(...expr)));
    }
    _and() {
        const expr = [this._term()];
        while (this._matchOne(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.And)) {
            const right = this._term();
            expr.push(right);
        }
        return expr.length === 1 ? expr[0] : ( (ContextKeyExpr.and(...expr)));
    }
    _term() {
        if (this._matchOne(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Neg)) {
            const peek = this._peek();
            switch (peek.type) {
                case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.True:
                    this._advance();
                    return ContextKeyFalseExpr.INSTANCE;
                case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.False:
                    this._advance();
                    return ContextKeyTrueExpr.INSTANCE;
                case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.LParen: {
                    this._advance();
                    const expr = this._expr();
                    this._consume(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.RParen, errorClosingParenthesis);
                    return expr?.negate();
                }
                case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Str:
                    this._advance();
                    return (
                         (ContextKeyNotExpr.create(peek.lexeme))
                    );
                default:
                    throw this._errExpectedButGot(`KEY | true | false | '(' expression ')'`, peek);
            }
        }
        return this._primary();
    }
    _primary() {
        const peek = this._peek();
        switch (peek.type) {
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.True:
                this._advance();
                return ContextKeyExpr.true();
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.False:
                this._advance();
                return (
                     (ContextKeyExpr.false())
                );
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.LParen: {
                this._advance();
                const expr = this._expr();
                this._consume(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.RParen, errorClosingParenthesis);
                return expr;
            }
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Str: {
                const key = peek.lexeme;
                this._advance();
                if (this._matchOne(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.RegexOp)) {
                    const expr = this._peek();
                    if (!this._config.regexParsingWithErrorRecovery) {
                        this._advance();
                        if (expr.type !== _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.RegexStr) {
                            throw this._errExpectedButGot(`REGEX`, expr);
                        }
                        const regexLexeme = expr.lexeme;
                        const closingSlashIndex = regexLexeme.lastIndexOf('/');
                        const flags = closingSlashIndex === regexLexeme.length - 1 ? undefined : this._removeFlagsGY(regexLexeme.substring(closingSlashIndex + 1));
                        let regexp;
                        try {
                            regexp = ( (new RegExp(regexLexeme.substring(1, closingSlashIndex), flags)));
                        }
                        catch (e) {
                            throw this._errExpectedButGot(`REGEX`, expr);
                        }
                        return ContextKeyRegexExpr.create(key, regexp);
                    }
                    switch (expr.type) {
                        case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.RegexStr:
                        case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Error: {
                            const lexemeReconstruction = [expr.lexeme];
                            this._advance();
                            let followingToken = this._peek();
                            let parenBalance = 0;
                            for (let i = 0; i < expr.lexeme.length; i++) {
                                if (expr.lexeme.charCodeAt(i) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.OpenParen) {
                                    parenBalance++;
                                }
                                else if (expr.lexeme.charCodeAt(i) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CloseParen) {
                                    parenBalance--;
                                }
                            }
                            while (!this._isAtEnd() && followingToken.type !== _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.And && followingToken.type !== _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Or) {
                                switch (followingToken.type) {
                                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.LParen:
                                        parenBalance++;
                                        break;
                                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.RParen:
                                        parenBalance--;
                                        break;
                                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.RegexStr:
                                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.QuotedStr:
                                        for (let i = 0; i < followingToken.lexeme.length; i++) {
                                            if (followingToken.lexeme.charCodeAt(i) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.OpenParen) {
                                                parenBalance++;
                                            }
                                            else if (expr.lexeme.charCodeAt(i) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.CloseParen) {
                                                parenBalance--;
                                            }
                                        }
                                }
                                if (parenBalance < 0) {
                                    break;
                                }
                                lexemeReconstruction.push(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.Scanner.getLexeme(followingToken));
                                this._advance();
                                followingToken = this._peek();
                            }
                            const regexLexeme = lexemeReconstruction.join('');
                            const closingSlashIndex = regexLexeme.lastIndexOf('/');
                            const flags = closingSlashIndex === regexLexeme.length - 1 ? undefined : this._removeFlagsGY(regexLexeme.substring(closingSlashIndex + 1));
                            let regexp;
                            try {
                                regexp = ( (new RegExp(regexLexeme.substring(1, closingSlashIndex), flags)));
                            }
                            catch (e) {
                                throw this._errExpectedButGot(`REGEX`, expr);
                            }
                            return (
                                 (ContextKeyExpr.regex(key, regexp))
                            );
                        }
                        case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.QuotedStr: {
                            const serializedValue = expr.lexeme;
                            this._advance();
                            let regex = null;
                            if (!(0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.isFalsyOrWhitespace)(serializedValue)) {
                                const start = serializedValue.indexOf('/');
                                const end = serializedValue.lastIndexOf('/');
                                if (start !== end && start >= 0) {
                                    const value = serializedValue.slice(start + 1, end);
                                    const caseIgnoreFlag = serializedValue[end + 1] === 'i' ? 'i' : '';
                                    try {
                                        regex = ( (new RegExp(value, caseIgnoreFlag)));
                                    }
                                    catch (_e) {
                                        throw this._errExpectedButGot(`REGEX`, expr);
                                    }
                                }
                            }
                            if (regex === null) {
                                throw this._errExpectedButGot('REGEX', expr);
                            }
                            return ContextKeyRegexExpr.create(key, regex);
                        }
                        default:
                            throw this._errExpectedButGot('REGEX', this._peek());
                    }
                }
                if (this._matchOne(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Not)) {
                    this._consume(_scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.In, errorNoInAfterNot);
                    const right = this._value();
                    return ContextKeyExpr.notIn(key, right);
                }
                const maybeOp = this._peek().type;
                switch (maybeOp) {
                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Eq: {
                        this._advance();
                        const right = this._value();
                        if (this._previous().type === _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.QuotedStr) {
                            return (
                                 (ContextKeyExpr.equals(key, right))
                            );
                        }
                        switch (right) {
                            case 'true':
                                return (
                                     (ContextKeyExpr.has(key))
                                );
                            case 'false':
                                return ContextKeyExpr.not(key);
                            default:
                                return (
                                     (ContextKeyExpr.equals(key, right))
                                );
                        }
                    }
                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.NotEq: {
                        this._advance();
                        const right = this._value();
                        if (this._previous().type === _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.QuotedStr) {
                            return (
                                 (ContextKeyExpr.notEquals(key, right))
                            );
                        }
                        switch (right) {
                            case 'true':
                                return ContextKeyExpr.not(key);
                            case 'false':
                                return (
                                     (ContextKeyExpr.has(key))
                                );
                            default:
                                return (
                                     (ContextKeyExpr.notEquals(key, right))
                                );
                        }
                    }
                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Lt:
                        this._advance();
                        return ContextKeySmallerExpr.create(key, this._value());
                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.LtEq:
                        this._advance();
                        return ContextKeySmallerEqualsExpr.create(key, this._value());
                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Gt:
                        this._advance();
                        return ContextKeyGreaterExpr.create(key, this._value());
                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.GtEq:
                        this._advance();
                        return ContextKeyGreaterEqualsExpr.create(key, this._value());
                    case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.In:
                        this._advance();
                        return ContextKeyExpr.in(key, this._value());
                    default:
                        return (
                             (ContextKeyExpr.has(key))
                        );
                }
            }
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.EOF:
                this._parsingErrors.push({ message: errorUnexpectedEOF, offset: peek.offset, lexeme: '', additionalInfo: hintUnexpectedEOF });
                throw Parser._parseError;
            default:
                throw this._errExpectedButGot(`true | false | KEY \n\t| KEY '=~' REGEX \n\t| KEY ('==' | '!=' | '<' | '<=' | '>' | '>=' | 'in' | 'not' 'in') value`, this._peek());
        }
    }
    _value() {
        const token = this._peek();
        switch (token.type) {
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.Str:
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.QuotedStr:
                this._advance();
                return token.lexeme;
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.True:
                this._advance();
                return 'true';
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.False:
                this._advance();
                return 'false';
            case _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.In:
                this._advance();
                return 'in';
            default:
                return '';
        }
    }
    _removeFlagsGY(flags) {
        return flags.replaceAll(this._flagsGYRe, '');
    }
    _previous() {
        return this._tokens[this._current - 1];
    }
    _matchOne(token) {
        if (this._check(token)) {
            this._advance();
            return true;
        }
        return false;
    }
    _advance() {
        if (!this._isAtEnd()) {
            this._current++;
        }
        return this._previous();
    }
    _consume(type, message) {
        if (this._check(type)) {
            return this._advance();
        }
        throw this._errExpectedButGot(message, this._peek());
    }
    _errExpectedButGot(expected, got, additionalInfo) {
        const message = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(
            _moduleId,
            8,
            "Expected: {0}\nReceived: '{1}'.",
            expected,
            _scanner_js__WEBPACK_IMPORTED_MODULE_3__.Scanner.getLexeme(got)
        ));
        const offset = got.offset;
        const lexeme = _scanner_js__WEBPACK_IMPORTED_MODULE_3__.Scanner.getLexeme(got);
        this._parsingErrors.push({ message, offset, lexeme, additionalInfo });
        return Parser._parseError;
    }
    _check(type) {
        return this._peek().type === type;
    }
    _peek() {
        return this._tokens[this._current];
    }
    _isAtEnd() {
        return this._peek().type === _scanner_js__WEBPACK_IMPORTED_MODULE_3__.TokenType.EOF;
    }
}
class ContextKeyExpr {
    static false() {
        return ContextKeyFalseExpr.INSTANCE;
    }
    static true() {
        return ContextKeyTrueExpr.INSTANCE;
    }
    static has(key) {
        return (
             (ContextKeyDefinedExpr.create(key))
        );
    }
    static equals(key, value) {
        return ContextKeyEqualsExpr.create(key, value);
    }
    static notEquals(key, value) {
        return ContextKeyNotEqualsExpr.create(key, value);
    }
    static regex(key, value) {
        return ContextKeyRegexExpr.create(key, value);
    }
    static in(key, value) {
        return ContextKeyInExpr.create(key, value);
    }
    static notIn(key, value) {
        return ContextKeyNotInExpr.create(key, value);
    }
    static not(key) {
        return (
             (ContextKeyNotExpr.create(key))
        );
    }
    static and(...expr) {
        return ContextKeyAndExpr.create(expr, null, true);
    }
    static or(...expr) {
        return ContextKeyOrExpr.create(expr, null, true);
    }
    static greater(key, value) {
        return ContextKeyGreaterExpr.create(key, value);
    }
    static greaterEquals(key, value) {
        return ContextKeyGreaterEqualsExpr.create(key, value);
    }
    static smaller(key, value) {
        return ContextKeySmallerExpr.create(key, value);
    }
    static smallerEquals(key, value) {
        return ContextKeySmallerEqualsExpr.create(key, value);
    }
    static { this._parser = ( (new Parser({ regexParsingWithErrorRecovery: false }))); }
    static deserialize(serialized) {
        if (serialized === undefined || serialized === null) {
            return undefined;
        }
        const expr = this._parser.parse(serialized);
        return expr;
    }
}
function validateWhenClauses(whenClauses) {
    const parser = ( (new Parser({ regexParsingWithErrorRecovery: false })));
    return (
         (whenClauses.map(whenClause => {
            parser.parse(whenClause);
            if (parser.lexingErrors.length > 0) {
                return (
                     (parser.lexingErrors.map((se) => ({
                        errorMessage: se.additionalInfo ?
                            ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 9, "Unexpected token. Hint: {0}", se.additionalInfo)) :
                            ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_4__.localizeWithPath)(_moduleId, 10, "Unexpected token.")),
                        offset: se.offset,
                        length: se.lexeme.length,
                    })))
                );
            }
            else if (parser.parsingErrors.length > 0) {
                return (
                     (parser.parsingErrors.map((pe) => ({
                        errorMessage: pe.additionalInfo ? `${pe.message}. ${pe.additionalInfo}` : pe.message,
                        offset: pe.offset,
                        length: pe.lexeme.length,
                    })))
                );
            }
            else {
                return [];
            }
        }))
    );
}
function expressionsAreEqualWithConstantSubstitution(a, b) {
    const aExpr = a ? a.substituteConstants() : undefined;
    const bExpr = b ? b.substituteConstants() : undefined;
    if (!aExpr && !bExpr) {
        return true;
    }
    if (!aExpr || !bExpr) {
        return false;
    }
    return aExpr.equals(bExpr);
}
function cmp(a, b) {
    return a.cmp(b);
}
class ContextKeyFalseExpr {
    static { this.INSTANCE = ( (new ContextKeyFalseExpr())); }
    constructor() {
        this.type = ContextKeyExprType.False;
    }
    cmp(other) {
        return this.type - other.type;
    }
    equals(other) {
        return (other.type === this.type);
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        return false;
    }
    serialize() {
        return 'false';
    }
    keys() {
        return [];
    }
    map(mapFnc) {
        return this;
    }
    negate() {
        return ContextKeyTrueExpr.INSTANCE;
    }
}
class ContextKeyTrueExpr {
    static { this.INSTANCE = ( (new ContextKeyTrueExpr())); }
    constructor() {
        this.type = ContextKeyExprType.True;
    }
    cmp(other) {
        return this.type - other.type;
    }
    equals(other) {
        return (other.type === this.type);
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        return true;
    }
    serialize() {
        return 'true';
    }
    keys() {
        return [];
    }
    map(mapFnc) {
        return this;
    }
    negate() {
        return ContextKeyFalseExpr.INSTANCE;
    }
}
class ContextKeyDefinedExpr {
    static create(key, negated = null) {
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === 'boolean') {
            return constantValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
        }
        return (
             (new ContextKeyDefinedExpr(key, negated))
        );
    }
    constructor(key, negated) {
        this.key = key;
        this.negated = negated;
        this.type = ContextKeyExprType.Defined;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp1(this.key, other.key);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key);
        }
        return false;
    }
    substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === 'boolean') {
            return constantValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
        }
        return this;
    }
    evaluate(context) {
        return (!!context.getValue(this.key));
    }
    serialize() {
        return this.key;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapDefined(this.key);
    }
    negate() {
        if (!this.negated) {
            this.negated = ( (ContextKeyNotExpr.create(this.key, this)));
        }
        return this.negated;
    }
}
class ContextKeyEqualsExpr {
    static create(key, value, negated = null) {
        if (typeof value === 'boolean') {
            return (value ?  (ContextKeyDefinedExpr.create(key, negated)) :  (ContextKeyNotExpr.create(key, negated)));
        }
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === 'boolean') {
            const trueValue = constantValue ? 'true' : 'false';
            return (value === trueValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE);
        }
        return (
             (new ContextKeyEqualsExpr(key, value, negated))
        );
    }
    constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = ContextKeyExprType.Equals;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    }
    substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === 'boolean') {
            const trueValue = constantValue ? 'true' : 'false';
            return (this.value === trueValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE);
        }
        return this;
    }
    evaluate(context) {
        return (context.getValue(this.key) == this.value);
    }
    serialize() {
        return `${this.key} == '${this.value}'`;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapEquals(this.key, this.value);
    }
    negate() {
        if (!this.negated) {
            this.negated = ContextKeyNotEqualsExpr.create(this.key, this.value, this);
        }
        return this.negated;
    }
}
class ContextKeyInExpr {
    static create(key, valueKey) {
        return (
             (new ContextKeyInExpr(key, valueKey))
        );
    }
    constructor(key, valueKey) {
        this.key = key;
        this.valueKey = valueKey;
        this.type = ContextKeyExprType.In;
        this.negated = null;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.valueKey, other.key, other.valueKey);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.valueKey === other.valueKey);
        }
        return false;
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        const source = context.getValue(this.valueKey);
        const item = context.getValue(this.key);
        if (Array.isArray(source)) {
            return source.includes(item);
        }
        if (typeof item === 'string' && typeof source === 'object' && source !== null) {
            return hasOwnProperty.call(source, item);
        }
        return false;
    }
    serialize() {
        return `${this.key} in '${this.valueKey}'`;
    }
    keys() {
        return [this.key, this.valueKey];
    }
    map(mapFnc) {
        return mapFnc.mapIn(this.key, this.valueKey);
    }
    negate() {
        if (!this.negated) {
            this.negated = ContextKeyNotInExpr.create(this.key, this.valueKey);
        }
        return this.negated;
    }
}
class ContextKeyNotInExpr {
    static create(key, valueKey) {
        return (
             (new ContextKeyNotInExpr(key, valueKey))
        );
    }
    constructor(key, valueKey) {
        this.key = key;
        this.valueKey = valueKey;
        this.type = ContextKeyExprType.NotIn;
        this._negated = ContextKeyInExpr.create(key, valueKey);
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return this._negated.cmp(other._negated);
    }
    equals(other) {
        if (other.type === this.type) {
            return this._negated.equals(other._negated);
        }
        return false;
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        return !this._negated.evaluate(context);
    }
    serialize() {
        return `${this.key} not in '${this.valueKey}'`;
    }
    keys() {
        return (
             (this._negated.keys())
        );
    }
    map(mapFnc) {
        return mapFnc.mapNotIn(this.key, this.valueKey);
    }
    negate() {
        return this._negated;
    }
}
class ContextKeyNotEqualsExpr {
    static create(key, value, negated = null) {
        if (typeof value === 'boolean') {
            if (value) {
                return (
                     (ContextKeyNotExpr.create(key, negated))
                );
            }
            return (
                 (ContextKeyDefinedExpr.create(key, negated))
            );
        }
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === 'boolean') {
            const falseValue = constantValue ? 'true' : 'false';
            return (value === falseValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE);
        }
        return (
             (new ContextKeyNotEqualsExpr(key, value, negated))
        );
    }
    constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = ContextKeyExprType.NotEquals;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    }
    substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === 'boolean') {
            const falseValue = constantValue ? 'true' : 'false';
            return (this.value === falseValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE);
        }
        return this;
    }
    evaluate(context) {
        return (context.getValue(this.key) != this.value);
    }
    serialize() {
        return `${this.key} != '${this.value}'`;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapNotEquals(this.key, this.value);
    }
    negate() {
        if (!this.negated) {
            this.negated = ContextKeyEqualsExpr.create(this.key, this.value, this);
        }
        return this.negated;
    }
}
class ContextKeyNotExpr {
    static create(key, negated = null) {
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === 'boolean') {
            return (constantValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE);
        }
        return (
             (new ContextKeyNotExpr(key, negated))
        );
    }
    constructor(key, negated) {
        this.key = key;
        this.negated = negated;
        this.type = ContextKeyExprType.Not;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp1(this.key, other.key);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key);
        }
        return false;
    }
    substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === 'boolean') {
            return (constantValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE);
        }
        return this;
    }
    evaluate(context) {
        return (!context.getValue(this.key));
    }
    serialize() {
        return `!${this.key}`;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapNot(this.key);
    }
    negate() {
        if (!this.negated) {
            this.negated = ( (ContextKeyDefinedExpr.create(this.key, this)));
        }
        return this.negated;
    }
}
function withFloatOrStr(value, callback) {
    if (typeof value === 'string') {
        const n = parseFloat(value);
        if (!isNaN(n)) {
            value = n;
        }
    }
    if (typeof value === 'string' || typeof value === 'number') {
        return callback(value);
    }
    return ContextKeyFalseExpr.INSTANCE;
}
class ContextKeyGreaterExpr {
    static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => ( (new ContextKeyGreaterExpr(key, value, negated))));
    }
    constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = ContextKeyExprType.Greater;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        if (typeof this.value === 'string') {
            return false;
        }
        return (parseFloat(context.getValue(this.key)) > this.value);
    }
    serialize() {
        return `${this.key} > ${this.value}`;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapGreater(this.key, this.value);
    }
    negate() {
        if (!this.negated) {
            this.negated = ContextKeySmallerEqualsExpr.create(this.key, this.value, this);
        }
        return this.negated;
    }
}
class ContextKeyGreaterEqualsExpr {
    static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => ( (new ContextKeyGreaterEqualsExpr(key, value, negated))));
    }
    constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = ContextKeyExprType.GreaterEquals;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        if (typeof this.value === 'string') {
            return false;
        }
        return (parseFloat(context.getValue(this.key)) >= this.value);
    }
    serialize() {
        return `${this.key} >= ${this.value}`;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapGreaterEquals(this.key, this.value);
    }
    negate() {
        if (!this.negated) {
            this.negated = ContextKeySmallerExpr.create(this.key, this.value, this);
        }
        return this.negated;
    }
}
class ContextKeySmallerExpr {
    static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => ( (new ContextKeySmallerExpr(key, value, negated))));
    }
    constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = ContextKeyExprType.Smaller;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        if (typeof this.value === 'string') {
            return false;
        }
        return (parseFloat(context.getValue(this.key)) < this.value);
    }
    serialize() {
        return `${this.key} < ${this.value}`;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapSmaller(this.key, this.value);
    }
    negate() {
        if (!this.negated) {
            this.negated = ContextKeyGreaterEqualsExpr.create(this.key, this.value, this);
        }
        return this.negated;
    }
}
class ContextKeySmallerEqualsExpr {
    static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => ( (new ContextKeySmallerEqualsExpr(key, value, negated))));
    }
    constructor(key, value, negated) {
        this.key = key;
        this.value = value;
        this.negated = negated;
        this.type = ContextKeyExprType.SmallerEquals;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    }
    equals(other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        if (typeof this.value === 'string') {
            return false;
        }
        return (parseFloat(context.getValue(this.key)) <= this.value);
    }
    serialize() {
        return `${this.key} <= ${this.value}`;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapSmallerEquals(this.key, this.value);
    }
    negate() {
        if (!this.negated) {
            this.negated = ContextKeyGreaterExpr.create(this.key, this.value, this);
        }
        return this.negated;
    }
}
class ContextKeyRegexExpr {
    static create(key, regexp) {
        return (
             (new ContextKeyRegexExpr(key, regexp))
        );
    }
    constructor(key, regexp) {
        this.key = key;
        this.regexp = regexp;
        this.type = ContextKeyExprType.Regex;
        this.negated = null;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        if (this.key < other.key) {
            return -1;
        }
        if (this.key > other.key) {
            return 1;
        }
        const thisSource = this.regexp ? this.regexp.source : '';
        const otherSource = other.regexp ? other.regexp.source : '';
        if (thisSource < otherSource) {
            return -1;
        }
        if (thisSource > otherSource) {
            return 1;
        }
        return 0;
    }
    equals(other) {
        if (other.type === this.type) {
            const thisSource = this.regexp ? this.regexp.source : '';
            const otherSource = other.regexp ? other.regexp.source : '';
            return (this.key === other.key && thisSource === otherSource);
        }
        return false;
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        const value = context.getValue(this.key);
        return this.regexp ? this.regexp.test(value) : false;
    }
    serialize() {
        const value = this.regexp
            ? `/${this.regexp.source}/${this.regexp.flags}`
            : '/invalid/';
        return `${this.key} =~ ${value}`;
    }
    keys() {
        return [this.key];
    }
    map(mapFnc) {
        return mapFnc.mapRegex(this.key, this.regexp);
    }
    negate() {
        if (!this.negated) {
            this.negated = ContextKeyNotRegexExpr.create(this);
        }
        return this.negated;
    }
}
class ContextKeyNotRegexExpr {
    static create(actual) {
        return (
             (new ContextKeyNotRegexExpr(actual))
        );
    }
    constructor(_actual) {
        this._actual = _actual;
        this.type = ContextKeyExprType.NotRegex;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return this._actual.cmp(other._actual);
    }
    equals(other) {
        if (other.type === this.type) {
            return this._actual.equals(other._actual);
        }
        return false;
    }
    substituteConstants() {
        return this;
    }
    evaluate(context) {
        return !this._actual.evaluate(context);
    }
    serialize() {
        return `!(${this._actual.serialize()})`;
    }
    keys() {
        return (
             (this._actual.keys())
        );
    }
    map(mapFnc) {
        return (
             (new ContextKeyNotRegexExpr( (this._actual.map(mapFnc))))
        );
    }
    negate() {
        return this._actual;
    }
}
function eliminateConstantsInArray(arr) {
    let newArr = null;
    for (let i = 0, len = arr.length; i < len; i++) {
        const newExpr = arr[i].substituteConstants();
        if (arr[i] !== newExpr) {
            if (newArr === null) {
                newArr = [];
                for (let j = 0; j < i; j++) {
                    newArr[j] = arr[j];
                }
            }
        }
        if (newArr !== null) {
            newArr[i] = newExpr;
        }
    }
    if (newArr === null) {
        return arr;
    }
    return newArr;
}
class ContextKeyAndExpr {
    static create(_expr, negated, extraRedundantCheck) {
        return ContextKeyAndExpr._normalizeArr(_expr, negated, extraRedundantCheck);
    }
    constructor(expr, negated) {
        this.expr = expr;
        this.negated = negated;
        this.type = ContextKeyExprType.And;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        if (this.expr.length < other.expr.length) {
            return -1;
        }
        if (this.expr.length > other.expr.length) {
            return 1;
        }
        for (let i = 0, len = this.expr.length; i < len; i++) {
            const r = cmp(this.expr[i], other.expr[i]);
            if (r !== 0) {
                return r;
            }
        }
        return 0;
    }
    equals(other) {
        if (other.type === this.type) {
            if (this.expr.length !== other.expr.length) {
                return false;
            }
            for (let i = 0, len = this.expr.length; i < len; i++) {
                if (!this.expr[i].equals(other.expr[i])) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
    substituteConstants() {
        const exprArr = eliminateConstantsInArray(this.expr);
        if (exprArr === this.expr) {
            return this;
        }
        return ContextKeyAndExpr.create(exprArr, this.negated, false);
    }
    evaluate(context) {
        for (let i = 0, len = this.expr.length; i < len; i++) {
            if (!this.expr[i].evaluate(context)) {
                return false;
            }
        }
        return true;
    }
    static _normalizeArr(arr, negated, extraRedundantCheck) {
        const expr = [];
        let hasTrue = false;
        for (const e of arr) {
            if (!e) {
                continue;
            }
            if (e.type === ContextKeyExprType.True) {
                hasTrue = true;
                continue;
            }
            if (e.type === ContextKeyExprType.False) {
                return ContextKeyFalseExpr.INSTANCE;
            }
            if (e.type === ContextKeyExprType.And) {
                expr.push(...e.expr);
                continue;
            }
            expr.push(e);
        }
        if (expr.length === 0 && hasTrue) {
            return ContextKeyTrueExpr.INSTANCE;
        }
        if (expr.length === 0) {
            return undefined;
        }
        if (expr.length === 1) {
            return expr[0];
        }
        expr.sort(cmp);
        for (let i = 1; i < expr.length; i++) {
            if (expr[i - 1].equals(expr[i])) {
                expr.splice(i, 1);
                i--;
            }
        }
        if (expr.length === 1) {
            return expr[0];
        }
        while (expr.length > 1) {
            const lastElement = expr[expr.length - 1];
            if (lastElement.type !== ContextKeyExprType.Or) {
                break;
            }
            expr.pop();
            const secondToLastElement = expr.pop();
            const isFinished = (expr.length === 0);
            const resultElement = ContextKeyOrExpr.create(( (lastElement.expr.map(
                el => ContextKeyAndExpr.create([el, secondToLastElement], null, extraRedundantCheck)
            ))), null, isFinished);
            if (resultElement) {
                expr.push(resultElement);
                expr.sort(cmp);
            }
        }
        if (expr.length === 1) {
            return expr[0];
        }
        if (extraRedundantCheck) {
            for (let i = 0; i < expr.length; i++) {
                for (let j = i + 1; j < expr.length; j++) {
                    if (( (expr[i].negate())).equals(expr[j])) {
                        return ContextKeyFalseExpr.INSTANCE;
                    }
                }
            }
            if (expr.length === 1) {
                return expr[0];
            }
        }
        return (
             (new ContextKeyAndExpr(expr, negated))
        );
    }
    serialize() {
        return ( (this.expr.map(e => e.serialize()))).join(' && ');
    }
    keys() {
        const result = [];
        for (const expr of this.expr) {
            result.push(...( (expr.keys())));
        }
        return result;
    }
    map(mapFnc) {
        return (
             (new ContextKeyAndExpr(
                 (this.expr.map(expr => ( (expr.map(mapFnc))))),
                null
            ))
        );
    }
    negate() {
        if (!this.negated) {
            const result = [];
            for (const expr of this.expr) {
                result.push(( (expr.negate())));
            }
            this.negated = ContextKeyOrExpr.create(result, this, true);
        }
        return this.negated;
    }
}
class ContextKeyOrExpr {
    static create(_expr, negated, extraRedundantCheck) {
        return ContextKeyOrExpr._normalizeArr(_expr, negated, extraRedundantCheck);
    }
    constructor(expr, negated) {
        this.expr = expr;
        this.negated = negated;
        this.type = ContextKeyExprType.Or;
    }
    cmp(other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        if (this.expr.length < other.expr.length) {
            return -1;
        }
        if (this.expr.length > other.expr.length) {
            return 1;
        }
        for (let i = 0, len = this.expr.length; i < len; i++) {
            const r = cmp(this.expr[i], other.expr[i]);
            if (r !== 0) {
                return r;
            }
        }
        return 0;
    }
    equals(other) {
        if (other.type === this.type) {
            if (this.expr.length !== other.expr.length) {
                return false;
            }
            for (let i = 0, len = this.expr.length; i < len; i++) {
                if (!this.expr[i].equals(other.expr[i])) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
    substituteConstants() {
        const exprArr = eliminateConstantsInArray(this.expr);
        if (exprArr === this.expr) {
            return this;
        }
        return ContextKeyOrExpr.create(exprArr, this.negated, false);
    }
    evaluate(context) {
        for (let i = 0, len = this.expr.length; i < len; i++) {
            if (this.expr[i].evaluate(context)) {
                return true;
            }
        }
        return false;
    }
    static _normalizeArr(arr, negated, extraRedundantCheck) {
        let expr = [];
        let hasFalse = false;
        if (arr) {
            for (let i = 0, len = arr.length; i < len; i++) {
                const e = arr[i];
                if (!e) {
                    continue;
                }
                if (e.type === ContextKeyExprType.False) {
                    hasFalse = true;
                    continue;
                }
                if (e.type === ContextKeyExprType.True) {
                    return ContextKeyTrueExpr.INSTANCE;
                }
                if (e.type === ContextKeyExprType.Or) {
                    expr = expr.concat(e.expr);
                    continue;
                }
                expr.push(e);
            }
            if (expr.length === 0 && hasFalse) {
                return ContextKeyFalseExpr.INSTANCE;
            }
            expr.sort(cmp);
        }
        if (expr.length === 0) {
            return undefined;
        }
        if (expr.length === 1) {
            return expr[0];
        }
        for (let i = 1; i < expr.length; i++) {
            if (expr[i - 1].equals(expr[i])) {
                expr.splice(i, 1);
                i--;
            }
        }
        if (expr.length === 1) {
            return expr[0];
        }
        if (extraRedundantCheck) {
            for (let i = 0; i < expr.length; i++) {
                for (let j = i + 1; j < expr.length; j++) {
                    if (( (expr[i].negate())).equals(expr[j])) {
                        return ContextKeyTrueExpr.INSTANCE;
                    }
                }
            }
            if (expr.length === 1) {
                return expr[0];
            }
        }
        return (
             (new ContextKeyOrExpr(expr, negated))
        );
    }
    serialize() {
        return ( (this.expr.map(e => e.serialize()))).join(' || ');
    }
    keys() {
        const result = [];
        for (const expr of this.expr) {
            result.push(...( (expr.keys())));
        }
        return result;
    }
    map(mapFnc) {
        return (
             (new ContextKeyOrExpr(
                 (this.expr.map(expr => ( (expr.map(mapFnc))))),
                null
            ))
        );
    }
    negate() {
        if (!this.negated) {
            const result = [];
            for (const expr of this.expr) {
                result.push(( (expr.negate())));
            }
            while (result.length > 1) {
                const LEFT = result.shift();
                const RIGHT = result.shift();
                const all = [];
                for (const left of getTerminals(LEFT)) {
                    for (const right of getTerminals(RIGHT)) {
                        all.push(ContextKeyAndExpr.create([left, right], null, false));
                    }
                }
                result.unshift(ContextKeyOrExpr.create(all, null, false));
            }
            this.negated = ContextKeyOrExpr.create(result, this, true);
        }
        return this.negated;
    }
}
class RawContextKey extends ContextKeyDefinedExpr {
    static { this._info = []; }
    static all() {
        return (
             (RawContextKey._info.values())
        );
    }
    constructor(key, defaultValue, metaOrHide) {
        super(key, null);
        this._defaultValue = defaultValue;
        if (typeof metaOrHide === 'object') {
            RawContextKey._info.push({ ...metaOrHide, key });
        }
        else if (metaOrHide !== true) {
            RawContextKey._info.push({ key, description: metaOrHide, type: defaultValue !== null && defaultValue !== undefined ? typeof defaultValue : undefined });
        }
    }
    bindTo(target) {
        return target.createKey(this.key, this._defaultValue);
    }
    getValue(target) {
        return target.getContextKeyValue(this.key);
    }
    toNegated() {
        return (
             (this.negate())
        );
    }
    isEqualTo(value) {
        return ContextKeyEqualsExpr.create(this.key, value);
    }
    notEqualsTo(value) {
        return ContextKeyNotEqualsExpr.create(this.key, value);
    }
}
function cmp1(key1, key2) {
    if (key1 < key2) {
        return -1;
    }
    if (key1 > key2) {
        return 1;
    }
    return 0;
}
function cmp2(key1, value1, key2, value2) {
    if (key1 < key2) {
        return -1;
    }
    if (key1 > key2) {
        return 1;
    }
    if (value1 < value2) {
        return -1;
    }
    if (value1 > value2) {
        return 1;
    }
    return 0;
}
function implies(p, q) {
    if (p.type === ContextKeyExprType.False || q.type === ContextKeyExprType.True) {
        return true;
    }
    if (p.type === ContextKeyExprType.Or) {
        if (q.type === ContextKeyExprType.Or) {
            return allElementsIncluded(p.expr, q.expr);
        }
        return false;
    }
    if (q.type === ContextKeyExprType.Or) {
        for (const element of q.expr) {
            if (implies(p, element)) {
                return true;
            }
        }
        return false;
    }
    if (p.type === ContextKeyExprType.And) {
        if (q.type === ContextKeyExprType.And) {
            return allElementsIncluded(q.expr, p.expr);
        }
        for (const element of p.expr) {
            if (implies(element, q)) {
                return true;
            }
        }
        return false;
    }
    return p.equals(q);
}
function allElementsIncluded(p, q) {
    let pIndex = 0;
    let qIndex = 0;
    while (pIndex < p.length && qIndex < q.length) {
        const cmp = p[pIndex].cmp(q[qIndex]);
        if (cmp < 0) {
            return false;
        }
        else if (cmp === 0) {
            pIndex++;
            qIndex++;
        }
        else {
            qIndex++;
        }
    }
    return (pIndex === p.length);
}
function getTerminals(node) {
    if (node.type === ContextKeyExprType.Or) {
        return node.expr;
    }
    return [node];
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/platform/contextkey/common/contextkey.service.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/platform/contextkey/common/contextkey.service.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IContextKeyService: () => (/* binding */ IContextKeyService)
/* harmony export */ });
/* harmony import */ var _instantiation_common_instantiation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../instantiation/common/instantiation.js */ "./node_modules/vscode/vscode/src/vs/platform/instantiation/common/instantiation.js");

const IContextKeyService = ( (0,_instantiation_common_instantiation_js__WEBPACK_IMPORTED_MODULE_0__.createDecorator)('contextKeyService'));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/platform/contextkey/common/scanner.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/platform/contextkey/common/scanner.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Scanner: () => (/* binding */ Scanner),
/* harmony export */   TokenType: () => (/* binding */ TokenType)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _base_common_errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _nls_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../nls.js */ "./node_modules/vscode/vscode/src/vs/nls.js");



const _moduleId = "vs/platform/contextkey/common/scanner";
var TokenType;
( ((function(TokenType) {
    TokenType[TokenType["LParen"] = 0] = "LParen";
    TokenType[TokenType["RParen"] = 1] = "RParen";
    TokenType[TokenType["Neg"] = 2] = "Neg";
    TokenType[TokenType["Eq"] = 3] = "Eq";
    TokenType[TokenType["NotEq"] = 4] = "NotEq";
    TokenType[TokenType["Lt"] = 5] = "Lt";
    TokenType[TokenType["LtEq"] = 6] = "LtEq";
    TokenType[TokenType["Gt"] = 7] = "Gt";
    TokenType[TokenType["GtEq"] = 8] = "GtEq";
    TokenType[TokenType["RegexOp"] = 9] = "RegexOp";
    TokenType[TokenType["RegexStr"] = 10] = "RegexStr";
    TokenType[TokenType["True"] = 11] = "True";
    TokenType[TokenType["False"] = 12] = "False";
    TokenType[TokenType["In"] = 13] = "In";
    TokenType[TokenType["Not"] = 14] = "Not";
    TokenType[TokenType["And"] = 15] = "And";
    TokenType[TokenType["Or"] = 16] = "Or";
    TokenType[TokenType["Str"] = 17] = "Str";
    TokenType[TokenType["QuotedStr"] = 18] = "QuotedStr";
    TokenType[TokenType["Error"] = 19] = "Error";
    TokenType[TokenType["EOF"] = 20] = "EOF";
})(TokenType || (TokenType = {}))));
function hintDidYouMean(...meant) {
    switch (meant.length) {
        case 1:
            return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(_moduleId, 0, "Did you mean {0}?", meant[0]));
        case 2:
            return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(_moduleId, 1, "Did you mean {0} or {1}?", meant[0], meant[1]));
        case 3:
            return ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(
                _moduleId,
                2,
                "Did you mean {0}, {1} or {2}?",
                meant[0],
                meant[1],
                meant[2]
            ));
        default:
            return undefined;
    }
}
const hintDidYouForgetToOpenOrCloseQuote = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(_moduleId, 3, "Did you forget to open or close the quote?"));
const hintDidYouForgetToEscapeSlash = ( (0,_nls_js__WEBPACK_IMPORTED_MODULE_2__.localizeWithPath)(
    _moduleId,
    4,
    "Did you forget to escape the '/' (slash) character? Put two backslashes before it to escape, e.g., '\\\\/\'."
));
class Scanner {
    constructor() {
        this._input = '';
        this._start = 0;
        this._current = 0;
        this._tokens = [];
        this._errors = [];
        this.stringRe = /[a-zA-Z0-9_<>\-\./\\:\*\?\+\[\]\^,#@;"%\$\p{L}-]+/uy;
    }
    static getLexeme(token) {
        switch (token.type) {
            case TokenType.LParen:
                return '(';
            case TokenType.RParen:
                return ')';
            case TokenType.Neg:
                return '!';
            case TokenType.Eq:
                return token.isTripleEq ? '===' : '==';
            case TokenType.NotEq:
                return token.isTripleEq ? '!==' : '!=';
            case TokenType.Lt:
                return '<';
            case TokenType.LtEq:
                return '<=';
            case TokenType.Gt:
                return '>=';
            case TokenType.GtEq:
                return '>=';
            case TokenType.RegexOp:
                return '=~';
            case TokenType.RegexStr:
                return token.lexeme;
            case TokenType.True:
                return 'true';
            case TokenType.False:
                return 'false';
            case TokenType.In:
                return 'in';
            case TokenType.Not:
                return 'not';
            case TokenType.And:
                return '&&';
            case TokenType.Or:
                return '||';
            case TokenType.Str:
                return token.lexeme;
            case TokenType.QuotedStr:
                return token.lexeme;
            case TokenType.Error:
                return token.lexeme;
            case TokenType.EOF:
                return 'EOF';
            default:
                throw (0,_base_common_errors_js__WEBPACK_IMPORTED_MODULE_1__.illegalState)(`unhandled token type: ${JSON.stringify(token)}; have you forgotten to add a case?`);
        }
    }
    static { this._regexFlags = ( (new Set( (['i', 'g', 's', 'm', 'y', 'u'].map(ch => ch.charCodeAt(0)))))); }
    static { this._keywords = ( (new Map([
        ['not', TokenType.Not],
        ['in', TokenType.In],
        ['false', TokenType.False],
        ['true', TokenType.True],
    ]))); }
    get errors() {
        return this._errors;
    }
