/******/ var __webpack_modules__ = ({

/***/ "./node_modules/monaco-editor/esm/vs/editor/editor.worker.js":
/*!*******************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/editor/editor.worker.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   initialize: () => (/* reexport safe */ vscode_workers_editor_worker__WEBPACK_IMPORTED_MODULE_0__.initialize)
/* harmony export */ });
/* harmony import */ var vscode_workers_editor_worker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vscode/workers/editor.worker */ "./node_modules/vscode/workers/editor.worker.js");


/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/color.js":
/*!****************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/color.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Color: () => (/* binding */ Color),
/* harmony export */   HSLA: () => (/* binding */ HSLA),
/* harmony export */   HSVA: () => (/* binding */ HSVA),
/* harmony export */   RGBA: () => (/* binding */ RGBA)
/* harmony export */ });
/* harmony import */ var _charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");

function roundFloat(number, decimalPoints) {
    const decimal = Math.pow(10, decimalPoints);
    return Math.round(number * decimal) / decimal;
}
class RGBA {
    constructor(r, g, b, a = 1) {
        this._rgbaBrand = undefined;
        this.r = Math.min(255, Math.max(0, r)) | 0;
        this.g = Math.min(255, Math.max(0, g)) | 0;
        this.b = Math.min(255, Math.max(0, b)) | 0;
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    static equals(a, b) {
        return a.r === b.r && a.g === b.g && a.b === b.b && a.a === b.a;
    }
}
class HSLA {
    constructor(h, s, l, a) {
        this._hslaBrand = undefined;
        this.h = Math.max(Math.min(360, h), 0) | 0;
        this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
        this.l = roundFloat(Math.max(Math.min(1, l), 0), 3);
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    static equals(a, b) {
        return a.h === b.h && a.s === b.s && a.l === b.l && a.a === b.a;
    }
    static fromRGBA(rgba) {
        const r = rgba.r / 255;
        const g = rgba.g / 255;
        const b = rgba.b / 255;
        const a = rgba.a;
        const max = Math.max(r, g, b);
        const min = Math.min(r, g, b);
        let h = 0;
        let s = 0;
        const l = (min + max) / 2;
        const chroma = max - min;
        if (chroma > 0) {
            s = Math.min((l <= 0.5 ? chroma / (2 * l) : chroma / (2 - (2 * l))), 1);
            switch (max) {
                case r:
                    h = (g - b) / chroma + (g < b ? 6 : 0);
                    break;
                case g:
                    h = (b - r) / chroma + 2;
                    break;
                case b:
                    h = (r - g) / chroma + 4;
                    break;
            }
            h *= 60;
            h = Math.round(h);
        }
        return ( new HSLA(h, s, l, a));
    }
    static _hue2rgb(p, q, t) {
        if (t < 0) {
            t += 1;
        }
        if (t > 1) {
            t -= 1;
        }
        if (t < 1 / 6) {
            return p + (q - p) * 6 * t;
        }
        if (t < 1 / 2) {
            return q;
        }
        if (t < 2 / 3) {
            return p + (q - p) * (2 / 3 - t) * 6;
        }
        return p;
    }
    static toRGBA(hsla) {
        const h = hsla.h / 360;
        const { s, l, a } = hsla;
        let r, g, b;
        if (s === 0) {
            r = g = b = l;
        }
        else {
            const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
            const p = 2 * l - q;
            r = HSLA._hue2rgb(p, q, h + 1 / 3);
            g = HSLA._hue2rgb(p, q, h);
            b = HSLA._hue2rgb(p, q, h - 1 / 3);
        }
        return ( new RGBA(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), a));
    }
}
class HSVA {
    constructor(h, s, v, a) {
        this._hsvaBrand = undefined;
        this.h = Math.max(Math.min(360, h), 0) | 0;
        this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
        this.v = roundFloat(Math.max(Math.min(1, v), 0), 3);
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    static equals(a, b) {
        return a.h === b.h && a.s === b.s && a.v === b.v && a.a === b.a;
    }
    static fromRGBA(rgba) {
        const r = rgba.r / 255;
        const g = rgba.g / 255;
        const b = rgba.b / 255;
        const cmax = Math.max(r, g, b);
        const cmin = Math.min(r, g, b);
        const delta = cmax - cmin;
        const s = cmax === 0 ? 0 : (delta / cmax);
        let m;
        if (delta === 0) {
            m = 0;
        }
        else if (cmax === r) {
            m = ((((g - b) / delta) % 6) + 6) % 6;
        }
        else if (cmax === g) {
            m = ((b - r) / delta) + 2;
        }
        else {
            m = ((r - g) / delta) + 4;
        }
        return ( new HSVA(Math.round(m * 60), s, cmax, rgba.a));
    }
    static toRGBA(hsva) {
        const { h, s, v, a } = hsva;
        const c = v * s;
        const x = c * (1 - Math.abs((h / 60) % 2 - 1));
        const m = v - c;
        let [r, g, b] = [0, 0, 0];
        if (h < 60) {
            r = c;
            g = x;
        }
        else if (h < 120) {
            r = x;
            g = c;
        }
        else if (h < 180) {
            g = c;
            b = x;
        }
        else if (h < 240) {
            g = x;
            b = c;
        }
        else if (h < 300) {
            r = x;
            b = c;
        }
        else if (h <= 360) {
            r = c;
            b = x;
        }
        r = Math.round((r + m) * 255);
        g = Math.round((g + m) * 255);
        b = Math.round((b + m) * 255);
        return ( new RGBA(r, g, b, a));
    }
}
class Color {
    static fromHex(hex) {
        return Color.Format.CSS.parseHex(hex) || Color.red;
    }
    static equals(a, b) {
        if (!a && !b) {
            return true;
        }
        if (!a || !b) {
            return false;
        }
        return a.equals(b);
    }
    get hsla() {
        if (this._hsla) {
            return this._hsla;
        }
        else {
            return HSLA.fromRGBA(this.rgba);
        }
    }
    get hsva() {
        if (this._hsva) {
            return this._hsva;
        }
        return HSVA.fromRGBA(this.rgba);
    }
    constructor(arg) {
        if (!arg) {
            throw ( new Error('Color needs a value'));
        }
        else if (arg instanceof RGBA) {
            this.rgba = arg;
        }
        else if (arg instanceof HSLA) {
            this._hsla = arg;
            this.rgba = HSLA.toRGBA(arg);
        }
        else if (arg instanceof HSVA) {
            this._hsva = arg;
            this.rgba = HSVA.toRGBA(arg);
        }
        else {
            throw ( new Error('Invalid color ctor argument'));
        }
    }
    equals(other) {
        return !!other && RGBA.equals(this.rgba, other.rgba) && HSLA.equals(this.hsla, other.hsla) && HSVA.equals(this.hsva, other.hsva);
    }
    getRelativeLuminance() {
        const R = Color._relativeLuminanceForComponent(this.rgba.r);
        const G = Color._relativeLuminanceForComponent(this.rgba.g);
        const B = Color._relativeLuminanceForComponent(this.rgba.b);
        const luminance = 0.2126 * R + 0.7152 * G + 0.0722 * B;
        return roundFloat(luminance, 4);
    }
    static _relativeLuminanceForComponent(color) {
        const c = color / 255;
        return (c <= 0.03928) ? c / 12.92 : Math.pow(((c + 0.055) / 1.055), 2.4);
    }
    getContrastRatio(another) {
        const lum1 = this.getRelativeLuminance();
        const lum2 = another.getRelativeLuminance();
        return lum1 > lum2 ? (lum1 + 0.05) / (lum2 + 0.05) : (lum2 + 0.05) / (lum1 + 0.05);
    }
    isDarker() {
        const yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1000;
        return yiq < 128;
    }
    isLighter() {
        const yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1000;
        return yiq >= 128;
    }
    isLighterThan(another) {
        const lum1 = this.getRelativeLuminance();
        const lum2 = another.getRelativeLuminance();
        return lum1 > lum2;
    }
    isDarkerThan(another) {
        const lum1 = this.getRelativeLuminance();
        const lum2 = another.getRelativeLuminance();
        return lum1 < lum2;
    }
    lighten(factor) {
        return ( new Color(( new HSLA(this.hsla.h, this.hsla.s, this.hsla.l + this.hsla.l * factor, this.hsla.a))));
    }
    darken(factor) {
        return ( new Color(( new HSLA(this.hsla.h, this.hsla.s, this.hsla.l - this.hsla.l * factor, this.hsla.a))));
    }
    transparent(factor) {
        const { r, g, b, a } = this.rgba;
        return ( new Color(( new RGBA(r, g, b, a * factor))));
    }
    isTransparent() {
        return this.rgba.a === 0;
    }
    isOpaque() {
        return this.rgba.a === 1;
    }
    opposite() {
        return ( new Color(( new RGBA(255 - this.rgba.r, 255 - this.rgba.g, 255 - this.rgba.b, this.rgba.a))));
    }
    blend(c) {
        const rgba = c.rgba;
        const thisA = this.rgba.a;
        const colorA = rgba.a;
        const a = thisA + colorA * (1 - thisA);
        if (a < 1e-6) {
            return Color.transparent;
        }
        const r = this.rgba.r * thisA / a + rgba.r * colorA * (1 - thisA) / a;
        const g = this.rgba.g * thisA / a + rgba.g * colorA * (1 - thisA) / a;
        const b = this.rgba.b * thisA / a + rgba.b * colorA * (1 - thisA) / a;
        return ( new Color(( new RGBA(r, g, b, a))));
    }
    makeOpaque(opaqueBackground) {
        if (this.isOpaque() || opaqueBackground.rgba.a !== 1) {
            return this;
        }
        const { r, g, b, a } = this.rgba;
        return ( new Color(( new RGBA(
            opaqueBackground.rgba.r - a * (opaqueBackground.rgba.r - r),
            opaqueBackground.rgba.g - a * (opaqueBackground.rgba.g - g),
            opaqueBackground.rgba.b - a * (opaqueBackground.rgba.b - b),
            1
        ))));
    }
    flatten(...backgrounds) {
        const background = backgrounds.reduceRight((accumulator, color) => {
            return Color._flatten(color, accumulator);
        });
        return Color._flatten(this, background);
    }
    static _flatten(foreground, background) {
        const backgroundAlpha = 1 - foreground.rgba.a;
        return ( new Color(( new RGBA(
            backgroundAlpha * background.rgba.r + foreground.rgba.a * foreground.rgba.r,
            backgroundAlpha * background.rgba.g + foreground.rgba.a * foreground.rgba.g,
            backgroundAlpha * background.rgba.b + foreground.rgba.a * foreground.rgba.b
        ))));
    }
    toString() {
        if (!this._toString) {
            this._toString = Color.Format.CSS.format(this);
        }
        return this._toString;
    }
    static getLighterColor(of, relative, factor) {
        if (of.isLighterThan(relative)) {
            return of;
        }
        factor = factor ? factor : 0.5;
        const lum1 = of.getRelativeLuminance();
        const lum2 = relative.getRelativeLuminance();
        factor = factor * (lum2 - lum1) / lum2;
        return ( of.lighten(factor));
    }
    static getDarkerColor(of, relative, factor) {
        if (of.isDarkerThan(relative)) {
            return of;
        }
        factor = factor ? factor : 0.5;
        const lum1 = of.getRelativeLuminance();
        const lum2 = relative.getRelativeLuminance();
        factor = factor * (lum1 - lum2) / lum1;
        return ( of.darken(factor));
    }
    static { this.white = ( new Color(( new RGBA(255, 255, 255, 1)))); }
    static { this.black = ( new Color(( new RGBA(0, 0, 0, 1)))); }
    static { this.red = ( new Color(( new RGBA(255, 0, 0, 1)))); }
    static { this.blue = ( new Color(( new RGBA(0, 0, 255, 1)))); }
    static { this.green = ( new Color(( new RGBA(0, 255, 0, 1)))); }
    static { this.cyan = ( new Color(( new RGBA(0, 255, 255, 1)))); }
    static { this.lightgrey = ( new Color(( new RGBA(211, 211, 211, 1)))); }
    static { this.transparent = ( new Color(( new RGBA(0, 0, 0, 0)))); }
}
( (function(Color) {
    ( (function(Format) {
        ( (function(CSS) {
            function formatRGB(color) {
                if (color.rgba.a === 1) {
                    return `rgb(${color.rgba.r}, ${color.rgba.g}, ${color.rgba.b})`;
                }
                return Color.Format.CSS.formatRGBA(color);
            }
            CSS.formatRGB = formatRGB;
            function formatRGBA(color) {
                return `rgba(${color.rgba.r}, ${color.rgba.g}, ${color.rgba.b}, ${+(color.rgba.a).toFixed(2)})`;
            }
            CSS.formatRGBA = formatRGBA;
            function formatHSL(color) {
                if (color.hsla.a === 1) {
                    return `hsl(${color.hsla.h}, ${(color.hsla.s * 100).toFixed(2)}%, ${(color.hsla.l * 100).toFixed(2)}%)`;
                }
                return Color.Format.CSS.formatHSLA(color);
            }
            CSS.formatHSL = formatHSL;
            function formatHSLA(color) {
                return `hsla(${color.hsla.h}, ${(color.hsla.s * 100).toFixed(2)}%, ${(color.hsla.l * 100).toFixed(2)}%, ${color.hsla.a.toFixed(2)})`;
            }
            CSS.formatHSLA = formatHSLA;
            function _toTwoDigitHex(n) {
                const r = ( n.toString(16));
                return r.length !== 2 ? '0' + r : r;
            }
            function formatHex(color) {
                return `#${_toTwoDigitHex(color.rgba.r)}${_toTwoDigitHex(color.rgba.g)}${_toTwoDigitHex(color.rgba.b)}`;
            }
            CSS.formatHex = formatHex;
            function formatHexA(color, compact = false) {
                if (compact && color.rgba.a === 1) {
                    return Color.Format.CSS.formatHex(color);
                }
                return `#${_toTwoDigitHex(color.rgba.r)}${_toTwoDigitHex(color.rgba.g)}${_toTwoDigitHex(color.rgba.b)}${_toTwoDigitHex(Math.round(color.rgba.a * 255))}`;
            }
            CSS.formatHexA = formatHexA;
            function format(color) {
                if (color.isOpaque()) {
                    return Color.Format.CSS.formatHex(color);
                }
                return Color.Format.CSS.formatRGBA(color);
            }
            CSS.format = format;
            function parseHex(hex) {
                const length = hex.length;
                if (length === 0) {
                    return null;
                }
                if (hex.charCodeAt(0) !== _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Hash) {
                    return null;
                }
                if (length === 7) {
                    const r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
                    const g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
                    const b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
                    return ( new Color(( new RGBA(r, g, b, 1))));
                }
                if (length === 9) {
                    const r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
                    const g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
                    const b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
                    const a = 16 * _parseHexDigit(hex.charCodeAt(7)) + _parseHexDigit(hex.charCodeAt(8));
                    return ( new Color(( new RGBA(r, g, b, a / 255))));
                }
                if (length === 4) {
                    const r = _parseHexDigit(hex.charCodeAt(1));
                    const g = _parseHexDigit(hex.charCodeAt(2));
                    const b = _parseHexDigit(hex.charCodeAt(3));
                    return ( new Color(( new RGBA(16 * r + r, 16 * g + g, 16 * b + b))));
                }
                if (length === 5) {
                    const r = _parseHexDigit(hex.charCodeAt(1));
                    const g = _parseHexDigit(hex.charCodeAt(2));
                    const b = _parseHexDigit(hex.charCodeAt(3));
                    const a = _parseHexDigit(hex.charCodeAt(4));
                    return ( new Color(( new RGBA(16 * r + r, 16 * g + g, 16 * b + b, (16 * a + a) / 255))));
                }
                return null;
            }
            CSS.parseHex = parseHex;
            function _parseHexDigit(charCode) {
                switch (charCode) {
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit0: return 0;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit1: return 1;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit2: return 2;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit3: return 3;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit4: return 4;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit5: return 5;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit6: return 6;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit7: return 7;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit8: return 8;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Digit9: return 9;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.a: return 10;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.A: return 10;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.b: return 11;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.B: return 11;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.c: return 12;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.C: return 12;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.d: return 13;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.D: return 13;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.e: return 14;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.E: return 14;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.f: return 15;
                    case _charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.F: return 15;
                }
                return 0;
            }
        })(Format.CSS || (Format.CSS = {})));
    })(Color.Format || (Color.Format = {})));
})(Color || (Color = {})));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/diff/diff.js":
/*!********************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/diff/diff.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LcsDiff: () => (/* binding */ LcsDiff),
/* harmony export */   StringDiffSequence: () => (/* binding */ StringDiffSequence),
/* harmony export */   stringDiff: () => (/* binding */ stringDiff)
/* harmony export */ });
/* harmony import */ var _diffChange_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./diffChange.js */ "./node_modules/vscode/vscode/src/vs/base/common/diff/diffChange.js");
/* harmony import */ var _hash_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../hash.js */ "./node_modules/vscode/vscode/src/vs/base/common/hash.js");
/* harmony import */ var _uint_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../uint.js */ "./node_modules/vscode/vscode/src/vs/base/common/uint.js");



class StringDiffSequence {
    constructor(source) {
        this.source = source;
    }
    getElements() {
        const source = this.source;
        const characters = ( new Int32Array(source.length));
        for (let i = 0, len = source.length; i < len; i++) {
            characters[i] = source.charCodeAt(i);
        }
        return characters;
    }
}
function stringDiff(original, modified, pretty) {
    return ( new LcsDiff(( new StringDiffSequence(original)), ( new StringDiffSequence(modified)))).ComputeDiff(pretty).changes;
}
class Debug {
    static Assert(condition, message) {
        if (!condition) {
            throw ( new Error(message));
        }
    }
}
class MyArray {
    static Copy(sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
        for (let i = 0; i < length; i++) {
            destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
        }
    }
    static Copy2(sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
        for (let i = 0; i < length; i++) {
            destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
        }
    }
}
var LocalConstants;
( (function(LocalConstants) {
    LocalConstants[LocalConstants["MaxDifferencesHistory"] = 1447] = "MaxDifferencesHistory";
})(LocalConstants || (LocalConstants = {})));
class DiffChangeHelper {
    constructor() {
        this.m_changes = [];
        this.m_originalStart = _uint_js__WEBPACK_IMPORTED_MODULE_2__.Constants.MAX_SAFE_SMALL_INTEGER;
        this.m_modifiedStart = _uint_js__WEBPACK_IMPORTED_MODULE_2__.Constants.MAX_SAFE_SMALL_INTEGER;
        this.m_originalCount = 0;
        this.m_modifiedCount = 0;
    }
    MarkNextChange() {
        if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
            this.m_changes.push(( new _diffChange_js__WEBPACK_IMPORTED_MODULE_0__.DiffChange(
                this.m_originalStart,
                this.m_originalCount,
                this.m_modifiedStart,
                this.m_modifiedCount
            )));
        }
        this.m_originalCount = 0;
        this.m_modifiedCount = 0;
        this.m_originalStart = _uint_js__WEBPACK_IMPORTED_MODULE_2__.Constants.MAX_SAFE_SMALL_INTEGER;
        this.m_modifiedStart = _uint_js__WEBPACK_IMPORTED_MODULE_2__.Constants.MAX_SAFE_SMALL_INTEGER;
    }
    AddOriginalElement(originalIndex, modifiedIndex) {
        this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
        this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
        this.m_originalCount++;
    }
    AddModifiedElement(originalIndex, modifiedIndex) {
        this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
        this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
        this.m_modifiedCount++;
    }
    getChanges() {
        if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
            this.MarkNextChange();
        }
        return this.m_changes;
    }
    getReverseChanges() {
        if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
            this.MarkNextChange();
        }
        this.m_changes.reverse();
        return this.m_changes;
    }
}
class LcsDiff {
    constructor(originalSequence, modifiedSequence, continueProcessingPredicate = null) {
        this.ContinueProcessingPredicate = continueProcessingPredicate;
        this._originalSequence = originalSequence;
        this._modifiedSequence = modifiedSequence;
        const [originalStringElements, originalElementsOrHash, originalHasStrings] = LcsDiff._getElements(originalSequence);
        const [modifiedStringElements, modifiedElementsOrHash, modifiedHasStrings] = LcsDiff._getElements(modifiedSequence);
        this._hasStrings = (originalHasStrings && modifiedHasStrings);
        this._originalStringElements = originalStringElements;
        this._originalElementsOrHash = originalElementsOrHash;
        this._modifiedStringElements = modifiedStringElements;
        this._modifiedElementsOrHash = modifiedElementsOrHash;
        this.m_forwardHistory = [];
        this.m_reverseHistory = [];
    }
    static _isStringArray(arr) {
        return (arr.length > 0 && typeof arr[0] === 'string');
    }
    static _getElements(sequence) {
        const elements = sequence.getElements();
        if (LcsDiff._isStringArray(elements)) {
            const hashes = ( new Int32Array(elements.length));
            for (let i = 0, len = elements.length; i < len; i++) {
                hashes[i] = (0,_hash_js__WEBPACK_IMPORTED_MODULE_1__.stringHash)(elements[i], 0);
            }
            return [elements, hashes, true];
        }
        if (elements instanceof Int32Array) {
            return [[], elements, false];
        }
        return [[], ( new Int32Array(elements)), false];
    }
    ElementsAreEqual(originalIndex, newIndex) {
        if (this._originalElementsOrHash[originalIndex] !== this._modifiedElementsOrHash[newIndex]) {
            return false;
        }
        return (this._hasStrings ? this._originalStringElements[originalIndex] === this._modifiedStringElements[newIndex] : true);
    }
    ElementsAreStrictEqual(originalIndex, newIndex) {
        if (!this.ElementsAreEqual(originalIndex, newIndex)) {
            return false;
        }
        const originalElement = LcsDiff._getStrictElement(this._originalSequence, originalIndex);
        const modifiedElement = LcsDiff._getStrictElement(this._modifiedSequence, newIndex);
        return (originalElement === modifiedElement);
    }
    static _getStrictElement(sequence, index) {
        if (typeof sequence.getStrictElement === 'function') {
            return sequence.getStrictElement(index);
        }
        return null;
    }
    OriginalElementsAreEqual(index1, index2) {
        if (this._originalElementsOrHash[index1] !== this._originalElementsOrHash[index2]) {
            return false;
        }
        return (this._hasStrings ? this._originalStringElements[index1] === this._originalStringElements[index2] : true);
    }
    ModifiedElementsAreEqual(index1, index2) {
        if (this._modifiedElementsOrHash[index1] !== this._modifiedElementsOrHash[index2]) {
            return false;
        }
        return (this._hasStrings ? this._modifiedStringElements[index1] === this._modifiedStringElements[index2] : true);
    }
    ComputeDiff(pretty) {
        return this._ComputeDiff(0, this._originalElementsOrHash.length - 1, 0, this._modifiedElementsOrHash.length - 1, pretty);
    }
    _ComputeDiff(originalStart, originalEnd, modifiedStart, modifiedEnd, pretty) {
        const quitEarlyArr = [false];
        let changes = this.ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr);
        if (pretty) {
            changes = this.PrettifyChanges(changes);
        }
        return {
            quitEarly: quitEarlyArr[0],
            changes: changes
        };
    }
    ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr) {
        quitEarlyArr[0] = false;
        while (originalStart <= originalEnd && modifiedStart <= modifiedEnd && this.ElementsAreEqual(originalStart, modifiedStart)) {
            originalStart++;
            modifiedStart++;
        }
        while (originalEnd >= originalStart && modifiedEnd >= modifiedStart && this.ElementsAreEqual(originalEnd, modifiedEnd)) {
            originalEnd--;
            modifiedEnd--;
        }
        if (originalStart > originalEnd || modifiedStart > modifiedEnd) {
            let changes;
            if (modifiedStart <= modifiedEnd) {
                Debug.Assert(originalStart === originalEnd + 1, 'originalStart should only be one more than originalEnd');
                changes = [
                    ( new _diffChange_js__WEBPACK_IMPORTED_MODULE_0__.DiffChange(originalStart, 0, modifiedStart, modifiedEnd - modifiedStart + 1))
                ];
            }
            else if (originalStart <= originalEnd) {
                Debug.Assert(modifiedStart === modifiedEnd + 1, 'modifiedStart should only be one more than modifiedEnd');
                changes = [
                    ( new _diffChange_js__WEBPACK_IMPORTED_MODULE_0__.DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, 0))
                ];
            }
            else {
                Debug.Assert(originalStart === originalEnd + 1, 'originalStart should only be one more than originalEnd');
                Debug.Assert(modifiedStart === modifiedEnd + 1, 'modifiedStart should only be one more than modifiedEnd');
                changes = [];
            }
            return changes;
        }
        const midOriginalArr = [0];
        const midModifiedArr = [0];
        const result = this.ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr);
        const midOriginal = midOriginalArr[0];
        const midModified = midModifiedArr[0];
        if (result !== null) {
            return result;
        }
        else if (!quitEarlyArr[0]) {
            const leftChanges = this.ComputeDiffRecursive(originalStart, midOriginal, modifiedStart, midModified, quitEarlyArr);
            let rightChanges = [];
            if (!quitEarlyArr[0]) {
                rightChanges = this.ComputeDiffRecursive(midOriginal + 1, originalEnd, midModified + 1, modifiedEnd, quitEarlyArr);
            }
            else {
                rightChanges = [
                    ( new _diffChange_js__WEBPACK_IMPORTED_MODULE_0__.DiffChange(
                        midOriginal + 1,
                        originalEnd - (midOriginal + 1) + 1,
                        midModified + 1,
                        modifiedEnd - (midModified + 1) + 1
                    ))
                ];
            }
            return this.ConcatenateChanges(leftChanges, rightChanges);
        }
        return [
            ( new _diffChange_js__WEBPACK_IMPORTED_MODULE_0__.DiffChange(
                originalStart,
                originalEnd - originalStart + 1,
                modifiedStart,
                modifiedEnd - modifiedStart + 1
            ))
        ];
    }
    WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr) {
        let forwardChanges = null;
        let reverseChanges = null;
        let changeHelper = ( new DiffChangeHelper());
        let diagonalMin = diagonalForwardStart;
        let diagonalMax = diagonalForwardEnd;
        let diagonalRelative = (midOriginalArr[0] - midModifiedArr[0]) - diagonalForwardOffset;
        let lastOriginalIndex = _uint_js__WEBPACK_IMPORTED_MODULE_2__.Constants.MIN_SAFE_SMALL_INTEGER;
        let historyIndex = this.m_forwardHistory.length - 1;
        do {
            const diagonal = diagonalRelative + diagonalForwardBase;
            if (diagonal === diagonalMin || (diagonal < diagonalMax && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1])) {
                originalIndex = forwardPoints[diagonal + 1];
                modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
                if (originalIndex < lastOriginalIndex) {
                    changeHelper.MarkNextChange();
                }
                lastOriginalIndex = originalIndex;
                changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex);
                diagonalRelative = (diagonal + 1) - diagonalForwardBase;
            }
            else {
                originalIndex = forwardPoints[diagonal - 1] + 1;
                modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
                if (originalIndex < lastOriginalIndex) {
                    changeHelper.MarkNextChange();
                }
                lastOriginalIndex = originalIndex - 1;
                changeHelper.AddOriginalElement(originalIndex, modifiedIndex + 1);
                diagonalRelative = (diagonal - 1) - diagonalForwardBase;
            }
            if (historyIndex >= 0) {
                forwardPoints = this.m_forwardHistory[historyIndex];
                diagonalForwardBase = forwardPoints[0];
                diagonalMin = 1;
                diagonalMax = forwardPoints.length - 1;
            }
        } while (--historyIndex >= -1);
        forwardChanges = changeHelper.getReverseChanges();
        if (quitEarlyArr[0]) {
            let originalStartPoint = midOriginalArr[0] + 1;
            let modifiedStartPoint = midModifiedArr[0] + 1;
            if (forwardChanges !== null && forwardChanges.length > 0) {
                const lastForwardChange = forwardChanges[forwardChanges.length - 1];
                originalStartPoint = Math.max(originalStartPoint, lastForwardChange.getOriginalEnd());
                modifiedStartPoint = Math.max(modifiedStartPoint, lastForwardChange.getModifiedEnd());
            }
            reverseChanges = [
                ( new _diffChange_js__WEBPACK_IMPORTED_MODULE_0__.DiffChange(
                    originalStartPoint,
                    originalEnd - originalStartPoint + 1,
                    modifiedStartPoint,
                    modifiedEnd - modifiedStartPoint + 1
                ))
            ];
        }
        else {
            changeHelper = ( new DiffChangeHelper());
            diagonalMin = diagonalReverseStart;
            diagonalMax = diagonalReverseEnd;
            diagonalRelative = (midOriginalArr[0] - midModifiedArr[0]) - diagonalReverseOffset;
            lastOriginalIndex = _uint_js__WEBPACK_IMPORTED_MODULE_2__.Constants.MAX_SAFE_SMALL_INTEGER;
            historyIndex = (deltaIsEven) ? this.m_reverseHistory.length - 1 : this.m_reverseHistory.length - 2;
            do {
                const diagonal = diagonalRelative + diagonalReverseBase;
                if (diagonal === diagonalMin || (diagonal < diagonalMax && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1])) {
                    originalIndex = reversePoints[diagonal + 1] - 1;
                    modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
                    if (originalIndex > lastOriginalIndex) {
                        changeHelper.MarkNextChange();
                    }
                    lastOriginalIndex = originalIndex + 1;
                    changeHelper.AddOriginalElement(originalIndex + 1, modifiedIndex + 1);
                    diagonalRelative = (diagonal + 1) - diagonalReverseBase;
                }
                else {
                    originalIndex = reversePoints[diagonal - 1];
                    modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
                    if (originalIndex > lastOriginalIndex) {
                        changeHelper.MarkNextChange();
                    }
                    lastOriginalIndex = originalIndex;
                    changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex + 1);
                    diagonalRelative = (diagonal - 1) - diagonalReverseBase;
                }
                if (historyIndex >= 0) {
                    reversePoints = this.m_reverseHistory[historyIndex];
                    diagonalReverseBase = reversePoints[0];
                    diagonalMin = 1;
                    diagonalMax = reversePoints.length - 1;
                }
            } while (--historyIndex >= -1);
            reverseChanges = changeHelper.getChanges();
        }
        return this.ConcatenateChanges(forwardChanges, reverseChanges);
    }
    ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr) {
        let originalIndex = 0, modifiedIndex = 0;
        let diagonalForwardStart = 0, diagonalForwardEnd = 0;
        let diagonalReverseStart = 0, diagonalReverseEnd = 0;
        originalStart--;
        modifiedStart--;
        midOriginalArr[0] = 0;
        midModifiedArr[0] = 0;
        this.m_forwardHistory = [];
        this.m_reverseHistory = [];
        const maxDifferences = (originalEnd - originalStart) + (modifiedEnd - modifiedStart);
        const numDiagonals = maxDifferences + 1;
        const forwardPoints = ( new Int32Array(numDiagonals));
        const reversePoints = ( new Int32Array(numDiagonals));
        const diagonalForwardBase = (modifiedEnd - modifiedStart);
        const diagonalReverseBase = (originalEnd - originalStart);
        const diagonalForwardOffset = (originalStart - modifiedStart);
        const diagonalReverseOffset = (originalEnd - modifiedEnd);
        const delta = diagonalReverseBase - diagonalForwardBase;
        const deltaIsEven = (delta % 2 === 0);
        forwardPoints[diagonalForwardBase] = originalStart;
        reversePoints[diagonalReverseBase] = originalEnd;
        quitEarlyArr[0] = false;
        for (let numDifferences = 1; numDifferences <= (maxDifferences / 2) + 1; numDifferences++) {
            let furthestOriginalIndex = 0;
            let furthestModifiedIndex = 0;
            diagonalForwardStart = this.ClipDiagonalBound(diagonalForwardBase - numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
            diagonalForwardEnd = this.ClipDiagonalBound(diagonalForwardBase + numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
            for (let diagonal = diagonalForwardStart; diagonal <= diagonalForwardEnd; diagonal += 2) {
                if (diagonal === diagonalForwardStart || (diagonal < diagonalForwardEnd && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1])) {
                    originalIndex = forwardPoints[diagonal + 1];
                }
                else {
                    originalIndex = forwardPoints[diagonal - 1] + 1;
                }
                modifiedIndex = originalIndex - (diagonal - diagonalForwardBase) - diagonalForwardOffset;
                const tempOriginalIndex = originalIndex;
                while (originalIndex < originalEnd && modifiedIndex < modifiedEnd && this.ElementsAreEqual(originalIndex + 1, modifiedIndex + 1)) {
                    originalIndex++;
                    modifiedIndex++;
                }
                forwardPoints[diagonal] = originalIndex;
                if (originalIndex + modifiedIndex > furthestOriginalIndex + furthestModifiedIndex) {
                    furthestOriginalIndex = originalIndex;
                    furthestModifiedIndex = modifiedIndex;
                }
                if (!deltaIsEven && Math.abs(diagonal - diagonalReverseBase) <= (numDifferences - 1)) {
                    if (originalIndex >= reversePoints[diagonal]) {
                        midOriginalArr[0] = originalIndex;
                        midModifiedArr[0] = modifiedIndex;
                        if (tempOriginalIndex <= reversePoints[diagonal] && LocalConstants.MaxDifferencesHistory > 0 && numDifferences <= (LocalConstants.MaxDifferencesHistory + 1)) {
                            return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
                        }
                        else {
                            return null;
                        }
                    }
                }
            }
            const matchLengthOfLongest = ((furthestOriginalIndex - originalStart) + (furthestModifiedIndex - modifiedStart) - numDifferences) / 2;
            if (this.ContinueProcessingPredicate !== null && !this.ContinueProcessingPredicate(furthestOriginalIndex, matchLengthOfLongest)) {
                quitEarlyArr[0] = true;
                midOriginalArr[0] = furthestOriginalIndex;
                midModifiedArr[0] = furthestModifiedIndex;
                if (matchLengthOfLongest > 0 && LocalConstants.MaxDifferencesHistory > 0 && numDifferences <= (LocalConstants.MaxDifferencesHistory + 1)) {
                    return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
                }
                else {
                    originalStart++;
                    modifiedStart++;
                    return [
                        ( new _diffChange_js__WEBPACK_IMPORTED_MODULE_0__.DiffChange(
                            originalStart,
                            originalEnd - originalStart + 1,
                            modifiedStart,
                            modifiedEnd - modifiedStart + 1
                        ))
                    ];
                }
            }
            diagonalReverseStart = this.ClipDiagonalBound(diagonalReverseBase - numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
            diagonalReverseEnd = this.ClipDiagonalBound(diagonalReverseBase + numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
            for (let diagonal = diagonalReverseStart; diagonal <= diagonalReverseEnd; diagonal += 2) {
                if (diagonal === diagonalReverseStart || (diagonal < diagonalReverseEnd && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1])) {
                    originalIndex = reversePoints[diagonal + 1] - 1;
                }
                else {
                    originalIndex = reversePoints[diagonal - 1];
                }
                modifiedIndex = originalIndex - (diagonal - diagonalReverseBase) - diagonalReverseOffset;
                const tempOriginalIndex = originalIndex;
                while (originalIndex > originalStart && modifiedIndex > modifiedStart && this.ElementsAreEqual(originalIndex, modifiedIndex)) {
                    originalIndex--;
                    modifiedIndex--;
                }
                reversePoints[diagonal] = originalIndex;
                if (deltaIsEven && Math.abs(diagonal - diagonalForwardBase) <= numDifferences) {
                    if (originalIndex <= forwardPoints[diagonal]) {
                        midOriginalArr[0] = originalIndex;
                        midModifiedArr[0] = modifiedIndex;
                        if (tempOriginalIndex >= forwardPoints[diagonal] && LocalConstants.MaxDifferencesHistory > 0 && numDifferences <= (LocalConstants.MaxDifferencesHistory + 1)) {
                            return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
                        }
                        else {
                            return null;
                        }
                    }
                }
            }
            if (numDifferences <= LocalConstants.MaxDifferencesHistory) {
                let temp = ( new Int32Array(diagonalForwardEnd - diagonalForwardStart + 2));
                temp[0] = diagonalForwardBase - diagonalForwardStart + 1;
                MyArray.Copy2(forwardPoints, diagonalForwardStart, temp, 1, diagonalForwardEnd - diagonalForwardStart + 1);
                this.m_forwardHistory.push(temp);
                temp = ( new Int32Array(diagonalReverseEnd - diagonalReverseStart + 2));
                temp[0] = diagonalReverseBase - diagonalReverseStart + 1;
                MyArray.Copy2(reversePoints, diagonalReverseStart, temp, 1, diagonalReverseEnd - diagonalReverseStart + 1);
                this.m_reverseHistory.push(temp);
            }
        }
        return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
    }
    PrettifyChanges(changes) {
        for (let i = 0; i < changes.length; i++) {
            const change = changes[i];
            const originalStop = (i < changes.length - 1) ? changes[i + 1].originalStart : this._originalElementsOrHash.length;
            const modifiedStop = (i < changes.length - 1) ? changes[i + 1].modifiedStart : this._modifiedElementsOrHash.length;
            const checkOriginal = change.originalLength > 0;
            const checkModified = change.modifiedLength > 0;
            while (change.originalStart + change.originalLength < originalStop
                && change.modifiedStart + change.modifiedLength < modifiedStop
                && (!checkOriginal || this.OriginalElementsAreEqual(change.originalStart, change.originalStart + change.originalLength))
                && (!checkModified || this.ModifiedElementsAreEqual(change.modifiedStart, change.modifiedStart + change.modifiedLength))) {
                const startStrictEqual = this.ElementsAreStrictEqual(change.originalStart, change.modifiedStart);
                const endStrictEqual = this.ElementsAreStrictEqual(change.originalStart + change.originalLength, change.modifiedStart + change.modifiedLength);
                if (endStrictEqual && !startStrictEqual) {
                    break;
                }
                change.originalStart++;
                change.modifiedStart++;
            }
            const mergedChangeArr = [null];
            if (i < changes.length - 1 && this.ChangesOverlap(changes[i], changes[i + 1], mergedChangeArr)) {
                changes[i] = mergedChangeArr[0];
                changes.splice(i + 1, 1);
                i--;
                continue;
            }
        }
        for (let i = changes.length - 1; i >= 0; i--) {
            const change = changes[i];
            let originalStop = 0;
            let modifiedStop = 0;
            if (i > 0) {
                const prevChange = changes[i - 1];
                originalStop = prevChange.originalStart + prevChange.originalLength;
                modifiedStop = prevChange.modifiedStart + prevChange.modifiedLength;
            }
            const checkOriginal = change.originalLength > 0;
            const checkModified = change.modifiedLength > 0;
            let bestDelta = 0;
            let bestScore = this._boundaryScore(change.originalStart, change.originalLength, change.modifiedStart, change.modifiedLength);
            for (let delta = 1;; delta++) {
                const originalStart = change.originalStart - delta;
                const modifiedStart = change.modifiedStart - delta;
                if (originalStart < originalStop || modifiedStart < modifiedStop) {
                    break;
                }
                if (checkOriginal && !this.OriginalElementsAreEqual(originalStart, originalStart + change.originalLength)) {
                    break;
                }
                if (checkModified && !this.ModifiedElementsAreEqual(modifiedStart, modifiedStart + change.modifiedLength)) {
                    break;
                }
                const touchingPreviousChange = (originalStart === originalStop && modifiedStart === modifiedStop);
                const score = ((touchingPreviousChange ? 5 : 0)
                    + this._boundaryScore(originalStart, change.originalLength, modifiedStart, change.modifiedLength));
                if (score > bestScore) {
                    bestScore = score;
                    bestDelta = delta;
                }
            }
            change.originalStart -= bestDelta;
            change.modifiedStart -= bestDelta;
            const mergedChangeArr = [null];
            if (i > 0 && this.ChangesOverlap(changes[i - 1], changes[i], mergedChangeArr)) {
                changes[i - 1] = mergedChangeArr[0];
                changes.splice(i, 1);
                i++;
                continue;
            }
        }
        if (this._hasStrings) {
            for (let i = 1, len = changes.length; i < len; i++) {
                const aChange = changes[i - 1];
                const bChange = changes[i];
                const matchedLength = bChange.originalStart - aChange.originalStart - aChange.originalLength;
                const aOriginalStart = aChange.originalStart;
                const bOriginalEnd = bChange.originalStart + bChange.originalLength;
                const abOriginalLength = bOriginalEnd - aOriginalStart;
                const aModifiedStart = aChange.modifiedStart;
                const bModifiedEnd = bChange.modifiedStart + bChange.modifiedLength;
                const abModifiedLength = bModifiedEnd - aModifiedStart;
                if (matchedLength < 5 && abOriginalLength < 20 && abModifiedLength < 20) {
                    const t = this._findBetterContiguousSequence(aOriginalStart, abOriginalLength, aModifiedStart, abModifiedLength, matchedLength);
                    if (t) {
                        const [originalMatchStart, modifiedMatchStart] = t;
                        if (originalMatchStart !== aChange.originalStart + aChange.originalLength || modifiedMatchStart !== aChange.modifiedStart + aChange.modifiedLength) {
                            aChange.originalLength = originalMatchStart - aChange.originalStart;
                            aChange.modifiedLength = modifiedMatchStart - aChange.modifiedStart;
                            bChange.originalStart = originalMatchStart + matchedLength;
                            bChange.modifiedStart = modifiedMatchStart + matchedLength;
                            bChange.originalLength = bOriginalEnd - bChange.originalStart;
                            bChange.modifiedLength = bModifiedEnd - bChange.modifiedStart;
                        }
                    }
                }
            }
        }
        return changes;
    }
    _findBetterContiguousSequence(originalStart, originalLength, modifiedStart, modifiedLength, desiredLength) {
        if (originalLength < desiredLength || modifiedLength < desiredLength) {
            return null;
        }
        const originalMax = originalStart + originalLength - desiredLength + 1;
        const modifiedMax = modifiedStart + modifiedLength - desiredLength + 1;
        let bestScore = 0;
        let bestOriginalStart = 0;
        let bestModifiedStart = 0;
        for (let i = originalStart; i < originalMax; i++) {
            for (let j = modifiedStart; j < modifiedMax; j++) {
                const score = this._contiguousSequenceScore(i, j, desiredLength);
                if (score > 0 && score > bestScore) {
                    bestScore = score;
                    bestOriginalStart = i;
                    bestModifiedStart = j;
                }
            }
        }
        if (bestScore > 0) {
            return [bestOriginalStart, bestModifiedStart];
        }
        return null;
    }
    _contiguousSequenceScore(originalStart, modifiedStart, length) {
        let score = 0;
        for (let l = 0; l < length; l++) {
            if (!this.ElementsAreEqual(originalStart + l, modifiedStart + l)) {
                return 0;
            }
            score += this._originalStringElements[originalStart + l].length;
        }
        return score;
    }
    _OriginalIsBoundary(index) {
        if (index <= 0 || index >= this._originalElementsOrHash.length - 1) {
            return true;
        }
        return (this._hasStrings && /^\s*$/.test(this._originalStringElements[index]));
    }
    _OriginalRegionIsBoundary(originalStart, originalLength) {
        if (this._OriginalIsBoundary(originalStart) || this._OriginalIsBoundary(originalStart - 1)) {
            return true;
        }
        if (originalLength > 0) {
            const originalEnd = originalStart + originalLength;
            if (this._OriginalIsBoundary(originalEnd - 1) || this._OriginalIsBoundary(originalEnd)) {
                return true;
            }
        }
        return false;
    }
    _ModifiedIsBoundary(index) {
        if (index <= 0 || index >= this._modifiedElementsOrHash.length - 1) {
            return true;
        }
        return (this._hasStrings && /^\s*$/.test(this._modifiedStringElements[index]));
    }
    _ModifiedRegionIsBoundary(modifiedStart, modifiedLength) {
        if (this._ModifiedIsBoundary(modifiedStart) || this._ModifiedIsBoundary(modifiedStart - 1)) {
            return true;
        }
        if (modifiedLength > 0) {
            const modifiedEnd = modifiedStart + modifiedLength;
            if (this._ModifiedIsBoundary(modifiedEnd - 1) || this._ModifiedIsBoundary(modifiedEnd)) {
                return true;
            }
        }
        return false;
    }
    _boundaryScore(originalStart, originalLength, modifiedStart, modifiedLength) {
        const originalScore = (this._OriginalRegionIsBoundary(originalStart, originalLength) ? 1 : 0);
        const modifiedScore = (this._ModifiedRegionIsBoundary(modifiedStart, modifiedLength) ? 1 : 0);
        return (originalScore + modifiedScore);
    }
    ConcatenateChanges(left, right) {
        const mergedChangeArr = [];
        if (left.length === 0 || right.length === 0) {
            return (right.length > 0) ? right : left;
        }
        else if (this.ChangesOverlap(left[left.length - 1], right[0], mergedChangeArr)) {
            const result = ( new Array(left.length + right.length - 1));
            MyArray.Copy(left, 0, result, 0, left.length - 1);
            result[left.length - 1] = mergedChangeArr[0];
            MyArray.Copy(right, 1, result, left.length, right.length - 1);
            return result;
        }
        else {
            const result = ( new Array(left.length + right.length));
            MyArray.Copy(left, 0, result, 0, left.length);
            MyArray.Copy(right, 0, result, left.length, right.length);
            return result;
        }
    }
    ChangesOverlap(left, right, mergedChangeArr) {
        Debug.Assert(left.originalStart <= right.originalStart, 'Left change is not less than or equal to right change');
        Debug.Assert(left.modifiedStart <= right.modifiedStart, 'Left change is not less than or equal to right change');
        if (left.originalStart + left.originalLength >= right.originalStart || left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
            const originalStart = left.originalStart;
            let originalLength = left.originalLength;
            const modifiedStart = left.modifiedStart;
            let modifiedLength = left.modifiedLength;
            if (left.originalStart + left.originalLength >= right.originalStart) {
                originalLength = right.originalStart + right.originalLength - left.originalStart;
            }
            if (left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
                modifiedLength = right.modifiedStart + right.modifiedLength - left.modifiedStart;
            }
            mergedChangeArr[0] = ( new _diffChange_js__WEBPACK_IMPORTED_MODULE_0__.DiffChange(originalStart, originalLength, modifiedStart, modifiedLength));
            return true;
        }
        else {
            mergedChangeArr[0] = null;
            return false;
        }
    }
    ClipDiagonalBound(diagonal, numDifferences, diagonalBaseIndex, numDiagonals) {
        if (diagonal >= 0 && diagonal < numDiagonals) {
            return diagonal;
        }
        const diagonalsBelow = diagonalBaseIndex;
        const diagonalsAbove = numDiagonals - diagonalBaseIndex - 1;
        const diffEven = (numDifferences % 2 === 0);
        if (diagonal < 0) {
            const lowerBoundEven = (diagonalsBelow % 2 === 0);
            return (diffEven === lowerBoundEven) ? 0 : 1;
        }
        else {
            const upperBoundEven = (diagonalsAbove % 2 === 0);
            return (diffEven === upperBoundEven) ? numDiagonals - 1 : numDiagonals - 2;
        }
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/diff/diffChange.js":
/*!**************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/diff/diffChange.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DiffChange: () => (/* binding */ DiffChange)
/* harmony export */ });
class DiffChange {
    constructor(originalStart, originalLength, modifiedStart, modifiedLength) {
        this.originalStart = originalStart;
        this.originalLength = originalLength;
        this.modifiedStart = modifiedStart;
        this.modifiedLength = modifiedLength;
    }
    getOriginalEnd() {
        return this.originalStart + this.originalLength;
    }
    getModifiedEnd() {
        return this.modifiedStart + this.modifiedLength;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/keyCodes.js":
/*!*******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/keyCodes.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EVENT_KEY_CODE_MAP: () => (/* binding */ EVENT_KEY_CODE_MAP),
/* harmony export */   IMMUTABLE_CODE_TO_KEY_CODE: () => (/* binding */ IMMUTABLE_CODE_TO_KEY_CODE),
/* harmony export */   IMMUTABLE_KEY_CODE_TO_CODE: () => (/* binding */ IMMUTABLE_KEY_CODE_TO_CODE),
/* harmony export */   KeyChord: () => (/* binding */ KeyChord),
/* harmony export */   KeyCode: () => (/* binding */ KeyCode),
/* harmony export */   KeyCodeUtils: () => (/* binding */ KeyCodeUtils),
/* harmony export */   KeyMod: () => (/* binding */ KeyMod$1),
/* harmony export */   NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE: () => (/* binding */ NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE),
/* harmony export */   ScanCode: () => (/* binding */ ScanCode),
/* harmony export */   ScanCodeUtils: () => (/* binding */ ScanCodeUtils)
/* harmony export */ });
var KeyCode;
( (function(KeyCode) {
    KeyCode[KeyCode["DependsOnKbLayout"] = -1] = "DependsOnKbLayout";
    KeyCode[KeyCode["Unknown"] = 0] = "Unknown";
    KeyCode[KeyCode["Backspace"] = 1] = "Backspace";
    KeyCode[KeyCode["Tab"] = 2] = "Tab";
    KeyCode[KeyCode["Enter"] = 3] = "Enter";
    KeyCode[KeyCode["Shift"] = 4] = "Shift";
    KeyCode[KeyCode["Ctrl"] = 5] = "Ctrl";
    KeyCode[KeyCode["Alt"] = 6] = "Alt";
    KeyCode[KeyCode["PauseBreak"] = 7] = "PauseBreak";
    KeyCode[KeyCode["CapsLock"] = 8] = "CapsLock";
    KeyCode[KeyCode["Escape"] = 9] = "Escape";
    KeyCode[KeyCode["Space"] = 10] = "Space";
    KeyCode[KeyCode["PageUp"] = 11] = "PageUp";
    KeyCode[KeyCode["PageDown"] = 12] = "PageDown";
    KeyCode[KeyCode["End"] = 13] = "End";
    KeyCode[KeyCode["Home"] = 14] = "Home";
    KeyCode[KeyCode["LeftArrow"] = 15] = "LeftArrow";
    KeyCode[KeyCode["UpArrow"] = 16] = "UpArrow";
    KeyCode[KeyCode["RightArrow"] = 17] = "RightArrow";
    KeyCode[KeyCode["DownArrow"] = 18] = "DownArrow";
    KeyCode[KeyCode["Insert"] = 19] = "Insert";
    KeyCode[KeyCode["Delete"] = 20] = "Delete";
    KeyCode[KeyCode["Digit0"] = 21] = "Digit0";
    KeyCode[KeyCode["Digit1"] = 22] = "Digit1";
    KeyCode[KeyCode["Digit2"] = 23] = "Digit2";
    KeyCode[KeyCode["Digit3"] = 24] = "Digit3";
    KeyCode[KeyCode["Digit4"] = 25] = "Digit4";
    KeyCode[KeyCode["Digit5"] = 26] = "Digit5";
    KeyCode[KeyCode["Digit6"] = 27] = "Digit6";
    KeyCode[KeyCode["Digit7"] = 28] = "Digit7";
    KeyCode[KeyCode["Digit8"] = 29] = "Digit8";
    KeyCode[KeyCode["Digit9"] = 30] = "Digit9";
    KeyCode[KeyCode["KeyA"] = 31] = "KeyA";
    KeyCode[KeyCode["KeyB"] = 32] = "KeyB";
    KeyCode[KeyCode["KeyC"] = 33] = "KeyC";
    KeyCode[KeyCode["KeyD"] = 34] = "KeyD";
    KeyCode[KeyCode["KeyE"] = 35] = "KeyE";
    KeyCode[KeyCode["KeyF"] = 36] = "KeyF";
    KeyCode[KeyCode["KeyG"] = 37] = "KeyG";
    KeyCode[KeyCode["KeyH"] = 38] = "KeyH";
    KeyCode[KeyCode["KeyI"] = 39] = "KeyI";
    KeyCode[KeyCode["KeyJ"] = 40] = "KeyJ";
    KeyCode[KeyCode["KeyK"] = 41] = "KeyK";
    KeyCode[KeyCode["KeyL"] = 42] = "KeyL";
    KeyCode[KeyCode["KeyM"] = 43] = "KeyM";
    KeyCode[KeyCode["KeyN"] = 44] = "KeyN";
    KeyCode[KeyCode["KeyO"] = 45] = "KeyO";
    KeyCode[KeyCode["KeyP"] = 46] = "KeyP";
    KeyCode[KeyCode["KeyQ"] = 47] = "KeyQ";
    KeyCode[KeyCode["KeyR"] = 48] = "KeyR";
    KeyCode[KeyCode["KeyS"] = 49] = "KeyS";
    KeyCode[KeyCode["KeyT"] = 50] = "KeyT";
    KeyCode[KeyCode["KeyU"] = 51] = "KeyU";
    KeyCode[KeyCode["KeyV"] = 52] = "KeyV";
    KeyCode[KeyCode["KeyW"] = 53] = "KeyW";
    KeyCode[KeyCode["KeyX"] = 54] = "KeyX";
    KeyCode[KeyCode["KeyY"] = 55] = "KeyY";
    KeyCode[KeyCode["KeyZ"] = 56] = "KeyZ";
    KeyCode[KeyCode["Meta"] = 57] = "Meta";
    KeyCode[KeyCode["ContextMenu"] = 58] = "ContextMenu";
    KeyCode[KeyCode["F1"] = 59] = "F1";
    KeyCode[KeyCode["F2"] = 60] = "F2";
    KeyCode[KeyCode["F3"] = 61] = "F3";
    KeyCode[KeyCode["F4"] = 62] = "F4";
    KeyCode[KeyCode["F5"] = 63] = "F5";
    KeyCode[KeyCode["F6"] = 64] = "F6";
    KeyCode[KeyCode["F7"] = 65] = "F7";
    KeyCode[KeyCode["F8"] = 66] = "F8";
    KeyCode[KeyCode["F9"] = 67] = "F9";
    KeyCode[KeyCode["F10"] = 68] = "F10";
    KeyCode[KeyCode["F11"] = 69] = "F11";
    KeyCode[KeyCode["F12"] = 70] = "F12";
    KeyCode[KeyCode["F13"] = 71] = "F13";
    KeyCode[KeyCode["F14"] = 72] = "F14";
    KeyCode[KeyCode["F15"] = 73] = "F15";
    KeyCode[KeyCode["F16"] = 74] = "F16";
    KeyCode[KeyCode["F17"] = 75] = "F17";
    KeyCode[KeyCode["F18"] = 76] = "F18";
    KeyCode[KeyCode["F19"] = 77] = "F19";
    KeyCode[KeyCode["F20"] = 78] = "F20";
    KeyCode[KeyCode["F21"] = 79] = "F21";
    KeyCode[KeyCode["F22"] = 80] = "F22";
    KeyCode[KeyCode["F23"] = 81] = "F23";
    KeyCode[KeyCode["F24"] = 82] = "F24";
    KeyCode[KeyCode["NumLock"] = 83] = "NumLock";
    KeyCode[KeyCode["ScrollLock"] = 84] = "ScrollLock";
    KeyCode[KeyCode["Semicolon"] = 85] = "Semicolon";
    KeyCode[KeyCode["Equal"] = 86] = "Equal";
    KeyCode[KeyCode["Comma"] = 87] = "Comma";
    KeyCode[KeyCode["Minus"] = 88] = "Minus";
    KeyCode[KeyCode["Period"] = 89] = "Period";
    KeyCode[KeyCode["Slash"] = 90] = "Slash";
    KeyCode[KeyCode["Backquote"] = 91] = "Backquote";
    KeyCode[KeyCode["BracketLeft"] = 92] = "BracketLeft";
    KeyCode[KeyCode["Backslash"] = 93] = "Backslash";
    KeyCode[KeyCode["BracketRight"] = 94] = "BracketRight";
    KeyCode[KeyCode["Quote"] = 95] = "Quote";
    KeyCode[KeyCode["OEM_8"] = 96] = "OEM_8";
    KeyCode[KeyCode["IntlBackslash"] = 97] = "IntlBackslash";
    KeyCode[KeyCode["Numpad0"] = 98] = "Numpad0";
    KeyCode[KeyCode["Numpad1"] = 99] = "Numpad1";
    KeyCode[KeyCode["Numpad2"] = 100] = "Numpad2";
    KeyCode[KeyCode["Numpad3"] = 101] = "Numpad3";
    KeyCode[KeyCode["Numpad4"] = 102] = "Numpad4";
    KeyCode[KeyCode["Numpad5"] = 103] = "Numpad5";
    KeyCode[KeyCode["Numpad6"] = 104] = "Numpad6";
    KeyCode[KeyCode["Numpad7"] = 105] = "Numpad7";
    KeyCode[KeyCode["Numpad8"] = 106] = "Numpad8";
    KeyCode[KeyCode["Numpad9"] = 107] = "Numpad9";
    KeyCode[KeyCode["NumpadMultiply"] = 108] = "NumpadMultiply";
    KeyCode[KeyCode["NumpadAdd"] = 109] = "NumpadAdd";
    KeyCode[KeyCode["NUMPAD_SEPARATOR"] = 110] = "NUMPAD_SEPARATOR";
    KeyCode[KeyCode["NumpadSubtract"] = 111] = "NumpadSubtract";
    KeyCode[KeyCode["NumpadDecimal"] = 112] = "NumpadDecimal";
    KeyCode[KeyCode["NumpadDivide"] = 113] = "NumpadDivide";
    KeyCode[KeyCode["KEY_IN_COMPOSITION"] = 114] = "KEY_IN_COMPOSITION";
    KeyCode[KeyCode["ABNT_C1"] = 115] = "ABNT_C1";
    KeyCode[KeyCode["ABNT_C2"] = 116] = "ABNT_C2";
    KeyCode[KeyCode["AudioVolumeMute"] = 117] = "AudioVolumeMute";
    KeyCode[KeyCode["AudioVolumeUp"] = 118] = "AudioVolumeUp";
    KeyCode[KeyCode["AudioVolumeDown"] = 119] = "AudioVolumeDown";
    KeyCode[KeyCode["BrowserSearch"] = 120] = "BrowserSearch";
    KeyCode[KeyCode["BrowserHome"] = 121] = "BrowserHome";
    KeyCode[KeyCode["BrowserBack"] = 122] = "BrowserBack";
    KeyCode[KeyCode["BrowserForward"] = 123] = "BrowserForward";
    KeyCode[KeyCode["MediaTrackNext"] = 124] = "MediaTrackNext";
    KeyCode[KeyCode["MediaTrackPrevious"] = 125] = "MediaTrackPrevious";
    KeyCode[KeyCode["MediaStop"] = 126] = "MediaStop";
    KeyCode[KeyCode["MediaPlayPause"] = 127] = "MediaPlayPause";
    KeyCode[KeyCode["LaunchMediaPlayer"] = 128] = "LaunchMediaPlayer";
    KeyCode[KeyCode["LaunchMail"] = 129] = "LaunchMail";
    KeyCode[KeyCode["LaunchApp2"] = 130] = "LaunchApp2";
    KeyCode[KeyCode["Clear"] = 131] = "Clear";
    KeyCode[KeyCode["MAX_VALUE"] = 132] = "MAX_VALUE";
})(KeyCode || (KeyCode = {})));
var ScanCode;
( (function(ScanCode) {
    ScanCode[ScanCode["DependsOnKbLayout"] = -1] = "DependsOnKbLayout";
    ScanCode[ScanCode["None"] = 0] = "None";
    ScanCode[ScanCode["Hyper"] = 1] = "Hyper";
    ScanCode[ScanCode["Super"] = 2] = "Super";
    ScanCode[ScanCode["Fn"] = 3] = "Fn";
    ScanCode[ScanCode["FnLock"] = 4] = "FnLock";
    ScanCode[ScanCode["Suspend"] = 5] = "Suspend";
    ScanCode[ScanCode["Resume"] = 6] = "Resume";
    ScanCode[ScanCode["Turbo"] = 7] = "Turbo";
    ScanCode[ScanCode["Sleep"] = 8] = "Sleep";
    ScanCode[ScanCode["WakeUp"] = 9] = "WakeUp";
    ScanCode[ScanCode["KeyA"] = 10] = "KeyA";
    ScanCode[ScanCode["KeyB"] = 11] = "KeyB";
    ScanCode[ScanCode["KeyC"] = 12] = "KeyC";
    ScanCode[ScanCode["KeyD"] = 13] = "KeyD";
    ScanCode[ScanCode["KeyE"] = 14] = "KeyE";
    ScanCode[ScanCode["KeyF"] = 15] = "KeyF";
    ScanCode[ScanCode["KeyG"] = 16] = "KeyG";
    ScanCode[ScanCode["KeyH"] = 17] = "KeyH";
    ScanCode[ScanCode["KeyI"] = 18] = "KeyI";
    ScanCode[ScanCode["KeyJ"] = 19] = "KeyJ";
    ScanCode[ScanCode["KeyK"] = 20] = "KeyK";
    ScanCode[ScanCode["KeyL"] = 21] = "KeyL";
    ScanCode[ScanCode["KeyM"] = 22] = "KeyM";
    ScanCode[ScanCode["KeyN"] = 23] = "KeyN";
    ScanCode[ScanCode["KeyO"] = 24] = "KeyO";
    ScanCode[ScanCode["KeyP"] = 25] = "KeyP";
    ScanCode[ScanCode["KeyQ"] = 26] = "KeyQ";
    ScanCode[ScanCode["KeyR"] = 27] = "KeyR";
    ScanCode[ScanCode["KeyS"] = 28] = "KeyS";
    ScanCode[ScanCode["KeyT"] = 29] = "KeyT";
    ScanCode[ScanCode["KeyU"] = 30] = "KeyU";
    ScanCode[ScanCode["KeyV"] = 31] = "KeyV";
    ScanCode[ScanCode["KeyW"] = 32] = "KeyW";
    ScanCode[ScanCode["KeyX"] = 33] = "KeyX";
    ScanCode[ScanCode["KeyY"] = 34] = "KeyY";
    ScanCode[ScanCode["KeyZ"] = 35] = "KeyZ";
    ScanCode[ScanCode["Digit1"] = 36] = "Digit1";
    ScanCode[ScanCode["Digit2"] = 37] = "Digit2";
    ScanCode[ScanCode["Digit3"] = 38] = "Digit3";
    ScanCode[ScanCode["Digit4"] = 39] = "Digit4";
    ScanCode[ScanCode["Digit5"] = 40] = "Digit5";
    ScanCode[ScanCode["Digit6"] = 41] = "Digit6";
    ScanCode[ScanCode["Digit7"] = 42] = "Digit7";
    ScanCode[ScanCode["Digit8"] = 43] = "Digit8";
    ScanCode[ScanCode["Digit9"] = 44] = "Digit9";
    ScanCode[ScanCode["Digit0"] = 45] = "Digit0";
    ScanCode[ScanCode["Enter"] = 46] = "Enter";
    ScanCode[ScanCode["Escape"] = 47] = "Escape";
    ScanCode[ScanCode["Backspace"] = 48] = "Backspace";
    ScanCode[ScanCode["Tab"] = 49] = "Tab";
    ScanCode[ScanCode["Space"] = 50] = "Space";
    ScanCode[ScanCode["Minus"] = 51] = "Minus";
    ScanCode[ScanCode["Equal"] = 52] = "Equal";
    ScanCode[ScanCode["BracketLeft"] = 53] = "BracketLeft";
    ScanCode[ScanCode["BracketRight"] = 54] = "BracketRight";
    ScanCode[ScanCode["Backslash"] = 55] = "Backslash";
    ScanCode[ScanCode["IntlHash"] = 56] = "IntlHash";
    ScanCode[ScanCode["Semicolon"] = 57] = "Semicolon";
    ScanCode[ScanCode["Quote"] = 58] = "Quote";
    ScanCode[ScanCode["Backquote"] = 59] = "Backquote";
    ScanCode[ScanCode["Comma"] = 60] = "Comma";
    ScanCode[ScanCode["Period"] = 61] = "Period";
    ScanCode[ScanCode["Slash"] = 62] = "Slash";
    ScanCode[ScanCode["CapsLock"] = 63] = "CapsLock";
    ScanCode[ScanCode["F1"] = 64] = "F1";
    ScanCode[ScanCode["F2"] = 65] = "F2";
    ScanCode[ScanCode["F3"] = 66] = "F3";
    ScanCode[ScanCode["F4"] = 67] = "F4";
    ScanCode[ScanCode["F5"] = 68] = "F5";
    ScanCode[ScanCode["F6"] = 69] = "F6";
    ScanCode[ScanCode["F7"] = 70] = "F7";
    ScanCode[ScanCode["F8"] = 71] = "F8";
    ScanCode[ScanCode["F9"] = 72] = "F9";
    ScanCode[ScanCode["F10"] = 73] = "F10";
    ScanCode[ScanCode["F11"] = 74] = "F11";
    ScanCode[ScanCode["F12"] = 75] = "F12";
    ScanCode[ScanCode["PrintScreen"] = 76] = "PrintScreen";
    ScanCode[ScanCode["ScrollLock"] = 77] = "ScrollLock";
    ScanCode[ScanCode["Pause"] = 78] = "Pause";
    ScanCode[ScanCode["Insert"] = 79] = "Insert";
    ScanCode[ScanCode["Home"] = 80] = "Home";
    ScanCode[ScanCode["PageUp"] = 81] = "PageUp";
    ScanCode[ScanCode["Delete"] = 82] = "Delete";
    ScanCode[ScanCode["End"] = 83] = "End";
    ScanCode[ScanCode["PageDown"] = 84] = "PageDown";
    ScanCode[ScanCode["ArrowRight"] = 85] = "ArrowRight";
    ScanCode[ScanCode["ArrowLeft"] = 86] = "ArrowLeft";
    ScanCode[ScanCode["ArrowDown"] = 87] = "ArrowDown";
    ScanCode[ScanCode["ArrowUp"] = 88] = "ArrowUp";
    ScanCode[ScanCode["NumLock"] = 89] = "NumLock";
    ScanCode[ScanCode["NumpadDivide"] = 90] = "NumpadDivide";
    ScanCode[ScanCode["NumpadMultiply"] = 91] = "NumpadMultiply";
    ScanCode[ScanCode["NumpadSubtract"] = 92] = "NumpadSubtract";
    ScanCode[ScanCode["NumpadAdd"] = 93] = "NumpadAdd";
    ScanCode[ScanCode["NumpadEnter"] = 94] = "NumpadEnter";
    ScanCode[ScanCode["Numpad1"] = 95] = "Numpad1";
    ScanCode[ScanCode["Numpad2"] = 96] = "Numpad2";
    ScanCode[ScanCode["Numpad3"] = 97] = "Numpad3";
    ScanCode[ScanCode["Numpad4"] = 98] = "Numpad4";
    ScanCode[ScanCode["Numpad5"] = 99] = "Numpad5";
    ScanCode[ScanCode["Numpad6"] = 100] = "Numpad6";
    ScanCode[ScanCode["Numpad7"] = 101] = "Numpad7";
    ScanCode[ScanCode["Numpad8"] = 102] = "Numpad8";
    ScanCode[ScanCode["Numpad9"] = 103] = "Numpad9";
    ScanCode[ScanCode["Numpad0"] = 104] = "Numpad0";
    ScanCode[ScanCode["NumpadDecimal"] = 105] = "NumpadDecimal";
    ScanCode[ScanCode["IntlBackslash"] = 106] = "IntlBackslash";
    ScanCode[ScanCode["ContextMenu"] = 107] = "ContextMenu";
    ScanCode[ScanCode["Power"] = 108] = "Power";
    ScanCode[ScanCode["NumpadEqual"] = 109] = "NumpadEqual";
    ScanCode[ScanCode["F13"] = 110] = "F13";
    ScanCode[ScanCode["F14"] = 111] = "F14";
    ScanCode[ScanCode["F15"] = 112] = "F15";
    ScanCode[ScanCode["F16"] = 113] = "F16";
    ScanCode[ScanCode["F17"] = 114] = "F17";
    ScanCode[ScanCode["F18"] = 115] = "F18";
    ScanCode[ScanCode["F19"] = 116] = "F19";
    ScanCode[ScanCode["F20"] = 117] = "F20";
    ScanCode[ScanCode["F21"] = 118] = "F21";
    ScanCode[ScanCode["F22"] = 119] = "F22";
    ScanCode[ScanCode["F23"] = 120] = "F23";
    ScanCode[ScanCode["F24"] = 121] = "F24";
    ScanCode[ScanCode["Open"] = 122] = "Open";
    ScanCode[ScanCode["Help"] = 123] = "Help";
    ScanCode[ScanCode["Select"] = 124] = "Select";
    ScanCode[ScanCode["Again"] = 125] = "Again";
    ScanCode[ScanCode["Undo"] = 126] = "Undo";
    ScanCode[ScanCode["Cut"] = 127] = "Cut";
    ScanCode[ScanCode["Copy"] = 128] = "Copy";
    ScanCode[ScanCode["Paste"] = 129] = "Paste";
    ScanCode[ScanCode["Find"] = 130] = "Find";
    ScanCode[ScanCode["AudioVolumeMute"] = 131] = "AudioVolumeMute";
    ScanCode[ScanCode["AudioVolumeUp"] = 132] = "AudioVolumeUp";
    ScanCode[ScanCode["AudioVolumeDown"] = 133] = "AudioVolumeDown";
    ScanCode[ScanCode["NumpadComma"] = 134] = "NumpadComma";
    ScanCode[ScanCode["IntlRo"] = 135] = "IntlRo";
    ScanCode[ScanCode["KanaMode"] = 136] = "KanaMode";
    ScanCode[ScanCode["IntlYen"] = 137] = "IntlYen";
    ScanCode[ScanCode["Convert"] = 138] = "Convert";
    ScanCode[ScanCode["NonConvert"] = 139] = "NonConvert";
    ScanCode[ScanCode["Lang1"] = 140] = "Lang1";
    ScanCode[ScanCode["Lang2"] = 141] = "Lang2";
    ScanCode[ScanCode["Lang3"] = 142] = "Lang3";
    ScanCode[ScanCode["Lang4"] = 143] = "Lang4";
    ScanCode[ScanCode["Lang5"] = 144] = "Lang5";
    ScanCode[ScanCode["Abort"] = 145] = "Abort";
    ScanCode[ScanCode["Props"] = 146] = "Props";
    ScanCode[ScanCode["NumpadParenLeft"] = 147] = "NumpadParenLeft";
    ScanCode[ScanCode["NumpadParenRight"] = 148] = "NumpadParenRight";
    ScanCode[ScanCode["NumpadBackspace"] = 149] = "NumpadBackspace";
    ScanCode[ScanCode["NumpadMemoryStore"] = 150] = "NumpadMemoryStore";
    ScanCode[ScanCode["NumpadMemoryRecall"] = 151] = "NumpadMemoryRecall";
    ScanCode[ScanCode["NumpadMemoryClear"] = 152] = "NumpadMemoryClear";
    ScanCode[ScanCode["NumpadMemoryAdd"] = 153] = "NumpadMemoryAdd";
    ScanCode[ScanCode["NumpadMemorySubtract"] = 154] = "NumpadMemorySubtract";
    ScanCode[ScanCode["NumpadClear"] = 155] = "NumpadClear";
    ScanCode[ScanCode["NumpadClearEntry"] = 156] = "NumpadClearEntry";
    ScanCode[ScanCode["ControlLeft"] = 157] = "ControlLeft";
    ScanCode[ScanCode["ShiftLeft"] = 158] = "ShiftLeft";
    ScanCode[ScanCode["AltLeft"] = 159] = "AltLeft";
    ScanCode[ScanCode["MetaLeft"] = 160] = "MetaLeft";
    ScanCode[ScanCode["ControlRight"] = 161] = "ControlRight";
    ScanCode[ScanCode["ShiftRight"] = 162] = "ShiftRight";
    ScanCode[ScanCode["AltRight"] = 163] = "AltRight";
    ScanCode[ScanCode["MetaRight"] = 164] = "MetaRight";
    ScanCode[ScanCode["BrightnessUp"] = 165] = "BrightnessUp";
    ScanCode[ScanCode["BrightnessDown"] = 166] = "BrightnessDown";
    ScanCode[ScanCode["MediaPlay"] = 167] = "MediaPlay";
    ScanCode[ScanCode["MediaRecord"] = 168] = "MediaRecord";
    ScanCode[ScanCode["MediaFastForward"] = 169] = "MediaFastForward";
    ScanCode[ScanCode["MediaRewind"] = 170] = "MediaRewind";
    ScanCode[ScanCode["MediaTrackNext"] = 171] = "MediaTrackNext";
    ScanCode[ScanCode["MediaTrackPrevious"] = 172] = "MediaTrackPrevious";
    ScanCode[ScanCode["MediaStop"] = 173] = "MediaStop";
    ScanCode[ScanCode["Eject"] = 174] = "Eject";
    ScanCode[ScanCode["MediaPlayPause"] = 175] = "MediaPlayPause";
    ScanCode[ScanCode["MediaSelect"] = 176] = "MediaSelect";
    ScanCode[ScanCode["LaunchMail"] = 177] = "LaunchMail";
    ScanCode[ScanCode["LaunchApp2"] = 178] = "LaunchApp2";
    ScanCode[ScanCode["LaunchApp1"] = 179] = "LaunchApp1";
    ScanCode[ScanCode["SelectTask"] = 180] = "SelectTask";
    ScanCode[ScanCode["LaunchScreenSaver"] = 181] = "LaunchScreenSaver";
    ScanCode[ScanCode["BrowserSearch"] = 182] = "BrowserSearch";
    ScanCode[ScanCode["BrowserHome"] = 183] = "BrowserHome";
    ScanCode[ScanCode["BrowserBack"] = 184] = "BrowserBack";
    ScanCode[ScanCode["BrowserForward"] = 185] = "BrowserForward";
    ScanCode[ScanCode["BrowserStop"] = 186] = "BrowserStop";
    ScanCode[ScanCode["BrowserRefresh"] = 187] = "BrowserRefresh";
    ScanCode[ScanCode["BrowserFavorites"] = 188] = "BrowserFavorites";
    ScanCode[ScanCode["ZoomToggle"] = 189] = "ZoomToggle";
    ScanCode[ScanCode["MailReply"] = 190] = "MailReply";
    ScanCode[ScanCode["MailForward"] = 191] = "MailForward";
    ScanCode[ScanCode["MailSend"] = 192] = "MailSend";
    ScanCode[ScanCode["MAX_VALUE"] = 193] = "MAX_VALUE";
})(ScanCode || (ScanCode = {})));
class KeyCodeStrMap {
    constructor() {
        this._keyCodeToStr = [];
        this._strToKeyCode = Object.create(null);
    }
    define(keyCode, str) {
        this._keyCodeToStr[keyCode] = str;
        this._strToKeyCode[str.toLowerCase()] = keyCode;
    }
    keyCodeToStr(keyCode) {
        return this._keyCodeToStr[keyCode];
    }
    strToKeyCode(str) {
        return this._strToKeyCode[str.toLowerCase()] || KeyCode.Unknown;
    }
}
const uiMap = ( new KeyCodeStrMap());
const userSettingsUSMap = ( new KeyCodeStrMap());
const userSettingsGeneralMap = ( new KeyCodeStrMap());
const EVENT_KEY_CODE_MAP = ( new Array(230));
const NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE = {};
const scanCodeIntToStr = [];
const scanCodeStrToInt = Object.create(null);
const scanCodeLowerCaseStrToInt = Object.create(null);
const ScanCodeUtils = {
    lowerCaseToEnum: (scanCode) => scanCodeLowerCaseStrToInt[scanCode] || ScanCode.None,
    toEnum: (scanCode) => scanCodeStrToInt[scanCode] || ScanCode.None,
    toString: (scanCode) => scanCodeIntToStr[scanCode] || 'None'
};
const IMMUTABLE_CODE_TO_KEY_CODE = [];
const IMMUTABLE_KEY_CODE_TO_CODE = [];
for (let i = 0; i <= ScanCode.MAX_VALUE; i++) {
    IMMUTABLE_CODE_TO_KEY_CODE[i] = KeyCode.DependsOnKbLayout;
}
for (let i = 0; i <= KeyCode.MAX_VALUE; i++) {
    IMMUTABLE_KEY_CODE_TO_CODE[i] = ScanCode.DependsOnKbLayout;
}
(function () {
    const empty = '';
    const mappings = [
        [1, ScanCode.None, 'None', KeyCode.Unknown, 'unknown', 0, 'VK_UNKNOWN', empty, empty],
        [1, ScanCode.Hyper, 'Hyper', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Super, 'Super', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Fn, 'Fn', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.FnLock, 'FnLock', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Suspend, 'Suspend', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Resume, 'Resume', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Turbo, 'Turbo', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Sleep, 'Sleep', KeyCode.Unknown, empty, 0, 'VK_SLEEP', empty, empty],
        [1, ScanCode.WakeUp, 'WakeUp', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [0, ScanCode.KeyA, 'KeyA', KeyCode.KeyA, 'A', 65, 'VK_A', empty, empty],
        [0, ScanCode.KeyB, 'KeyB', KeyCode.KeyB, 'B', 66, 'VK_B', empty, empty],
        [0, ScanCode.KeyC, 'KeyC', KeyCode.KeyC, 'C', 67, 'VK_C', empty, empty],
        [0, ScanCode.KeyD, 'KeyD', KeyCode.KeyD, 'D', 68, 'VK_D', empty, empty],
        [0, ScanCode.KeyE, 'KeyE', KeyCode.KeyE, 'E', 69, 'VK_E', empty, empty],
        [0, ScanCode.KeyF, 'KeyF', KeyCode.KeyF, 'F', 70, 'VK_F', empty, empty],
        [0, ScanCode.KeyG, 'KeyG', KeyCode.KeyG, 'G', 71, 'VK_G', empty, empty],
        [0, ScanCode.KeyH, 'KeyH', KeyCode.KeyH, 'H', 72, 'VK_H', empty, empty],
        [0, ScanCode.KeyI, 'KeyI', KeyCode.KeyI, 'I', 73, 'VK_I', empty, empty],
        [0, ScanCode.KeyJ, 'KeyJ', KeyCode.KeyJ, 'J', 74, 'VK_J', empty, empty],
        [0, ScanCode.KeyK, 'KeyK', KeyCode.KeyK, 'K', 75, 'VK_K', empty, empty],
        [0, ScanCode.KeyL, 'KeyL', KeyCode.KeyL, 'L', 76, 'VK_L', empty, empty],
        [0, ScanCode.KeyM, 'KeyM', KeyCode.KeyM, 'M', 77, 'VK_M', empty, empty],
        [0, ScanCode.KeyN, 'KeyN', KeyCode.KeyN, 'N', 78, 'VK_N', empty, empty],
        [0, ScanCode.KeyO, 'KeyO', KeyCode.KeyO, 'O', 79, 'VK_O', empty, empty],
        [0, ScanCode.KeyP, 'KeyP', KeyCode.KeyP, 'P', 80, 'VK_P', empty, empty],
        [0, ScanCode.KeyQ, 'KeyQ', KeyCode.KeyQ, 'Q', 81, 'VK_Q', empty, empty],
        [0, ScanCode.KeyR, 'KeyR', KeyCode.KeyR, 'R', 82, 'VK_R', empty, empty],
        [0, ScanCode.KeyS, 'KeyS', KeyCode.KeyS, 'S', 83, 'VK_S', empty, empty],
        [0, ScanCode.KeyT, 'KeyT', KeyCode.KeyT, 'T', 84, 'VK_T', empty, empty],
        [0, ScanCode.KeyU, 'KeyU', KeyCode.KeyU, 'U', 85, 'VK_U', empty, empty],
        [0, ScanCode.KeyV, 'KeyV', KeyCode.KeyV, 'V', 86, 'VK_V', empty, empty],
        [0, ScanCode.KeyW, 'KeyW', KeyCode.KeyW, 'W', 87, 'VK_W', empty, empty],
        [0, ScanCode.KeyX, 'KeyX', KeyCode.KeyX, 'X', 88, 'VK_X', empty, empty],
        [0, ScanCode.KeyY, 'KeyY', KeyCode.KeyY, 'Y', 89, 'VK_Y', empty, empty],
        [0, ScanCode.KeyZ, 'KeyZ', KeyCode.KeyZ, 'Z', 90, 'VK_Z', empty, empty],
        [0, ScanCode.Digit1, 'Digit1', KeyCode.Digit1, '1', 49, 'VK_1', empty, empty],
        [0, ScanCode.Digit2, 'Digit2', KeyCode.Digit2, '2', 50, 'VK_2', empty, empty],
        [0, ScanCode.Digit3, 'Digit3', KeyCode.Digit3, '3', 51, 'VK_3', empty, empty],
        [0, ScanCode.Digit4, 'Digit4', KeyCode.Digit4, '4', 52, 'VK_4', empty, empty],
        [0, ScanCode.Digit5, 'Digit5', KeyCode.Digit5, '5', 53, 'VK_5', empty, empty],
        [0, ScanCode.Digit6, 'Digit6', KeyCode.Digit6, '6', 54, 'VK_6', empty, empty],
        [0, ScanCode.Digit7, 'Digit7', KeyCode.Digit7, '7', 55, 'VK_7', empty, empty],
        [0, ScanCode.Digit8, 'Digit8', KeyCode.Digit8, '8', 56, 'VK_8', empty, empty],
        [0, ScanCode.Digit9, 'Digit9', KeyCode.Digit9, '9', 57, 'VK_9', empty, empty],
        [0, ScanCode.Digit0, 'Digit0', KeyCode.Digit0, '0', 48, 'VK_0', empty, empty],
        [1, ScanCode.Enter, 'Enter', KeyCode.Enter, 'Enter', 13, 'VK_RETURN', empty, empty],
        [1, ScanCode.Escape, 'Escape', KeyCode.Escape, 'Escape', 27, 'VK_ESCAPE', empty, empty],
        [1, ScanCode.Backspace, 'Backspace', KeyCode.Backspace, 'Backspace', 8, 'VK_BACK', empty, empty],
        [1, ScanCode.Tab, 'Tab', KeyCode.Tab, 'Tab', 9, 'VK_TAB', empty, empty],
        [1, ScanCode.Space, 'Space', KeyCode.Space, 'Space', 32, 'VK_SPACE', empty, empty],
        [0, ScanCode.Minus, 'Minus', KeyCode.Minus, '-', 189, 'VK_OEM_MINUS', '-', 'OEM_MINUS'],
        [0, ScanCode.Equal, 'Equal', KeyCode.Equal, '=', 187, 'VK_OEM_PLUS', '=', 'OEM_PLUS'],
        [0, ScanCode.BracketLeft, 'BracketLeft', KeyCode.BracketLeft, '[', 219, 'VK_OEM_4', '[', 'OEM_4'],
        [0, ScanCode.BracketRight, 'BracketRight', KeyCode.BracketRight, ']', 221, 'VK_OEM_6', ']', 'OEM_6'],
        [0, ScanCode.Backslash, 'Backslash', KeyCode.Backslash, '\\', 220, 'VK_OEM_5', '\\', 'OEM_5'],
        [0, ScanCode.IntlHash, 'IntlHash', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [0, ScanCode.Semicolon, 'Semicolon', KeyCode.Semicolon, ';', 186, 'VK_OEM_1', ';', 'OEM_1'],
        [0, ScanCode.Quote, 'Quote', KeyCode.Quote, '\'', 222, 'VK_OEM_7', '\'', 'OEM_7'],
        [0, ScanCode.Backquote, 'Backquote', KeyCode.Backquote, '`', 192, 'VK_OEM_3', '`', 'OEM_3'],
        [0, ScanCode.Comma, 'Comma', KeyCode.Comma, ',', 188, 'VK_OEM_COMMA', ',', 'OEM_COMMA'],
        [0, ScanCode.Period, 'Period', KeyCode.Period, '.', 190, 'VK_OEM_PERIOD', '.', 'OEM_PERIOD'],
        [0, ScanCode.Slash, 'Slash', KeyCode.Slash, '/', 191, 'VK_OEM_2', '/', 'OEM_2'],
        [1, ScanCode.CapsLock, 'CapsLock', KeyCode.CapsLock, 'CapsLock', 20, 'VK_CAPITAL', empty, empty],
        [1, ScanCode.F1, 'F1', KeyCode.F1, 'F1', 112, 'VK_F1', empty, empty],
        [1, ScanCode.F2, 'F2', KeyCode.F2, 'F2', 113, 'VK_F2', empty, empty],
        [1, ScanCode.F3, 'F3', KeyCode.F3, 'F3', 114, 'VK_F3', empty, empty],
        [1, ScanCode.F4, 'F4', KeyCode.F4, 'F4', 115, 'VK_F4', empty, empty],
        [1, ScanCode.F5, 'F5', KeyCode.F5, 'F5', 116, 'VK_F5', empty, empty],
        [1, ScanCode.F6, 'F6', KeyCode.F6, 'F6', 117, 'VK_F6', empty, empty],
        [1, ScanCode.F7, 'F7', KeyCode.F7, 'F7', 118, 'VK_F7', empty, empty],
        [1, ScanCode.F8, 'F8', KeyCode.F8, 'F8', 119, 'VK_F8', empty, empty],
        [1, ScanCode.F9, 'F9', KeyCode.F9, 'F9', 120, 'VK_F9', empty, empty],
        [1, ScanCode.F10, 'F10', KeyCode.F10, 'F10', 121, 'VK_F10', empty, empty],
        [1, ScanCode.F11, 'F11', KeyCode.F11, 'F11', 122, 'VK_F11', empty, empty],
        [1, ScanCode.F12, 'F12', KeyCode.F12, 'F12', 123, 'VK_F12', empty, empty],
        [1, ScanCode.PrintScreen, 'PrintScreen', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.ScrollLock, 'ScrollLock', KeyCode.ScrollLock, 'ScrollLock', 145, 'VK_SCROLL', empty, empty],
        [1, ScanCode.Pause, 'Pause', KeyCode.PauseBreak, 'PauseBreak', 19, 'VK_PAUSE', empty, empty],
        [1, ScanCode.Insert, 'Insert', KeyCode.Insert, 'Insert', 45, 'VK_INSERT', empty, empty],
        [1, ScanCode.Home, 'Home', KeyCode.Home, 'Home', 36, 'VK_HOME', empty, empty],
        [1, ScanCode.PageUp, 'PageUp', KeyCode.PageUp, 'PageUp', 33, 'VK_PRIOR', empty, empty],
        [1, ScanCode.Delete, 'Delete', KeyCode.Delete, 'Delete', 46, 'VK_DELETE', empty, empty],
        [1, ScanCode.End, 'End', KeyCode.End, 'End', 35, 'VK_END', empty, empty],
        [1, ScanCode.PageDown, 'PageDown', KeyCode.PageDown, 'PageDown', 34, 'VK_NEXT', empty, empty],
        [1, ScanCode.ArrowRight, 'ArrowRight', KeyCode.RightArrow, 'RightArrow', 39, 'VK_RIGHT', 'Right', empty],
        [1, ScanCode.ArrowLeft, 'ArrowLeft', KeyCode.LeftArrow, 'LeftArrow', 37, 'VK_LEFT', 'Left', empty],
        [1, ScanCode.ArrowDown, 'ArrowDown', KeyCode.DownArrow, 'DownArrow', 40, 'VK_DOWN', 'Down', empty],
        [1, ScanCode.ArrowUp, 'ArrowUp', KeyCode.UpArrow, 'UpArrow', 38, 'VK_UP', 'Up', empty],
        [1, ScanCode.NumLock, 'NumLock', KeyCode.NumLock, 'NumLock', 144, 'VK_NUMLOCK', empty, empty],
        [1, ScanCode.NumpadDivide, 'NumpadDivide', KeyCode.NumpadDivide, 'NumPad_Divide', 111, 'VK_DIVIDE', empty, empty],
        [1, ScanCode.NumpadMultiply, 'NumpadMultiply', KeyCode.NumpadMultiply, 'NumPad_Multiply', 106, 'VK_MULTIPLY', empty, empty],
        [1, ScanCode.NumpadSubtract, 'NumpadSubtract', KeyCode.NumpadSubtract, 'NumPad_Subtract', 109, 'VK_SUBTRACT', empty, empty],
        [1, ScanCode.NumpadAdd, 'NumpadAdd', KeyCode.NumpadAdd, 'NumPad_Add', 107, 'VK_ADD', empty, empty],
        [1, ScanCode.NumpadEnter, 'NumpadEnter', KeyCode.Enter, empty, 0, empty, empty, empty],
        [1, ScanCode.Numpad1, 'Numpad1', KeyCode.Numpad1, 'NumPad1', 97, 'VK_NUMPAD1', empty, empty],
        [1, ScanCode.Numpad2, 'Numpad2', KeyCode.Numpad2, 'NumPad2', 98, 'VK_NUMPAD2', empty, empty],
        [1, ScanCode.Numpad3, 'Numpad3', KeyCode.Numpad3, 'NumPad3', 99, 'VK_NUMPAD3', empty, empty],
        [1, ScanCode.Numpad4, 'Numpad4', KeyCode.Numpad4, 'NumPad4', 100, 'VK_NUMPAD4', empty, empty],
        [1, ScanCode.Numpad5, 'Numpad5', KeyCode.Numpad5, 'NumPad5', 101, 'VK_NUMPAD5', empty, empty],
        [1, ScanCode.Numpad6, 'Numpad6', KeyCode.Numpad6, 'NumPad6', 102, 'VK_NUMPAD6', empty, empty],
        [1, ScanCode.Numpad7, 'Numpad7', KeyCode.Numpad7, 'NumPad7', 103, 'VK_NUMPAD7', empty, empty],
        [1, ScanCode.Numpad8, 'Numpad8', KeyCode.Numpad8, 'NumPad8', 104, 'VK_NUMPAD8', empty, empty],
        [1, ScanCode.Numpad9, 'Numpad9', KeyCode.Numpad9, 'NumPad9', 105, 'VK_NUMPAD9', empty, empty],
        [1, ScanCode.Numpad0, 'Numpad0', KeyCode.Numpad0, 'NumPad0', 96, 'VK_NUMPAD0', empty, empty],
        [1, ScanCode.NumpadDecimal, 'NumpadDecimal', KeyCode.NumpadDecimal, 'NumPad_Decimal', 110, 'VK_DECIMAL', empty, empty],
        [0, ScanCode.IntlBackslash, 'IntlBackslash', KeyCode.IntlBackslash, 'OEM_102', 226, 'VK_OEM_102', empty, empty],
        [1, ScanCode.ContextMenu, 'ContextMenu', KeyCode.ContextMenu, 'ContextMenu', 93, empty, empty, empty],
        [1, ScanCode.Power, 'Power', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadEqual, 'NumpadEqual', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.F13, 'F13', KeyCode.F13, 'F13', 124, 'VK_F13', empty, empty],
        [1, ScanCode.F14, 'F14', KeyCode.F14, 'F14', 125, 'VK_F14', empty, empty],
        [1, ScanCode.F15, 'F15', KeyCode.F15, 'F15', 126, 'VK_F15', empty, empty],
        [1, ScanCode.F16, 'F16', KeyCode.F16, 'F16', 127, 'VK_F16', empty, empty],
        [1, ScanCode.F17, 'F17', KeyCode.F17, 'F17', 128, 'VK_F17', empty, empty],
        [1, ScanCode.F18, 'F18', KeyCode.F18, 'F18', 129, 'VK_F18', empty, empty],
        [1, ScanCode.F19, 'F19', KeyCode.F19, 'F19', 130, 'VK_F19', empty, empty],
        [1, ScanCode.F20, 'F20', KeyCode.F20, 'F20', 131, 'VK_F20', empty, empty],
        [1, ScanCode.F21, 'F21', KeyCode.F21, 'F21', 132, 'VK_F21', empty, empty],
        [1, ScanCode.F22, 'F22', KeyCode.F22, 'F22', 133, 'VK_F22', empty, empty],
        [1, ScanCode.F23, 'F23', KeyCode.F23, 'F23', 134, 'VK_F23', empty, empty],
        [1, ScanCode.F24, 'F24', KeyCode.F24, 'F24', 135, 'VK_F24', empty, empty],
        [1, ScanCode.Open, 'Open', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Help, 'Help', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Select, 'Select', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Again, 'Again', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Undo, 'Undo', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Cut, 'Cut', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Copy, 'Copy', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Paste, 'Paste', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Find, 'Find', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.AudioVolumeMute, 'AudioVolumeMute', KeyCode.AudioVolumeMute, 'AudioVolumeMute', 173, 'VK_VOLUME_MUTE', empty, empty],
        [1, ScanCode.AudioVolumeUp, 'AudioVolumeUp', KeyCode.AudioVolumeUp, 'AudioVolumeUp', 175, 'VK_VOLUME_UP', empty, empty],
        [1, ScanCode.AudioVolumeDown, 'AudioVolumeDown', KeyCode.AudioVolumeDown, 'AudioVolumeDown', 174, 'VK_VOLUME_DOWN', empty, empty],
        [1, ScanCode.NumpadComma, 'NumpadComma', KeyCode.NUMPAD_SEPARATOR, 'NumPad_Separator', 108, 'VK_SEPARATOR', empty, empty],
        [0, ScanCode.IntlRo, 'IntlRo', KeyCode.ABNT_C1, 'ABNT_C1', 193, 'VK_ABNT_C1', empty, empty],
        [1, ScanCode.KanaMode, 'KanaMode', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [0, ScanCode.IntlYen, 'IntlYen', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Convert, 'Convert', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NonConvert, 'NonConvert', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Lang1, 'Lang1', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Lang2, 'Lang2', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Lang3, 'Lang3', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Lang4, 'Lang4', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Lang5, 'Lang5', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Abort, 'Abort', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.Props, 'Props', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadParenLeft, 'NumpadParenLeft', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadParenRight, 'NumpadParenRight', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadBackspace, 'NumpadBackspace', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadMemoryStore, 'NumpadMemoryStore', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadMemoryRecall, 'NumpadMemoryRecall', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadMemoryClear, 'NumpadMemoryClear', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadMemoryAdd, 'NumpadMemoryAdd', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadMemorySubtract, 'NumpadMemorySubtract', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.NumpadClear, 'NumpadClear', KeyCode.Clear, 'Clear', 12, 'VK_CLEAR', empty, empty],
        [1, ScanCode.NumpadClearEntry, 'NumpadClearEntry', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.None, empty, KeyCode.Ctrl, 'Ctrl', 17, 'VK_CONTROL', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Shift, 'Shift', 16, 'VK_SHIFT', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Alt, 'Alt', 18, 'VK_MENU', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Meta, 'Meta', 91, 'VK_COMMAND', empty, empty],
        [1, ScanCode.ControlLeft, 'ControlLeft', KeyCode.Ctrl, empty, 0, 'VK_LCONTROL', empty, empty],
        [1, ScanCode.ShiftLeft, 'ShiftLeft', KeyCode.Shift, empty, 0, 'VK_LSHIFT', empty, empty],
        [1, ScanCode.AltLeft, 'AltLeft', KeyCode.Alt, empty, 0, 'VK_LMENU', empty, empty],
        [1, ScanCode.MetaLeft, 'MetaLeft', KeyCode.Meta, empty, 0, 'VK_LWIN', empty, empty],
        [1, ScanCode.ControlRight, 'ControlRight', KeyCode.Ctrl, empty, 0, 'VK_RCONTROL', empty, empty],
        [1, ScanCode.ShiftRight, 'ShiftRight', KeyCode.Shift, empty, 0, 'VK_RSHIFT', empty, empty],
        [1, ScanCode.AltRight, 'AltRight', KeyCode.Alt, empty, 0, 'VK_RMENU', empty, empty],
        [1, ScanCode.MetaRight, 'MetaRight', KeyCode.Meta, empty, 0, 'VK_RWIN', empty, empty],
        [1, ScanCode.BrightnessUp, 'BrightnessUp', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.BrightnessDown, 'BrightnessDown', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MediaPlay, 'MediaPlay', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MediaRecord, 'MediaRecord', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MediaFastForward, 'MediaFastForward', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MediaRewind, 'MediaRewind', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MediaTrackNext, 'MediaTrackNext', KeyCode.MediaTrackNext, 'MediaTrackNext', 176, 'VK_MEDIA_NEXT_TRACK', empty, empty],
        [1, ScanCode.MediaTrackPrevious, 'MediaTrackPrevious', KeyCode.MediaTrackPrevious, 'MediaTrackPrevious', 177, 'VK_MEDIA_PREV_TRACK', empty, empty],
        [1, ScanCode.MediaStop, 'MediaStop', KeyCode.MediaStop, 'MediaStop', 178, 'VK_MEDIA_STOP', empty, empty],
        [1, ScanCode.Eject, 'Eject', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MediaPlayPause, 'MediaPlayPause', KeyCode.MediaPlayPause, 'MediaPlayPause', 179, 'VK_MEDIA_PLAY_PAUSE', empty, empty],
        [1, ScanCode.MediaSelect, 'MediaSelect', KeyCode.LaunchMediaPlayer, 'LaunchMediaPlayer', 181, 'VK_MEDIA_LAUNCH_MEDIA_SELECT', empty, empty],
        [1, ScanCode.LaunchMail, 'LaunchMail', KeyCode.LaunchMail, 'LaunchMail', 180, 'VK_MEDIA_LAUNCH_MAIL', empty, empty],
        [1, ScanCode.LaunchApp2, 'LaunchApp2', KeyCode.LaunchApp2, 'LaunchApp2', 183, 'VK_MEDIA_LAUNCH_APP2', empty, empty],
        [1, ScanCode.LaunchApp1, 'LaunchApp1', KeyCode.Unknown, empty, 0, 'VK_MEDIA_LAUNCH_APP1', empty, empty],
        [1, ScanCode.SelectTask, 'SelectTask', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.LaunchScreenSaver, 'LaunchScreenSaver', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.BrowserSearch, 'BrowserSearch', KeyCode.BrowserSearch, 'BrowserSearch', 170, 'VK_BROWSER_SEARCH', empty, empty],
        [1, ScanCode.BrowserHome, 'BrowserHome', KeyCode.BrowserHome, 'BrowserHome', 172, 'VK_BROWSER_HOME', empty, empty],
        [1, ScanCode.BrowserBack, 'BrowserBack', KeyCode.BrowserBack, 'BrowserBack', 166, 'VK_BROWSER_BACK', empty, empty],
        [1, ScanCode.BrowserForward, 'BrowserForward', KeyCode.BrowserForward, 'BrowserForward', 167, 'VK_BROWSER_FORWARD', empty, empty],
        [1, ScanCode.BrowserStop, 'BrowserStop', KeyCode.Unknown, empty, 0, 'VK_BROWSER_STOP', empty, empty],
        [1, ScanCode.BrowserRefresh, 'BrowserRefresh', KeyCode.Unknown, empty, 0, 'VK_BROWSER_REFRESH', empty, empty],
        [1, ScanCode.BrowserFavorites, 'BrowserFavorites', KeyCode.Unknown, empty, 0, 'VK_BROWSER_FAVORITES', empty, empty],
        [1, ScanCode.ZoomToggle, 'ZoomToggle', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MailReply, 'MailReply', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MailForward, 'MailForward', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.MailSend, 'MailSend', KeyCode.Unknown, empty, 0, empty, empty, empty],
        [1, ScanCode.None, empty, KeyCode.KEY_IN_COMPOSITION, 'KeyInComposition', 229, empty, empty, empty],
        [1, ScanCode.None, empty, KeyCode.ABNT_C2, 'ABNT_C2', 194, 'VK_ABNT_C2', empty, empty],
        [1, ScanCode.None, empty, KeyCode.OEM_8, 'OEM_8', 223, 'VK_OEM_8', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_KANA', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_HANGUL', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_JUNJA', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_FINAL', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_HANJA', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_KANJI', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_CONVERT', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_NONCONVERT', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_ACCEPT', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_MODECHANGE', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_SELECT', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_PRINT', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_EXECUTE', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_SNAPSHOT', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_HELP', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_APPS', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_PROCESSKEY', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_PACKET', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_DBE_SBCSCHAR', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_DBE_DBCSCHAR', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_ATTN', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_CRSEL', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_EXSEL', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_EREOF', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_PLAY', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_ZOOM', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_NONAME', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_PA1', empty, empty],
        [1, ScanCode.None, empty, KeyCode.Unknown, empty, 0, 'VK_OEM_CLEAR', empty, empty],
    ];
    const seenKeyCode = [];
    const seenScanCode = [];
    for (const mapping of mappings) {
        const [immutable, scanCode, scanCodeStr, keyCode, keyCodeStr, eventKeyCode, vkey, usUserSettingsLabel, generalUserSettingsLabel] = mapping;
        if (!seenScanCode[scanCode]) {
            seenScanCode[scanCode] = true;
            scanCodeIntToStr[scanCode] = scanCodeStr;
            scanCodeStrToInt[scanCodeStr] = scanCode;
            scanCodeLowerCaseStrToInt[scanCodeStr.toLowerCase()] = scanCode;
            if (immutable) {
                IMMUTABLE_CODE_TO_KEY_CODE[scanCode] = keyCode;
                if ((keyCode !== KeyCode.Unknown)
                    && (keyCode !== KeyCode.Enter)
                    && (keyCode !== KeyCode.Ctrl)
                    && (keyCode !== KeyCode.Shift)
                    && (keyCode !== KeyCode.Alt)
                    && (keyCode !== KeyCode.Meta)) {
                    IMMUTABLE_KEY_CODE_TO_CODE[keyCode] = scanCode;
                }
            }
        }
        if (!seenKeyCode[keyCode]) {
            seenKeyCode[keyCode] = true;
            if (!keyCodeStr) {
                throw ( new Error(
                    `String representation missing for key code ${keyCode} around scan code ${scanCodeStr}`
                ));
            }
            uiMap.define(keyCode, keyCodeStr);
            userSettingsUSMap.define(keyCode, usUserSettingsLabel || keyCodeStr);
            userSettingsGeneralMap.define(keyCode, generalUserSettingsLabel || usUserSettingsLabel || keyCodeStr);
        }
        if (eventKeyCode) {
            EVENT_KEY_CODE_MAP[eventKeyCode] = keyCode;
        }
        if (vkey) {
            NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE[vkey] = keyCode;
        }
    }
    IMMUTABLE_KEY_CODE_TO_CODE[KeyCode.Enter] = ScanCode.Enter;
})();
var KeyCodeUtils;
( (function(KeyCodeUtils) {
    function toString(keyCode) {
        return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils.toString = toString;
    function fromString(key) {
        return uiMap.strToKeyCode(key);
    }
    KeyCodeUtils.fromString = fromString;
    function toUserSettingsUS(keyCode) {
        return userSettingsUSMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils.toUserSettingsUS = toUserSettingsUS;
    function toUserSettingsGeneral(keyCode) {
        return userSettingsGeneralMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils.toUserSettingsGeneral = toUserSettingsGeneral;
    function fromUserSettings(key) {
        return userSettingsUSMap.strToKeyCode(key) || userSettingsGeneralMap.strToKeyCode(key);
    }
    KeyCodeUtils.fromUserSettings = fromUserSettings;
    function toElectronAccelerator(keyCode) {
        if (keyCode >= KeyCode.Numpad0 && keyCode <= KeyCode.NumpadDivide) {
            return null;
        }
        switch (keyCode) {
            case KeyCode.UpArrow:
                return 'Up';
            case KeyCode.DownArrow:
                return 'Down';
            case KeyCode.LeftArrow:
                return 'Left';
            case KeyCode.RightArrow:
                return 'Right';
        }
        return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils.toElectronAccelerator = toElectronAccelerator;
})(KeyCodeUtils || (KeyCodeUtils = {})));
var KeyMod$1;
( (function(KeyMod) {
    KeyMod[KeyMod["CtrlCmd"] = 2048] = "CtrlCmd";
    KeyMod[KeyMod["Shift"] = 1024] = "Shift";
    KeyMod[KeyMod["Alt"] = 512] = "Alt";
    KeyMod[KeyMod["WinCtrl"] = 256] = "WinCtrl";
})(KeyMod$1 || (KeyMod$1 = {})));
function KeyChord(firstPart, secondPart) {
    const chordPart = ((secondPart & 0x0000FFFF) << 16) >>> 0;
    return (firstPart | chordPart) >>> 0;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/base/common/worker/simpleWorker.js":
/*!******************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/base/common/worker/simpleWorker.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SimpleWorkerClient: () => (/* binding */ SimpleWorkerClient),
/* harmony export */   SimpleWorkerServer: () => (/* binding */ SimpleWorkerServer),
/* harmony export */   logOnceWebWorkerWarning: () => (/* binding */ logOnceWebWorkerWarning)
/* harmony export */ });
/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _event_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _lifecycle_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../lifecycle.js */ "./node_modules/vscode/vscode/src/vs/base/common/lifecycle.js");
/* harmony import */ var _objects_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../objects.js */ "./node_modules/vscode/vscode/src/vs/base/common/objects.js");
/* harmony import */ var _platform_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../platform.js */ "./node_modules/vscode/vscode/src/vs/base/common/platform.js");
/* harmony import */ var _strings_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");






const INITIALIZE = '$initialize';
let webWorkerWarningLogged = false;
function logOnceWebWorkerWarning(err) {
    if (!_platform_js__WEBPACK_IMPORTED_MODULE_4__.isWeb) {
        return;
    }
    if (!webWorkerWarningLogged) {
        webWorkerWarningLogged = true;
        console.warn('Could not create web worker(s). Falling back to loading web worker code in main thread, which might cause UI freezes. Please see https://github.com/microsoft/monaco-editor#faq');
    }
    console.warn(err.message);
}
var MessageType;
( (function(MessageType) {
    MessageType[MessageType["Request"] = 0] = "Request";
    MessageType[MessageType["Reply"] = 1] = "Reply";
    MessageType[MessageType["SubscribeEvent"] = 2] = "SubscribeEvent";
    MessageType[MessageType["Event"] = 3] = "Event";
    MessageType[MessageType["UnsubscribeEvent"] = 4] = "UnsubscribeEvent";
})(MessageType || (MessageType = {})));
class RequestMessage {
    constructor(vsWorker, req, method, args) {
        this.vsWorker = vsWorker;
        this.req = req;
        this.method = method;
        this.args = args;
        this.type = MessageType.Request;
    }
}
class ReplyMessage {
    constructor(vsWorker, seq, res, err) {
        this.vsWorker = vsWorker;
        this.seq = seq;
        this.res = res;
        this.err = err;
        this.type = MessageType.Reply;
    }
}
class SubscribeEventMessage {
    constructor(vsWorker, req, eventName, arg) {
        this.vsWorker = vsWorker;
        this.req = req;
        this.eventName = eventName;
        this.arg = arg;
        this.type = MessageType.SubscribeEvent;
    }
}
class EventMessage {
    constructor(vsWorker, req, event) {
        this.vsWorker = vsWorker;
        this.req = req;
        this.event = event;
        this.type = MessageType.Event;
    }
}
class UnsubscribeEventMessage {
    constructor(vsWorker, req) {
        this.vsWorker = vsWorker;
        this.req = req;
        this.type = MessageType.UnsubscribeEvent;
    }
}
class SimpleWorkerProtocol {
    constructor(handler) {
        this._workerId = -1;
        this._handler = handler;
        this._lastSentReq = 0;
        this._pendingReplies = Object.create(null);
        this._pendingEmitters = ( new Map());
        this._pendingEvents = ( new Map());
    }
    setWorkerId(workerId) {
        this._workerId = workerId;
    }
    sendMessage(method, args) {
        const req = String(++this._lastSentReq);
        return ( new Promise((resolve, reject) => {
            this._pendingReplies[req] = {
                resolve: resolve,
                reject: reject
            };
            this._send(( new RequestMessage(this._workerId, req, method, args)));
        }));
    }
    listen(eventName, arg) {
        let req = null;
        const emitter = ( new _event_js__WEBPACK_IMPORTED_MODULE_1__.Emitter({
            onWillAddFirstListener: () => {
                req = String(++this._lastSentReq);
                this._pendingEmitters.set(req, emitter);
                this._send(( new SubscribeEventMessage(this._workerId, req, eventName, arg)));
            },
            onDidRemoveLastListener: () => {
                this._pendingEmitters.delete(req);
                this._send(( new UnsubscribeEventMessage(this._workerId, req)));
                req = null;
            }
        }));
        return emitter.event;
    }
    handleMessage(message) {
        if (!message || !message.vsWorker) {
            return;
        }
        if (this._workerId !== -1 && message.vsWorker !== this._workerId) {
            return;
        }
        this._handleMessage(message);
    }
    _handleMessage(msg) {
        switch (msg.type) {
            case MessageType.Reply:
                return this._handleReplyMessage(msg);
            case MessageType.Request:
                return this._handleRequestMessage(msg);
            case MessageType.SubscribeEvent:
                return this._handleSubscribeEventMessage(msg);
            case MessageType.Event:
                return this._handleEventMessage(msg);
            case MessageType.UnsubscribeEvent:
                return this._handleUnsubscribeEventMessage(msg);
        }
    }
    _handleReplyMessage(replyMessage) {
        if (!this._pendingReplies[replyMessage.seq]) {
            console.warn('Got reply to unknown seq');
            return;
        }
        const reply = this._pendingReplies[replyMessage.seq];
        delete this._pendingReplies[replyMessage.seq];
        if (replyMessage.err) {
            let err = replyMessage.err;
            if (replyMessage.err.$isError) {
                err = ( new Error());
                err.name = replyMessage.err.name;
                err.message = replyMessage.err.message;
                err.stack = replyMessage.err.stack;
            }
            reply.reject(err);
            return;
        }
        reply.resolve(replyMessage.res);
    }
    _handleRequestMessage(requestMessage) {
        const req = requestMessage.req;
        const result = this._handler.handleMessage(requestMessage.method, requestMessage.args);
        result.then((r) => {
            this._send(( new ReplyMessage(this._workerId, req, r, undefined)));
        }, (e) => {
            if (e.detail instanceof Error) {
                e.detail = (0,_errors_js__WEBPACK_IMPORTED_MODULE_0__.transformErrorForSerialization)(e.detail);
            }
            this._send(( new ReplyMessage(this._workerId, req, undefined, (0,_errors_js__WEBPACK_IMPORTED_MODULE_0__.transformErrorForSerialization)(e))));
        });
    }
    _handleSubscribeEventMessage(msg) {
        const req = msg.req;
        const disposable = this._handler.handleEvent(msg.eventName, msg.arg)((event) => {
            this._send(( new EventMessage(this._workerId, req, event)));
        });
        this._pendingEvents.set(req, disposable);
    }
    _handleEventMessage(msg) {
        if (!( this._pendingEmitters.has(msg.req))) {
            console.warn('Got event for unknown req');
            return;
        }
        this._pendingEmitters.get(msg.req).fire(msg.event);
    }
    _handleUnsubscribeEventMessage(msg) {
        if (!( this._pendingEvents.has(msg.req))) {
            console.warn('Got unsubscribe for unknown req');
            return;
        }
        this._pendingEvents.get(msg.req).dispose();
        this._pendingEvents.delete(msg.req);
    }
    _send(msg) {
        const transfer = [];
        if (msg.type === MessageType.Request) {
            for (let i = 0; i < msg.args.length; i++) {
                if (msg.args[i] instanceof ArrayBuffer) {
                    transfer.push(msg.args[i]);
                }
            }
        }
        else if (msg.type === MessageType.Reply) {
            if (msg.res instanceof ArrayBuffer) {
                transfer.push(msg.res);
            }
        }
        this._handler.sendMessage(msg, transfer);
    }
}
class SimpleWorkerClient extends _lifecycle_js__WEBPACK_IMPORTED_MODULE_2__.Disposable {
    constructor(workerFactory, moduleId, host) {
        super();
        let lazyProxyReject = null;
        this._worker = this._register(workerFactory.create('vs/base/common/worker/simpleWorker', (msg) => {
            this._protocol.handleMessage(msg);
        }, (err) => {
            lazyProxyReject?.(err);
        }));
        this._protocol = ( new SimpleWorkerProtocol({
            sendMessage: (msg, transfer) => {
                this._worker.postMessage(msg, transfer);
            },
            handleMessage: (method, args) => {
                if (typeof host[method] !== 'function') {
                    return Promise.reject(( new Error('Missing method ' + method + ' on main thread host.')));
                }
                try {
                    return Promise.resolve(host[method].apply(host, args));
                }
                catch (e) {
                    return Promise.reject(e);
                }
            },
            handleEvent: (eventName, arg) => {
                if (propertyIsDynamicEvent(eventName)) {
                    const event = host[eventName].call(host, arg);
                    if (typeof event !== 'function') {
                        throw ( new Error(`Missing dynamic event ${eventName} on main thread host.`));
                    }
                    return event;
                }
                if (propertyIsEvent(eventName)) {
                    const event = host[eventName];
                    if (typeof event !== 'function') {
                        throw ( new Error(`Missing event ${eventName} on main thread host.`));
                    }
                    return event;
                }
                throw ( new Error(`Malformed event name ${eventName}`));
            }
        }));
        this._protocol.setWorkerId(this._worker.getId());
        let loaderConfiguration = null;
        if (typeof globalThis.requirejs !== 'undefined') {
            loaderConfiguration = globalThis.requirejs.s.contexts._.config;
        }
        const hostMethods = (0,_objects_js__WEBPACK_IMPORTED_MODULE_3__.getAllMethodNames)(host);
        this._onModuleLoaded = this._protocol.sendMessage(INITIALIZE, [
            this._worker.getId(),
            JSON.parse(JSON.stringify(loaderConfiguration)),
            moduleId,
            hostMethods,
        ]);
        const proxyMethodRequest = (method, args) => {
            return this._request(method, args);
        };
        const proxyListen = (eventName, arg) => {
            return this._protocol.listen(eventName, arg);
        };
        this._lazyProxy = ( new Promise((resolve, reject) => {
            lazyProxyReject = reject;
            this._onModuleLoaded.then((availableMethods) => {
                resolve(createProxyObject(availableMethods, proxyMethodRequest, proxyListen));
            }, (e) => {
                reject(e);
                this._onError('Worker failed to load ' + moduleId, e);
            });
        }));
    }
    getProxyObject() {
        return this._lazyProxy;
    }
    _request(method, args) {
        return ( new Promise((resolve, reject) => {
            this._onModuleLoaded.then(() => {
                this._protocol.sendMessage(method, args).then(resolve, reject);
            }, reject);
        }));
    }
    _onError(message, error) {
        console.error(message);
        console.info(error);
    }
}
function propertyIsEvent(name) {
    return name[0] === 'o' && name[1] === 'n' && (0,_strings_js__WEBPACK_IMPORTED_MODULE_5__.isUpperAsciiLetter)(name.charCodeAt(2));
}
function propertyIsDynamicEvent(name) {
    return /^onDynamic/.test(name) && (0,_strings_js__WEBPACK_IMPORTED_MODULE_5__.isUpperAsciiLetter)(name.charCodeAt(9));
}
function createProxyObject(methodNames, invoke, proxyListen) {
    const createProxyMethod = (method) => {
        return function () {
            const args = Array.prototype.slice.call(arguments, 0);
            return invoke(method, args);
        };
    };
    const createProxyDynamicEvent = (eventName) => {
        return function (arg) {
            return proxyListen(eventName, arg);
        };
    };
    const result = {};
    for (const methodName of methodNames) {
        if (propertyIsDynamicEvent(methodName)) {
            result[methodName] = createProxyDynamicEvent(methodName);
            continue;
        }
        if (propertyIsEvent(methodName)) {
            result[methodName] = proxyListen(methodName, undefined);
            continue;
        }
        result[methodName] = createProxyMethod(methodName);
    }
    return result;
}
class SimpleWorkerServer {
    constructor(postMessage, requestHandlerFactory) {
        this._requestHandlerFactory = requestHandlerFactory;
        this._requestHandler = null;
        this._protocol = ( new SimpleWorkerProtocol({
            sendMessage: (msg, transfer) => {
                postMessage(msg, transfer);
            },
            handleMessage: (method, args) => this._handleMessage(method, args),
            handleEvent: (eventName, arg) => this._handleEvent(eventName, arg)
        }));
    }
    onmessage(msg) {
        this._protocol.handleMessage(msg);
    }
    _handleMessage(method, args) {
        if (method === INITIALIZE) {
            return this.initialize(args[0], args[1], args[2], args[3]);
        }
        if (!this._requestHandler || typeof this._requestHandler[method] !== 'function') {
            return Promise.reject(( new Error('Missing requestHandler or method: ' + method)));
        }
        try {
            return Promise.resolve(this._requestHandler[method].apply(this._requestHandler, args));
        }
        catch (e) {
            return Promise.reject(e);
        }
    }
    _handleEvent(eventName, arg) {
        if (!this._requestHandler) {
            throw ( new Error(`Missing requestHandler`));
        }
        if (propertyIsDynamicEvent(eventName)) {
            const event = this._requestHandler[eventName].call(this._requestHandler, arg);
            if (typeof event !== 'function') {
                throw ( new Error(`Missing dynamic event ${eventName} on request handler.`));
            }
            return event;
        }
        if (propertyIsEvent(eventName)) {
            const event = this._requestHandler[eventName];
            if (typeof event !== 'function') {
                throw ( new Error(`Missing event ${eventName} on request handler.`));
            }
            return event;
        }
        throw ( new Error(`Malformed event name ${eventName}`));
    }
    initialize(workerId, loaderConfig, moduleId, hostMethods) {
        this._protocol.setWorkerId(workerId);
        const proxyMethodRequest = (method, args) => {
            return this._protocol.sendMessage(method, args);
        };
        const proxyListen = (eventName, arg) => {
            return this._protocol.listen(eventName, arg);
        };
        const hostProxy = createProxyObject(hostMethods, proxyMethodRequest, proxyListen);
        if (this._requestHandlerFactory) {
            this._requestHandler = this._requestHandlerFactory(hostProxy);
            return Promise.resolve((0,_objects_js__WEBPACK_IMPORTED_MODULE_3__.getAllMethodNames)(this._requestHandler));
        }
        if (loaderConfig) {
            if (typeof loaderConfig.baseUrl !== 'undefined') {
                delete loaderConfig['baseUrl'];
            }
            if (typeof loaderConfig.paths !== 'undefined') {
                if (typeof loaderConfig.paths.vs !== 'undefined') {
                    delete loaderConfig.paths['vs'];
                }
            }
            if (typeof loaderConfig.trustedTypesPolicy !== 'undefined') {
                delete loaderConfig['trustedTypesPolicy'];
            }
            loaderConfig.catchError = true;
            globalThis.require.config(loaderConfig);
        }
        return ( new Promise((resolve, reject) => {
            const req = undefined;
            req([moduleId], (module) => {
                this._requestHandler = module.create(hostProxy);
                if (!this._requestHandler) {
                    reject(( new Error(`No RequestHandler!`)));
                    return;
                }
                resolve((0,_objects_js__WEBPACK_IMPORTED_MODULE_3__.getAllMethodNames)(this._requestHandler));
            }, reject);
        }));
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/lineRange.js":
/*!***************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/lineRange.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineRange: () => (/* binding */ LineRange),
/* harmony export */   LineRangeSet: () => (/* binding */ LineRangeSet)
/* harmony export */ });
/* harmony import */ var _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _offsetRange_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");
/* harmony import */ var _range_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../base/common/arraysFind.js */ "./node_modules/vscode/vscode/src/vs/base/common/arraysFind.js");




class LineRange {
    static fromRange(range) {
        return ( new LineRange(range.startLineNumber, range.endLineNumber));
    }
    static fromRangeInclusive(range) {
        return ( new LineRange(range.startLineNumber, range.endLineNumber + 1));
    }
    static subtract(a, b) {
        if (!b) {
            return [a];
        }
        if (a.startLineNumber < b.startLineNumber && b.endLineNumberExclusive < a.endLineNumberExclusive) {
            return [
                ( new LineRange(a.startLineNumber, b.startLineNumber)),
                ( new LineRange(b.endLineNumberExclusive, a.endLineNumberExclusive))
            ];
        }
        else if (b.startLineNumber <= a.startLineNumber && a.endLineNumberExclusive <= b.endLineNumberExclusive) {
            return [];
        }
        else if (b.endLineNumberExclusive < a.endLineNumberExclusive) {
            return [( new LineRange(
                Math.max(b.endLineNumberExclusive, a.startLineNumber),
                a.endLineNumberExclusive
            ))];
        }
        else {
            return [( new LineRange(a.startLineNumber, Math.min(b.startLineNumber, a.endLineNumberExclusive)))];
        }
    }
    static joinMany(lineRanges) {
        if (lineRanges.length === 0) {
            return [];
        }
        let result = ( new LineRangeSet(lineRanges[0].slice()));
        for (let i = 1; i < lineRanges.length; i++) {
            result = result.getUnion(( new LineRangeSet(lineRanges[i].slice())));
        }
        return result.ranges;
    }
    static join(lineRanges) {
        if (lineRanges.length === 0) {
            throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__.BugIndicatingError('lineRanges cannot be empty'));
        }
        let startLineNumber = lineRanges[0].startLineNumber;
        let endLineNumberExclusive = lineRanges[0].endLineNumberExclusive;
        for (let i = 1; i < lineRanges.length; i++) {
            startLineNumber = Math.min(startLineNumber, lineRanges[i].startLineNumber);
            endLineNumberExclusive = Math.max(endLineNumberExclusive, lineRanges[i].endLineNumberExclusive);
        }
        return ( new LineRange(startLineNumber, endLineNumberExclusive));
    }
    static ofLength(startLineNumber, length) {
        return ( new LineRange(startLineNumber, startLineNumber + length));
    }
    static deserialize(lineRange) {
        return ( new LineRange(lineRange[0], lineRange[1]));
    }
    constructor(startLineNumber, endLineNumberExclusive) {
        if (startLineNumber > endLineNumberExclusive) {
            throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__.BugIndicatingError(
                `startLineNumber ${startLineNumber} cannot be after endLineNumberExclusive ${endLineNumberExclusive}`
            ));
        }
        this.startLineNumber = startLineNumber;
        this.endLineNumberExclusive = endLineNumberExclusive;
    }
    contains(lineNumber) {
        return this.startLineNumber <= lineNumber && lineNumber < this.endLineNumberExclusive;
    }
    get isEmpty() {
        return this.startLineNumber === this.endLineNumberExclusive;
    }
    delta(offset) {
        return ( new LineRange(this.startLineNumber + offset, this.endLineNumberExclusive + offset));
    }
    deltaLength(offset) {
        return ( new LineRange(this.startLineNumber, this.endLineNumberExclusive + offset));
    }
    get length() {
        return this.endLineNumberExclusive - this.startLineNumber;
    }
    join(other) {
        return ( new LineRange(
            Math.min(this.startLineNumber, other.startLineNumber),
            Math.max(this.endLineNumberExclusive, other.endLineNumberExclusive)
        ));
    }
    toString() {
        return `[${this.startLineNumber},${this.endLineNumberExclusive})`;
    }
    intersect(other) {
        const startLineNumber = Math.max(this.startLineNumber, other.startLineNumber);
        const endLineNumberExclusive = Math.min(this.endLineNumberExclusive, other.endLineNumberExclusive);
        if (startLineNumber <= endLineNumberExclusive) {
            return ( new LineRange(startLineNumber, endLineNumberExclusive));
        }
        return undefined;
    }
    intersectsStrict(other) {
        return this.startLineNumber < other.endLineNumberExclusive && other.startLineNumber < this.endLineNumberExclusive;
    }
    overlapOrTouch(other) {
        return this.startLineNumber <= other.endLineNumberExclusive && other.startLineNumber <= this.endLineNumberExclusive;
    }
    equals(b) {
        return this.startLineNumber === b.startLineNumber && this.endLineNumberExclusive === b.endLineNumberExclusive;
    }
    toInclusiveRange() {
        if (this.isEmpty) {
            return null;
        }
        return ( new _range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
            this.startLineNumber,
            1,
            this.endLineNumberExclusive - 1,
            Number.MAX_SAFE_INTEGER
        ));
    }
    toExclusiveRange() {
        return ( new _range_js__WEBPACK_IMPORTED_MODULE_2__.Range(this.startLineNumber, 1, this.endLineNumberExclusive, 1));
    }
    mapToLineArray(f) {
        const result = [];
        for (let lineNumber = this.startLineNumber; lineNumber < this.endLineNumberExclusive; lineNumber++) {
            result.push(f(lineNumber));
        }
        return result;
    }
    forEach(f) {
        for (let lineNumber = this.startLineNumber; lineNumber < this.endLineNumberExclusive; lineNumber++) {
            f(lineNumber);
        }
    }
    serialize() {
        return [this.startLineNumber, this.endLineNumberExclusive];
    }
    includes(lineNumber) {
        return this.startLineNumber <= lineNumber && lineNumber < this.endLineNumberExclusive;
    }
    toOffsetRange() {
        return ( new _offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(this.startLineNumber - 1, this.endLineNumberExclusive - 1));
    }
}
class LineRangeSet {
    constructor(
    _normalizedRanges = []) {
        this._normalizedRanges = _normalizedRanges;
    }
    get ranges() {
        return this._normalizedRanges;
    }
    addRange(range) {
        if (range.length === 0) {
            return;
        }
        const joinRangeStartIdx = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findFirstIdxMonotonousOrArrLen)(this._normalizedRanges, r => r.endLineNumberExclusive >= range.startLineNumber);
        const joinRangeEndIdxExclusive = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findLastIdxMonotonous)(this._normalizedRanges, r => r.startLineNumber <= range.endLineNumberExclusive) + 1;
        if (joinRangeStartIdx === joinRangeEndIdxExclusive) {
            this._normalizedRanges.splice(joinRangeStartIdx, 0, range);
        }
        else if (joinRangeStartIdx === joinRangeEndIdxExclusive - 1) {
            const joinRange = this._normalizedRanges[joinRangeStartIdx];
            this._normalizedRanges[joinRangeStartIdx] = joinRange.join(range);
        }
        else {
            const joinRange = this._normalizedRanges[joinRangeStartIdx].join(this._normalizedRanges[joinRangeEndIdxExclusive - 1]).join(range);
            this._normalizedRanges.splice(joinRangeStartIdx, joinRangeEndIdxExclusive - joinRangeStartIdx, joinRange);
        }
    }
    contains(lineNumber) {
        const rangeThatStartsBeforeEnd = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findLastMonotonous)(this._normalizedRanges, r => r.startLineNumber <= lineNumber);
        return !!rangeThatStartsBeforeEnd && rangeThatStartsBeforeEnd.endLineNumberExclusive > lineNumber;
    }
    intersects(range) {
        const rangeThatStartsBeforeEnd = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findLastMonotonous)(this._normalizedRanges, r => r.startLineNumber < range.endLineNumberExclusive);
        return !!rangeThatStartsBeforeEnd && rangeThatStartsBeforeEnd.endLineNumberExclusive > range.startLineNumber;
    }
    getUnion(other) {
        if (this._normalizedRanges.length === 0) {
            return other;
        }
        if (other._normalizedRanges.length === 0) {
            return this;
        }
        const result = [];
        let i1 = 0;
        let i2 = 0;
        let current = null;
        while (i1 < this._normalizedRanges.length || i2 < other._normalizedRanges.length) {
            let next = null;
            if (i1 < this._normalizedRanges.length && i2 < other._normalizedRanges.length) {
                const lineRange1 = this._normalizedRanges[i1];
                const lineRange2 = other._normalizedRanges[i2];
                if (lineRange1.startLineNumber < lineRange2.startLineNumber) {
                    next = lineRange1;
                    i1++;
                }
                else {
                    next = lineRange2;
                    i2++;
                }
            }
            else if (i1 < this._normalizedRanges.length) {
                next = this._normalizedRanges[i1];
                i1++;
            }
            else {
                next = other._normalizedRanges[i2];
                i2++;
            }
            if (current === null) {
                current = next;
            }
            else {
                if (current.endLineNumberExclusive >= next.startLineNumber) {
                    current = ( new LineRange(
                        current.startLineNumber,
                        Math.max(current.endLineNumberExclusive, next.endLineNumberExclusive)
                    ));
                }
                else {
                    result.push(current);
                    current = next;
                }
            }
        }
        if (current !== null) {
            result.push(current);
        }
        return ( new LineRangeSet(result));
    }
    subtractFrom(range) {
        const joinRangeStartIdx = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findFirstIdxMonotonousOrArrLen)(this._normalizedRanges, r => r.endLineNumberExclusive >= range.startLineNumber);
        const joinRangeEndIdxExclusive = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findLastIdxMonotonous)(this._normalizedRanges, r => r.startLineNumber <= range.endLineNumberExclusive) + 1;
        if (joinRangeStartIdx === joinRangeEndIdxExclusive) {
            return ( new LineRangeSet([range]));
        }
        const result = [];
        let startLineNumber = range.startLineNumber;
        for (let i = joinRangeStartIdx; i < joinRangeEndIdxExclusive; i++) {
            const r = this._normalizedRanges[i];
            if (r.startLineNumber > startLineNumber) {
                result.push(( new LineRange(startLineNumber, r.startLineNumber)));
            }
            startLineNumber = r.endLineNumberExclusive;
        }
        if (startLineNumber < range.endLineNumberExclusive) {
            result.push(( new LineRange(startLineNumber, range.endLineNumberExclusive)));
        }
        return ( new LineRangeSet(result));
    }
    toString() {
        return ( this._normalizedRanges.map(r => ( r.toString()))).join(', ');
    }
    getIntersection(other) {
        const result = [];
        let i1 = 0;
        let i2 = 0;
        while (i1 < this._normalizedRanges.length && i2 < other._normalizedRanges.length) {
            const r1 = this._normalizedRanges[i1];
            const r2 = other._normalizedRanges[i2];
            const i = r1.intersect(r2);
            if (i && !i.isEmpty) {
                result.push(i);
            }
            if (r1.endLineNumberExclusive < r2.endLineNumberExclusive) {
                i1++;
            }
            else {
                i2++;
            }
        }
        return ( new LineRangeSet(result));
    }
    getWithDelta(value) {
        return ( new LineRangeSet(( this._normalizedRanges.map(r => r.delta(value)))));
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OffsetRange: () => (/* binding */ OffsetRange),
/* harmony export */   OffsetRangeSet: () => (/* binding */ OffsetRangeSet)
/* harmony export */ });
/* harmony import */ var _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");

class OffsetRange {
    static addRange(range, sortedRanges) {
        let i = 0;
        while (i < sortedRanges.length && sortedRanges[i].endExclusive < range.start) {
            i++;
        }
        let j = i;
        while (j < sortedRanges.length && sortedRanges[j].start <= range.endExclusive) {
            j++;
        }
        if (i === j) {
            sortedRanges.splice(i, 0, range);
        }
        else {
            const start = Math.min(range.start, sortedRanges[i].start);
            const end = Math.max(range.endExclusive, sortedRanges[j - 1].endExclusive);
            sortedRanges.splice(i, j - i, ( new OffsetRange(start, end)));
        }
    }
    static tryCreate(start, endExclusive) {
        if (start > endExclusive) {
            return undefined;
        }
        return ( new OffsetRange(start, endExclusive));
    }
    static ofLength(length) {
        return ( new OffsetRange(0, length));
    }
    static ofStartAndLength(start, length) {
        return ( new OffsetRange(start, start + length));
    }
    constructor(start, endExclusive) {
        this.start = start;
        this.endExclusive = endExclusive;
        if (start > endExclusive) {
            throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__.BugIndicatingError(`Invalid range: ${( this.toString())}`));
        }
    }
    get isEmpty() {
        return this.start === this.endExclusive;
    }
    delta(offset) {
        return ( new OffsetRange(this.start + offset, this.endExclusive + offset));
    }
    deltaStart(offset) {
        return ( new OffsetRange(this.start + offset, this.endExclusive));
    }
    deltaEnd(offset) {
        return ( new OffsetRange(this.start, this.endExclusive + offset));
    }
    get length() {
        return this.endExclusive - this.start;
    }
    toString() {
        return `[${this.start}, ${this.endExclusive})`;
    }
    equals(other) {
        return this.start === other.start && this.endExclusive === other.endExclusive;
    }
    containsRange(other) {
        return this.start <= other.start && other.endExclusive <= this.endExclusive;
    }
    contains(offset) {
        return this.start <= offset && offset < this.endExclusive;
    }
    join(other) {
        return ( new OffsetRange(
            Math.min(this.start, other.start),
            Math.max(this.endExclusive, other.endExclusive)
        ));
    }
    intersect(other) {
        const start = Math.max(this.start, other.start);
        const end = Math.min(this.endExclusive, other.endExclusive);
        if (start <= end) {
            return ( new OffsetRange(start, end));
        }
        return undefined;
    }
    intersects(other) {
        const start = Math.max(this.start, other.start);
        const end = Math.min(this.endExclusive, other.endExclusive);
        return start < end;
    }
    intersectsOrTouches(other) {
        const start = Math.max(this.start, other.start);
        const end = Math.min(this.endExclusive, other.endExclusive);
        return start <= end;
    }
    isBefore(other) {
        return this.endExclusive <= other.start;
    }
    isAfter(other) {
        return this.start >= other.endExclusive;
    }
    slice(arr) {
        return arr.slice(this.start, this.endExclusive);
    }
    substring(str) {
        return str.substring(this.start, this.endExclusive);
    }
    clip(value) {
        if (this.isEmpty) {
            throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__.BugIndicatingError(`Invalid clipping range: ${( this.toString())}`));
        }
        return Math.max(this.start, Math.min(this.endExclusive - 1, value));
    }
    clipCyclic(value) {
        if (this.isEmpty) {
            throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__.BugIndicatingError(`Invalid clipping range: ${( this.toString())}`));
        }
        if (value < this.start) {
            return this.endExclusive - ((this.start - value) % this.length);
        }
        if (value >= this.endExclusive) {
            return this.start + ((value - this.start) % this.length);
        }
        return value;
    }
    map(f) {
        const result = [];
        for (let i = this.start; i < this.endExclusive; i++) {
            result.push(f(i));
        }
        return result;
    }
    forEach(f) {
        for (let i = this.start; i < this.endExclusive; i++) {
            f(i);
        }
    }
}
class OffsetRangeSet {
    constructor() {
        this._sortedRanges = [];
    }
    addRange(range) {
        let i = 0;
        while (i < this._sortedRanges.length && this._sortedRanges[i].endExclusive < range.start) {
            i++;
        }
        let j = i;
        while (j < this._sortedRanges.length && this._sortedRanges[j].start <= range.endExclusive) {
            j++;
        }
        if (i === j) {
            this._sortedRanges.splice(i, 0, range);
        }
        else {
            const start = Math.min(range.start, this._sortedRanges[i].start);
            const end = Math.max(range.endExclusive, this._sortedRanges[j - 1].endExclusive);
            this._sortedRanges.splice(i, j - i, ( new OffsetRange(start, end)));
        }
    }
    toString() {
        return ( this._sortedRanges.map(r => ( r.toString()))).join(', ');
    }
    intersectsStrict(other) {
        let i = 0;
        while (i < this._sortedRanges.length && this._sortedRanges[i].endExclusive <= other.start) {
            i++;
        }
        return i < this._sortedRanges.length && this._sortedRanges[i].start < other.endExclusive;
    }
    intersectWithRange(other) {
        const result = ( new OffsetRangeSet());
        for (const range of this._sortedRanges) {
            const intersection = range.intersect(other);
            if (intersection) {
                result.addRange(intersection);
            }
        }
        return result;
    }
    intersectWithRangeLength(other) {
        return this.intersectWithRange(other).length;
    }
    get length() {
        return this._sortedRanges.reduce((prev, cur) => prev + cur.length, 0);
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/positionToOffset.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/positionToOffset.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PositionOffsetTransformer: () => (/* binding */ PositionOffsetTransformer)
/* harmony export */ });
/* harmony import */ var _base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/arraysFind.js */ "./node_modules/vscode/vscode/src/vs/base/common/arraysFind.js");
/* harmony import */ var _offsetRange_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");
/* harmony import */ var _position_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./position.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/position.js");
/* harmony import */ var _range_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _textLength_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./textLength.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/textLength.js");





class PositionOffsetTransformer {
    constructor(text) {
        this.text = text;
        this.lineStartOffsetByLineIdx = [];
        this.lineStartOffsetByLineIdx.push(0);
        for (let i = 0; i < text.length; i++) {
            if (text.charAt(i) === '\n') {
                this.lineStartOffsetByLineIdx.push(i + 1);
            }
        }
    }
    getOffset(position) {
        return this.lineStartOffsetByLineIdx[position.lineNumber - 1] + position.column - 1;
    }
    getOffsetRange(range) {
        return ( new _offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(
            this.getOffset(range.getStartPosition()),
            this.getOffset(range.getEndPosition())
        ));
    }
    getPosition(offset) {
        const idx = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_0__.findLastIdxMonotonous)(this.lineStartOffsetByLineIdx, i => i <= offset);
        const lineNumber = idx + 1;
        const column = offset - this.lineStartOffsetByLineIdx[idx] + 1;
        return ( new _position_js__WEBPACK_IMPORTED_MODULE_2__.Position(lineNumber, column));
    }
    getRange(offsetRange) {
        return _range_js__WEBPACK_IMPORTED_MODULE_3__.Range.fromPositions(this.getPosition(offsetRange.start), this.getPosition(offsetRange.endExclusive));
    }
    getTextLength(offsetRange) {
        return _textLength_js__WEBPACK_IMPORTED_MODULE_4__.TextLength.ofRange(this.getRange(offsetRange));
    }
    get textLength() {
        const lineIdx = this.lineStartOffsetByLineIdx.length - 1;
        return ( new _textLength_js__WEBPACK_IMPORTED_MODULE_4__.TextLength(lineIdx, this.text.length - this.lineStartOffsetByLineIdx[lineIdx]));
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/textEdit.js":
/*!**************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/textEdit.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractText: () => (/* binding */ AbstractText),
/* harmony export */   SingleTextEdit: () => (/* binding */ SingleTextEdit),
/* harmony export */   StringText: () => (/* binding */ StringText),
/* harmony export */   TextEdit: () => (/* binding */ TextEdit)
/* harmony export */ });
/* harmony import */ var _base_common_assert_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/assert.js */ "./node_modules/vscode/vscode/src/vs/base/common/assert.js");
/* harmony import */ var _base_common_errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _position_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./position.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/position.js");
/* harmony import */ var _positionToOffset_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./positionToOffset.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/positionToOffset.js");
/* harmony import */ var _range_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _textLength_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./textLength.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/textLength.js");






class TextEdit {
    static single(originalRange, newText) {
        return ( new TextEdit([( new SingleTextEdit(originalRange, newText))]));
    }
    constructor(edits) {
        this.edits = edits;
        (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_0__.assertFn)(() => (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_0__.checkAdjacentItems)(edits, (a, b) => a.range.getEndPosition().isBeforeOrEqual(b.range.getStartPosition())));
    }
    normalize() {
        const edits = [];
        for (const edit of this.edits) {
            if (edits.length > 0 && edits[edits.length - 1].range.getEndPosition().equals(edit.range.getStartPosition())) {
                const last = edits[edits.length - 1];
                edits[edits.length - 1] = ( new SingleTextEdit(last.range.plusRange(edit.range), last.text + edit.text));
            }
            else if (!edit.isEmpty) {
                edits.push(edit);
            }
        }
        return ( new TextEdit(edits));
    }
    mapPosition(position) {
        let lineDelta = 0;
        let curLine = 0;
        let columnDeltaInCurLine = 0;
        for (const edit of this.edits) {
            const start = edit.range.getStartPosition();
            const end = edit.range.getEndPosition();
            if (position.isBeforeOrEqual(start)) {
                break;
            }
            const len = _textLength_js__WEBPACK_IMPORTED_MODULE_5__.TextLength.ofText(edit.text);
            if (position.isBefore(end)) {
                const startPos = ( new _position_js__WEBPACK_IMPORTED_MODULE_2__.Position(
                    start.lineNumber + lineDelta,
                    start.column + (start.lineNumber + lineDelta === curLine ? columnDeltaInCurLine : 0)
                ));
                const endPos = len.addToPosition(startPos);
                return rangeFromPositions(startPos, endPos);
            }
            lineDelta += len.lineCount - (edit.range.endLineNumber - edit.range.startLineNumber);
            if (len.lineCount === 0) {
                if (end.lineNumber !== start.lineNumber) {
                    columnDeltaInCurLine += len.columnCount - (end.column - 1);
                }
                else {
                    columnDeltaInCurLine += len.columnCount - (end.column - start.column);
                }
            }
            else {
                columnDeltaInCurLine = len.columnCount;
            }
            curLine = end.lineNumber + lineDelta;
        }
        return ( new _position_js__WEBPACK_IMPORTED_MODULE_2__.Position(
            position.lineNumber + lineDelta,
            position.column + (position.lineNumber + lineDelta === curLine ? columnDeltaInCurLine : 0)
        ));
    }
    mapRange(range) {
        function getStart(p) {
            return p instanceof _position_js__WEBPACK_IMPORTED_MODULE_2__.Position ? p : p.getStartPosition();
        }
        function getEnd(p) {
            return p instanceof _position_js__WEBPACK_IMPORTED_MODULE_2__.Position ? p : p.getEndPosition();
        }
        const start = getStart(this.mapPosition(range.getStartPosition()));
        const end = getEnd(this.mapPosition(range.getEndPosition()));
        return rangeFromPositions(start, end);
    }
    inverseMapPosition(positionAfterEdit, doc) {
        const reversed = this.inverse(doc);
        return reversed.mapPosition(positionAfterEdit);
    }
    inverseMapRange(range, doc) {
        const reversed = this.inverse(doc);
        return reversed.mapRange(range);
    }
    apply(text) {
        let result = '';
        let lastEditEnd = ( new _position_js__WEBPACK_IMPORTED_MODULE_2__.Position(1, 1));
        for (const edit of this.edits) {
            const editRange = edit.range;
            const editStart = editRange.getStartPosition();
            const editEnd = editRange.getEndPosition();
            const r = rangeFromPositions(lastEditEnd, editStart);
            if (!r.isEmpty()) {
                result += text.getValueOfRange(r);
            }
            result += edit.text;
            lastEditEnd = editEnd;
        }
        const r = rangeFromPositions(lastEditEnd, text.endPositionExclusive);
        if (!r.isEmpty()) {
            result += text.getValueOfRange(r);
        }
        return result;
    }
    applyToString(str) {
        const strText = ( new StringText(str));
        return this.apply(strText);
    }
    inverse(doc) {
        const ranges = this.getNewRanges();
        return ( new TextEdit(( this.edits.map((e, idx) => ( new SingleTextEdit(ranges[idx], doc.getValueOfRange(e.range)))))));
    }
    getNewRanges() {
        const newRanges = [];
        let previousEditEndLineNumber = 0;
        let lineOffset = 0;
        let columnOffset = 0;
        for (const edit of this.edits) {
            const textLength = _textLength_js__WEBPACK_IMPORTED_MODULE_5__.TextLength.ofText(edit.text);
            const newRangeStart = _position_js__WEBPACK_IMPORTED_MODULE_2__.Position.lift({
                lineNumber: edit.range.startLineNumber + lineOffset,
                column: edit.range.startColumn + (edit.range.startLineNumber === previousEditEndLineNumber ? columnOffset : 0)
            });
            const newRange = textLength.createRange(newRangeStart);
            newRanges.push(newRange);
            lineOffset = newRange.endLineNumber - edit.range.endLineNumber;
            columnOffset = newRange.endColumn - edit.range.endColumn;
            previousEditEndLineNumber = edit.range.endLineNumber;
        }
        return newRanges;
    }
}
class SingleTextEdit {
    constructor(range, text) {
        this.range = range;
        this.text = text;
    }
    get isEmpty() {
        return this.range.isEmpty() && this.text.length === 0;
    }
    static equals(first, second) {
        return first.range.equalsRange(second.range) && first.text === second.text;
    }
    toSingleEditOperation() {
        return {
            range: this.range,
            text: this.text,
        };
    }
}
function rangeFromPositions(start, end) {
    if (start.lineNumber === end.lineNumber && start.column === Number.MAX_SAFE_INTEGER) {
        return _range_js__WEBPACK_IMPORTED_MODULE_4__.Range.fromPositions(end, end);
    }
    else if (!start.isBeforeOrEqual(end)) {
        throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_1__.BugIndicatingError('start must be before end'));
    }
    return ( new _range_js__WEBPACK_IMPORTED_MODULE_4__.Range(start.lineNumber, start.column, end.lineNumber, end.column));
}
class AbstractText {
    get endPositionExclusive() {
        return this.length.addToPosition(( new _position_js__WEBPACK_IMPORTED_MODULE_2__.Position(1, 1)));
    }
    getValue() {
        return this.getValueOfRange(this.length.toRange());
    }
}
class StringText extends AbstractText {
    constructor(value) {
        super();
        this.value = value;
        this._t = ( new _positionToOffset_js__WEBPACK_IMPORTED_MODULE_3__.PositionOffsetTransformer(this.value));
    }
    getValueOfRange(range) {
        return this._t.getOffsetRange(range).substring(this.value);
    }
    get length() {
        return this._t.textLength;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/core/textLength.js":
/*!****************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/core/textLength.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextLength: () => (/* binding */ TextLength)
/* harmony export */ });
/* harmony import */ var _position_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./position.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/position.js");
/* harmony import */ var _range_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");


class TextLength {
    static { this.zero = ( new TextLength(0, 0)); }
    static lengthDiffNonNegative(start, end) {
        if (end.isLessThan(start)) {
            return TextLength.zero;
        }
        if (start.lineCount === end.lineCount) {
            return ( new TextLength(0, end.columnCount - start.columnCount));
        }
        else {
            return ( new TextLength(end.lineCount - start.lineCount, end.columnCount));
        }
    }
    static betweenPositions(position1, position2) {
        if (position1.lineNumber === position2.lineNumber) {
            return ( new TextLength(0, position2.column - position1.column));
        }
        else {
            return ( new TextLength(position2.lineNumber - position1.lineNumber, position2.column - 1));
        }
    }
    static ofRange(range) {
        return TextLength.betweenPositions(range.getStartPosition(), range.getEndPosition());
    }
    static ofText(text) {
        let line = 0;
        let column = 0;
        for (const c of text) {
            if (c === '\n') {
                line++;
                column = 0;
            }
            else {
                column++;
            }
        }
        return ( new TextLength(line, column));
    }
    constructor(lineCount, columnCount) {
        this.lineCount = lineCount;
        this.columnCount = columnCount;
    }
    isZero() {
        return this.lineCount === 0 && this.columnCount === 0;
    }
    isLessThan(other) {
        if (this.lineCount !== other.lineCount) {
            return this.lineCount < other.lineCount;
        }
        return this.columnCount < other.columnCount;
    }
    isGreaterThan(other) {
        if (this.lineCount !== other.lineCount) {
            return this.lineCount > other.lineCount;
        }
        return this.columnCount > other.columnCount;
    }
    isGreaterThanOrEqualTo(other) {
        if (this.lineCount !== other.lineCount) {
            return this.lineCount > other.lineCount;
        }
        return this.columnCount >= other.columnCount;
    }
    equals(other) {
        return this.lineCount === other.lineCount && this.columnCount === other.columnCount;
    }
    compare(other) {
        if (this.lineCount !== other.lineCount) {
            return this.lineCount - other.lineCount;
        }
        return this.columnCount - other.columnCount;
    }
    add(other) {
        if (other.lineCount === 0) {
            return ( new TextLength(this.lineCount, this.columnCount + other.columnCount));
        }
        else {
            return ( new TextLength(this.lineCount + other.lineCount, other.columnCount));
        }
    }
    createRange(startPosition) {
        if (this.lineCount === 0) {
            return ( new _range_js__WEBPACK_IMPORTED_MODULE_1__.Range(
                startPosition.lineNumber,
                startPosition.column,
                startPosition.lineNumber,
                startPosition.column + this.columnCount
            ));
        }
        else {
            return ( new _range_js__WEBPACK_IMPORTED_MODULE_1__.Range(
                startPosition.lineNumber,
                startPosition.column,
                startPosition.lineNumber + this.lineCount,
                this.columnCount + 1
            ));
        }
    }
    toRange() {
        return ( new _range_js__WEBPACK_IMPORTED_MODULE_1__.Range(1, 1, this.lineCount + 1, this.columnCount + 1));
    }
    addToPosition(position) {
        if (this.lineCount === 0) {
            return ( new _position_js__WEBPACK_IMPORTED_MODULE_0__.Position(position.lineNumber, position.column + this.columnCount));
        }
        else {
            return ( new _position_js__WEBPACK_IMPORTED_MODULE_0__.Position(position.lineNumber + this.lineCount, this.columnCount + 1));
        }
    }
    toString() {
        return `${this.lineCount},${this.columnCount}`;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/diffAlgorithm.js":
/*!*******************************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/diffAlgorithm.js ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DateTimeout: () => (/* binding */ DateTimeout),
/* harmony export */   DiffAlgorithmResult: () => (/* binding */ DiffAlgorithmResult),
/* harmony export */   InfiniteTimeout: () => (/* binding */ InfiniteTimeout),
/* harmony export */   OffsetPair: () => (/* binding */ OffsetPair),
/* harmony export */   SequenceDiff: () => (/* binding */ SequenceDiff)
/* harmony export */ });
/* harmony import */ var _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../base/common/arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _base_common_errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../base/common/errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core/offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");



class DiffAlgorithmResult {
    static trivial(seq1, seq2) {
        return ( new DiffAlgorithmResult([( new SequenceDiff(_core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange.ofLength(seq1.length), _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange.ofLength(seq2.length)))], false));
    }
    static trivialTimedOut(seq1, seq2) {
        return ( new DiffAlgorithmResult([( new SequenceDiff(_core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange.ofLength(seq1.length), _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange.ofLength(seq2.length)))], true));
    }
    constructor(diffs,
    hitTimeout) {
        this.diffs = diffs;
        this.hitTimeout = hitTimeout;
    }
}
class SequenceDiff {
    static invert(sequenceDiffs, doc1Length) {
        const result = [];
        (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.forEachAdjacent)(sequenceDiffs, (a, b) => {
            result.push(SequenceDiff.fromOffsetPairs(a ? a.getEndExclusives() : OffsetPair.zero, b ? b.getStarts() : ( new OffsetPair(
                doc1Length,
                (a ? a.seq2Range.endExclusive - a.seq1Range.endExclusive : 0) + doc1Length
            ))));
        });
        return result;
    }
    static fromOffsetPairs(start, endExclusive) {
        return ( new SequenceDiff(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange(start.offset1, endExclusive.offset1)), ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange(start.offset2, endExclusive.offset2))));
    }
    constructor(seq1Range, seq2Range) {
        this.seq1Range = seq1Range;
        this.seq2Range = seq2Range;
    }
    swap() {
        return ( new SequenceDiff(this.seq2Range, this.seq1Range));
    }
    toString() {
        return `${this.seq1Range} <-> ${this.seq2Range}`;
    }
    join(other) {
        return ( new SequenceDiff(this.seq1Range.join(other.seq1Range), this.seq2Range.join(other.seq2Range)));
    }
    delta(offset) {
        if (offset === 0) {
            return this;
        }
        return ( new SequenceDiff(this.seq1Range.delta(offset), this.seq2Range.delta(offset)));
    }
    deltaStart(offset) {
        if (offset === 0) {
            return this;
        }
        return ( new SequenceDiff(this.seq1Range.deltaStart(offset), this.seq2Range.deltaStart(offset)));
    }
    deltaEnd(offset) {
        if (offset === 0) {
            return this;
        }
        return ( new SequenceDiff(this.seq1Range.deltaEnd(offset), this.seq2Range.deltaEnd(offset)));
    }
    intersectsOrTouches(other) {
        return this.seq1Range.intersectsOrTouches(other.seq1Range) || this.seq2Range.intersectsOrTouches(other.seq2Range);
    }
    intersect(other) {
        const i1 = this.seq1Range.intersect(other.seq1Range);
        const i2 = this.seq2Range.intersect(other.seq2Range);
        if (!i1 || !i2) {
            return undefined;
        }
        return ( new SequenceDiff(i1, i2));
    }
    getStarts() {
        return ( new OffsetPair(this.seq1Range.start, this.seq2Range.start));
    }
    getEndExclusives() {
        return ( new OffsetPair(this.seq1Range.endExclusive, this.seq2Range.endExclusive));
    }
}
class OffsetPair {
    static { this.zero = ( new OffsetPair(0, 0)); }
    static { this.max = ( new OffsetPair(Number.MAX_SAFE_INTEGER, Number.MAX_SAFE_INTEGER)); }
    constructor(offset1, offset2) {
        this.offset1 = offset1;
        this.offset2 = offset2;
    }
    toString() {
        return `${this.offset1} <-> ${this.offset2}`;
    }
    delta(offset) {
        if (offset === 0) {
            return this;
        }
        return ( new OffsetPair(this.offset1 + offset, this.offset2 + offset));
    }
    equals(other) {
        return this.offset1 === other.offset1 && this.offset2 === other.offset2;
    }
}
class InfiniteTimeout {
    static { this.instance = ( new InfiniteTimeout()); }
    isValid() {
        return true;
    }
}
class DateTimeout {
    constructor(timeout) {
        this.timeout = timeout;
        this.startTime = Date.now();
        this.valid = true;
        if (timeout <= 0) {
            throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_1__.BugIndicatingError('timeout must be positive'));
        }
    }
    isValid() {
        const valid = Date.now() - this.startTime < this.timeout;
        if (!valid && this.valid) {
            this.valid = false;
            debugger;
        }
        return this.valid;
    }
    disable() {
        this.timeout = Number.MAX_SAFE_INTEGER;
        this.isValid = () => true;
        this.valid = true;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/dynamicProgrammingDiffing.js":
/*!*******************************************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/dynamicProgrammingDiffing.js ***!
  \*******************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DynamicProgrammingDiffing: () => (/* binding */ DynamicProgrammingDiffing)
/* harmony export */ });
/* harmony import */ var _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../core/offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");
/* harmony import */ var _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./diffAlgorithm.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/diffAlgorithm.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/utils.js");



class DynamicProgrammingDiffing {
    compute(sequence1, sequence2, timeout = _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.InfiniteTimeout.instance, equalityScore) {
        if (sequence1.length === 0 || sequence2.length === 0) {
            return _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.DiffAlgorithmResult.trivial(sequence1, sequence2);
        }
        const lcsLengths = ( new _utils_js__WEBPACK_IMPORTED_MODULE_2__.Array2D(sequence1.length, sequence2.length));
        const directions = ( new _utils_js__WEBPACK_IMPORTED_MODULE_2__.Array2D(sequence1.length, sequence2.length));
        const lengths = ( new _utils_js__WEBPACK_IMPORTED_MODULE_2__.Array2D(sequence1.length, sequence2.length));
        for (let s1 = 0; s1 < sequence1.length; s1++) {
            for (let s2 = 0; s2 < sequence2.length; s2++) {
                if (!timeout.isValid()) {
                    return _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.DiffAlgorithmResult.trivialTimedOut(sequence1, sequence2);
                }
                const horizontalLen = s1 === 0 ? 0 : lcsLengths.get(s1 - 1, s2);
                const verticalLen = s2 === 0 ? 0 : lcsLengths.get(s1, s2 - 1);
                let extendedSeqScore;
                if (sequence1.getElement(s1) === sequence2.getElement(s2)) {
                    if (s1 === 0 || s2 === 0) {
                        extendedSeqScore = 0;
                    }
                    else {
                        extendedSeqScore = lcsLengths.get(s1 - 1, s2 - 1);
                    }
                    if (s1 > 0 && s2 > 0 && directions.get(s1 - 1, s2 - 1) === 3) {
                        extendedSeqScore += lengths.get(s1 - 1, s2 - 1);
                    }
                    extendedSeqScore += (equalityScore ? equalityScore(s1, s2) : 1);
                }
                else {
                    extendedSeqScore = -1;
                }
                const newValue = Math.max(horizontalLen, verticalLen, extendedSeqScore);
                if (newValue === extendedSeqScore) {
                    const prevLen = s1 > 0 && s2 > 0 ? lengths.get(s1 - 1, s2 - 1) : 0;
                    lengths.set(s1, s2, prevLen + 1);
                    directions.set(s1, s2, 3);
                }
                else if (newValue === horizontalLen) {
                    lengths.set(s1, s2, 0);
                    directions.set(s1, s2, 1);
                }
                else if (newValue === verticalLen) {
                    lengths.set(s1, s2, 0);
                    directions.set(s1, s2, 2);
                }
                lcsLengths.set(s1, s2, newValue);
            }
        }
        const result = [];
        let lastAligningPosS1 = sequence1.length;
        let lastAligningPosS2 = sequence2.length;
        function reportDecreasingAligningPositions(s1, s2) {
            if (s1 + 1 !== lastAligningPosS1 || s2 + 1 !== lastAligningPosS2) {
                result.push(( new _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.SequenceDiff(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_0__.OffsetRange(s1 + 1, lastAligningPosS1)), ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_0__.OffsetRange(s2 + 1, lastAligningPosS2)))));
            }
            lastAligningPosS1 = s1;
            lastAligningPosS2 = s2;
        }
        let s1 = sequence1.length - 1;
        let s2 = sequence2.length - 1;
        while (s1 >= 0 && s2 >= 0) {
            if (directions.get(s1, s2) === 3) {
                reportDecreasingAligningPositions(s1, s2);
                s1--;
                s2--;
            }
            else {
                if (directions.get(s1, s2) === 1) {
                    s1--;
                }
                else {
                    s2--;
                }
            }
        }
        reportDecreasingAligningPositions(-1, -1);
        result.reverse();
        return ( new _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.DiffAlgorithmResult(result, false));
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/myersDiffAlgorithm.js":
/*!************************************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/myersDiffAlgorithm.js ***!
  \************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MyersDiffAlgorithm: () => (/* binding */ MyersDiffAlgorithm)
/* harmony export */ });
/* harmony import */ var _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../core/offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");
/* harmony import */ var _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./diffAlgorithm.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/diffAlgorithm.js");


class MyersDiffAlgorithm {
    compute(seq1, seq2, timeout = _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.InfiniteTimeout.instance) {
        if (seq1.length === 0 || seq2.length === 0) {
            return _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.DiffAlgorithmResult.trivial(seq1, seq2);
        }
        const seqX = seq1;
        const seqY = seq2;
        function getXAfterSnake(x, y) {
            while (x < seqX.length && y < seqY.length && seqX.getElement(x) === seqY.getElement(y)) {
                x++;
                y++;
            }
            return x;
        }
        let d = 0;
        const V = ( new FastInt32Array());
        V.set(0, getXAfterSnake(0, 0));
        const paths = ( new FastArrayNegativeIndices());
        paths.set(0, V.get(0) === 0 ? null : ( new SnakePath(null, 0, 0, V.get(0))));
        let k = 0;
        loop: while (true) {
            d++;
            if (!timeout.isValid()) {
                return _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.DiffAlgorithmResult.trivialTimedOut(seqX, seqY);
            }
            const lowerBound = -Math.min(d, seqY.length + (d % 2));
            const upperBound = Math.min(d, seqX.length + (d % 2));
            for (k = lowerBound; k <= upperBound; k += 2) {
                const maxXofDLineTop = k === upperBound ? -1 : V.get(k + 1);
                const maxXofDLineLeft = k === lowerBound ? -1 : V.get(k - 1) + 1;
                const x = Math.min(Math.max(maxXofDLineTop, maxXofDLineLeft), seqX.length);
                const y = x - k;
                if (x > seqX.length || y > seqY.length) {
                    continue;
                }
                const newMaxX = getXAfterSnake(x, y);
                V.set(k, newMaxX);
                const lastPath = x === maxXofDLineTop ? paths.get(k + 1) : paths.get(k - 1);
                paths.set(k, newMaxX !== x ? ( new SnakePath(lastPath, x, y, newMaxX - x)) : lastPath);
                if (V.get(k) === seqX.length && V.get(k) - k === seqY.length) {
                    break loop;
                }
            }
        }
        let path = paths.get(k);
        const result = [];
        let lastAligningPosS1 = seqX.length;
        let lastAligningPosS2 = seqY.length;
        while (true) {
            const endX = path ? path.x + path.length : 0;
            const endY = path ? path.y + path.length : 0;
            if (endX !== lastAligningPosS1 || endY !== lastAligningPosS2) {
                result.push(( new _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.SequenceDiff(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_0__.OffsetRange(endX, lastAligningPosS1)), ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_0__.OffsetRange(endY, lastAligningPosS2)))));
            }
            if (!path) {
                break;
            }
            lastAligningPosS1 = path.x;
            lastAligningPosS2 = path.y;
            path = path.prev;
        }
        result.reverse();
        return ( new _diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_1__.DiffAlgorithmResult(result, false));
    }
}
class SnakePath {
    constructor(prev, x, y, length) {
        this.prev = prev;
        this.x = x;
        this.y = y;
        this.length = length;
    }
}
class FastInt32Array {
    constructor() {
        this.positiveArr = ( new Int32Array(10));
        this.negativeArr = ( new Int32Array(10));
    }
    get(idx) {
        if (idx < 0) {
            idx = -idx - 1;
            return this.negativeArr[idx];
        }
        else {
            return this.positiveArr[idx];
        }
    }
    set(idx, value) {
        if (idx < 0) {
            idx = -idx - 1;
            if (idx >= this.negativeArr.length) {
                const arr = this.negativeArr;
                this.negativeArr = ( new Int32Array(arr.length * 2));
                this.negativeArr.set(arr);
            }
            this.negativeArr[idx] = value;
        }
        else {
            if (idx >= this.positiveArr.length) {
                const arr = this.positiveArr;
                this.positiveArr = ( new Int32Array(arr.length * 2));
                this.positiveArr.set(arr);
            }
            this.positiveArr[idx] = value;
        }
    }
}
class FastArrayNegativeIndices {
    constructor() {
        this.positiveArr = [];
        this.negativeArr = [];
    }
    get(idx) {
        if (idx < 0) {
            idx = -idx - 1;
            return this.negativeArr[idx];
        }
        else {
            return this.positiveArr[idx];
        }
    }
    set(idx, value) {
        if (idx < 0) {
            idx = -idx - 1;
            this.negativeArr[idx] = value;
        }
        else {
            this.positiveArr[idx] = value;
        }
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/computeMovedLines.js":
/*!************************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/computeMovedLines.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   computeMovedLines: () => (/* binding */ computeMovedLines)
/* harmony export */ });
/* harmony import */ var _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./algorithms/diffAlgorithm.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/diffAlgorithm.js");
/* harmony import */ var _rangeMapping_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../rangeMapping.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/rangeMapping.js");
/* harmony import */ var _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../base/common/arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../base/common/arraysFind.js */ "./node_modules/vscode/vscode/src/vs/base/common/arraysFind.js");
/* harmony import */ var _base_common_map_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../base/common/map.js */ "./node_modules/vscode/vscode/src/vs/base/common/map.js");
/* harmony import */ var _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/lineRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/lineRange.js");
/* harmony import */ var _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");
/* harmony import */ var _linesSliceCharSequence_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./linesSliceCharSequence.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/linesSliceCharSequence.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/utils.js");
/* harmony import */ var _algorithms_myersDiffAlgorithm_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./algorithms/myersDiffAlgorithm.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/myersDiffAlgorithm.js");










function computeMovedLines(changes, originalLines, modifiedLines, hashedOriginalLines, hashedModifiedLines, timeout) {
    let { moves, excludedChanges } = computeMovesFromSimpleDeletionsToSimpleInsertions(changes, originalLines, modifiedLines, timeout);
    if (!timeout.isValid()) {
        return [];
    }
    const filteredChanges = changes.filter(c => !( excludedChanges.has(c)));
    const unchangedMoves = computeUnchangedMoves(filteredChanges, hashedOriginalLines, hashedModifiedLines, originalLines, modifiedLines, timeout);
    (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.pushMany)(moves, unchangedMoves);
    moves = joinCloseConsecutiveMoves(moves);
    moves = moves.filter(current => {
        const lines = ( current.original.toOffsetRange().slice(originalLines).map(l => l.trim()));
        const originalText = lines.join('\n');
        return originalText.length >= 15 && countWhere(lines, l => l.length >= 2) >= 2;
    });
    moves = removeMovesInSameDiff(changes, moves);
    return moves;
}
function countWhere(arr, predicate) {
    let count = 0;
    for (const t of arr) {
        if (predicate(t)) {
            count++;
        }
    }
    return count;
}
function computeMovesFromSimpleDeletionsToSimpleInsertions(changes, originalLines, modifiedLines, timeout) {
    const moves = [];
    const deletions = ( changes
        .filter(c => c.modified.isEmpty && c.original.length >= 3)
        .map(d => ( new _utils_js__WEBPACK_IMPORTED_MODULE_8__.LineRangeFragment(d.original, originalLines, d))));
    const insertions = ( new Set(( changes
        .filter(c => c.original.isEmpty && c.modified.length >= 3)
        .map(d => ( new _utils_js__WEBPACK_IMPORTED_MODULE_8__.LineRangeFragment(d.modified, modifiedLines, d))))));
    const excludedChanges = ( new Set());
    for (const deletion of deletions) {
        let highestSimilarity = -1;
        let best;
        for (const insertion of insertions) {
            const similarity = deletion.computeSimilarity(insertion);
            if (similarity > highestSimilarity) {
                highestSimilarity = similarity;
                best = insertion;
            }
        }
        if (highestSimilarity > 0.90 && best) {
            insertions.delete(best);
            moves.push(( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_1__.LineRangeMapping(deletion.range, best.range)));
            excludedChanges.add(deletion.source);
            excludedChanges.add(best.source);
        }
        if (!timeout.isValid()) {
            return { moves, excludedChanges };
        }
    }
    return { moves, excludedChanges };
}
function computeUnchangedMoves(changes, hashedOriginalLines, hashedModifiedLines, originalLines, modifiedLines, timeout) {
    const moves = [];
    const original3LineHashes = ( new _base_common_map_js__WEBPACK_IMPORTED_MODULE_4__.SetMap());
    for (const change of changes) {
        for (let i = change.original.startLineNumber; i < change.original.endLineNumberExclusive - 2; i++) {
            const key = `${hashedOriginalLines[i - 1]}:${hashedOriginalLines[i + 1 - 1]}:${hashedOriginalLines[i + 2 - 1]}`;
            original3LineHashes.add(key, { range: ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(i, i + 3)) });
        }
    }
    const possibleMappings = [];
    changes.sort((0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.compareBy)(c => c.modified.startLineNumber, _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.numberComparator));
    for (const change of changes) {
        let lastMappings = [];
        for (let i = change.modified.startLineNumber; i < change.modified.endLineNumberExclusive - 2; i++) {
            const key = `${hashedModifiedLines[i - 1]}:${hashedModifiedLines[i + 1 - 1]}:${hashedModifiedLines[i + 2 - 1]}`;
            const currentModifiedRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(i, i + 3));
            const nextMappings = [];
            original3LineHashes.forEach(key, ({ range }) => {
                for (const lastMapping of lastMappings) {
                    if (lastMapping.originalLineRange.endLineNumberExclusive + 1 === range.endLineNumberExclusive &&
                        lastMapping.modifiedLineRange.endLineNumberExclusive + 1 === currentModifiedRange.endLineNumberExclusive) {
                        lastMapping.originalLineRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(
                            lastMapping.originalLineRange.startLineNumber,
                            range.endLineNumberExclusive
                        ));
                        lastMapping.modifiedLineRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(
                            lastMapping.modifiedLineRange.startLineNumber,
                            currentModifiedRange.endLineNumberExclusive
                        ));
                        nextMappings.push(lastMapping);
                        return;
                    }
                }
                const mapping = {
                    modifiedLineRange: currentModifiedRange,
                    originalLineRange: range,
                };
                possibleMappings.push(mapping);
                nextMappings.push(mapping);
            });
            lastMappings = nextMappings;
        }
        if (!timeout.isValid()) {
            return [];
        }
    }
    possibleMappings.sort((0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.reverseOrder)((0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.compareBy)(m => m.modifiedLineRange.length, _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.numberComparator)));
    const modifiedSet = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRangeSet());
    const originalSet = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRangeSet());
    for (const mapping of possibleMappings) {
        const diffOrigToMod = mapping.modifiedLineRange.startLineNumber - mapping.originalLineRange.startLineNumber;
        const modifiedSections = modifiedSet.subtractFrom(mapping.modifiedLineRange);
        const originalTranslatedSections = originalSet.subtractFrom(mapping.originalLineRange).getWithDelta(diffOrigToMod);
        const modifiedIntersectedSections = modifiedSections.getIntersection(originalTranslatedSections);
        for (const s of modifiedIntersectedSections.ranges) {
            if (s.length < 3) {
                continue;
            }
            const modifiedLineRange = s;
            const originalLineRange = s.delta(-diffOrigToMod);
            moves.push(( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_1__.LineRangeMapping(originalLineRange, modifiedLineRange)));
            modifiedSet.addRange(modifiedLineRange);
            originalSet.addRange(originalLineRange);
        }
    }
    moves.sort((0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.compareBy)(m => m.original.startLineNumber, _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.numberComparator));
    const monotonousChanges = ( new _base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.MonotonousArray(changes));
    for (let i = 0; i < moves.length; i++) {
        const move = moves[i];
        const firstTouchingChangeOrig = monotonousChanges.findLastMonotonous(c => c.original.startLineNumber <= move.original.startLineNumber);
        const firstTouchingChangeMod = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findLastMonotonous)(changes, c => c.modified.startLineNumber <= move.modified.startLineNumber);
        const linesAbove = Math.max(move.original.startLineNumber - firstTouchingChangeOrig.original.startLineNumber, move.modified.startLineNumber - firstTouchingChangeMod.modified.startLineNumber);
        const lastTouchingChangeOrig = monotonousChanges.findLastMonotonous(c => c.original.startLineNumber < move.original.endLineNumberExclusive);
        const lastTouchingChangeMod = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findLastMonotonous)(changes, c => c.modified.startLineNumber < move.modified.endLineNumberExclusive);
        const linesBelow = Math.max(lastTouchingChangeOrig.original.endLineNumberExclusive - move.original.endLineNumberExclusive, lastTouchingChangeMod.modified.endLineNumberExclusive - move.modified.endLineNumberExclusive);
        let extendToTop;
        for (extendToTop = 0; extendToTop < linesAbove; extendToTop++) {
            const origLine = move.original.startLineNumber - extendToTop - 1;
            const modLine = move.modified.startLineNumber - extendToTop - 1;
            if (origLine > originalLines.length || modLine > modifiedLines.length) {
                break;
            }
            if (modifiedSet.contains(modLine) || originalSet.contains(origLine)) {
                break;
            }
            if (!areLinesSimilar(originalLines[origLine - 1], modifiedLines[modLine - 1], timeout)) {
                break;
            }
        }
        if (extendToTop > 0) {
            originalSet.addRange(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(move.original.startLineNumber - extendToTop, move.original.startLineNumber)));
            modifiedSet.addRange(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(move.modified.startLineNumber - extendToTop, move.modified.startLineNumber)));
        }
        let extendToBottom;
        for (extendToBottom = 0; extendToBottom < linesBelow; extendToBottom++) {
            const origLine = move.original.endLineNumberExclusive + extendToBottom;
            const modLine = move.modified.endLineNumberExclusive + extendToBottom;
            if (origLine > originalLines.length || modLine > modifiedLines.length) {
                break;
            }
            if (modifiedSet.contains(modLine) || originalSet.contains(origLine)) {
                break;
            }
            if (!areLinesSimilar(originalLines[origLine - 1], modifiedLines[modLine - 1], timeout)) {
                break;
            }
        }
        if (extendToBottom > 0) {
            originalSet.addRange(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(
                move.original.endLineNumberExclusive,
                move.original.endLineNumberExclusive + extendToBottom
            )));
            modifiedSet.addRange(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(
                move.modified.endLineNumberExclusive,
                move.modified.endLineNumberExclusive + extendToBottom
            )));
        }
        if (extendToTop > 0 || extendToBottom > 0) {
            moves[i] = ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_1__.LineRangeMapping(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(
                move.original.startLineNumber - extendToTop,
                move.original.endLineNumberExclusive + extendToBottom
            )), ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(
                move.modified.startLineNumber - extendToTop,
                move.modified.endLineNumberExclusive + extendToBottom
            ))));
        }
    }
    return moves;
}
function areLinesSimilar(line1, line2, timeout) {
    if (line1.trim() === line2.trim()) {
        return true;
    }
    if (line1.length > 300 && line2.length > 300) {
        return false;
    }
    const myersDiffingAlgorithm = ( new _algorithms_myersDiffAlgorithm_js__WEBPACK_IMPORTED_MODULE_9__.MyersDiffAlgorithm());
    const result = myersDiffingAlgorithm.compute(( new _linesSliceCharSequence_js__WEBPACK_IMPORTED_MODULE_7__.LinesSliceCharSequence([line1], ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_6__.OffsetRange(0, 1)), false)), ( new _linesSliceCharSequence_js__WEBPACK_IMPORTED_MODULE_7__.LinesSliceCharSequence([line2], ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_6__.OffsetRange(0, 1)), false)), timeout);
    let commonNonSpaceCharCount = 0;
    const inverted = _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_0__.SequenceDiff.invert(result.diffs, line1.length);
    for (const seq of inverted) {
        seq.seq1Range.forEach(idx => {
            if (!(0,_utils_js__WEBPACK_IMPORTED_MODULE_8__.isSpace)(line1.charCodeAt(idx))) {
                commonNonSpaceCharCount++;
            }
        });
    }
    function countNonWsChars(str) {
        let count = 0;
        for (let i = 0; i < line1.length; i++) {
            if (!(0,_utils_js__WEBPACK_IMPORTED_MODULE_8__.isSpace)(str.charCodeAt(i))) {
                count++;
            }
        }
        return count;
    }
    const longerLineLength = countNonWsChars(line1.length > line2.length ? line1 : line2);
    const r = commonNonSpaceCharCount / longerLineLength > 0.6 && longerLineLength > 10;
    return r;
}
function joinCloseConsecutiveMoves(moves) {
    if (moves.length === 0) {
        return moves;
    }
    moves.sort((0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.compareBy)(m => m.original.startLineNumber, _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_2__.numberComparator));
    const result = [moves[0]];
    for (let i = 1; i < moves.length; i++) {
        const last = result[result.length - 1];
        const current = moves[i];
        const originalDist = current.original.startLineNumber - last.original.endLineNumberExclusive;
        const modifiedDist = current.modified.startLineNumber - last.modified.endLineNumberExclusive;
        const currentMoveAfterLast = originalDist >= 0 && modifiedDist >= 0;
        if (currentMoveAfterLast && originalDist + modifiedDist <= 2) {
            result[result.length - 1] = last.join(current);
            continue;
        }
        result.push(current);
    }
    return result;
}
function removeMovesInSameDiff(changes, moves) {
    const changesMonotonous = ( new _base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.MonotonousArray(changes));
    moves = moves.filter(m => {
        const diffBeforeEndOfMoveOriginal = changesMonotonous.findLastMonotonous(c => c.original.startLineNumber < m.original.endLineNumberExclusive)
            || ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_1__.LineRangeMapping(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(1, 1)), ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_5__.LineRange(1, 1))));
        const diffBeforeEndOfMoveModified = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_3__.findLastMonotonous)(changes, c => c.modified.startLineNumber < m.modified.endLineNumberExclusive);
        const differentDiffs = diffBeforeEndOfMoveOriginal !== diffBeforeEndOfMoveModified;
        return differentDiffs;
    });
    return moves;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/defaultLinesDiffComputer.js":
/*!*******************************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/defaultLinesDiffComputer.js ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultLinesDiffComputer: () => (/* binding */ DefaultLinesDiffComputer),
/* harmony export */   getLineRangeMapping: () => (/* binding */ getLineRangeMapping),
/* harmony export */   lineRangeMappingFromRangeMappings: () => (/* binding */ lineRangeMappingFromRangeMappings)
/* harmony export */ });
/* harmony import */ var _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../base/common/arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _base_common_assert_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../base/common/assert.js */ "./node_modules/vscode/vscode/src/vs/base/common/assert.js");
/* harmony import */ var _core_lineRange_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/lineRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/lineRange.js");
/* harmony import */ var _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./algorithms/diffAlgorithm.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/diffAlgorithm.js");
/* harmony import */ var _algorithms_dynamicProgrammingDiffing_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./algorithms/dynamicProgrammingDiffing.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/dynamicProgrammingDiffing.js");
/* harmony import */ var _algorithms_myersDiffAlgorithm_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./algorithms/myersDiffAlgorithm.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/myersDiffAlgorithm.js");
/* harmony import */ var _computeMovedLines_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./computeMovedLines.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/computeMovedLines.js");
/* harmony import */ var _heuristicSequenceOptimizations_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./heuristicSequenceOptimizations.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/heuristicSequenceOptimizations.js");
/* harmony import */ var _lineSequence_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./lineSequence.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/lineSequence.js");
/* harmony import */ var _linesSliceCharSequence_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./linesSliceCharSequence.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/linesSliceCharSequence.js");
/* harmony import */ var _linesDiffComputer_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../linesDiffComputer.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/linesDiffComputer.js");
/* harmony import */ var _rangeMapping_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../rangeMapping.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/rangeMapping.js");














class DefaultLinesDiffComputer {
    constructor() {
        this.dynamicProgrammingDiffing = ( new _algorithms_dynamicProgrammingDiffing_js__WEBPACK_IMPORTED_MODULE_6__.DynamicProgrammingDiffing());
        this.myersDiffingAlgorithm = ( new _algorithms_myersDiffAlgorithm_js__WEBPACK_IMPORTED_MODULE_7__.MyersDiffAlgorithm());
    }
    computeDiff(originalLines, modifiedLines, options) {
        if (originalLines.length <= 1 && (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.equals)(originalLines, modifiedLines, (a, b) => a === b)) {
            return ( new _linesDiffComputer_js__WEBPACK_IMPORTED_MODULE_12__.LinesDiff([], [], false));
        }
        if (originalLines.length === 1 && originalLines[0].length === 0 || modifiedLines.length === 1 && modifiedLines[0].length === 0) {
            return ( new _linesDiffComputer_js__WEBPACK_IMPORTED_MODULE_12__.LinesDiff([
                ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_13__.DetailedLineRangeMapping(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_2__.LineRange(1, originalLines.length + 1)), ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_2__.LineRange(1, modifiedLines.length + 1)), [
                    ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_13__.RangeMapping(( new _core_range_js__WEBPACK_IMPORTED_MODULE_4__.Range(
                        1,
                        1,
                        originalLines.length,
                        originalLines[originalLines.length - 1].length + 1
                    )), ( new _core_range_js__WEBPACK_IMPORTED_MODULE_4__.Range(
                        1,
                        1,
                        modifiedLines.length,
                        modifiedLines[modifiedLines.length - 1].length + 1
                    ))))
                ]))
            ], [], false));
        }
        const timeout = options.maxComputationTimeMs === 0 ? _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_5__.InfiniteTimeout.instance : ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_5__.DateTimeout(options.maxComputationTimeMs));
        const considerWhitespaceChanges = !options.ignoreTrimWhitespace;
        const perfectHashes = ( new Map());
        function getOrCreateHash(text) {
            let hash = perfectHashes.get(text);
            if (hash === undefined) {
                hash = perfectHashes.size;
                perfectHashes.set(text, hash);
            }
            return hash;
        }
        const originalLinesHashes = ( originalLines.map((l) => getOrCreateHash(l.trim())));
        const modifiedLinesHashes = ( modifiedLines.map((l) => getOrCreateHash(l.trim())));
        const sequence1 = ( new _lineSequence_js__WEBPACK_IMPORTED_MODULE_10__.LineSequence(originalLinesHashes, originalLines));
        const sequence2 = ( new _lineSequence_js__WEBPACK_IMPORTED_MODULE_10__.LineSequence(modifiedLinesHashes, modifiedLines));
        const lineAlignmentResult = (() => {
            if (sequence1.length + sequence2.length < 1700) {
                return this.dynamicProgrammingDiffing.compute(sequence1, sequence2, timeout, (offset1, offset2) => originalLines[offset1] === modifiedLines[offset2]
                    ? modifiedLines[offset2].length === 0
                        ? 0.1
                        : 1 + Math.log(1 + modifiedLines[offset2].length)
                    : 0.99);
            }
            return this.myersDiffingAlgorithm.compute(sequence1, sequence2, timeout);
        })();
        let lineAlignments = lineAlignmentResult.diffs;
        let hitTimeout = lineAlignmentResult.hitTimeout;
        lineAlignments = (0,_heuristicSequenceOptimizations_js__WEBPACK_IMPORTED_MODULE_9__.optimizeSequenceDiffs)(sequence1, sequence2, lineAlignments);
        lineAlignments = (0,_heuristicSequenceOptimizations_js__WEBPACK_IMPORTED_MODULE_9__.removeVeryShortMatchingLinesBetweenDiffs)(sequence1, sequence2, lineAlignments);
        const alignments = [];
        const scanForWhitespaceChanges = (equalLinesCount) => {
            if (!considerWhitespaceChanges) {
                return;
            }
            for (let i = 0; i < equalLinesCount; i++) {
                const seq1Offset = seq1LastStart + i;
                const seq2Offset = seq2LastStart + i;
                if (originalLines[seq1Offset] !== modifiedLines[seq2Offset]) {
                    const characterDiffs = this.refineDiff(originalLines, modifiedLines, ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_5__.SequenceDiff(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_3__.OffsetRange(seq1Offset, seq1Offset + 1)), ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_3__.OffsetRange(seq2Offset, seq2Offset + 1)))), timeout, considerWhitespaceChanges);
                    for (const a of characterDiffs.mappings) {
                        alignments.push(a);
                    }
                    if (characterDiffs.hitTimeout) {
                        hitTimeout = true;
                    }
                }
            }
        };
        let seq1LastStart = 0;
        let seq2LastStart = 0;
        for (const diff of lineAlignments) {
            (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_1__.assertFn)(() => diff.seq1Range.start - seq1LastStart === diff.seq2Range.start - seq2LastStart);
            const equalLinesCount = diff.seq1Range.start - seq1LastStart;
            scanForWhitespaceChanges(equalLinesCount);
            seq1LastStart = diff.seq1Range.endExclusive;
            seq2LastStart = diff.seq2Range.endExclusive;
            const characterDiffs = this.refineDiff(originalLines, modifiedLines, diff, timeout, considerWhitespaceChanges);
            if (characterDiffs.hitTimeout) {
                hitTimeout = true;
            }
            for (const a of characterDiffs.mappings) {
                alignments.push(a);
            }
        }
        scanForWhitespaceChanges(originalLines.length - seq1LastStart);
        const changes = lineRangeMappingFromRangeMappings(alignments, originalLines, modifiedLines);
        let moves = [];
        if (options.computeMoves) {
            moves = this.computeMoves(changes, originalLines, modifiedLines, originalLinesHashes, modifiedLinesHashes, timeout, considerWhitespaceChanges);
        }
        (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_1__.assertFn)(() => {
            function validatePosition(pos, lines) {
                if (pos.lineNumber < 1 || pos.lineNumber > lines.length) {
                    return false;
                }
                const line = lines[pos.lineNumber - 1];
                if (pos.column < 1 || pos.column > line.length + 1) {
                    return false;
                }
                return true;
            }
            function validateRange(range, lines) {
                if (range.startLineNumber < 1 || range.startLineNumber > lines.length + 1) {
                    return false;
                }
                if (range.endLineNumberExclusive < 1 || range.endLineNumberExclusive > lines.length + 1) {
                    return false;
                }
                return true;
            }
            for (const c of changes) {
                if (!c.innerChanges) {
                    return false;
                }
                for (const ic of c.innerChanges) {
                    const valid = validatePosition(ic.modifiedRange.getStartPosition(), modifiedLines) && validatePosition(ic.modifiedRange.getEndPosition(), modifiedLines) &&
                        validatePosition(ic.originalRange.getStartPosition(), originalLines) && validatePosition(ic.originalRange.getEndPosition(), originalLines);
                    if (!valid) {
                        return false;
                    }
                }
                if (!validateRange(c.modified, modifiedLines) || !validateRange(c.original, originalLines)) {
                    return false;
                }
            }
            return true;
        });
        return ( new _linesDiffComputer_js__WEBPACK_IMPORTED_MODULE_12__.LinesDiff(changes, moves, hitTimeout));
    }
    computeMoves(changes, originalLines, modifiedLines, hashedOriginalLines, hashedModifiedLines, timeout, considerWhitespaceChanges) {
        const moves = (0,_computeMovedLines_js__WEBPACK_IMPORTED_MODULE_8__.computeMovedLines)(changes, originalLines, modifiedLines, hashedOriginalLines, hashedModifiedLines, timeout);
        const movesWithDiffs = ( moves.map(m => {
            const moveChanges = this.refineDiff(originalLines, modifiedLines, ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_5__.SequenceDiff(m.original.toOffsetRange(), m.modified.toOffsetRange())), timeout, considerWhitespaceChanges);
            const mappings = lineRangeMappingFromRangeMappings(moveChanges.mappings, originalLines, modifiedLines, true);
            return ( new _linesDiffComputer_js__WEBPACK_IMPORTED_MODULE_12__.MovedText(m, mappings));
        }));
        return movesWithDiffs;
    }
    refineDiff(originalLines, modifiedLines, diff, timeout, considerWhitespaceChanges) {
        const slice1 = ( new _linesSliceCharSequence_js__WEBPACK_IMPORTED_MODULE_11__.LinesSliceCharSequence(originalLines, diff.seq1Range, considerWhitespaceChanges));
        const slice2 = ( new _linesSliceCharSequence_js__WEBPACK_IMPORTED_MODULE_11__.LinesSliceCharSequence(modifiedLines, diff.seq2Range, considerWhitespaceChanges));
        const diffResult = slice1.length + slice2.length < 500
            ? this.dynamicProgrammingDiffing.compute(slice1, slice2, timeout)
            : this.myersDiffingAlgorithm.compute(slice1, slice2, timeout);
        let diffs = diffResult.diffs;
        diffs = (0,_heuristicSequenceOptimizations_js__WEBPACK_IMPORTED_MODULE_9__.optimizeSequenceDiffs)(slice1, slice2, diffs);
        diffs = (0,_heuristicSequenceOptimizations_js__WEBPACK_IMPORTED_MODULE_9__.extendDiffsToEntireWordIfAppropriate)(slice1, slice2, diffs);
        diffs = (0,_heuristicSequenceOptimizations_js__WEBPACK_IMPORTED_MODULE_9__.removeShortMatches)(slice1, slice2, diffs);
        diffs = (0,_heuristicSequenceOptimizations_js__WEBPACK_IMPORTED_MODULE_9__.removeVeryShortMatchingTextBetweenLongDiffs)(slice1, slice2, diffs);
        const result = ( diffs.map((d) => ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_13__.RangeMapping(slice1.translateRange(d.seq1Range), slice2.translateRange(d.seq2Range)))));
        return {
            mappings: result,
            hitTimeout: diffResult.hitTimeout,
        };
    }
}
function lineRangeMappingFromRangeMappings(alignments, originalLines, modifiedLines, dontAssertStartLine = false) {
    const changes = [];
    for (const g of (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.groupAdjacentBy)(( alignments.map(a => getLineRangeMapping(a, originalLines, modifiedLines))), (a1, a2) => a1.original.overlapOrTouch(a2.original)
        || a1.modified.overlapOrTouch(a2.modified))) {
        const first = g[0];
        const last = g[g.length - 1];
        changes.push(( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_13__.DetailedLineRangeMapping(
            first.original.join(last.original),
            first.modified.join(last.modified),
            ( g.map(a => a.innerChanges[0]))
        )));
    }
    (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_1__.assertFn)(() => {
        if (!dontAssertStartLine && changes.length > 0) {
            if (changes[0].modified.startLineNumber !== changes[0].original.startLineNumber) {
                return false;
            }
            if (modifiedLines.length - changes[changes.length - 1].modified.endLineNumberExclusive !== originalLines.length - changes[changes.length - 1].original.endLineNumberExclusive) {
                return false;
            }
        }
        return (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_1__.checkAdjacentItems)(changes, (m1, m2) => m2.original.startLineNumber - m1.original.endLineNumberExclusive === m2.modified.startLineNumber - m1.modified.endLineNumberExclusive &&
            m1.original.endLineNumberExclusive < m2.original.startLineNumber &&
            m1.modified.endLineNumberExclusive < m2.modified.startLineNumber);
    });
    return changes;
}
function getLineRangeMapping(rangeMapping, originalLines, modifiedLines) {
    let lineStartDelta = 0;
    let lineEndDelta = 0;
    if (rangeMapping.modifiedRange.endColumn === 1 && rangeMapping.originalRange.endColumn === 1
        && rangeMapping.originalRange.startLineNumber + lineStartDelta <= rangeMapping.originalRange.endLineNumber
        && rangeMapping.modifiedRange.startLineNumber + lineStartDelta <= rangeMapping.modifiedRange.endLineNumber) {
        lineEndDelta = -1;
    }
    if (rangeMapping.modifiedRange.startColumn - 1 >= modifiedLines[rangeMapping.modifiedRange.startLineNumber - 1].length
        && rangeMapping.originalRange.startColumn - 1 >= originalLines[rangeMapping.originalRange.startLineNumber - 1].length
        && rangeMapping.originalRange.startLineNumber <= rangeMapping.originalRange.endLineNumber + lineEndDelta
        && rangeMapping.modifiedRange.startLineNumber <= rangeMapping.modifiedRange.endLineNumber + lineEndDelta) {
        lineStartDelta = 1;
    }
    const originalLineRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_2__.LineRange(
        rangeMapping.originalRange.startLineNumber + lineStartDelta,
        rangeMapping.originalRange.endLineNumber + 1 + lineEndDelta
    ));
    const modifiedLineRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_2__.LineRange(
        rangeMapping.modifiedRange.startLineNumber + lineStartDelta,
        rangeMapping.modifiedRange.endLineNumber + 1 + lineEndDelta
    ));
    return ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_13__.DetailedLineRangeMapping(originalLineRange, modifiedLineRange, [rangeMapping]));
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/heuristicSequenceOptimizations.js":
/*!*************************************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/heuristicSequenceOptimizations.js ***!
  \*************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extendDiffsToEntireWordIfAppropriate: () => (/* binding */ extendDiffsToEntireWordIfAppropriate),
/* harmony export */   optimizeSequenceDiffs: () => (/* binding */ optimizeSequenceDiffs),
/* harmony export */   removeShortMatches: () => (/* binding */ removeShortMatches),
/* harmony export */   removeVeryShortMatchingLinesBetweenDiffs: () => (/* binding */ removeVeryShortMatchingLinesBetweenDiffs),
/* harmony export */   removeVeryShortMatchingTextBetweenLongDiffs: () => (/* binding */ removeVeryShortMatchingTextBetweenLongDiffs)
/* harmony export */ });
/* harmony import */ var _base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../base/common/arrays.js */ "./node_modules/vscode/vscode/src/vs/base/common/arrays.js");
/* harmony import */ var _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");
/* harmony import */ var _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./algorithms/diffAlgorithm.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/algorithms/diffAlgorithm.js");



function optimizeSequenceDiffs(sequence1, sequence2, sequenceDiffs) {
    let result = sequenceDiffs;
    result = joinSequenceDiffsByShifting(sequence1, sequence2, result);
    result = joinSequenceDiffsByShifting(sequence1, sequence2, result);
    result = shiftSequenceDiffs(sequence1, sequence2, result);
    return result;
}
function joinSequenceDiffsByShifting(sequence1, sequence2, sequenceDiffs) {
    if (sequenceDiffs.length === 0) {
        return sequenceDiffs;
    }
    const result = [];
    result.push(sequenceDiffs[0]);
    for (let i = 1; i < sequenceDiffs.length; i++) {
        const prevResult = result[result.length - 1];
        let cur = sequenceDiffs[i];
        if (cur.seq1Range.isEmpty || cur.seq2Range.isEmpty) {
            const length = cur.seq1Range.start - prevResult.seq1Range.endExclusive;
            let d;
            for (d = 1; d <= length; d++) {
                if (sequence1.getElement(cur.seq1Range.start - d) !== sequence1.getElement(cur.seq1Range.endExclusive - d) ||
                    sequence2.getElement(cur.seq2Range.start - d) !== sequence2.getElement(cur.seq2Range.endExclusive - d)) {
                    break;
                }
            }
            d--;
            if (d === length) {
                result[result.length - 1] = ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.SequenceDiff(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(prevResult.seq1Range.start, cur.seq1Range.endExclusive - length)), ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(prevResult.seq2Range.start, cur.seq2Range.endExclusive - length))));
                continue;
            }
            cur = cur.delta(-d);
        }
        result.push(cur);
    }
    const result2 = [];
    for (let i = 0; i < result.length - 1; i++) {
        const nextResult = result[i + 1];
        let cur = result[i];
        if (cur.seq1Range.isEmpty || cur.seq2Range.isEmpty) {
            const length = nextResult.seq1Range.start - cur.seq1Range.endExclusive;
            let d;
            for (d = 0; d < length; d++) {
                if (!sequence1.isStronglyEqual(cur.seq1Range.start + d, cur.seq1Range.endExclusive + d) ||
                    !sequence2.isStronglyEqual(cur.seq2Range.start + d, cur.seq2Range.endExclusive + d)) {
                    break;
                }
            }
            if (d === length) {
                result[i + 1] = ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.SequenceDiff(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(cur.seq1Range.start + length, nextResult.seq1Range.endExclusive)), ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(cur.seq2Range.start + length, nextResult.seq2Range.endExclusive))));
                continue;
            }
            if (d > 0) {
                cur = cur.delta(d);
            }
        }
        result2.push(cur);
    }
    if (result.length > 0) {
        result2.push(result[result.length - 1]);
    }
    return result2;
}
function shiftSequenceDiffs(sequence1, sequence2, sequenceDiffs) {
    if (!sequence1.getBoundaryScore || !sequence2.getBoundaryScore) {
        return sequenceDiffs;
    }
    for (let i = 0; i < sequenceDiffs.length; i++) {
        const prevDiff = (i > 0 ? sequenceDiffs[i - 1] : undefined);
        const diff = sequenceDiffs[i];
        const nextDiff = (i + 1 < sequenceDiffs.length ? sequenceDiffs[i + 1] : undefined);
        const seq1ValidRange = ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(
            prevDiff ? prevDiff.seq1Range.endExclusive + 1 : 0,
            nextDiff ? nextDiff.seq1Range.start - 1 : sequence1.length
        ));
        const seq2ValidRange = ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(
            prevDiff ? prevDiff.seq2Range.endExclusive + 1 : 0,
            nextDiff ? nextDiff.seq2Range.start - 1 : sequence2.length
        ));
        if (diff.seq1Range.isEmpty) {
            sequenceDiffs[i] = shiftDiffToBetterPosition(diff, sequence1, sequence2, seq1ValidRange, seq2ValidRange);
        }
        else if (diff.seq2Range.isEmpty) {
            sequenceDiffs[i] = shiftDiffToBetterPosition(diff.swap(), sequence2, sequence1, seq2ValidRange, seq1ValidRange).swap();
        }
    }
    return sequenceDiffs;
}
function shiftDiffToBetterPosition(diff, sequence1, sequence2, seq1ValidRange, seq2ValidRange) {
    const maxShiftLimit = 100;
    let deltaBefore = 1;
    while (diff.seq1Range.start - deltaBefore >= seq1ValidRange.start &&
        diff.seq2Range.start - deltaBefore >= seq2ValidRange.start &&
        sequence2.isStronglyEqual(diff.seq2Range.start - deltaBefore, diff.seq2Range.endExclusive - deltaBefore) && deltaBefore < maxShiftLimit) {
        deltaBefore++;
    }
    deltaBefore--;
    let deltaAfter = 0;
    while (diff.seq1Range.start + deltaAfter < seq1ValidRange.endExclusive &&
        diff.seq2Range.endExclusive + deltaAfter < seq2ValidRange.endExclusive &&
        sequence2.isStronglyEqual(diff.seq2Range.start + deltaAfter, diff.seq2Range.endExclusive + deltaAfter) && deltaAfter < maxShiftLimit) {
        deltaAfter++;
    }
    if (deltaBefore === 0 && deltaAfter === 0) {
        return diff;
    }
    let bestDelta = 0;
    let bestScore = -1;
    for (let delta = -deltaBefore; delta <= deltaAfter; delta++) {
        const seq2OffsetStart = diff.seq2Range.start + delta;
        const seq2OffsetEndExclusive = diff.seq2Range.endExclusive + delta;
        const seq1Offset = diff.seq1Range.start + delta;
        const score = sequence1.getBoundaryScore(seq1Offset) + sequence2.getBoundaryScore(seq2OffsetStart) + sequence2.getBoundaryScore(seq2OffsetEndExclusive);
        if (score > bestScore) {
            bestScore = score;
            bestDelta = delta;
        }
    }
    return diff.delta(bestDelta);
}
function removeShortMatches(sequence1, sequence2, sequenceDiffs) {
    const result = [];
    for (const s of sequenceDiffs) {
        const last = result[result.length - 1];
        if (!last) {
            result.push(s);
            continue;
        }
        if (s.seq1Range.start - last.seq1Range.endExclusive <= 2 || s.seq2Range.start - last.seq2Range.endExclusive <= 2) {
            result[result.length - 1] = ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.SequenceDiff(last.seq1Range.join(s.seq1Range), last.seq2Range.join(s.seq2Range)));
        }
        else {
            result.push(s);
        }
    }
    return result;
}
function extendDiffsToEntireWordIfAppropriate(sequence1, sequence2, sequenceDiffs) {
    const equalMappings = _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.SequenceDiff.invert(sequenceDiffs, sequence1.length);
    const additional = [];
    let lastPoint = ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.OffsetPair(0, 0));
    function scanWord(pair, equalMapping) {
        if (pair.offset1 < lastPoint.offset1 || pair.offset2 < lastPoint.offset2) {
            return;
        }
        const w1 = sequence1.findWordContaining(pair.offset1);
        const w2 = sequence2.findWordContaining(pair.offset2);
        if (!w1 || !w2) {
            return;
        }
        let w = ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.SequenceDiff(w1, w2));
        const equalPart = w.intersect(equalMapping);
        let equalChars1 = equalPart.seq1Range.length;
        let equalChars2 = equalPart.seq2Range.length;
        while (equalMappings.length > 0) {
            const next = equalMappings[0];
            const intersects = next.seq1Range.intersects(w.seq1Range) || next.seq2Range.intersects(w.seq2Range);
            if (!intersects) {
                break;
            }
            const v1 = sequence1.findWordContaining(next.seq1Range.start);
            const v2 = sequence2.findWordContaining(next.seq2Range.start);
            const v = ( new _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.SequenceDiff(v1, v2));
            const equalPart = v.intersect(next);
            equalChars1 += equalPart.seq1Range.length;
            equalChars2 += equalPart.seq2Range.length;
            w = w.join(v);
            if (w.seq1Range.endExclusive >= next.seq1Range.endExclusive) {
                equalMappings.shift();
            }
            else {
                break;
            }
        }
        if (equalChars1 + equalChars2 < (w.seq1Range.length + w.seq2Range.length) * 2 / 3) {
            additional.push(w);
        }
        lastPoint = w.getEndExclusives();
    }
    while (equalMappings.length > 0) {
        const next = equalMappings.shift();
        if (next.seq1Range.isEmpty) {
            continue;
        }
        scanWord(next.getStarts(), next);
        scanWord(next.getEndExclusives().delta(-1), next);
    }
    const merged = mergeSequenceDiffs(sequenceDiffs, additional);
    return merged;
}
function mergeSequenceDiffs(sequenceDiffs1, sequenceDiffs2) {
    const result = [];
    while (sequenceDiffs1.length > 0 || sequenceDiffs2.length > 0) {
        const sd1 = sequenceDiffs1[0];
        const sd2 = sequenceDiffs2[0];
        let next;
        if (sd1 && (!sd2 || sd1.seq1Range.start < sd2.seq1Range.start)) {
            next = sequenceDiffs1.shift();
        }
        else {
            next = sequenceDiffs2.shift();
        }
        if (result.length > 0 && result[result.length - 1].seq1Range.endExclusive >= next.seq1Range.start) {
            result[result.length - 1] = result[result.length - 1].join(next);
        }
        else {
            result.push(next);
        }
    }
    return result;
}
function removeVeryShortMatchingLinesBetweenDiffs(sequence1, _sequence2, sequenceDiffs) {
    let diffs = sequenceDiffs;
    if (diffs.length === 0) {
        return diffs;
    }
    let counter = 0;
    let shouldRepeat;
    do {
        shouldRepeat = false;
        const result = [
            diffs[0]
        ];
        for (let i = 1; i < diffs.length; i++) {
            const cur = diffs[i];
            const lastResult = result[result.length - 1];
            function shouldJoinDiffs(before, after) {
                const unchangedRange = ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(lastResult.seq1Range.endExclusive, cur.seq1Range.start));
                const unchangedText = sequence1.getText(unchangedRange);
                const unchangedTextWithoutWs = unchangedText.replace(/\s/g, '');
                if (unchangedTextWithoutWs.length <= 4
                    && (before.seq1Range.length + before.seq2Range.length > 5 || after.seq1Range.length + after.seq2Range.length > 5)) {
                    return true;
                }
                return false;
            }
            const shouldJoin = shouldJoinDiffs(lastResult, cur);
            if (shouldJoin) {
                shouldRepeat = true;
                result[result.length - 1] = result[result.length - 1].join(cur);
            }
            else {
                result.push(cur);
            }
        }
        diffs = result;
    } while (counter++ < 10 && shouldRepeat);
    return diffs;
}
function removeVeryShortMatchingTextBetweenLongDiffs(sequence1, sequence2, sequenceDiffs) {
    let diffs = sequenceDiffs;
    if (diffs.length === 0) {
        return diffs;
    }
    let counter = 0;
    let shouldRepeat;
    do {
        shouldRepeat = false;
        const result = [
            diffs[0]
        ];
        for (let i = 1; i < diffs.length; i++) {
            const cur = diffs[i];
            const lastResult = result[result.length - 1];
            function shouldJoinDiffs(before, after) {
                const unchangedRange = ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(lastResult.seq1Range.endExclusive, cur.seq1Range.start));
                const unchangedLineCount = sequence1.countLinesIn(unchangedRange);
                if (unchangedLineCount > 5 || unchangedRange.length > 500) {
                    return false;
                }
                const unchangedText = sequence1.getText(unchangedRange).trim();
                if (unchangedText.length > 20 || unchangedText.split(/\r\n|\r|\n/).length > 1) {
                    return false;
                }
                const beforeLineCount1 = sequence1.countLinesIn(before.seq1Range);
                const beforeSeq1Length = before.seq1Range.length;
                const beforeLineCount2 = sequence2.countLinesIn(before.seq2Range);
                const beforeSeq2Length = before.seq2Range.length;
                const afterLineCount1 = sequence1.countLinesIn(after.seq1Range);
                const afterSeq1Length = after.seq1Range.length;
                const afterLineCount2 = sequence2.countLinesIn(after.seq2Range);
                const afterSeq2Length = after.seq2Range.length;
                const max = 2 * 40 + 50;
                function cap(v) {
                    return Math.min(v, max);
                }
                if (Math.pow(Math.pow(cap(beforeLineCount1 * 40 + beforeSeq1Length), 1.5) + Math.pow(cap(beforeLineCount2 * 40 + beforeSeq2Length), 1.5), 1.5)
                    + Math.pow(Math.pow(cap(afterLineCount1 * 40 + afterSeq1Length), 1.5) + Math.pow(cap(afterLineCount2 * 40 + afterSeq2Length), 1.5), 1.5) > ((max ** 1.5) ** 1.5) * 1.3) {
                    return true;
                }
                return false;
            }
            const shouldJoin = shouldJoinDiffs(lastResult, cur);
            if (shouldJoin) {
                shouldRepeat = true;
                result[result.length - 1] = result[result.length - 1].join(cur);
            }
            else {
                result.push(cur);
            }
        }
        diffs = result;
    } while (counter++ < 10 && shouldRepeat);
    const newDiffs = [];
    (0,_base_common_arrays_js__WEBPACK_IMPORTED_MODULE_0__.forEachWithNeighbors)(diffs, (prev, cur, next) => {
        let newDiff = cur;
        function shouldMarkAsChanged(text) {
            return text.length > 0 && text.trim().length <= 3 && cur.seq1Range.length + cur.seq2Range.length > 100;
        }
        const fullRange1 = sequence1.extendToFullLines(cur.seq1Range);
        const prefix = sequence1.getText(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(fullRange1.start, cur.seq1Range.start)));
        if (shouldMarkAsChanged(prefix)) {
            newDiff = newDiff.deltaStart(-prefix.length);
        }
        const suffix = sequence1.getText(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_1__.OffsetRange(cur.seq1Range.endExclusive, fullRange1.endExclusive)));
        if (shouldMarkAsChanged(suffix)) {
            newDiff = newDiff.deltaEnd(suffix.length);
        }
        const availableSpace = _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.SequenceDiff.fromOffsetPairs(prev ? prev.getEndExclusives() : _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.OffsetPair.zero, next ? next.getStarts() : _algorithms_diffAlgorithm_js__WEBPACK_IMPORTED_MODULE_2__.OffsetPair.max);
        const result = newDiff.intersect(availableSpace);
        if (newDiffs.length > 0 && result.getStarts().equals(newDiffs[newDiffs.length - 1].getEndExclusives())) {
            newDiffs[newDiffs.length - 1] = newDiffs[newDiffs.length - 1].join(result);
        }
        else {
            newDiffs.push(result);
        }
    });
    return newDiffs;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/lineSequence.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/lineSequence.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LineSequence: () => (/* binding */ LineSequence)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");

class LineSequence {
    constructor(trimmedHash, lines) {
        this.trimmedHash = trimmedHash;
        this.lines = lines;
    }
    getElement(offset) {
        return this.trimmedHash[offset];
    }
    get length() {
        return this.trimmedHash.length;
    }
    getBoundaryScore(length) {
        const indentationBefore = length === 0 ? 0 : getIndentation(this.lines[length - 1]);
        const indentationAfter = length === this.lines.length ? 0 : getIndentation(this.lines[length]);
        return 1000 - (indentationBefore + indentationAfter);
    }
    getText(range) {
        return this.lines.slice(range.start, range.endExclusive).join('\n');
    }
    isStronglyEqual(offset1, offset2) {
        return this.lines[offset1] === this.lines[offset2];
    }
}
function getIndentation(str) {
    let i = 0;
    while (i < str.length && (str.charCodeAt(i) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Space || str.charCodeAt(i) === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Tab)) {
        i++;
    }
    return i;
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/linesSliceCharSequence.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/linesSliceCharSequence.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinesSliceCharSequence: () => (/* binding */ LinesSliceCharSequence)
/* harmony export */ });
/* harmony import */ var _base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../base/common/arraysFind.js */ "./node_modules/vscode/vscode/src/vs/base/common/arraysFind.js");
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/offsetRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/offsetRange.js");
/* harmony import */ var _core_position_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/position.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/position.js");
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/utils.js");






class LinesSliceCharSequence {
    constructor(lines, lineRange, considerWhitespaceChanges) {
        this.lines = lines;
        this.considerWhitespaceChanges = considerWhitespaceChanges;
        this.elements = [];
        this.firstCharOffsetByLine = [];
        this.additionalOffsetByLine = [];
        let trimFirstLineFully = false;
        if (lineRange.start > 0 && lineRange.endExclusive >= lines.length) {
            lineRange = ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange(lineRange.start - 1, lineRange.endExclusive));
            trimFirstLineFully = true;
        }
        this.lineRange = lineRange;
        this.firstCharOffsetByLine[0] = 0;
        for (let i = this.lineRange.start; i < this.lineRange.endExclusive; i++) {
            let line = lines[i];
            let offset = 0;
            if (trimFirstLineFully) {
                offset = line.length;
                line = '';
                trimFirstLineFully = false;
            }
            else if (!considerWhitespaceChanges) {
                const trimmedStartLine = line.trimStart();
                offset = line.length - trimmedStartLine.length;
                line = trimmedStartLine.trimEnd();
            }
            this.additionalOffsetByLine.push(offset);
            for (let i = 0; i < line.length; i++) {
                this.elements.push(line.charCodeAt(i));
            }
            if (i < lines.length - 1) {
                this.elements.push('\n'.charCodeAt(0));
                this.firstCharOffsetByLine[i - this.lineRange.start + 1] = this.elements.length;
            }
        }
        this.additionalOffsetByLine.push(0);
    }
    toString() {
        return `Slice: "${this.text}"`;
    }
    get text() {
        return this.getText(( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange(0, this.length)));
    }
    getText(range) {
        return ( this.elements.slice(range.start, range.endExclusive).map(e => String.fromCharCode(e))).join('');
    }
    getElement(offset) {
        return this.elements[offset];
    }
    get length() {
        return this.elements.length;
    }
    getBoundaryScore(length) {
        const prevCategory = getCategory(length > 0 ? this.elements[length - 1] : -1);
        const nextCategory = getCategory(length < this.elements.length ? this.elements[length] : -1);
        if (prevCategory === CharBoundaryCategory.LineBreakCR && nextCategory === CharBoundaryCategory.LineBreakLF) {
            return 0;
        }
        if (prevCategory === CharBoundaryCategory.LineBreakLF) {
            return 150;
        }
        let score = 0;
        if (prevCategory !== nextCategory) {
            score += 10;
            if (prevCategory === CharBoundaryCategory.WordLower && nextCategory === CharBoundaryCategory.WordUpper) {
                score += 1;
            }
        }
        score += getCategoryBoundaryScore(prevCategory);
        score += getCategoryBoundaryScore(nextCategory);
        return score;
    }
    translateOffset(offset) {
        if (this.lineRange.isEmpty) {
            return ( new _core_position_js__WEBPACK_IMPORTED_MODULE_3__.Position(this.lineRange.start + 1, 1));
        }
        const i = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_0__.findLastIdxMonotonous)(this.firstCharOffsetByLine, (value) => value <= offset);
        return ( new _core_position_js__WEBPACK_IMPORTED_MODULE_3__.Position(
            this.lineRange.start + i + 1,
            offset - this.firstCharOffsetByLine[i] + this.additionalOffsetByLine[i] + 1
        ));
    }
    translateRange(range) {
        return _core_range_js__WEBPACK_IMPORTED_MODULE_4__.Range.fromPositions(this.translateOffset(range.start), this.translateOffset(range.endExclusive));
    }
    findWordContaining(offset) {
        if (offset < 0 || offset >= this.elements.length) {
            return undefined;
        }
        if (!isWordChar(this.elements[offset])) {
            return undefined;
        }
        let start = offset;
        while (start > 0 && isWordChar(this.elements[start - 1])) {
            start--;
        }
        let end = offset;
        while (end < this.elements.length && isWordChar(this.elements[end])) {
            end++;
        }
        return ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange(start, end));
    }
    countLinesIn(range) {
        return this.translateOffset(range.endExclusive).lineNumber - this.translateOffset(range.start).lineNumber;
    }
    isStronglyEqual(offset1, offset2) {
        return this.elements[offset1] === this.elements[offset2];
    }
    extendToFullLines(range) {
        const start = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_0__.findLastMonotonous)(this.firstCharOffsetByLine, x => x <= range.start) ?? 0;
        const end = (0,_base_common_arraysFind_js__WEBPACK_IMPORTED_MODULE_0__.findFirstMonotonous)(this.firstCharOffsetByLine, x => range.endExclusive <= x) ?? this.elements.length;
        return ( new _core_offsetRange_js__WEBPACK_IMPORTED_MODULE_2__.OffsetRange(start, end));
    }
}
function isWordChar(charCode) {
    return charCode >= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.a && charCode <= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.z
        || charCode >= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.A && charCode <= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Z
        || charCode >= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Digit0 && charCode <= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Digit9;
}
var CharBoundaryCategory;
( (function(CharBoundaryCategory) {
    CharBoundaryCategory[CharBoundaryCategory["WordLower"] = 0] = "WordLower";
    CharBoundaryCategory[CharBoundaryCategory["WordUpper"] = 1] = "WordUpper";
    CharBoundaryCategory[CharBoundaryCategory["WordNumber"] = 2] = "WordNumber";
    CharBoundaryCategory[CharBoundaryCategory["End"] = 3] = "End";
    CharBoundaryCategory[CharBoundaryCategory["Other"] = 4] = "Other";
    CharBoundaryCategory[CharBoundaryCategory["Separator"] = 5] = "Separator";
    CharBoundaryCategory[CharBoundaryCategory["Space"] = 6] = "Space";
    CharBoundaryCategory[CharBoundaryCategory["LineBreakCR"] = 7] = "LineBreakCR";
    CharBoundaryCategory[CharBoundaryCategory["LineBreakLF"] = 8] = "LineBreakLF";
})(CharBoundaryCategory || (CharBoundaryCategory = {})));
const score = {
    [CharBoundaryCategory.WordLower]: 0,
    [CharBoundaryCategory.WordUpper]: 0,
    [CharBoundaryCategory.WordNumber]: 0,
    [CharBoundaryCategory.End]: 10,
    [CharBoundaryCategory.Other]: 2,
    [CharBoundaryCategory.Separator]: 30,
    [CharBoundaryCategory.Space]: 3,
    [CharBoundaryCategory.LineBreakCR]: 10,
    [CharBoundaryCategory.LineBreakLF]: 10,
};
function getCategoryBoundaryScore(category) {
    return score[category];
}
function getCategory(charCode) {
    if (charCode === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.LineFeed) {
        return CharBoundaryCategory.LineBreakLF;
    }
    else if (charCode === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.CarriageReturn) {
        return CharBoundaryCategory.LineBreakCR;
    }
    else if ((0,_utils_js__WEBPACK_IMPORTED_MODULE_5__.isSpace)(charCode)) {
        return CharBoundaryCategory.Space;
    }
    else if (charCode >= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.a && charCode <= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.z) {
        return CharBoundaryCategory.WordLower;
    }
    else if (charCode >= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.A && charCode <= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Z) {
        return CharBoundaryCategory.WordUpper;
    }
    else if (charCode >= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Digit0 && charCode <= _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Digit9) {
        return CharBoundaryCategory.WordNumber;
    }
    else if (charCode === -1) {
        return CharBoundaryCategory.End;
    }
    else if (charCode === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Comma || charCode === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_1__.CharCode.Semicolon) {
        return CharBoundaryCategory.Separator;
    }
    else {
        return CharBoundaryCategory.Other;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/utils.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/utils.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Array2D: () => (/* binding */ Array2D),
/* harmony export */   LineRangeFragment: () => (/* binding */ LineRangeFragment),
/* harmony export */   isSpace: () => (/* binding */ isSpace)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");

class Array2D {
    constructor(width, height) {
        this.width = width;
        this.height = height;
        this.array = [];
        this.array = ( new Array(width * height));
    }
    get(x, y) {
        return this.array[x + y * this.width];
    }
    set(x, y, value) {
        this.array[x + y * this.width] = value;
    }
}
function isSpace(charCode) {
    return charCode === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Space || charCode === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.Tab;
}
class LineRangeFragment {
    static { this.chrKeys = ( new Map()); }
    static getKey(chr) {
        let key = this.chrKeys.get(chr);
        if (key === undefined) {
            key = this.chrKeys.size;
            this.chrKeys.set(chr, key);
        }
        return key;
    }
    constructor(range, lines, source) {
        this.range = range;
        this.lines = lines;
        this.source = source;
        this.histogram = [];
        let counter = 0;
        for (let i = range.startLineNumber - 1; i < range.endLineNumberExclusive - 1; i++) {
            const line = lines[i];
            for (let j = 0; j < line.length; j++) {
                counter++;
                const chr = line[j];
                const key = LineRangeFragment.getKey(chr);
                this.histogram[key] = (this.histogram[key] || 0) + 1;
            }
            counter++;
            const key = LineRangeFragment.getKey('\n');
            this.histogram[key] = (this.histogram[key] || 0) + 1;
        }
        this.totalCount = counter;
    }
    computeSimilarity(other) {
        let sumDifferences = 0;
        const maxLength = Math.max(this.histogram.length, other.histogram.length);
        for (let i = 0; i < maxLength; i++) {
            sumDifferences += Math.abs((this.histogram[i] ?? 0) - (other.histogram[i] ?? 0));
        }
        return 1 - (sumDifferences / (this.totalCount + other.totalCount));
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/legacyLinesDiffComputer.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/legacyLinesDiffComputer.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DiffComputer: () => (/* binding */ DiffComputer),
/* harmony export */   LegacyLinesDiffComputer: () => (/* binding */ LegacyLinesDiffComputer)
/* harmony export */ });
/* harmony import */ var _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/charCode.js */ "./node_modules/vscode/vscode/src/vs/base/common/charCode.js");
/* harmony import */ var _base_common_diff_diff_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/diff/diff.js */ "./node_modules/vscode/vscode/src/vs/base/common/diff/diff.js");
/* harmony import */ var _linesDiffComputer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./linesDiffComputer.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/linesDiffComputer.js");
/* harmony import */ var _rangeMapping_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./rangeMapping.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/rangeMapping.js");
/* harmony import */ var _base_common_strings_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../base/common/strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _base_common_assert_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../base/common/assert.js */ "./node_modules/vscode/vscode/src/vs/base/common/assert.js");
/* harmony import */ var _core_lineRange_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core/lineRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/lineRange.js");








const MINIMUM_MATCHING_CHARACTER_LENGTH = 3;
class LegacyLinesDiffComputer {
    computeDiff(originalLines, modifiedLines, options) {
        const diffComputer = ( new DiffComputer(originalLines, modifiedLines, {
            maxComputationTime: options.maxComputationTimeMs,
            shouldIgnoreTrimWhitespace: options.ignoreTrimWhitespace,
            shouldComputeCharChanges: true,
            shouldMakePrettyDiff: true,
            shouldPostProcessCharChanges: true,
        }));
        const result = diffComputer.computeDiff();
        const changes = [];
        let lastChange = null;
        for (const c of result.changes) {
            let originalRange;
            if (c.originalEndLineNumber === 0) {
                originalRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_7__.LineRange(c.originalStartLineNumber + 1, c.originalStartLineNumber + 1));
            }
            else {
                originalRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_7__.LineRange(c.originalStartLineNumber, c.originalEndLineNumber + 1));
            }
            let modifiedRange;
            if (c.modifiedEndLineNumber === 0) {
                modifiedRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_7__.LineRange(c.modifiedStartLineNumber + 1, c.modifiedStartLineNumber + 1));
            }
            else {
                modifiedRange = ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_7__.LineRange(c.modifiedStartLineNumber, c.modifiedEndLineNumber + 1));
            }
            let change = ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_3__.DetailedLineRangeMapping(originalRange, modifiedRange, c.charChanges?.map(c => ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_3__.RangeMapping(( new _core_range_js__WEBPACK_IMPORTED_MODULE_5__.Range(
                c.originalStartLineNumber,
                c.originalStartColumn,
                c.originalEndLineNumber,
                c.originalEndColumn
            )), ( new _core_range_js__WEBPACK_IMPORTED_MODULE_5__.Range(
                c.modifiedStartLineNumber,
                c.modifiedStartColumn,
                c.modifiedEndLineNumber,
                c.modifiedEndColumn
            )))))));
            if (lastChange) {
                if (lastChange.modified.endLineNumberExclusive === change.modified.startLineNumber
                    || lastChange.original.endLineNumberExclusive === change.original.startLineNumber) {
                    change = ( new _rangeMapping_js__WEBPACK_IMPORTED_MODULE_3__.DetailedLineRangeMapping(
                        lastChange.original.join(change.original),
                        lastChange.modified.join(change.modified),
                        lastChange.innerChanges && change.innerChanges ?
                            lastChange.innerChanges.concat(change.innerChanges) : undefined
                    ));
                    changes.pop();
                }
            }
            changes.push(change);
            lastChange = change;
        }
        (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_6__.assertFn)(() => {
            return (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_6__.checkAdjacentItems)(changes, (m1, m2) => m2.original.startLineNumber - m1.original.endLineNumberExclusive === m2.modified.startLineNumber - m1.modified.endLineNumberExclusive &&
                m1.original.endLineNumberExclusive < m2.original.startLineNumber &&
                m1.modified.endLineNumberExclusive < m2.modified.startLineNumber);
        });
        return ( new _linesDiffComputer_js__WEBPACK_IMPORTED_MODULE_2__.LinesDiff(changes, [], result.quitEarly));
    }
}
function computeDiff(originalSequence, modifiedSequence, continueProcessingPredicate, pretty) {
    const diffAlgo = ( new _base_common_diff_diff_js__WEBPACK_IMPORTED_MODULE_1__.LcsDiff(originalSequence, modifiedSequence, continueProcessingPredicate));
    return diffAlgo.ComputeDiff(pretty);
}
class LineSequence {
    constructor(lines) {
        const startColumns = [];
        const endColumns = [];
        for (let i = 0, length = lines.length; i < length; i++) {
            startColumns[i] = getFirstNonBlankColumn(lines[i], 1);
            endColumns[i] = getLastNonBlankColumn(lines[i], 1);
        }
        this.lines = lines;
        this._startColumns = startColumns;
        this._endColumns = endColumns;
    }
    getElements() {
        const elements = [];
        for (let i = 0, len = this.lines.length; i < len; i++) {
            elements[i] = this.lines[i].substring(this._startColumns[i] - 1, this._endColumns[i] - 1);
        }
        return elements;
    }
    getStrictElement(index) {
        return this.lines[index];
    }
    getStartLineNumber(i) {
        return i + 1;
    }
    getEndLineNumber(i) {
        return i + 1;
    }
    createCharSequence(shouldIgnoreTrimWhitespace, startIndex, endIndex) {
        const charCodes = [];
        const lineNumbers = [];
        const columns = [];
        let len = 0;
        for (let index = startIndex; index <= endIndex; index++) {
            const lineContent = this.lines[index];
            const startColumn = (shouldIgnoreTrimWhitespace ? this._startColumns[index] : 1);
            const endColumn = (shouldIgnoreTrimWhitespace ? this._endColumns[index] : lineContent.length + 1);
            for (let col = startColumn; col < endColumn; col++) {
                charCodes[len] = lineContent.charCodeAt(col - 1);
                lineNumbers[len] = index + 1;
                columns[len] = col;
                len++;
            }
            if (!shouldIgnoreTrimWhitespace && index < endIndex) {
                charCodes[len] = _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed;
                lineNumbers[len] = index + 1;
                columns[len] = lineContent.length + 1;
                len++;
            }
        }
        return ( new CharSequence(charCodes, lineNumbers, columns));
    }
}
class CharSequence {
    constructor(charCodes, lineNumbers, columns) {
        this._charCodes = charCodes;
        this._lineNumbers = lineNumbers;
        this._columns = columns;
    }
    toString() {
        return ('[' + ( this._charCodes.map(
            (s, idx) => (s === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed ? '\\n' : String.fromCharCode(s)) + `-(${this._lineNumbers[idx]},${this._columns[idx]})`
        )).join(', ') + ']');
    }
    _assertIndex(index, arr) {
        if (index < 0 || index >= arr.length) {
            throw ( new Error(`Illegal index`));
        }
    }
    getElements() {
        return this._charCodes;
    }
    getStartLineNumber(i) {
        if (i > 0 && i === this._lineNumbers.length) {
            return this.getEndLineNumber(i - 1);
        }
        this._assertIndex(i, this._lineNumbers);
        return this._lineNumbers[i];
    }
    getEndLineNumber(i) {
        if (i === -1) {
            return this.getStartLineNumber(i + 1);
        }
        this._assertIndex(i, this._lineNumbers);
        if (this._charCodes[i] === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
            return this._lineNumbers[i] + 1;
        }
        return this._lineNumbers[i];
    }
    getStartColumn(i) {
        if (i > 0 && i === this._columns.length) {
            return this.getEndColumn(i - 1);
        }
        this._assertIndex(i, this._columns);
        return this._columns[i];
    }
    getEndColumn(i) {
        if (i === -1) {
            return this.getStartColumn(i + 1);
        }
        this._assertIndex(i, this._columns);
        if (this._charCodes[i] === _base_common_charCode_js__WEBPACK_IMPORTED_MODULE_0__.CharCode.LineFeed) {
            return 1;
        }
        return this._columns[i] + 1;
    }
}
class CharChange {
    constructor(originalStartLineNumber, originalStartColumn, originalEndLineNumber, originalEndColumn, modifiedStartLineNumber, modifiedStartColumn, modifiedEndLineNumber, modifiedEndColumn) {
        this.originalStartLineNumber = originalStartLineNumber;
        this.originalStartColumn = originalStartColumn;
        this.originalEndLineNumber = originalEndLineNumber;
        this.originalEndColumn = originalEndColumn;
        this.modifiedStartLineNumber = modifiedStartLineNumber;
        this.modifiedStartColumn = modifiedStartColumn;
        this.modifiedEndLineNumber = modifiedEndLineNumber;
        this.modifiedEndColumn = modifiedEndColumn;
    }
    static createFromDiffChange(diffChange, originalCharSequence, modifiedCharSequence) {
        const originalStartLineNumber = originalCharSequence.getStartLineNumber(diffChange.originalStart);
        const originalStartColumn = originalCharSequence.getStartColumn(diffChange.originalStart);
        const originalEndLineNumber = originalCharSequence.getEndLineNumber(diffChange.originalStart + diffChange.originalLength - 1);
        const originalEndColumn = originalCharSequence.getEndColumn(diffChange.originalStart + diffChange.originalLength - 1);
        const modifiedStartLineNumber = modifiedCharSequence.getStartLineNumber(diffChange.modifiedStart);
        const modifiedStartColumn = modifiedCharSequence.getStartColumn(diffChange.modifiedStart);
        const modifiedEndLineNumber = modifiedCharSequence.getEndLineNumber(diffChange.modifiedStart + diffChange.modifiedLength - 1);
        const modifiedEndColumn = modifiedCharSequence.getEndColumn(diffChange.modifiedStart + diffChange.modifiedLength - 1);
        return ( new CharChange(
            originalStartLineNumber,
            originalStartColumn,
            originalEndLineNumber,
            originalEndColumn,
            modifiedStartLineNumber,
            modifiedStartColumn,
            modifiedEndLineNumber,
            modifiedEndColumn
        ));
    }
}
function postProcessCharChanges(rawChanges) {
    if (rawChanges.length <= 1) {
        return rawChanges;
    }
    const result = [rawChanges[0]];
    let prevChange = result[0];
    for (let i = 1, len = rawChanges.length; i < len; i++) {
        const currChange = rawChanges[i];
        const originalMatchingLength = currChange.originalStart - (prevChange.originalStart + prevChange.originalLength);
        const modifiedMatchingLength = currChange.modifiedStart - (prevChange.modifiedStart + prevChange.modifiedLength);
        const matchingLength = Math.min(originalMatchingLength, modifiedMatchingLength);
        if (matchingLength < MINIMUM_MATCHING_CHARACTER_LENGTH) {
            prevChange.originalLength = (currChange.originalStart + currChange.originalLength) - prevChange.originalStart;
            prevChange.modifiedLength = (currChange.modifiedStart + currChange.modifiedLength) - prevChange.modifiedStart;
        }
        else {
            result.push(currChange);
            prevChange = currChange;
        }
    }
    return result;
}
class LineChange {
    constructor(originalStartLineNumber, originalEndLineNumber, modifiedStartLineNumber, modifiedEndLineNumber, charChanges) {
        this.originalStartLineNumber = originalStartLineNumber;
        this.originalEndLineNumber = originalEndLineNumber;
        this.modifiedStartLineNumber = modifiedStartLineNumber;
        this.modifiedEndLineNumber = modifiedEndLineNumber;
        this.charChanges = charChanges;
    }
    static createFromDiffResult(shouldIgnoreTrimWhitespace, diffChange, originalLineSequence, modifiedLineSequence, continueCharDiff, shouldComputeCharChanges, shouldPostProcessCharChanges) {
        let originalStartLineNumber;
        let originalEndLineNumber;
        let modifiedStartLineNumber;
        let modifiedEndLineNumber;
        let charChanges = undefined;
        if (diffChange.originalLength === 0) {
            originalStartLineNumber = originalLineSequence.getStartLineNumber(diffChange.originalStart) - 1;
            originalEndLineNumber = 0;
        }
        else {
            originalStartLineNumber = originalLineSequence.getStartLineNumber(diffChange.originalStart);
            originalEndLineNumber = originalLineSequence.getEndLineNumber(diffChange.originalStart + diffChange.originalLength - 1);
        }
        if (diffChange.modifiedLength === 0) {
            modifiedStartLineNumber = modifiedLineSequence.getStartLineNumber(diffChange.modifiedStart) - 1;
            modifiedEndLineNumber = 0;
        }
        else {
            modifiedStartLineNumber = modifiedLineSequence.getStartLineNumber(diffChange.modifiedStart);
            modifiedEndLineNumber = modifiedLineSequence.getEndLineNumber(diffChange.modifiedStart + diffChange.modifiedLength - 1);
        }
        if (shouldComputeCharChanges && diffChange.originalLength > 0 && diffChange.originalLength < 20 && diffChange.modifiedLength > 0 && diffChange.modifiedLength < 20 && continueCharDiff()) {
            const originalCharSequence = originalLineSequence.createCharSequence(shouldIgnoreTrimWhitespace, diffChange.originalStart, diffChange.originalStart + diffChange.originalLength - 1);
            const modifiedCharSequence = modifiedLineSequence.createCharSequence(shouldIgnoreTrimWhitespace, diffChange.modifiedStart, diffChange.modifiedStart + diffChange.modifiedLength - 1);
            if (originalCharSequence.getElements().length > 0 && modifiedCharSequence.getElements().length > 0) {
                let rawChanges = computeDiff(originalCharSequence, modifiedCharSequence, continueCharDiff, true).changes;
                if (shouldPostProcessCharChanges) {
                    rawChanges = postProcessCharChanges(rawChanges);
                }
                charChanges = [];
                for (let i = 0, length = rawChanges.length; i < length; i++) {
                    charChanges.push(CharChange.createFromDiffChange(rawChanges[i], originalCharSequence, modifiedCharSequence));
                }
            }
        }
        return ( new LineChange(
            originalStartLineNumber,
            originalEndLineNumber,
            modifiedStartLineNumber,
            modifiedEndLineNumber,
            charChanges
        ));
    }
}
class DiffComputer {
    constructor(originalLines, modifiedLines, opts) {
        this.shouldComputeCharChanges = opts.shouldComputeCharChanges;
        this.shouldPostProcessCharChanges = opts.shouldPostProcessCharChanges;
        this.shouldIgnoreTrimWhitespace = opts.shouldIgnoreTrimWhitespace;
        this.shouldMakePrettyDiff = opts.shouldMakePrettyDiff;
        this.originalLines = originalLines;
        this.modifiedLines = modifiedLines;
        this.original = ( new LineSequence(originalLines));
        this.modified = ( new LineSequence(modifiedLines));
        this.continueLineDiff = createContinueProcessingPredicate(opts.maxComputationTime);
        this.continueCharDiff = createContinueProcessingPredicate(opts.maxComputationTime === 0 ? 0 : Math.min(opts.maxComputationTime, 5000));
    }
    computeDiff() {
        if (this.original.lines.length === 1 && this.original.lines[0].length === 0) {
            if (this.modified.lines.length === 1 && this.modified.lines[0].length === 0) {
                return {
                    quitEarly: false,
                    changes: []
                };
            }
            return {
                quitEarly: false,
                changes: [{
                        originalStartLineNumber: 1,
                        originalEndLineNumber: 1,
                        modifiedStartLineNumber: 1,
                        modifiedEndLineNumber: this.modified.lines.length,
                        charChanges: undefined
                    }]
            };
        }
        if (this.modified.lines.length === 1 && this.modified.lines[0].length === 0) {
            return {
                quitEarly: false,
                changes: [{
                        originalStartLineNumber: 1,
                        originalEndLineNumber: this.original.lines.length,
                        modifiedStartLineNumber: 1,
                        modifiedEndLineNumber: 1,
                        charChanges: undefined
                    }]
            };
        }
        const diffResult = computeDiff(this.original, this.modified, this.continueLineDiff, this.shouldMakePrettyDiff);
        const rawChanges = diffResult.changes;
        const quitEarly = diffResult.quitEarly;
        if (this.shouldIgnoreTrimWhitespace) {
            const lineChanges = [];
            for (let i = 0, length = rawChanges.length; i < length; i++) {
                lineChanges.push(LineChange.createFromDiffResult(this.shouldIgnoreTrimWhitespace, rawChanges[i], this.original, this.modified, this.continueCharDiff, this.shouldComputeCharChanges, this.shouldPostProcessCharChanges));
            }
            return {
                quitEarly: quitEarly,
                changes: lineChanges
            };
        }
        const result = [];
        let originalLineIndex = 0;
        let modifiedLineIndex = 0;
        for (let i = -1 , len = rawChanges.length; i < len; i++) {
            const nextChange = (i + 1 < len ? rawChanges[i + 1] : null);
            const originalStop = (nextChange ? nextChange.originalStart : this.originalLines.length);
            const modifiedStop = (nextChange ? nextChange.modifiedStart : this.modifiedLines.length);
            while (originalLineIndex < originalStop && modifiedLineIndex < modifiedStop) {
                const originalLine = this.originalLines[originalLineIndex];
                const modifiedLine = this.modifiedLines[modifiedLineIndex];
                if (originalLine !== modifiedLine) {
                    {
                        let originalStartColumn = getFirstNonBlankColumn(originalLine, 1);
                        let modifiedStartColumn = getFirstNonBlankColumn(modifiedLine, 1);
                        while (originalStartColumn > 1 && modifiedStartColumn > 1) {
                            const originalChar = originalLine.charCodeAt(originalStartColumn - 2);
                            const modifiedChar = modifiedLine.charCodeAt(modifiedStartColumn - 2);
                            if (originalChar !== modifiedChar) {
                                break;
                            }
                            originalStartColumn--;
                            modifiedStartColumn--;
                        }
                        if (originalStartColumn > 1 || modifiedStartColumn > 1) {
                            this._pushTrimWhitespaceCharChange(result, originalLineIndex + 1, 1, originalStartColumn, modifiedLineIndex + 1, 1, modifiedStartColumn);
                        }
                    }
                    {
                        let originalEndColumn = getLastNonBlankColumn(originalLine, 1);
                        let modifiedEndColumn = getLastNonBlankColumn(modifiedLine, 1);
                        const originalMaxColumn = originalLine.length + 1;
                        const modifiedMaxColumn = modifiedLine.length + 1;
                        while (originalEndColumn < originalMaxColumn && modifiedEndColumn < modifiedMaxColumn) {
                            const originalChar = originalLine.charCodeAt(originalEndColumn - 1);
                            const modifiedChar = originalLine.charCodeAt(modifiedEndColumn - 1);
                            if (originalChar !== modifiedChar) {
                                break;
                            }
                            originalEndColumn++;
                            modifiedEndColumn++;
                        }
                        if (originalEndColumn < originalMaxColumn || modifiedEndColumn < modifiedMaxColumn) {
                            this._pushTrimWhitespaceCharChange(result, originalLineIndex + 1, originalEndColumn, originalMaxColumn, modifiedLineIndex + 1, modifiedEndColumn, modifiedMaxColumn);
                        }
                    }
                }
                originalLineIndex++;
                modifiedLineIndex++;
            }
            if (nextChange) {
                result.push(LineChange.createFromDiffResult(this.shouldIgnoreTrimWhitespace, nextChange, this.original, this.modified, this.continueCharDiff, this.shouldComputeCharChanges, this.shouldPostProcessCharChanges));
                originalLineIndex += nextChange.originalLength;
                modifiedLineIndex += nextChange.modifiedLength;
            }
        }
        return {
            quitEarly: quitEarly,
            changes: result
        };
    }
    _pushTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn) {
        if (this._mergeTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn)) {
            return;
        }
        let charChanges = undefined;
        if (this.shouldComputeCharChanges) {
            charChanges = [( new CharChange(
                originalLineNumber,
                originalStartColumn,
                originalLineNumber,
                originalEndColumn,
                modifiedLineNumber,
                modifiedStartColumn,
                modifiedLineNumber,
                modifiedEndColumn
            ))];
        }
        result.push(( new LineChange(
            originalLineNumber,
            originalLineNumber,
            modifiedLineNumber,
            modifiedLineNumber,
            charChanges
        )));
    }
    _mergeTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn) {
        const len = result.length;
        if (len === 0) {
            return false;
        }
        const prevChange = result[len - 1];
        if (prevChange.originalEndLineNumber === 0 || prevChange.modifiedEndLineNumber === 0) {
            return false;
        }
        if (prevChange.originalEndLineNumber === originalLineNumber && prevChange.modifiedEndLineNumber === modifiedLineNumber) {
            if (this.shouldComputeCharChanges && prevChange.charChanges) {
                prevChange.charChanges.push(( new CharChange(
                    originalLineNumber,
                    originalStartColumn,
                    originalLineNumber,
                    originalEndColumn,
                    modifiedLineNumber,
                    modifiedStartColumn,
                    modifiedLineNumber,
                    modifiedEndColumn
                )));
            }
            return true;
        }
        if (prevChange.originalEndLineNumber + 1 === originalLineNumber && prevChange.modifiedEndLineNumber + 1 === modifiedLineNumber) {
            prevChange.originalEndLineNumber = originalLineNumber;
            prevChange.modifiedEndLineNumber = modifiedLineNumber;
            if (this.shouldComputeCharChanges && prevChange.charChanges) {
                prevChange.charChanges.push(( new CharChange(
                    originalLineNumber,
                    originalStartColumn,
                    originalLineNumber,
                    originalEndColumn,
                    modifiedLineNumber,
                    modifiedStartColumn,
                    modifiedLineNumber,
                    modifiedEndColumn
                )));
            }
            return true;
        }
        return false;
    }
}
function getFirstNonBlankColumn(txt, defaultValue) {
    const r = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_4__.firstNonWhitespaceIndex)(txt);
    if (r === -1) {
        return defaultValue;
    }
    return r + 1;
}
function getLastNonBlankColumn(txt, defaultValue) {
    const r = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_4__.lastNonWhitespaceIndex)(txt);
    if (r === -1) {
        return defaultValue;
    }
    return r + 2;
}
function createContinueProcessingPredicate(maximumRuntime) {
    if (maximumRuntime === 0) {
        return () => true;
    }
    const startTime = Date.now();
    return () => {
        return Date.now() - startTime < maximumRuntime;
    };
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/linesDiffComputer.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/linesDiffComputer.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinesDiff: () => (/* binding */ LinesDiff),
/* harmony export */   MovedText: () => (/* binding */ MovedText)
/* harmony export */ });
class LinesDiff {
    constructor(changes,
    moves,
    hitTimeout) {
        this.changes = changes;
        this.moves = moves;
        this.hitTimeout = hitTimeout;
    }
}
class MovedText {
    constructor(lineRangeMapping, changes) {
        this.lineRangeMapping = lineRangeMapping;
        this.changes = changes;
    }
    flip() {
        return ( new MovedText(this.lineRangeMapping.flip(), ( this.changes.map(c => c.flip()))));
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/linesDiffComputers.js":
/*!************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/linesDiffComputers.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   linesDiffComputers: () => (/* binding */ linesDiffComputers)
/* harmony export */ });
/* harmony import */ var _legacyLinesDiffComputer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./legacyLinesDiffComputer.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/legacyLinesDiffComputer.js");
/* harmony import */ var _defaultLinesDiffComputer_defaultLinesDiffComputer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./defaultLinesDiffComputer/defaultLinesDiffComputer.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/defaultLinesDiffComputer/defaultLinesDiffComputer.js");


const linesDiffComputers = {
    getLegacy: () => ( new _legacyLinesDiffComputer_js__WEBPACK_IMPORTED_MODULE_0__.LegacyLinesDiffComputer()),
    getDefault: () => ( new _defaultLinesDiffComputer_defaultLinesDiffComputer_js__WEBPACK_IMPORTED_MODULE_1__.DefaultLinesDiffComputer()),
};



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/diff/rangeMapping.js":
/*!******************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/diff/rangeMapping.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DetailedLineRangeMapping: () => (/* binding */ DetailedLineRangeMapping),
/* harmony export */   LineRangeMapping: () => (/* binding */ LineRangeMapping),
/* harmony export */   RangeMapping: () => (/* binding */ RangeMapping)
/* harmony export */ });
/* harmony import */ var _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/lineRange.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/lineRange.js");
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _core_textEdit_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/textEdit.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/textEdit.js");




class LineRangeMapping {
    static inverse(mapping, originalLineCount, modifiedLineCount) {
        const result = [];
        let lastOriginalEndLineNumber = 1;
        let lastModifiedEndLineNumber = 1;
        for (const m of mapping) {
            const r = ( new LineRangeMapping(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__.LineRange(lastOriginalEndLineNumber, m.original.startLineNumber)), ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__.LineRange(lastModifiedEndLineNumber, m.modified.startLineNumber))));
            if (!r.modified.isEmpty) {
                result.push(r);
            }
            lastOriginalEndLineNumber = m.original.endLineNumberExclusive;
            lastModifiedEndLineNumber = m.modified.endLineNumberExclusive;
        }
        const r = ( new LineRangeMapping(( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__.LineRange(lastOriginalEndLineNumber, originalLineCount + 1)), ( new _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__.LineRange(lastModifiedEndLineNumber, modifiedLineCount + 1))));
        if (!r.modified.isEmpty) {
            result.push(r);
        }
        return result;
    }
    static clip(mapping, originalRange, modifiedRange) {
        const result = [];
        for (const m of mapping) {
            const original = m.original.intersect(originalRange);
            const modified = m.modified.intersect(modifiedRange);
            if (original && !original.isEmpty && modified && !modified.isEmpty) {
                result.push(( new LineRangeMapping(original, modified)));
            }
        }
        return result;
    }
    constructor(originalRange, modifiedRange) {
        this.original = originalRange;
        this.modified = modifiedRange;
    }
    toString() {
        return `{${( this.original.toString())}->${( this.modified.toString())}}`;
    }
    flip() {
        return ( new LineRangeMapping(this.modified, this.original));
    }
    join(other) {
        return ( new LineRangeMapping(this.original.join(other.original), this.modified.join(other.modified)));
    }
    get changedLineCount() {
        return Math.max(this.original.length, this.modified.length);
    }
    toRangeMapping() {
        const origInclusiveRange = this.original.toInclusiveRange();
        const modInclusiveRange = this.modified.toInclusiveRange();
        if (origInclusiveRange && modInclusiveRange) {
            return ( new RangeMapping(origInclusiveRange, modInclusiveRange));
        }
        else if (this.original.startLineNumber === 1 || this.modified.startLineNumber === 1) {
            if (!(this.modified.startLineNumber === 1 && this.original.startLineNumber === 1)) {
                throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_0__.BugIndicatingError('not a valid diff'));
            }
            return ( new RangeMapping(( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(this.original.startLineNumber, 1, this.original.endLineNumberExclusive, 1)), ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(this.modified.startLineNumber, 1, this.modified.endLineNumberExclusive, 1))));
        }
        else {
            return ( new RangeMapping(( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                this.original.startLineNumber - 1,
                Number.MAX_SAFE_INTEGER,
                this.original.endLineNumberExclusive - 1,
                Number.MAX_SAFE_INTEGER
            )), ( new _core_range_js__WEBPACK_IMPORTED_MODULE_2__.Range(
                this.modified.startLineNumber - 1,
                Number.MAX_SAFE_INTEGER,
                this.modified.endLineNumberExclusive - 1,
                Number.MAX_SAFE_INTEGER
            ))));
        }
    }
}
class DetailedLineRangeMapping extends LineRangeMapping {
    static fromRangeMappings(rangeMappings) {
        const originalRange = _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__.LineRange.join(( rangeMappings.map(r => _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__.LineRange.fromRangeInclusive(r.originalRange))));
        const modifiedRange = _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__.LineRange.join(( rangeMappings.map(r => _core_lineRange_js__WEBPACK_IMPORTED_MODULE_1__.LineRange.fromRangeInclusive(r.modifiedRange))));
        return ( new DetailedLineRangeMapping(originalRange, modifiedRange, rangeMappings));
    }
    constructor(originalRange, modifiedRange, innerChanges) {
        super(originalRange, modifiedRange);
        this.innerChanges = innerChanges;
    }
    flip() {
        return ( new DetailedLineRangeMapping(this.modified, this.original, this.innerChanges?.map(c => c.flip())));
    }
    withInnerChangesFromLineRanges() {
        return ( new DetailedLineRangeMapping(this.original, this.modified, [this.toRangeMapping()]));
    }
}
class RangeMapping {
    constructor(originalRange, modifiedRange) {
        this.originalRange = originalRange;
        this.modifiedRange = modifiedRange;
    }
    toString() {
        return `{${( this.originalRange.toString())}->${( this.modifiedRange.toString())}}`;
    }
    flip() {
        return ( new RangeMapping(this.modifiedRange, this.originalRange));
    }
    toTextEdit(modified) {
        const newText = modified.getValueOfRange(this.modifiedRange);
        return ( new _core_textEdit_js__WEBPACK_IMPORTED_MODULE_3__.SingleTextEdit(this.originalRange, newText));
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/languages/defaultDocumentColorsComputer.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/languages/defaultDocumentColorsComputer.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   computeDefaultDocumentColors: () => (/* binding */ computeDefaultDocumentColors)
/* harmony export */ });
/* harmony import */ var _base_common_color_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/color.js */ "./node_modules/vscode/vscode/src/vs/base/common/color.js");

function _parseCaptureGroups(captureGroups) {
    const values = [];
    for (const captureGroup of captureGroups) {
        const parsedNumber = Number(captureGroup);
        if (parsedNumber || parsedNumber === 0 && captureGroup.replace(/\s/g, '') !== '') {
            values.push(parsedNumber);
        }
    }
    return values;
}
function _toIColor(r, g, b, a) {
    return {
        red: r / 255,
        blue: b / 255,
        green: g / 255,
        alpha: a
    };
}
function _findRange(model, match) {
    const index = match.index;
    const length = match[0].length;
    if (!index) {
        return;
    }
    const startPosition = model.positionAt(index);
    const range = {
        startLineNumber: startPosition.lineNumber,
        startColumn: startPosition.column,
        endLineNumber: startPosition.lineNumber,
        endColumn: startPosition.column + length
    };
    return range;
}
function _findHexColorInformation(range, hexValue) {
    if (!range) {
        return;
    }
    const parsedHexColor = _base_common_color_js__WEBPACK_IMPORTED_MODULE_0__.Color.Format.CSS.parseHex(hexValue);
    if (!parsedHexColor) {
        return;
    }
    return {
        range: range,
        color: _toIColor(parsedHexColor.rgba.r, parsedHexColor.rgba.g, parsedHexColor.rgba.b, parsedHexColor.rgba.a)
    };
}
function _findRGBColorInformation(range, matches, isAlpha) {
    if (!range || matches.length !== 1) {
        return;
    }
    const match = matches[0];
    const captureGroups = ( match.values());
    const parsedRegex = _parseCaptureGroups(captureGroups);
    return {
        range: range,
        color: _toIColor(parsedRegex[0], parsedRegex[1], parsedRegex[2], isAlpha ? parsedRegex[3] : 1)
    };
}
function _findHSLColorInformation(range, matches, isAlpha) {
    if (!range || matches.length !== 1) {
        return;
    }
    const match = matches[0];
    const captureGroups = ( match.values());
    const parsedRegex = _parseCaptureGroups(captureGroups);
    const colorEquivalent = ( new _base_common_color_js__WEBPACK_IMPORTED_MODULE_0__.Color(( new _base_common_color_js__WEBPACK_IMPORTED_MODULE_0__.HSLA(
        parsedRegex[0],
        parsedRegex[1] / 100,
        parsedRegex[2] / 100,
        isAlpha ? parsedRegex[3] : 1
    ))));
    return {
        range: range,
        color: _toIColor(colorEquivalent.rgba.r, colorEquivalent.rgba.g, colorEquivalent.rgba.b, colorEquivalent.rgba.a)
    };
}
function _findMatches(model, regex) {
    if (typeof model === 'string') {
        return [...model.matchAll(regex)];
    }
    else {
        return model.findMatches(regex);
    }
}
function computeColors(model) {
    const result = [];
    const initialValidationRegex = /\b(rgb|rgba|hsl|hsla)(\([0-9\s,.\%]*\))|(#)([A-Fa-f0-9]{3})\b|(#)([A-Fa-f0-9]{4})\b|(#)([A-Fa-f0-9]{6})\b|(#)([A-Fa-f0-9]{8})\b/gm;
    const initialValidationMatches = _findMatches(model, initialValidationRegex);
    if (initialValidationMatches.length > 0) {
        for (const initialMatch of initialValidationMatches) {
            const initialCaptureGroups = initialMatch.filter(captureGroup => captureGroup !== undefined);
            const colorScheme = initialCaptureGroups[1];
            const colorParameters = initialCaptureGroups[2];
            if (!colorParameters) {
                continue;
            }
            let colorInformation;
            if (colorScheme === 'rgb') {
                const regexParameters = /^\(\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*\)$/gm;
                colorInformation = _findRGBColorInformation(_findRange(model, initialMatch), _findMatches(colorParameters, regexParameters), false);
            }
            else if (colorScheme === 'rgba') {
                const regexParameters = /^\(\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(0[.][0-9]+|[.][0-9]+|[01][.]|[01])\s*\)$/gm;
                colorInformation = _findRGBColorInformation(_findRange(model, initialMatch), _findMatches(colorParameters, regexParameters), true);
            }
            else if (colorScheme === 'hsl') {
                const regexParameters = /^\(\s*(36[0]|3[0-5][0-9]|[12][0-9][0-9]|[1-9]?[0-9])\s*,\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*,\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*\)$/gm;
                colorInformation = _findHSLColorInformation(_findRange(model, initialMatch), _findMatches(colorParameters, regexParameters), false);
            }
            else if (colorScheme === 'hsla') {
                const regexParameters = /^\(\s*(36[0]|3[0-5][0-9]|[12][0-9][0-9]|[1-9]?[0-9])\s*,\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*,\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*,\s*(0[.][0-9]+|[.][0-9]+|[01][.]|[01])\s*\)$/gm;
                colorInformation = _findHSLColorInformation(_findRange(model, initialMatch), _findMatches(colorParameters, regexParameters), true);
            }
            else if (colorScheme === '#') {
                colorInformation = _findHexColorInformation(_findRange(model, initialMatch), colorScheme + colorParameters);
            }
            if (colorInformation) {
                result.push(colorInformation);
            }
        }
    }
    return result;
}
function computeDefaultDocumentColors(model) {
    if (!model || typeof model.getValue !== 'function' || typeof model.positionAt !== 'function') {
        return [];
    }
    return computeColors(model);
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/languages/supports/inplaceReplaceSupport.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/languages/supports/inplaceReplaceSupport.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BasicInplaceReplace: () => (/* binding */ BasicInplaceReplace)
/* harmony export */ });
class BasicInplaceReplace {
    constructor() {
        this._defaultValueSet = [
            ['true', 'false'],
            ['True', 'False'],
            ['Private', 'Public', 'Friend', 'ReadOnly', 'Partial', 'Protected', 'WriteOnly'],
            ['public', 'protected', 'private'],
        ];
    }
    static { this.INSTANCE = ( new BasicInplaceReplace()); }
    navigateValueSet(range1, text1, range2, text2, up) {
        if (range1 && text1) {
            const result = this.doNavigateValueSet(text1, up);
            if (result) {
                return {
                    range: range1,
                    value: result
                };
            }
        }
        if (range2 && text2) {
            const result = this.doNavigateValueSet(text2, up);
            if (result) {
                return {
                    range: range2,
                    value: result
                };
            }
        }
        return null;
    }
    doNavigateValueSet(text, up) {
        const numberResult = this.numberReplace(text, up);
        if (numberResult !== null) {
            return numberResult;
        }
        return this.textReplace(text, up);
    }
    numberReplace(value, up) {
        const precision = Math.pow(10, value.length - (value.lastIndexOf('.') + 1));
        let n1 = Number(value);
        const n2 = parseFloat(value);
        if (!isNaN(n1) && !isNaN(n2) && n1 === n2) {
            if (n1 === 0 && !up) {
                return null;
            }
            else {
                n1 = Math.floor(n1 * precision);
                n1 += up ? precision : -precision;
                return String(n1 / precision);
            }
        }
        return null;
    }
    textReplace(value, up) {
        return this.valueSetsReplace(this._defaultValueSet, value, up);
    }
    valueSetsReplace(valueSets, value, up) {
        let result = null;
        for (let i = 0, len = valueSets.length; result === null && i < len; i++) {
            result = this.valueSetReplace(valueSets[i], value, up);
        }
        return result;
    }
    valueSetReplace(valueSet, value, up) {
        let idx = valueSet.indexOf(value);
        if (idx >= 0) {
            idx += up ? +1 : -1;
            if (idx < 0) {
                idx = valueSet.length - 1;
            }
            else {
                idx %= valueSet.length;
            }
            return valueSet[idx];
        }
        return null;
    }
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/services/editorBaseApi.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/services/editorBaseApi.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KeyMod: () => (/* binding */ KeyMod),
/* harmony export */   createMonacoBaseAPI: () => (/* binding */ createMonacoBaseAPI)
/* harmony export */ });
/* harmony import */ var _base_common_cancellation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/cancellation.js */ "./node_modules/vscode/vscode/src/vs/base/common/cancellation.js");
/* harmony import */ var _base_common_event_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/event.js */ "./node_modules/vscode/vscode/src/vs/base/common/event.js");
/* harmony import */ var _base_common_keyCodes_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../base/common/keyCodes.js */ "./node_modules/vscode/vscode/src/vs/base/common/keyCodes.js");
/* harmony import */ var _base_common_uri_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../base/common/uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");
/* harmony import */ var _core_position_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/position.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/position.js");
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _core_selection_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/selection.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/selection.js");
/* harmony import */ var _languages_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../languages.js */ "./node_modules/vscode/vscode/src/vs/editor/common/languages.js");
/* harmony import */ var _standalone_standaloneEnums_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../standalone/standaloneEnums.js */ "./node_modules/vscode/vscode/src/vs/editor/common/standalone/standaloneEnums.js");









class KeyMod {
    static { this.CtrlCmd = _base_common_keyCodes_js__WEBPACK_IMPORTED_MODULE_2__.KeyMod.CtrlCmd; }
    static { this.Shift = _base_common_keyCodes_js__WEBPACK_IMPORTED_MODULE_2__.KeyMod.Shift; }
    static { this.Alt = _base_common_keyCodes_js__WEBPACK_IMPORTED_MODULE_2__.KeyMod.Alt; }
    static { this.WinCtrl = _base_common_keyCodes_js__WEBPACK_IMPORTED_MODULE_2__.KeyMod.WinCtrl; }
    static chord(firstPart, secondPart) {
        return (0,_base_common_keyCodes_js__WEBPACK_IMPORTED_MODULE_2__.KeyChord)(firstPart, secondPart);
    }
}
function createMonacoBaseAPI() {
    return {
        editor: undefined,
        languages: undefined,
        CancellationTokenSource: _base_common_cancellation_js__WEBPACK_IMPORTED_MODULE_0__.CancellationTokenSource,
        Emitter: _base_common_event_js__WEBPACK_IMPORTED_MODULE_1__.Emitter,
        KeyCode: _standalone_standaloneEnums_js__WEBPACK_IMPORTED_MODULE_8__.KeyCode,
        KeyMod: KeyMod,
        Position: _core_position_js__WEBPACK_IMPORTED_MODULE_4__.Position,
        Range: _core_range_js__WEBPACK_IMPORTED_MODULE_5__.Range,
        Selection: _core_selection_js__WEBPACK_IMPORTED_MODULE_6__.Selection,
        SelectionDirection: _standalone_standaloneEnums_js__WEBPACK_IMPORTED_MODULE_8__.SelectionDirection,
        MarkerSeverity: _standalone_standaloneEnums_js__WEBPACK_IMPORTED_MODULE_8__.MarkerSeverity,
        MarkerTag: _standalone_standaloneEnums_js__WEBPACK_IMPORTED_MODULE_8__.MarkerTag,
        Uri: _base_common_uri_js__WEBPACK_IMPORTED_MODULE_3__.URI,
        Token: _languages_js__WEBPACK_IMPORTED_MODULE_7__.Token
    };
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/services/editorSimpleWorker.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/services/editorSimpleWorker.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EditorSimpleWorker: () => (/* binding */ EditorSimpleWorker)
/* harmony export */ });
/* harmony import */ var _base_common_diff_diff_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../base/common/diff/diff.js */ "./node_modules/vscode/vscode/src/vs/base/common/diff/diff.js");
/* harmony import */ var _base_common_uri_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../base/common/uri.js */ "./node_modules/vscode/vscode/src/vs/base/common/uri.js");
/* harmony import */ var _core_position_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/position.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/position.js");
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _model_mirrorTextModel_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/mirrorTextModel.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model/mirrorTextModel.js");
/* harmony import */ var _core_wordHelper_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/wordHelper.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/wordHelper.js");
/* harmony import */ var _languages_linkComputer_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../languages/linkComputer.js */ "./node_modules/vscode/vscode/src/vs/editor/common/languages/linkComputer.js");
/* harmony import */ var _languages_supports_inplaceReplaceSupport_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../languages/supports/inplaceReplaceSupport.js */ "./node_modules/vscode/vscode/src/vs/editor/common/languages/supports/inplaceReplaceSupport.js");
/* harmony import */ var _editorBaseApi_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./editorBaseApi.js */ "./node_modules/vscode/vscode/src/vs/editor/common/services/editorBaseApi.js");
/* harmony import */ var _base_common_stopwatch_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../base/common/stopwatch.js */ "./node_modules/vscode/vscode/src/vs/base/common/stopwatch.js");
/* harmony import */ var _unicodeTextModelHighlighter_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./unicodeTextModelHighlighter.js */ "./node_modules/vscode/vscode/src/vs/editor/common/services/unicodeTextModelHighlighter.js");
/* harmony import */ var _diff_legacyLinesDiffComputer_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../diff/legacyLinesDiffComputer.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/legacyLinesDiffComputer.js");
/* harmony import */ var _diff_linesDiffComputers_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../diff/linesDiffComputers.js */ "./node_modules/vscode/vscode/src/vs/editor/common/diff/linesDiffComputers.js");
/* harmony import */ var _base_common_objects_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../base/common/objects.js */ "./node_modules/vscode/vscode/src/vs/base/common/objects.js");
/* harmony import */ var _base_common_errors_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../base/common/errors.js */ "./node_modules/vscode/vscode/src/vs/base/common/errors.js");
/* harmony import */ var _languages_defaultDocumentColorsComputer_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../languages/defaultDocumentColorsComputer.js */ "./node_modules/vscode/vscode/src/vs/editor/common/languages/defaultDocumentColorsComputer.js");
/* harmony import */ var _findSectionHeaders_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./findSectionHeaders.js */ "./node_modules/vscode/vscode/src/vs/editor/common/services/findSectionHeaders.js");

















class MirrorModel extends _model_mirrorTextModel_js__WEBPACK_IMPORTED_MODULE_4__.MirrorTextModel {
    get uri() {
        return this._uri;
    }
    get eol() {
        return this._eol;
    }
    getValue() {
        return this.getText();
    }
    findMatches(regex) {
        const matches = [];
        for (let i = 0; i < this._lines.length; i++) {
            const line = this._lines[i];
            const offsetToAdd = this.offsetAt(( new _core_position_js__WEBPACK_IMPORTED_MODULE_2__.Position(i + 1, 1)));
            const iteratorOverMatches = line.matchAll(regex);
            for (const match of iteratorOverMatches) {
                if (match.index || match.index === 0) {
                    match.index = match.index + offsetToAdd;
                }
                matches.push(match);
            }
        }
        return matches;
    }
    getLinesContent() {
        return this._lines.slice(0);
    }
    getLineCount() {
        return this._lines.length;
    }
    getLineContent(lineNumber) {
        return this._lines[lineNumber - 1];
    }
    getWordAtPosition(position, wordDefinition) {
        const wordAtText = (0,_core_wordHelper_js__WEBPACK_IMPORTED_MODULE_5__.getWordAtText)(position.column, (0,_core_wordHelper_js__WEBPACK_IMPORTED_MODULE_5__.ensureValidWordDefinition)(wordDefinition), this._lines[position.lineNumber - 1], 0);
        if (wordAtText) {
            return ( new _core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range(
                position.lineNumber,
                wordAtText.startColumn,
                position.lineNumber,
                wordAtText.endColumn
            ));
        }
        return null;
    }
    getWordUntilPosition(position, wordDefinition) {
        const wordAtPosition = this.getWordAtPosition(position, wordDefinition);
        if (!wordAtPosition) {
            return {
                word: '',
                startColumn: position.column,
                endColumn: position.column
            };
        }
        return {
            word: this._lines[position.lineNumber - 1].substring(wordAtPosition.startColumn - 1, position.column - 1),
            startColumn: wordAtPosition.startColumn,
            endColumn: position.column
        };
    }
    words(wordDefinition) {
        const lines = this._lines;
        const wordenize = this._wordenize.bind(this);
        let lineNumber = 0;
        let lineText = '';
        let wordRangesIdx = 0;
        let wordRanges = [];
        return {
            *[Symbol.iterator]() {
                while (true) {
                    if (wordRangesIdx < wordRanges.length) {
                        const value = lineText.substring(wordRanges[wordRangesIdx].start, wordRanges[wordRangesIdx].end);
                        wordRangesIdx += 1;
                        yield value;
                    }
                    else {
                        if (lineNumber < lines.length) {
                            lineText = lines[lineNumber];
                            wordRanges = wordenize(lineText, wordDefinition);
                            wordRangesIdx = 0;
                            lineNumber += 1;
                        }
                        else {
                            break;
                        }
                    }
                }
            }
        };
    }
    getLineWords(lineNumber, wordDefinition) {
        const content = this._lines[lineNumber - 1];
        const ranges = this._wordenize(content, wordDefinition);
        const words = [];
        for (const range of ranges) {
            words.push({
                word: content.substring(range.start, range.end),
                startColumn: range.start + 1,
                endColumn: range.end + 1
            });
        }
        return words;
    }
    _wordenize(content, wordDefinition) {
        const result = [];
        let match;
        wordDefinition.lastIndex = 0;
        while (match = wordDefinition.exec(content)) {
            if (match[0].length === 0) {
                break;
            }
            result.push({ start: match.index, end: match.index + match[0].length });
        }
        return result;
    }
    getValueInRange(range) {
        range = this._validateRange(range);
        if (range.startLineNumber === range.endLineNumber) {
            return this._lines[range.startLineNumber - 1].substring(range.startColumn - 1, range.endColumn - 1);
        }
        const lineEnding = this._eol;
        const startLineIndex = range.startLineNumber - 1;
        const endLineIndex = range.endLineNumber - 1;
        const resultLines = [];
        resultLines.push(this._lines[startLineIndex].substring(range.startColumn - 1));
        for (let i = startLineIndex + 1; i < endLineIndex; i++) {
            resultLines.push(this._lines[i]);
        }
        resultLines.push(this._lines[endLineIndex].substring(0, range.endColumn - 1));
        return resultLines.join(lineEnding);
    }
    offsetAt(position) {
        position = this._validatePosition(position);
        this._ensureLineStarts();
        return this._lineStarts.getPrefixSum(position.lineNumber - 2) + (position.column - 1);
    }
    positionAt(offset) {
        offset = Math.floor(offset);
        offset = Math.max(0, offset);
        this._ensureLineStarts();
        const out = this._lineStarts.getIndexOf(offset);
        const lineLength = this._lines[out.index].length;
        return {
            lineNumber: 1 + out.index,
            column: 1 + Math.min(out.remainder, lineLength)
        };
    }
    _validateRange(range) {
        const start = this._validatePosition({ lineNumber: range.startLineNumber, column: range.startColumn });
        const end = this._validatePosition({ lineNumber: range.endLineNumber, column: range.endColumn });
        if (start.lineNumber !== range.startLineNumber
            || start.column !== range.startColumn
            || end.lineNumber !== range.endLineNumber
            || end.column !== range.endColumn) {
            return {
                startLineNumber: start.lineNumber,
                startColumn: start.column,
                endLineNumber: end.lineNumber,
                endColumn: end.column
            };
        }
        return range;
    }
    _validatePosition(position) {
        if (!_core_position_js__WEBPACK_IMPORTED_MODULE_2__.Position.isIPosition(position)) {
            throw ( new Error('bad position'));
        }
        let { lineNumber, column } = position;
        let hasChanged = false;
        if (lineNumber < 1) {
            lineNumber = 1;
            column = 1;
            hasChanged = true;
        }
        else if (lineNumber > this._lines.length) {
            lineNumber = this._lines.length;
            column = this._lines[lineNumber - 1].length + 1;
            hasChanged = true;
        }
        else {
            const maxCharacter = this._lines[lineNumber - 1].length + 1;
            if (column < 1) {
                column = 1;
                hasChanged = true;
            }
            else if (column > maxCharacter) {
                column = maxCharacter;
                hasChanged = true;
            }
        }
        if (!hasChanged) {
            return position;
        }
        else {
            return { lineNumber, column };
        }
    }
}
class EditorSimpleWorker {
    constructor(host, foreignModuleFactory) {
        this._host = host;
        this._models = Object.create(null);
        this._foreignModuleFactory = foreignModuleFactory;
        this._foreignModule = null;
    }
    dispose() {
        this._models = Object.create(null);
    }
    _getModel(uri) {
        return this._models[uri];
    }
    _getModels() {
        const all = [];
        ( Object.keys(this._models)).forEach((key) => all.push(this._models[key]));
        return all;
    }
    acceptNewModel(data) {
        this._models[data.url] = ( new MirrorModel(( _base_common_uri_js__WEBPACK_IMPORTED_MODULE_1__.URI.parse(data.url)), data.lines, data.EOL, data.versionId));
    }
    acceptModelChanged(strURL, e) {
        if (!this._models[strURL]) {
            return;
        }
        const model = this._models[strURL];
        model.onEvents(e);
    }
    acceptRemovedModel(strURL) {
        if (!this._models[strURL]) {
            return;
        }
        delete this._models[strURL];
    }
    async computeUnicodeHighlights(url, options, range) {
        const model = this._getModel(url);
        if (!model) {
            return { ranges: [], hasMore: false, ambiguousCharacterCount: 0, invisibleCharacterCount: 0, nonBasicAsciiCharacterCount: 0 };
        }
        return _unicodeTextModelHighlighter_js__WEBPACK_IMPORTED_MODULE_10__.UnicodeTextModelHighlighter.computeUnicodeHighlights(model, options, range);
    }
    async findSectionHeaders(url, options) {
        const model = this._getModel(url);
        if (!model) {
            return [];
        }
        return (0,_findSectionHeaders_js__WEBPACK_IMPORTED_MODULE_16__.findSectionHeaders)(model, options);
    }
    async computeDiff(originalUrl, modifiedUrl, options, algorithm) {
        const original = this._getModel(originalUrl);
        const modified = this._getModel(modifiedUrl);
        if (!original || !modified) {
            return null;
        }
        const result = EditorSimpleWorker.computeDiff(original, modified, options, algorithm);
        return result;
    }
    static computeDiff(originalTextModel, modifiedTextModel, options, algorithm) {
        const diffAlgorithm = algorithm === 'advanced' ? _diff_linesDiffComputers_js__WEBPACK_IMPORTED_MODULE_12__.linesDiffComputers.getDefault() : _diff_linesDiffComputers_js__WEBPACK_IMPORTED_MODULE_12__.linesDiffComputers.getLegacy();
        const originalLines = originalTextModel.getLinesContent();
        const modifiedLines = modifiedTextModel.getLinesContent();
        const result = diffAlgorithm.computeDiff(originalLines, modifiedLines, options);
        const identical = (result.changes.length > 0 ? false : this._modelsAreIdentical(originalTextModel, modifiedTextModel));
        function getLineChanges(changes) {
            return ( changes.map(
                m => ([m.original.startLineNumber, m.original.endLineNumberExclusive, m.modified.startLineNumber, m.modified.endLineNumberExclusive, m.innerChanges?.map(m => [
                        m.originalRange.startLineNumber,
                        m.originalRange.startColumn,
                        m.originalRange.endLineNumber,
                        m.originalRange.endColumn,
                        m.modifiedRange.startLineNumber,
                        m.modifiedRange.startColumn,
                        m.modifiedRange.endLineNumber,
                        m.modifiedRange.endColumn,
                    ])])
            ));
        }
        return {
            identical,
            quitEarly: result.hitTimeout,
            changes: getLineChanges(result.changes),
            moves: ( result.moves.map(m => ([
                m.lineRangeMapping.original.startLineNumber,
                m.lineRangeMapping.original.endLineNumberExclusive,
                m.lineRangeMapping.modified.startLineNumber,
                m.lineRangeMapping.modified.endLineNumberExclusive,
                getLineChanges(m.changes)
            ]))),
        };
    }
    static _modelsAreIdentical(original, modified) {
        const originalLineCount = original.getLineCount();
        const modifiedLineCount = modified.getLineCount();
        if (originalLineCount !== modifiedLineCount) {
            return false;
        }
        for (let line = 1; line <= originalLineCount; line++) {
            const originalLine = original.getLineContent(line);
            const modifiedLine = modified.getLineContent(line);
            if (originalLine !== modifiedLine) {
                return false;
            }
        }
        return true;
    }
    async computeDirtyDiff(originalUrl, modifiedUrl, ignoreTrimWhitespace) {
        const original = this._getModel(originalUrl);
        const modified = this._getModel(modifiedUrl);
        if (!original || !modified) {
            return null;
        }
        const originalLines = original.getLinesContent();
        const modifiedLines = modified.getLinesContent();
        const diffComputer = ( new _diff_legacyLinesDiffComputer_js__WEBPACK_IMPORTED_MODULE_11__.DiffComputer(originalLines, modifiedLines, {
            shouldComputeCharChanges: false,
            shouldPostProcessCharChanges: false,
            shouldIgnoreTrimWhitespace: ignoreTrimWhitespace,
            shouldMakePrettyDiff: true,
            maxComputationTime: 1000
        }));
        return diffComputer.computeDiff().changes;
    }
    static { this._diffLimit = 100000; }
    async computeMoreMinimalEdits(modelUrl, edits, pretty) {
        const model = this._getModel(modelUrl);
        if (!model) {
            return edits;
        }
        const result = [];
        let lastEol = undefined;
        edits = edits.slice(0).sort((a, b) => {
            if (a.range && b.range) {
                return _core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.compareRangesUsingStarts(a.range, b.range);
            }
            const aRng = a.range ? 0 : 1;
            const bRng = b.range ? 0 : 1;
            return aRng - bRng;
        });
        let writeIndex = 0;
        for (let readIndex = 1; readIndex < edits.length; readIndex++) {
            if (_core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.getEndPosition(edits[writeIndex].range).equals(_core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.getStartPosition(edits[readIndex].range))) {
                edits[writeIndex].range = _core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.fromPositions(_core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.getStartPosition(edits[writeIndex].range), _core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.getEndPosition(edits[readIndex].range));
                edits[writeIndex].text += edits[readIndex].text;
            }
            else {
                writeIndex++;
                edits[writeIndex] = edits[readIndex];
            }
        }
        edits.length = writeIndex + 1;
        for (let { range, text, eol } of edits) {
            if (typeof eol === 'number') {
                lastEol = eol;
            }
            if (_core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.isEmpty(range) && !text) {
                continue;
            }
            const original = model.getValueInRange(range);
            text = text.replace(/\r\n|\n|\r/g, model.eol);
            if (original === text) {
                continue;
            }
            if (Math.max(text.length, original.length) > EditorSimpleWorker._diffLimit) {
                result.push({ range, text });
                continue;
            }
            const changes = (0,_base_common_diff_diff_js__WEBPACK_IMPORTED_MODULE_0__.stringDiff)(original, text, pretty);
            const editOffset = model.offsetAt(_core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.lift(range).getStartPosition());
            for (const change of changes) {
                const start = model.positionAt(editOffset + change.originalStart);
                const end = model.positionAt(editOffset + change.originalStart + change.originalLength);
                const newEdit = {
                    text: text.substr(change.modifiedStart, change.modifiedLength),
                    range: { startLineNumber: start.lineNumber, startColumn: start.column, endLineNumber: end.lineNumber, endColumn: end.column }
                };
                if (model.getValueInRange(newEdit.range) !== newEdit.text) {
                    result.push(newEdit);
                }
            }
        }
        if (typeof lastEol === 'number') {
            result.push({ eol: lastEol, text: '', range: { startLineNumber: 0, startColumn: 0, endLineNumber: 0, endColumn: 0 } });
        }
        return result;
    }
    computeHumanReadableDiff(modelUrl, edits, options) {
        const model = this._getModel(modelUrl);
        if (!model) {
            return edits;
        }
        const result = [];
        let lastEol = undefined;
        edits = edits.slice(0).sort((a, b) => {
            if (a.range && b.range) {
                return _core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.compareRangesUsingStarts(a.range, b.range);
            }
            const aRng = a.range ? 0 : 1;
            const bRng = b.range ? 0 : 1;
            return aRng - bRng;
        });
        for (let { range, text, eol } of edits) {
            if (typeof eol === 'number') {
                lastEol = eol;
            }
            if (_core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.isEmpty(range) && !text) {
                continue;
            }
            const original = model.getValueInRange(range);
            text = text.replace(/\r\n|\n|\r/g, model.eol);
            if (original === text) {
                continue;
            }
            if (Math.max(text.length, original.length) > EditorSimpleWorker._diffLimit) {
                result.push({ range, text });
                continue;
            }
            const originalLines = original.split(/\r\n|\n|\r/);
            const modifiedLines = text.split(/\r\n|\n|\r/);
            const diff = _diff_linesDiffComputers_js__WEBPACK_IMPORTED_MODULE_12__.linesDiffComputers.getDefault().computeDiff(originalLines, modifiedLines, options);
            const start = _core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.lift(range).getStartPosition();
            function addPositions(pos1, pos2) {
                return ( new _core_position_js__WEBPACK_IMPORTED_MODULE_2__.Position(
                    pos1.lineNumber + pos2.lineNumber - 1,
                    pos2.lineNumber === 1 ? pos1.column + pos2.column - 1 : pos2.column
                ));
            }
            function getText(lines, range) {
                const result = [];
                for (let i = range.startLineNumber; i <= range.endLineNumber; i++) {
                    const line = lines[i - 1];
                    if (i === range.startLineNumber && i === range.endLineNumber) {
                        result.push(line.substring(range.startColumn - 1, range.endColumn - 1));
                    }
                    else if (i === range.startLineNumber) {
                        result.push(line.substring(range.startColumn - 1));
                    }
                    else if (i === range.endLineNumber) {
                        result.push(line.substring(0, range.endColumn - 1));
                    }
                    else {
                        result.push(line);
                    }
                }
                return result;
            }
            for (const c of diff.changes) {
                if (c.innerChanges) {
                    for (const x of c.innerChanges) {
                        result.push({
                            range: _core_range_js__WEBPACK_IMPORTED_MODULE_3__.Range.fromPositions(addPositions(start, x.originalRange.getStartPosition()), addPositions(start, x.originalRange.getEndPosition())),
                            text: getText(modifiedLines, x.modifiedRange).join(model.eol)
                        });
                    }
                }
                else {
                    throw ( new _base_common_errors_js__WEBPACK_IMPORTED_MODULE_14__.BugIndicatingError('The experimental diff algorithm always produces inner changes'));
                }
            }
        }
        if (typeof lastEol === 'number') {
            result.push({ eol: lastEol, text: '', range: { startLineNumber: 0, startColumn: 0, endLineNumber: 0, endColumn: 0 } });
        }
        return result;
    }
    async computeLinks(modelUrl) {
        const model = this._getModel(modelUrl);
        if (!model) {
            return null;
        }
        return (0,_languages_linkComputer_js__WEBPACK_IMPORTED_MODULE_6__.computeLinks)(model);
    }
    async computeDefaultDocumentColors(modelUrl) {
        const model = this._getModel(modelUrl);
        if (!model) {
            return null;
        }
        return (0,_languages_defaultDocumentColorsComputer_js__WEBPACK_IMPORTED_MODULE_15__.computeDefaultDocumentColors)(model);
    }
    static { this._suggestionsLimit = 10000; }
    async textualSuggest(modelUrls, leadingWord, wordDef, wordDefFlags) {
        const sw = ( new _base_common_stopwatch_js__WEBPACK_IMPORTED_MODULE_9__.StopWatch());
        const wordDefRegExp = ( new RegExp(wordDef, wordDefFlags));
        const seen = ( new Set());
        outer: for (const url of modelUrls) {
            const model = this._getModel(url);
            if (!model) {
                continue;
            }
            for (const word of model.words(wordDefRegExp)) {
                if (word === leadingWord || !isNaN(Number(word))) {
                    continue;
                }
                seen.add(word);
                if (seen.size > EditorSimpleWorker._suggestionsLimit) {
                    break outer;
                }
            }
        }
        return { words: Array.from(seen), duration: sw.elapsed() };
    }
    async computeWordRanges(modelUrl, range, wordDef, wordDefFlags) {
        const model = this._getModel(modelUrl);
        if (!model) {
            return Object.create(null);
        }
        const wordDefRegExp = ( new RegExp(wordDef, wordDefFlags));
        const result = Object.create(null);
        for (let line = range.startLineNumber; line < range.endLineNumber; line++) {
            const words = model.getLineWords(line, wordDefRegExp);
            for (const word of words) {
                if (!isNaN(Number(word.word))) {
                    continue;
                }
                let array = result[word.word];
                if (!array) {
                    array = [];
                    result[word.word] = array;
                }
                array.push({
                    startLineNumber: line,
                    startColumn: word.startColumn,
                    endLineNumber: line,
                    endColumn: word.endColumn
                });
            }
        }
        return result;
    }
    async navigateValueSet(modelUrl, range, up, wordDef, wordDefFlags) {
        const model = this._getModel(modelUrl);
        if (!model) {
            return null;
        }
        const wordDefRegExp = ( new RegExp(wordDef, wordDefFlags));
        if (range.startColumn === range.endColumn) {
            range = {
                startLineNumber: range.startLineNumber,
                startColumn: range.startColumn,
                endLineNumber: range.endLineNumber,
                endColumn: range.endColumn + 1
            };
        }
        const selectionText = model.getValueInRange(range);
        const wordRange = model.getWordAtPosition({ lineNumber: range.startLineNumber, column: range.startColumn }, wordDefRegExp);
        if (!wordRange) {
            return null;
        }
        const word = model.getValueInRange(wordRange);
        const result = _languages_supports_inplaceReplaceSupport_js__WEBPACK_IMPORTED_MODULE_7__.BasicInplaceReplace.INSTANCE.navigateValueSet(range, selectionText, wordRange, word, up);
        return result;
    }
    loadForeignModule(moduleId, createData, foreignHostMethods) {
        const proxyMethodRequest = (method, args) => {
            return this._host.fhr(method, args);
        };
        const foreignHost = (0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_13__.createProxyObject)(foreignHostMethods, proxyMethodRequest);
        const ctx = {
            host: foreignHost,
            getMirrorModels: () => {
                return this._getModels();
            }
        };
        if (this._foreignModuleFactory) {
            this._foreignModule = this._foreignModuleFactory(ctx, createData);
            return Promise.resolve((0,_base_common_objects_js__WEBPACK_IMPORTED_MODULE_13__.getAllMethodNames)(this._foreignModule));
        }
        return Promise.reject(( new Error(`Unexpected usage`)));
    }
    fmr(method, args) {
        if (!this._foreignModule || typeof this._foreignModule[method] !== 'function') {
            return Promise.reject(( new Error('Missing requestHandler or method: ' + method)));
        }
        try {
            return Promise.resolve(this._foreignModule[method].apply(this._foreignModule, args));
        }
        catch (e) {
            return Promise.reject(e);
        }
    }
}
if (typeof importScripts === 'function') {
    globalThis.monaco = (0,_editorBaseApi_js__WEBPACK_IMPORTED_MODULE_8__.createMonacoBaseAPI)();
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/services/findSectionHeaders.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/services/findSectionHeaders.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   findSectionHeaders: () => (/* binding */ findSectionHeaders)
/* harmony export */ });
const markRegex = ( new RegExp('\\bMARK:\\s*(.*)$', 'd'));
const trimDashesRegex = /^-+|-+$/g;
function findSectionHeaders(model, options) {
    let headers = [];
    if (options.findRegionSectionHeaders && options.foldingRules?.markers) {
        const regionHeaders = collectRegionHeaders(model, options);
        headers = headers.concat(regionHeaders);
    }
    if (options.findMarkSectionHeaders) {
        const markHeaders = collectMarkHeaders(model);
        headers = headers.concat(markHeaders);
    }
    return headers;
}
function collectRegionHeaders(model, options) {
    const regionHeaders = [];
    const endLineNumber = model.getLineCount();
    for (let lineNumber = 1; lineNumber <= endLineNumber; lineNumber++) {
        const lineContent = model.getLineContent(lineNumber);
        const match = lineContent.match(options.foldingRules.markers.start);
        if (match) {
            const range = { startLineNumber: lineNumber, startColumn: match[0].length + 1, endLineNumber: lineNumber, endColumn: lineContent.length + 1 };
            if (range.endColumn > range.startColumn) {
                const sectionHeader = {
                    range,
                    ...getHeaderText(lineContent.substring(match[0].length)),
                    shouldBeInComments: false
                };
                if (sectionHeader.text || sectionHeader.hasSeparatorLine) {
                    regionHeaders.push(sectionHeader);
                }
            }
        }
    }
    return regionHeaders;
}
function collectMarkHeaders(model) {
    const markHeaders = [];
    const endLineNumber = model.getLineCount();
    for (let lineNumber = 1; lineNumber <= endLineNumber; lineNumber++) {
        const lineContent = model.getLineContent(lineNumber);
        addMarkHeaderIfFound(lineContent, lineNumber, markHeaders);
    }
    return markHeaders;
}
function addMarkHeaderIfFound(lineContent, lineNumber, sectionHeaders) {
    markRegex.lastIndex = 0;
    const match = markRegex.exec(lineContent);
    if (match) {
        const column = match.indices[1][0] + 1;
        const endColumn = match.indices[1][1] + 1;
        const range = { startLineNumber: lineNumber, startColumn: column, endLineNumber: lineNumber, endColumn: endColumn };
        if (range.endColumn > range.startColumn) {
            const sectionHeader = {
                range,
                ...getHeaderText(match[1]),
                shouldBeInComments: true
            };
            if (sectionHeader.text || sectionHeader.hasSeparatorLine) {
                sectionHeaders.push(sectionHeader);
            }
        }
    }
}
function getHeaderText(text) {
    text = text.trim();
    const hasSeparatorLine = text.startsWith('-');
    text = text.replace(trimDashesRegex, '');
    return { text, hasSeparatorLine };
}



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/services/unicodeTextModelHighlighter.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/services/unicodeTextModelHighlighter.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UnicodeHighlighterReasonKind: () => (/* binding */ UnicodeHighlighterReasonKind),
/* harmony export */   UnicodeTextModelHighlighter: () => (/* binding */ UnicodeTextModelHighlighter)
/* harmony export */ });
/* harmony import */ var _core_range_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/range.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/range.js");
/* harmony import */ var _model_textModelSearch_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/textModelSearch.js */ "./node_modules/vscode/vscode/src/vs/editor/common/model/textModelSearch.js");
/* harmony import */ var _base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../base/common/strings.js */ "./node_modules/vscode/vscode/src/vs/base/common/strings.js");
/* harmony import */ var _base_common_assert_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../base/common/assert.js */ "./node_modules/vscode/vscode/src/vs/base/common/assert.js");
/* harmony import */ var _core_wordHelper_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/wordHelper.js */ "./node_modules/vscode/vscode/src/vs/editor/common/core/wordHelper.js");





class UnicodeTextModelHighlighter {
    static computeUnicodeHighlights(model, options, range) {
        const startLine = range ? range.startLineNumber : 1;
        const endLine = range ? range.endLineNumber : model.getLineCount();
        const codePointHighlighter = ( new CodePointHighlighter(options));
        const candidates = codePointHighlighter.getCandidateCodePoints();
        let regex;
        if (candidates === 'allNonBasicAscii') {
            regex = ( new RegExp('[^\\t\\n\\r\\x20-\\x7E]', 'g'));
        }
        else {
            regex = ( new RegExp(`${buildRegExpCharClassExpr(Array.from(candidates))}`, 'g'));
        }
        const searcher = ( new _model_textModelSearch_js__WEBPACK_IMPORTED_MODULE_1__.Searcher(null, regex));
        const ranges = [];
        let hasMore = false;
        let m;
        let ambiguousCharacterCount = 0;
        let invisibleCharacterCount = 0;
        let nonBasicAsciiCharacterCount = 0;
        forLoop: for (let lineNumber = startLine, lineCount = endLine; lineNumber <= lineCount; lineNumber++) {
            const lineContent = model.getLineContent(lineNumber);
            const lineLength = lineContent.length;
            searcher.reset(0);
            do {
                m = searcher.next(lineContent);
                if (m) {
                    let startIndex = m.index;
                    let endIndex = m.index + m[0].length;
                    if (startIndex > 0) {
                        const charCodeBefore = lineContent.charCodeAt(startIndex - 1);
                        if ((0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.isHighSurrogate)(charCodeBefore)) {
                            startIndex--;
                        }
                    }
                    if (endIndex + 1 < lineLength) {
                        const charCodeBefore = lineContent.charCodeAt(endIndex - 1);
                        if ((0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.isHighSurrogate)(charCodeBefore)) {
                            endIndex++;
                        }
                    }
                    const str = lineContent.substring(startIndex, endIndex);
                    let word = (0,_core_wordHelper_js__WEBPACK_IMPORTED_MODULE_4__.getWordAtText)(startIndex + 1, _core_wordHelper_js__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_WORD_REGEXP, lineContent, 0);
                    if (word && word.endColumn <= startIndex + 1) {
                        word = null;
                    }
                    const highlightReason = codePointHighlighter.shouldHighlightNonBasicASCII(str, word ? word.word : null);
                    if (highlightReason !== SimpleHighlightReason.None) {
                        if (highlightReason === SimpleHighlightReason.Ambiguous) {
                            ambiguousCharacterCount++;
                        }
                        else if (highlightReason === SimpleHighlightReason.Invisible) {
                            invisibleCharacterCount++;
                        }
                        else if (highlightReason === SimpleHighlightReason.NonBasicASCII) {
                            nonBasicAsciiCharacterCount++;
                        }
                        else {
                            (0,_base_common_assert_js__WEBPACK_IMPORTED_MODULE_3__.assertNever)();
                        }
                        const MAX_RESULT_LENGTH = 1000;
                        if (ranges.length >= MAX_RESULT_LENGTH) {
                            hasMore = true;
                            break forLoop;
                        }
                        ranges.push(( new _core_range_js__WEBPACK_IMPORTED_MODULE_0__.Range(lineNumber, startIndex + 1, lineNumber, endIndex + 1)));
                    }
                }
            } while (m);
        }
        return {
            ranges,
            hasMore,
            ambiguousCharacterCount,
            invisibleCharacterCount,
            nonBasicAsciiCharacterCount
        };
    }
    static computeUnicodeHighlightReason(char, options) {
        const codePointHighlighter = ( new CodePointHighlighter(options));
        const reason = codePointHighlighter.shouldHighlightNonBasicASCII(char, null);
        switch (reason) {
            case SimpleHighlightReason.None:
                return null;
            case SimpleHighlightReason.Invisible:
                return { kind: UnicodeHighlighterReasonKind.Invisible };
            case SimpleHighlightReason.Ambiguous: {
                const codePoint = char.codePointAt(0);
                const primaryConfusable = codePointHighlighter.ambiguousCharacters.getPrimaryConfusable(codePoint);
                const notAmbiguousInLocales = _base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.AmbiguousCharacters.getLocales().filter((l) => !_base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.AmbiguousCharacters.getInstance(( new Set([...options.allowedLocales, l]))).isAmbiguous(codePoint));
                return { kind: UnicodeHighlighterReasonKind.Ambiguous, confusableWith: String.fromCodePoint(primaryConfusable), notAmbiguousInLocales };
            }
            case SimpleHighlightReason.NonBasicASCII:
                return { kind: UnicodeHighlighterReasonKind.NonBasicAscii };
        }
    }
}
function buildRegExpCharClassExpr(codePoints, flags) {
    const src = `[${(0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.escapeRegExpCharacters)(( codePoints.map((i) => String.fromCodePoint(i))).join(''))}]`;
    return src;
}
var UnicodeHighlighterReasonKind;
( (function(UnicodeHighlighterReasonKind) {
    UnicodeHighlighterReasonKind[UnicodeHighlighterReasonKind["Ambiguous"] = 0] = "Ambiguous";
    UnicodeHighlighterReasonKind[UnicodeHighlighterReasonKind["Invisible"] = 1] = "Invisible";
    UnicodeHighlighterReasonKind[UnicodeHighlighterReasonKind["NonBasicAscii"] = 2] = "NonBasicAscii";
})(UnicodeHighlighterReasonKind || (UnicodeHighlighterReasonKind = {})));
class CodePointHighlighter {
    constructor(options) {
        this.options = options;
        this.allowedCodePoints = ( new Set(options.allowedCodePoints));
        this.ambiguousCharacters = _base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.AmbiguousCharacters.getInstance(( new Set(options.allowedLocales)));
    }
    getCandidateCodePoints() {
        if (this.options.nonBasicASCII) {
            return 'allNonBasicAscii';
        }
        const set = ( new Set());
        if (this.options.invisibleCharacters) {
            for (const cp of _base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.InvisibleCharacters.codePoints) {
                if (!isAllowedInvisibleCharacter(String.fromCodePoint(cp))) {
                    set.add(cp);
                }
            }
        }
        if (this.options.ambiguousCharacters) {
            for (const cp of this.ambiguousCharacters.getConfusableCodePoints()) {
                set.add(cp);
            }
        }
        for (const cp of this.allowedCodePoints) {
            set.delete(cp);
        }
        return set;
    }
    shouldHighlightNonBasicASCII(character, wordContext) {
        const codePoint = character.codePointAt(0);
        if (( this.allowedCodePoints.has(codePoint))) {
            return SimpleHighlightReason.None;
        }
        if (this.options.nonBasicASCII) {
            return SimpleHighlightReason.NonBasicASCII;
        }
        let hasBasicASCIICharacters = false;
        let hasNonConfusableNonBasicAsciiCharacter = false;
        if (wordContext) {
            for (const char of wordContext) {
                const codePoint = char.codePointAt(0);
                const isBasicASCII$1 = (0,_base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.isBasicASCII)(char);
                hasBasicASCIICharacters = hasBasicASCIICharacters || isBasicASCII$1;
                if (!isBasicASCII$1 &&
                    !this.ambiguousCharacters.isAmbiguous(codePoint) &&
                    !_base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.InvisibleCharacters.isInvisibleCharacter(codePoint)) {
                    hasNonConfusableNonBasicAsciiCharacter = true;
                }
            }
        }
        if (
         !hasBasicASCIICharacters &&
             hasNonConfusableNonBasicAsciiCharacter) {
            return SimpleHighlightReason.None;
        }
        if (this.options.invisibleCharacters) {
            if (!isAllowedInvisibleCharacter(character) && _base_common_strings_js__WEBPACK_IMPORTED_MODULE_2__.InvisibleCharacters.isInvisibleCharacter(codePoint)) {
                return SimpleHighlightReason.Invisible;
            }
        }
        if (this.options.ambiguousCharacters) {
            if (this.ambiguousCharacters.isAmbiguous(codePoint)) {
                return SimpleHighlightReason.Ambiguous;
            }
        }
        return SimpleHighlightReason.None;
    }
}
function isAllowedInvisibleCharacter(character) {
    return character === ' ' || character === '\n' || character === '\t';
}
var SimpleHighlightReason;
( (function(SimpleHighlightReason) {
    SimpleHighlightReason[SimpleHighlightReason["None"] = 0] = "None";
    SimpleHighlightReason[SimpleHighlightReason["NonBasicASCII"] = 1] = "NonBasicASCII";
    SimpleHighlightReason[SimpleHighlightReason["Invisible"] = 2] = "Invisible";
    SimpleHighlightReason[SimpleHighlightReason["Ambiguous"] = 3] = "Ambiguous";
})(SimpleHighlightReason || (SimpleHighlightReason = {})));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/common/standalone/standaloneEnums.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/common/standalone/standaloneEnums.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccessibilitySupport: () => (/* binding */ AccessibilitySupport),
/* harmony export */   CodeActionTriggerType: () => (/* binding */ CodeActionTriggerType),
/* harmony export */   CompletionItemInsertTextRule: () => (/* binding */ CompletionItemInsertTextRule),
/* harmony export */   CompletionItemKind: () => (/* binding */ CompletionItemKind),
/* harmony export */   CompletionItemTag: () => (/* binding */ CompletionItemTag),
/* harmony export */   CompletionTriggerKind: () => (/* binding */ CompletionTriggerKind),
/* harmony export */   ContentWidgetPositionPreference: () => (/* binding */ ContentWidgetPositionPreference),
/* harmony export */   CursorChangeReason: () => (/* binding */ CursorChangeReason),
/* harmony export */   DefaultEndOfLine: () => (/* binding */ DefaultEndOfLine),
/* harmony export */   DocumentHighlightKind: () => (/* binding */ DocumentHighlightKind),
/* harmony export */   EditorAutoIndentStrategy: () => (/* binding */ EditorAutoIndentStrategy),
/* harmony export */   EditorOption: () => (/* binding */ EditorOption),
/* harmony export */   EndOfLinePreference: () => (/* binding */ EndOfLinePreference),
/* harmony export */   EndOfLineSequence: () => (/* binding */ EndOfLineSequence),
/* harmony export */   GlyphMarginLane: () => (/* binding */ GlyphMarginLane),
/* harmony export */   HoverVerbosityAction: () => (/* binding */ HoverVerbosityAction),
/* harmony export */   IndentAction: () => (/* binding */ IndentAction),
/* harmony export */   InjectedTextCursorStops: () => (/* binding */ InjectedTextCursorStops),
/* harmony export */   InlayHintKind: () => (/* binding */ InlayHintKind),
/* harmony export */   InlineCompletionTriggerKind: () => (/* binding */ InlineCompletionTriggerKind),
/* harmony export */   InlineEditTriggerKind: () => (/* binding */ InlineEditTriggerKind),
/* harmony export */   KeyCode: () => (/* binding */ KeyCode),
/* harmony export */   MarkerSeverity: () => (/* binding */ MarkerSeverity),
/* harmony export */   MarkerTag: () => (/* binding */ MarkerTag),
/* harmony export */   MinimapPosition: () => (/* binding */ MinimapPosition),
/* harmony export */   MinimapSectionHeaderStyle: () => (/* binding */ MinimapSectionHeaderStyle),
/* harmony export */   MouseTargetType: () => (/* binding */ MouseTargetType),
/* harmony export */   NewSymbolNameTag: () => (/* binding */ NewSymbolNameTag),
/* harmony export */   NewSymbolNameTriggerKind: () => (/* binding */ NewSymbolNameTriggerKind),
/* harmony export */   OverlayWidgetPositionPreference: () => (/* binding */ OverlayWidgetPositionPreference),
/* harmony export */   OverviewRulerLane: () => (/* binding */ OverviewRulerLane),
/* harmony export */   PartialAcceptTriggerKind: () => (/* binding */ PartialAcceptTriggerKind),
/* harmony export */   PositionAffinity: () => (/* binding */ PositionAffinity),
/* harmony export */   RenderLineNumbersType: () => (/* binding */ RenderLineNumbersType),
/* harmony export */   RenderMinimap: () => (/* binding */ RenderMinimap),
/* harmony export */   ScrollType: () => (/* binding */ ScrollType),
/* harmony export */   ScrollbarVisibility: () => (/* binding */ ScrollbarVisibility),
/* harmony export */   SelectionDirection: () => (/* binding */ SelectionDirection),
/* harmony export */   ShowLightbulbIconMode: () => (/* binding */ ShowLightbulbIconMode),
/* harmony export */   SignatureHelpTriggerKind: () => (/* binding */ SignatureHelpTriggerKind),
/* harmony export */   SymbolKind: () => (/* binding */ SymbolKind),
/* harmony export */   SymbolTag: () => (/* binding */ SymbolTag),
/* harmony export */   TextEditorCursorBlinkingStyle: () => (/* binding */ TextEditorCursorBlinkingStyle),
/* harmony export */   TextEditorCursorStyle: () => (/* binding */ TextEditorCursorStyle),
/* harmony export */   TrackedRangeStickiness: () => (/* binding */ TrackedRangeStickiness),
/* harmony export */   WrappingIndent: () => (/* binding */ WrappingIndent)
/* harmony export */ });
var AccessibilitySupport;
( (function(AccessibilitySupport) {
    AccessibilitySupport[AccessibilitySupport["Unknown"] = 0] = "Unknown";
    AccessibilitySupport[AccessibilitySupport["Disabled"] = 1] = "Disabled";
    AccessibilitySupport[AccessibilitySupport["Enabled"] = 2] = "Enabled";
})(AccessibilitySupport || (AccessibilitySupport = {})));
var CodeActionTriggerType;
( (function(CodeActionTriggerType) {
    CodeActionTriggerType[CodeActionTriggerType["Invoke"] = 1] = "Invoke";
    CodeActionTriggerType[CodeActionTriggerType["Auto"] = 2] = "Auto";
})(CodeActionTriggerType || (CodeActionTriggerType = {})));
var CompletionItemInsertTextRule;
( (function(CompletionItemInsertTextRule) {
    CompletionItemInsertTextRule[CompletionItemInsertTextRule["None"] = 0] = "None";
    CompletionItemInsertTextRule[CompletionItemInsertTextRule["KeepWhitespace"] = 1] = "KeepWhitespace";
    CompletionItemInsertTextRule[CompletionItemInsertTextRule["InsertAsSnippet"] = 4] = "InsertAsSnippet";
})(CompletionItemInsertTextRule || (CompletionItemInsertTextRule = {})));
var CompletionItemKind;
( (function(CompletionItemKind) {
    CompletionItemKind[CompletionItemKind["Method"] = 0] = "Method";
    CompletionItemKind[CompletionItemKind["Function"] = 1] = "Function";
    CompletionItemKind[CompletionItemKind["Constructor"] = 2] = "Constructor";
    CompletionItemKind[CompletionItemKind["Field"] = 3] = "Field";
    CompletionItemKind[CompletionItemKind["Variable"] = 4] = "Variable";
    CompletionItemKind[CompletionItemKind["Class"] = 5] = "Class";
    CompletionItemKind[CompletionItemKind["Struct"] = 6] = "Struct";
    CompletionItemKind[CompletionItemKind["Interface"] = 7] = "Interface";
    CompletionItemKind[CompletionItemKind["Module"] = 8] = "Module";
    CompletionItemKind[CompletionItemKind["Property"] = 9] = "Property";
    CompletionItemKind[CompletionItemKind["Event"] = 10] = "Event";
    CompletionItemKind[CompletionItemKind["Operator"] = 11] = "Operator";
    CompletionItemKind[CompletionItemKind["Unit"] = 12] = "Unit";
    CompletionItemKind[CompletionItemKind["Value"] = 13] = "Value";
    CompletionItemKind[CompletionItemKind["Constant"] = 14] = "Constant";
    CompletionItemKind[CompletionItemKind["Enum"] = 15] = "Enum";
    CompletionItemKind[CompletionItemKind["EnumMember"] = 16] = "EnumMember";
    CompletionItemKind[CompletionItemKind["Keyword"] = 17] = "Keyword";
    CompletionItemKind[CompletionItemKind["Text"] = 18] = "Text";
    CompletionItemKind[CompletionItemKind["Color"] = 19] = "Color";
    CompletionItemKind[CompletionItemKind["File"] = 20] = "File";
    CompletionItemKind[CompletionItemKind["Reference"] = 21] = "Reference";
    CompletionItemKind[CompletionItemKind["Customcolor"] = 22] = "Customcolor";
    CompletionItemKind[CompletionItemKind["Folder"] = 23] = "Folder";
    CompletionItemKind[CompletionItemKind["TypeParameter"] = 24] = "TypeParameter";
    CompletionItemKind[CompletionItemKind["User"] = 25] = "User";
    CompletionItemKind[CompletionItemKind["Issue"] = 26] = "Issue";
    CompletionItemKind[CompletionItemKind["Snippet"] = 27] = "Snippet";
})(CompletionItemKind || (CompletionItemKind = {})));
var CompletionItemTag;
( (function(CompletionItemTag) {
    CompletionItemTag[CompletionItemTag["Deprecated"] = 1] = "Deprecated";
})(CompletionItemTag || (CompletionItemTag = {})));
var CompletionTriggerKind;
( (function(CompletionTriggerKind) {
    CompletionTriggerKind[CompletionTriggerKind["Invoke"] = 0] = "Invoke";
    CompletionTriggerKind[CompletionTriggerKind["TriggerCharacter"] = 1] = "TriggerCharacter";
    CompletionTriggerKind[CompletionTriggerKind["TriggerForIncompleteCompletions"] = 2] = "TriggerForIncompleteCompletions";
})(CompletionTriggerKind || (CompletionTriggerKind = {})));
var ContentWidgetPositionPreference;
( (function(ContentWidgetPositionPreference) {
    ContentWidgetPositionPreference[ContentWidgetPositionPreference["EXACT"] = 0] = "EXACT";
    ContentWidgetPositionPreference[ContentWidgetPositionPreference["ABOVE"] = 1] = "ABOVE";
    ContentWidgetPositionPreference[ContentWidgetPositionPreference["BELOW"] = 2] = "BELOW";
})(ContentWidgetPositionPreference || (ContentWidgetPositionPreference = {})));
var CursorChangeReason;
( (function(CursorChangeReason) {
    CursorChangeReason[CursorChangeReason["NotSet"] = 0] = "NotSet";
    CursorChangeReason[CursorChangeReason["ContentFlush"] = 1] = "ContentFlush";
    CursorChangeReason[CursorChangeReason["RecoverFromMarkers"] = 2] = "RecoverFromMarkers";
    CursorChangeReason[CursorChangeReason["Explicit"] = 3] = "Explicit";
    CursorChangeReason[CursorChangeReason["Paste"] = 4] = "Paste";
    CursorChangeReason[CursorChangeReason["Undo"] = 5] = "Undo";
    CursorChangeReason[CursorChangeReason["Redo"] = 6] = "Redo";
})(CursorChangeReason || (CursorChangeReason = {})));
var DefaultEndOfLine;
( (function(DefaultEndOfLine) {
    DefaultEndOfLine[DefaultEndOfLine["LF"] = 1] = "LF";
    DefaultEndOfLine[DefaultEndOfLine["CRLF"] = 2] = "CRLF";
})(DefaultEndOfLine || (DefaultEndOfLine = {})));
var DocumentHighlightKind;
( (function(DocumentHighlightKind) {
    DocumentHighlightKind[DocumentHighlightKind["Text"] = 0] = "Text";
    DocumentHighlightKind[DocumentHighlightKind["Read"] = 1] = "Read";
    DocumentHighlightKind[DocumentHighlightKind["Write"] = 2] = "Write";
})(DocumentHighlightKind || (DocumentHighlightKind = {})));
var EditorAutoIndentStrategy;
( (function(EditorAutoIndentStrategy) {
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["None"] = 0] = "None";
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["Keep"] = 1] = "Keep";
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["Brackets"] = 2] = "Brackets";
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["Advanced"] = 3] = "Advanced";
    EditorAutoIndentStrategy[EditorAutoIndentStrategy["Full"] = 4] = "Full";
})(EditorAutoIndentStrategy || (EditorAutoIndentStrategy = {})));
var EditorOption;
( (function(EditorOption) {
    EditorOption[EditorOption["acceptSuggestionOnCommitCharacter"] = 0] = "acceptSuggestionOnCommitCharacter";
    EditorOption[EditorOption["acceptSuggestionOnEnter"] = 1] = "acceptSuggestionOnEnter";
    EditorOption[EditorOption["accessibilitySupport"] = 2] = "accessibilitySupport";
    EditorOption[EditorOption["accessibilityPageSize"] = 3] = "accessibilityPageSize";
    EditorOption[EditorOption["ariaLabel"] = 4] = "ariaLabel";
    EditorOption[EditorOption["ariaRequired"] = 5] = "ariaRequired";
    EditorOption[EditorOption["autoClosingBrackets"] = 6] = "autoClosingBrackets";
    EditorOption[EditorOption["autoClosingComments"] = 7] = "autoClosingComments";
    EditorOption[EditorOption["screenReaderAnnounceInlineSuggestion"] = 8] = "screenReaderAnnounceInlineSuggestion";
    EditorOption[EditorOption["autoClosingDelete"] = 9] = "autoClosingDelete";
    EditorOption[EditorOption["autoClosingOvertype"] = 10] = "autoClosingOvertype";
    EditorOption[EditorOption["autoClosingQuotes"] = 11] = "autoClosingQuotes";
    EditorOption[EditorOption["autoIndent"] = 12] = "autoIndent";
    EditorOption[EditorOption["automaticLayout"] = 13] = "automaticLayout";
    EditorOption[EditorOption["autoSurround"] = 14] = "autoSurround";
    EditorOption[EditorOption["bracketPairColorization"] = 15] = "bracketPairColorization";
    EditorOption[EditorOption["guides"] = 16] = "guides";
    EditorOption[EditorOption["codeLens"] = 17] = "codeLens";
    EditorOption[EditorOption["codeLensFontFamily"] = 18] = "codeLensFontFamily";
    EditorOption[EditorOption["codeLensFontSize"] = 19] = "codeLensFontSize";
    EditorOption[EditorOption["colorDecorators"] = 20] = "colorDecorators";
    EditorOption[EditorOption["colorDecoratorsLimit"] = 21] = "colorDecoratorsLimit";
    EditorOption[EditorOption["columnSelection"] = 22] = "columnSelection";
    EditorOption[EditorOption["comments"] = 23] = "comments";
    EditorOption[EditorOption["contextmenu"] = 24] = "contextmenu";
    EditorOption[EditorOption["copyWithSyntaxHighlighting"] = 25] = "copyWithSyntaxHighlighting";
    EditorOption[EditorOption["cursorBlinking"] = 26] = "cursorBlinking";
    EditorOption[EditorOption["cursorSmoothCaretAnimation"] = 27] = "cursorSmoothCaretAnimation";
    EditorOption[EditorOption["cursorStyle"] = 28] = "cursorStyle";
    EditorOption[EditorOption["cursorSurroundingLines"] = 29] = "cursorSurroundingLines";
    EditorOption[EditorOption["cursorSurroundingLinesStyle"] = 30] = "cursorSurroundingLinesStyle";
    EditorOption[EditorOption["cursorWidth"] = 31] = "cursorWidth";
    EditorOption[EditorOption["disableLayerHinting"] = 32] = "disableLayerHinting";
    EditorOption[EditorOption["disableMonospaceOptimizations"] = 33] = "disableMonospaceOptimizations";
    EditorOption[EditorOption["domReadOnly"] = 34] = "domReadOnly";
    EditorOption[EditorOption["dragAndDrop"] = 35] = "dragAndDrop";
    EditorOption[EditorOption["dropIntoEditor"] = 36] = "dropIntoEditor";
    EditorOption[EditorOption["emptySelectionClipboard"] = 37] = "emptySelectionClipboard";
    EditorOption[EditorOption["experimentalWhitespaceRendering"] = 38] = "experimentalWhitespaceRendering";
    EditorOption[EditorOption["extraEditorClassName"] = 39] = "extraEditorClassName";
    EditorOption[EditorOption["fastScrollSensitivity"] = 40] = "fastScrollSensitivity";
    EditorOption[EditorOption["find"] = 41] = "find";
    EditorOption[EditorOption["fixedOverflowWidgets"] = 42] = "fixedOverflowWidgets";
    EditorOption[EditorOption["folding"] = 43] = "folding";
    EditorOption[EditorOption["foldingStrategy"] = 44] = "foldingStrategy";
    EditorOption[EditorOption["foldingHighlight"] = 45] = "foldingHighlight";
    EditorOption[EditorOption["foldingImportsByDefault"] = 46] = "foldingImportsByDefault";
    EditorOption[EditorOption["foldingMaximumRegions"] = 47] = "foldingMaximumRegions";
    EditorOption[EditorOption["unfoldOnClickAfterEndOfLine"] = 48] = "unfoldOnClickAfterEndOfLine";
    EditorOption[EditorOption["fontFamily"] = 49] = "fontFamily";
    EditorOption[EditorOption["fontInfo"] = 50] = "fontInfo";
    EditorOption[EditorOption["fontLigatures"] = 51] = "fontLigatures";
    EditorOption[EditorOption["fontSize"] = 52] = "fontSize";
    EditorOption[EditorOption["fontWeight"] = 53] = "fontWeight";
    EditorOption[EditorOption["fontVariations"] = 54] = "fontVariations";
    EditorOption[EditorOption["formatOnPaste"] = 55] = "formatOnPaste";
    EditorOption[EditorOption["formatOnType"] = 56] = "formatOnType";
    EditorOption[EditorOption["glyphMargin"] = 57] = "glyphMargin";
    EditorOption[EditorOption["gotoLocation"] = 58] = "gotoLocation";
    EditorOption[EditorOption["hideCursorInOverviewRuler"] = 59] = "hideCursorInOverviewRuler";
    EditorOption[EditorOption["hover"] = 60] = "hover";
    EditorOption[EditorOption["inDiffEditor"] = 61] = "inDiffEditor";
    EditorOption[EditorOption["inlineSuggest"] = 62] = "inlineSuggest";
    EditorOption[EditorOption["inlineEdit"] = 63] = "inlineEdit";
    EditorOption[EditorOption["letterSpacing"] = 64] = "letterSpacing";
    EditorOption[EditorOption["lightbulb"] = 65] = "lightbulb";
    EditorOption[EditorOption["lineDecorationsWidth"] = 66] = "lineDecorationsWidth";
    EditorOption[EditorOption["lineHeight"] = 67] = "lineHeight";
    EditorOption[EditorOption["lineNumbers"] = 68] = "lineNumbers";
    EditorOption[EditorOption["lineNumbersMinChars"] = 69] = "lineNumbersMinChars";
    EditorOption[EditorOption["linkedEditing"] = 70] = "linkedEditing";
    EditorOption[EditorOption["links"] = 71] = "links";
    EditorOption[EditorOption["matchBrackets"] = 72] = "matchBrackets";
    EditorOption[EditorOption["minimap"] = 73] = "minimap";
    EditorOption[EditorOption["mouseStyle"] = 74] = "mouseStyle";
    EditorOption[EditorOption["mouseWheelScrollSensitivity"] = 75] = "mouseWheelScrollSensitivity";
    EditorOption[EditorOption["mouseWheelZoom"] = 76] = "mouseWheelZoom";
    EditorOption[EditorOption["multiCursorMergeOverlapping"] = 77] = "multiCursorMergeOverlapping";
    EditorOption[EditorOption["multiCursorModifier"] = 78] = "multiCursorModifier";
    EditorOption[EditorOption["multiCursorPaste"] = 79] = "multiCursorPaste";
    EditorOption[EditorOption["multiCursorLimit"] = 80] = "multiCursorLimit";
    EditorOption[EditorOption["occurrencesHighlight"] = 81] = "occurrencesHighlight";
    EditorOption[EditorOption["overviewRulerBorder"] = 82] = "overviewRulerBorder";
    EditorOption[EditorOption["overviewRulerLanes"] = 83] = "overviewRulerLanes";
    EditorOption[EditorOption["padding"] = 84] = "padding";
    EditorOption[EditorOption["pasteAs"] = 85] = "pasteAs";
    EditorOption[EditorOption["parameterHints"] = 86] = "parameterHints";
    EditorOption[EditorOption["peekWidgetDefaultFocus"] = 87] = "peekWidgetDefaultFocus";
    EditorOption[EditorOption["placeholder"] = 88] = "placeholder";
    EditorOption[EditorOption["definitionLinkOpensInPeek"] = 89] = "definitionLinkOpensInPeek";
    EditorOption[EditorOption["quickSuggestions"] = 90] = "quickSuggestions";
    EditorOption[EditorOption["quickSuggestionsDelay"] = 91] = "quickSuggestionsDelay";
    EditorOption[EditorOption["readOnly"] = 92] = "readOnly";
    EditorOption[EditorOption["readOnlyMessage"] = 93] = "readOnlyMessage";
    EditorOption[EditorOption["renameOnType"] = 94] = "renameOnType";
    EditorOption[EditorOption["renderControlCharacters"] = 95] = "renderControlCharacters";
    EditorOption[EditorOption["renderFinalNewline"] = 96] = "renderFinalNewline";
    EditorOption[EditorOption["renderLineHighlight"] = 97] = "renderLineHighlight";
    EditorOption[EditorOption["renderLineHighlightOnlyWhenFocus"] = 98] = "renderLineHighlightOnlyWhenFocus";
    EditorOption[EditorOption["renderValidationDecorations"] = 99] = "renderValidationDecorations";
    EditorOption[EditorOption["renderWhitespace"] = 100] = "renderWhitespace";
    EditorOption[EditorOption["revealHorizontalRightPadding"] = 101] = "revealHorizontalRightPadding";
    EditorOption[EditorOption["roundedSelection"] = 102] = "roundedSelection";
    EditorOption[EditorOption["rulers"] = 103] = "rulers";
    EditorOption[EditorOption["scrollbar"] = 104] = "scrollbar";
    EditorOption[EditorOption["scrollBeyondLastColumn"] = 105] = "scrollBeyondLastColumn";
    EditorOption[EditorOption["scrollBeyondLastLine"] = 106] = "scrollBeyondLastLine";
    EditorOption[EditorOption["scrollPredominantAxis"] = 107] = "scrollPredominantAxis";
    EditorOption[EditorOption["selectionClipboard"] = 108] = "selectionClipboard";
    EditorOption[EditorOption["selectionHighlight"] = 109] = "selectionHighlight";
    EditorOption[EditorOption["selectOnLineNumbers"] = 110] = "selectOnLineNumbers";
    EditorOption[EditorOption["showFoldingControls"] = 111] = "showFoldingControls";
    EditorOption[EditorOption["showUnused"] = 112] = "showUnused";
    EditorOption[EditorOption["snippetSuggestions"] = 113] = "snippetSuggestions";
    EditorOption[EditorOption["smartSelect"] = 114] = "smartSelect";
    EditorOption[EditorOption["smoothScrolling"] = 115] = "smoothScrolling";
    EditorOption[EditorOption["stickyScroll"] = 116] = "stickyScroll";
    EditorOption[EditorOption["stickyTabStops"] = 117] = "stickyTabStops";
    EditorOption[EditorOption["stopRenderingLineAfter"] = 118] = "stopRenderingLineAfter";
    EditorOption[EditorOption["suggest"] = 119] = "suggest";
    EditorOption[EditorOption["suggestFontSize"] = 120] = "suggestFontSize";
    EditorOption[EditorOption["suggestLineHeight"] = 121] = "suggestLineHeight";
    EditorOption[EditorOption["suggestOnTriggerCharacters"] = 122] = "suggestOnTriggerCharacters";
    EditorOption[EditorOption["suggestSelection"] = 123] = "suggestSelection";
    EditorOption[EditorOption["tabCompletion"] = 124] = "tabCompletion";
    EditorOption[EditorOption["tabIndex"] = 125] = "tabIndex";
    EditorOption[EditorOption["unicodeHighlighting"] = 126] = "unicodeHighlighting";
    EditorOption[EditorOption["unusualLineTerminators"] = 127] = "unusualLineTerminators";
    EditorOption[EditorOption["useShadowDOM"] = 128] = "useShadowDOM";
    EditorOption[EditorOption["useTabStops"] = 129] = "useTabStops";
    EditorOption[EditorOption["wordBreak"] = 130] = "wordBreak";
    EditorOption[EditorOption["wordSegmenterLocales"] = 131] = "wordSegmenterLocales";
    EditorOption[EditorOption["wordSeparators"] = 132] = "wordSeparators";
    EditorOption[EditorOption["wordWrap"] = 133] = "wordWrap";
    EditorOption[EditorOption["wordWrapBreakAfterCharacters"] = 134] = "wordWrapBreakAfterCharacters";
    EditorOption[EditorOption["wordWrapBreakBeforeCharacters"] = 135] = "wordWrapBreakBeforeCharacters";
    EditorOption[EditorOption["wordWrapColumn"] = 136] = "wordWrapColumn";
    EditorOption[EditorOption["wordWrapOverride1"] = 137] = "wordWrapOverride1";
    EditorOption[EditorOption["wordWrapOverride2"] = 138] = "wordWrapOverride2";
    EditorOption[EditorOption["wrappingIndent"] = 139] = "wrappingIndent";
    EditorOption[EditorOption["wrappingStrategy"] = 140] = "wrappingStrategy";
    EditorOption[EditorOption["showDeprecated"] = 141] = "showDeprecated";
    EditorOption[EditorOption["inlayHints"] = 142] = "inlayHints";
    EditorOption[EditorOption["editorClassName"] = 143] = "editorClassName";
    EditorOption[EditorOption["pixelRatio"] = 144] = "pixelRatio";
    EditorOption[EditorOption["tabFocusMode"] = 145] = "tabFocusMode";
    EditorOption[EditorOption["layoutInfo"] = 146] = "layoutInfo";
    EditorOption[EditorOption["wrappingInfo"] = 147] = "wrappingInfo";
    EditorOption[EditorOption["defaultColorDecorators"] = 148] = "defaultColorDecorators";
    EditorOption[EditorOption["colorDecoratorsActivatedOn"] = 149] = "colorDecoratorsActivatedOn";
    EditorOption[EditorOption["inlineCompletionsAccessibilityVerbose"] = 150] = "inlineCompletionsAccessibilityVerbose";
})(EditorOption || (EditorOption = {})));
var EndOfLinePreference;
( (function(EndOfLinePreference) {
    EndOfLinePreference[EndOfLinePreference["TextDefined"] = 0] = "TextDefined";
    EndOfLinePreference[EndOfLinePreference["LF"] = 1] = "LF";
    EndOfLinePreference[EndOfLinePreference["CRLF"] = 2] = "CRLF";
})(EndOfLinePreference || (EndOfLinePreference = {})));
var EndOfLineSequence;
( (function(EndOfLineSequence) {
    EndOfLineSequence[EndOfLineSequence["LF"] = 0] = "LF";
    EndOfLineSequence[EndOfLineSequence["CRLF"] = 1] = "CRLF";
})(EndOfLineSequence || (EndOfLineSequence = {})));
var GlyphMarginLane;
( (function(GlyphMarginLane) {
    GlyphMarginLane[GlyphMarginLane["Left"] = 1] = "Left";
    GlyphMarginLane[GlyphMarginLane["Center"] = 2] = "Center";
    GlyphMarginLane[GlyphMarginLane["Right"] = 3] = "Right";
})(GlyphMarginLane || (GlyphMarginLane = {})));
var HoverVerbosityAction;
( (function(HoverVerbosityAction) {
    HoverVerbosityAction[HoverVerbosityAction["Increase"] = 0] = "Increase";
    HoverVerbosityAction[HoverVerbosityAction["Decrease"] = 1] = "Decrease";
})(HoverVerbosityAction || (HoverVerbosityAction = {})));
var IndentAction;
( (function(IndentAction) {
    IndentAction[IndentAction["None"] = 0] = "None";
    IndentAction[IndentAction["Indent"] = 1] = "Indent";
    IndentAction[IndentAction["IndentOutdent"] = 2] = "IndentOutdent";
    IndentAction[IndentAction["Outdent"] = 3] = "Outdent";
})(IndentAction || (IndentAction = {})));
var InjectedTextCursorStops;
( (function(InjectedTextCursorStops) {
    InjectedTextCursorStops[InjectedTextCursorStops["Both"] = 0] = "Both";
    InjectedTextCursorStops[InjectedTextCursorStops["Right"] = 1] = "Right";
    InjectedTextCursorStops[InjectedTextCursorStops["Left"] = 2] = "Left";
    InjectedTextCursorStops[InjectedTextCursorStops["None"] = 3] = "None";
})(InjectedTextCursorStops || (InjectedTextCursorStops = {})));
var InlayHintKind;
( (function(InlayHintKind) {
    InlayHintKind[InlayHintKind["Type"] = 1] = "Type";
    InlayHintKind[InlayHintKind["Parameter"] = 2] = "Parameter";
})(InlayHintKind || (InlayHintKind = {})));
var InlineCompletionTriggerKind;
( (function(InlineCompletionTriggerKind) {
    InlineCompletionTriggerKind[InlineCompletionTriggerKind["Automatic"] = 0] = "Automatic";
    InlineCompletionTriggerKind[InlineCompletionTriggerKind["Explicit"] = 1] = "Explicit";
})(InlineCompletionTriggerKind || (InlineCompletionTriggerKind = {})));
var InlineEditTriggerKind;
( (function(InlineEditTriggerKind) {
    InlineEditTriggerKind[InlineEditTriggerKind["Invoke"] = 0] = "Invoke";
    InlineEditTriggerKind[InlineEditTriggerKind["Automatic"] = 1] = "Automatic";
})(InlineEditTriggerKind || (InlineEditTriggerKind = {})));
var KeyCode;
( (function(KeyCode) {
    KeyCode[KeyCode["DependsOnKbLayout"] = -1] = "DependsOnKbLayout";
    KeyCode[KeyCode["Unknown"] = 0] = "Unknown";
    KeyCode[KeyCode["Backspace"] = 1] = "Backspace";
    KeyCode[KeyCode["Tab"] = 2] = "Tab";
    KeyCode[KeyCode["Enter"] = 3] = "Enter";
    KeyCode[KeyCode["Shift"] = 4] = "Shift";
    KeyCode[KeyCode["Ctrl"] = 5] = "Ctrl";
    KeyCode[KeyCode["Alt"] = 6] = "Alt";
    KeyCode[KeyCode["PauseBreak"] = 7] = "PauseBreak";
    KeyCode[KeyCode["CapsLock"] = 8] = "CapsLock";
    KeyCode[KeyCode["Escape"] = 9] = "Escape";
    KeyCode[KeyCode["Space"] = 10] = "Space";
    KeyCode[KeyCode["PageUp"] = 11] = "PageUp";
    KeyCode[KeyCode["PageDown"] = 12] = "PageDown";
    KeyCode[KeyCode["End"] = 13] = "End";
    KeyCode[KeyCode["Home"] = 14] = "Home";
    KeyCode[KeyCode["LeftArrow"] = 15] = "LeftArrow";
    KeyCode[KeyCode["UpArrow"] = 16] = "UpArrow";
    KeyCode[KeyCode["RightArrow"] = 17] = "RightArrow";
    KeyCode[KeyCode["DownArrow"] = 18] = "DownArrow";
    KeyCode[KeyCode["Insert"] = 19] = "Insert";
    KeyCode[KeyCode["Delete"] = 20] = "Delete";
    KeyCode[KeyCode["Digit0"] = 21] = "Digit0";
    KeyCode[KeyCode["Digit1"] = 22] = "Digit1";
    KeyCode[KeyCode["Digit2"] = 23] = "Digit2";
    KeyCode[KeyCode["Digit3"] = 24] = "Digit3";
    KeyCode[KeyCode["Digit4"] = 25] = "Digit4";
    KeyCode[KeyCode["Digit5"] = 26] = "Digit5";
    KeyCode[KeyCode["Digit6"] = 27] = "Digit6";
    KeyCode[KeyCode["Digit7"] = 28] = "Digit7";
    KeyCode[KeyCode["Digit8"] = 29] = "Digit8";
    KeyCode[KeyCode["Digit9"] = 30] = "Digit9";
    KeyCode[KeyCode["KeyA"] = 31] = "KeyA";
    KeyCode[KeyCode["KeyB"] = 32] = "KeyB";
    KeyCode[KeyCode["KeyC"] = 33] = "KeyC";
    KeyCode[KeyCode["KeyD"] = 34] = "KeyD";
    KeyCode[KeyCode["KeyE"] = 35] = "KeyE";
    KeyCode[KeyCode["KeyF"] = 36] = "KeyF";
    KeyCode[KeyCode["KeyG"] = 37] = "KeyG";
    KeyCode[KeyCode["KeyH"] = 38] = "KeyH";
    KeyCode[KeyCode["KeyI"] = 39] = "KeyI";
    KeyCode[KeyCode["KeyJ"] = 40] = "KeyJ";
    KeyCode[KeyCode["KeyK"] = 41] = "KeyK";
    KeyCode[KeyCode["KeyL"] = 42] = "KeyL";
    KeyCode[KeyCode["KeyM"] = 43] = "KeyM";
    KeyCode[KeyCode["KeyN"] = 44] = "KeyN";
    KeyCode[KeyCode["KeyO"] = 45] = "KeyO";
    KeyCode[KeyCode["KeyP"] = 46] = "KeyP";
    KeyCode[KeyCode["KeyQ"] = 47] = "KeyQ";
    KeyCode[KeyCode["KeyR"] = 48] = "KeyR";
    KeyCode[KeyCode["KeyS"] = 49] = "KeyS";
    KeyCode[KeyCode["KeyT"] = 50] = "KeyT";
    KeyCode[KeyCode["KeyU"] = 51] = "KeyU";
    KeyCode[KeyCode["KeyV"] = 52] = "KeyV";
    KeyCode[KeyCode["KeyW"] = 53] = "KeyW";
    KeyCode[KeyCode["KeyX"] = 54] = "KeyX";
    KeyCode[KeyCode["KeyY"] = 55] = "KeyY";
    KeyCode[KeyCode["KeyZ"] = 56] = "KeyZ";
    KeyCode[KeyCode["Meta"] = 57] = "Meta";
    KeyCode[KeyCode["ContextMenu"] = 58] = "ContextMenu";
    KeyCode[KeyCode["F1"] = 59] = "F1";
    KeyCode[KeyCode["F2"] = 60] = "F2";
    KeyCode[KeyCode["F3"] = 61] = "F3";
    KeyCode[KeyCode["F4"] = 62] = "F4";
    KeyCode[KeyCode["F5"] = 63] = "F5";
    KeyCode[KeyCode["F6"] = 64] = "F6";
    KeyCode[KeyCode["F7"] = 65] = "F7";
    KeyCode[KeyCode["F8"] = 66] = "F8";
    KeyCode[KeyCode["F9"] = 67] = "F9";
    KeyCode[KeyCode["F10"] = 68] = "F10";
    KeyCode[KeyCode["F11"] = 69] = "F11";
    KeyCode[KeyCode["F12"] = 70] = "F12";
    KeyCode[KeyCode["F13"] = 71] = "F13";
    KeyCode[KeyCode["F14"] = 72] = "F14";
    KeyCode[KeyCode["F15"] = 73] = "F15";
    KeyCode[KeyCode["F16"] = 74] = "F16";
    KeyCode[KeyCode["F17"] = 75] = "F17";
    KeyCode[KeyCode["F18"] = 76] = "F18";
    KeyCode[KeyCode["F19"] = 77] = "F19";
    KeyCode[KeyCode["F20"] = 78] = "F20";
    KeyCode[KeyCode["F21"] = 79] = "F21";
    KeyCode[KeyCode["F22"] = 80] = "F22";
    KeyCode[KeyCode["F23"] = 81] = "F23";
    KeyCode[KeyCode["F24"] = 82] = "F24";
    KeyCode[KeyCode["NumLock"] = 83] = "NumLock";
    KeyCode[KeyCode["ScrollLock"] = 84] = "ScrollLock";
    KeyCode[KeyCode["Semicolon"] = 85] = "Semicolon";
    KeyCode[KeyCode["Equal"] = 86] = "Equal";
    KeyCode[KeyCode["Comma"] = 87] = "Comma";
    KeyCode[KeyCode["Minus"] = 88] = "Minus";
    KeyCode[KeyCode["Period"] = 89] = "Period";
    KeyCode[KeyCode["Slash"] = 90] = "Slash";
    KeyCode[KeyCode["Backquote"] = 91] = "Backquote";
    KeyCode[KeyCode["BracketLeft"] = 92] = "BracketLeft";
    KeyCode[KeyCode["Backslash"] = 93] = "Backslash";
    KeyCode[KeyCode["BracketRight"] = 94] = "BracketRight";
    KeyCode[KeyCode["Quote"] = 95] = "Quote";
    KeyCode[KeyCode["OEM_8"] = 96] = "OEM_8";
    KeyCode[KeyCode["IntlBackslash"] = 97] = "IntlBackslash";
    KeyCode[KeyCode["Numpad0"] = 98] = "Numpad0";
    KeyCode[KeyCode["Numpad1"] = 99] = "Numpad1";
    KeyCode[KeyCode["Numpad2"] = 100] = "Numpad2";
    KeyCode[KeyCode["Numpad3"] = 101] = "Numpad3";
    KeyCode[KeyCode["Numpad4"] = 102] = "Numpad4";
    KeyCode[KeyCode["Numpad5"] = 103] = "Numpad5";
    KeyCode[KeyCode["Numpad6"] = 104] = "Numpad6";
    KeyCode[KeyCode["Numpad7"] = 105] = "Numpad7";
    KeyCode[KeyCode["Numpad8"] = 106] = "Numpad8";
    KeyCode[KeyCode["Numpad9"] = 107] = "Numpad9";
    KeyCode[KeyCode["NumpadMultiply"] = 108] = "NumpadMultiply";
    KeyCode[KeyCode["NumpadAdd"] = 109] = "NumpadAdd";
    KeyCode[KeyCode["NUMPAD_SEPARATOR"] = 110] = "NUMPAD_SEPARATOR";
    KeyCode[KeyCode["NumpadSubtract"] = 111] = "NumpadSubtract";
    KeyCode[KeyCode["NumpadDecimal"] = 112] = "NumpadDecimal";
    KeyCode[KeyCode["NumpadDivide"] = 113] = "NumpadDivide";
    KeyCode[KeyCode["KEY_IN_COMPOSITION"] = 114] = "KEY_IN_COMPOSITION";
    KeyCode[KeyCode["ABNT_C1"] = 115] = "ABNT_C1";
    KeyCode[KeyCode["ABNT_C2"] = 116] = "ABNT_C2";
    KeyCode[KeyCode["AudioVolumeMute"] = 117] = "AudioVolumeMute";
    KeyCode[KeyCode["AudioVolumeUp"] = 118] = "AudioVolumeUp";
    KeyCode[KeyCode["AudioVolumeDown"] = 119] = "AudioVolumeDown";
    KeyCode[KeyCode["BrowserSearch"] = 120] = "BrowserSearch";
    KeyCode[KeyCode["BrowserHome"] = 121] = "BrowserHome";
    KeyCode[KeyCode["BrowserBack"] = 122] = "BrowserBack";
    KeyCode[KeyCode["BrowserForward"] = 123] = "BrowserForward";
    KeyCode[KeyCode["MediaTrackNext"] = 124] = "MediaTrackNext";
    KeyCode[KeyCode["MediaTrackPrevious"] = 125] = "MediaTrackPrevious";
    KeyCode[KeyCode["MediaStop"] = 126] = "MediaStop";
    KeyCode[KeyCode["MediaPlayPause"] = 127] = "MediaPlayPause";
    KeyCode[KeyCode["LaunchMediaPlayer"] = 128] = "LaunchMediaPlayer";
    KeyCode[KeyCode["LaunchMail"] = 129] = "LaunchMail";
    KeyCode[KeyCode["LaunchApp2"] = 130] = "LaunchApp2";
    KeyCode[KeyCode["Clear"] = 131] = "Clear";
    KeyCode[KeyCode["MAX_VALUE"] = 132] = "MAX_VALUE";
})(KeyCode || (KeyCode = {})));
var MarkerSeverity;
( (function(MarkerSeverity) {
    MarkerSeverity[MarkerSeverity["Hint"] = 1] = "Hint";
    MarkerSeverity[MarkerSeverity["Info"] = 2] = "Info";
    MarkerSeverity[MarkerSeverity["Warning"] = 4] = "Warning";
    MarkerSeverity[MarkerSeverity["Error"] = 8] = "Error";
})(MarkerSeverity || (MarkerSeverity = {})));
var MarkerTag;
( (function(MarkerTag) {
    MarkerTag[MarkerTag["Unnecessary"] = 1] = "Unnecessary";
    MarkerTag[MarkerTag["Deprecated"] = 2] = "Deprecated";
})(MarkerTag || (MarkerTag = {})));
var MinimapPosition;
( (function(MinimapPosition) {
    MinimapPosition[MinimapPosition["Inline"] = 1] = "Inline";
    MinimapPosition[MinimapPosition["Gutter"] = 2] = "Gutter";
})(MinimapPosition || (MinimapPosition = {})));
var MinimapSectionHeaderStyle;
( (function(MinimapSectionHeaderStyle) {
    MinimapSectionHeaderStyle[MinimapSectionHeaderStyle["Normal"] = 1] = "Normal";
    MinimapSectionHeaderStyle[MinimapSectionHeaderStyle["Underlined"] = 2] = "Underlined";
})(MinimapSectionHeaderStyle || (MinimapSectionHeaderStyle = {})));
var MouseTargetType;
( (function(MouseTargetType) {
    MouseTargetType[MouseTargetType["UNKNOWN"] = 0] = "UNKNOWN";
    MouseTargetType[MouseTargetType["TEXTAREA"] = 1] = "TEXTAREA";
    MouseTargetType[MouseTargetType["GUTTER_GLYPH_MARGIN"] = 2] = "GUTTER_GLYPH_MARGIN";
    MouseTargetType[MouseTargetType["GUTTER_LINE_NUMBERS"] = 3] = "GUTTER_LINE_NUMBERS";
    MouseTargetType[MouseTargetType["GUTTER_LINE_DECORATIONS"] = 4] = "GUTTER_LINE_DECORATIONS";
    MouseTargetType[MouseTargetType["GUTTER_VIEW_ZONE"] = 5] = "GUTTER_VIEW_ZONE";
    MouseTargetType[MouseTargetType["CONTENT_TEXT"] = 6] = "CONTENT_TEXT";
    MouseTargetType[MouseTargetType["CONTENT_EMPTY"] = 7] = "CONTENT_EMPTY";
    MouseTargetType[MouseTargetType["CONTENT_VIEW_ZONE"] = 8] = "CONTENT_VIEW_ZONE";
    MouseTargetType[MouseTargetType["CONTENT_WIDGET"] = 9] = "CONTENT_WIDGET";
    MouseTargetType[MouseTargetType["OVERVIEW_RULER"] = 10] = "OVERVIEW_RULER";
    MouseTargetType[MouseTargetType["SCROLLBAR"] = 11] = "SCROLLBAR";
    MouseTargetType[MouseTargetType["OVERLAY_WIDGET"] = 12] = "OVERLAY_WIDGET";
    MouseTargetType[MouseTargetType["OUTSIDE_EDITOR"] = 13] = "OUTSIDE_EDITOR";
})(MouseTargetType || (MouseTargetType = {})));
var NewSymbolNameTag;
( (function(NewSymbolNameTag) {
    NewSymbolNameTag[NewSymbolNameTag["AIGenerated"] = 1] = "AIGenerated";
})(NewSymbolNameTag || (NewSymbolNameTag = {})));
var NewSymbolNameTriggerKind;
( (function(NewSymbolNameTriggerKind) {
    NewSymbolNameTriggerKind[NewSymbolNameTriggerKind["Invoke"] = 0] = "Invoke";
    NewSymbolNameTriggerKind[NewSymbolNameTriggerKind["Automatic"] = 1] = "Automatic";
})(NewSymbolNameTriggerKind || (NewSymbolNameTriggerKind = {})));
var OverlayWidgetPositionPreference;
( (function(OverlayWidgetPositionPreference) {
    OverlayWidgetPositionPreference[OverlayWidgetPositionPreference["TOP_RIGHT_CORNER"] = 0] = "TOP_RIGHT_CORNER";
    OverlayWidgetPositionPreference[OverlayWidgetPositionPreference["BOTTOM_RIGHT_CORNER"] = 1] = "BOTTOM_RIGHT_CORNER";
    OverlayWidgetPositionPreference[OverlayWidgetPositionPreference["TOP_CENTER"] = 2] = "TOP_CENTER";
})(OverlayWidgetPositionPreference || (OverlayWidgetPositionPreference = {})));
var OverviewRulerLane;
( (function(OverviewRulerLane) {
    OverviewRulerLane[OverviewRulerLane["Left"] = 1] = "Left";
    OverviewRulerLane[OverviewRulerLane["Center"] = 2] = "Center";
    OverviewRulerLane[OverviewRulerLane["Right"] = 4] = "Right";
    OverviewRulerLane[OverviewRulerLane["Full"] = 7] = "Full";
})(OverviewRulerLane || (OverviewRulerLane = {})));
var PartialAcceptTriggerKind;
( (function(PartialAcceptTriggerKind) {
    PartialAcceptTriggerKind[PartialAcceptTriggerKind["Word"] = 0] = "Word";
    PartialAcceptTriggerKind[PartialAcceptTriggerKind["Line"] = 1] = "Line";
    PartialAcceptTriggerKind[PartialAcceptTriggerKind["Suggest"] = 2] = "Suggest";
})(PartialAcceptTriggerKind || (PartialAcceptTriggerKind = {})));
var PositionAffinity;
( (function(PositionAffinity) {
    PositionAffinity[PositionAffinity["Left"] = 0] = "Left";
    PositionAffinity[PositionAffinity["Right"] = 1] = "Right";
    PositionAffinity[PositionAffinity["None"] = 2] = "None";
    PositionAffinity[PositionAffinity["LeftOfInjectedText"] = 3] = "LeftOfInjectedText";
    PositionAffinity[PositionAffinity["RightOfInjectedText"] = 4] = "RightOfInjectedText";
})(PositionAffinity || (PositionAffinity = {})));
var RenderLineNumbersType;
( (function(RenderLineNumbersType) {
    RenderLineNumbersType[RenderLineNumbersType["Off"] = 0] = "Off";
    RenderLineNumbersType[RenderLineNumbersType["On"] = 1] = "On";
    RenderLineNumbersType[RenderLineNumbersType["Relative"] = 2] = "Relative";
    RenderLineNumbersType[RenderLineNumbersType["Interval"] = 3] = "Interval";
    RenderLineNumbersType[RenderLineNumbersType["Custom"] = 4] = "Custom";
})(RenderLineNumbersType || (RenderLineNumbersType = {})));
var RenderMinimap;
( (function(RenderMinimap) {
    RenderMinimap[RenderMinimap["None"] = 0] = "None";
    RenderMinimap[RenderMinimap["Text"] = 1] = "Text";
    RenderMinimap[RenderMinimap["Blocks"] = 2] = "Blocks";
})(RenderMinimap || (RenderMinimap = {})));
var ScrollType;
( (function(ScrollType) {
    ScrollType[ScrollType["Smooth"] = 0] = "Smooth";
    ScrollType[ScrollType["Immediate"] = 1] = "Immediate";
})(ScrollType || (ScrollType = {})));
var ScrollbarVisibility;
( (function(ScrollbarVisibility) {
    ScrollbarVisibility[ScrollbarVisibility["Auto"] = 1] = "Auto";
    ScrollbarVisibility[ScrollbarVisibility["Hidden"] = 2] = "Hidden";
    ScrollbarVisibility[ScrollbarVisibility["Visible"] = 3] = "Visible";
})(ScrollbarVisibility || (ScrollbarVisibility = {})));
var SelectionDirection;
( (function(SelectionDirection) {
    SelectionDirection[SelectionDirection["LTR"] = 0] = "LTR";
    SelectionDirection[SelectionDirection["RTL"] = 1] = "RTL";
})(SelectionDirection || (SelectionDirection = {})));
var ShowLightbulbIconMode;
( (function(ShowLightbulbIconMode) {
    ShowLightbulbIconMode["Off"] = "off";
    ShowLightbulbIconMode["OnCode"] = "onCode";
    ShowLightbulbIconMode["On"] = "on";
})(ShowLightbulbIconMode || (ShowLightbulbIconMode = {})));
var SignatureHelpTriggerKind;
( (function(SignatureHelpTriggerKind) {
    SignatureHelpTriggerKind[SignatureHelpTriggerKind["Invoke"] = 1] = "Invoke";
    SignatureHelpTriggerKind[SignatureHelpTriggerKind["TriggerCharacter"] = 2] = "TriggerCharacter";
    SignatureHelpTriggerKind[SignatureHelpTriggerKind["ContentChange"] = 3] = "ContentChange";
})(SignatureHelpTriggerKind || (SignatureHelpTriggerKind = {})));
var SymbolKind;
( (function(SymbolKind) {
    SymbolKind[SymbolKind["File"] = 0] = "File";
    SymbolKind[SymbolKind["Module"] = 1] = "Module";
    SymbolKind[SymbolKind["Namespace"] = 2] = "Namespace";
    SymbolKind[SymbolKind["Package"] = 3] = "Package";
    SymbolKind[SymbolKind["Class"] = 4] = "Class";
    SymbolKind[SymbolKind["Method"] = 5] = "Method";
    SymbolKind[SymbolKind["Property"] = 6] = "Property";
    SymbolKind[SymbolKind["Field"] = 7] = "Field";
    SymbolKind[SymbolKind["Constructor"] = 8] = "Constructor";
    SymbolKind[SymbolKind["Enum"] = 9] = "Enum";
    SymbolKind[SymbolKind["Interface"] = 10] = "Interface";
    SymbolKind[SymbolKind["Function"] = 11] = "Function";
    SymbolKind[SymbolKind["Variable"] = 12] = "Variable";
    SymbolKind[SymbolKind["Constant"] = 13] = "Constant";
    SymbolKind[SymbolKind["String"] = 14] = "String";
    SymbolKind[SymbolKind["Number"] = 15] = "Number";
    SymbolKind[SymbolKind["Boolean"] = 16] = "Boolean";
    SymbolKind[SymbolKind["Array"] = 17] = "Array";
    SymbolKind[SymbolKind["Object"] = 18] = "Object";
    SymbolKind[SymbolKind["Key"] = 19] = "Key";
    SymbolKind[SymbolKind["Null"] = 20] = "Null";
    SymbolKind[SymbolKind["EnumMember"] = 21] = "EnumMember";
    SymbolKind[SymbolKind["Struct"] = 22] = "Struct";
    SymbolKind[SymbolKind["Event"] = 23] = "Event";
    SymbolKind[SymbolKind["Operator"] = 24] = "Operator";
    SymbolKind[SymbolKind["TypeParameter"] = 25] = "TypeParameter";
})(SymbolKind || (SymbolKind = {})));
var SymbolTag;
( (function(SymbolTag) {
    SymbolTag[SymbolTag["Deprecated"] = 1] = "Deprecated";
})(SymbolTag || (SymbolTag = {})));
var TextEditorCursorBlinkingStyle;
( (function(TextEditorCursorBlinkingStyle) {
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Hidden"] = 0] = "Hidden";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Blink"] = 1] = "Blink";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Smooth"] = 2] = "Smooth";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Phase"] = 3] = "Phase";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Expand"] = 4] = "Expand";
    TextEditorCursorBlinkingStyle[TextEditorCursorBlinkingStyle["Solid"] = 5] = "Solid";
})(TextEditorCursorBlinkingStyle || (TextEditorCursorBlinkingStyle = {})));
var TextEditorCursorStyle;
( (function(TextEditorCursorStyle) {
    TextEditorCursorStyle[TextEditorCursorStyle["Line"] = 1] = "Line";
    TextEditorCursorStyle[TextEditorCursorStyle["Block"] = 2] = "Block";
    TextEditorCursorStyle[TextEditorCursorStyle["Underline"] = 3] = "Underline";
    TextEditorCursorStyle[TextEditorCursorStyle["LineThin"] = 4] = "LineThin";
    TextEditorCursorStyle[TextEditorCursorStyle["BlockOutline"] = 5] = "BlockOutline";
    TextEditorCursorStyle[TextEditorCursorStyle["UnderlineThin"] = 6] = "UnderlineThin";
})(TextEditorCursorStyle || (TextEditorCursorStyle = {})));
var TrackedRangeStickiness;
( (function(TrackedRangeStickiness) {
    TrackedRangeStickiness[TrackedRangeStickiness["AlwaysGrowsWhenTypingAtEdges"] = 0] = "AlwaysGrowsWhenTypingAtEdges";
    TrackedRangeStickiness[TrackedRangeStickiness["NeverGrowsWhenTypingAtEdges"] = 1] = "NeverGrowsWhenTypingAtEdges";
    TrackedRangeStickiness[TrackedRangeStickiness["GrowsOnlyWhenTypingBefore"] = 2] = "GrowsOnlyWhenTypingBefore";
    TrackedRangeStickiness[TrackedRangeStickiness["GrowsOnlyWhenTypingAfter"] = 3] = "GrowsOnlyWhenTypingAfter";
})(TrackedRangeStickiness || (TrackedRangeStickiness = {})));
var WrappingIndent;
( (function(WrappingIndent) {
    WrappingIndent[WrappingIndent["None"] = 0] = "None";
    WrappingIndent[WrappingIndent["Same"] = 1] = "Same";
    WrappingIndent[WrappingIndent["Indent"] = 2] = "Indent";
    WrappingIndent[WrappingIndent["DeepIndent"] = 3] = "DeepIndent";
})(WrappingIndent || (WrappingIndent = {})));



/***/ }),

/***/ "./node_modules/vscode/vscode/src/vs/editor/editor.worker.js":
/*!*******************************************************************!*\
  !*** ./node_modules/vscode/vscode/src/vs/editor/editor.worker.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   initialize: () => (/* binding */ initialize)
/* harmony export */ });
/* harmony import */ var _base_common_worker_simpleWorker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../base/common/worker/simpleWorker.js */ "./node_modules/vscode/vscode/src/vs/base/common/worker/simpleWorker.js");
/* harmony import */ var _common_services_editorSimpleWorker_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./common/services/editorSimpleWorker.js */ "./node_modules/vscode/vscode/src/vs/editor/common/services/editorSimpleWorker.js");


let initialized = false;
function initialize(foreignModule) {
    if (initialized) {
        return;
    }
    initialized = true;
    const simpleWorker = ( new _base_common_worker_simpleWorker_js__WEBPACK_IMPORTED_MODULE_0__.SimpleWorkerServer((msg) => {
        globalThis.postMessage(msg);
    }, (host) => ( new _common_services_editorSimpleWorker_js__WEBPACK_IMPORTED_MODULE_1__.EditorSimpleWorker(host, foreignModule))));
    globalThis.onmessage = (e) => {
        simpleWorker.onmessage(e.data);
    };
}
globalThis.onmessage = (e) => {
    if (!initialized) {
        initialize(null);
    }
};



/***/ }),

/***/ "./node_modules/vscode/workers/editor.worker.js":
/*!******************************************************!*\
  !*** ./node_modules/vscode/workers/editor.worker.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   initialize: () => (/* reexport safe */ _vscode_src_vs_editor_editor_worker_js__WEBPACK_IMPORTED_MODULE_0__.initialize)
/* harmony export */ });
/* harmony import */ var _vscode_src_vs_editor_editor_worker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../vscode/src/vs/editor/editor.worker.js */ "./node_modules/vscode/vscode/src/vs/editor/editor.worker.js");



/***/ })

/******/ });
/************************************************************************/
/******/ // The module cache
/******/ var __webpack_module_cache__ = {};
/******/ 
/******/ // The require function
/******/ function __webpack_require__(moduleId) {
/******/ 	// Check if module is in cache
/******/ 	var cachedModule = __webpack_module_cache__[moduleId];
/******/ 	if (cachedModule !== undefined) {
/******/ 		return cachedModule.exports;
/******/ 	}
/******/ 	// Create a new module (and put it into the cache)
/******/ 	var module = __webpack_module_cache__[moduleId] = {
/******/ 		// no module.id needed
/******/ 		// no module.loaded needed
/******/ 		exports: {}
/******/ 	};
/******/ 
/******/ 	// Execute the module function
/******/ 	__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 
/******/ 	// Return the exports of the module
/******/ 	return module.exports;
/******/ }
/******/ 
/******/ // expose the modules object (__webpack_modules__)
/******/ __webpack_require__.m = __webpack_modules__;
/******/ 
/******/ // the startup function
/******/ __webpack_require__.x = () => {
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["vendors-node_modules_vscode_vscode_src_vs_base_common_assert_js-node_modules_vscode_vscode_sr-d1ce6a"], () => (__webpack_require__("./node_modules/monaco-editor/esm/vs/editor/editor.worker.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	return __webpack_exports__;
/******/ };
/******/ 
/************************************************************************/
/******/ /* webpack/runtime/chunk loaded */
/******/ (() => {
/******/ 	var deferred = [];
/******/ 	__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 		if(chunkIds) {
/******/ 			priority = priority || 0;
/******/ 			for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 			deferred[i] = [chunkIds, fn, priority];
/******/ 			return;
/******/ 		}
/******/ 		var notFulfilled = Infinity;
/******/ 		for (var i = 0; i < deferred.length; i++) {
/******/ 			var [chunkIds, fn, priority] = deferred[i];
/******/ 			var fulfilled = true;
/******/ 			for (var j = 0; j < chunkIds.length; j++) {
/******/ 				if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 					chunkIds.splice(j--, 1);
/******/ 				} else {
/******/ 					fulfilled = false;
/******/ 					if(priority < notFulfilled) notFulfilled = priority;
/******/ 				}
/******/ 			}
/******/ 			if(fulfilled) {
/******/ 				deferred.splice(i--, 1)
/******/ 				var r = fn();
/******/ 				if (r !== undefined) result = r;
/******/ 			}
/******/ 		}
/******/ 		return result;
/******/ 	};
/******/ })();
/******/ 
/******/ /* webpack/runtime/define property getters */
/******/ (() => {
/******/ 	// define getter functions for harmony exports
/******/ 	__webpack_require__.d = (exports, definition) => {
/******/ 		for(var key in definition) {
/******/ 			if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 				Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 			}
/******/ 		}
/******/ 	};
/******/ })();
/******/ 
/******/ /* webpack/runtime/ensure chunk */
/******/ (() => {
/******/ 	__webpack_require__.f = {};
/******/ 	// This file contains only the entry chunk.
/******/ 	// The chunk loading function for additional chunks
/******/ 	__webpack_require__.e = (chunkId) => {
/******/ 		return Promise.all(Object.keys(__webpack_require__.f).reduce((promises, key) => {
/******/ 			__webpack_require__.f[key](chunkId, promises);
/******/ 			return promises;
/******/ 		}, []));
/******/ 	};
/******/ })();
/******/ 
/******/ /* webpack/runtime/get javascript chunk filename */
/******/ (() => {
/******/ 	// This function allow to reference async chunks and sibling chunks for the entrypoint
/******/ 	__webpack_require__.u = (chunkId) => {
/******/ 		// return url for filenames based on template
/******/ 		return "" + chunkId + ".main.js";
/******/ 	};
/******/ })();
/******/ 
/******/ /* webpack/runtime/hasOwnProperty shorthand */
/******/ (() => {
/******/ 	__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ })();
/******/ 
/******/ /* webpack/runtime/make namespace object */
/******/ (() => {
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = (exports) => {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/ })();
/******/ 
/******/ /* webpack/runtime/publicPath */
/******/ (() => {
/******/ 	var scriptUrl;
/******/ 	if (typeof import.meta.url === "string") scriptUrl = import.meta.url
/******/ 	// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 	// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 	if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 	scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 	__webpack_require__.p = scriptUrl;
/******/ })();
/******/ 
/******/ /* webpack/runtime/importScripts chunk loading */
/******/ (() => {
/******/ 	// no baseURI
/******/ 	
/******/ 	// object to store loaded chunks
/******/ 	// "1" means "already loaded"
/******/ 	var installedChunks = {
/******/ 		"vendors-node_modules_monaco-editor_esm_vs_editor_editor_worker_js": 1
/******/ 	};
/******/ 	
/******/ 	// importScripts chunk loading
/******/ 	var installChunk = (data) => {
/******/ 		var [chunkIds, moreModules, runtime] = data;
/******/ 		for(var moduleId in moreModules) {
/******/ 			if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 				__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 			}
/******/ 		}
/******/ 		if(runtime) runtime(__webpack_require__);
/******/ 		while(chunkIds.length)
/******/ 			installedChunks[chunkIds.pop()] = 1;
/******/ 		parentChunkLoadingFunction(data);
/******/ 	};
/******/ 	__webpack_require__.f.i = (chunkId, promises) => {
/******/ 		// "1" is the signal for "already loaded"
/******/ 		if(!installedChunks[chunkId]) {
/******/ 			if(true) { // all chunks have JS
/******/ 				importScripts(__webpack_require__.p + __webpack_require__.u(chunkId));
/******/ 			}
/******/ 		}
/******/ 	};
/******/ 	
/******/ 	var chunkLoadingGlobal = self["webpackChunkexample_client_webpack"] = self["webpackChunkexample_client_webpack"] || [];
/******/ 	var parentChunkLoadingFunction = chunkLoadingGlobal.push.bind(chunkLoadingGlobal);
/******/ 	chunkLoadingGlobal.push = installChunk;
/******/ 	
/******/ 	// no HMR
/******/ 	
/******/ 	// no HMR manifest
/******/ })();
/******/ 
/******/ /* webpack/runtime/startup chunk dependencies */
/******/ (() => {
/******/ 	var next = __webpack_require__.x;
/******/ 	__webpack_require__.x = () => {
/******/ 		return __webpack_require__.e("vendors-node_modules_vscode_vscode_src_vs_base_common_assert_js-node_modules_vscode_vscode_sr-d1ce6a").then(next);
/******/ 	};
/******/ })();
/******/ 
/************************************************************************/
/******/ 
/******/ // run startup
/******/ var __webpack_exports__ = __webpack_require__.x();
/******/ 

//# sourceMappingURL=vendors-node_modules_monaco-editor_esm_vs_editor_editor_worker_js.main.js.map