/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.KeyPressEvent;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractProjectViewer;
import io.quassar.editor.box.ui.displays.templates.ProjectModuleLinkViewer;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Model;
import java.util.List;
import java.util.function.Consumer;

public class ProjectViewer
extends AbstractProjectViewer<EditorBox> {
    private Model model;
    private String project;
    private Consumer<Model> selectListener;

    public ProjectViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void project(String project) {
        this.project = project;
        this.newModuleField.value(null);
    }

    public void onSelect(Consumer<Model> listener) {
        this.selectListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.newModuleField.onEnterPress(this::addModule);
    }

    public void refresh() {
        super.refresh();
        List<String> moduleList = ((EditorBox)this.box()).modelManager().modules(this.project, this.username());
        this.modules.clear();
        moduleList.forEach(p -> this.fill((String)p, (ProjectModuleLinkViewer)this.modules.add()));
    }

    private void fill(String module, ProjectModuleLinkViewer display) {
        display.model(((EditorBox)this.box()).modelManager().model(this.project, module, this.model.language(), this.username()));
        display.onSelect((String e) -> this.open(module));
        display.module(module);
        display.selected(module != null && this.model.module().equals(module));
        display.refresh();
    }

    private void open(String module) {
        Model model = ((EditorBox)this.box()).modelManager().model(this.project, module, this.model.language(), this.username());
        if (model == null) {
            model = ((EditorBox)this.box()).commands(ModelCommands.class).create(ModelHelper.proposeName(), "", this.model.language(), this.username(), this.username());
            ((EditorBox)this.box()).commands(ModelCommands.class).saveQualifiedName(model, this.project, module, this.username());
        }
        ((TemplateNotifier)this.notifier).redirect(PathHelper.modelUrl(model, this.session()));
    }

    private void openModules() {
        this.modules.show();
        this.currentModuleBlock.hide();
        this.refresh();
    }

    private void addModule(KeyPressEvent e) {
        if (e.value() == null) {
            return;
        }
        if (!DisplayHelper.check(this.newModuleField, arg_0 -> ((ProjectViewer)this).translate(arg_0))) {
            return;
        }
        String name = (String)e.value();
        ((EditorBox)this.box()).commands(ModelCommands.class).createModule(name, this.project, this.model.language(), this.username());
        this.newModuleField.value(null);
        this.open(name);
    }
}

