/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.selector.SelectorOption;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractReleaseSelectorOption;
import io.quassar.editor.model.Language;
import java.util.UUID;
import java.util.function.Consumer;

public class ReleaseSelectorOption
extends AbstractReleaseSelectorOption<EditorBox>
implements SelectorOption {
    private Language language;
    private String release;
    private Consumer<String> removeListener;

    public ReleaseSelectorOption(EditorBox box) {
        super(box);
        this.id(UUID.randomUUID().toString());
    }

    public ReleaseSelectorOption language(Language language) {
        this.language = language;
        return this;
    }

    public String release() {
        return this.release;
    }

    public ReleaseSelectorOption release(String release) {
        this.name(release);
        this.release = release;
        return this;
    }

    public ReleaseSelectorOption onRemove(Consumer<String> listener) {
        this.removeListener = listener;
        return this;
    }

    public void update() {
        super.update();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.remove.onExecute(e -> this.removeListener.accept(this.release));
        this.remove.signChecker((sign, reason) -> this.release.equals(sign));
    }

    public void refresh() {
        super.refresh();
        this.version.value(this.release);
        this.remove.visible(this.language.release(this.release) != null);
    }
}

