/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLicenseItemTemplate;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.License;
import java.util.Set;
import java.util.function.Consumer;

public class LicenseItemTemplate
extends AbstractLicenseItemTemplate<EditorBox> {
    private License license;
    private Consumer<License> renewListener;

    public LicenseItemTemplate(EditorBox box) {
        super(box);
    }

    public void license(License license) {
        this.license = license;
    }

    public void onRenew(Consumer<License> listener) {
        this.renewListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.renew.onExecute(e -> this.renewListener.accept(this.license));
    }

    public void refresh() {
        super.refresh();
        this.bullet.formats(Set.of(this.license.isExpired() ? "inactiveBullet" : "activeBullet"));
        this.title.value(this.license.code() + " - " + this.license.collection().name());
        this.renew.visible(this.renewListener != null && PermissionsHelper.canRenew(this.license, this.session(), (EditorBox)this.box()));
        this.expirationInfo.value(DisplayHelper.expirationInfo(this.license, arg_0 -> ((LicenseItemTemplate)this).translate(arg_0), this.language()));
    }
}

