/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.CollectionCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractCollectionTemplate;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Collection;
import java.util.List;

public class CollectionTemplate
extends AbstractCollectionTemplate<EditorBox> {
    private Collection collection;

    public CollectionTemplate(EditorBox box) {
        super(box);
    }

    public void open(String collection) {
        this.collection = ((EditorBox)this.box()).collectionManager().get(collection);
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.mainBlock.onInit(e -> this.initMainBlock());
        this.mainBlock.onShow(e -> this.refreshMainBlock());
    }

    public void refresh() {
        super.refresh();
        this.notFoundBlock.visible(!PermissionsHelper.hasPermissions(this.collection, this.session(), (EditorBox)this.box()));
        this.refreshHeader();
        this.refreshBlocks();
    }

    private void refreshHeader() {
        this.headerStamp.visible(PermissionsHelper.hasPermissions(this.collection, this.session(), (EditorBox)this.box()));
        if (!this.headerStamp.isVisible()) {
            return;
        }
        this.headerStamp.collection(this.collection);
        this.headerStamp.refresh();
    }

    private void refreshBlocks() {
        this.mainBlock.visible(PermissionsHelper.hasPermissions(this.collection, this.session(), (EditorBox)this.box()));
    }

    private void initMainBlock() {
        this.remove.onExecute(e -> this.removeCollection());
        this.remove.signChecker((sign, reason) -> this.collection.name().equals(sign));
        this.collaboratorsStamp.onChange(this::saveCollaborators);
    }

    private void refreshMainBlock() {
        this.refreshProperties();
        this.refreshLanguages();
        this.refreshCollaborators();
        this.refreshLicenses();
    }

    private void refreshProperties() {
        this.remove.visible(PermissionsHelper.canRemove(this.collection, this.session(), (EditorBox)this.box()));
        this.subscriptionPlan.value(this.translate("%s subscription").formatted(this.translate(this.collection.subscriptionPlan().name())));
        this.subscriptionPlan.backgroundColor(this.subscriptionPlanBackgroundColor());
    }

    private void refreshLanguages() {
        this.languagesCatalog.collection(this.collection);
        this.languagesCatalog.refresh();
    }

    private void refreshCollaborators() {
        this.collaboratorsStamp.owner(this.collection.owner());
        this.collaboratorsStamp.collaborators(this.collection.collaborators());
        this.collaboratorsStamp.readonly(!PermissionsHelper.canInvite(this.collection, this.session(), (EditorBox)this.box()));
        this.collaboratorsStamp.collaboratorsTitle.value(this.translate("Collaborators (max. %s)").formatted(((EditorBox)this.box()).configuration().collectionCollaboratorsCount()));
        this.collaboratorsStamp.refresh();
    }

    private void refreshLicenses() {
        this.licensesStamp.collection(this.collection);
        this.licensesStamp.refresh();
    }

    private String subscriptionPlanBackgroundColor() {
        if (this.collection.subscriptionPlan() == Collection.SubscriptionPlan.Enterprise) {
            return "black";
        }
        return "blue";
    }

    private void removeCollection() {
        ((EditorBox)this.box()).commands(CollectionCommands.class).remove(this.collection, this.username());
        ((TemplateNotifier)this.notifier).redirect(PathHelper.homeUrl(this.session()));
    }

    private void saveCollaborators(List<String> collaborators) {
        ((EditorBox)this.box()).commands(CollectionCommands.class).save(this.collection, collaborators, this.username());
        this.refreshCollaborators();
    }
}

