/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractForgeTemplate;
import io.quassar.editor.box.ui.types.ForgeView;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.SessionHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;

public class ForgeTemplate
extends AbstractForgeTemplate<EditorBox> {
    private Model model;
    private String release;
    private ForgeView view;

    public ForgeTemplate(EditorBox box) {
        super(box);
    }

    public void open(String model, String release, String view) {
        this.model = ((EditorBox)this.box()).modelManager().get(model);
        this.release = release;
        this.view = view != null ? ForgeView.from(view) : SessionHelper.forgeView(this.session());
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.createLanguageBlock.onInit(e -> this.initCreateLanguageBlock());
        this.createLanguageBlock.onShow(e -> this.refreshCreateLanguageBlock());
        this.languageBlock.onShow(e -> this.refreshLanguageBlock());
    }

    public void refresh() {
        super.refresh();
        this.notFoundBlock.visible(!PermissionsHelper.hasPermissions(this.model, this.session(), (EditorBox)this.box()));
        this.contentBlock.visible(PermissionsHelper.hasPermissions(this.model, this.session(), (EditorBox)this.box()));
        if (this.model == null) {
            return;
        }
        Language language = ((EditorBox)this.box()).languageManager().getWithMetamodel(this.model);
        this.hideBlocks();
        if (language == null) {
            this.createLanguageBlock.show();
        } else {
            this.languageBlock.show();
        }
    }

    private void hideBlocks() {
        if (this.createLanguageBlock.isVisible()) {
            this.createLanguageBlock.hide();
        }
        if (this.languageBlock.isVisible()) {
            this.languageBlock.hide();
        }
    }

    private void initCreateLanguageBlock() {
        this.createLanguageStamp.onCreate(language -> this.refresh());
    }

    private void refreshCreateLanguageBlock() {
        this.createLanguageStamp.model(this.model);
        this.createLanguageStamp.release(this.release);
        this.createLanguageStamp.refresh();
    }

    private void refreshLanguageBlock() {
        this.languageStamp.language(((EditorBox)this.box()).languageManager().getWithMetamodel(this.model));
        this.languageStamp.release(this.release);
        this.languageStamp.view(this.view);
        this.languageStamp.refresh();
    }
}

