/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.schemas.IntinoDslEditorFile;
import io.quassar.editor.box.schemas.IntinoDslEditorFileContent;
import io.quassar.editor.box.schemas.IntinoDslEditorFilePosition;
import io.quassar.editor.box.schemas.IntinoDslEditorSetup;
import io.quassar.editor.box.ui.displays.AbstractIntinoDslEditor;
import io.quassar.editor.box.ui.displays.notifiers.IntinoDslEditorNotifier;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.FilePosition;
import io.quassar.editor.model.Model;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;

public class IntinoDslEditor
extends AbstractIntinoDslEditor<EditorBox> {
    private Model model;
    private String release;
    private LanguageTab tab;
    private ModelView view;
    private List<File> files = new ArrayList<File>();
    private File selectedFile;
    private FilePosition selectedPosition;
    private Consumer<Boolean> fileModifiedListener;
    private Consumer<IntinoDslEditorFileContent> saveFileListener;
    private Consumer<Boolean> checkListener;
    private Consumer<Boolean> commitListener;
    private Function<String, File> selectedFileListener;
    private boolean reloadRequired;

    public IntinoDslEditor(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String value) {
        this.release = value;
    }

    public void tab(LanguageTab value) {
        this.tab = value;
    }

    public void view(ModelView value) {
        this.view = value;
    }

    public boolean initialized() {
        if (this.selectedFile == null) {
            return false;
        }
        return this.model != null && this.release != null && this.files.stream().anyMatch(f -> f.uri().equals(this.selectedFile.uri()));
    }

    public boolean sameReleaseAndFile(String newRelease, String newUri) {
        return this.release != null && this.release.equals(newRelease) && this.selectedFile != null && this.selectedFile.uri().equals(newUri);
    }

    public void files(List<File> files) {
        this.files = files;
    }

    public void file(File file, FilePosition position) {
        this.reloadRequired = this.selectedFile == null || !this.selectedFile.uri().equals(file.uri());
        this.selectedFile = file;
        this.selectedPosition = position;
    }

    public void onFileModified(Consumer<Boolean> listener) {
        this.fileModifiedListener = listener;
    }

    public void onSaveFile(Consumer<IntinoDslEditorFileContent> listener) {
        this.saveFileListener = listener;
    }

    public void onCommit(Consumer<Boolean> listener) {
        this.commitListener = listener;
    }

    public void onCheck(Consumer<Boolean> listener) {
        this.checkListener = listener;
    }

    public void onSelectFile(Function<String, File> listener) {
        this.selectedFileListener = listener;
    }

    public void fireSavingProcess() {
        ((IntinoDslEditorNotifier)this.notifier).receiveContent();
    }

    public void fileModified() {
        if (this.fileModifiedListener == null) {
            return;
        }
        this.fileModifiedListener.accept(true);
    }

    public void fileContent(IntinoDslEditorFileContent content) {
        if (this.saveFileListener == null || !PermissionsHelper.canEdit(this.model, this.release, this.session(), (EditorBox)this.box())) {
            return;
        }
        this.saveFileListener.accept(content);
    }

    public void executeCommand(String name) {
        if (name.equalsIgnoreCase("check")) {
            this.checkListener.accept(true);
        }
        if (name.equalsIgnoreCase("commit")) {
            this.commitListener.accept(true);
        }
    }

    public void fileSelected(String uri) {
        this.selectedFile = this.selectedFileListener.apply(uri);
    }

    public void openFile(File file, FilePosition position) {
        this.selectedFile = file;
        this.selectedPosition = position;
        ((IntinoDslEditorNotifier)this.notifier).refreshReadonly(!PermissionsHelper.canEdit(this.model, this.release, this.session(), (EditorBox)this.box()));
        ((IntinoDslEditorNotifier)this.notifier).refreshFile(this.fileOf(file).position(this.positionOf(position)));
    }

    public void refresh() {
        super.refresh();
        if (this.model == null) {
            return;
        }
        this.reload();
    }

    private void reload() {
        ((IntinoDslEditorNotifier)this.notifier).setup(this.info());
    }

    private IntinoDslEditorSetup info() {
        IntinoDslEditorSetup result = new IntinoDslEditorSetup();
        result.dslName(this.model.language().artifactId());
        result.modelName(this.model.id());
        result.modelRelease(this.release);
        result.readonly(!PermissionsHelper.canEdit(this.model, this.release, this.session(), (EditorBox)this.box()));
        result.fileAddress(PathHelper.modelPath(this.model, this.release, this.tab, this.view, ":file"));
        result.files(this.files.stream().map(this::fileOf).toList());
        return result;
    }

    private IntinoDslEditorFile fileOf(File file) {
        boolean active = this.selectedFile != null && this.selectedFile.uri().equals(file.uri());
        return new IntinoDslEditorFile().active(active).name(file.name()).uri(file.uri()).extension(file.extension()).content(this.content(file)).language(file.language()).position(this.positionOf(this.selectedPosition));
    }

    private IntinoDslEditorFilePosition positionOf(FilePosition position) {
        if (position == null) {
            return null;
        }
        return new IntinoDslEditorFilePosition().line(position.line()).column(position.column());
    }

    private String content(File file) {
        try {
            InputStream content = ((EditorBox)this.box()).modelManager().content(this.model, this.release, file.uri());
            return content != null ? IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8) : "";
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }
}

