/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.actions.QuassarAction;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;

public class CreateLanguageAction
extends QuassarAction {
    public String collection;
    public String metamodel;
    public String name;
    public String owner;

    public String execute() {
        Logger.info((String)"Creating language %s".formatted(this.name));
        Collection collection = this.box.collectionManager().get(this.collection);
        Model metamodel = this.box.modelManager().get(this.metamodel);
        this.box.modelManager().removeLanguageServer(metamodel);
        this.box.commands(ModelCommands.class).createRelease(metamodel, "1.0.0", this.owner);
        Language result = this.box.commands(LanguageCommands.class).create(collection, this.name, metamodel, Language.Level.L1, true, null, this.owner);
        this.box.commands(LanguageCommands.class).createRelease(result, "1.0.0", this.owner);
        Logger.info((String)"Language %s created".formatted(this.name));
        return GavCoordinates.from(result, result.lastRelease()).toString();
    }
}

