/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractProjectModuleViewer;
import io.quassar.editor.box.ui.displays.templates.ProjectModuleEntryViewer;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Model;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class ProjectModuleViewer
extends AbstractProjectModuleViewer<EditorBox> {
    private Model model;
    private String project;
    private String module;
    private boolean showTitle = true;
    private Consumer<String> backListener;
    private Consumer<Model> selectListener;

    public ProjectModuleViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void project(String project) {
        this.project = project;
    }

    public void module(String module) {
        this.module = module;
    }

    public void showTitle(boolean value) {
        this.showTitle = value;
    }

    public void onBack(Consumer<String> listener) {
        this.backListener = listener;
    }

    public void onSelect(Consumer<Model> listener) {
        this.selectListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.back.onExecute(e -> this.backListener.accept(this.module));
    }

    public void refresh() {
        super.refresh();
        this.refreshTitle();
        this.refreshModels();
    }

    private void refreshTitle() {
        this.titleBlock.visible(this.showTitle);
        if (!this.titleBlock.isVisible()) {
            return;
        }
        this.moduleName.value(this.module);
        this.back.visible(this.backListener != null);
    }

    private void refreshModels() {
        this.entriesBlock.formats(this.showTitle ? Set.of("tripleAirLeft") : Set.of());
        List<GavCoordinates> languages = ((EditorBox)this.box()).modelManager().languages(this.model.project(), this.username()).stream().sorted(Comparator.comparing(GavCoordinates::artifactId)).toList();
        List<Model> models = ((EditorBox)this.box()).modelManager().models(this.model.project(), this.module, this.username());
        this.entries.clear();
        languages.forEach(l -> this.fill((GavCoordinates)l, this.modelWith((GavCoordinates)l, models), (ProjectModuleEntryViewer)this.entries.add()));
    }

    private Model modelWith(GavCoordinates language, List<Model> models) {
        return models.stream().filter(m -> m.language().equals(language)).findFirst().orElse(null);
    }

    private void fill(GavCoordinates language, Model model, ProjectModuleEntryViewer display) {
        display.model(model);
        display.project(this.project);
        display.module(this.module);
        display.language(language);
        display.selected(model != null && model.id().equals(this.model.id()));
        display.onSelect((Boolean e) -> this.selectListener.accept(model));
        display.refresh();
    }
}

