/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractModelNameDialog;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.model.Model;
import java.util.List;
import java.util.function.Consumer;

public class ModelNameDialog
extends AbstractModelNameDialog<EditorBox> {
    private Model model;
    private Consumer<String> saveListener;
    private AddType selectedAddType;
    private String selectedProject;
    private String selectedModule;

    public ModelNameDialog(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void onSave(Consumer<String> listener) {
        this.saveListener = listener;
    }

    public void open() {
        this.dialog.open();
    }

    @Override
    public void init() {
        super.init();
        this.dialog.onOpen(e -> this.refreshDialog());
        this.addDialog.onOpen(e -> this.refreshAddDialog());
        this.simpleNameBlock.onInit(e -> this.initSimpleNameBlock());
        this.simpleNameBlock.onShow(e -> this.refreshSimpleNameBlock());
        this.qualifiedNameBlock.onInit(e -> this.initQualifiedNameBlock());
        this.qualifiedNameBlock.onShow(e -> this.refreshQualifiedNameBlock());
        this.save.onExecute(e -> this.saveName());
        this.addField.onEnterPress(e -> this.add());
        this.add.onExecute(e -> this.add());
    }

    private void refreshDialog() {
        this.typeSelector.visible(!this.model.isExample() && ModelHelper.isM1(this.model));
        if (!this.typeSelector.isVisible()) {
            this.simpleNameBlock.show();
            return;
        }
        this.typeSelector.select(this.model.isQualifiedName() ? "qualifiedOption" : "simpleOption");
    }

    private void initSimpleNameBlock() {
        this.nameField.onEnterPress(e -> this.saveName());
    }

    private void refreshSimpleNameBlock() {
        this.nameField.value(this.model.name());
        this.nameField.focus();
    }

    private void initQualifiedNameBlock() {
        this.projectSelector.onSelect(e -> this.updateProject());
        this.moduleSelector.onSelect(e -> this.updateModule());
        this.addProjectLink.onExecute(e -> {
            this.selectedAddType = AddType.Project;
            this.addDialog.open();
        });
        this.addModuleLink.onExecute(e -> {
            this.selectedAddType = AddType.Module;
            this.addDialog.open();
        });
    }

    private void refreshQualifiedNameBlock() {
        this.qualifiedNameField.value(this.qualifiedName());
        this.refreshProjects();
        this.updateProject();
    }

    private void refreshProjects() {
        this.projectSelector.clear();
        this.projectSelector.addAll(this.projects());
        if (this.selectedProject != null) {
            this.projectSelector.select(new String[]{this.selectedProject});
        } else if (!this.model.project().isEmpty()) {
            this.projectSelector.select(new String[]{this.model.project()});
        }
    }

    private void updateProject() {
        this.selectedProject = this.selectedProject();
        this.refreshModules();
    }

    private void refreshModules() {
        if (this.selectedProject == null) {
            return;
        }
        this.moduleSelector.clear();
        this.moduleSelector.addAll(this.modules());
        if (this.selectedModule != null) {
            this.moduleSelector.select(new String[]{this.selectedModule});
        } else if (!this.model.module().isEmpty()) {
            this.moduleSelector.select(new String[]{this.model.module()});
        }
    }

    private void updateModule() {
        this.selectedModule = this.selectedModule();
    }

    private List<String> projects() {
        return ((EditorBox)this.box()).modelManager().projects(this.username());
    }

    private List<String> modules() {
        return ((EditorBox)this.box()).modelManager().modules(this.selectedProject(), this.username());
    }

    private String selectedProject() {
        List selection = this.projectSelector.selection();
        return !selection.isEmpty() ? (String)selection.getFirst() : null;
    }

    private String selectedModule() {
        List selection = this.moduleSelector.selection();
        return !selection.isEmpty() ? (String)selection.getFirst() : null;
    }

    private void saveName() {
        if (this.simpleNameBlock.isVisible()) {
            this.saveSimpleName();
        } else {
            this.saveQualifiedName();
        }
    }

    private void saveSimpleName() {
        if (!DisplayHelper.check(this.nameField, arg_0 -> ((ModelNameDialog)this).translate(arg_0))) {
            return;
        }
        String value = this.nameField.value();
        ((EditorBox)this.box()).commands(ModelCommands.class).saveSimpleName(this.model, value, this.username());
        this.dialog.close();
        this.saveListener.accept(value);
    }

    private void saveQualifiedName() {
        String module;
        String project = this.selectedProject != null ? this.selectedProject : this.model.project();
        String string = module = this.selectedModule != null ? this.selectedModule : this.model.module();
        if (project.isEmpty()) {
            this.notifyUser(this.translate("Project is required"), UserMessage.Type.Warning);
            return;
        }
        if (module.isEmpty()) {
            this.notifyUser(this.translate("Module is required"), UserMessage.Type.Warning);
            return;
        }
        ((EditorBox)this.box()).commands(ModelCommands.class).saveQualifiedName(this.model, project, module, this.username());
        this.dialog.close();
        this.saveListener.accept(Model.qualifiedNameFor(project, module));
    }

    private void refreshAddDialog() {
        this.addDialog.title(this.translate("Add %s".formatted(this.selectedAddType.name().toLowerCase())));
        this.addField.value(null);
        this.addField.focus();
    }

    private void add() {
        if (this.selectedAddType == null) {
            return;
        }
        if (!DisplayHelper.check(this.addField, arg_0 -> ((ModelNameDialog)this).translate(arg_0))) {
            return;
        }
        if (this.selectedAddType == AddType.Project) {
            this.selectedProject = this.addField.value();
        } else {
            this.selectedModule = this.addField.value();
        }
        this.addDialog.close();
        this.refreshQualifiedNameBlock();
    }

    private String qualifiedName() {
        String project = this.selectedProject != null ? this.selectedProject : this.model.project();
        String module = this.selectedModule != null ? this.selectedModule : this.model.module();
        return Model.qualifiedNameFor(project, module);
    }

    private static enum AddType {
        Project,
        Module;

    }
}

