/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.push.User;
import io.intino.alexandria.ui.utils.UrlUtil;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.AbstractGoogleLoginDisplay;
import io.quassar.editor.box.ui.displays.notifiers.GoogleLoginDisplayNotifier;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.function.Consumer;

public class GoogleLoginDisplay
extends AbstractGoogleLoginDisplay<EditorBox> {
    private Consumer<User> successListener;
    private Consumer<String> failureListener;

    public GoogleLoginDisplay(EditorBox box) {
        super(box);
    }

    public void onSuccess(Consumer<User> listener) {
        this.successListener = listener;
    }

    public void onFailure(Consumer<String> listener) {
        this.failureListener = listener;
    }

    public void logout() {
        ((GoogleLoginDisplayNotifier)this.notifier).logout();
    }

    @Override
    public void init() {
        super.init();
        this.session().whenLogout(e -> ((GoogleLoginDisplayNotifier)this.notifier).logout());
    }

    public void refresh() {
        super.refresh();
        ((GoogleLoginDisplayNotifier)this.notifier).refresh(((EditorBox)this.box()).configuration().googleClientId());
    }

    public void success(String credential) {
        User user = this.verify(credential);
        if (user == null) {
            this.failure();
            return;
        }
        this.successListener.accept(user);
    }

    public void check(String credential) {
        User user = this.verify(credential);
        if (user == null) {
            return;
        }
        this.successListener.accept(user);
    }

    public void failure() {
        this.failureListener.accept("Could not log in with google");
    }

    private User verify(String credential) {
        try {
            GoogleIdTokenVerifier verifier = new GoogleIdTokenVerifier.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance()).setAudience(Collections.singletonList(((EditorBox)this.box()).configuration().googleClientId())).build();
            GoogleIdToken idToken = verifier.verify(credential);
            if (idToken == null) {
                return null;
            }
            GoogleIdToken.Payload payload = idToken.getPayload();
            String email = payload.getEmail();
            String name = (String)payload.get((Object)"name");
            String pictureUrl = (String)payload.get((Object)"picture");
            return new User().username(email).fullName(name).email(email).photo(UrlUtil.toURL((String)pictureUrl));
        }
        catch (IOException | GeneralSecurityException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

