/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.collection;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.model.License;

public class AssignLicenseCommand
extends Command<AssignResult> {
    public String license;

    public AssignLicenseCommand(EditorBox box) {
        super(box);
    }

    @Override
    public AssignResult execute() {
        License license = this.box.collectionManager().getLicense(this.license);
        if (license == null) {
            return new AssignResult(false, "The license code doesn't exist. Make sure you entered it correctly.", null);
        }
        if (license.status() == License.Status.Assigned) {
            return new AssignResult(false, "This license code has already been used", null);
        }
        License currentLicense = license.collection().validLicense(this.author);
        if (currentLicense != null) {
            return new AssignResult(false, "You already have an active license for collection %s", currentLicense);
        }
        this.box.collectionManager().assign(license, this.author);
        return new AssignResult(true, null, license);
    }

    public record AssignResult(boolean success, String message, License license) {
    }
}

