/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.jmx;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.actions.AddLicenseAction;
import io.quassar.editor.box.actions.CreateLanguageAction;
import io.quassar.editor.box.actions.CreateMetamodelFromTemplateAction;
import io.quassar.editor.box.actions.CreateModelAction;
import io.quassar.editor.box.actions.RebuildLanguagesAction;
import io.quassar.editor.box.jmx.MaintenanceApiMBean;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class MaintenanceApi
extends StandardMBean
implements MaintenanceApiMBean {
    private final EditorBox box;

    public MaintenanceApi(EditorBox box) throws NotCompliantMBeanException {
        super(MaintenanceApiMBean.class);
        this.box = box;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getClass().getName(), "maintenanceApi", null, null, new MBeanOperationInfo[]{this.rebuildLanguagesInfo(), this.createMetamodelFromTemplateInfo(), this.createLanguageInfo(), this.createModelInfo(), this.addLicenseInfo()}, null);
    }

    public MBeanOperationInfo rebuildLanguagesInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        return new MBeanOperationInfo("rebuildLanguages", "Rebuild language releases", params, "", 1);
    }

    public MBeanOperationInfo createMetamodelFromTemplateInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("template", "java.lang.String", ""), new MBeanParameterInfo("owner", "java.lang.String", "")};
        return new MBeanOperationInfo("createMetamodelFromTemplate", "Create metamodel from template for user", params, "", 1);
    }

    public MBeanOperationInfo createLanguageInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("collection", "java.lang.String", ""), new MBeanParameterInfo("metamodel", "java.lang.String", ""), new MBeanParameterInfo("name", "java.lang.String", ""), new MBeanParameterInfo("owner", "java.lang.String", "")};
        return new MBeanOperationInfo("createLanguage", "Create language", params, "", 1);
    }

    public MBeanOperationInfo createModelInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("language", "java.lang.String", ""), new MBeanParameterInfo("name", "java.lang.String", ""), new MBeanParameterInfo("owner", "java.lang.String", "")};
        return new MBeanOperationInfo("createModel", "Create model", params, "", 1);
    }

    public MBeanOperationInfo addLicenseInfo() {
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("collection", "java.lang.String", ""), new MBeanParameterInfo("duration", "java.lang.Integer", ""), new MBeanParameterInfo("username", "java.lang.String", "")};
        return new MBeanOperationInfo("addLicense", "Add license", params, "", 1);
    }

    @Override
    public String rebuildLanguages() {
        try {
            RebuildLanguagesAction action = new RebuildLanguagesAction();
            action.box = this.box;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String createMetamodelFromTemplate(String template, String owner) {
        try {
            CreateMetamodelFromTemplateAction action = new CreateMetamodelFromTemplateAction();
            action.box = this.box;
            action.template = template;
            action.owner = owner;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String createLanguage(String collection, String metamodel, String name, String owner) {
        try {
            CreateLanguageAction action = new CreateLanguageAction();
            action.box = this.box;
            action.collection = collection;
            action.metamodel = metamodel;
            action.name = name;
            action.owner = owner;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String createModel(String language, String name, String owner) {
        try {
            CreateModelAction action = new CreateModelAction();
            action.box = this.box;
            action.language = language;
            action.name = name;
            action.owner = owner;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public Boolean addLicense(String collection, Integer duration, String username) {
        try {
            AddLicenseAction action = new AddLicenseAction();
            action.box = this.box;
            action.collection = collection;
            action.duration = duration;
            action.username = username;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }
}

