/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    public static void zip(Path folder, String manifest, Path destiny) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destiny.toFile()));
        ZipHelper.appendFolder(folder, zos);
        ZipHelper.append("manifest.json", manifest, zos);
        zos.close();
    }

    public static void zip(Path folder, Path destiny) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destiny.toFile()));
        ZipHelper.appendFolder(folder, zos);
        zos.close();
    }

    private static void appendFolder(final Path folder, final ZipOutputStream stream) throws Exception {
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                ZipHelper.append(file, folder.relativize(file), stream);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void append(Path file, Path relativePath, ZipOutputStream stream) {
        try {
            stream.putNextEntry(new ZipEntry(relativePath.toString()));
            Files.copy(file, stream);
            stream.closeEntry();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private static void append(String name, String content, ZipOutputStream stream) {
        try {
            stream.putNextEntry(new ZipEntry(name));
            stream.write(content.getBytes(StandardCharsets.UTF_8));
            stream.closeEntry();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public static void extract(File zipFile, File destiny) {
        try {
            ZipHelper.extract(new FileInputStream(zipFile), destiny);
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
        }
    }

    public static void extract(InputStream zipStream, File destiny) {
        if (!destiny.exists()) {
            destiny.mkdirs();
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(zipStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                File destFile = new File(destiny, entry.getName());
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                } else {
                    File parentDir = destFile.getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    try (FileOutputStream fos = new FileOutputStream(destFile);){
                        int bytesRead;
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                            fos.write(buffer, 0, bytesRead);
                        }
                    }
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

