/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.selector.SelectorOption;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractReleaseSelectorOption;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;

public class ReleaseSelectorOption
extends AbstractReleaseSelectorOption<EditorBox>
implements SelectorOption {
    private Language language;
    private String release;
    private Model metamodel;
    private Consumer<String> selectListener;
    private Consumer<String> removeListener;
    private boolean selected = false;

    public ReleaseSelectorOption(EditorBox box) {
        super(box);
        this.id(UUID.randomUUID().toString());
    }

    public ReleaseSelectorOption language(Language language) {
        this.language = language;
        return this;
    }

    public String release() {
        return this.release;
    }

    public ReleaseSelectorOption release(String release) {
        this.name(release);
        this.release = release;
        return this;
    }

    public ReleaseSelectorOption metamodel(Model metamodel) {
        this.metamodel = metamodel;
        return this;
    }

    public void selected(boolean value) {
        this.selected = value;
    }

    public ReleaseSelectorOption onSelect(Consumer<String> listener) {
        this.selectListener = listener;
        return this;
    }

    public ReleaseSelectorOption onRemove(Consumer<String> listener) {
        this.removeListener = listener;
        return this;
    }

    public void update() {
        super.update();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.version.onExecute(e -> {
            this.selectListener.accept(this.release);
            this.refreshFormats();
        });
        this.remove.onExecute(e -> this.removeListener.accept(this.release));
        this.remove.signChecker((sign, reason) -> this.release.equals(sign));
    }

    public void refresh() {
        super.refresh();
        this.refreshFormats();
        this.version.title(this.release);
        this.version.address(path -> PathHelper.forgePath(path, this.metamodel.id(), this.release));
        this.remove.visible(this.language.release(this.release) != null);
    }

    private void refreshFormats() {
        this.contentBlock.formats(Set.of("relative", "versionSelector", this.selected ? "versionSelected" : ""));
        this.version.formats(Set.of("versionSelectorLink", this.selected ? "versionSelectorLinkSelected" : ""));
    }
}

