/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.ModelContainer;
import io.quassar.editor.box.ui.displays.IntinoDslEditor;
import io.quassar.editor.box.ui.displays.templates.AbstractModelViewer;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.model.Model;
import java.util.Collections;
import java.util.List;

public class ModelViewer
extends AbstractModelViewer<EditorBox> {
    private Model model;
    private String release;
    private ModelContainer modelContainer;
    private File selectedFile;

    public ModelViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model, String release) {
        this.model = model;
        this.release = release;
        this.modelContainer = this.model != null ? ((EditorBox)this.box()).modelManager().modelContainer(this.model, this.release) : null;
        this.selectedFile = null;
    }

    public void file(File file) {
        this.selectedFile = file;
    }

    public void didMount() {
        super.didMount();
        if (this.model == null) {
            return;
        }
        this.createFileEditor();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.fileSelector.onSelect(this::openModelFile);
        this.initFileEditor();
    }

    public void reset() {
        this.createFileEditor();
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        this.languageNotLoadedBlock.visible(this.modelContainer == null);
        this.refreshContent();
    }

    private void refreshContent() {
        this.contentBlock.visible(this.model != null && this.modelContainer != null);
        if (!this.contentBlock.isVisible()) {
            return;
        }
        List<File> files = this.modelContainer.modelFiles();
        this.noFilesMessage.visible(files.isEmpty());
        this.refreshFileSelector(files);
        this.refreshFile(files);
    }

    private void initFileEditor() {
        this.createFileEditor();
    }

    private void refreshFileSelector(List<File> files) {
        this.fileSelector.visible(!files.isEmpty());
        if (!this.fileSelector.isVisible()) {
            return;
        }
        this.fileSelector.clear();
        this.fileSelector.addAll(files.stream().map(File::uri).toList());
        if (this.selectedFile() != null) {
            this.fileSelector.selection(new String[]{this.selectedFile().uri()});
        }
    }

    private IntinoDslEditor createFileEditor() {
        IntinoDslEditor editor = new IntinoDslEditor((EditorBox)this.box());
        this.intinoDslEditor.clear();
        this.intinoDslEditor.display(editor);
        editor.files(this.editorFiles());
        editor.onFileModified(e -> {});
        editor.onSelectFile(e -> this.selectedFile());
        editor.onSaveFile(e -> {});
        editor.onCommit(e -> {});
        editor.onCheck(e -> {});
        return editor;
    }

    private List<File> editorFiles() {
        if (this.modelContainer == null) {
            return Collections.emptyList();
        }
        return this.modelContainer.modelFiles();
    }

    private void refreshFile(List<File> files) {
        IntinoDslEditor display = (IntinoDslEditor)this.intinoDslEditor.display();
        if (display == null) {
            display = this.createFileEditor();
        }
        display.model(this.model);
        display.release(this.release);
        display.view(ModelView.Model);
        if (!display.initialized()) {
            display.files(this.editorFiles());
            display.file(this.selectedFile(), null);
            display.refresh();
        } else {
            display.openFile(this.selectedFile(), null);
        }
    }

    private File selectedFile() {
        if (this.selectedFile != null) {
            return this.selectedFile;
        }
        return ModelHelper.mainFile(this.modelContainer);
    }

    private void openModelFile(SelectionEvent e) {
        List selection = e.selection();
        if (selection.isEmpty()) {
            return;
        }
        String uri = (String)selection.getFirst();
        ModelContainer modelContainer = ((EditorBox)this.box()).modelManager().modelContainer(this.model, this.release);
        File selected = modelContainer.modelFiles().stream().filter(f -> f.uri().equalsIgnoreCase(uri)).findFirst().orElse(null);
        this.file(selected);
        this.refresh();
    }
}

