/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models;

import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.FileReader;
import io.quassar.editor.box.models.Workspace;
import io.quassar.editor.box.models.readers.ModelReader;
import io.quassar.editor.box.models.readers.ResourcesReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.services.LanguageServer;

public class WorkspaceReader {
    private final Workspace workspace;
    private final LanguageServer server;

    public WorkspaceReader(Workspace workspace, LanguageServer server) {
        this.workspace = workspace;
        this.server = server;
    }

    public List<File> files() {
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(this.modelFiles());
        result.addAll(this.resourceFiles());
        return result;
    }

    public List<File> modelFiles() {
        return new ModelReader(this.workspace, this.server).files();
    }

    public List<File> resourceFiles() {
        return new ResourcesReader(this.workspace).files();
    }

    public boolean existsFile(String filename, File parent) {
        return this.readerOf(parent != null ? parent.uri() : filename).exists(filename, parent);
    }

    public InputStream content(String uri) {
        return this.readerOf(uri).content(uri);
    }

    private FileReader readerOf(String uri) {
        return File.isResource(uri) ? new ResourcesReader(this.workspace) : new ModelReader(this.workspace, this.server);
    }
}

