/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.SubjectGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public class DirUtils {
    public static void copyDir(String dir, File destiny) {
        URL resourceUrl = DirUtils.class.getClassLoader().getResource(dir);
        if (resourceUrl == null) {
            return;
        }
        if (resourceUrl.getProtocol().equals("jar")) {
            DirUtils.copyDirFromJarFile(dir, resourceUrl, destiny);
        } else {
            DirUtils.copyDirFromResources(dir, resourceUrl, destiny);
        }
    }

    public static void copyDirFromJarFile(String dir, URL resourceUrl, File destiny) {
        String jarPath = resourceUrl.getPath().substring(5, resourceUrl.getPath().indexOf("!"));
        try (JarFile jarFile = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(dir)) continue;
                String relativePath = entry.getName().substring(dir.length()).replaceFirst("^/", "");
                Path entryDestination = destiny.toPath().resolve(relativePath);
                if (entry.isDirectory()) {
                    Files.createDirectories(entryDestination, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(entryDestination.getParent(), new FileAttribute[0]);
                InputStream in = jarFile.getInputStream(entry);
                try {
                    Files.copy(in, entryDestination, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public static void copyDirFromResources(String dir, URL resourceUrl, File destiny) {
        try {
            Path source = Paths.get(SubjectGenerator.class.getResource("/" + dir).toURI());
            try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
                paths.forEach(path -> {
                    try {
                        Path destinoPath = destiny.toPath().resolve(source.relativize((Path)path).toString());
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            Files.createDirectories(destinoPath, new FileAttribute[0]);
                        } else {
                            Files.createDirectories(destinoPath.getParent(), new FileAttribute[0]);
                            Files.copy(path, destinoPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        catch (IOException | URISyntaxException e) {
            Logger.error((Throwable)e);
        }
    }
}

