/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.collection;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.util.LicenseGenerator;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.UserHelper;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.License;
import io.quassar.editor.model.User;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;

public class AddLicensesCommand
extends Command<List<License>> {
    public Collection collection;
    public int count;
    public int duration;

    public AddLicensesCommand(EditorBox box) {
        super(box);
    }

    @Override
    public List<License> execute() {
        if (!this.hasCredit()) {
            return Collections.emptyList();
        }
        List<License> licenses = IntStream.range(0, this.count).mapToObj(i -> this.box.collectionManager().createLicense(this.collection, LicenseGenerator.generate(), this.duration)).toList();
        this.consumeCredit();
        return licenses;
    }

    private boolean hasCredit() {
        if (this.collection.subscriptionPlan() == Collection.SubscriptionPlan.Enterprise) {
            return PermissionsHelper.hasCredit(this.duration, this.collection, this.box);
        }
        return PermissionsHelper.hasCredit(this.count * this.duration, this.author, this.box);
    }

    private void consumeCredit() {
        if (this.collection.subscriptionPlan() == Collection.SubscriptionPlan.Enterprise) {
            return;
        }
        User user = UserHelper.user(this.author, this.box);
        int licenseTime = UserHelper.licenseTime(this.author, this.box);
        user.licenseTime(licenseTime - this.count * this.duration);
    }
}

