/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractProjectModuleLinkViewer;
import io.quassar.editor.model.Model;
import java.util.Set;
import java.util.function.Consumer;

public class ProjectModuleLinkViewer
extends AbstractProjectModuleLinkViewer<EditorBox> {
    private Model model;
    private String project;
    private String module;
    private Consumer<String> selectListener;
    private boolean selected = false;

    public ProjectModuleLinkViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void project(String project) {
        this.project = project;
    }

    public void module(String module) {
        this.module = module;
    }

    public void onSelect(Consumer<String> listener) {
        this.selectListener = listener;
    }

    public void selected(boolean value) {
        this.selected = value;
    }

    @Override
    public void init() {
        super.init();
        this.moduleLink.onExecute(e -> this.selectListener.accept(this.module));
    }

    public void refresh() {
        super.refresh();
        this.bubble.formats(Set.of("bubble", this.model != null ? "bubbleFilled" : "bubbleNotFilled"));
        this.refreshLink();
        this.refreshText();
    }

    private void refreshLink() {
        this.moduleLink.visible(!this.selected);
        if (!this.moduleLink.isVisible()) {
            return;
        }
        this.moduleLink.title(this.module);
    }

    private void refreshText() {
        this.moduleText.visible(this.selected);
        if (!this.moduleText.isVisible()) {
            return;
        }
        this.moduleText.value(this.module);
    }
}

