/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractModelNameViewer;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.model.Model;

public class ModelNameViewer
extends AbstractModelNameViewer<EditorBox> {
    private Model model;

    public ModelNameViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    @Override
    public void init() {
        super.init();
        this.simpleNameBlock.onInit(e -> this.initSimpleNameBlock());
        this.simpleNameBlock.onShow(e -> this.refreshSimpleNameBlock());
        this.qualifiedNameBlock.onInit(e -> this.initQualifiedNameBlock());
        this.qualifiedNameBlock.onShow(e -> this.refreshQualifiedNameBlock());
        this.projectBlock.onOpen(e -> this.refreshProjectBlock());
        this.moduleBlock.onOpen(e -> this.refreshModuleBlock());
    }

    public void refresh() {
        super.refresh();
        this.qualifiedNameBlock.hide();
        this.simpleNameBlock.hide();
        if (this.model.isQualifiedName()) {
            this.qualifiedNameBlock.show();
        } else {
            this.simpleNameBlock.show();
        }
    }

    private void initSimpleNameBlock() {
    }

    private void refreshSimpleNameBlock() {
        this.nameField.value(ModelHelper.label(this.model, this.language(), (EditorBox)this.box()));
    }

    private void initQualifiedNameBlock() {
    }

    private void refreshQualifiedNameBlock() {
        this.project.title(this.model.project());
        this.module.title(this.model.module());
    }

    private void refreshProjectBlock() {
        this.projectBlock.projectBlockHeader.projectBlockTitle.value(this.translate("Modules in %s").formatted(this.model.project()));
        this.projectBlock.projectBlockContent.projectViewer.model(this.model);
        this.projectBlock.projectBlockContent.projectViewer.onSelect(e -> {
            this.projectBlock.close();
            this.module.launch();
        });
        this.projectBlock.projectBlockContent.projectViewer.project(this.model.project());
        this.projectBlock.projectBlockContent.projectViewer.refresh();
    }

    private void refreshModuleBlock() {
        this.moduleBlock.moduleBlockHeader.moduleBlockTitle.value(this.translate("Models in %s: %s").formatted(this.model.project(), this.model.module()));
        this.moduleBlock.moduleBlockContent.moduleViewer.onSelect(e -> this.moduleBlock.close());
        this.moduleBlock.moduleBlockContent.moduleViewer.model(this.model);
        this.moduleBlock.moduleBlockContent.moduleViewer.project(this.model.project());
        this.moduleBlock.moduleBlockContent.moduleViewer.module(this.model.module());
        this.moduleBlock.moduleBlockContent.moduleViewer.showTitle(false);
        this.moduleBlock.moduleBlockContent.moduleViewer.refresh();
    }
}

