/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageExecutionLauncher;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageExecution;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.ModelRelease;

public class LanguageExecutionLauncher
extends AbstractLanguageExecutionLauncher<EditorBox> {
    private Model model;
    private String release;

    public LanguageExecutionLauncher(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String release) {
        this.release = release;
    }

    public void launch() {
        LanguageExecution execution = this.execution();
        if (execution == null) {
            this.notifyUser("No execution environment defined in language %s".formatted(this.model.language().artifactId()), UserMessage.Type.Info);
            return;
        }
        switch (execution.type()) {
            case None: {
                this.notifyUser("No execution environment defined in language %s".formatted(this.model.language().artifactId()), UserMessage.Type.Info);
                break;
            }
            case Local: {
                if (execution.content().isEmpty()) {
                    this.notifyUser("No execution environment defined in language %s".formatted(this.model.language().artifactId()), UserMessage.Type.Info);
                    break;
                }
                this.localDialog.open();
                break;
            }
            case Remote: {
                if (execution.content().isEmpty()) {
                    this.notifyUser("No remote environment defined in language %s".formatted(this.model.language().artifactId()), UserMessage.Type.Info);
                    break;
                }
                this.launchForge();
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.localDialog.onOpen(e -> this.refreshLocalDialog());
    }

    private void launchForge() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model.language());
        if (language.name().equals("metta")) {
            this.openSite(PathHelper.forgeUrl(this.model, this.release, this.session()));
        } else {
            this.openSite(this.execution().content());
        }
    }

    private void openSite(String site) {
        ((TemplateNotifier)this.notifier).redirect(this.withParams(site));
    }

    private void refreshLocalDialog() {
        String content = this.withParams(this.execution().content());
        this.execution.value(content);
        this.copy.text(content);
        this.openInstallationNotes.visible(!this.execution().installationUrl().isEmpty());
        this.openInstallationNotes.site(this.execution().installationUrl());
    }

    private LanguageExecution execution() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model.language());
        return language.release(this.model.language().version()).execution();
    }

    private String withParams(String content) {
        ModelRelease modelRelease = this.model.release(this.release);
        return content.replace("[commit]", modelRelease.commit()).replace("[commit-url]", PathHelper.commitUrl(modelRelease, this.session()));
    }
}

