/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.models.ModelContainer;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class File {
    private final String name;
    private final String uri;
    private final boolean isDirectory;
    private final List<String> parents;
    private static Map<String, String> LanguagesMap = null;
    public static final String ResourcesDirectory = "resources";
    private static final String DefaultLanguage = "tara";
    private static final String DefaultExtension = "tara";

    public File(String name, String uri, boolean isDirectory, List<String> parents) {
        this.name = name;
        this.uri = uri;
        this.isDirectory = isDirectory;
        this.parents = parents;
        this.loadLanguages();
    }

    public String name() {
        return this.name;
    }

    public String extension() {
        return this.extensionOf(this.name);
    }

    public Type type() {
        return File.isResource(this.uri) ? Type.Resource : Type.Model;
    }

    public boolean isResource() {
        return File.isResource(this.uri);
    }

    public static boolean isResource(String file) {
        return file.startsWith(ResourcesDirectory);
    }

    public static String withResourcesPath(String name) {
        return ResourcesDirectory + (name.startsWith(java.io.File.separator) ? "" : java.io.File.separator) + name;
    }

    public List<String> parents() {
        return this.parents;
    }

    public String uri() {
        return this.uri;
    }

    public String language() {
        return LanguagesMap.getOrDefault(this.extensionOf(this.name), "tara");
    }

    private String extensionOf(String name) {
        if (!name.contains(".")) {
            return "tara";
        }
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public File clone(String newUri) {
        return new File(this.name, newUri, this.isDirectory, this.parents());
    }

    private void loadLanguages() {
        try {
            if (LanguagesMap != null) {
                return;
            }
            InputStream stream = ModelContainer.class.getResourceAsStream("/programming-languages.tsv");
            if (stream == null) {
                return;
            }
            LanguagesMap = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.toMap(l -> l.split("\t")[0], l -> l.split("\t")[1]));
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }

    public static enum Type {
        Model,
        Resource;

    }
}

