/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.model;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.ZipHelper;
import io.quassar.editor.model.Model;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import java.util.stream.Stream;

public class AddModelZipCommand
extends Command<Boolean> {
    public Model model;
    public ModelView view;
    public InputStream content;
    public File parent;

    public AddModelZipCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Boolean execute() {
        java.io.File directory = this.extract();
        String extension = this.languageFileExtension();
        try (Stream<Path> paths = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            paths.filter(p -> p.toFile().isFile() && this.matches(p.toFile().getName(), extension)).forEach(p -> this.add((Path)p, directory));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return false;
        }
        return true;
    }

    private void add(Path path, java.io.File root) {
        try {
            java.io.File file = path.toFile();
            ByteArrayInputStream content = new ByteArrayInputStream(Files.readAllBytes(path));
            String filename = this.nameFor(file.getAbsolutePath().replace(root.getAbsolutePath() + java.io.File.separator, ""));
            if (this.box.modelManager().existsFile(this.model, filename, this.parent)) {
                return;
            }
            this.box.modelManager().createFile(this.model, filename, content, this.parent);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String nameFor(String name) {
        String result = ModelHelper.validWorkspaceFileName(name);
        return this.view == ModelView.Resources ? (this.parent != null ? result : File.withResourcesPath(result)) : result;
    }

    private java.io.File extract() {
        java.io.File destiny = this.box.archetype().tmp().upload(UUID.randomUUID().toString());
        ZipHelper.extract(this.content, destiny);
        return destiny;
    }

    private boolean matches(String name, String extension) {
        if (this.view == ModelView.Resources) {
            return true;
        }
        return name.endsWith("." + extension);
    }

    private String languageFileExtension() {
        return ".tara".replace("\\.", "");
    }
}

