/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.server.UIFile;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractDownloadModelDialog;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.ModelRelease;
import java.io.File;

public class DownloadModelDialog
extends AbstractDownloadModelDialog<EditorBox> {
    private String title;
    private Model model;
    private String release;

    public DownloadModelDialog(EditorBox box) {
        super(box);
    }

    public void title(String title) {
        this.title = title;
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String release) {
        this.release = release;
    }

    public void open() {
        this.dialog.open();
    }

    @Override
    public void init() {
        super.init();
        this.download.onExecute(e -> this.download());
        this.downloadSilently.onExecute(e -> this.download());
        this.dialog.onOpen(e -> this.refreshDialog());
    }

    private void refreshDialog() {
        this.dialog.title(this.title != null ? this.title : this.translate("Download %s %s").formatted(ModelHelper.label(this.model, this.language(), (EditorBox)this.box()), this.release));
        ModelRelease modelRelease = this.model.release(this.release);
        this.modelUrl.value(PathHelper.commitUrl(modelRelease, this.session()));
        this.copyReleaseUrl.text(PathHelper.commitUrl(modelRelease, this.session()));
        this.copyReleaseCommit.text(modelRelease.commit());
    }

    private UIFile download() {
        File release = ((EditorBox)this.box()).modelManager().release(this.model, this.release);
        return DisplayHelper.uiFile(ModelHelper.label(this.model, this.language(), (EditorBox)this.box()) + "-" + release.getName(), release);
    }
}

