/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.model;

import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.schemas.Message;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.builder.BuildResult;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.model.CheckModelCommand;
import io.quassar.editor.box.ui.displays.templates.ModelTemplate;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.WorkspaceHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.OperationResult;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class CreateModelReleaseCommand
extends Command<Command.CommandResult> {
    public Model model;
    public String version;

    public CreateModelReleaseCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Command.CommandResult execute() {
        Command.CommandResult result = this.check();
        if (!result.success()) {
            return result;
        }
        if (this.box.modelManager().release(this.model, this.version).exists()) {
            return this.resultOf(this.replaceRelease());
        }
        return this.resultOf(this.box.modelManager().createRelease(this.model, this.version));
    }

    private OperationResult replaceRelease() {
        this.cleanReleases();
        OperationResult result = this.box.modelManager().replaceRelease(this.model, this.version);
        Language language = this.box.languageManager().getWithMetamodel(this.model);
        if (language == null) {
            return result;
        }
        LanguageRelease release = language.release(this.version);
        if (release == null) {
            return result;
        }
        BuildResult rebuildResult = LanguageHelper.rebuild(this.model, language, release, this.author, this.box);
        return !rebuildResult.success() ? OperationResult.Error(rebuildResult.messages().stream().map(Message::content).collect(Collectors.joining("; "))) : result;
    }

    private void cleanReleases() {
        this.removeTemporalWorkspace();
        this.reloadServers();
    }

    private void reloadServers() {
        Language language = this.box.languageManager().getWithMetamodel(this.model);
        List<Model> models = this.box.modelManager().modelsWithRelease(language, this.version);
        models.forEach(this::reloadServer);
    }

    private void reloadServer(Model model) {
        this.box.modelManager().removeLanguageServer(model);
        this.box.souls().stream().map(s -> s.displays(ModelTemplate.class).stream().toList()).flatMap(Collection::stream).filter(Objects::nonNull).forEach(t -> t.languageChanged(model.language()));
    }

    private void removeTemporalWorkspace() {
        try {
            if ("draft".equals(this.version)) {
                return;
            }
            File file = WorkspaceHelper.releaseWorkSpace(this.model, this.version, this.box.archetype());
            if (file == null || !file.exists()) {
                return;
            }
            FileUtils.deleteDirectory((File)file);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private Command.CommandResult check() {
        CheckModelCommand command = new CheckModelCommand(this.box);
        command.author = this.author;
        command.model = this.model;
        command.release = "draft";
        return command.execute();
    }
}

