/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaHttpServerBuilder;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.AlexandriaUiServer;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.UiElementsService;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.TranslatorService;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryLoader;
import io.intino.alexandria.ui.services.push.PushService;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.EditorConfiguration;
import io.quassar.editor.box.I18n;
import io.quassar.editor.box.QuassarApiService;
import io.quassar.editor.box.QuassarArtifactoryApiService;
import io.quassar.editor.box.Sentinels;
import io.quassar.editor.box.ui.EditorElementsService;
import io.quassar.editor.box.ui.displays.RouteDispatcher;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends AlexandriaUiBox {
    protected EditorConfiguration configuration;
    private AlexandriaScheduler scheduler = new AlexandriaScheduler();
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    protected List<AlexandriaLibraryLoader> libraryLoaders = new ArrayList<AlexandriaLibraryLoader>();
    private List<AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new ArrayList<AlexandriaUiBox.SoulsClosed>();
    private AuthService authService;

    public AbstractBox(String[] args) {
        this(new EditorConfiguration(args));
    }

    public AbstractBox(EditorConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    public EditorConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        super.put(o);
        return this;
    }

    public abstract void beforeStart();

    public Box start() {
        this.initConnector();
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    public abstract void afterStart();

    public abstract void beforeStop();

    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    public void stopServices() {
        AlexandriaHttpServerBuilder.instance().stop();
    }

    public abstract void afterStop();

    public void startServices() {
        this.initUI();
        this.initAgenda();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initCli();
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(AlexandriaUiBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    public boolean existsLibraryTemplate(String name) {
        return this.libraryLoaders.stream().anyMatch(l -> l.libraryTemplateEntryPointClass(name) != null);
    }

    protected abstract AuthService authService(URL var1);

    public AlexandriaScheduler scheduler() {
        return this.scheduler;
    }

    protected void beforeSetupEditorElementsUi(AlexandriaUiServer server) {
    }

    public void setupEditorElementsUi() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        this.authService = this.authService(AbstractBox.url(this.configuration().get("federation-url")));
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        AlexandriaHttpServerBuilder.setUI((boolean)true);
        AlexandriaHttpServerBuilder.addParameters((Object[])new Object[]{this.authService});
        this.pushService = this.owner != null && this.owner instanceof AlexandriaUiBox ? ((AlexandriaUiBox)this.owner).pushService() : new PushService();
        AlexandriaUiServer server = (AlexandriaUiServer)AlexandriaHttpServerBuilder.instance();
        this.beforeSetupEditorElementsUi(server);
        EditorElementsService.init(server, (EditorBox)this, this.pushService, new RouteDispatcher());
        UiElementsService.initDisplays((AlexandriaUiServer)server, (PushService)this.pushService);
    }

    private void initRestServices() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        QuassarArtifactoryApiService.setup(AlexandriaHttpServerBuilder.instance(), (EditorBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service quassar-artifactory-api: started at port " + this.configuration().get("port") + "!"));
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        QuassarApiService.setup(AlexandriaHttpServerBuilder.instance(), (EditorBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service quassar-api: started at port " + this.configuration().get("port") + "!"));
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
        this.initTranslatorService();
        this.setupEditorElementsUi();
        AlexandriaUiServer serverEditorElementsInstance = (AlexandriaUiServer)AlexandriaHttpServerBuilder.instance();
        serverEditorElementsInstance.start();
        io.intino.alexandria.logger.Logger.info((String)("UI EditorElements: started at port " + this.configuration().get("port") + "!"));
    }

    private void initTranslatorService() {
        this.translatorService = new TranslatorService();
        this.translatorService.addAll(I18n.dictionaries());
        this.translatorService.addAll(io.intino.alexandria.I18n.dictionaries());
    }

    protected void initConnector() {
    }

    protected void initTerminal() {
    }

    protected void initSentinels() {
        Sentinels.init(this.scheduler, this.configuration.home(), (EditorBox)this);
    }

    protected void initWorkflow() {
    }

    protected void initAgenda() {
    }

    protected void initCli() {
    }

    protected void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    public static URL url(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }
}

