/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractProjectModuleEntryViewer;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Model;
import java.util.Set;
import java.util.function.Consumer;

public class ProjectModuleEntryViewer
extends AbstractProjectModuleEntryViewer<EditorBox> {
    private Model model;
    private String project;
    private String module;
    private GavCoordinates language;
    private boolean selected;
    private Consumer<Boolean> selectListener;

    public ProjectModuleEntryViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void language(GavCoordinates language) {
        this.language = language;
    }

    public void project(String project) {
        this.project = project;
    }

    public void module(String module) {
        this.module = module;
    }

    public void selected(boolean value) {
        this.selected = value;
    }

    public void onSelect(Consumer<Boolean> listener) {
        this.selectListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.titleLink.onExecute(e -> this.open());
    }

    public void refresh() {
        super.refresh();
        this.bubble.formats(Set.of("bubble", this.model != null ? "bubbleFilled" : "bubbleNotFilled"));
        this.refreshLink();
        this.refreshText();
    }

    private void refreshLink() {
        this.titleLink.visible(!this.selected);
        if (!this.titleLink.isVisible()) {
            return;
        }
        this.titleLink.title(this.language.languageId());
    }

    private void refreshText() {
        this.titleText.visible(this.selected);
        if (!this.titleText.isVisible()) {
            return;
        }
        this.titleText.value(this.language.languageId());
    }

    private void open() {
        if (this.model == null) {
            this.model = ((EditorBox)this.box()).commands(ModelCommands.class).create(ModelHelper.proposeName(), "", this.language, this.username(), this.username());
            ((EditorBox)this.box()).commands(ModelCommands.class).saveQualifiedName(this.model, this.project, this.module, this.username());
        }
        ((TemplateNotifier)this.notifier).redirect(PathHelper.modelUrl(this.model, this.session()));
        this.selectListener.accept(true);
    }
}

