/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.datasources.CollaboratorsDatasource;
import io.quassar.editor.box.ui.displays.items.UserItem;
import io.quassar.editor.box.ui.displays.templates.AbstractCollaboratorsTemplate;
import io.quassar.editor.box.ui.displays.templates.CollaboratorItemTemplate;
import io.quassar.editor.model.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class CollaboratorsTemplate
extends AbstractCollaboratorsTemplate<EditorBox> {
    private String owner;
    private Set<String> collaboratorSet = new HashSet<String>();
    private Consumer<List<String>> changeListener;
    private boolean readonly = false;

    public CollaboratorsTemplate(EditorBox box) {
        super(box);
    }

    public void owner(String owner) {
        this.owner = owner;
    }

    public void collaborators(List<String> collaborators) {
        this.collaboratorSet = new HashSet<String>(collaborators);
    }

    public void readonly(boolean value) {
        this.readonly = value;
    }

    public void onChange(Consumer<List<String>> listener) {
        this.changeListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.invite.onExecute(e -> this.invitePeople());
        this.peopleField.valueProvider(element -> ((User)element).name());
        this.peopleField.peopleList.onAddItem(this::refresh);
    }

    public void refresh() {
        super.refresh();
        this.invite.readonly(this.readonly);
        this.peopleField.select(new Object[0]);
        this.peopleField.source((Datasource)new CollaboratorsDatasource((EditorBox)this.box(), this.session(), new ArrayList<String>(this.collaboratorSet)));
        this.ownerField.value(this.owner);
        this.collaborators.clear();
        this.collaboratorSet.forEach(u -> this.fill((String)u, (CollaboratorItemTemplate)this.collaborators.add()));
    }

    private void fill(String user, CollaboratorItemTemplate display) {
        display.user(user);
        display.onRemove(this::removeUser);
        display.refresh();
    }

    private void removeUser(String user) {
        this.collaboratorSet.remove(user);
        this.notifyChange();
        this.refresh();
    }

    private void invitePeople() {
        List people = !this.peopleField.selection().isEmpty() ? List.of(((User)this.peopleField.selection().getFirst()).name()) : Collections.emptyList();
        this.collaboratorSet.addAll(people);
        this.peopleField.select(new Object[0]);
        this.notifyChange();
        this.refresh();
    }

    private void notifyChange() {
        this.changeListener.accept(new ArrayList<String>(this.collaboratorSet));
    }

    private void refresh(AddCollectionItemEvent event) {
        this.refresh((User)event.item(), (UserItem)event.component());
    }

    private void refresh(User user, UserItem display) {
        display.fullName.value(user.fullname() != null && !user.name().equals(user.fullname()) ? user.fullname() : user.name());
        display.email.value(user.fullname() != null && !user.name().equals(user.fullname()) ? user.name() : null);
    }
}

