/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.languages;

import io.intino.alexandria.logger.Logger;
import io.quassar.archetype.Archetype;
import io.quassar.editor.box.util.ArtifactoryHelper;
import io.quassar.editor.box.util.SubjectHelper;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageExecution;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import systems.intino.datamarts.subjectstore.SubjectStore;
import systems.intino.datamarts.subjectstore.model.Subject;

public class LanguageManager {
    private final Archetype archetype;
    private final SubjectStore subjectStore;
    private final Function<String, Model> modelProvider;

    public LanguageManager(Archetype archetype, SubjectStore store, Function<String, Model> modelProvider) {
        this.archetype = archetype;
        this.subjectStore = store;
        this.modelProvider = modelProvider;
    }

    public List<Language> visibleLanguages(String owner) {
        HashSet<Language> result = new HashSet<Language>(this.foundationalLanguages());
        result.addAll(this.privateLanguages(owner));
        result.addAll(this.licensedLanguages(owner));
        return result.stream().filter(l -> !l.name().equals("metta")).distinct().toList();
    }

    public List<Language> foundationalLanguages() {
        return this.languages().stream().filter(Language::isFoundational).toList();
    }

    public List<Language> privateLanguages(String owner) {
        return this.languages().stream().filter(l -> this.hasAccess((Language)l, owner)).toList();
    }

    public List<Language> licensedLanguages(String owner) {
        if (owner == null) {
            return Collections.emptyList();
        }
        HashSet<String> collections = new HashSet<String>(this.subjectStore.query().isType("license").where("user").equals(owner).collect().stream().map(s -> s.parent().name()).distinct().toList());
        collections.addAll(this.subjectStore.query().isType("collection").where("owner").equals(owner).collect().stream().map(Subject::name).toList());
        collections.addAll(this.subjectStore.query().isType("collection").where("collaborator").equals(owner).collect().stream().map(Subject::name).toList());
        if (collections.isEmpty()) {
            return Collections.emptyList();
        }
        return this.subjectStore.query().isType("dsl").where("collection").satisfy(v -> collections.stream().anyMatch(v::equals)).stream().map(this::get).toList();
    }

    public List<Language> languages() {
        return this.subjectStore.query().isType("dsl").isRoot().collect().stream().map(this::get).toList();
    }

    public List<Language> languages(Collection collection) {
        return this.subjectStore.query().isType("dsl").isRoot().where("collection").equals(collection.name()).collect().stream().map(this::get).toList();
    }

    public Language create(Collection collection, String name, Model metamodel, Language.Level level, String title, String description) {
        Language language = new Language(this.subjectStore.create(SubjectHelper.languagePath(Language.key(collection.id(), name))));
        language.collection(collection.id());
        language.name(name.toLowerCase());
        language.level(level);
        language.title(title);
        language.description(description);
        language.createDate(Instant.now());
        if (metamodel == null) {
            return language;
        }
        language.metamodel(metamodel.id());
        language.parent(metamodel.language());
        return language;
    }

    public LanguageRelease createRelease(Language language, String version) {
        LanguageExecution lastExecution = language.lastRelease() != null ? language.lastRelease().execution() : null;
        LanguageRelease release = new LanguageRelease(this.subjectStore.create(SubjectHelper.pathOf(language, version)));
        release.version(version);
        if (lastExecution != null) {
            this.copyExecution(language, release, lastExecution);
        } else {
            this.createExecution(language, release, null, LanguageExecution.Type.None);
        }
        return release;
    }

    public void renameRelease(Language language, LanguageRelease release, String newVersion) {
        LanguageRelease newRelease = new LanguageRelease(this.subjectStore.open(SubjectHelper.pathOf(language, release.version())).rename(newVersion));
        newRelease.version(newVersion);
    }

    public void removeRelease(Language language, LanguageRelease release) {
        try {
            File directory;
            Subject subject = this.subjectStore.create(SubjectHelper.pathOf(language, release.version()));
            if (subject != null) {
                subject.drop();
            }
            if (!(directory = this.archetype.languages().release(language.key(), release.version())).exists()) {
                return;
            }
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public LanguageExecution createExecution(Language language, LanguageRelease release, String name, LanguageExecution.Type type) {
        LanguageExecution result = new LanguageExecution(this.subjectStore.create(SubjectHelper.executionPathOf(language, release)));
        result.name(name);
        result.type(type);
        return result;
    }

    public File loadLogo(Language language) {
        return this.archetype.languages().logo(language.key());
    }

    public void saveLogo(Language language, File logo) {
        try {
            File current = this.archetype.languages().logo(language.key());
            if (logo == null && current.exists()) {
                current.delete();
                return;
            }
            if (logo != null && logo.getAbsolutePath().equals(current.getAbsolutePath())) {
                return;
            }
            if (logo != null) {
                if (current.exists()) {
                    current.delete();
                }
                Files.move(logo.toPath(), current.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void saveDsl(Language language, String release, File dsl) {
        this.copy(dsl, this.archetype.languages().releaseDslJar(language.key(), release));
        LanguageRelease languageRelease = language.release(release);
        ArtifactoryHelper.cleanDslCache(language, languageRelease, this.archetype.languages());
    }

    public void saveDslManifest(Language language, String release, File dsl) {
        this.copy(dsl, this.archetype.languages().releaseDslManifest(language.key(), release));
        LanguageRelease languageRelease = language.release(release);
        ArtifactoryHelper.cleanDslCache(language, languageRelease, this.archetype.languages());
    }

    public File loadDsl(GavCoordinates coordinates) {
        return this.loadDsl(coordinates.languageId(), coordinates.version());
    }

    public File loadDsl(Language language, LanguageRelease release) {
        return this.loadDsl(language.key(), release.version());
    }

    public File loadDslDigest(Language language, LanguageRelease release) {
        File digest = this.archetype.languages().releaseDslJarDigest(language.key(), release.version());
        if (!digest.exists()) {
            ArtifactoryHelper.prepareDsl(language, release, this.archetype.languages());
        }
        return digest.exists() ? digest : null;
    }

    public File loadDslManifest(Language language, LanguageRelease release) {
        File manifest = this.archetype.languages().releaseDslManifest(language.key(), release.version());
        if (!manifest.exists()) {
            ArtifactoryHelper.prepareDsl(language, release, this.archetype.languages());
        }
        return manifest.exists() ? manifest : null;
    }

    public File loadDslManifestDigest(Language language, LanguageRelease release) {
        File manifest = this.archetype.languages().releaseDslManifestDigest(language.key(), release.version());
        if (!manifest.exists()) {
            ArtifactoryHelper.prepareDsl(language, release, this.archetype.languages());
        }
        return manifest.exists() ? manifest : null;
    }

    public File loadGraph(Language language, LanguageRelease release) {
        if (release == null) {
            return null;
        }
        File file = this.archetype.languages().releaseGraph(language.key(), release.version());
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public void saveGraph(Language language, String release, File graph) {
        this.copy(graph, this.archetype.languages().releaseGraph(language.key(), release));
    }

    public File loadParser(Language language, LanguageRelease release, String name) {
        if (release == null) {
            return null;
        }
        File result = this.archetype.languages().releaseParserJar(language.key(), release.version(), name);
        if (!result.exists()) {
            ArtifactoryHelper.prepareParserDependency(language, release, name, this.archetype.languages());
        }
        return result.exists() ? result : null;
    }

    public File loadParserDigest(Language language, LanguageRelease release, String name) {
        File manifest = this.archetype.languages().releaseParserJarDigest(language.key(), release.version(), name);
        if (!manifest.exists()) {
            ArtifactoryHelper.prepareParserDependency(language, release, name, this.archetype.languages());
        }
        return manifest.exists() ? manifest : null;
    }

    public File loadParserManifest(Language language, LanguageRelease release, String name) {
        File manifest = this.archetype.languages().releaseParserManifest(language.key(), release.version(), name);
        if (!manifest.exists()) {
            ArtifactoryHelper.prepareParserDependency(language, release, name, this.archetype.languages());
        }
        return manifest.exists() ? manifest : null;
    }

    public File loadParserManifestDigest(Language language, LanguageRelease release, String name) {
        File manifest = this.archetype.languages().releaseParserManifestDigest(language.key(), release.version(), name);
        if (!manifest.exists()) {
            ArtifactoryHelper.prepareParserDependency(language, release, name, this.archetype.languages());
        }
        return manifest.exists() ? manifest : null;
    }

    public List<File> loadParsers(Language language, LanguageRelease release) {
        if (release == null) {
            return null;
        }
        return this.archetype.languages().releaseParsers(language.key(), release.version());
    }

    public void saveParsers(Language language, String release, List<File> parsers) {
        LanguageRelease languageRelease = language.release(release);
        this.copy(parsers, this.archetype.languages().releaseParsersDir(language.key(), release));
        parsers.forEach(p -> ArtifactoryHelper.cleanParserDependencyCache(language, languageRelease, p.getName(), this.archetype.languages()));
    }

    public String loadHelp(Language language, String version) {
        return this.loadHelp(language.key(), version);
    }

    public String loadHelp(Language language, LanguageRelease release) {
        return this.loadHelp(language.key(), release.version());
    }

    public String loadHelp(GavCoordinates gav) {
        return this.loadHelp(gav.languageId(), gav.version());
    }

    public void saveHelp(Language language, String release, String content) {
        try {
            if (content == null) {
                return;
            }
            File destiny = this.archetype.languages().releaseHelp(language.key(), release);
            Files.writeString(destiny.toPath(), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public boolean exists(Model model) {
        return this.get(model) != null;
    }

    public boolean exists(String collection, String language) {
        if (language == null) {
            return false;
        }
        if (new File(this.archetype.languages().root(), language).exists()) {
            return true;
        }
        if (new File(this.archetype.languages().root(), Language.key(collection, language)).exists()) {
            return true;
        }
        return !this.subjectStore.query().isType("dsl").where("collection").equals(collection).where("name").equals(language).collect().isEmpty();
    }

    public Language getDefault() {
        return this.languages().stream().findFirst().orElse(null);
    }

    public Language getWithMetamodel(Model model) {
        List result = this.subjectStore.query().isType("dsl").where("metamodel").equals(SubjectHelper.modelPath(model.id())).collect();
        if (result.isEmpty()) {
            result = this.subjectStore.query().isType("dsl").where("metamodel").equals(model.id()).collect();
        }
        return !result.isEmpty() ? this.get((Subject)result.getFirst()) : null;
    }

    public Language get(Model model) {
        return this.get(Model.language(this.subjectStore.open(SubjectHelper.pathOf(model))));
    }

    public Language get(GavCoordinates gav) {
        Language language = this.get(Language.key(gav.groupId(), gav.artifactId()));
        if (language == null) {
            language = this.get(gav.artifactId());
        }
        return language;
    }

    public Language get(String id) {
        Language language = this.get(this.subjectStore.open(SubjectHelper.languagePath(id)));
        if (language == null) {
            language = this.get((Subject)this.subjectStore.query().isType("dsl").where("collection").equals(Language.collectionFrom(id)).where("name").equals(Language.nameFrom(id)).collect().stream().findFirst().orElse(null));
        }
        return language;
    }

    public void rename(Language language, String newId) {
        language.collection(Language.collectionFrom(newId));
        language.name(Language.nameFrom(newId));
        this.subjectStore.open(SubjectHelper.pathOf(language)).rename(newId);
    }

    public void remove(Language language) {
        try {
            File rootDir = this.archetype.languages().get(language.key());
            if (!rootDir.exists()) {
                return;
            }
            language.releases().forEach(r -> this.subjectStore.open(SubjectHelper.pathOf(language, r)).drop());
            this.subjectStore.open(SubjectHelper.pathOf(language)).drop();
            FileUtils.deleteDirectory((File)rootDir);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public boolean hasAccess(Language language, String user) {
        String owner;
        if (language.isPublic()) {
            return true;
        }
        if (user == null) {
            return false;
        }
        Model metamodel = language.metamodel() != null ? this.modelProvider.apply(language.metamodel()) : null;
        String string = owner = metamodel != null ? metamodel.owner() : null;
        if ((owner == null || owner.equals("quassar")) && language.isFoundational()) {
            return true;
        }
        if (owner != null && owner.equals(user)) {
            return true;
        }
        if (metamodel == null) {
            return false;
        }
        return metamodel.collaborators().stream().anyMatch(c -> c.equals(user));
    }

    public String owner(Language language) {
        String metamodel = language.metamodel();
        return metamodel != null ? Model.owner(this.subjectStore.open(SubjectHelper.modelPath(metamodel))) : null;
    }

    private boolean matches(String regex, String user) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(user).matches();
    }

    private String loadHelp(String language, String release) {
        try {
            if (release == null) {
                return null;
            }
            File helpFile = this.archetype.languages().releaseHelp(language, release);
            if (!helpFile.exists()) {
                return null;
            }
            return Files.readString(helpFile.toPath());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private Language get(Subject subject) {
        if (subject == null || subject.isNull()) {
            return null;
        }
        return new Language(subject);
    }

    private void copy(File source, File destiny) {
        try {
            if (source == null) {
                return;
            }
            if (destiny.exists()) {
                destiny.delete();
            }
            Files.copy(source.toPath(), destiny.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void copy(List<File> source, File destiny) {
        try {
            if (!destiny.exists()) {
                destiny.mkdirs();
            }
            for (File file : source) {
                Files.copy(file.toPath(), new File(destiny, file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private File loadDsl(String language, String release) {
        if (release == null) {
            return null;
        }
        File file = this.archetype.languages().releaseDslJar(language, release);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private void copyExecution(Language language, LanguageRelease release, LanguageExecution execution) {
        LanguageExecution result = this.createExecution(language, release, execution.name(), execution.type());
        result.content(execution.content(LanguageExecution.Type.Local));
        result.content(execution.content(LanguageExecution.Type.Remote));
    }
}

