/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.datasources.ModelsDatasource;
import io.quassar.editor.box.ui.displays.templates.AbstractModelsDialog;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.SessionHelper;
import io.quassar.editor.model.Language;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class ModelsDialog
extends AbstractModelsDialog<EditorBox> {
    private Consumer<Boolean> addModelListener;
    private Language language;
    private Function<Language, Long> countItemsProvider = null;
    private Collection<?, ?> collection;

    public ModelsDialog(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void countItemsProvider(Function<Language, Long> provider) {
        this.countItemsProvider = provider;
    }

    @Override
    public void init() {
        super.init();
        this.addModelTrigger.onExecute(e -> this.notifyAddModel());
        this.mostRecentLink.onExecute(e -> this.updateSorting(ModelsDatasource.Sorting.MostRecent));
        this.lastModifiedLink.onExecute(e -> this.updateSorting(ModelsDatasource.Sorting.LastModified));
        this.licenseDialog.onRenew(e -> this.notifyAddModel());
    }

    public void refresh() {
        super.refresh();
        this.refreshSorting(SessionHelper.modelsSorting(this.session()));
        this.searchBox.condition("");
        this.addModelTrigger.visible(this.addModelListener != null && PermissionsHelper.canAddModel(this.language, this.session(), (EditorBox)this.box()));
        if (this.addModelTrigger.isVisible()) {
            this.addModelTrigger.readonly(!PermissionsHelper.hasValidLicense(this.language, this.session(), (EditorBox)this.box()));
        }
        this.catalogOperations.visible(this.countItemsProvider.apply(this.language) > DisplayHelper.MinItemsCount);
    }

    public void onAddModel(Consumer<Boolean> listener) {
        this.addModelListener = listener;
    }

    public void bindTo(Collection<?, ?> collection) {
        this.collection = collection;
        this.searchBox.bindTo(new Collection[]{collection});
    }

    private void notifyAddModel() {
        if (!PermissionsHelper.hasValidLicense(this.language, this.session(), (EditorBox)this.box())) {
            this.openLicenseDialog();
            return;
        }
        this.addModelListener.accept(true);
    }

    private void openLicenseDialog() {
        this.licenseDialog.license(((EditorBox)this.box()).collectionManager().anyLicense(this.language.collection(), this.username()));
        this.licenseDialog.open();
    }

    private void updateSorting(ModelsDatasource.Sorting sorting) {
        SessionHelper.registerModelsSorting(this.session(), sorting);
        this.collection.sortings(List.of(sorting.name()));
        this.refreshSorting(sorting);
    }

    private void refreshSorting(ModelsDatasource.Sorting sorting) {
        this.mostRecentLink.visible(sorting != ModelsDatasource.Sorting.MostRecent);
        this.mostRecentText.visible(sorting == ModelsDatasource.Sorting.MostRecent);
        this.lastModifiedLink.visible(sorting != ModelsDatasource.Sorting.LastModified);
        this.lastModifiedText.visible(sorting == ModelsDatasource.Sorting.LastModified);
    }
}

