/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Actionable;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.ui.displays.templates.AbstractModelHeaderTemplate;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.FilePosition;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageExecution;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class ModelHeaderTemplate
extends AbstractModelHeaderTemplate<EditorBox> {
    private Model model;
    private String release;
    private ModelView view;
    private LanguageTab tab;
    private File file;
    private FilePosition filePosition;
    private Function<Model, Boolean> checkListener;
    private Consumer<Model> openSettingsListener;
    private Consumer<Model> cloneListener;
    private BiConsumer<Model, Command.CommandResult> deployListener;
    private Step step = Step.Edit;
    private boolean checked = false;
    private static final String NoExecutionName = "4. inspect";
    private static final String DefaultExecutionName = "4. execute";

    public ModelHeaderTemplate(EditorBox box) {
        super(box);
    }

    public Model model() {
        return this.model;
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String value) {
        this.release = value;
    }

    public void view(ModelView value) {
        this.view = value;
    }

    public void tab(LanguageTab tab) {
        this.tab = tab;
    }

    public void file(File value) {
        this.file = value;
    }

    public void position(FilePosition position) {
        this.filePosition = position;
    }

    public void onOpenSettings(Consumer<Model> listener) {
        this.openSettingsListener = listener;
    }

    public void onCheck(Function<Model, Boolean> listener) {
        this.checkListener = listener;
    }

    public void onClone(Consumer<Model> listener) {
        this.cloneListener = listener;
    }

    public void onDeploy(BiConsumer<Model, Command.CommandResult> listener) {
        this.deployListener = listener;
    }

    public void checked(boolean value) {
        this.updateStep(value ? Step.Check : Step.Edit);
    }

    @Override
    public void init() {
        super.init();
        this.releaseSelector.onExecute(e -> this.openRelease(e.option()));
        this.settingsTrigger.onExecute(e -> this.openSettingsListener.accept(this.model));
        this.editTrigger.onExecute(e -> this.edit());
        this.checkTrigger.onExecute(e -> this.check());
        this.commitTrigger.onExecute(e -> this.commit());
        this.downloadTrigger.onExecute(e -> this.openDownloadDialog());
        this.forgeTrigger.onOpen(e -> this.updateStep(Step.Forge));
        this.cloneTrigger.onExecute(e -> this.cloneModel());
        this.commitModelDialog.onCommit((m, v) -> this.openRelease((String)v));
        this.commitModelDialog.onCommitFailure((m, v) -> this.deployListener.accept((Model)m, (Command.CommandResult)v));
        this.commitModelDialog.onCreateRelease((m, v) -> this.deployListener.accept((Model)m, (Command.CommandResult)v));
        this.executionTrigger.onExecute(e -> this.openExecutionLauncher());
    }

    public void refresh() {
        super.refresh();
        this.contentBlock.visible(this.model != null);
        if (!this.contentBlock.isVisible()) {
            return;
        }
        Language language = ((EditorBox)this.box()).languageManager().get(this.model);
        this.step = !"draft".equals(this.release) ? Step.Commit : (this.checked ? Step.Check : Step.Edit);
        this.checked = false;
        this.titleViewer.model(this.model);
        this.titleViewer.refresh();
        this.refreshReleaseSelector();
        this.refreshToolbar();
        this.refreshLanguageTrigger(language);
        this.refreshCloseTrigger(language);
    }

    private void refreshLanguageTrigger(Language language) {
        this.languageTrigger.visible(language != null && !this.model.isTemplate() && !this.model.isExample());
        if (!this.languageTrigger.isVisible() || language == null) {
            return;
        }
        this.languageTrigger.title(this.translate("Goto %s").formatted(LanguageHelper.title(this.model.language())));
        this.languageTrigger.address(path -> PathHelper.languagePath(path, language));
    }

    private void refreshCloseTrigger(Language language) {
        this.closeTrigger.visible(language != null && (this.model.isTemplate() || this.model.isExample()));
        if (!this.closeTrigger.isVisible()) {
            return;
        }
        this.closeTrigger.title(this.translate(this.model.isTemplate() ? "Template" : "Example"));
    }

    private void refreshToolbar() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model);
        Language forgedLanguage = ((EditorBox)this.box()).languageManager().getWithMetamodel(this.model);
        boolean hasValidLicense = PermissionsHelper.hasValidLicense(this.model.language(), this.session(), (EditorBox)this.box());
        this.settingsTrigger.visible(PermissionsHelper.canEditSettings(this.model, this.release, this.session(), (EditorBox)this.box()) && hasValidLicense);
        this.editTrigger.highlight(this.step == Step.Edit ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.editTrigger.visible(!this.model.isTemplate() && !this.model.isExample() && hasValidLicense);
        this.checkTrigger.readonly(!PermissionsHelper.canCheck(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.checkTrigger.visible(PermissionsHelper.isOwnerOrCollaborator(this.model, this.session(), (EditorBox)this.box()) && hasValidLicense);
        this.checkTrigger.highlight(this.step == Step.Check && !this.model.isTemplate() && !this.model.isExample() ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.checkTrigger.title(this.model.isTemplate() || this.model.isExample() ? this.translate("Check") : this.translate("2. Check"));
        this.commitTrigger.visible(!this.model.isTemplate() && !this.model.isExample() && hasValidLicense);
        this.commitTrigger.readonly(this.step == Step.Edit || !PermissionsHelper.canCommit(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.commitTrigger.highlight(this.step == Step.Commit ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.forgeTrigger.visible(!this.model.isTemplate() && this.release != null && this.model.language().artifactId().equals("metta"));
        this.forgeTrigger.readonly(this.step == Step.Edit || this.release == null || this.release.equals("draft") || !PermissionsHelper.canForge(this.model, language, this.release, this.session(), (EditorBox)this.box()));
        this.forgeTrigger.highlight(this.step == Step.Forge ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        if (this.forgeTrigger.isVisible()) {
            this.forgeTrigger.site(PathHelper.forgeUrl(this.model, this.release, this.session()));
        }
        this.executionTrigger.visible(!this.model.isTemplate() && !this.model.isExample() && ModelHelper.isM1Release(this.model, this.release) && this.executionDefined());
        if (this.executionTrigger.isVisible()) {
            this.executionTrigger.title(this.executionName());
        }
        this.executionTrigger.readonly(this.step == Step.Edit || this.release == null || this.release.equals("draft") || !PermissionsHelper.canLaunchExecution(this.model, language, this.release, this.session(), (EditorBox)this.box()));
        this.executionTrigger.highlight(this.step == Step.Forge ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.downloadTrigger.visible(ModelHelper.validReleaseName(this.release, arg_0 -> ((ModelHeaderTemplate)this).translate(arg_0)) && !this.executionDefined() && !this.model.language().artifactId().equals("metta"));
        this.downloadTrigger.highlight(this.step == Step.Forge ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.cloneTrigger.visible(this.session().user() != null && this.model.isExample() && !PermissionsHelper.isOwnerOrCollaborator(this.model, this.session(), (EditorBox)this.box()));
        this.noLanguageDefinedBlock.visible(!this.model.isTemplate() && this.model.language().artifactId().equals("metta") && (forgedLanguage == null || this.model.releases().isEmpty()));
        this.languageDefinedBlock.visible(forgedLanguage != null && !this.model.isTemplate() && this.model.language().artifactId().equals("metta") && !this.model.releases().isEmpty());
        if (this.languageDefinedBlock.isVisible() && forgedLanguage != null) {
            this.gotoForgeTrigger.site(PathHelper.forgeUrl(this.model, this.release, this.session()));
            this.gotoForgeTrigger.title("%s DSL".formatted(forgedLanguage.name()));
        }
        this.releaseSelector.visible(!this.model.isTemplate() && !this.model.isExample() && !this.model.releases().isEmpty());
        this.languageToolbar.model(this.model);
        this.languageToolbar.release(this.release);
        this.languageToolbar.view(this.view);
        this.languageToolbar.tab(this.tab);
        this.languageToolbar.file(this.file);
        this.languageToolbar.filePosition(this.filePosition);
        this.languageToolbar.refresh();
    }

    private void refreshReleaseSelector() {
        this.releaseSelector.visible(!this.model.isTemplate());
        if (!this.releaseSelector.isVisible()) {
            return;
        }
        this.releaseSelector.clear();
        SequencedCollection options = new ArrayList<String>(((EditorBox)this.box()).modelManager().releases(this.model)).reversed();
        this.releaseSelector.options((List)options);
        this.releaseSelector.option(this.release != null ? this.release : null);
    }

    private void openRelease(String release) {
        String releaseName = release.equals(this.translate("draft")) ? "draft" : release;
        ((TemplateNotifier)this.notifier).dispatch(PathHelper.modelPath(this.model, releaseName, this.tab, this.view, this.file));
    }

    private void edit() {
        this.openRelease("draft");
        this.refreshToolbar();
    }

    private void check() {
        if (!"draft".equals(this.release)) {
            this.openRelease("draft");
            this.checked = true;
        }
        this.updateStep(this.checkListener.apply(this.model) != false ? Step.Check : Step.Edit);
    }

    private void commit() {
        this.commitModelDialog.model(this.model);
        this.commitModelDialog.open();
        this.updateStep(Step.Commit);
    }

    private void cloneModel() {
        this.cloneListener.accept(this.model);
    }

    private void openDownloadDialog() {
        this.updateStep(Step.Forge);
        this.downloadModelDialog.model(this.model);
        this.downloadModelDialog.release(this.release);
        this.downloadModelDialog.open();
    }

    private void openExecutionLauncher() {
        this.executionLauncher.model(this.model);
        this.executionLauncher.release(this.release);
        this.executionLauncher.launch();
        this.updateStep(Step.Forge);
    }

    private String executionName() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model.language());
        if (language == null) {
            return this.translate(DefaultExecutionName);
        }
        LanguageRelease languageRelease = language.release(this.model.language().version());
        if (languageRelease == null) {
            return this.translate(DefaultExecutionName);
        }
        if (languageRelease.execution() == null || languageRelease.execution().type() == LanguageExecution.Type.None) {
            return this.translate(NoExecutionName);
        }
        String name = languageRelease.execution().name();
        return this.translate((String)(!name.isEmpty() ? "4. " + name : DefaultExecutionName));
    }

    private boolean executionDefined() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model.language());
        if (language == null) {
            return false;
        }
        LanguageRelease languageRelease = language.release(this.model.language().version());
        if (languageRelease == null) {
            return false;
        }
        return languageRelease.execution() != null && languageRelease.execution().type() != LanguageExecution.Type.None && !languageRelease.execution().content().isEmpty();
    }

    private void updateStep(Step step) {
        this.step = step;
        this.refreshToolbar();
    }

    private static enum Step {
        Edit,
        Check,
        Commit,
        Forge;

    }
}

