/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.BlockConditional;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.services.push.User;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.commands.UserCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractHomeTemplate;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.util.Arrays;

public class HomeTemplate
extends AbstractHomeTemplate<EditorBox> {
    private Page current;
    private Language language;
    private String release;
    private Model model;

    public HomeTemplate(EditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.registerUserIfNeeded();
    }

    public void createModel(String languageId) {
        Language language = ((EditorBox)this.box()).languageManager().get(languageId);
        if (language == null) {
            Logger.warn((String)"Trying to create model from not recognized language");
            ((TemplateNotifier)this.notifier).redirect(PathHelper.languageUrl(languageId, this.session()));
            return;
        }
        if (!PermissionsHelper.isEnterprise(language, this.session(), (EditorBox)this.box())) {
            Logger.warn((String)"You don't hava an enterprise subscription for language %s".formatted(language.name()));
            ((TemplateNotifier)this.notifier).redirect(PathHelper.loginUrl(this.session()));
            return;
        }
        if (!PermissionsHelper.canAddModel(language, this.session(), (EditorBox)this.box())) {
            this.session().add("callback", this.session().browser().requestUrl());
            ((TemplateNotifier)this.notifier).redirect(PathHelper.loginUrl(this.session()));
            return;
        }
        String name = ModelHelper.proposeName();
        if (language.lastRelease() == null) {
            Logger.warn((String)("Trying to create model from language " + language.name() + " with no releases"));
            return;
        }
        Model model = ((EditorBox)this.box()).commands(ModelCommands.class).create(name, name, "", new GavCoordinates(language.collection(), language.name(), language.lastRelease().version()), this.username(), this.username());
        ((TemplateNotifier)this.notifier).redirect(PathHelper.modelUrl(model, this.session()));
    }

    public void openHome(String dialog) {
        this.openLanding(dialog);
    }

    public void openLanding(String dialog) {
        this.set((String)null, null, null);
        this.openPage(Page.Landing);
        if (this.landingPage.landingStamp != null) {
            this.landingPage.landingStamp.open(dialog);
        }
    }

    public void openAbout() {
        this.set((String)null, null, null);
        this.openPage(Page.About);
        if (this.aboutPage.aboutStamp != null) {
            this.aboutPage.aboutStamp.open();
        }
    }

    public void openCollection(String collection) {
        this.openPage(Page.Collection);
        if (this.collectionPage.collectionStamp == null) {
            return;
        }
        this.collectionPage.collectionStamp.open(collection);
    }

    public void openLanguage(String language, String tab) {
        boolean openTab = this.current != null && this.current == Page.Language;
        this.set(language, null, null);
        this.openPage(Page.Language);
        if (this.languagePage.languageStamp == null) {
            return;
        }
        if (openTab) {
            this.languagePage.languageStamp.openTab(tab);
        } else {
            this.languagePage.languageStamp.open(language, tab);
        }
    }

    public void openModel(String model, String release, String tab, String view, String file, String position) {
        Model modelInstance = ((EditorBox)this.box()).modelManager().get(model);
        Language language = modelInstance != null ? ((EditorBox)this.box()).languageManager().get(modelInstance) : null;
        this.set(language, release, modelInstance);
        this.openPage(Page.Model);
        if (this.modelPage.modelStamp != null) {
            this.modelPage.modelStamp.open(model, release, tab, view, file, position);
        }
    }

    public void openStartingModel(String model) {
        this.set(null, null, model);
        this.openPage(Page.Model);
        if (this.modelPage.modelStamp != null) {
            this.modelPage.modelStamp.openStarting(model);
        }
    }

    public void openTemplate(String languageKey, String version) {
        Language language = ((EditorBox)this.box()).languageManager().get(languageKey);
        LanguageRelease release = language.release(version);
        this.openModel(release.template(), release.version(), null, null, null, null);
    }

    public void openHelp(String language, String version) {
        this.set(language, version, null);
        this.openPage(Page.Language);
        if (this.languagePage.languageStamp != null) {
            this.languagePage.languageStamp.openHelp(language, version);
        }
    }

    public void open(String model, String release, String view) {
        this.set(null, release, view);
        this.openPage(Page.Forge);
        if (this.forgePage.forgeStamp != null) {
            this.forgePage.forgeStamp.open(model, release, view);
        }
    }

    private boolean openPage(Page page) {
        this.refreshHeader();
        if (this.current == page) {
            return true;
        }
        this.loading.visible(false);
        this.hidePages();
        this.blockOf(page).show();
        this.current = page;
        return true;
    }

    private void refreshHeader() {
        this.header.language(this.language);
        this.header.release(this.release);
        this.header.model(this.model);
        this.header.refresh();
    }

    private void hidePages() {
        if (this.landingPage.isVisible()) {
            this.landingPage.hide();
        }
        if (this.aboutPage.isVisible()) {
            this.aboutPage.hide();
        }
        if (this.collectionPage.isVisible()) {
            this.collectionPage.hide();
        }
        if (this.languagePage.isVisible()) {
            this.languagePage.hide();
        }
        if (this.modelPage.isVisible()) {
            this.modelPage.hide();
        }
        if (this.forgePage.isVisible()) {
            this.forgePage.hide();
        }
    }

    private BlockConditional<?, ?> blockOf(Page page) {
        if (page == Page.Landing) {
            return this.landingPage;
        }
        if (page == Page.About) {
            return this.aboutPage;
        }
        if (page == Page.Collection) {
            return this.collectionPage;
        }
        if (page == Page.Language) {
            return this.languagePage;
        }
        if (page == Page.Model) {
            return this.modelPage;
        }
        if (page == Page.Forge) {
            return this.forgePage;
        }
        return null;
    }

    private void set(String language, String release, String model) {
        Language languageInstance = language != null ? ((EditorBox)this.box()).languageManager().get(language) : null;
        Model modelInstance = model != null ? ((EditorBox)this.box()).modelManager().get(model) : null;
        this.set(languageInstance, release, modelInstance);
    }

    private void set(Language language, String release, Model model) {
        this.language = language;
        this.release = release;
        this.model = model;
    }

    private void registerUserIfNeeded() {
        User user = this.session().user();
        if (user == null) {
            return;
        }
        if (((EditorBox)this.box()).userManager().exists(user.username())) {
            return;
        }
        ((EditorBox)this.box()).commands(UserCommands.class).create(user.username(), this.username());
    }

    public static enum Page {
        Landing,
        About,
        Collection,
        Language,
        Model,
        Forge;


        public static Page from(String key) {
            return Arrays.stream(Page.values()).filter(v -> v.name().equalsIgnoreCase(key)).findFirst().orElse(null);
        }
    }
}

