/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.CollectionCommands;
import io.quassar.editor.box.commands.collection.AssignLicenseCommand;
import io.quassar.editor.box.ui.displays.templates.AbstractAddLicenseEditor;
import io.quassar.editor.box.util.LicenseGenerator;
import io.quassar.editor.model.License;
import java.util.function.Consumer;

public class AddLicenseEditor
extends AbstractAddLicenseEditor<EditorBox> {
    private Consumer<License> addListener;
    private AssignLicenseCommand.AssignResult assignResult;

    public AddLicenseEditor(EditorBox box) {
        super(box);
    }

    public void onAdd(Consumer<License> listener) {
        this.addListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.licenseField.onChange(e -> this.assign());
        this.licenseField.onEnterPress(e -> this.assign());
        this.failureDialog.onOpen(e -> this.refreshFailureDialog());
    }

    public void refresh() {
        super.refresh();
        this.licenseField.value(null);
    }

    private void assign() {
        String value = this.licenseField.value();
        if (value == null || value.length() < LicenseGenerator.size()) {
            return;
        }
        this.licenseField.value(null);
        this.assignResult = ((EditorBox)this.box()).commands(CollectionCommands.class).assignLicense(value, this.username());
        if (!this.assignResult.success()) {
            this.failureDialog.open();
        } else {
            this.addListener.accept(this.assignResult.license());
        }
    }

    private void refreshFailureDialog() {
        this.failureMessage.value(this.translate(this.assignResult.message()).formatted(this.assignResult.license() != null ? this.assignResult.license().collection().name() : ""));
    }
}

