/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.languages;

import io.intino.alexandria.logger.Logger;
import io.intino.tara.Language;
import io.quassar.editor.box.languages.LanguageArtifactory;
import io.quassar.editor.model.GavCoordinates;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class LanguageLoader {
    private final LanguageArtifactory artifactory;
    private final Map<GavCoordinates, Language> languageMap = new HashMap<GavCoordinates, Language>();

    public LanguageLoader(LanguageArtifactory artifactory) {
        this.artifactory = artifactory;
    }

    public Language get(GavCoordinates gav) throws IOException {
        if (this.languageMap.containsKey(gav)) {
            return this.languageMap.get(gav);
        }
        File jarFile = this.artifactory.retrieve(gav);
        Language language = this.load(gav, jarFile);
        this.languageMap.put(gav, language);
        return language;
    }

    public void remove(GavCoordinates gav) {
        this.languageMap.remove(gav);
    }

    private Language load(GavCoordinates gav, File jar) throws IOException {
        try {
            ClassLoader classLoader = LanguageLoader.createClassLoader(jar);
            if (classLoader == null) {
                return null;
            }
            Class<?> cls = classLoader.loadClass(this.artifactory.mainClass(gav));
            return (Language)cls.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Logger.error((Throwable)e);
            throw new IOException("Impossible to load language: " + e.getMessage(), e);
        }
    }

    private static ClassLoader createClassLoader(File jar) {
        try {
            return new URLClassLoader(new URL[]{jar.toURI().toURL()}, Language.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String firstUpperCase(String value) {
        return value.isEmpty() ? "" : value.substring(0, 1).toUpperCase() + value.substring(1);
    }
}

