/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class ShortIdGenerator {
    private static final SecureRandom Random = new SecureRandom();
    private static final char[] Base = "ABCDEFGHIJKLMNOPQRSTUVWXYZ-abcdefghijklmnopqrstuvwxyz~0123456789".toCharArray();
    private static final long EpochSeconds = LocalDateTime.of(2025, 1, 1, 0, 0).toEpochSecond(ZoneOffset.UTC);
    private static final int[] order = new int[]{6, 3, 0, 1, 7, 2, 4, 5};

    public static String generate() {
        return ShortIdGenerator.generate(ShortIdGenerator.value());
    }

    private static String generate(long value) {
        char[] chars = new char[8];
        for (int i = 7; i >= 0; --i) {
            chars[i] = Base[(int)(value & 0x3FL)];
            value >>>= 6;
        }
        return ShortIdGenerator.mix(chars);
    }

    private static String mix(char[] chars) {
        char[] result = new char[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = chars[order[i]];
        }
        return new String(result);
    }

    private static long value() {
        return ShortIdGenerator.seconds() << 18 | ShortIdGenerator.random();
    }

    private static long random() {
        return Random.nextInt(262144);
    }

    private static long seconds() {
        return Instant.now().getEpochSecond() - EpochSeconds;
    }
}

